vm="APP-DC01";
id="101022813";

qm guest cmd $id get-fsinfo
qm guest cmd $id get-host-name
qm guest cmd $id get-osinfo
qm guest cmd $id get-time
qm guest cmd $id get-timezone
qm guest cmd $id get-users
qm guest cmd $id info
qm guest cmd $id network-get-interfaces


qm list | awk '{print $1}' | sed 1d | xargs -I $id qm guest cmd $id network-get-interfaces


getFqdn () { fqdn=`qm guest exec $1 powershell -- '[System.Net.Dns]::GetHostByName($env:computerName).HostName' | jq ' to_entries | sort | .[2] | .value' | tr -d '"' | rev | cut -c5- | rev ;` ; echo $1:$fqdn ;  }


qm guest cmd $id get-host-name          | jq ' to_entries | sort | .[0] | .value' | tr -d '"';
qm guest cmd $id get-osinfo             | jq ' to_entries | sort | .[5] | .value' | tr -d '"';
qm guest cmd $id get-time               | jq
qm guest cmd $id get-timezone           | jq ' to_entries | sort | .[1] | .value' | tr -d '"';
qm guest cmd $id get-users              | jq
qm guest cmd $id network-get-interfaces | jq ' to_entries | sort | .[0] | .value' | tr -d '"';
qm guest cmd $id network-get-interfaces | jq ' to_entries | sort | .[0] | .value' | tr -d '"' | jq 'to_entries | sort | .[1] | .value';
qm guest cmd $id network-get-interfaces | jq ' to_entries | sort | .[0] | .value' | tr -d '"' 

qm guest cmd $id get-host-name | jq ' to_entries | sort | ip-addresses.ip-address[0] | .value' | tr -d '"' | rev | cut -c5- | rev ;


qm guest cmd $id network-get-interfaces | jq -r '.[] | to_entries[] | [.key,.value]'
qm guest cmd $id network-get-interfaces | jq -r '.[.. | .ip-addresses?[0] | select(.) ]'

qm guest cmd $id network-get-interfaces | jq -r '.[] | .ip-addresses?[0] | .value'


###############################################################

   conf=$configs/$id.conf
sed -i '/autostart:/d' $conf
echo 'boot: order=sata0'>>$conf
qm rescan --vm  $id

key=sld;id=172221211;conf=$configs/$id.conf;
autostart=$(qm config $id | grep "autostart" | awk '{print $2}')
   onboot=$(qm config $id | grep "onboot"    | awk '{print $2}')
  startup=$(qm config $id | grep "startup"   | awk '{print $2}')
echo "qm set $id -autostart $autostart -onboot $onboot -startup $startup"

qm set 172221211 -autostart 0 -onboot 1 -startup order=2,up=300,down=300
qm set 172221211 -onboot 0 
qm set 172221211 -startup `[[order=]\d+] [,up=\d+] [,down=\d+]`
qm set 172221211 -delete onboot,startup

	 tags=$([[ "$key" == "sld" ]] && echo "sld" ; )
	 [[ "$key" == "off" ]] && echo "off" ;
	 [[ "$key" == "sld" ]] && echo "ndb" ;
	 [[ "$key" == "sld" ]] && echo "sld" ;
	 [[ "$key" == "sld" ]] && echo "sld" ;
     tags=$(qm config $id | grep "tags"      | awk '{print $2}')

acpi: 1
agent: 1,fstrim_cloned_disks=1
autostart: 0
balloon: 0
boot: order=ide0;virtio0
cores: 4
cpu: kvm64
ide0: none,media=cdrom
kvm: 1
machine: pc-q35-5.1
memory: 16384
name: unirez-12-sld
net0: virtio=44:44:43:87:76:11,bridge=vmbr0
numa: 1
onboot: 1
ostype: l26
scsihw: virtio-scsi-single
smbios1: uuid=008b691f-3ddd-4a87-b1f7-ec9be60c11c6
sockets: 2
startup: order=2,up=300,down=300
tablet: 0
template: 0
vga: std
virtio0: zfs:vm-172221211-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256,size=120G














id=17222343
id=172221221
qm guest cmd $id info
qm guest cmd $id ping && qm status $id --verbose | grep '^status:' | awk '{print $2}'

#qm guest cmd 1001002 shutdown
#qm shutdown 1001002 && qm wait 300 -timeout 40
qm guest cmd $id info
qm guest cmd $id get-users
qm guest cmd $id get-host-name
qm guest cmd $id get-osinfo
qm guest cmd $id network-get-interfaces
qm guest exec $id powershell -- '[System.Net.Dns]::GetHostByName($env:computerName).HostName' | jq
jq=`qm guest exec $id powershell -- '[System.Net.Dns]::GetHostByName($env:computerName).HostName'`
echo $jq | jq ' to_entries | sort | .[2] | .value' | tr -d '"' | rev | cut -c5- | rev
fqdn=$(qm guest exec $id powershell -- '[System.Net.Dns]::GetHostByName($env:computerName).HostName' | jq ' to_entries | sort | .[2] | .value' | tr -d '"' | rev | cut -c5- | rev)

qm guest exec $id cmd        -- "/c ipconfig /all"
qm guest exec $id powershell -- "ipconfig /all"
qm guest exec $id powershell -- "ipconfig /all"
qm guest exec $id powershell -- 'Get-NetIPConfiguration | Where-Object {$_.InterfaceAlias -eq "Ethernet0"}'

getHostname () { qm guest cmd $1 get-host-name          | jq '.[]' ; }
getNetworks () { qm guest cmd $1 network-get-interfaces | jq '.[]' ; } 
getNetname  () { jq=`qm guest exec $1 powershell -- 'Get-NetIPConfiguration | Where-Object {$_.InterfaceAlias -eq "Ethernet0"}' | jq '.[]'` ; echo $jq | awk '{gsub(/\\r\\n/,RS)} 1' | grep NetProfile.Name | awk '{print $3}' ; }
getFqdn     () { qm guest exec $1 powershell -- '[System.Net.Dns]::GetHostByName($env:computerName).HostName' | jq ' to_entries | sort | .[2] | .value' | tr -d '"' | rev | cut -c5- | rev ; }
getAll      () { echo $1 $(getFqdn $1) ; }

qm guest cmd $id network-get-interfaces | jq
qm guest cmd $id network-get-interfaces | jq '.[]  | keys'
qm guest cmd $id network-get-interfaces | jq '.[]  | length'
qm guest cmd $id network-get-interfaces | jq '.[0] | keys'
qm guest cmd $id network-get-interfaces | jq '.[0] | length'
qm guest cmd $id network-get-interfaces | jq '.[0] | .name'

#PVESH 
#https://pve.proxmox.com/pve-docs/api-viewer/index.html
#https://forum.proxmox.com/threads/list-all-vms-in-specific-pool-with-pvesh.103690/
export mypool=""
pvesh get /cluster/resources --type vm --output-format json |jq '.[]'
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k1 -n
export mypool="unirez"
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)'
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k1 -n
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool != env.mypool)|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k1 -n | grep $mypool
pvesh set /pools/$mypool --vms 17222276,172222559
export mypool="null"
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.template,.type,.status,.maxcpu,.vmid,.name,.node,.pool'| tr -d \" | awk 'NR%8{printf "%s ",$0;next;}1' | column -t | sort -k5 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.pool,.node,.name,.vmid,.status'                        | tr -d \" | awk 'NR%5{printf "%s ",$0;next;}1' | column -t | sort -k2 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.pool,.node,.name,.vmid,.status'                        | tr -d \" | awk 'NR%5{printf "%s ",$0;next;}1' | column -t | sort -k3 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.pool,.node,.name,.vmid,.status'                        | tr -d \" | awk 'NR%5{printf "%s ",$0;next;}1' | column -t | sort -k4 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]'                                                        | tr -d \" | awk 'NR%3{printf "%s ",$0;next;}1' | column -t | sort -k1 -n | grep $mypool
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|.vmid,.name,.node'                                      | tr -d \" | awk 'NR%3{printf "%s ",$0;next;}1' | column -t | sort -k1 -n
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)|.id'
pvesh get /cluster/resources --type vm --output-format json |jq '.[]|select(.pool == env.mypool)|.vmid,.name,.node'          | tr -d \" | awk 'NR%3{printf "%s ",$0;next;}1' | column -t | sort -k1 -n



#!/bin/bash
#qm guest cmd 1001002 info
#qm guest cmd 1001002 shutdown
#qm shutdown 1001002 && qm wait 300 -timeout 40
#qm status 1001002  --verbose
#qm showcmd 1001002 --pretty
 vm_ids=(1001002 1001007)
#vm_ids=("$@")
# Function to check if autostart is enabled for a VM
check_autostart() {
    local vm_id=$1

    local autostart_setting=$(qm config $vm_id | grep onboot | awk '{print $2}')

    if [[ $autostart_setting == 1 ]]; then
        read -p "Select option for VM $vm_id (long/short): " option

        if [[ $option == "long" ]]; then
            qm set $vm_id -onboot 1 -bootdisk sata0 -bootorder disk,cdrom -bootcdrom none -bootmenu 0
            qm set $vm_id -startup delay=180 -shutdown delay=300
            qm set $vm_id -tags long
        elif [[ $option == "short" ]]; then
            qm set $vm_id -onboot 1 -bootdisk sata0 -bootorder disk,cdrom -bootcdrom none -bootmenu 0
            qm set $vm_id -startup delay=30 -shutdown delay=60
            qm set $vm_id -tags short
        else
            echo "Invalid option selected for VM $vm_id"
        fi
    else
        qm set $vm_id -tags offline
    fi
}
# Backup the config of each VM
backup_config() {
    local vm_id=$1
    local node_name=$(hostname)
    local timestamp=$(date +"%Y%m%d_%H%M")
    local backup_folder=vm-settings-$node_name-$timestamp
    if [ ! -d "$backup_folder" ]; then
        mkdir $backup_folder
    fi
    qm config  $vm_id           > $backup_folder/$vm_id.conf
	qm config  $vm_id --current > $backup_folder/$vm_id.confcurrent
	qm status  $vm_id --verbose > $backup_folder/$vm_id.status
	qm showcmd $vm_id --pretty  > $backup_folder/$vm_id.showcmd
}
# Restore the config of a VM
restore_config() {
    local vm_id=$1
    local node_name=$(hostname)
    local timestamp=$(date +"%Y%m%d_%H%M%S")
    local backup_folder=vm-settings-$node_name-$timestamp
    local backup_file=$backup_folder/$vm_id.conf

    if [ -f "$backup_file" ]; then
        qm restore $vm_id $backup_file
    else
        echo "Backup file for VM $vm_id not found"
    fi
}

generate_csv(){
    local node_name=$(hostname)
    local csv_file="$node_name.settings"
    local csv_file_bak="$node_name.settings.bak"
    local values="vmid,tags,onboot,ostype,name,machine,numa,cpu,sockets,cores,memory,balloon,startup"
    echo $values > $csv_file
    for id in "${vm_ids[@]}"
    do
        local    vmid=$id
		local    tags=$(qm config $id | grep "tags"    | awk '{print $2}')
        local  onboot=$(qm config $id | grep "onboot"  | awk '{print $2}')
        local  ostype=$(qm config $id | grep "ostype"  | awk '{print $2}')
        local    name=$(qm config $id | grep "name"    | awk '{print $2}')
        local machine=$(qm config $id | grep "machine" | awk '{print $2}')
        local    numa=$(qm config $id | grep "numa"    | awk '{print $2}')
        local     cpu=$(qm config $id | grep "cpu" | grep -v "cpuunits" | awk '{print $2}')
        local sockets=$(qm config $id | grep "sockets" | awk '{print $2}')
        local   cores=$(qm config $id | grep "cores"   | awk '{print $2}')
        local  memory=$(qm config $id | grep "memory"  | awk '{print $2}')
        local balloon=$(qm config $id | grep "balloon" | awk '{print $2}')
		local startup=$(qm config $id | grep "startup" | awk '{print $2}')
        echo '"'"$vmid"'","'"$tags"'","'"$onboot"'","'"$ostype"'","'"$name"'","'"$machine"'","'"$numa"'","'"$cpu"'","'"$sockets"'","'"$cores"'","'"$memory"'","'"$balloon"'","'"$startup"'"' >> $csv_file
    done
    column -s "," -t $csv_file > $csv_file_bak ; cp $csv_file_bak $csv_file ; cat $csv_file
}

# Iterate over the passed list of VMs
for vm_id in "${vm_ids[@]}"; do
 backup_config   $vm_id
#check_autostart $vm_id
#restore_config  $vm_id
#generate_csv     $vm_id
done



# qm set <vmid> [OPTIONS]
# 
# Set virtual machine options (synchrounous API) - You should consider using the POST method instead for any actions involving hotplug or storage allocation.
# 
# <vmid>: <integer> (1 - N)
# The (unique) ID of the VM.
# 
# --acpi <boolean> (default = 1)
# Enable/disable ACPI.
# 
# --affinity <string>
# List of host cores used to execute guest processes, for example: 0,5,8-11
# 
# --agent [enabled=]<1|0> [,fstrim_cloned_disks=<1|0>] [,type=<virtio|isa>]
# Enable/disable communication with the Qemu Guest Agent and its properties.
# 
# --arch <aarch64 | x86_64>
# Virtual processor architecture. Defaults to the host.
# 
# --args <string>
# Arbitrary arguments passed to kvm.
# 
# --audio0 device=<ich9-intel-hda|intel-hda|AC97> [,driver=<spice|none>]
# Configure a audio device, useful in combination with QXL/Spice.
# 
# --autostart <boolean> (default = 0)
# Automatic restart after crash (currently ignored).
# 
# --balloon <integer> (0 - N)
# Amount of target RAM for the VM in MB. Using zero disables the ballon driver.
# 
# --bios <ovmf | seabios> (default = seabios)
# Select BIOS implementation.
# 
# --boot [[legacy=]<[acdn]{1,4}>] [,order=<device[;device...]>]
# Specify guest boot order. Use the order= sub-property as usage with no key or legacy= is deprecated.
# 
# --bootdisk (ide|sata|scsi|virtio)\d+
# Enable booting from specified disk. Deprecated: Use boot: order=foo;bar instead.
# 
# --cdrom <volume>
# This is an alias for option -ide2
# 
# --cicustom [meta=<volume>] [,network=<volume>] [,user=<volume>] [,vendor=<volume>]
# cloud-init: Specify custom files to replace the automatically generated ones at start.
# 
# --cipassword <password>
# cloud-init: Password to assign the user. Using this is generally not recommended. Use ssh keys instead. Also note that older cloud-init versions do not support hashed passwords.
# 
# --citype <configdrive2 | nocloud | opennebula>
# Specifies the cloud-init configuration format. The default depends on the configured operating system type (ostype. We use the nocloud format for Linux, and configdrive2 for windows.
# 
# --ciuser <string>
# cloud-init: User name to change ssh keys and password for instead of the image’s configured default user.
# 
# --cores <integer> (1 - N) (default = 1)
# The number of cores per socket.
# 
# --cpu [[cputype=]<string>] [,flags=<+FLAG[;-FLAG...]>] [,hidden=<1|0>] [,hv-vendor-id=<vendor-id>] [,phys-bits=<8-64|host>] [,reported-model=<enum>]
# Emulated CPU type.
# 
# --cpulimit <number> (0 - 128) (default = 0)
# Limit of CPU usage.
# 
# --cpuunits <integer> (1 - 262144) (default = cgroup v1: 1024, cgroup v2: 100)
# CPU weight for a VM, will be clamped to [1, 10000] in cgroup v2.
# 
# --delete <string>
# A list of settings you want to delete.
# 
# --description <string>
# Description for the VM. Shown in the web-interface VM’s summary. This is saved as comment inside the configuration file.
# 
# --digest <string>
# Prevent changes if current configuration file has different SHA1 digest. This can be used to prevent concurrent modifications.
# 
# --efidisk0 [file=]<volume> [,efitype=<2m|4m>] [,format=<enum>] [,import-from=<source volume>] [,pre-enrolled-keys=<1|0>] [,size=<DiskSize>]
# Configure a Disk for storing EFI vars. Use the special syntax STORAGE_ID:SIZE_IN_GiB to allocate a new volume. Note that SIZE_IN_GiB is ignored here and that the default EFI vars are copied to the volume instead. Use STORAGE_ID:0 and the import-from parameter to import from an existing volume.
# 
# --force <boolean>
# Force physical removal. Without this, we simple remove the disk from the config file and create an additional configuration entry called unused[n], which contains the volume ID. Unlink of unused[n] always cause physical removal.
# 
# Note	Requires option(s): delete
# --freeze <boolean>
# Freeze CPU at startup (use c monitor command to start execution).
# 
# --hookscript <string>
# Script that will be executed during various steps in the vms lifetime.
# 
# --hostpci[n] [host=]<HOSTPCIID[;HOSTPCIID2...]> [,device-id=<hex id>] [,legacy-igd=<1|0>] [,mdev=<string>] [,pcie=<1|0>] [,rombar=<1|0>] [,romfile=<string>] [,sub-device-id=<hex id>] [,sub-vendor-id=<hex id>] [,vendor-id=<hex id>] [,x-vga=<1|0>]
# Map host PCI devices into guest.
# 
# --hotplug <string> (default = network,disk,usb)
# Selectively enable hotplug features. This is a comma separated list of hotplug features: network, disk, cpu, memory, usb and cloudinit. Use 0 to disable hotplug completely. Using 1 as value is an alias for the default network,disk,usb. USB hotplugging is possible for guests with machine version >= 7.1 and ostype l26 or windows > 7.
# 
# --hugepages <1024 | 2 | any>
# Enable/disable hugepages memory.
# 
# --ide[n] [file=]<volume> [,aio=<native|threads|io_uring>] [,backup=<1|0>] [,bps=<bps>] [,bps_max_length=<seconds>] [,bps_rd=<bps>] [,bps_rd_max_length=<seconds>] [,bps_wr=<bps>] [,bps_wr_max_length=<seconds>] [,cache=<enum>] [,cyls=<integer>] [,detect_zeroes=<1|0>] [,discard=<ignore|on>] [,format=<enum>] [,heads=<integer>] [,import-from=<source volume>] [,iops=<iops>] [,iops_max=<iops>] [,iops_max_length=<seconds>] [,iops_rd=<iops>] [,iops_rd_max=<iops>] [,iops_rd_max_length=<seconds>] [,iops_wr=<iops>] [,iops_wr_max=<iops>] [,iops_wr_max_length=<seconds>] [,mbps=<mbps>] [,mbps_max=<mbps>] [,mbps_rd=<mbps>] [,mbps_rd_max=<mbps>] [,mbps_wr=<mbps>] [,mbps_wr_max=<mbps>] [,media=<cdrom|disk>] [,model=<model>] [,replicate=<1|0>] [,rerror=<ignore|report|stop>] [,secs=<integer>] [,serial=<serial>] [,shared=<1|0>] [,size=<DiskSize>] [,snapshot=<1|0>] [,ssd=<1|0>] [,trans=<none|lba|auto>] [,werror=<enum>] [,wwn=<wwn>]
# Use volume as IDE hard disk or CD-ROM (n is 0 to 3). Use the special syntax STORAGE_ID:SIZE_IN_GiB to allocate a new volume. Use STORAGE_ID:0 and the import-from parameter to import from an existing volume.
# 
# --ipconfig[n] [gw=<GatewayIPv4>] [,gw6=<GatewayIPv6>] [,ip=<IPv4Format/CIDR>] [,ip6=<IPv6Format/CIDR>]
# cloud-init: Specify IP addresses and gateways for the corresponding interface.
# 
# IP addresses use CIDR notation, gateways are optional but need an IP of the same type specified.
# 
# The special string dhcp can be used for IP addresses to use DHCP, in which case no explicit gateway should be provided. For IPv6 the special string auto can be used to use stateless autoconfiguration. This requires cloud-init 19.4 or newer.
# 
# If cloud-init is enabled and neither an IPv4 nor an IPv6 address is specified, it defaults to using dhcp on IPv4.
# 
# --ivshmem size=<integer> [,name=<string>]
# Inter-VM shared memory. Useful for direct communication between VMs, or to the host.
# 
# --keephugepages <boolean> (default = 0)
# Use together with hugepages. If enabled, hugepages will not not be deleted after VM shutdown and can be used for subsequent starts.
# 
# --keyboard <da | de | de-ch | en-gb | en-us | es | fi | fr | fr-be | fr-ca | fr-ch | hu | is | it | ja | lt | mk | nl | no | pl | pt | pt-br | sl | sv | tr>
# Keyboard layout for VNC server. This option is generally not required and is often better handled from within the guest OS.
# 
# --kvm <boolean> (default = 1)
# Enable/disable KVM hardware virtualization.
# 
# --localtime <boolean>
# Set the real time clock (RTC) to local time. This is enabled by default if the ostype indicates a Microsoft Windows OS.
# 
# --lock <backup | clone | create | migrate | rollback | snapshot | snapshot-delete | suspended | suspending>
# Lock/unlock the VM.
# 
# --machine (pc|pc(-i440fx)?-\d+(\.\d+)+(\+pve\d+)?(\.pxe)?|q35|pc-q35-\d+(\.\d+)+(\+pve\d+)?(\.pxe)?|virt(?:-\d+(\.\d+)+)?(\+pve\d+)?)
# Specifies the Qemu machine type.
# 
# --memory <integer> (16 - N) (default = 512)
# Amount of RAM for the VM in MB. This is the maximum available memory when you use the balloon device.
# 
# --migrate_downtime <number> (0 - N) (default = 0.1)
# Set maximum tolerated downtime (in seconds) for migrations.
# 
# --migrate_speed <integer> (0 - N) (default = 0)
# Set maximum speed (in MB/s) for migrations. Value 0 is no limit.
# 
# --name <string>
# Set a name for the VM. Only used on the configuration web interface.
# 
# --nameserver <string>
# cloud-init: Sets DNS server IP address for a container. Create will automatically use the setting from the host if neither searchdomain nor nameserver are set.
# 
# --net[n] [model=]<enum> [,bridge=<bridge>] [,firewall=<1|0>] [,link_down=<1|0>] [,macaddr=<XX:XX:XX:XX:XX:XX>] [,mtu=<integer>] [,queues=<integer>] [,rate=<number>] [,tag=<integer>] [,trunks=<vlanid[;vlanid...]>] [,<model>=<macaddr>]
# Specify network devices.
# 
# --numa <boolean> (default = 0)
# Enable/disable NUMA.
# 
# --numa[n] cpus=<id[-id];...> [,hostnodes=<id[-id];...>] [,memory=<number>] [,policy=<preferred|bind|interleave>]
# NUMA topology.
# 
# --onboot <boolean> (default = 0)
# Specifies whether a VM will be started during system bootup.
# 
# --ostype <l24 | l26 | other | solaris | w2k | w2k3 | w2k8 | win10 | win11 | win7 | win8 | wvista | wxp>
# Specify guest operating system.
# 
# --parallel[n] /dev/parport\d+|/dev/usb/lp\d+
# Map host parallel devices (n is 0 to 2).
# 
# --protection <boolean> (default = 0)
# Sets the protection flag of the VM. This will disable the remove VM and remove disk operations.
# 
# --reboot <boolean> (default = 1)
# Allow reboot. If set to 0 the VM exit on reboot.
# 
# --revert <string>
# Revert a pending change.
# 
# --rng0 [source=]</dev/urandom|/dev/random|/dev/hwrng> [,max_bytes=<integer>] [,period=<integer>]
# Configure a VirtIO-based Random Number Generator.
# 
# --sata[n] [file=]<volume> [,aio=<native|threads|io_uring>] [,backup=<1|0>] [,bps=<bps>] [,bps_max_length=<seconds>] [,bps_rd=<bps>] [,bps_rd_max_length=<seconds>] [,bps_wr=<bps>] [,bps_wr_max_length=<seconds>] [,cache=<enum>] [,cyls=<integer>] [,detect_zeroes=<1|0>] [,discard=<ignore|on>] [,format=<enum>] [,heads=<integer>] [,import-from=<source volume>] [,iops=<iops>] [,iops_max=<iops>] [,iops_max_length=<seconds>] [,iops_rd=<iops>] [,iops_rd_max=<iops>] [,iops_rd_max_length=<seconds>] [,iops_wr=<iops>] [,iops_wr_max=<iops>] [,iops_wr_max_length=<seconds>] [,mbps=<mbps>] [,mbps_max=<mbps>] [,mbps_rd=<mbps>] [,mbps_rd_max=<mbps>] [,mbps_wr=<mbps>] [,mbps_wr_max=<mbps>] [,media=<cdrom|disk>] [,replicate=<1|0>] [,rerror=<ignore|report|stop>] [,secs=<integer>] [,serial=<serial>] [,shared=<1|0>] [,size=<DiskSize>] [,snapshot=<1|0>] [,ssd=<1|0>] [,trans=<none|lba|auto>] [,werror=<enum>] [,wwn=<wwn>]
# Use volume as SATA hard disk or CD-ROM (n is 0 to 5). Use the special syntax STORAGE_ID:SIZE_IN_GiB to allocate a new volume. Use STORAGE_ID:0 and the import-from parameter to import from an existing volume.
# 
# --scsi[n] [file=]<volume> [,aio=<native|threads|io_uring>] [,backup=<1|0>] [,bps=<bps>] [,bps_max_length=<seconds>] [,bps_rd=<bps>] [,bps_rd_max_length=<seconds>] [,bps_wr=<bps>] [,bps_wr_max_length=<seconds>] [,cache=<enum>] [,cyls=<integer>] [,detect_zeroes=<1|0>] [,discard=<ignore|on>] [,format=<enum>] [,heads=<integer>] [,import-from=<source volume>] [,iops=<iops>] [,iops_max=<iops>] [,iops_max_length=<seconds>] [,iops_rd=<iops>] [,iops_rd_max=<iops>] [,iops_rd_max_length=<seconds>] [,iops_wr=<iops>] [,iops_wr_max=<iops>] [,iops_wr_max_length=<seconds>] [,iothread=<1|0>] [,mbps=<mbps>] [,mbps_max=<mbps>] [,mbps_rd=<mbps>] [,mbps_rd_max=<mbps>] [,mbps_wr=<mbps>] [,mbps_wr_max=<mbps>] [,media=<cdrom|disk>] [,queues=<integer>] [,replicate=<1|0>] [,rerror=<ignore|report|stop>] [,ro=<1|0>] [,scsiblock=<1|0>] [,secs=<integer>] [,serial=<serial>] [,shared=<1|0>] [,size=<DiskSize>] [,snapshot=<1|0>] [,ssd=<1|0>] [,trans=<none|lba|auto>] [,werror=<enum>] [,wwn=<wwn>]
# Use volume as SCSI hard disk or CD-ROM (n is 0 to 30). Use the special syntax STORAGE_ID:SIZE_IN_GiB to allocate a new volume. Use STORAGE_ID:0 and the import-from parameter to import from an existing volume.
# 
# --scsihw <lsi | lsi53c810 | megasas | pvscsi | virtio-scsi-pci | virtio-scsi-single> (default = lsi)
# SCSI controller model
# 
# --searchdomain <string>
# cloud-init: Sets DNS search domains for a container. Create will automatically use the setting from the host if neither searchdomain nor nameserver are set.
# 
# --serial[n] (/dev/.+|socket)
# Create a serial device inside the VM (n is 0 to 3)
# 
# --shares <integer> (0 - 50000) (default = 1000)
# Amount of memory shares for auto-ballooning. The larger the number is, the more memory this VM gets. Number is relative to weights of all other running VMs. Using zero disables auto-ballooning. Auto-ballooning is done by pvestatd.
# 
# --skiplock <boolean>
# Ignore locks - only root is allowed to use this option.
# 
# --smbios1 [base64=<1|0>] [,family=<Base64 encoded string>] [,manufacturer=<Base64 encoded string>] [,product=<Base64 encoded string>] [,serial=<Base64 encoded string>] [,sku=<Base64 encoded string>] [,uuid=<UUID>] [,version=<Base64 encoded string>]
# Specify SMBIOS type 1 fields.
# 
# --smp <integer> (1 - N) (default = 1)
# The number of CPUs. Please use option -sockets instead.
# 
# --sockets <integer> (1 - N) (default = 1)
# The number of CPU sockets.
# 
# --spice_enhancements [foldersharing=<1|0>] [,videostreaming=<off|all|filter>]
# Configure additional enhancements for SPICE.
# 
# --sshkeys <filepath>
# cloud-init: Setup public SSH keys (one key per line, OpenSSH format).
# 
# --startdate (now | YYYY-MM-DD | YYYY-MM-DDTHH:MM:SS) (default = now)
# Set the initial date of the real time clock. Valid format for date are:'now' or 2006-06-17T16:01:21 or 2006-06-17.
# 
# --startup `[[order=]\d+] [,up=\d+] [,down=\d+] `
# Startup and shutdown behavior. Order is a non-negative number defining the general startup order. Shutdown in done with reverse ordering. Additionally you can set the up or down delay in seconds, which specifies a delay to wait before the next VM is started or stopped.
# 
# --tablet <boolean> (default = 1)
# Enable/disable the USB tablet device.
# 
# --tags <string>
# Tags of the VM. This is only meta information.
# 
# --tdf <boolean> (default = 0)
# Enable/disable time drift fix.
# 
# --template <boolean> (default = 0)
# Enable/disable Template.
# 
# --tpmstate0 [file=]<volume> [,import-from=<source volume>] [,size=<DiskSize>] [,version=<v1.2|v2.0>]
# Configure a Disk for storing TPM state. The format is fixed to raw. Use the special syntax STORAGE_ID:SIZE_IN_GiB to allocate a new volume. Note that SIZE_IN_GiB is ignored here and 4 MiB will be used instead. Use STORAGE_ID:0 and the import-from parameter to import from an existing volume.
# 
# --unused[n] [file=]<volume>
# Reference to unused volumes. This is used internally, and should not be modified manually.
# 
# --usb[n] [host=]<HOSTUSBDEVICE|spice> [,usb3=<1|0>]
# Configure an USB device (n is 0 to 4, for machine version >= 7.1 and ostype l26 or windows > 7, n can be up to 14).
# 
# --vcpus <integer> (1 - N) (default = 0)
# Number of hotplugged vcpus.
# 
# --vga [[type=]<enum>] [,memory=<integer>]
# Configure the VGA hardware.
# 
# --virtio[n] [file=]<volume> [,aio=<native|threads|io_uring>] [,backup=<1|0>] [,bps=<bps>] [,bps_max_length=<seconds>] [,bps_rd=<bps>] [,bps_rd_max_length=<seconds>] [,bps_wr=<bps>] [,bps_wr_max_length=<seconds>] [,cache=<enum>] [,cyls=<integer>] [,detect_zeroes=<1|0>] [,discard=<ignore|on>] [,format=<enum>] [,heads=<integer>] [,import-from=<source volume>] [,iops=<iops>] [,iops_max=<iops>] [,iops_max_length=<seconds>] [,iops_rd=<iops>] [,iops_rd_max=<iops>] [,iops_rd_max_length=<seconds>] [,iops_wr=<iops>] [,iops_wr_max=<iops>] [,iops_wr_max_length=<seconds>] [,iothread=<1|0>] [,mbps=<mbps>] [,mbps_max=<mbps>] [,mbps_rd=<mbps>] [,mbps_rd_max=<mbps>] [,mbps_wr=<mbps>] [,mbps_wr_max=<mbps>] [,media=<cdrom|disk>] [,replicate=<1|0>] [,rerror=<ignore|report|stop>] [,ro=<1|0>] [,secs=<integer>] [,serial=<serial>] [,shared=<1|0>] [,size=<DiskSize>] [,snapshot=<1|0>] [,trans=<none|lba|auto>] [,werror=<enum>]
# Use volume as VIRTIO hard disk (n is 0 to 15). Use the special syntax STORAGE_ID:SIZE_IN_GiB to allocate a new volume. Use STORAGE_ID:0 and the import-from parameter to import from an existing volume.
# 
# --vmgenid <UUID> (default = 1 (autogenerated))
# Set VM Generation ID. Use 1 to autogenerate on create or update, pass 0 to disable explicitly.
# 
# --vmstatestorage <string>
# Default storage for VM state volumes/files.
# 
# --watchdog [[model=]<i6300esb|ib700>] [,action=<enum>]
# Create a virtual hardware watchdog device.
