$viserver = "192.168.191.3"
connect-viserver $viserver

$vm = read-host "Enter VM Name" #tautropfenwin1
$vm = "tautropfenwin1"
$vmObject = Get-VM -Name $vm
$pve = ""
$esx = (Get-VMHost -VM $vmObject | Select-Object Name).Name
$esxRo = 
$vmxFilePathOrig = $vmObject.ExtensionData.Config.Files.VmPathName
$vmxFilePathOrig = "[191-92-SSD] tautropfenwin1/tautropfenwin1.vmx"
$vmxDatastore = ($vmxFilePathOrig -split ' ')[0].TrimStart('[').TrimEnd(']')
$vmxVmFolder = ($vmxFilePathOrig -split ' ')[1]
$vmxRootPath = "/vmfs/volumes"
$vmxFilePath = "$vmxRootPath/$vmxDatastore/$vmxVmFolder"

$vm = Get-VM -Name "tautropfenwin1"
$vmDisks = ($vm.ExtensionData.Config.Hardware.Device | Where-Object {$_.GetType().Name -eq 'VirtualDisk'}).Backing.FileName
foreach ($index in 0..($vmDisks.Count - 1)) {
    $diskPath = "/vmfs/volumes" + $vmDisks[$index].Replace('[','/').Replace('] ','/')
    Write-Host "disk$index = $diskPath"
}

$vmName = "tautropfenwin1"

$VMs=Get-View -ViewType VirtualMachine -Filter @{"Name"="$vmName"}
$vmName=$VMs.Summary.Config.Name


Get-VM | Select Name,@{N="Path";E={(Get-Path -Object $_) -replace "^.*?Resources/"`}}


get-vm
get-vm | select -first 1 | get-member | where {$_.MemberType -eq "Property"} | select name, definition
get-vm -Name "$vmName" | fl -Property *
get-vm -Name "$vmName" | fl -Property Name,VMHost,NumCpu,CoresPerSocket,MemoryMB,HardwareVersion
Get-View -ViewType VirtualMachine -Filter @{"Name"="$vmName"}


$VMs=Get-View -ViewType VirtualMachine -Filter @{"Name"="$vmName"}
$VMs
$VMs.Config
$VMs.Guest
$VMs.Layout.Disk | Sort-Object -Property Key
$VMs.Summary.Config
$VMs.Config.Hardware.Device | where {$_.DeviceInfo.Label -match "Network Adapter"} | select MacAddress
$VMs.Config.Hardware.Device | where {$_.DeviceInfo.Label -match "Network Adapter"} | select MacAddress | fl

    $VMs=Get-View -ViewType VirtualMachine -Filter @{"Name"="$vmName"}
 $vmName=$VMs.Summary.Config.Name
  $vmNet=get-networkadapter -VM "$vmName"
 $vmMac1=$vmNet.MacAddress
 $vmMac1=$VMs.Config.Hardware.Device.MacAddress
$vmVlan1=$vmNet.NetworkName
 $vMSCpu=$VMs.Summary.Config.NumCpu
 $vMSMem=$VMs.Summary.Config.MemorySizeMB
 $vMSNet=$VMs.Summary.Config.NumEthernetCards
$vMSDisk=$VMs.Summary.Config.NumVirtualDisks
$vmCores=$VMs.Config.Hardware.NumCPU
$vmSocks=$VMs.Config.Hardware.NumCoresPerSocket
  vmNuma="1"
  vmScsi="virtio-scsi-single"
   vmMem="$vMSMem"
   vmBal="$vmMem"
  vmType="pc-i440fx-6.1"
   $vmOs=$VMs.Summary.Config.GuestId
 $vmOsNa=$VMs.Summary.Config.GuestFullName
 $vmNote=$VMs.Config.Annotation
$vmDisks=($VMs.Layout.Disk | Sort-Object -Property Key).DiskFile.replace('[','/').replace('] ','/')
 vmDisk1=$esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL.vmdk                ;echo [vmDisk1=$vmDisk1];du -sh "$vmDisk1";#GB: 250#LETTER:C#NAME:OS
 vmDisk2=$esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_1.vmdk              ;echo [vmDisk2=$vmDisk2];du -sh "$vmDisk2";#GB: 100#LETTER:E#NAME:LOGS
 vmDisk3=$esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_2.vmdk              ;echo [vmDisk3=$vmDisk3];du -sh "$vmDisk3";#GB:1000#LETTER:F#NAME:DATA
 vmDisk4=$esxRo/LOCAL_HD_R1-01/AP-SQL-LOG/AP-SQL/AP-SQL_3.vmdk       ;echo [vmDisk4=$vmDisk4];du -sh "$vmDisk4";#GB: 800#LETTER:L#NAME:SQL_LOG
 vmDisk5=$esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_4.vmdk              ;echo [vmDisk5=$vmDisk5];du -sh "$vmDisk5";#GB: 160#LETTER:G#NAME:SQL LOGS-1
 vmDisk6=$esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_5.vmdk              ;echo [vmDisk6=$vmDisk6];du -sh "$vmDisk6";#GB: 160#LETTER:H#NAME:SQL_TEMP
 vmDisk7=$esxRo/NETAPP1_DATASTORE1/SVRSQL-BACKUP/AP-SQL/AP-SQL_6.vmdk;echo [vmDisk7=$vmDisk7];du -sh "$vmDisk7";#GB:1024#LETTER:*#NAME:NettApp Vol1_SQL_BCK

function echoVariables {
 echo "vm       = $vmName           "
 echo "vmNet    = $vmNet            "
 echo "vmMac1   = $vmMac1           "
 echo "vmVlan1  = $vmVlan1          " 
 echo "vMSCpu   = $vMSCpu           "
 echo "vMSMem   = $vMSMem           "
 echo "vMSNet   = $vMSNet           "
 echo "vMSDisk  = $vMSDisk          " 
 echo "vmCores  = $vmCores          " 
 echo "vmSocks  = $vmSocks          "
 echo "vmNuma   = 1                 "
 echo "vmScsi   = virtio-scsi-single"
 echo "vmMem    = $vMSMem           "
 echo "vmBal    = $vMSMem           "
 echo "vmType   = pc-i440fx-6.1     "
 echo "vmOs     = $vmOs             "
 echo "vmOsNa   = $vmOsNa           "
 echo "vmNote   = $vmNote           "
 echo "vmDisks  = $vmDisks          "
}

vmName   = AP-SQL
vmNet    = Network adapter 1
vmMac1   = 00:50:56:b4:af:ea
vmMac1   = 00:50:56:b4:af:ea
vmVlan1  = Vlan262
vMSCpu   = 8
vMSMem   = 98304
vMSNet   = 1
vMSDisk  = 7
vmCores  = 8
vmSocks  = 1
vmOs     = windows8Server64Guest
vmOsNa   = Microsoft Windows Server 2012 (64-bit)
vmNote   =
vmDisk1  = $esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL.vmdk 
vmDisk2  = $esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_1.vmdk 
vmDisk3  = $esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_2.vmdk 
vmDisk4  = $esxRo/LOCAL_HD_R1-01/AP-SQL-LOG/AP-SQL/AP-SQL_3.vmdk 
vmDisk5  = $esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_4.vmdk 
vmDisk6  = $esxRo/NETAPP1_DATASTORE2/AP-SQL/AP-SQL_5.vmdk 
vmDisk7  = $esxRo/NETAPP1_DATASTORE1/SVRSQL-BACKUP/AP-SQL/AP-SQL_6.vmdk



Connect-VIServer servername -User -Password 

Get-VM |

Select Name,PowerState,Version,NumCPU,MemoryGB,ProvisionedSpaceGB,UsedSpaceGB,

    @{N='GuestOS';E={$_.Guest.OSFUllName}},

    @{N='PortgroupName';E={(Get-NetworkAdapter -VM $_).NetworkName -join '|'}},

    @{N='PortgroupVlanId';E={(Get-VirtualPortGroup -Name (Get-NetworkAdapter -VM $_).NetworkName -VMHost $_.VMHost).VlanId -join '|'}},

    @{N='Cluster';E={(Get-Cluster -VM $_).Name}},

    @{N='HostName';E={$_.VMHost.Name}} |

    Export-Csv C:\temp\VMPortGroup.csv 


$annotation          = $VMs.Config.Annotation
$config.version      = $VMs.Config.Version
CpuAllocation
cpuid.coresPerSocket = ""
displayName = "AP-SQL"
ethernet0.addressType = "vpx"
ethernet0.generatedAddress = "00:50:56:b4:af:ea"
ethernet0.networkName = "Vlan262"
ethernet0.present = "TRUE"
ethernet0.virtualDev = "e1000e"
guestOS = "windows8srv-64"
memSize = "98304"
numvcpus = "8"
scsi0.virtualDev = "lsisas1068"
scsi0:0.fileName = "AP-SQL.vmdk"
scsi0:1.fileName = "AP-SQL_1.vmdk"
scsi0:2.fileName = "AP-SQL_2.vmdk"
scsi0:3.fileName = "/vmfs/volumes/5bb278ec-e891434e-9073-7cd30ae6a6d0/AP-SQL-LOG/AP-SQL/AP-SQL_3.vmdk"
scsi0:4.fileName = "AP-SQL_4.vmdk"
scsi0:5.fileName = "AP-SQL_5.vmdk"
scsi0:6.fileName = "/vmfs/volumes/5b4fcd15-b260d86c-6baf-7cd30ae6a6d0/SVRSQL-BACKUP/AP-SQL/AP-SQL_6.vmdk"
virtualHW.version = "11"

$report =@() 
Get-VM | Get-View | %{ 
 $VMname = $_.Name 
 $_.Config.Hardware.Device | where {$_.DeviceInfo.Label -match "Network Adapter"} | %{` 
        $row = "" | Select VM, MAC, Type 
        $row.VM = $VMname 
        $row.MAC = $_.MacAddress 
        $row.Type = $_.AddressType 
        $report += $row 
  } 
  } 
$report 

Capability           : VMware.Vim.VirtualMachineCapability
Config               : VMware.Vim.VirtualMachineConfigInfo
Layout               : VMware.Vim.VirtualMachineFileLayout
LayoutEx             : VMware.Vim.VirtualMachineFileLayoutEx
Storage              : VMware.Vim.VirtualMachineStorageInfo
EnvironmentBrowser   : EnvironmentBrowser-2-envmgr
ResourcePool         : ResourcePool-ha-root-pool
ParentVApp           :
ResourceConfig       : VMware.Vim.ResourceConfigSpec
Runtime              : VMware.Vim.VirtualMachineRuntimeInfo
Guest                : VMware.Vim.GuestInfo
Summary              : VMware.Vim.VirtualMachineSummary
Datastore            : {Datastore-5bb278ec-e891434e-9073-7cd30ae6a6d0, Datastore-5b4fcd15-b260d86c-6baf-7cd30ae6a6d0, Datastore-5b4fcd2d-91c9e3d2-0e1d-7cd30ae6a6d0}
Network              : {Network-HaNetwork-Vlan262}
Snapshot             :
RootSnapshot         : {}
GuestHeartbeatStatus : gray
LinkedView           :
Parent               : Folder-ha-folder-vm
CustomValue          : {}
OverallStatus        : green
ConfigStatus         : green
ConfigIssue          : {}
EffectiveRole        : {-1}
Permission           : {}
Name                 : AP-SQL
DisabledMethod       : {setCustomValue, AddTag, RemoveTag, RetrieveCustomValues...}
RecentTask           : {}
DeclaredAlarmState   : {}
TriggeredAlarmState  : {}
AlarmActionsEnabled  : False
Tag                  : {}
Value                : {}
AvailableField       : {}
MoRef                : VirtualMachine-2
Client               : VMware.Vim.VimClientImpl


$VMs.Config
$VMs.Layout
$VMs.LayoutEx
$VMs.Storage
$VMs.EnvironmentBrowser
$VMs.ResourcePool
$VMs.ResourceConfig
$VMs.Runtime
$VMs.Guest


Name                    : AP-SQL
PowerState              : PoweredOff
Notes                   :
Guest                   : AP-SQL:
NumCpu                  : 8
CoresPerSocket          : 1
MemoryMB                : 98304
MemoryGB                : 96
VMHostId                : HostSystem-ha-host
VMHost                  : 172.16.195.101
VApp                    :
FolderId                : Folder-ha-folder-vm
Folder                  : vm
ResourcePoolId          : ResourcePool-ha-root-pool
ResourcePool            : Resources
HARestartPriority       :
HAIsolationResponse     :
DrsAutomationLevel      :
VMSwapfilePolicy        : Inherit
VMResourceConfiguration : CpuShares:Normal/8000 MemShares:Normal/983040
Version                 : v11
HardwareVersion         : vmx-11
PersistentId            : 50345652-f63d-4900-152a-078ebbeddf0d
GuestId                 : windows8Server64Guest
UsedSpaceGB             : 2895.6250880435109138488769531
ProvisionedSpaceGB      : 3494.2385182967409491539001465
DatastoreIdList         : {Datastore-5bb278ec-e891434e-9073-7cd30ae6a6d0, Datastore-5b4fcd15-b260d86c-6baf-7cd30ae6a6d0, Datastore-5b4fcd2d-91c9e3d2-0e1d-7cd30ae6a6d0}
CreateDate              :
SEVEnabled              :
BootDelayMillisecond    : 0
MigrationEncryption     : Opportunistic
MemoryHotAddEnabled     : True
MemoryHotAddIncrement   :
MemoryHotAddLimit       :
CpuHotAddEnabled        : True
CpuHotRemoveEnabled     : False
ExtensionData           : VMware.Vim.VirtualMachine
CustomFields            : {}
Id                      : VirtualMachine-2
Uid                     : /VIServer=root@172.16.195.101:443/VirtualMachine=VirtualMachine-2/

