param(
    [Parameter(Position = 0)]
    [string]$TaskName,

    [Parameter(Position = 1)]
    [string]$TaskOption,

    [Parameter(Position = 2)]
    [string]$TaskDateTime,

    [Parameter(ParameterSetName = 'DoUpdate')]
    [switch]$DoUpdate
)

$ScriptFile = $PSScriptRoot + '\' + [System.IO.Path]::GetFileNameWithoutExtension($($PSCommandPath | Split-Path -Leaf)) + '.ps1'

if (-not $PSBoundParameters.ContainsKey('TaskName')) {
    Write-Output @"
[Examples to run this script]
$ScriptFile "reboot1"  "shutdown -r -t 60" "2023-05-10 21:59:00"
$ScriptFile "reboot2"  "shutdown -r -t 60" "2023-05-10 22:59:00" -DoUpdate
$ScriptFile "reboot3"  "shutdown -r -t 60" "2023-05-11 00:59:00" -DoUpdate
$ScriptFile "shutdown" "shutdown -s -t 60" "2023-05-11 03:59:00"
"@
}
elseif (-not $PSBoundParameters.ContainsKey('TaskOption') -or -not $PSBoundParameters.ContainsKey('TaskDateTime')) {
    Write-Error "Invalid option or parameter."
}
else {
    $taskDescription = $TaskName
    $doUpdateCommand = if ($DoUpdate) { "Get-WUInstall -MicrosoftUpdate -AcceptAll -Download -Install -IgnoreReboot" }
    $taskCommand = "$doUpdateCommand;$TaskOption;schtasks.exe /delete /f /tn $TaskName;"
    $action = New-ScheduledTaskAction `
        -Execute 'C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe' `
        -Argument "-NoProfile -NoLogo -NonInteractive -ExecutionPolicy Bypass -Command `"$taskCommand`""
    $trigger = New-ScheduledTaskTrigger -Once -At $TaskDateTime
    $taskSettings = New-ScheduledTaskSettingsSet -Compatibility Win8
    Register-ScheduledTask `
        -Force `
        -User "SYSTEM" `
        -TaskName $TaskName `
        -Action $action `
        -Trigger $trigger `
        -Settings $taskSettings `
        -Description $taskDescription
}

