### Order

- [ ] IP configuration from the customer network 
- [ ] familiarize with the order 
- [ ] is a partner involved?
- [ ] create sharepoint folder + server Questions.xlsx
- [ ] fill in server Questions.xlsx + contact details from the customer 
- [ ] support contract? ( if yes : VPN + SMB )
- [ ] create customer network on UTM or XG/XGs

### Delivery

- [ ] delivery vs. order!
- [ ] SAP name
- [ ] CPU, RAM, HDD ( SAS, SSD, M.2, NVME ), LOM, PCI-E
- [ ] others ( Riser Card, USB, Altercate )
- [ ] mount the server cover with the serial number 
- [ ] licenses after installation and assembly 
- [ ] mount the server in the rack 
- [ ] server serial numbers  ( cover + manufacturer ) and HDD's/SSD's/NVME's in SAP

### XCLARITY

- [ ] log in and check : CPU, RAM, RAID5 ( SAS, SSD ), RAID1 (M.2)
- [ ] if something is missing or wrong, correct it now 
- [ ] BMC Configuration>User: Name from *USERID* to *admin_xcc*
- [ ] BMC Configuration>User: *admin_xcc* change password
- [ ] BMC Configuration>Network: Static IP, Disable ipv6, DNS
- [ ] Store SSH keys: iSystems Support - SAP > Templates & Documents > ssh-xcc.bat
- [ ] if it is imm and not xcc: ssh to server and execute the command   `tls -min 1.2`
- [ ] Events>Alert Recipients: configure SMTP Server (IP Address: `isystems-mailing.de` Port:`587` User: `eu@isystems-mailing.de` Password: `eEu^6k95`)
- [ ] Events>Alert Recipients: Create Email Recipient (Name: `iSystems` Email: `sysmessages@isystems-integration.com` Critical: `all` Attention: `all except Power redundancy warning and Warning Power Threshold Exceeded and Non-critical Fan events` System: `Operating System boot failure and Predicted failure(PFA)`)
- [ ] Server Configuration>Server Properties: Location (Address) and Contact (Email)
- [ ] Set Time: pool.ntp.org, Sync 30, Auto Adjust Daylight Savings
- [ ] Server Configuration>Boot Options:USB,CD,HDD,PXE
- [ ] Home > System Name: "XCC - Customer - Location - S/N"
- [ ] Register the Lenovo Server
- [ ] Maximum Performance: Start the Server > F1 > UEFI Setup > System Settings > Operating Modes > Maximum Performance / UEFI Setup > System Settings > Devices and I/O Ports > PCI 64-Bit Resource Allocation = Disable and MM Config Base 3GB ([System tuning for VMware on x86 Servers and ThinkSystem - Lenovo ThinkSystem and Lenovo Server - Lenovo Support DE](https://support.lenovo.com/de/en/solutions/ht115952-system-tuning-for-vmware-on-x86-servers-and-thinksystem-lenovo-thinksystem-and-lenovo-server))
- [ ] GPT Auto Repair: Start the Server > F1 > UEFI Setup > System Settings > Recovery and RAS > DISK GPT Recovery > Automatic + save & reboot
- [ ] Fix TPM Warning in vCenter7: uefi setup > system settings > security > physical presence > toggle and enable > save, then: uefi setup > system settings > security > physical presence > secure boot config > enable > save > exit bios

### iDRAC

- [ ] system > overview: check CPU and RAM
- [ ] storage > virtual hard disk check RAID5 ( SAS, SSD ), RAID1 (M.2)
- [ ] create raid if necessary: storage>  virtual hard disk > create virtual hard disk > advanced configuration
- [ ] if something is missing or wrong, correct it now 
- [ ] iDRAC-settings > users > local user: name from *root* to *admin_idrac*
- [ ] iDRAC-settings > user > Lokale user: *admin_idrac* change password
- [ ] iDrac-settings > connectivity > network > general settings: change DNS name 
- [ ] iDrac-settings > connectivity > network > general settings: change domainname
- [ ] iDrac-settings > connectivity > network > IPv4-settings: change static IP, DNS
- [ ] store SSH keys: iSystems Support - SAP > Templates & Documents > ssh-idrac.bat
- [ ] iDRAC-settings > settings > SMTP: configure SMTP server (IP Address: `isystems-mailing.de` send email address: `eu@isystems-mailing.de` SMTP-interface number:`587` user: `eu@isystems-mailing.de` password: `eEu^6k95` connection encryption: `STARTTLS`)
- [ ] configuration > systemsettings > warning configuration > warnings: enable
- [ ] configuration > systemsettings > warning configuration > warnings > quick alert configuration: 1. all, 2. critical and warning, 3. email
- [ ] configuration > systemsettings > warning configuration > SMTP: email warning 1 enable + adress `sysmessages@isystems-integration.com`
- [ ] system > details > systemdetails > location: register location
- [ ] configuration > asset-monitoring> name of owner: `name`, systemlocation: `adress`, user-defined assets `owners email: email`
- [ ] iDRAC-settings > settings > timezone and NTP: set time zone and add time server: pool.ntp.org
- [ ] register the Dell server
- [ ] configuration > BIOS-settings > processor settings: Dell controlled turbo `enabled`

### ESXI

- [ ] VIA USB ONLY: prepare the bootstick with *ks.cfg* and */efi/boot/boot.cfg* ( `kernelopt=ks=usb:/efi/boot/ks.cfg` or `kernelopt=runweasel ks=cdrom:/EFI/BOOT/KS.CFG` or `kernelopt=netdevice=vmnic0 bootproto=dhcp ks=nfs://192.168.182.71/ISO/etc/ks.cfg`)
- [ ] VIA NETWORK ONLY: edit ks.cfg on FTP (ESXI6.5:`/isystems/vmware/iso/VMware-ESXi-6.5.0.update02-9298722-LNV-20180919_ks_nfs.txt`, ESXI7:`/isystems/vmware/iso/VMware-ESXi-7.0.1.-16850804-LNV-20200917_ks_nfs.txt`) mount ISO via NFS
- [ ] mount NFS share *B1H*: B1H, 192.168.189.100, /B1H, NFS3 ( `ssh root@192.168.189.100 -p 60022 && cat /etc/exports && exportfs -ra` )
- [ ] mount NFS share *ISO*: ISO, 192.168.182.71,  /ISO, NFS3
- [ ] create storage
- [ ] install ovftool (SFTP and SSH to ESXI, copy Ovftool to a Datastore (`iSystems Support - Netzwerke > iSystems > ovftool`), chmod -R 777 and chmod +x,alias ovftool in /etc/profile.local)
- [ ] SNMP( `esxcli system snmp set --communities mgmt;esxcli system snmp set --enable true;esxcli network firewall ruleset set --ruleset-id snmp --allowed-all true;` )
- [ ] check autostart ( active, 120s, 120s, stop, tact wait )
- [ ] Copy most important ISO to Datastore for later use (Windows, Veeam, Paragon)
- [ ] #Download/Mount ISO (sftp://vmware:Zo7ou&igoh@gebck.privatcloud.biz:55667/backup/vmware/iso)
- [ ] esxcli network firewall set --enabled false && wget https://blog.friedlandreas.net/wp-content/uploads/2014/12/ProfileESXi-Host-2.png && esxcli network firewall set --enabled true

### WINDOWS

- [ ] server vs. workstation, version, language
- [ ] create VM ( 8xCPU, 16GB RAM, 80GB HDD/SSD Thick, ISO )
- [ ] start VM and log in with default password
- [ ] drop VM into folder and customize Veeam (Hosted)
- [ ] server user=administrator, workstation user=admin
- [ ] VMWare-Tools install completely
- [ ] server Manager: hostname, diskmgmt, lusrmgr administrator PW, IPv4 Config, IPv6 off, IE-security settings, RDP, File Sharing, file extension and hidden elements, privat network (secpol.msc > security settings > network-list-manager-guidelines), green dasboard, time, energy options maximum power (powercfg -duplicatescheme e9a42b02-d5df-448d-aa00-03f14749eb61), screen never off, reboot
- [ ] windows updates > gpedit.msc > computer > administrative templates > windows-components > windows update: configure automatic updates > 4, schedule daily, 3 am, install updates for other ms products ( OR https://www.bheil.net/notes/1-klick-update-unter-windows-mit-powershell-und-chocolatey.html )
- [ ] ChocolateyStd: `choco install -y vmware-tools googlechrome notepadplusplus 7zip choco-upgrade-all-at`
- [ ] ChocolateyAll: `choco install -y vmware-tools googlechrome notepadplusplus 7zip choco-upgrade-all-at anydesk adobereader pdfcreator jre8 mobaxterm winscp putty sysinternals openvpn nirlauncher hp-universal-print-driver-pcl dotnet3.5 dotnet4.0 dotnet4.5 dotnet4.6 dotnet4.7 nettime boxstarter cyberduck bitvise-ssh-client`
- [ ] Anydesk: unattended with pw: `Tarantu95(ad)` then reboot
- [ ] install SAP B1: for terminal server & workstations install HDBClient&B1Client using `SAP.PS1`
- [ ] install SAP B1: for admin server install HDBClient&B1Client&HANAStudio&B1Components: set HANAStudio=1 before running `SAP.PS1`, then use setup wizard to install RSP,SDK,DTW,B1i (B1i=""Integration Solution Components)
- [ ] RDP login check
- [ ] cleanup `%public%\desktop`
- [ ] install language pack ( https://dennisspan.com/managing-windows-languages-and-language-packs/#CompleteInstallationScript )
- [ ] allow icmp and smb access for server 2019: `Set-NetFirewallRule FPS-SMB-In-TCP -Enabled True;Set-NetFirewallRule FPS-ICMP4-ERQ-In -Enabled True;` or `netsh advfirewall firewall add rule name="ICMP Allow incoming V4 echo request" protocol=icmpv4:8,any dir=in action=allow`
- [ ] allow access to specific ports if needed: `netsh advfirewall firewall add rule name=SAP protocol=TCP dir=in localport=80,443,1433,7299,8080,8100,8443,40000 action=allow`
- [ ] insecure guest access may be needed on 2019: gpedit.msc > computer > administrative templates > network > LanMan-workstation: enable unsecure guest login > enabled
- [ ] AV exclusions: "Serverinstallation.md > SNIPPETS > WindowsDefender.ps1"
- [ ] install license: cmd > `slmgr.vbs /ipk QPGMN-4FHPW-7PXXY-XDXTH-PWHYQ`
- [ ] add users to administrators as required
- [ ] function sysUpdateReboot {Install-PackageProvider -Name NuGet -Force;Install-Module -Name PSWindowsUpdate -Force;Install-WindowsUpdate -AcceptAll -Install -IgnoreReboot | Out-File "c:\PSWindowsUpdate_$(get-date -f yyyy-MM-dd).log" -force;shutdown /r /t 0;}
- [ ] function sysClean        {dism /online /cleanup-image /restorehealth;dism /online /cleanup-image /startcomponentcleanup /resetbase;sfc /scannow;echo y|chkdsk /x /f /r;echo j|chkdsk /x /f /r;shutdown /r /t 0;}

### Veeam 

- [ ] latest Veeam version on backup server
- [ ] new datastores: REFS, 64K
- [ ] add datastores: Veeam > Backup Infrastructure > Backup Repositories > Add Repository
- [ ] add esxi: > Inventory > Virtual Infrastructure  > Add Server
- [ ] add daily hana backup task
- [ ] add daily windows backup tasl
- [ ] add service provider: `veeam.isystems-integration.com` (only if ordered), on 192.168.191.202 Veeam > Cloud Connect > Tenants > Add Tenant

### Terminal Server

- [ ] the steps to follow are only needed if you do not have a domain. if you have a domain, use the **rds-script.ps1**
- [ ] install session host and license server
- [ ] open license manager and activate server
- [ ] add rds user cals using Service Provider Lizense Aggrement 67475361
- [ ] cmd > gpedit.msc > computerconfiguration > administrative templates > windows-components > remote desktop services > remote desktop session host > licensing > use specified remote desktop license servers > enable + enter license server (127.0.0.1)
- [ ] cmd > gpedit.msc > computerconfiguration > administrative templates > windows-components > remote desktop services > remote desktop session host > licensing > per user
- [ ] cmd > gpedit.msc > computerconfiguration > administrative templates > windows-components > remote desktop services > remote desktop session host> session time limits > set time limit for separate sessions > enable + 2 hours
- [ ] cmd > gpedit.msc > computerconfiguration > administrative templates > windows-components > remote desktop services > remote desktop session host> session time limits > end session when time limit is reached > enable
- [ ] cmd > ´gpupdate /force´

### HANA

- [ ] ESXI und HANA in hosts: `/home/ansible/hosts` ( `cd /home/ansible && ansible -m ping esxi` )
- [ ] HANA last used macs: `ssh -p 44556 root@isystems-integration.com "ls -lahr /var/www/wordpress/bz8d3ky5/controlfiles/44444*      |head -n 50"`
- [ ] Reserve Sles Mac:    `ssh -p 44556 root@isystems-integration.com "touch    /var/www/wordpress/bz8d3ky5/controlfiles/44444400444a"`
- [ ] HANA in configs: `/home/ansible/hosts/autoinst/configs/kunde.conf`
- [ ] install HANA: `screen -dRR && /home/ansible/00-scripts/02-createVM-ESXi-std-hanab1.sh kunde.conf && ssh-copy-id -i ~/.ssh/id_rsa.pub root@kundeipv4 && ansible kundehostname -m ping`
- [ ] change password
- [ ] RDP, eject CD and adjust time  
- [ ] RDP, hana studio login with secure storage
- [ ] test backup script. if demo/test system do: `ALTER SYSTEM ALTER CONFIGURATION ('global.ini', 'SYSTEM') SET ('persistence', 'log_mode') = 'overwrite' WITH RECONFIGURE;`
- [ ] ndbadm allow `echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/sapb1servertools status'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/sapb1servertools restart'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/sapb1servertools stop'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/sapb1servertools start'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/b1s stop'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/b1s start'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /etc/init.d/b1s restart'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl stop sapb1servertools'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl start sapb1servertools'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl restart sapb1servertools'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl status sapb1servertools'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl status sapinit'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl stop sapinit'>>/etc/sudoers;echo 'ndbadm ALL=(ALL) NOPASSWD: /bin/systemctl start sapinit'>>/etc/sudoers;`
- [ ] enter hardware key in serverquestions, open `https://localhost:40000/LicenseControlCenter/`
- [ ] SUSEConnect -r 133713371337 -e support_eu@isystems-integration.com
- [ ] install Tailscale if needed (on all hana servers, not on SLD, delete connection if customer has no support): `hostname="3868dd4b3b78.pve.omega.tegrous" && zypper ar -g -r https://pkgs.tailscale.com/stable/opensuse/leap/15.1/tailscale.repo && zypper ref 'Tailscale stable' && zypper in -y tailscale && systemctl enable --now tailscaled && sleep 3 && tailscale up --authkey=tskey-b12beb40c36a8a4530ef0422 --hostname=$hostname && ip addr show tailscale0`
- [ ] reconfigure backup service ( do not restart hana automatically! ): `tenant="NDB";mkdir /backup/service;mkdir /backup/service/$tenant;mkdir /backup/service/$tenant/working;mkdir /backup/service/$tenant/exports;chmod -R 777 /backup/service; chown -R b1service0:b1service0 /backup/service;`, run `/usr/sap/SAPBusinessOne/setup` > reconfigure > update backup service > backup folder: /backup/service/NDB/exports, log folder: leave as is, working folder: /backup/service/NDB/working; max size: 5000, compress: check > view changes and apply
- [ ] reconfigure public URL's for XSEngine (B1V10 only): see `Sharepoint\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Support\SAP\Hana - B1 - V10 - How To Setup Public Urls for XSEngine - App Framework in SLD.msg` OR do this: `ALTER SYSTEM ALTER CONFIGURATION ('xsengine.ini', 'database', 'HXE') SET ('public_urls', 'http_url') = 'http://XYZDOMAIN:8080' WITH RECONFIGURE;` & `ALTER SYSTEM ALTER CONFIGURATION ('xsengine.ini', 'database', 'HXE') SET ('public_urls', 'https_url') = 'https://XYZDOMAIN:8443' WITH RECONFIGURE;`
- [ ] for hana V2 only: yast > system > boot loader > kernel parameters > transparent_hugepage=never // `ALTER SYSTEM ALTER CONFIGURATION ('global.ini','SYSTEM') SET ('memorymanager','global_allocation_limit') = '65535' WITH RECONFIGURE;`
- [ ] enable at to schedule tasks `cnf at;cnf atd; zypper in -y at;systemctl enable atd;systemctl start atd`
- [ ] when partner is conplus, disable the webclient: `systemctl disable webclient;systemctl stop webclient`
- [ ] shutdown: `systemctl stop sapb1servertools sapinit && systemctl poweroff`
- [ ] adjust vm hardware if needed
- [ ] import SBODEMODE or SBODEMOUS
- [ ] write down databse port for multitenant systems (SELECT DATABASE_NAME, SQL_PORT FROM SYS_DATABASES.M_SERVICES)
- [ ] update Hana/SLD services with customer ssl certificate

### HANA UPDATE

#### BEFORE DATE OF UPDATE

- [ ] suse server review: is it necessary to update suse? `zypper sl`
- [ ] hana server review: is it necessary to update hana? `su - ndbadm -c "HDB version"`
- [ ] sld config review (make screenshots)
- [ ] backup sld license and config `zip -ur /usr/sap/SAPBusinessOne/B1_SHF/B1License.zip /usr/sap/SAPBusinessOne/ServerTools/License/webapps/lib/B1*.*`
- [ ] install config review: `cat /usr/sap/SAPBusinessOne/.installer.properties`
- [ ] install files on sld server ready to go
- [ ] install b1 config review on sld server `zip -ur /usr/sap/SAPBusinessOne/B1_SHF/B1Installer.zip /var/log/SAPBusinessOne/B1Installer_*.log`
- [ ] install b1 config review on sld server `/var/log/SAPBusinessOne/B1Installer_202107292342.log`
- [ ] edit '/etc/fstab' to use UUID and/or add disks, for example /backup
- [ ] review disk size and other system details
- [ ] review ssl certificate and renew if needed
- [ ] ssl certificate on sld server for use during installation #/usr/sap/SAPBusinessOne/Common/tomcat/cert/ttg.privatcloud.biz.pfx #sapB1iP
- [ ] win vm: prepare for uninstallation of b1: `choco install -y bulk-crap-uninstaller`
- [ ] server update scheduled
- [ ] server shutdown scheduled
- [ ] Test Export & Import dbs, upload to sftp
- [ ] Test Upgrade on the Test windows vms
- [ ] hana server disable ipv6
- [ ] hana server update /etc/hosts
- [ ] hana server update dns servers
- [ ] server update & reboot working
- [ ] server shutdown

#### DATE OF UPDATE

- [ ] veeam backup ok last night
- [ ] hana backup ok last night
- [ ] make one hana backup after sld shutdown
- [ ] update backup partition (see notes below)
- [ ] increase size of /usr/sap disk
- [ ] ndb vm: export dbs, upload to sftp
- [ ] vm snapshot create after auto shutdown
- [ ] review RAM/HDD/CPU and adjust if necessary now
- [ ] sld vm: start, stop sld services, install missing packages, maybe restart
- [ ] update/install packages as required: `zypper in -y xmlstarlet;#zypper in -y libicu60_2 libcap-progs firewalld bc glibc-i18ndata python python-openssl python-pycrypto`
- [ ] sld vm: prepare for uninstallation of b1, uninstall&install b1 using **SLD.SH** from serverinstallation
- [ ] sld vm: install b1, shutdown sld, make snapshot, start sld
- [ ] ndb vm: alter system stop database BO2;alter system start database BO2;
- [ ] sld vm: `mv /usr/sap/SAPBusinessOne_/Common/tomcat/cert/healthcare-xnull.com.pfx /usr/sap/SAPBusinessOne/Common/tomcat/cert`
- [ ] sld vm: restore b1_shf files, cleanup, systemctl stop webclient
- [ ] win vm: start, no network, stop sap services, enable network, start uninstallation
- [ ] win vm: start upgrade wizard after installation of b1
- [ ] win vm: start installation and other things noted below
- [ ] win vm: double check integration framework
- [ ] win vm: replace ssl certificate on integration framework 
- [ ] initialize db's @ :40000/Enablement
- [ ] collect b1 installation logs (C:\ProgramData\SAP\SAP Business One\Log\SAP Business One\Administrator\SetupWizard\SetupSummary) and update partner to take over
- [ ] win vm: `choco uninstall -y bulk-crap-uninstaller`
- [ ] shutdown vms and make another snapshot when done with everything
- [ ] double check vm network adapter checkmark, network should always be enabled at start
- [ ] vm snapshot delete

#### AFTER DATE OF UPDATE

- [ ] veeam backup ok last night, hana backup ok last night
- [ ] get confirmation from partner
- [ ] delete unneded snapshots or other files
- [ ] summarize
- [ ] log time
- [ ] delete LOGINS
- [ ] delete /usr/sap/SAPBusinessOne/B1_SHF_
- [ ] go sleep
- [ ] review this checklist
- [ ] review this checklist once more

### SQL

- [ ] prefer IPv4 over IPv6: `Set-Itemproperty -Path "HKLM:\SYSTEM\CurrentControlSet\Services\tcpip6\Parameters" -Name "DisabledComponents" -value 32`
- [ ] choco install -y sql-server-2019 sql-server-management-studio
- [ ] move the iso to your downloads folder and restart the windows server `C:\Users\Administrator\AppData\Local\Temp\1\chocolatey\sql-server-2019\14.0.1000\SQLServer2019-x64-ENU-Dev.iso`
- [ ] mount the iso > Maintenance > Edition Upgrade > enter key: `PHDV4-3VJWD-N7JVP-FGPKY-XBV89` (2017) `PMBDC-FXVM3-T777P-N4FY8-PKFF4` (2019)
- [ ] change the password and set sql login mode for sa user: see below **update.sql**
- [ ] set Lock Pages in Memory on 64-bit SQL Server ( sap note 1134345 ): gpedit.msc > Local Computer Policy > Computer Configuration > Windows Settings > Security Settings > Local Policies > User Rights Assignments > Lock pages in Memory > User = 'NT Service\MSSQL$SQL'
- [ ] allow connections by setting the firewall: `netsh advfirewall firewall add rule name=SAP protocol=TCP dir=in localport=80,443,1433,7299,8080,8100,8443,40000 action=allow`
- [ ] in SQL Server Configuration Manager > SQL Server Network Configuration > Protocols for SQL > TCP/IP > Enable/Activate ALL
- [ ] in SQL Server Configuration Manager > SQL Server Services > restart the SQL Server Instance
- [ ] install SAP B1: Repository,RSP,ServiceLayer,ServerTools=SLD,JobServer,SAPBusinessOneClient
- [ ] set LicenseServer IPv4: `Set-Itemproperty -Path "HKLM:\SOFTWARE\WOW6432Node\ACE\TAO" -Name "TaoNamingServiceOptions" -value "-ORBEndPoint iiop://127.0.0.1:30000 -ORBDottedDecimalAddresses 1"`
- [ ] replace 'localhost' with 'SQL' in 'C:\Program Files\SAP\SAP Business One\Conf' and 'C:\Program Files\SAP\SAP Business One DI API\Conf' xml files
- [ ] open SAPBusinessOneClient as administrator
- [ ] set ntfs and sharing permissions 'C:\Program Files (x86)\SAP\SAP Business One Server\B1_SHR' (give full permission to domain users), disable caching on the share
- [ ] move the B1 Installation folder and SQL server iso to B1_SHR folder
- [ ] import SBODEMO (copied are on the ftp in iso folder or see  `iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Support\SAP\B1_Demo_Databases_Overview.pdf`)
- [ ] verify connectivity, ie. to SLD
- [ ] reboot and verify connectivity again
- [ ] install ODBC driver on other windows servers that do not run mssqlserver: `choco install -y sqlserver-odbcdriver`

**update.sql**

```
USE [master]
GO
EXEC xp_instance_regwrite N'HKEY_LOCAL_MACHINE', N'Software\Microsoft\MSSQLServer\MSSQLServer', N'LoginMode', REG_DWORD, 2
GO
ALTER LOGIN [sa] WITH PASSWORD=N'Test1234'
GO
ALTER LOGIN [sa] ENABLE
GO
```

### SYNOLOGY

[ ] create admin user 'isystems' and note the password
[ ] check details of the nas: what services are running, users&groups, storage, ipconfig, apps installed, what is actually being used
[ ] disable all unused services, harden security
[ ] install missing packages if needed (maybe tailscale?)
[ ] create share 'veeam', remove all permissions, only for isystems user and ip of veeam backup server @ nfs
[ ] add share to veeam backup server via NFS
[ ] add backup job OR copy job, adjust archiving if you have a lot of space on NAS
[ ] install ActiveBackupforBusiness+o365: see below, update ip+user+passwd+serial_number

**ActiveBackupforBusiness**
```
http://127.0.0.1:5000/webapi/auth.cgi?api=SYNO.API.Auth&method=Login&version=1&account=admin&passwd=lala
http://127.0.0.1:5000/webapi/entry.cgi?api=SYNO.ActiveBackup.Activation&method=get&version=1
http://127.0.0.1:5000/webapi/entry.cgi?api=SYNO.ActiveBackup.Activation&method=set&version=1&activated=true&serial_number="1234"
http://127.0.0.1:5000/webapi/entry.cgi?api=SYNO.ActiveBackupOffice365&method=get_activation&version=1
http://127.0.0.1:5000/webapi/entry.cgi?api=SYNO.ActiveBackupOffice365&method=set_activation&version=1&activated=true&serial_number="1234"
```

### SAP WEB Acces

- [ ] robot.s-dns.de : general > nameserver > P > edit Privatcloud.biz 
- [ ] A-records add
- [ ] open openssl.cnf (below) and copy to /tmp/openssl.cnf
- [ ] fill SSL.sh (below)
- [ ] run SSL.sh on Hana server 
- [ ] install certificate windows server (admin: pfx, all others: cls)
- [ ] admin server firewall: `netsh advfirewall firewall add rule name=SAP protocol=TCP dir=in localport=80,443,1433,7299,8080,8100,8443,40000 action=allow`
- [ ] install browser access (admin server)
- [ ] external mapping in ControlCenter
- [ ] restart sld `/etc/init.d/sapb1servertools stop && /etc/init.d/sapb1servertools start` 
- [ ] restart windows server
- [ ] open https://sap.domain.privatcloud.biz:8100/Dispatcher and see if it opens without warning

### RDS HTML5

- [ ] edit the `rds-domain.ps1`dont forget to change the users at the end of the script and run it on your PC
- [ ] max performance (gpo (groupguidelines) "computer > administrative templates> system > power management > set user-defined active power plan" (e9a42b02-d5df-448d-aa00-03f14749eb61))
- [ ] edit the `rds-script.ps1` and run it on the DC
- [ ] open license manager and activate server
- [ ] install license (service provider license aggrement, 67475361), per user 
- [ ] session time limit
- [ ] create settings script
- [ ] try to use the webinterface with a few user
- [ ] import the certificate and save it on the B1_shf share

### AUFRÄUMEN

- [ ] HANA DISK6 /tmp und DISK7 /backup auf HDD
- [ ] ESXI Backup and save on Sharepoint (Kunde-ESXIname.tzz)(`/bin/firmwareConfig.sh --backup /tmp/` `/bin/firmwareConfig.py --restore /tmp/`)
- [ ] Proxmox Backup and save on Sharepoint: `wget -q -O /root/prox_config_backup.sh https://raw.githubusercontent.com/DerDanilo/proxmox-stuff/master/prox_config_backup.sh;cd /root;myDir="/root/backup";mkdir $myDir;export BACK_DIR="$myDir";chmod +x /root/prox_config_backup.sh;./prox_config_backup.sh`
- [ ] server Questions & SAP: update usernames and passwords
- [ ] create Thycotic folder
- [ ] test autostart and change VM version (z.B. SUSE 12 to SUSE 15) and upgrade VM compatibility (z.b ESXI6.5 to ESXI 7.0)
- [ ] remove all NFS shares from Esxi
- [ ] VPN and SMB
- [ ] licenses
- [ ] print server Questions (incl. checklist)
- [ ] server VPNs+Backups.xlsx
- [ ] hosting Excel (only Hosting server)
- [ ] backup table
- [ ] wrap up server
- [ ] delivery with Jessi
- [ ] customer network UTM

### customer leaving

- [ ] remove system from monitoring
- [ ] system shutdown and wait for next backup then remove VMs from the host
- [ ] disable not delete in UTM (network, interface, firewall, vpn, users)
- [ ] update sheets: server VPNs+Backups + Hosting
- [ ] zip sharepoint folder: customer-left.zip

### SSL VPN

- [ ] support > advanced > routes : Look for already existing network
- [ ] interfaces & routing > interfaces > additional address : add additional address 
- [ ] definitions & users > network definitions > network definitions: create new network definition
- [ ] definitions & users > users & groups > groups: create new group if not yet available
- [ ] remote access > SSL > profiles > new remote access profile: create SSL VPN with the created group and at the new created network
- [ ] definitions & users > users & groups > users : download SSL VPN packages for the users and then put the packages on the FTP

### VM Restore

- [ ] choose in Veeam the VMs
- [ ] restore it to a new location
- [ ] change host and datastore (backup network & Hana HD 4 and 5 eager)

### WINDOWS SYSPREP

- [ ] go to audit snapshot and boot system, update.cmd (few times), reboot if windows update, upgrade.cmd, sysprep audit reboot, sysprep audit shutdown, create update snapshot
- [ ] scan.cmd, clean.cmd, sysprep audit reboot, wisediskcleaner, sysprep audit shutdown, create snapshot audit
- [ ] sysprep oobe unattend ( set correct xml before running, ie. w2k19en )
- [ ] scsi mode sas, boot paragon, defrag & compress mft on all partitions, shutdown, set iso to guest local, scsi mode paravirtual ( + add "PG_Customer" nic for Klaus )
- [ ] make ova `myVM="" && myFolder=/vmfs/volumes/etc/VSO && mv "$myFolder/$myVM.ova" "$myFolder/$myVM.ova.bak" && ovftool --noSSLVerify "vi://root:Tarantu95@127.0.0.1/$myVM" "$myFolder/$myVM.ova"`
- [ ] test ova `myVM="" && myFolder=/vmfs/volumes/etc/VSO && ovftool -n="$myVM" -ds="NVME2" -dm="thin" "$myFolder/$myVM.ova" "vi://root:Tarantu95@127.0.0.1"` or `ovftool -n="lala" -ds="NVME2" -dm="thin" "ftp://vmware:secret@192.168.191.23:21/iso/win10.ova" "vi://root:Tarantu95@127.0.0.1"` or `cd /vmfs/volumes/RAID10 && wget "ftp://vmware:secret@192.168.191.23/iso/win10.ova" && echo run ovftool as usual`
- [ ] compare ova size, revert to last audit snapshot, delete all snapshots, cleanup scripts folder, sysprep audit shutdown, create audit snapshot
- [ ] exchange ova on other locations ( ie. our ftp, ansible servers, etc.?! )
- [ ] `\\192.168.195.6\etc\VSO\`
- [ ] `\\192.168.191.23\Transfer\isystems\vmware\ova\`
- [ ] `\\192.168.191.100\B1H\ISO\`
- [ ] `\\192.168.191.102\B1H\ISO\`
- [ ] `\\192.168.191.103\B1H\ISO\`
- [ ] `\\172.16.191.100\B1H\ISO\`

### WINDOWS CLEANUP & UPDATE

```
$drive="c"
repair-volume -driveletter $drive -scan
repair-volume -driveletter $drive -spotfix
repair-volume –driveletter $drive -offlinescanandfix
echo y|chkdsk /x /f /r;shutdown /r /t 0
sfc /scannow
dism /online /cleanup-image /restorehealth
Install-PackageProvider -name NuGet -Force
Install-Module -name PSWindowsUpdate -Force
Get-WUInstall -AcceptAll -AutoReboot
Get-WUInstall -MicrosoftUpdate -AutoSelectOnly -IgnoreReboot -IgnoreuserInput -Confirm:$false | Out-File C:\PSWindowsUpdate.log
Install-WindowsUpdate -AcceptAll -Install -AutoReboot | Out-File "c:\PSWindowsUpdate_$(get-date -f yyyy-MM-dd).log" -force
$servernames = "server1, server2, server3"
Invoke-WUJob -Computername $servernames -Script {ipmo PSWindowsUpdate;Install-WindowsUpdate -AcceptAll -Install -AutoReboot | Out-File "c:\PSWindowsUpdate_$(get-date -f yyyy-MM-dd_hh-mm-ss).log"} -RunNow -Confirm:$false
#https://www.action1.com/kb/installing-Windows-updates-remotely-with-the-PowerShell.html
#http://woshub.com/pswindowsupdate-module/
dism /online /cleanup-image /startcomponentcleanup /resetbase
#dism /online /cleanup-image /spsuperseded
#dism /online /cleanup-image /restorehealth
sfc /scannow
#sfc /scannow /offbootdir=d:\ /offwindir=d:\windows
```

### SAP SSO
$Domain = "RZ.TOBOL.DE"
$username = "sapsso"
$password = "secret"
$Firstname = "SAP"
$Lastname = "SSO"
New-ADuser -SamAccountname $username -userPrincipalname "$username@$Domain" -name "$Firstname $Lastname" -Givenname $Firstname -Surname $Lastname -Enabled $True -ChangepasswordAtLogon $False -Displayname "$Firstname $Lastname" -Accountpassword (convertto-securestring $password -AsPlainText -Force) -passwordNeverExpires $true
setspn -U -A $username/$Domain $username
#/usr/sap/SAPBusinessOne/setup>reconfigure>use domain auth,fqdn=rz.tobol.de,domain-controller=10.2.41.3,domain-user-name=sapsso,password=secret
#open sld > security > enable/update sso in order to check if the connection establishes, disable it again

### Azure AD sync Mailstore

- [ ] https://help.mailstore.com/de/server/Synchronisieren_von_Benutzerkonten_mit_Microsoft_365_(Modern_Authentication)

### Rack Setup

- [ ] check address
- [ ] check devices or orders
- [ ] position rack appropriately
- [ ] screw on grounding
- [ ] adjust rails
- [ ] mounting devices
- [ ] take a picture of the devices, as well as the numbers
- [ ] name devices (label)
- [ ] connect the devices (z.B. Switch, Firewall, AP...)
- [ ] set up firewall
- [ ] set up switches
- [ ] set up accesspoint
- [ ] run tests
- [ ] lay cables neatly
- [ ] netbox
- [ ] fill empty spaces with bubble wrap
- [ ] check delivery bill and shipping address
- [ ] pack and secure properly

### NFS

DCDUS:192.168.191.23:/ISO/
DCTPA1:172.16.195.199:/ISO/
DCTPA2:172.19.1.32:/volume1/ISO/
MG:192.168.182.71/ISO/


### SNIPPETS
**ovftool.sh**

```bash
ovftool -n=(Name) -dm=(thin,thick,eagerzeroedthick) -ds=(HDD,SSD,NVME...)"(Win 	version 	zum Installieren (.ova))" "vi://user:password@127.0.0.1"
```

**ovftool1.cmd**
```batch
::https://armann-systems.com/download/vmware-ovftool-4-2-64bit-for-windows/
set ovftool="C:\Program Files\VMware\VMware OVF Tool\ovftool.exe"
set ova="\\192.168.182.71\i\Win_Server_STD_CORE_2019_64Bit_German_DC_STD_MLF_X21-96583.ova"
%ovftool% -n=sap-b1i -dm=thick -ds=SSD "%ova%" "vi://root:Tarantu95@192.168.182.42"
```

**ovftool2.cmd**
```batch
set "ovftool=c:\tmp\ovftool.exe"
set  "ovadir=\\127.0.0.1\c$\tmp"
set  "ovaWin=%ovadir%\server2019std.ova"
set "ovaSles=%ovadir%\sles15.ova"
set "esxAddr=127.0.0.1"
set "esxUser=root"
set "esxPass=lala"
set "esxConn=vi://%esxUser%:%esxPass%@%esxAddr%"
set "esxData=ESXI-SSD-DATASTORE-NAME"
::import
echo "%ovftool%" -n=2k19 -dm=thick -ds="%esxData%"  "%ovaWin%" "%esxConn%"
echo "%ovftool%" -n=sles -dm=thick -ds="%esxData%" "%ovaSles%" "%esxConn%"
::export, in case needed
echo "%ovftool%" --noSSLVerify "%esxConn%/2k19" "%ovaWin%.bak"
```

**Reboot.ps1**
```powershell
$dom=".";$usr="administrator";$pwd="Test1234";$servers="192.168.1.134";$tskName="Reboot";$tskDelay="5";$tskDateTime="2021-08-03 03:06:00";$tskCommand="Install-WindowsUpdate -AcceptAll -Install -IgnoreReboot | Out-File c:\PSWindowsUpdate_$(get-date -f yyyy-MM-dd).log -force;shutdown -r -t $Using:tskDelay;schtasks.exe /delete /f /tn $Using:tskName"
$usd="$dom\$usr";$pwd=ConvertTo-SecureString -AsPlainText $pwd -Force;$crd=New-Object System.Management.Automation.PSCredential -ArgumentList $usd,$pwd;Invoke-Command -ComputerName $servers -Credential $crd -Scriptblock {
 $tskPrincipal="NT AUTHORITY\SYSTEM";$tskDateTime=[Datetime]::ParseExact($Using:tskDateTime, 'yyyy-MM-dd HH:mm:ss', $null);$tskBase64Cmd=[Convert]::ToBase64String([Text.Encoding]::Unicode.GetBytes($Using:tskCommand));$tskAction=New-ScheduledTaskAction -Execute "powershell.exe" -Argument "-NoProfile -ExecutionPolicy Bypass -EncodedCommand $tskBase64Cmd";$tskTrigger=New-ScheduledTaskTrigger -Once -At ($tskDateTime);$tskPrincipal=New-ScheduledTaskPrincipal -UserID "$tskPrincipal"
 Register-ScheduledTask -TaskName "$Using:tskName" -TaskPath "\" -Action $tskAction -Trigger $tskTrigger -Principal $tskPrincipal -Force
}
```

**UpdateReboot.ps1**
```powershell
<#install updates and automatically reboot if needed, after reboot, windows updates will continue to run until no more updates are available.PARAMETER URL (User the Computer parameter to specify the Computer to remotely install windows updates on)#>
[CmdletBinding()]
param (
[parameter(Mandatory=$true,Position=1)]
[string[]]$computer
)
ForEach ($c in $computer){
 #install pswindows updates module on remote machine
 $nugetinstall = invoke-command -ComputerName $c -ScriptBlock {Install-PackageProvider -Name NuGet -MinimumVersion 2.8.5.201 -Force}
 invoke-command -ComputerName $c -ScriptBlock {install-module pswindowsupdate -force}
 invoke-command -ComputerName $c -ScriptBlock {Import-Module PSWindowsUpdate -force}
 Do{
  #Reset Timeouts
  $connectiontimeout = 0
  $updatetimeout = 0
  #starts up a remote powershell session to the computer
  do{
   $session = New-PSSession -ComputerName $c
   "reconnecting remotely to $c"
   sleep -seconds 10
   $connectiontimeout++
  } until ($session.state -match "Opened" -or $connectiontimeout -ge 10)
  #retrieves a list of available updates
  "Checking for new updates available on $c"
  $updates = invoke-command -session $session -scriptblock {Get-wulist -verbose}
  #counts how many updates are available
  $updatenumber = ($updates.kb).count
  #if there are available updates proceed with installing the updates and then reboot the remote machine
  if ($updates -ne $null){
   #remote command to install windows updates, creates a scheduled task on remote computer
   invoke-command -ComputerName $c -ScriptBlock { Invoke-WUjob -ComputerName localhost -Script "ipmo PSWindowsUpdate; Install-WindowsUpdate -AcceptAll | Out-File C:\PSWindowsUpdate.log" -Confirm:$false -RunNow}
   #Show update status until the amount of installed updates equals the same as the amount of updates available
   sleep -Seconds 30
   do {$updatestatus = Get-Content \\$c\c$\PSWindowsUpdate.log
    "Currently processing the following update:"
    Get-Content \\$c\c$\PSWindowsUpdate.log | select-object -last 1
    sleep -Seconds 10
    $ErrorActionPreference = ‘SilentlyContinue’
    $installednumber = ([regex]::Matches($updatestatus, "Installed" )).count
    $Failednumber = ([regex]::Matches($updatestatus, "Failed" )).count
    $ErrorActionPreference = ‘Continue’
    $updatetimeout++
   }until ( ($installednumber + $Failednumber) -eq $updatenumber -or $updatetimeout -ge 720)
   #restarts the remote computer and waits till it starts up again
   "restarting remote computer"
    #removes schedule task from computer
   invoke-command -computername $c -ScriptBlock {Unregister-ScheduledTask -TaskName PSWindowsUpdate -Confirm:$false}
    # rename update log
    $date = Get-Date -Format "yyyy_MM_dd_hh-mm-ss"
    Rename-Item \\$c\c$\PSWindowsUpdate.log -NewName "WindowsUpdate-$date.log"
   Restart-Computer -Wait -ComputerName $c -Force
  }
 }until($updates -eq $null)
 "Windows is now up to date on $c"
}
```

**WindowsDefender.ps1**
```powershell
Add-MpPreference -ExclusionPath      "C:\Program Files\sap","C:\Program Files (x86)\sap","C:\ProgramData\sap","C:\Program Files\Microsoft SQL Server","C:\Program Files (x86)\Microsoft SQL Server"
Add-MpPreference -ExclusionProcess   "CKS.Startup.exe","conSHIP.UI.exe","coresuite.exe","SBO.BAB.exe","SBO.PRD.exe","B1Browser.exe","SAP Business One.exe","SAP Business One (x86).exe","B1ClientAgent.exe","explorer.exe","rdpclip.exe","RuntimeBroker.exe","spoolsv.exe","sqlservr.exe","sqlwriter.exe","vmtoolsd.exe","AgentConsole.exe","AgentService.exe","B1ClientAgent.exe","SBO.APP.Backend.exe","SBO.APP.exe","DTW.exe","httpd.exe","tomcat7.exe","sqlbrowser.exe","sqlceip.exe","sqlservr.exe","sqlwriter.exe"
Add-MpPreference -ExclusionExtension ".log",".txt"
```

**CHOCO.CMD**

```shell
@"%SystemRoot%\System32\WindowsPowerShell\v1.0\powershell.exe" -NoProfile -InputFormat None -ExecutionPolicy Bypass -Command " [System.Net.ServicePointManager]::SecurityProtocol = 3072; iex ((New-Object System.Net.WebClient).DownloadString('https://chocolatey.org/install.ps1'))" && SET "PATH=%PATH%;%ALLUSERSPROFILE%\chocolatey\bin"
```

**PSEXEC.CMD**

```shell
psexec \\remoteipv4 [-u usr[-p pwd]] cmd [arguments]
net use \\remoteipv4\c$ /user:usr pwd
copy c:\sophos\sophossetup.exe \\remoteipv4\c$
psexec \\remoteipv4 -u usr -p pwd -i c:\sophossetup.exe --quiet
psexec \\remoteipv4 -u usr -p pwd -w c:\windows\system32 schtasks /create /tn Task1 /xml:%windir%\setup\scripts\task1.xml /ru usr /rp pwd
del \\remoteipv4\c$\sophossetup.exe
mstsc /v:remoteipv4 /user:usr pwd
psexec \\remoteipv4 -u usr -p pwd -i "C:\Program Files (x86)\Sophos\Management Communications System\Endpoint\Uninstall.exe"

```

**ABB.txt**
```
#https://gist.github.com/igresc/91e468f3d2ad5f2f7407262ba6f0dd56
http://192.168.1.111:5000/webapi/auth.cgi?api=SYNO.API.Auth&method=Login&version=1&account=admin&passwd=secret
http://192.168.1.111:5000/webapi/entry.cgi?api=SYNO.ActiveBackup.Activation&method=get&version=1
http://192.168.1.111:5000/webapi/entry.cgi?api=SYNO.ActiveBackup.Activation&method=set&version=1&activated=true&serial_number="1690O7N149203"
```

**KS.CFG**

```shell
#https://www.virten.net/2017/02/vcenter-service-appliance-6-5-tips-and-tricks/
#VMware-ESXi-6.5.0.update02-9298722-LNV-20180919.iso
accepteula
rootpw Tarantu95
install --ignoressd --firstdisk=usb --overwritevmfs --novmfsondisk
network --bootproto=static --device=vmnic0 --ip=192.168.192.3 --netmask=255.255.255.240 --gateway=192.168.192.1 --nameserver=9.9.9.9 --hostname=esxi.devnet.local
keyboard German
reboot
#%pre
#%post
%firstboot --interpreter=busybox
vim-cmd hostsvc/enable_ssh
vim-cmd hostsvc/start_ssh
vim-cmd hostsvc/enable_esx_shell
vim-cmd hostsvc/start_esx_shell
esxcli system settings advanced set -o /UserVars/SuppressShellWarning -i 1
esxcli network ip set --ipv6-enabled=0
esxcli system hostname set --fqdn=esxi.devnet.local
esxcli network ip dns search add --domain=devnet.local
esxcli network ip dns server add --server 1.1.1.1

#NTP
cat > /etc/ntp.conf << __NTP_CONFIG__
restrict default kod nomodify notrap noquerynopeer
restrict 127.0.0.1
server 0.europe.pool.ntp.org
server 1.europe.pool.ntp.org
server 2.europe.pool.ntp.org
server 3.europe.pool.ntp.org
__NTP_CONFIG__
/sbin/chkconfig ntpd on

#TRIAL
#rm -r /etc/vmware/license.cfg && cp /etc/vmware/.#license.cfg /etc/vmware/license.cfg && /etc/init.d/vpxa restart

#SSH
#/home/ansible/files/00-all_keys.txt
cat > /etc/ssh/keys-root/authorized_keys << __ALLE-KEYS__
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiak2aW6hwqeTs4/+oA/y09AXCjjc4EEKTmOaU0AIXY1OMD/syVz4rHV8VLohcE6tmzjzXZDmDuFSY7XnoBrBJR/ZEfCbQFCpaOQ1VZ7Z/BtRagPkjsZxUpeQ6+VQz8VmsCfxI4nhg19OOk2gBv0/hQD1HGmE2Rcu0JL2l4maZJUnCcCYhsb7j+m9B/jissncI59XjBGUSfIgixId0uUbcpW/Ze67HdhcTaImlra5zC+RPdJJSLfrlyRP+G1sDHNaS/fJXk7oLIOHpQo0zifDUkcWcKlWR201WG8pIjmUsoaBuGO69y/KIqR3fJoWArDD3uKzAqkmC2PoZYa5OWhBd root@HCC-02 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCxo9UZTTksrYaTU8UVHIa6wb5+kpywel5j2kSpkYG9ibb+6zOE+VzchRAm03Gtw7Y5CT9VAQdHpCvaZJn2flxb73vU0gO/acKSRIhINz/QO33bYQnN5gX7D53Vy7TlY259/kHfOvIUGq3BF+lYF4wHrOhEbVMwjCJrH2NQfmmsfPtS6prGJba+dh0FV4K4jkX6fD9vxLST7ulbrssUxF9PcGRVmI0FOYVI2YWBZMaJp1QVLo/vwEQbDH4PCMiMOtBX5C6ot7dUgu2H+nmEeu0LWaQh+JYP3jR7yOfFLD6mkVoAkZDLkljEMJxhC21TZpbtgTf9CeTWEVj0qnIxsxml root@HCC-RZL3-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDClquILDs6oqokrkNS4WjKt3mh0rBuXM6VOpjKT5WV3cqiogZ8AP7tHQAIYjEPdkqDi9i7nSLEHsYV8t+Lc7W5A5DBeiSG27Fhf5H/RVbXY1TMmoMpnqAHbFVRiOY1rv9gp7j9Vu7uOYSKnVQnH7dra1N4HdBaGo/uuM3mPZCaOgqLl3RBATb0dU8mTW/eznrb69rYK3gw9U1/u0v6SopPLLBMkYQSx/jadr/L7gAIRa9yu+5sngt4jewAsqC4puU7xunjJndKGnWseYcyOzmYub2p5ce7Gia/j1RbPOF3++vwpiZAfi4clny+Ra8fwlgb9TLU+CS3bVBlBUIlfZjd klaus@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC7c2DfsgOCNSrX8GwwudGGMbmSyigGnv6bM4yCXhbE2wnPhBdF02N2JZxa1URgbaT69Q/U+Gnv7GwC0ZnJUixPcz7eNj3/U9uHstwk7FSxBfAot+M8svSE7kSLoFxf3l99QdbHneNa67K4g2pukbwtjmypChGp7X0f/gixa8VmSvGbIrwAYhZyAvXCPYPY+HFnvVz0z2KR4taq2t5gbBdpW/F/ppV4KpNDZDgkFaFSQ1EKFPWGrsetbwE6vWaPwm+JcH08CgL8fbv9JvMJmPCtkOtluIwsPV6eSLpv81v9digDYmbgYufBmrbmaplHhUaps3iA59tZReH+WVOgQHMf root@Lenovo-P310 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCz2BbQyhA75M+goDLoQeQqhqQkyoYduweOxxndza8dPhCoWIF2tZFie0SPae8TFOspQ0OMHrwxCNyWsUomSxYmRi7u24+gAcV19/ZN3USlGObJ1tscx1QIucUJ2iikNuAo8pu5PpHvRBvqQ13ZZvRXidLTRK60UkQMOPhCviNIRLn9kh5iOI6NxAbaiojPaMdyr5SS0ExUX0PBXpdFcYeLXfBNA4RMyNBC3vWGalEMcbTvQ+KtMY55oSg+69+jhGPccuY2MmwNdP1aFpBxhSuyIu/wa/lD//zHSraY0QgxuTFzw1oTWlvXApeFNT3WJydrpc1TnEvJ6EZiMooDhjet klaus@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCsDPj4VCKj8Aab8QGDdsL2YEL+eBiKiTzBHFgRfxxd485GtVvfYEM7ElnEVEkjFU1rP6VZcSP/k/13vlkfaMHCs1ep2dmYon7UvXiKd6LTEz1thgDL2OdRVDluL5lTPxCF5LM/wQEbrI31cRs/H2g1GE3TUcC2uYtPnoN6ZDAwdqze2sIFqF/HJPOnStGaQk89IFonvetYSBwxLdqzQ9UE4yHA5vC2nplJ5+Lzifn0wdaYikyMMFgU6iHxeJLwYO9IFVzLtuy/hV11NNCczJhZ78B883aPe6Uz7vVH7PrzFYpRhRMfD/v585wHAaD2ifa4QTGZ2v8EP+Bfdx1RkRxp root@X349m 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCfZuhHrytwVj8SbzDWG+aUhxqyyP1szL1jHUqxmH8SIawLrl3aEpwXFFRxn+NeMlKktuHFBzmp07IQJspYQCE15nqJeUkB8LlMKeV7AyfKrPCDUICo1F6CweEaGduR0LKlyIBlI6uzwvdX7xJ8IvvFXXy1SSXJweecxHxkQvtSFS5uC4ba1VJqPoPTLms1+YyTLB1IFrM18qcu4vJsPrILsq2/x1773THQ2uFVfROwwi0S7HbjwKkeZDuqGtwDcn8LZ+tCsO83tSVyRheImIdDNSatQLJu7fFXp8w6w5H/RvLL5K8ihcwGs35xJ90jh6eOPLhbPxiKgrXVXVAgLK2F root@HMC-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDBejZNhe/b5G5osjHujDF/I+l27RBKEK4pso73M4JtyBFD0XpsloifA4b0/AF2p9fjV0pf79rfWmRaAeZl+mKALuaGnUc17CjI0omw977pQLhOVXYQDAC4yhUbk63FaIwyQ49WXKTnzbPC2h+LSWK9aOKBejSdibnM2hYMvnSZg69ckFySTNsto6vC4dYGyy/zttERTyLczE2dsSZy2kdytwurB724EiE6vuBHDYgwp796Mjp4FTDXOg9NPEvqBPhlLDPQ3YaV2pZhzn579O2vxM4XUtXqcx5NckgFgdBUnQupFQVMDlyvlf3GAUl7kt1S8dDNeWrRSpxWFaQWeEXx root@dctpa-hcc-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDiCpHdqyjOlGLAjEpYqhH+Hdrd71e6gRxJN3h1DWgubK0ygP2oltEaO5isFnsw31K4oQJly86XaxiWpBDGYuDawiUTWS4HpLMBJROqiUo3sGGis6/1hxJdsA5aBo99mnVedqLWSOzaGf3gEBMMpaUlI6IlHrQYbAB8IEd8AklqGb8eOv/0eGqPdBzTbcWQF93O/2RDux09aMfDcNaCT3i0pVGKE9eG4n/KTdp7FkwRwEPIhCwc3+Y8KX7B4PzIGlGIQ+wLUG94ebTtItgV2C65g/iXSM6Njg8nBs+whlO+zxpU4i0wy4KWDdt9GfMJedLgfLClLR9K0I3dSheT339H skamphoff@saskia.local 
ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAQEAyh9JmipuyW5kk4LsvtxD5aiwYXQYdWAXMgKGJcOHm5XGP4R62nwjvCPS0JuXMQRyvayy9EjKfnZ4BzF0zacDMNwOgZDubMxy0bHt0XKyO1lpKVQJBWBUeAZtzfMceo/NYPX/WC6FlBFI9p5NIsTCU4BkTaLJt3si7z865hkxxzBvv4KpebyWbdCqRcGbohwbgwZQvmWZSiwfBnlfR0vQWleZVDv8HIHrfKxnuYYzeO0LSNcDn4flknVNZhB3ClDjXAZBpqpjST3nvoUOdtvBzEYSutZ9TiEBzXhuHmHKLrwlpX5s448xXsECXDBuK7Tn5W/z6y0cX0z6BtBz1gyrWQ== rsa-key-20181010-michael-notebook 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDDAj5HEdPDycwWXFkOb0A+eS2unzh7ruONNsqqLmDBrxwD25wD7K1bx8gF7HM5bVNzleoWoR5w4vLMwS5bnLAUXwkQ8VevEWruaaFThQpUj9QOIedjVo77j9aEcXaw0X6V/gjX/zSsX6fV+H4M992Y/4GSgrAlP0r5REmc8t6mAidHqe25D1fTgBy2jCYksJmetT7Gy+HCBUp00aJo1BHbqMLvclklfZB6nrEQCxlWjDK9CPfGTxVfF/IA6y1o61QanHQ1i1G2Kf7nZNVpRsv+hnIh8KuKdwz8WRgJp1Nwv8UBINE9VfJOEI7FWPq6/sJxeSXNR3IbjoNJxXcsxDSB root@HCC-MG-01 
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCsF9dX9iBJWCgp5NSQFuX0k9+hx69xeRV0h5qVjc4fHJ4Ur61t9ltz2kQIjX9R0HYu1KMoweVBjwNr1cAFIk18XotP5KdR/Xdbpyo1ghcQB5u1HLtdkMCeO0HXNPc02o6ZQ0SGnXXKGI/4umL4iEDaq82yyhRa548BjA+Iio+FJ6kzf/88NkUGoc5UNFTUG7lpQcqyGnlv83jKfH85Psr0j3lyVVHqLT6U++yKurD0LUD7tuhvP29qhSjyuioFtsBotj7haaeQyg4HnTIazGNP/Jz0WCOSyTuNrvj1GlIQK4XzvHglbZi15zMbm3loXA7ryMqIAO2YdwCDKYS9KpccTEf2EWtal1dPBz/m3n8VyeUv7J8HXReVM7+OfM3gNiutf5A4XB7eTLXFwP1AL1Krh2cG/SUVwARcmLGE2PLA+N3xfZ3iQTfONrFaKjB9Y+g7PSh9+Whtf8xX/ytdRo98uUjyejJQgZITIUHQyB2uFpkDe/0Ku8Sjv0RX5ubw+GE= root@hcc-mg-03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDIEJTbMPJbwO4mrllHoshZSEz3TSqkVlAI0d/N1+Jxrwt3E3z98w9kMMc7XkINtN9THBTkmXi2MJorABzLtk6wiDivTfBHTp27BaGkeBYfa9XM6c6I4LSYouiTG3TcGRhd0imtQnTvosGXYJOerrlVcZlBpOz9XEcmjD4Fgfy3n/jRJHkWGgt07f8P+SBEIkeDIsf8DJQ9Bm5Ap04A0JKlJ7NenmBieQNJ0ZKCrfN5L2AdQ1fONBpiet0WnSGqUZnbL7MonwMhLdFusSEbj3eSGOmPxWM9cl9DX2KRqxDwWZfcumBomX01nxyelx9mIPgsFJDRCl43NN+TTUumG/E7 root@dcdus-hcc03
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC4EhIIhIf0hyGjDOQMTVWYdcUHqrklNKVX5ldGEg7OJ0SuwWJbZJeAcqgkGVAh7GRchgHC3RrIurITcOQO6Tdpj8Fy7K48oN8AlMd3yAACchuDeXY8ADSSd4mfcsRjdoepif8JMoVATE2fRvyrqHD+KYwppv+zcvb+Dp6kCxDuuwx/3gsUiBlOUQRcQAeK51OQvdxAicxewS95qYFoqVfMNm04zf436XNEyWHo2Fpn/DGzn3m/onBSu5zjcG4xc2LA3yBFmrr0Ba2+1Z0MmZRiCo7JEbK4AjGW68+L8s0h4wyrIh/o0g8NWacFq4pJBtzUh3w+XSJCEP104lOvDMM3 isystems\stuecking@Samuel-L13
__ALLE-KEYS__

#USB
#chkconfig usbarbitrator off
#/etc/init.d/usbarbitrator stop

#PARTITION
#esxcli storage core path list
#ls /dev/disks
#disk=/dev/disks/vmhba33:C0:T0:L0
#partedUtil mklabel $disk gpt
#eval expr $(partedUtil getptbl $disk | tail -1 | awk '{print $1 " \\* " $2 " \\* " $3}') - 1
#partedUtil setptbl $disk gpt "1 2048 30025484 AA31E02A400F11DB9590000C2911D1B8 0"
#vmkfstools -C vmfs6 -S USB $disk:1

#SCRATCH
#cat /etc/vmware/locker.conf
#cd /vmfs/volumes/5c8773b0-d809b8e8-4caf-7cd30a5f9e70/
#mkdir -p esxi/scratch;cd esxi/scratch
#vim-cmd hostsvc/advopt/view ScratchConfig.ConfiguredScratchLocation
#vim-cmd hostsvc/advopt/update ScratchConfig.ConfiguredScratchLocation string /vmfs/volumes/5c8773b0-d809b8e8-4caf-7cd30a5f9e70/esxi/scratch
#vim-cmd hostsvc/advopt/view ScratchConfig.ConfiguredScratchLocation

# fix sel fulness ipmi
#localcli hardware ipmi sel clear && /etc/init.d/sfcbd-watchdog restart && services.sh restart &tail -f /var/log/jumpstart-stdout.log

#Klaus Joerissen [Mar 7, 2019 9:58:25 AM] 
#192.168.189.100:/B1H/install/HANA/SPS12rev122.22.tgz
#192.168.189.100:/B1H/install/B1/9.3/SP10HF0.tgz
#192.168.189.100:/B1H/ISO/SLE-12-SP4-STD-isystems.iso
#das sollte erst mal reichen
#echo "starting"
#source=/vmfs/volumes/B1H
#destin=/vmfs/volumes/USB
#cp $source/ISO/SLE-12-SP4-STD-isystems.iso $destin/ISO
#cp $source/install/HANA/SPS12rev122.22.tgz $destin/install/HANA
#cp $source/install/B1/9.3/SP10HF0.tgz $destin/install/B1/9.3
#echo "finished"

#esxcli network vswitch standard add --vswitch-name=vSwitch0 --ports=24
#esxcli network vswitch standard uplink add --uplink-name=vmnic0 --vswitch-name=vSwitch0
#esxcli network vswitch standard uplink add --uplink-name=vmnic1 --vswitch-name=vSwitch0
#esxcli network vswitch standard uplink add --uplink-name=vmnic2 --vswitch-name=vSwitch0
#esxcli network vswitch standard uplink add --uplink-name=vmnic3 --vswitch-name=vSwitch0
#esxcli network vswitch standard policy failover set --active-uplinks=vmnic0,vmnic1,vmnic2,vmnic3 --vswitch-name=vSwitch0
#esxcli network vswitch standard portgroup policy failover set --portgroup-name="Management Network" --active-uplinks=vmnic0,vmnic1,vmnic2,vmnic3
#esxcli network vswitch standard portgroup add --portgroup-name=hv100-prod0 --vswitch-name=vSwitch0
#esxcli network vswitch standard portgroup remove --portgroup-name="VM Network" --vswitch-name=vSwitch0
#vim-cmd vimsvc/task_cancel ''
#vim-cmd vimsvc/task_list
reboot

```

**/etc/init.d/sapb1servertools**

```shell

case "$1" in
    start)
        mount -a
        start_servertools
		sleep 30
        /etc/init.d/b1s start
		#sleep 15
        #/usr/sap/SAPBusinessOne/WebClient/startup.sh start
        ;;
    stop)
        #/usr/sap/SAPBusinessOne/WebClient/startup.sh stop
        /etc/init.d/b1s stop
        stop_servertools
        ;;
    restart)
        echo -n "Restart service SAP BusinessOne ServerTools ($INSTALL_DIR)"
        #/usr/sap/SAPBusinessOne/WebClient/startup.sh stop
        /etc/init.d/b1s stop
        stop_servertools
        sleep 2
        mount -a
        start_servertools
		sleep 30
        /etc/init.d/b1s start
		#sleep 15
        #/usr/sap/SAPBusinessOne/WebClient/startup.sh start
        rc_status
        ;;
    status)
        status
        ;;
    *)
        echo "Usage: $0 {start|stop|status|restart}"
        exit 1
        ;;
esac

```

**SAP.PS1**
```powershell
Write "Install SAP Aplications";$server="sld";$serverOld="localhost";$files="\\$server\b1_shf";$path86="C:\Program Files (x86)\sap";$path64="C:\Program Files\sap";
if ( 1 -eq 1 ) { 
 & "$files\Hana_Components\SAP_HANA_CLIENT_WINDOWSx32\hdbinst.exe"   --path="$path86\hdbclient" --batch
 Wait-Process -Name hdbinst
 & "$files\Hana_Components\SAP_HANA_CLIENT_WINDOWSx64\hdbinst.exe"   --path="$path64\hdbclient" --batch
 Wait-Process -Name hdbinst
}
if ( 1 -eq 0 ) { 
 & "$files\Hana_Components\SAP_HANA_STUDIO_WINDOWSx64\hdbinst.exe"   --path="$path64\hdbstudio" --batch
 Wait-Process -Name hdbinst
}
if ( 1 -eq 1 ) { 
 & "$files\Client.x64\setup.exe" /S /z"$path64\SAP Business One\*$server:40000"
 Wait-Process -Name setup
 & Get-ChildItem "$path64\SAP Business One\Conf"        -Recurse -Include "b1-local-machine.xml" |
  ForEach-Object { (Get-Content $_.FullName) | 
  ForEach-Object {$_ -replace "$serverOld", "$server"} | 
  Set-Content $_.FullName }
 & Get-ChildItem "$path64\SAP Business One DI API\Conf" -Recurse -Include "b1-local-machine.xml" |
  ForEach-Object { (Get-Content $_.FullName) | 
  ForEach-Object {$_ -replace "$serverOld", "$server"} | 
  Set-Content $_.FullName }
 & Get-ChildItem "$path64\SAP Business One\Conf"        -Recurse -Include "b1-local-machine-template.xml" |
  ForEach-Object { (Get-Content $_.FullName) | 
  ForEach-Object {$_ -replace "$serverOld", "$server"} | 
  Set-Content $_.FullName }
 & Get-ChildItem "$path64\SAP Business One DI API\Conf" -Recurse -Include "b1-local-machine-template.xml" |
  ForEach-Object { (Get-Content $_.FullName) | 
  ForEach-Object {$_ -replace "$serverOld", "$server"} | 
  Set-Content $_.FullName }
if (!(Test-Path "$path64\SAP Business One\AddOns")){New-Item -itemType Directory -Path "$path64\SAP Business One\" -Name "AddOns"}
  & Start-Process cmd -ArgumentList { /k icacls "C:\Program Files\sap\SAP Business One\AddOns" /grant *S-1-5-11:(OI)(CI)(F) /t /c /q }
}
#https://docs.microsoft.com/en-us/windows/security/identity-protection/access-control/security-identifiers
```

**B1i.txt**
```
1. netsh advfirewall firewall add rule name=SAP-B1I protocol=TCP dir=in localport=8080,8443 action=allow
2. "C:\Program Files\sap\SAP Business One Integration\IntegrationServer\Tomcat\webapps\B1iXcellerator\xcellerator.cfg" > xcl.http.localOnly=false
3. sc stop Tomcat8 && sc start Tomcat8
4. http://localhost:8080/B1iXcellerator & https://localhost:8443/B1iXcellerator
5. B1iadmin:Test1234
```

**SLES.SH**
```shell
screen -dRR
services="b1s b1s50000 b1s50001 b1s50002 b1s50003 b1s50004 webclient sapb1edfbackend sapb1servertools authenticationservice sldagent sapinit"
#sav-protect sav-rms
unitfile="'sapb1servertools\|sldagent\|sapb1edfbackend\|sapb1servertools\|webclient\|authenticationservice\|b1\|sap\|SAP'"
systemctl --type=service | grep $unitfile
systemctl status                $services
systemctl stop                  $services
systemctl disable               $services
systemctl enable                $services
systemctl start                 $services
systemctl reload-daemon
systemctl reset failed
kill $(lsof -ti:443);kill $(lsof -ti:7299);kill $(lsof -ti:40000);kill $(lsof -ti:50000);kill $(lsof -ti:7299);kill $(lsof -ti:60010);kill $(lsof -ti:60000)
snapper list #delete,create
crontab -l
cat /etc/fstab #uuid should be used
cat /sys/kernel/mm/transparent_hugepage/enabled;echo never > /sys/kernel/mm/transparent_hugepage/enabled;grep -e AnonHugePages /proc/*/smaps | awk '{ if($2>4) print $0}' | awk -F "/" '{print $0; system("ps -fp " $3)}'
yast > system > boot loader > kernel parameters > transparent_hugepage=never
slesVersion="15.1"
slesRegcode="010589DC7ABD8160";
zypper lr -e repositories.bak;cat repositories.bak.repo | grep 'name\|enabled'
rpm -qa --queryformat '%{NAME}\n' > installed-software.bak #restore#zypper ar repositories.bak.repo#zypper install $(cat installed-software.bak)
vi /etc/zypp/zypp.conf #multiversion = provides:multiversion(kernel) #multiversion.kernels = latest,running
SUSEConnect -s
SUSEConnect --status-text
SUSEConnect --de-register
SUSEConnect --cleanup
rm -f /etc/SUSEConnect;rm -rf /etc/zypp/credentials.d/*;rm -rf /etc/zypp/repos.d/*;rm -f /etc/zypp/services.d/*
SUSEConnect -r $slesRegcode
SUSEConnect -r $slesRegcode -e support_eu@isystems-integration.com
SUSEConnect -r $slesRegcode -p SLES/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p PackageHub/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-basesystem/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-desktop-applications/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-development-tools/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-legacy/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-python2/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-python2/$slesVersion/x86_64 zypper in bc glibc-i18ndata python python-openssl python-pycrypto
SUSEConnect -r $slesRegcode -p sle-module-server-applications/$slesVersion/x86_64
SUSEConnect -r $slesRegcode -p sle-module-web-scripting/$slesVersion/x86_64
zypper ar Tailscale
zypper nr Tailscale TailscaleRepo
zypper rr TailscaleRepo
zypper ref
zypper in -y zypper-migration-plugin
zypper in -y libicu60_2
zypper in -y libcap-progs
zypper in -y xmlstarlet
zypper in -y firewalld
#zypper in -y bc glibc-i18ndata python python-openssl python-pycrypto
zypper patch
zypper up
zypper migration
zypper clean -a
systemctl enable authentication b1s* webclient sapb1edfbackend sapb1servertools sldagent sapinit
#@reboot sleep 1   && systemctl stop  sldagent sapb1servertools b1s b1s50000 b1s50001 b1s50002 b1s50003 b1s50004
#@reboot sleep 60  && systemctl stop  sldagent sapb1servertools b1s b1s50000 b1s50001 b1s50002 b1s50003 b1s50004
#@reboot sleep 360 && systemctl start sldagent sapb1servertools && sleep 60 && systemctl start b1s b1s50000 b1s50001 b1s50002 b1s50003 b1s50004
systemctl reboot
```

**SLD.SH**
```shell
#2538555 - How to Perform Clean Reinstall of SAP Business One, version for SAP HANA Server Components
df -h;ls -lah /usr/sap/SAPBusinessOne/B1_SHF
systemctl stop b1s;systemctl stop sapb1servertools
kill $(lsof -ti:443);kill $(lsof -ti:7299);kill $(lsof -ti:40000);kill $(lsof -ti:50000);kill $(lsof -ti:7299);kill $(lsof -ti:60010);kill $(lsof -ti:60000)
rpm -qa | grep B1
rpm -qa | grep B1 | xargs rpm -ev
rpm -ev B1BackupService-10.0014104-2.x86_64
drop schema SBOCOMMON,SLDDATA cascade
optional: drop schema RSP,B1iF
drop user COMMON cascade
cat /usr/sap/SAPBusinessOne/.installer.properties
mv /usr/sap/SAPBusinessOne /usr/sap/SAPBusinessOne_
rm -rf /etc/init.d/sapb1servertools
cp /etc/samba/smb.conf /etc/samba/smb.conf.bak
vi /etc/samba/smb.conf #remove sap shares
optional: update hana client @ Hana_Components\SAP_HANA_CLIENT\hdbinst
systemctl stop smb && systemctl start smb
cd /usr/sap/SAPBusinessOne_/B1_SHF/10.0_SP2011HF0/Packages.Linux/ServerComponents
./install
#60000 is occupied
#restore B1_SHF files
```

**SSL.SH**

```shell

#!/bin/bash
#sap note 2298985
domain=$1
ip1=$2
ip2=$3
cat << EOF > /tmp/settings
[req]
default_bits = 2048
prompt = no
default_md = sha256
x509_extensions = v3_req
distinguished_name = dn
[dn]
C = DE
ST = NRW
L = Moenchengladbach
O = iSystems Consulting
OU = SAP
CN = $domain
[v3_req]
subjectAltName = @alt_names
[alt_names]
DNS.1=*.$domain
DNS.2=$ip1
DNS.3=$ip2
IP.1=$ip1
IP.2=$ip2
EOF
openssl req -new -x509 -newkey rsa:2048 -sha256 -nodes -days 825 -keyout $domain.key -out $domain.crt -config /tmp/settings
#openssl req -new -x509 -newkey rsa:2048 -sha256 -nodes -days 3560 -keyout $domain.key -out $domain.crt -config /tmp/settings
openssl pkcs12 -name $domain -inkey $domain.key -in $domain.crt -export -out $domain.pfx -password pass:sapB1iP
#cat $domain.crt $domain.key > $domain.keycer.crt

# HANA

1. mv /usr/sap/SAPBusinessOne/B1_SHF/domain.privatcloud.biz.pfx /usr/sap/SAPBusinessOne/Common/tomcat/cert
2. /usr/sap/SAPBusinessOne/ServerTools/SLD/tools/update_https_certificate.sh
3. /usr/sap/SAPBusinessOne/Common/tomcat
4. /usr/sap/SAPBusinessOne/Common/tomcat/cert/domain.privatcloud.biz.pfx
5. pw=sapB1iP
6. /etc/init.d/sapb1servertools stop && /etc/init.d/sapb1servertools start

# WINDOWS

## CONFIG

1. C:\Program Files (x86)\SAP\SAP Business One Integration\IntegrationServer\Tomcat\webapps\B1iXcellerator\xcellerator.cfg
2. C:\Program Files (x86)\SAP\SAP Business One BAS GateKeeper\tomcat\conf\server.xml
3. C:\Program Files (x86)\SAP\SAP Business One BAS GateKeeper\tomcat\conf\SLD-config.xml
4. C:\Program Files (x86)\sap\SAP Business One Integration\IntegrationServer\Tomcat\conf\server.xml

## CERTIFICATE

 set "bin=C:\Program Files\sap\SAP Business One Integration\sapjre_64\bin"
 set "b1i=C:\Program Files\sap\SAP Business One Integration\IntegrationServer\Tomcat\webapps\B1iXcellerator"
 set "pfx=C:\rds.e18.privatcloud.biz.pfx"
 set "pwd=sapB1iP"
 cd "%bin%"
 keytool -list -v -keystore "%b1i%\.keystore" -storepass "%pwd%"
 keytool -delete -alias tomcat -keystore "%b1i%\.keystore" -storepass "%pwd%"
 keytool -importkeystore -srckeystore "%pfx%" -srcstoretype PKCS12 -destkeystore "%b1i%\.keystore" -deststoretype JKS -deststorepass "%pwd%" -srcstorepass "%pwd%"
 keytool -list -v -keystore "%b1i%\.keystore" -storepass "%pwd%"
 set "alias={c7eda4db-30cc-4db4-9149-816a7bd01d09}"
 keytool -changealias -alias "%alias%" -destalias tomcat -keystore "%b1i%\.keystore" -storepass "%pwd%"
 sc stop SAPB1iDIProxy_Monitor && sc stop SAPB1iDIProxy && sc stop SAPB1iEventSender && sc stop Tomcat8
 sc start Tomcat8 && sc start SAPB1iEventSender && sc start SAPB1iDIProxy && sc start SAPB1iDIProxy_Monitor

#Enhanced Key Usage: Client Authentication (1.3.6.1.5.5.7.3.2),Server Authentication (1.3.6.1.5.5.7.3.1)
#Key Usage: Digital Signature, Key Encipherment (a0)
#Subject Key Identifier: c9 2d 29 86 c3 2f 3b 1c 30 e2 ed c0 c7 02 4a ad b8 29 d4 47

```

**OPENSSL.SH**

```shell

#cd "X:\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\OSC\Atlas\rds\ssl"
openssl genrsa -out rds.at.privatcloud.biz.key 2048
openssl req -new -sha256 -key rds.at.privatcloud.biz.key -out rds.at.privatcloud.biz.csr -subj "/C=DE/ST=NRW/L=DUESSELDORF/O=iSystems GmbH/CN=rds.at.privatcloud.biz"
#psw>einzelzertifikate
cat root.crt           > bundle.crt
cat intermediate1.crt >> bundle.crt
openssl pkcs12 -export -out rds.at.privatcloud.biz.pfx -inkey rds.at.privatcloud.biz.key -in certificate.crt -certfile bundle.crt
#sapB1iP
openssl pkcs12 -in rds.at.privatcloud.biz.pfx -out rds.at.privatcloud.biz.crt -nokeys -clcerts
openssl x509 -inform pem -in rds.at.privatcloud.biz.crt -outform der -out rds.at.privatcloud.biz.cer

```

**ANSIBLE.SH**

```shell
# UPDATE
#Klaus Joerissen sunday, 9th june, 2019
#- ansible Server updated
#- backup in /home/20190608-ansible.tgz
#- neues Verzeichnis für die hosts-Datei: /home/ansible/customers_std
#- neue Version trägt sich sich selbst dort ein
#- neue Musterkonfiguration: SLES124-01a.conf
#Klaus Joerissen
#Start mit 00-scripts/01-createVM-ESXi-std-hanab1.sh, das alte 00.. besteht nur noch aus Kompatibilitätsgründen
# KURZ
ssh root@192.168.191.100 -p 60022
cd /home/ansible
# host und config anschauen von spielwiese
/home/ansible/hosts
/home/ansible/autoinst/configs/nizza-b1.conf
# installieren
/home/ansible/00-scripts/00-createVM-ESXi-std-hanab1.sh spielwiese

# LANG
# From: Klaus Joerißen <info@kj-dv.de> 
# Sent: Thursday, October 11, 2018 01:02
# To: Michael Esser <m.esser@isystems-integration.com>; Jan Rzadkowski <j.rzadkowski@isystems-integration.com>
# Cc: Steffen Kamphoff <s.kamphoff@isystems-integration.com>
# Subject: Installation Hana-Server
#  
# Hallo Ihr beiden,
# ich habe den Fehler gefunden und das Installationsscript auf dem Server in MG gestartet. Morgen früh werde ich kurz das Ergebnis kontrollieren und hoffen, dass alles i.O. ist.
#  
# Leider hat mein Windoofrechner die Datei zum Ablauf nicht richtig abgespeichert, daher hier nur eine kurze Zusammenfassung
#  
# 1. Zugang
# ansible Server: 192.168.189.100
# Port: 60022
#  
# 2. Screen
# screen -dRR
# - neues Fenster erstellen: Strg+a, c
# - Fenster vor: Strg+a, n
# - Fenster zurück: Strg+a, p
#  
# 3. Host-Datei anpassen
# /home/ansible/hosts
#  
# 4. Config-Datei erstellen
# - /home/ansible/autoinst/configs/Articruz.conf kopieren und an das neue Zielsystem anpassen
#  
# 5. auf dem Ziel-ESXi das Volume B1H des ansible Servers einbinden
#  
# 6. Installation im Verzeichnis /home/ansible starten mit
# 00-scripts/00-createVM-ESXi-std-hanab1.sh NAME_DER_CONFIGDATEI
#  
# während die Installation läuft, könnt Ihr 
# - mit screen einen neuen Tab aufmachen und den nächsten Server fertigstellen....
# - in einer Browserkonsole des ESXi den Installationsablauf verfolgen
# - und natürlich Kaffee trinken  
#  
# Wenn es Probleme gibt, schickt mir am besten eine Nachricht.
# Wenn es nach der Installation des SLES Grundsystems nach dem Neustart zu einem Fehler, handelt es sich zu 98% um ein Problem in der Konfiguration des Workdefenders.
#  
# Viel Erfolg
# Klaus
# 


# WINDOWS:
# - aus dem ISO-Verzeichnis die entsprechende tgz auf den ESXi kopieren und dort entpacken
mkdir /vmfs/volumes/5be2ff5b-4d3fd5d2-8a39-7cd30ae54ee0/W2K16EN
tar -xf /vmfs/volumes/3dad8eb7-c2ea8976/ISO/W2K16EN.tgz -C /vmfs/volumes/5be2ff5b-4d3fd5d2-8a39-7cd30ae54ee0/W2K16EN
# - Verzeichnis umbenennen
# - VM registrieren und starten
# - manuell die IP von DHCP auf statisch ändern
# - auf ansible-Server Hosts in hostdatei aufnehmen
# - auf ansible-Server in groups_var die Gruppendatei kopieren
# - yml-Dateien für die VMs erstellen (=kopieren und anpassen
# - ansible laufen lassen:
#   ansible-playbook pb-W"K....yml

```

**KS.CFG.BAK**

```bash

#https://michael.lustfield.net/misc/completely-automated-esxi-deployment
#http://www.vstellar.com/2017/08/08/system-swap-scratch-configuration-in-vsphere-6/
#https://docs.vmware.com/en/VMware-vSphere/6.7/com.vmware.esxi.upgrade.doc/GUID-61A14EBB-5CF3-43EE-87EF-DB8EC6D83698.html
#https://docs.vmware.com/en/VMware-vSphere/6.0/vsphere-esxi-vcenter-server-602-installation-setup-guide.pdf
#https://www.virten.net/2014/12/unattended-esxi-installations-from-an-usb-flash-drive/
#https://www.virten.net/2014/12/howto-create-a-bootable-esxi-installer-usb-flash-drive/
#https://www.rudimartinsen.com/2018/06/09/customizing-esxi-installation-with-kickstart-files-and-pxe-boot/
#https://www.virtuallyghetto.com/2014/10/how-to-automate-vm-deployment-from-large-usb-keys-using-esxi-kickstart.html
#https://www.virtuallyghetto.com/2012/05/how-to-deploy-ovfova-in-esxi-shell.html
#https://www.tech-coffee.net/deploy-esxi-6-5-from-usb-stick-and-unattended-file/
#https://jimangel.io/post/scripted-esxi-6.7-install-to-usb/
#https://github.com/pbatard/rufus/releases/download/v3.4/rufus-3.4p.exe
#Now we have to configure the boot the load the ks.cfg automatically for the deployment.
#Open the USB stick and edit Boot.cfg. 
#Replace the following line kernelopt=runweasel by kernelopt=ks=usb:/ks.cfg
#Unplug the USB Stick and plug it on the server. You can boot the USB key to run the installer.
#https://calvin.me/reset-esxi-evaluation-license/
#rm -r /etc/vmware/license.cfg & cp /etc/vmware/.#license.cfg /etc/vmware/license.cfg & /etc/init.d/vpxa restart
#crontab.guru
#Accept VMware License agreement
accepteula
# Set the root password
rootpw Tarantu95
# Install ESXi on the first disk (Local first, then remote then USB)
#install --firstdisk --overwritevmfs
# Install ESXi on the first (USB) disk, ignore any SSD and do not create a VMFS
install --ignoressd --firstdisk=usb --overwritevmfs --novmfsondisk
# Following will create a VMFS on the second local drive
#partition datastoreM2 --onfirstdisk=local
# Set the keyboard
keyboard German
# Set the network
network --bootproto=dhcp
# reboot the host after installation is completed
reboot
# run the following command only on the firstboot
%firstboot --interpreter=busybox
# enable & start remote ESXi Shell (SSH)
vim-cmd hostsvc/enable_ssh
vim-cmd hostsvc/start_ssh
# enable & start ESXi Shell (TSM)
vim-cmd hostsvc/enable_esx_shell
vim-cmd hostsvc/start_esx_shell
# supress ESXi Shell shell warning - Thanks to Duncan (http://www.yellow-bricks.com/2011/07/21/esxi-5-suppressing-the-localremote-shell-warning/)
esxcli system settings advanced set -o /UserVars/SuppressShellWarning -i 1
# Get Network adapter information
NetName="vmk0"
# Get the IP address assigned by DHCP
IPAddress=$(localcli network ip interface ipv4 get | grep "${NetName}" | awk '{print $2}')
#Get the netmask assigned by DHCP
NetMask=$(localcli network ip interface ipv4 get | grep "${NetName}" | awk '{print $3}')
# Get the gateway provided by DHCP
Gateway=$(localcli network ip interface ipv4 get | grep "${NetName}" | awk '{print $6}')
DNS="9.9.9.9"
#VlanID="50"
# Get the hostname assigned thanks to reverse lookup zone
#HostName=$(hostname -s)
HostName=esxi
SuffixDNS="devnet.local"
FQDN="${HostName}.${SuffixDNS}"
# set static IP + default route + DNS
esxcli network ip interface ipv4 set --interface-name=vmk0 --ipv4=${IPAddress} --netmask=${NetMask} --type=static --gateway=${Gateway}
esxcli network ip dns server add --server ${DNS}
# DCTPA2 Vlan
ID=209
esxcli network vswitch standard list;esxcli network vswitch standard portgroup list;
esxcfg-vswitch --add-pg=Vlan$ID vSwitch0;esxcfg-vswitch -v $ID -p Vlan$ID vSwitch0;
/etc/init.d/hostd restart;/etc/init.d/vpxa restart;
# Set VLAN ID
#esxcli network vswitch standard portgroup set --portgroup-name "Management Network" --vlan-id 50
#Disable ipv6
esxcli network ip set --ipv6-enabled=0
# set suffix and FQDN host configuration
esxcli system hostname set --fqdn=${FQDN}
esxcli network ip dns search add --domain=${SuffixDNS}
# NTP Configuration (thanks to http://www.virtuallyghetto.com)
cat > /etc/ntp.conf << __NTP_CONFIG__
restrict default kod nomodify notrap noquerynopeer
restrict 127.0.0.1
server 0.europe.pool.ntp.org
server 1.europe.pool.ntp.org
server 2.europe.pool.ntp.org
server 3.europe.pool.ntp.org
__NTP_CONFIG__
/sbin/chkconfig ntpd on
# rename local datastore to something more meaningful
#vim-cmd hostsvc/datastore/rename datastore1 "Local - $(hostname -s)"
# restart a last time
reboot
# A sample post-install script
#%post --interpreter=python --ignorefailure=true
#import time
#stampFile = open('/finished.stamp', mode='w')
#stampFile.write( time.asctime() )

```

**ESXI.SH**

```bash

# SEL Fulness
#reset xcc event logs then: 
localcli hardware ipmi sel clear && /etc/init.d/sfcbd-watchdog restart && services.sh restart
# MOVE DISKS
#vmkfstools –i <sourcedisk> -d thin <targetdisk>
source=
destination=
vm=
disk=
#esxcli storage core path list
#ls /dev/disks
#consolidate vm first
#afterwards remove disk from inventory
mkdir "/vmfs/volumes/$destination/$vm"
vmkfstools -i "/vmfs/volumes/$source/$vm/$disk" -d thin "/vmfs/volumes/$destination/$vm/$disk"
find "/vmfs/volumes/$source/$vm" -maxdepth 1 -type f -print0 | grep -v ".vmdk" | while read file; do cp "$file" "/vmfs/volumes/$destination/$vm"; done
find "/vmfs/volumes/$source/$vm" -maxdepth 1 -type f -print0 | grep [0123456789][0123456789][0123456789][0123456789][0123456789][0123456789] | grep ".vmdk" | while read file; do cp "$file" "/vmfs/volumes/$destination/$vm"; done
#add disk to inventory, answer that you copied, then remove source
#rm -rf "/vmfs/volumes/$source/$vm"
#https://serverfault.com/questions/372526/move-vmware-esxi-vm-to-new-datastore-preserve-thin-provisioning
#VMIDsvim-cmd vmsvc/getallvms
#vim-cmd /vmsvc/unregister <Vmid>

```

**rds-domain.ps1**

```powershell
#run:
#Enable-PSRemoting;winrm quickconfig;Set-Item wsman:\localhost\client\TrustedHosts -Value * -Force
#change:
$dcip       = "10.3.12.3"
$dcusr      = "administrator"
$dcpw       = "nA4r4Ngw"
$rdsip      = "10.3.12.5"
$rdsusr     = "administrator"
$rdspw      = "nA4r4Ngw"
$ndc        = "dc"
$nrd        = "rds"
$rdd        = "pylon.privatcloud.biz"
$rnb        = "PYLON"
$netw       = "10.3.13.0/28"
$dnsip      = "10.3.13.3"
$dnsip2     = "10.3.13.1"
$dnsfw1     = "10.3.13.1"
$dnsfw2     = "9.9.9.9"
$susip      = "10.3.13.2"
#keep:
$dcpass     = ConvertTo-SecureString -AsPlainText $dcpw -Force
$rdspass    = ConvertTo-SecureString -AsPlainText $rdspw -Force
$dccred     = New-Object System.Management.Automation.PSCredential -ArgumentList $dcusr,$dcpass
$rdscred    = New-Object System.Management.Automation.PSCredential -ArgumentList $rdsusr,$rdspass
$domaincred = New-Object System.Management.Automation.PSCredential -ArgumentList $rnb\$dcusr,$dcpass
echo DomainControllerRename
Invoke-Command -ComputerName $dcip -Credential $dccred -ScriptBlock {
 Enable-PSRemoting;winrm quickconfig
 Rename-Computer -NewName $Using:ndc -Restart -Force
}
Start-Sleep -s 240
echo DomainControllerInstall
Invoke-Command -ComputerName $dcip -Credential $dccred -ScriptBlock {
 Install-WindowsFeature -Name AD-Domain-Services -IncludeManagementTools -IncludeAllSubFeature
 Import-Module ADDSDeployment
 Install-ADDSForest -DomainName $Using:rdd -DomainNetBiosName $Using:rnb -DomainMode WinThreshold -ForestMode WinThreshold -SkipPreChecks -InstallDns:$true -SafeModeAdministratorPassword $Using:dcpass -Force
}
Start-Sleep -s 600
echo DomainControllerSetting
Invoke-Command -ComputerName $dcip -Credential $domaincred -ScriptBlock {
 (Get-ADDomain | Format-List Name, DomainMode) + (Get-ADForest | Format-List Name, ForestMode)
 Add-DnsServerPrimaryZone -NetworkID $Using:netw -ReplicationScope Domain -DynamicUpdate Secure -PassThru
 ipconfig /registerdns
 Set-DnsClientServerAddress -InterfaceAlias "Ethernet0" -ServerAddresses "127.0.0.1,$Using:dnsip"
 Set-DnsServerForwarder -IPAddress "$Using:dnsfw1,$Using:dnsfw2"
 Set-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Services\LanmanWorkstation' -Name DependOnService -Value @('Bowser','MRxSmb20','NSI','DNS')
}
echo TerminalServerRename
Invoke-Command -ComputerName $rdsip -Credential $rdscred -ScriptBlock {
 Enable-PSRemoting;winrm quickconfig
 Set-DnsClientServerAddress -InterfaceAlias "Ethernet0" -ServerAddresses $using:dnsip,$using:dnsip2
 Rename-Computer -NewName $Using:nrd -Restart -Force
}
echo PleaseSetTheDnsServers
Start-Sleep -s 600
echo TerminalServerJoin
Invoke-Command -ComputerName $rdsip -Credential $rdscred -ScriptBlock {
 $domain=$using:rdd
 Add-Computer –domainname $domain -restart -Credential $using:domaincred
}
Invoke-Command -ComputerName $dcip -Credential $domainCred -ScriptBlock {
#admins
 $ADGroupMember="Domain Admins"
 $Username="partner";$Password="";$Firstname="Partner";$Lastname="Admin";$EmailAddress="$Username@$rdd";$OfficePhone="+123456789";New-ADUser -SamAccountName "$Username" -UserPrincipalName "$Username@$rdd" -Name "$Firstname $Lastname" -GivenName "$Firstname" -Surname "$Lastname" -EmailAddress "$EmailAddress" -OfficePhone "$OfficePhone" -Enabled $True -ChangePasswordAtLogon $False -DisplayName "$Firstname $Lastname" -AccountPassword (convertto-securestring $Password -AsPlainText -Force) -PasswordNeverExpires $true;Add-ADGroupMember -Identity $ADGroupMember -Members $Username
 $Username="user1"  ;$Password="";$Firstname="User"   ;$Lastname="1"    ;$EmailAddress="$Username@$rdd";$OfficePhone="+123456789";New-ADUser -SamAccountName "$Username" -UserPrincipalName "$Username@$rdd" -Name "$Firstname $Lastname" -GivenName "$Firstname" -Surname "$Lastname" -EmailAddress "$EmailAddress" -OfficePhone "$OfficePhone" -Enabled $True -ChangePasswordAtLogon $False -DisplayName "$Firstname $Lastname" -AccountPassword (convertto-securestring $Password -AsPlainText -Force) -PasswordNeverExpires $true
 $Username="user2"  ;$Password="";$Firstname="User"   ;$Lastname="2"    ;$EmailAddress="$Username@$rdd";$OfficePhone="+123456789";New-ADUser -SamAccountName "$Username" -UserPrincipalName "$Username@$rdd" -Name "$Firstname $Lastname" -GivenName "$Firstname" -Surname "$Lastname" -EmailAddress "$EmailAddress" -OfficePhone "$OfficePhone" -Enabled $True -ChangePasswordAtLogon $False -DisplayName "$Firstname $Lastname" -AccountPassword (convertto-securestring $Password -AsPlainText -Force) -PasswordNeverExpires $true
 $Username="user3"  ;$Password="";$Firstname="User"   ;$Lastname="3"    ;$EmailAddress="$Username@$rdd";$OfficePhone="+123456789";New-ADUser -SamAccountName "$Username" -UserPrincipalName "$Username@$rdd" -Name "$Firstname $Lastname" -GivenName "$Firstname" -Surname "$Lastname" -EmailAddress "$EmailAddress" -OfficePhone "$OfficePhone" -Enabled $True -ChangePasswordAtLogon $False -DisplayName "$Firstname $Lastname" -AccountPassword (convertto-securestring $Password -AsPlainText -Force) -PasswordNeverExpires $true
 $Username="user4"  ;$Password="";$Firstname="User"   ;$Lastname="4"    ;$EmailAddress="$Username@$rdd";$OfficePhone="+123456789";New-ADUser -SamAccountName "$Username" -UserPrincipalName "$Username@$rdd" -Name "$Firstname $Lastname" -GivenName "$Firstname" -Surname "$Lastname" -EmailAddress "$EmailAddress" -OfficePhone "$OfficePhone" -Enabled $True -ChangePasswordAtLogon $False -DisplayName "$Firstname $Lastname" -AccountPassword (convertto-securestring $Password -AsPlainText -Force) -PasswordNeverExpires $true
 $Username="user5"  ;$Password="";$Firstname="User"   ;$Lastname="5"    ;$EmailAddress="$Username@$rdd";$OfficePhone="+123456789";New-ADUser -SamAccountName "$Username" -UserPrincipalName "$Username@$rdd" -Name "$Firstname $Lastname" -GivenName "$Firstname" -Surname "$Lastname" -EmailAddress "$EmailAddress" -OfficePhone "$OfficePhone" -Enabled $True -ChangePasswordAtLogon $False -DisplayName "$Firstname $Lastname" -AccountPassword (convertto-securestring $Password -AsPlainText -Force) -PasswordNeverExpires $true
}
```

**rds-script.ps1**

```powershell
#change:
$dcusr      = "administrator"                   #admin User on DC
$dcpw       = "q4Wy2DGa"                        #admin User Password on DC
$rnb        = "SAMPOWER"                        #Domain Name
$fqdn       = "sampower.privatcloud.biz"        #Fully Qualified Domain Name
$susip      = "10.2.60.2"                       #IP from SLD Server
$dcip       = "10.2.60.3"                       #IP from Domain Controller
$rdsip      = "10.2.60.4"                       #IP from RDS Server
$rdstcp     = "10077"                           #RDS Port
$tdc        = "dc.$fqdn"                        #DNS Server Name
$rdb        = "rds.$fqdn"                       #Connection Broker Name
$rdg        = "rds.$fqdn"                       #Gateway Server Name
$rds        = "rds.$fqdn"                       #Session Host Server Name
$rdw        = "rds.$fqdn"                       #Web Access Server Name
$rdl        = "rds.$fqdn"                       #License Server Name
$rdc        = "SAP"                             #Collection Name
$rdspw      = "sapB1iP";$rdspw = ConvertTo-SecureString -String "$rdspw" -AsPlainText -Force #Cert Password
$rdspfx     = 'c:\sampower.privatcloud.biz.pfx' #PFX file path
$rdscer     = 'c:\sampower.privatcloud.biz.cer' #CER file path
$suscer     = '\\$susip\b1_shr'                 #B1 Share path
$rdsusr     = "Domänen-Benutzer@$fqdn"          #User for RDS
#keep:
$dcpass     = ConvertTo-SecureString -AsPlainText $dcpw -Force #dont change $dcpass and $domaincred
$domaincred = New-Object System.Management.Automation.PSCredential -ArgumentList $rnb\$dcusr,$dcpass
echo Enable PSRemoting
#https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/enable-psremoting?view=powershell-7.1
Enable-PSRemoting;winrm quickconfig;Set-Item wsman:\localhost\client\TrustedHosts -Value * -Force >> C:\log.txt
echo Install Connection Broker and Web Access Server and Session Host
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/new-rdsessiondeployment?view=windowsserver2016-ps
Import-Module RemoteDesktop
New-RDSessionDeployment -ConnectionBroker $rdb -WebAccessServer $rdw -SessionHost $rds >> C:\log.txt
Start-Sleep -s 400
echo Install Connection Broker and Session Host and Create Collection
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/new-rdsessioncollection?view=windowsserver2016-ps
New-RDSessionCollection -CollectionName $rdc -ConnectionBroker $rdb -SessionHost $rds >> C:\log.txt
echo Install Gateway Server
#https://www.it-visions.de/scripting/PowerShell/Commandlets.aspx?Add-WindowsFeature
Add-WindowsFeature -Name RDS-Gateway -IncludeManagementTools -ComputerName $rdg >> C:\log.txt
Start-Sleep -s 180
echo ADD Gateway Server to Remote Desktop deployment
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/add-rdserver?view=windowsserver2016-ps
Add-RDServer -Server $rdg -Role "RDS-GATEWAY" -ConnectionBroker $rdb -GatewayExternalFqdn $rdg >> C:\log.txt
echo create rdcap and rdrap and disable UDP and set Gateway Farm
Invoke-Command -ComputerName $rdg{
 $GatewayAccessGroup = $args[0]
 $RDBrokerDNSInternalName = $args[1]
 $RDBrokerDNSInternalZone = $args[2]
 $RDSHost01 = $args[3]
 Import-Module RemoteDesktopServices
 Remove-Item -Path "RDS:\GatewayServer\CAP\RDG_CAP_AllUsers" -Force -recurse
 Remove-Item -Path "RDS:\GatewayServer\RAP\RDG_RDConnectionBrokers" -Force -recurse
 Remove-Item -Path "RDS:\GatewayServer\RAP\RDG_AllDomainComputers" -Force -recurse
 Remove-Item -Path "RDS:\GatewayServer\GatewayManagedComputerGroups\RDG_RDCBComputers" -Force -recurse
 New-Item -Path "RDS:\GatewayServer\CAP\" -Name RDS -UserGroups $using:rdsusr -AuthMethod "1"-Force
 Set-Item -Path "RDS:\GatewayServer\CAP\RDS\DeviceRedirection\Printers" -Value "1"
 Set-Item -Path "RDS:\GatewayServer\CAP\RDS\DeviceRedirection\SerialPorts" -Value "0"
 Set-Item -Path "RDS:\GatewayServer\CAP\RDS\DeviceRedirection\PlugAndPlayDevices" -Value "0"
 New-Item -Path "RDS:\GatewayServer\RAP\" -Name RDS -UserGroups $using:rdsusr -ComputerGroupType "2" -Force
 #generates an error but seems working
 New-Item -Path "RDS:\GatewayServer\GatewayFarm\Servers" -Name $using:rdg -Force
 Set-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\TerminalServerGateway\Config\Core" IsUdpEnabled -Value 0
} >> C:\log.txt
echo set rddeplyment configuration
#https://docs.microsoft.com/en-us/powershell/module/rdmgmt/set-rddeploymentgatewayconfiguration?view=windowsserver2019-ps
Set-RDDeploymentGatewayConfiguration -GatewayMode Custom -GatewayExternalFQDN $rds -LogonMethod AllowUserToSelectDuringConnection -UseCachedCredentials $True -BypassLocal $False -ConnectionBroker "$rds" -force >> C:\log.txt
Start-Sleep -s 180
echo set DNS Records
#https://docs.microsoft.com/en-us/powershell/module/dnsserver/add-dnsserverresourcerecorda?view=windowsserver2019-ps
Import-Module RemoteDesktop
Add-DnsServerResourceRecordA -ComputerName $tdc -Name $rdg -ZoneName $fqdn -AllowUpdateAny -IPv4Address $rdsip >> C:\log.txt
echo Install License Server and add to Remote Desktop deployment
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/add-rdserver?view=windowsserver2016-ps
Add-RDServer -Server $rdl -Role "RDS-LICENSING" -ConnectionBroker $rdb >> C:\log.txt
echo change RDS Licence Configuration
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/set-rdlicenseconfiguration?view=windowsserver2016-ps
Set-RDLicenseConfiguration -LicenseServer $rdl -Mode PerUser -ConnectionBroker $rdb -Force >> C:\log.txt
ADD-ADGroupMember "Terminalserver-Lizenzserver" –members "rds$" >> C:\log.txt
echo set Certificate
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/set-rdcertificate?view=windowsserver2016-ps
Set-RDCertificate -Role RDPublishing -ImportPath $rdspfx -Password $rdspw -ConnectionBroker $rdb -Force >> C:\log.txt
Set-RDCertificate -Role RDRedirector -ImportPath $rdspfx -Password $rdspw -ConnectionBroker $rdb -Force >> C:\log.txt
Set-RDCertificate -Role RDWebAccess  -ImportPath $rdspfx -Password $rdspw -ConnectionBroker $rdb -Force >> C:\log.txt
Set-RDCertificate -Role RDGateway    -ImportPath $rdspfx -Password $rdspw -ConnectionBroker $rdb -Force >> C:\log.txt
echo copy Certificate to RDS Server
copy $rdscer \\$rds\c$ >> C:\log.txt
echo Install Nuget
Invoke-Command -ComputerName $rdg -Credential $domaincred -ScriptBlock {
 [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12;Install-PackageProvider Nuget –Force;Install-Module -Name PowerShellGet -Force -SkipPublisherCheck
} >> C:\log.txt
Start-Sleep -s 30
echo Install RDWeb HTML5
Invoke-Command -ComputerName $rdg -Credential $domaincred -ScriptBlock {
 Import-Module RemoteDesktop
 Install-Module -Name RDWebClientManagement;Install-RDWebClientPackage;Get-RDWebClientPackage
 Import-RDWebClientBrokerCert $using:rdscer;Publish-RDWebClientPackage -Type Production -Latest
 netsh advfirewall firewall add rule name=RDG protocol=TCP dir=in localport=$using:rdstcp action=allow
} >> C:\log.txt
#https://woodward.digital/update-html-5-remote-desktop-web-client/
echo "Please change the transport settings and Set-RDSessionCollectionConfiguration"
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/set-rdsessioncollectionconfiguration?view=windowsserver2016-ps
#$settings = @"
#gatewaycredentialssource:i:0
#gatewayhostname:s:rds.sampower.privatcloud.biz:10077
#gatewayprofileusagemethod:i:1
#gatewayusagemethod:i:1
#prompt for credentials:i:0
#prompt for credentials on client:i:1
#promptcredentialonce:i:1
#redirectclipboard:i:1
#redirectcomports:i:0
#redirectdirectx:i:1
#redirectdrives:i:1
#redirectposdevices:i:0
#redirectprinters:i:1
#redirectsmartcards:i:0
#session bpp:i:16
#span monitors:i:0
#use multimon:i:0
#use redirection server name:i:1
#videoplaybackmode:i:1
#"@
#Set-RDSessionCollectionConfiguration -CollectionName SAP -CustomRdpProperty $settings -ClientDeviceRedirectionOptions Clipboard,Drive -ClientPrinterAsDefault $True -ClientPrinterRedirected $True
pause
echo Show RDP in Portal
Invoke-Command -ComputerName $rdg -Credential $domaincred -ScriptBlock {
 Set-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Terminal Server\CentralPublishedResources\PublishedFarms\SAP\RemoteDesktops\SAP" ShowInPortal -Value 1 –Force
} >> C:\log.txt
#https://docs.microsoft.com/en-us/powershell/module/remotedesktop/?view=windowsserver2016-ps
#http://woshub.com/remote-desktop-session-time-limit/
```

**rds-script-ssl-update.ps1**

```powershell

#replace certificates
$rdb="rds.at.privatcloud.biz";$certpath="c:\at";$rdspw="sapB1iP";$rdspw=ConvertTo-SecureString -String $rdspw -AsPlainText -Force;
Set-RDCertificate -Role RDPublishing -ImportPath "$certpath.pfx" -Password $rdspw -ConnectionBroker $rdb -Force
Set-RDCertificate -Role RDRedirector -ImportPath "$certpath.pfx" -Password $rdspw -ConnectionBroker $rdb -Force
Set-RDCertificate -Role RDWebAccess  -ImportPath "$certpath.pfx" -Password $rdspw -ConnectionBroker $rdb -Force
Set-RDCertificate -Role RDGateway    -ImportPath "$certpath.pfx" -Password $rdspw -ConnectionBroker $rdb -Force
#update html5
Import-Module RemoteDesktop;
UnPublish-RDWebClientPackage  -Type Production;
Import-RDWebClientBrokerCert "$certpath.cer";
Publish-RDWebClientPackage    -Type Production -Latest;
#rds.ps1
$settings = @"
gatewaycredentialssource:i:0
gatewayhostname:s:rds.at.privatcloud.biz:10059
gatewayprofileusagemethod:i:1
gatewayusagemethod:i:1
prompt for credentials:i:0
prompt for credentials on client:i:1
promptcredentialonce:i:1
redirectclipboard:i:1
redirectcomports:i:0
redirectdirectx:i:1
redirectdrives:i:1
redirectposdevices:i:0
redirectprinters:i:1
redirectsmartcards:i:0
session bpp:i:16
span monitors:i:0
use multimon:i:0
use redirection server name:i:1
videoplaybackmode:i:1
"@
Set-RDSessionCollectionConfiguration -CollectionName SAP -CustomRdpProperty $settings -ClientDeviceRedirectionOptions Clipboard,Drive -ClientPrinterAsDefault $True -ClientPrinterRedirected $True
Set-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Terminal Server\CentralPublishedResources\PublishedFarms\SAP\RemoteDesktops\SAP" ShowInPortal -Value 1 –Force

```