Import-Module -Name 'NetSecurity'
 
# Setup windows update service to manual
$wuauserv = Get-WmiObject Win32_Service -Filter "Name = 'wuauserv'"
$wuauserv_starttype = $wuauserv.StartMode
Set-Service wuauserv -StartupType Manual
 
# Install OpenSSH
Add-WindowsCapability -Online -Name OpenSSH.Server~~~~0.0.1.0
 
# Set service to automatic and start
Set-Service sshd -StartupType Automatic
Start-Service sshd

# Setup windows update service to original
Set-Service wuauserv -StartupType $wuauserv_starttype
 
# Configure PowerShell as the default shell
New-ItemProperty -Path "HKLM:\SOFTWARE\OpenSSH" -Name DefaultShell -Value "$Env:SystemRoot\System32\WindowsPowerShell\v1.0\powershell.exe" -PropertyType String -Force
 
# Restart the service
Restart-Service sshd
 
# Configure SSH public key
$content = @"
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDDGvItCy5OwNY5tBYy2dJXz1LRC/dkNXXbkyERkWw8XieABxzDoD6PwEb4gkImTkEryqt1lyEaK/ArQl5NZ5aq0TpDzont9GEs+Vz9eyqpV1g3mXkKGIlX68VvWltK2KZs4is0SRQKX08nSG0iLYpwmpZHYBmkDrViBe16/iJDQlBB0VtCjJBokSvxhWIEK4b97QRMPuXYg0AAwF52nmGUV04UGMu/13XPg6l7F6Co/4tOq5iWKE5dW+zklUILampdQfZsckfqFFzcOMWcaNcCpa7qi+Bv2v+BVxFHN6UewxyEJfjfak/8KuYvImpq8Oj1eJ2LLAazFpwFUtZ+TV8jPU8DRtgMorenMGKHX2uNrT5VpCp2xPPGMoQSg7HX4qg9SvZgNu/mcQTL+qfioHnctAAEtExxnu5kS3NqhwH2EXC9nszVma8ZglmD944AtiBTnrY31x02VFTcPLKPwzcZdiGY7I7Njj32loTB88XFKX5LTTIUGrc4qUEhSsKMtusSCmfXj4uN5eiAf1GORjBa4I8tfqDMkweOUvxJl7ffybUU6XvUXFEBmAekNWZVOXD3lRZNvF+BYJDeV4Qw2Td8ND3sQ39U+7aBK3etrAtjItkMyNwhixm30EqqxaL+U6W5jlNMPW0uu1faW49S0ftcgh5TrkJbfwoF3HY91u6F2Q== ansible@hcc05
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDD35liaNzMHqhrCSQ5jHVpINJHQ3/Ym6Z5v28rwjpEbDhtgiIvknPg8oi6LTFlbWW/1vXjKnoqy6Dm0mOM+U2aO9OVc0J2gNZ+l2QNh0Jyf4Ra0X0mt2Cue3EHoGR2RogusmO+wovI4cD/bYHTcsK9vBLAOwSgeixQcZqXIUUnG3eLXd8HrMd9hse+Z3ClwxWXEQgxXbukT1b80oWrIzZRmr+XWklDJZYbnR6IFsIAiCkikDLO5ylVGn19xh+FExw+09ylgjFA8cXLLtYsOwx6XU2EJPNLRhQkwnsALUo08wJAcFcKuEnFvwcVBKT6Z9rmSEWq8LS16ri98B8SZmjdgNSacprAyoRC+N3b5VVdzTPV4oQtDMpTb8iwPKPuK9rCY1csVgsmTB7pv1WpuNJWsaqHUi/5R041ftLX7BTTrMz6t22fuHRJBJ0/FZOSqiL1nEsQGVoL+UsRmWA7P3X8W8kpwGGV58CQfiv14d9KMQU+NJbJ8L3+VAUsgXj+iG8= kladmin@hcc05
"@
 
# Write public key to file
$content | Set-Content -Path "$Env:ProgramData\ssh\administrators_authorized_keys"
 
# set acl on administrators_authorized_keys
$admins = ([System.Security.Principal.SecurityIdentifier]'S-1-5-32-544').Translate( [System.Security.Principal.NTAccount]).Value
$acl = Get-Acl $Env:ProgramData\ssh\administrators_authorized_keys
$acl.SetAccessRuleProtection($true, $false)
$administratorsRule = New-Object system.security.accesscontrol.filesystemaccessrule($admins,"FullControl","Allow")
$systemRule = New-Object system.security.accesscontrol.filesystemaccessrule("SYSTEM","FullControl","Allow")
$acl.SetAccessRule($administratorsRule)
$acl.SetAccessRule($systemRule)
$acl | Set-Acl
 
# Open firewall port 22
$FirewallParams = @{ 
  "DisplayName"       = 'OpenSSH SSH Server (sshd)'
  "Direction"         = 'Inbound'
  "Action"            = 'Allow'
  "Protocol"          = 'TCP'
  "LocalPort"         = '22'
  "Program"           = '%SystemRoot%\system32\OpenSSH\sshd.exe'
}
New-NetFirewallRule @FirewallParams

