$XmlFile       = $PSScriptRoot + '\' + ([System.IO.Path]::GetFileNameWithoutExtension($($PSCommandPath | Split-Path -Leaf))) + '.xml'
$XmlFileCustom = $PSScriptRoot + '\' + ([System.IO.Path]::GetFileNameWithoutExtension($($PSCommandPath | Split-Path -Leaf))) + 'Custom.xml'
function FormatXml {
    param (
        [xml]$xmlDocument
    )
    $settings = New-Object System.Xml.XmlWriterSettings
    $settings.Indent = $true
    $settings.IndentChars = ""
    $stringBuilder = New-Object System.Text.StringBuilder
    $xmlWriter = [System.Xml.XmlWriter]::Create($stringBuilder, $settings)
    $xmlDocument.WriteContentTo($xmlWriter)
    $xmlWriter.Flush()
    $xmlWriter.Close()
    $stringBuilder.ToString()
}
function WriteXml {
$servicesXml = New-Object System.Xml.XmlDocument
$servicesNode = $servicesXml.CreateElement("Services")
$servicesXml.AppendChild($servicesNode)	
$services = Get-WmiObject -Class Win32_Service | Select-Object DisplayName, Name, State, StartMode, DelayedAutoStart | Sort-Object -Property StartMode,DelayedAutoStart,DisplayName | ForEach-Object {
	$serviceNode = $servicesXml.CreateElement("Service")
	$serviceNode.SetAttribute("DisplayName", $_.DisplayName)
	$serviceNode.SetAttribute("Name", $_.Name)
	$serviceNode.SetAttribute("Status", $_.State)
	$startType = $_.StartMode
	if ($startType -eq "Auto") {
		if ($_.DelayedAutoStart -eq "True") {
			$startType = "AutomaticDelayed"
		} else {
			$startType = "Automatic"
		}
	}
	$serviceNode.SetAttribute("StartType", $startType)
	$servicesNode.AppendChild($serviceNode)
}
FormatXml -xmlDocument $servicesXml | Out-File -FilePath $XmlFile
@" 
<?xml version="1.0" encoding="utf-16"?>
<Services>
<Service DisplayName="Windows Update" Name="wuauserv" Status="Stopped" StartType="Manual" />
</Services>

"@ | Out-File -FilePath $XmlFileCustom
}
function ServicesDisable {
	$disableServicesXml = [xml](Get-Content -Path $XmlFileCustom)
	$servicesToDisable = $disableServicesXml.SelectNodes("//Service") | ForEach-Object {
		$_.GetAttribute("Name")
	}
	$servicesToDisable | ForEach-Object {
		$serviceName = $_
		$service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue
		if ($service -ne $null) {
			if ($service.StartType -ne 'Disabled') {
				Set-Service -Name $serviceName -StartupType Disabled
			}
		}
		else {
			Write-Warning "Service '$serviceName' not found."
		}
	}
}
function ServicesRestore {
	$disableServicesXml = [xml](Get-Content -Path $XmlFileCustom)
	$servicesToDisable = $disableServicesXml.SelectNodes("//Service")
	$servicesToDisable | ForEach-Object {
		$serviceName = $_.GetAttribute("Name")
		$desiredStartType = $_.GetAttribute("StartType")
		
		$service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue
		if ($service -ne $null) {
			if ($service.StartType -ne $desiredStartType) {
				if ($desiredStartType -eq "AutomaticDelayed") {$desiredStartType = "Automatic"}
				Set-Service -Name $serviceName -StartupType $desiredStartType
			}
		}
		else {
			Write-Warning "Service '$serviceName' not found."
		}
	}
}
if ($args.Length -eq 0) {
    WriteXml
}
elseif ($args.Length -eq 1) {
    $option = $args[0]
    if ($option -eq "-Disable") {
        ServicesDisable
    }
    elseif ($option -eq "-Restore") {
        ServicesRestore
    }
}
else {
    Write-Error "Invalid option or parameter."
}
#
#.\setServices.ps1
# 
# $serviceName="onesyncsvc";$service=Get-Service -Name "$serviceName" -ErrorAction SilentlyContinue;if($service -ne $null){Set-Service -Name "$serviceName" -StartupType "manual"};
# $serviceName="MapsBroker";$service=Get-Service -Name "$serviceName" -ErrorAction SilentlyContinue;if($service -ne $null){Set-Service -Name "$serviceName" -StartupType "manual"};
# $serviceName="gupdate"   ;$service=Get-Service -Name "$serviceName" -ErrorAction SilentlyContinue;if($service -ne $null){Set-Service -Name "$serviceName" -StartupType "manual"};
#
#.\getService.ps1
#
# # before
# Get-Service | select -property displayname,name,status,starttype | Format-Table -AutoSize > c:\tools\services1.txt
# 
# # stop
# $StartupType = "Disabled" ;
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "Barracuda Backup Agent"                              } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "SAP Business One Browser Access Server Gatekeeper"   } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "SAP Business One Client Agent"                       } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "SAP Business One RSP Agent Service"                  } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "ScreenConnect Client (8d010516576b0b5b)"             } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "ScreenConnect Client (af0850bc674c83b9)"             } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "World Wide Web Publishing Service"                   } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "Windows Update"                                      } | Set-Service -StartupType $StartupType
# 
# # start
# $StartupType = "Automatic" ;
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "Barracuda Backup Agent"                              } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "SAP Business One Browser Access Server Gatekeeper"   } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "SAP Business One Client Agent"                       } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "SAP Business One RSP Agent Service"                  } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "ScreenConnect Client (8d010516576b0b5b)"             } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "ScreenConnect Client (af0850bc674c83b9)"             } | Set-Service -StartupType $StartupType
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "World Wide Web Publishing Service"                   } | Set-Service -StartupType $StartupType
# $StartupType = "Manual" ;
# Get-Service | select -property displayname,name,status,starttype | where {$_.Name -eq "Windows Update"                                      } | Set-Service -StartupType $StartupType
# 
# # after
# Get-Service | select -property displayname,name,status,starttype | Format-Table -AutoSize > c:\tools\services2.txt
# 
# #AutomaticDelayedStart,Automatic,Disabled,Manual 
# $displayNames = @("AnyDesk Service","Windows Update")
# Get-Service | Where-Object {$displayNames -contains $_.DisplayName}
# Get-Service | Where-Object {$displayNames -eq       $_.DisplayName}
# Get-Service | select -property displayname,name,status,starttype | Format-Table -AutoSize
# Get-Service | Where-Object {$_.Status -eq "Running"} | Where-Object {$_.StartType -eq "Automatic"}
# Get-Service | Where-Object {$_.Status -eq "Running"} | Where-Object {$_.StartType -eq "AutomaticDelayedStart"}
# Get-Service | Where-Object {$_.Status -eq "Running"} | Where-Object {$_.StartType -eq "Automatic"} | select -property displayname
# Get-Service | Where-Object {$_.StartupType -eq "Automatic"} | select -property * | Format-Table -AutoSize
# Get-Service | select -property Name,ServiceName,DisplayName,Status,StartType | Format-Table -AutoSize
# Get-WmiObject        win32_service                 | ?{$_.DisplayName -like '*SAP*'}           | Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# Get-WmiObject -Class Win32_Service -Filter "                              startmode='auto'"    | Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# Get-WmiObject -Class Win32_Service -Filter "                              startmode='manual'"  | Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# Get-WmiObject -Class Win32_Service -Filter "                              startmode='disabled'"| Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# Get-WmiObject -Class Win32_Service -Filter "state='running'           and startmode='auto'"    | Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# Get-WmiObject -Class Win32_Service -Filter "state='stopped'           and startmode='auto'"    | Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# Get-WmiObject -Class Win32_Service -Filter "delayedautostart = 'true' and startmode='auto'"    | Select-Object DisplayName,Name,State,StartMode,DelayedAutoStart | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap
# 
# # Notes
# 
# cd C:\Temp\                                                                                                       
# Get-WmiObject -list *service*                                                                                     
# Get-WmiObject win32_service                                                                                       
# Get-WmiObject win32_service | Format-List *                                                                       
# Get-WmiObject win32_service | Where-Object {$_.StartName} like '%Local%'                                          
# Get-WmiObject win32_service | Where-Object {$_.StartName} -like '%Local%'                                         
# Get-WmiObject win32_service | Where-Object {$_.StartName} -clike '%Local%'                                        
# Get-WmiObject win32_service | Where-Object {$_.StartName}                                                         
# Get-WmiObject win32_service | Format-List *                                                                       
# Get-WmiObject win32_service | Where-Object {$_.StartName} -eq "LocalSystem"                                       
# Get-WmiObject win32_service | Select-Object {$_.xx}                                                               
# Get-WmiObject win32_service | Select-Object {$_.StartName}                                                        
# Get-WmiObject win32_service | where-Object {$_.StartName -eq "LocalSystem"}                                       
# Get-WmiObject win32_service | where-Object {$_.StartName -like "yste"}                                            
# Get-WmiObject win32_service | where-Object {$_.StartName -like "*yste*"}                                          
# Get-WmiObject win32_service | where-Object {$_.StartName -like "*Syste*"}                                         
# Get-WmiObject win32_service | where-Object {$_.StartName -like "*Syste*"} | select Name, StartName, State         
# Get-WmiObject win32_service | where-Object {$_.StartName -like "*Syste*"} | select Name, StartName, State | for...
# Get-WmiObject win32_service | where-Object {$_.StartName -like "*Syste*"} | select Name, StartName, State       
#
# Automatic
#
#Get-WmiObject win32_service | where-Object {$_.Name -eq "NlaSvc"} | Select-Object *
#
#PSComputerName          : XPS15
#Name                    : NlaSvc
#Status                  : OK
#ExitCode                : 0
#DesktopInteract         : False
#ErrorControl            : Normal
#PathName                : C:\WINDOWS\System32\svchost.exe -k NetworkService -p
#ServiceType             : Share Process
#StartMode               : Auto
#__GENUS                 : 2
#__CLASS                 : Win32_Service
#__SUPERCLASS            : Win32_BaseService
#__DYNASTY               : CIM_ManagedSystemElement
#__RELPATH               : Win32_Service.Name="NlaSvc"
#__PROPERTY_COUNT        : 26
#__DERIVATION            : {Win32_BaseService, CIM_Service, CIM_LogicalElement, CIM_ManagedSystemElement}
#__SERVER                : XPS15
#__NAMESPACE             : root\cimv2
#__PATH                  : \\XPS15\root\cimv2:Win32_Service.Name="NlaSvc"
#AcceptPause             : False
#AcceptStop              : True
#Caption                 : Network Location Awareness
#CheckPoint              : 0
#CreationClassName       : Win32_Service
#DelayedAutoStart        : False
#Description             : Collects and stores configuration information for the network and notifies programs when this information is modified. If this service is stopped, configuration information might be unavailable. If this service is disabled, any services that explicitly depend on it will fail to start.
#DisplayName             : Network Location Awareness
#InstallDate             : 
#ProcessId               : 2748
#ServiceSpecificExitCode : 0
#Started                 : True
#StartName               : NT AUTHORITY\NetworkService
#State                   : Running
#SystemCreationClassName : Win32_ComputerSystem
#SystemName              : XPS15
#TagId                   : 0
#WaitHint                : 0
#Scope                   : System.Management.ManagementScope
#Path                    : \\XPS15\root\cimv2:Win32_Service.Name="NlaSvc"
#Options                 : System.Management.ObjectGetOptions
#ClassPath               : \\XPS15\root\cimv2:Win32_Service
#Properties              : {AcceptPause, AcceptStop, Caption, CheckPoint...}
#SystemProperties        : {__GENUS, __CLASS, __SUPERCLASS, __DYNASTY...}
#Qualifiers              : {dynamic, Locale, provider, UUID}
#Site                    : 
#Container               : 
#
# AutomaticTriggered
#
#Get-WmiObject win32_service | where-Object {$_.Name -eq "Dnscache"} | Select-Object *
#
#PSComputerName          : XPS15
#Name                    : Dnscache
#Status                  : OK
#ExitCode                : 0
#DesktopInteract         : False
#ErrorControl            : Normal
#PathName                : C:\WINDOWS\system32\svchost.exe -k NetworkService -p
#ServiceType             : Share Process
#StartMode               : Auto
#__GENUS                 : 2
#__CLASS                 : Win32_Service
#__SUPERCLASS            : Win32_BaseService
#__DYNASTY               : CIM_ManagedSystemElement
#__RELPATH               : Win32_Service.Name="Dnscache"
#__PROPERTY_COUNT        : 26
#__DERIVATION            : {Win32_BaseService, CIM_Service, CIM_LogicalElement, CIM_ManagedSystemElement}
#__SERVER                : XPS15
#__NAMESPACE             : root\cimv2
#__PATH                  : \\XPS15\root\cimv2:Win32_Service.Name="Dnscache"
#AcceptPause             : False
#AcceptStop              : False
#Caption                 : DNS Client
#CheckPoint              : 0
#CreationClassName       : Win32_Service
#DelayedAutoStart        : False
#Description             : The DNS Client service (dnscache) caches Domain Name System (DNS) names and registers the full computer name for this computer. If the service is stopped, DNS names will continue to be resolved. However, the results of DNS name queries will not be cached and the computer's name will not be registered. If the service is disabled, any services that explicitly depend on it will fail to start.
#DisplayName             : DNS Client
#InstallDate             : 
#ProcessId               : 3536
#ServiceSpecificExitCode : 0
#Started                 : True
#StartName               : NT AUTHORITY\NetworkService
#State                   : Running
#SystemCreationClassName : Win32_ComputerSystem
#SystemName              : XPS15
#TagId                   : 0
#WaitHint                : 0
#Scope                   : System.Management.ManagementScope
#Path                    : \\XPS15\root\cimv2:Win32_Service.Name="Dnscache"
#Options                 : System.Management.ObjectGetOptions
#ClassPath               : \\XPS15\root\cimv2:Win32_Service
#Properties              : {AcceptPause, AcceptStop, Caption, CheckPoint...}
#SystemProperties        : {__GENUS, __CLASS, __SUPERCLASS, __DYNASTY...}
#Qualifiers              : {dynamic, Locale, provider, UUID}
#Site                    : 
#Container               : 
#
# Delayed
#
#Get-WmiObject win32_service | where-Object {$_.Name -eq "WSearch"} | Select-Object *
#
#PSComputerName          : XPS15
#Name                    : WSearch
#Status                  : OK
#ExitCode                : 0
#DesktopInteract         : False
#ErrorControl            : Normal
#PathName                : C:\WINDOWS\system32\SearchIndexer.exe /Embedding
#ServiceType             : Own Process
#StartMode               : Auto
#__GENUS                 : 2
#__CLASS                 : Win32_Service
#__SUPERCLASS            : Win32_BaseService
#__DYNASTY               : CIM_ManagedSystemElement
#__RELPATH               : Win32_Service.Name="WSearch"
#__PROPERTY_COUNT        : 26
#__DERIVATION            : {Win32_BaseService, CIM_Service, CIM_LogicalElement, CIM_ManagedSystemElement}
#__SERVER                : XPS15
#__NAMESPACE             : root\cimv2
#__PATH                  : \\XPS15\root\cimv2:Win32_Service.Name="WSearch"
#AcceptPause             : False
#AcceptStop              : True
#Caption                 : Windows Search
#CheckPoint              : 0
#CreationClassName       : Win32_Service
#DelayedAutoStart        : True
#Description             : Provides content indexing, property caching, and search results for files, e-mail, and other content.
#DisplayName             : Windows Search
#InstallDate             : 
#ProcessId               : 7384
#ServiceSpecificExitCode : 0
#Started                 : True
#StartName               : LocalSystem
#State                   : Running
#SystemCreationClassName : Win32_ComputerSystem
#SystemName              : XPS15
#TagId                   : 0
#WaitHint                : 0
#Scope                   : System.Management.ManagementScope
#Path                    : \\XPS15\root\cimv2:Win32_Service.Name="WSearch"
#Options                 : System.Management.ObjectGetOptions
#ClassPath               : \\XPS15\root\cimv2:Win32_Service
#Properties              : {AcceptPause, AcceptStop, Caption, CheckPoint...}
#SystemProperties        : {__GENUS, __CLASS, __SUPERCLASS, __DYNASTY...}
#Qualifiers              : {dynamic, Locale, provider, UUID}
#Site                    : 
#Container               : 
#
# Delayed, Triggered
#
#Get-WmiObject win32_service | where-Object {$_.Name -eq "DellClientManagementService"} | Select-Object *
#
#PSComputerName          : XPS15
#Name                    : DellClientManagementService
#Status                  : OK
#ExitCode                : 0
#DesktopInteract         : False
#ErrorControl            : Normal
#PathName                : "C:\Program Files (x86)\Dell\UpdateService\ServiceShell.exe"
#ServiceType             : Own Process
#StartMode               : Auto
#__GENUS                 : 2
#__CLASS                 : Win32_Service
#__SUPERCLASS            : Win32_BaseService
#__DYNASTY               : CIM_ManagedSystemElement
#__RELPATH               : Win32_Service.Name="DellClientManagementService"
#__PROPERTY_COUNT        : 26
#__DERIVATION            : {Win32_BaseService, CIM_Service, CIM_LogicalElement, CIM_ManagedSystemElement}
#__SERVER                : XPS15
#__NAMESPACE             : root\cimv2
#__PATH                  : \\XPS15\root\cimv2:Win32_Service.Name="DellClientManagementService"
#AcceptPause             : False
#AcceptStop              : True
#Caption                 : Dell Client Management Service
#CheckPoint              : 0
#CreationClassName       : Win32_Service
#DelayedAutoStart        : True
#Description             : Enables Dell applications to manage Dell specific features of the system. If this service is stopped, any services that explicitly depend on it will cause this service to be restarted. If this service is disabled, any services that explicitly depend on it will fail to function.
#DisplayName             : Dell Client Management Service
#InstallDate             : 
#ProcessId               : 5068
#ServiceSpecificExitCode : 0
#Started                 : True
#StartName               : LocalSystem
#State                   : Running
#SystemCreationClassName : Win32_ComputerSystem
#SystemName              : XPS15
#TagId                   : 0
#WaitHint                : 0
#Scope                   : System.Management.ManagementScope
#Path                    : \\XPS15\root\cimv2:Win32_Service.Name="DellClientManagementService"
#Options                 : System.Management.ObjectGetOptions
#ClassPath               : \\XPS15\root\cimv2:Win32_Service
#Properties              : {AcceptPause, AcceptStop, Caption, CheckPoint...}
#SystemProperties        : {__GENUS, __CLASS, __SUPERCLASS, __DYNASTY...}
#Qualifiers              : {dynamic, Locale, provider, UUID}
#Site                    : 
#Container               : 
#

