write-Host "Cleanup Started" -ForegroundColor Green

#Remove the temp files
$tempFilesENV = Get-ChildItem "env:\TEMP"
$tempFiles = $tempFilesENV.Value
Remove-Item "$tempFiles\*" -Recurse -Force -ErrorAction SilentlyContinue

#Remove windows prefetch files
#$windowsPrefetch = "C:\Windows\Prefetch\*"
#Remove-Item "$windowsPrefetch" -Recurse -Force -ErrorAction SilentlyContinue

#Remove windows temp files
$windowsTemp = "C:\Windows\Temp\*"
Remove-Item "$windowsTemp" -Recurse -Force -ErrorAction SilentlyContinue

#Remove old Windows Updates
$winDist = "C:\Windows\SoftwareDistribution\*"
Get-Service -Name WUAUSERV | Stop-Service -Force
Remove-Item "$winDist" -Recurse -Force -ErrorAction SilentlyContinue
Get-Service -Name WUAUSERV | Start-Service

#Running Disk Clean up Tool
cleanmgr /sagerun:1 | out-Null
$([char]7)
Sleep 1
write-Host "Cleanup Finished" -ForegroundColor Green
Sleep 1

