## NOTES

### OLD

pool=zfs; zpool create -f $pool -o ashift=0 -o xattr=on -o sync=standard -o compression=off -o atime=on  -o relatime=off -o recordsize=128K dedup=off -o logbias=latency -o primarycache=all -o secondarycache=all -o keyformat=none -o sharesmb=off -o sharenfs=off -o mountpoint=/zfs -o altroot= \

### current 1048576
options zfs zfs_arc_min=4294967296    #4
options zfs zfs_arc_max=1236950581248 #32
options zfs zfs_prefetch_disable=0
options zfs zfs_dirty_data_max=2147483648     #2
options zfs zfs_dirty_data_max_max=4294967296 #4
options zfs zfs_dirty_data_max_max_percent=25
options zfs zfs_dirty_data_max_percent=10
options zfs zfs_dirty_data_sync_percent=20

### suggested
options zfs zfs_arc_min=8589934592            #(( zfs_arc_min =  8 * 1024 * 1024 * 1024 ));echo $zfs_arc_min
options zfs zfs_arc_max=106300440567          #(( zfs_arc_max = 99 * 1024 * 1024 * 1024 ));echo $zfs_arc_max
options zfs zfs_prefetch_disable=1
options zfs zfs_nocacheflush=1
options zfs zfs_arc_meta_limit_percent=95
vm.dirty_background_bytes=134217728
vm.dirty_bytes=1073741824

### ubuntu

#https://askubuntu.com/questions/228386/how-do-you-apply-performance-tuning-settings-for-native-zfs
vfs.zfs.prefetch_disable="1"
vfs.zfs.txg.timeout="5"
kern.maxvnodes=250000
vfs.zfs.write_limit_override=1073741824
vfs.zfs.arc_min="512M"
vfs.zfs.arc_max="1536M"
vm.kmem_size_max="8G"
vm.kmem_size="6G"
zil_nocacheflush=1
zfs_nocacheflush=1
#1048576

### timmann

#https://lars.timmann.de/wiki/index.php/ZFS_on_Linux#:~:text=settings%20for%20ZFS-,Set%20module%20parameter%20in%20/etc/modprobe.d/zfs.conf,-options%20zfs%20zfs_arc_max
# increase them so scrub/resilver is more quickly at the cost of other work
options zfs zfs_vdev_scrub_min_active=24
options zfs zfs_vdev_scrub_max_active=64
# sync write
options zfs zfs_vdev_sync_write_min_active=8
options zfs zfs_vdev_sync_write_max_active=32
# sync reads (normal)
options zfs zfs_vdev_sync_read_min_active=8
options zfs zfs_vdev_sync_read_max_active=32
# async reads : prefetcher
options zfs zfs_vdev_async_read_min_active=8
options zfs zfs_vdev_async_read_max_active=32
# async write : bulk writes
options zfs zfs_vdev_async_write_min_active=8
options zfs zfs_vdev_async_write_max_active=32
# max write speed to l2arc
# tradeoff between write/read and durability of ssd (?)
# default : 8 * 1024 * 1024
# setting here : 500 * 1024 * 1024
options zfs l2arc_write_max=524288000
options zfs zfs_top_maxinflight=512
options zfs zfs_resilver_min_time_ms=8000
options zfs zfs_resilver_delay=0
#https://wiki.freebsd.org/ZFSTuningGuide#:~:text=to%20FreeBSD%20too.-,General%20Tuning,-There%20are%20some
#https://jro.io/nas/#overhead

