# XCC

set 'maximum performance' in uefi

# OS

## UPDATE

apt update && apt upgrade -y && apt auto-clean -y && apt autoremove -y

## KERNEL

apt install -y git
cd /tmp
git clone https://github.com/jordanhillis/pvekclean.git
cd pvekclean
chmod +x pvekclean.sh
./pvekclean.sh
pvekclean
grep Huge /proc/meminfo
cat /sys/kernel/mm/transparent_hugepage/enabled
cp /etc/default/grub /etc/default/grub.bak
cat /etc/default/grub
sed -i 's/GRUB_CMDLINE_LINUX_DEFAULT="quiet"/GRUB_CMDLINE_LINUX_DEFAULT="transparent_hugepage=never"/g' /etc/default/grub
update-grub && update-initramfs -u -k all

# ZFS

## INFO

modinfo zfs
zpool status
zpool status -v
pveperf /zfs
arc_summary
cat /proc/spl/kstat/zfs/arcstats
zfs   get all zfs
zpool get all zfs
zpool iostat
zpool iostat -v

## CONF

#https://openzfs.github.io/openzfs-docs/Performance%20and%20Tuning/Module%20Parameters.html?highlight=txg#zfs-module-parameters-1
#https://openzfs.github.io/openzfs-docs/search.html?q=

conf="/etc/modprobe.d/zfs.conf";op="options zfs";cat $conf;
zfs_arc_min=8                     ;((zfs_arc_min=$zfs_arc_min*1024*1024*1024))                      ;zfs_arc_min="$op zfs_arc_min=$zfs_arc_min"                                 ;echo $zfs_arc_min >$conf;
zfs_arc_max=32                    ;((zfs_arc_max=$zfs_arc_max*1024*1024*1024))                      ;zfs_arc_max="$op zfs_arc_max=$zfs_arc_max"                                 ;echo $zfs_arc_max>>$conf;
zfs_dirty_data_max=2              ;((zfs_dirty_data_max=$zfs_dirty_data_max*1024*1024*1024))        ;zfs_dirty_data_max="$op zfs_dirty_data_max=$zfs_dirty_data_max"            ;echo $zfs_dirty_data_max>>$conf;
zfs_dirty_data_max_max=4          ;((zfs_dirty_data_max_max=$zfs_dirty_data_max_max*1024*1024*1024));zfs_dirty_data_max_max="$op zfs_dirty_data_max_max=$zfs_dirty_data_max_max";echo $zfs_dirty_data_max_max>>$conf;
zfs_dirty_data_max_max_percent=25 ;echo "$op ""zfs_dirty_data_max_max_percent=""$zfs_dirty_data_max_max_percent">>$conf;
zfs_dirty_data_max_percent=10     ;echo "$op ""zfs_dirty_data_max_percent=""$zfs_dirty_data_max_percent">>$conf;
zfs_dirty_data_sync_percent=20    ;echo "$op ""zfs_dirty_data_sync_percent=""$zfs_dirty_data_sync_percent">>$conf;
zfs_arc_dnode_limit=0             ;echo "$op ""zfs_arc_dnode_limit=""$zfs_arc_dnode_limit">>$conf;
zfs_arc_dnode_limit_percent=50    ;echo "$op ""zfs_arc_dnode_limit_percent=""$zfs_arc_dnode_limit_percent">>$conf;
zfs_arc_meta_limit=0              ;echo "$op ""zfs_arc_meta_limit=""$zfs_arc_meta_limit">>$conf;
zfs_arc_meta_limit_percent=95     ;echo "$op ""zfs_arc_meta_limit_percent=""$zfs_arc_meta_limit_percent">>$conf;
zfs_prefetch_disable=1            ;echo "$op ""zfs_prefetch_disable=""$zfs_prefetch_disable">>$conf;
zfs_nocacheflush=1                ;echo "$op ""zfs_nocacheflush=""$zfs_nocacheflush">>$conf;
zfs_vdev_sync_write_min_active=8  ;echo "$op ""zfs_vdev_sync_write_min_active=""$zfs_vdev_sync_write_min_active">>$conf;
zfs_vdev_sync_write_max_active=32 ;echo "$op ""zfs_vdev_sync_write_max_active=""$zfs_vdev_sync_write_max_active">>$conf;
zfs_vdev_sync_read_min_active=8   ;echo "$op ""zfs_vdev_sync_read_min_active=""$zfs_vdev_sync_read_min_active">>$conf;
zfs_vdev_sync_read_max_active=32  ;echo "$op ""zfs_vdev_sync_read_max_active=""$zfs_vdev_sync_read_max_active">>$conf;
zfs_vdev_async_read_min_active=8  ;echo "$op ""zfs_vdev_async_read_min_active=""$zfs_vdev_async_read_min_active">>$conf;
zfs_vdev_async_read_max_active=32 ;echo "$op ""zfs_vdev_async_read_max_active=""$zfs_vdev_async_read_max_active">>$conf;
zfs_vdev_async_write_min_active=8 ;echo "$op ""zfs_vdev_async_write_min_active=""$zfs_vdev_async_write_min_active">>$conf;
zfs_vdev_async_write_max_active=32;echo "$op ""zfs_vdev_async_write_max_active=""$zfs_vdev_async_write_max_active">>$conf;
zfs_txg_timeout=5                 ;echo "$op ""zfs_txg_timeout=""$zfs_txg_timeout">>$conf;

cat $conf;
update-grub && update-initramfs -u -k all;

## DISKS

SSD_A="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800315"
SSD_B="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800448"
SSD_C="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800696"
SSD_D="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800727"
SSD_E="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800774"
SSD_F="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800890"
SSD_G="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800007"
SSD_H="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800555"
SSD_I="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800643"
SSD_J="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800698"
SSD_K="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800722"
SSD_L="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800863"

cat << EOF > /etc/zfs/vdev_id.conf
alias SSD_A_WD_315 ata-WDC_WDS200T1R0A-68A4W0_22160Y800315-part1
alias SSD_B_WD_448 ata-WDC_WDS200T1R0A-68A4W0_22160Y800448-part1
alias SSD_C_WD_696 ata-WDC_WDS200T1R0A-68A4W0_22160Y800696-part1
alias SSD_D_WD_727 ata-WDC_WDS200T1R0A-68A4W0_22160Y800727-part1
alias SSD_E_WD_774 ata-WDC_WDS200T1R0A-68A4W0_22160Y800774-part1
alias SSD_F_WD_890 ata-WDC_WDS200T1R0A-68A4W0_22160Y800890-part1
alias SSD_G_WD_007 ata-WDC_WDS200T1R0A-68A4W0_22160Y800007-part1
alias SSD_H_WD_555 ata-WDC_WDS200T1R0A-68A4W0_22160Y800555-part1
alias SSD_I_WD_643 ata-WDC_WDS200T1R0A-68A4W0_22160Y800643-part1
alias SSD_J_WD_698 ata-WDC_WDS200T1R0A-68A4W0_22160Y800698-part1
alias SSD_K_WD_722 ata-WDC_WDS200T1R0A-68A4W0_22160Y800722-part1
alias SSD_L_WD_863 ata-WDC_WDS200T1R0A-68A4W0_22160Y800863-part1
EOF

udevadm trigger

## PARTITION

parted $SSD_A --script -- mklabel gpt
parted $SSD_B --script -- mklabel gpt
parted $SSD_C --script -- mklabel gpt
parted $SSD_D --script -- mklabel gpt
parted $SSD_E --script -- mklabel gpt
parted $SSD_F --script -- mklabel gpt
parted $SSD_G --script -- mklabel gpt
parted $SSD_H --script -- mklabel gpt
parted $SSD_I --script -- mklabel gpt
parted $SSD_J --script -- mklabel gpt
parted $SSD_K --script -- mklabel gpt
parted $SSD_L --script -- mklabel gpt

## POOL

pool=zfs
 zpool create -f $pool -o ashift=12 -o autotrim=on \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800315 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800448 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800696 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800727 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800774 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800890 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800007 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800555 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800643 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800698 \
 mirror /dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800722 \
		/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800863

zfs get recordsize,xattr,compression,sync,atime,relatime,dedup,logbias,primarycache,secondarycache $pool #pool=zfs; zpool create -f $pool -o ashift=0 -o xattr=on -o sync=standard -o compression=off -o atime=on  -o relatime=off -o recordsize=128K dedup=off -o logbias=latency -o primarycache=all -o secondarycache=all -o keyformat=none -o sharesmb=off -o sharenfs=off -o mountpoint=/zfs -o altroot= \

 pveperf /zfs
 zfs set recordsize=128K       $pool
 zfs set xattr=sa              $pool
 zfs set sync=disabled         $pool
 zfs set compression=lz4       $pool
 zfs set atime=off             $pool
 zfs set relatime=on           $pool
 zfs set dedup=off             $pool
 zfs set logbias=throughput    $pool
 zfs set primarycache=metadata $pool
 zfs set secondarycache=none   $pool
#zfs set sharesmb=off          $pool
#zfs set sharenfs=off          $pool
#zfs set volblocksize=16K      $pool
#zfs set keyformat=raw         $pool
 pveperf /zfs

zpool set autotrim=on             $pool
zpool export                      $pool
zpool import -d /dev/disk/by-vdev $pool
#zpool import -c /etc/$pool/zpool.cache -aN

## STORAGE

pvesm add zfspool $pool -pool $pool -blocksize 16K -content rootdir,images -mountpoint /zfs -nodes pve6k,pve7k -sparse 1

## VM

pve="pve011";id="172222410"  ;vm="unirez24dc"      ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve011";id="172222411" ;vm="unirez24sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
pve="pve011";id="172222412"  ;vm="unirez24dia"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  16384 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
pve="pve011";id="172222413"  ;vm="unirez24mara"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  32768 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve011";id="172222420" ;vm="unirez24rds"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio2 zfs:vm-$id-disk-2,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
pve="pve011";id="172222421"  ;vm="unirez24ts1"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  49152 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
pve="pve011";id="172222422"  ;vm="unirez24ts2"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  49152 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
pve="pve011";id="172222423"  ;vm="unirez24ts3"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  49152 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve012";id="172221211" ;vm="unirez-12-sld"   ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve012";id="172221221" ;vm="unirez-12-rds"   ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve012";id="172221222" ;vm="unirez-12-adm-dc";qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve012";id="172222510";vm="unirez25sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve012";id="172222520" ;vm="unirez25ts"      ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  24576 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve012";id="172222552";vm="unirez-mt01"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon 65536 -memory 327680 -sockets 2 -cores 16 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio2 zfs:vm-$id-disk-2,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio3 zfs:vm-$id-disk-3,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio4 zfs:vm-$id-disk-6,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio5 zfs:vm-$id-disk-4,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio6 zfs:vm-$id-disk-5,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512;
  pve="pve012";id="172222553";vm="unirez-mt02"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon 65536 -memory 196608 -sockets 2 -cores  8 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio2 zfs:vm-$id-disk-2,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio3 zfs:vm-$id-disk-3,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio4 zfs:vm-$id-disk-4,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512;
 pve="pve013";id="17222263"  ;vm="unirez26win1"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   4096 -sockets 1 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="17222264" ;vm="unirez26win2"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222265"  ;vm="unirez26win3"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222273"  ;vm="unirez27win1"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   4096 -sockets 1 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222274"  ;vm="unirez27win2"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222275"  ;vm="unirez27win3"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  16384 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222283"  ;vm="unirez28win1"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   4096 -sockets 1 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222284"  ;vm="unirez28win2"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222285"  ;vm="unirez28win3"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  16384 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222293"  ;vm="unirez29win1"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   4096 -sockets 1 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222294"  ;vm="unirez29win2"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222295"  ;vm="unirez29win3"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="17222302" ;vm="unirez30hana"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon 65536 -memory  81920 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio2 zfs:vm-$id-disk-2,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio3 zfs:vm-$id-disk-3,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio4 zfs:vm-$id-disk-4,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512 -virtio5 zfs:vm-$id-disk-5,aio=native,discard=on,iothread=1,mbps_rd=512,mbps_wr=512;
 pve="pve013";id="17222303"  ;vm="unirez30win1"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   4096 -sockets 1 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222304"  ;vm="unirez30win2"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222305"  ;vm="unirez30win3"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory  16384 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222313"  ;vm="unirez31win1"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   4096 -sockets 1 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222314"  ;vm="unirez31win2"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  1 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
 pve="pve013";id="17222315"  ;vm="unirez31win3"    ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  2048 -memory   8192 -sockets 2 -cores  2 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="172222610";vm="unirez26sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="172222710";vm="unirez27sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="172222810";vm="unirez28sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="172222910";vm="unirez29sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
  pve="pve013";id="172223110";vm="unirez31sld"     ;qm set $id -delete shares,onboot,spice_enhancements -agent 1,fstrim_cloned_disks=1 -balloon  8192 -memory  16384 -sockets 2 -cores  4 -cpu kvm64 -numa 1 -vga std -scsihw virtio-scsi-single -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256 -virtio1 zfs:vm-$id-disk-1,aio=native,discard=on,iothread=1,mbps_rd=256,mbps_wr=256;
