#!/bin/bash

# make this script executable
#chmod +x /root/hostIpUpdate.sh

# create a cronjob at boot for this script
#@reboot  /root/hostIpUpdate.sh

# define the parameters
net_interface=vmbr0
net_host=$(cat /etc/hostname)
net_domain=$(dnsdomainname)
net_domain="mgmt.local"
net_fqdn="$net_host.$net_domain"
net_address=$(ip addr show $net_interface | awk '/inet / {print $2}' | cut -d/ -f1)

# Define the line to be added to /etc/hosts
line="$net_address $net_host $net_fqdn"

# Make a backup of /etc/hosts
cp /etc/hosts /etc/hosts.bak

# Delete the previous line in /etc/hosts
sed -i "/$net_host/d" /etc/hosts

# Append the new line to /etc/hosts
echo "$line" >> /etc/hosts

# update /etc/issue
echo "                                     ">  /etc/issue
echo " ----------------------------------- ">> /etc/issue
echo "                                     ">> /etc/issue
echo " PVE @ https://$net_address:8006     ">> /etc/issue
echo " PBS @ https://$net_address:8007     ">> /etc/issue
echo "                                     ">> /etc/issue
echo " ----------------------------------- ">> /etc/issue
echo "                                     ">> /etc/issue

# example /etc/network/interfaces
#
# auto eno1
# iface eno1 inet manual
# 
# auto vmbr0
# iface vmbr0 inet dhcp
#         bridge-ports eno1
#         bridge-stp off
#         bridge-fd 0
# 

