#shutdown vm and make sure there is no snapshots
#run veeam backup task
#run veeam replica task when backup task finished
#set parameters for migration to proxmox
esx="pve3k";pve="pve6k";esxRoot="/mnt/sshfs/$esx";clone="100000011";netapp="SAN01DS01";vm="hanab10sp4";dsm="DSM2RW";rep=$vm"_v2p";id="17001065";
#mount sshfs to retrieve vm info
mkdir -p $esxRoot
sshfs -o allow_other,default_permissions root@$esx:/vmfs/volumes/ $esxRoot
#remove snapshots on the replica (when you do it, veeam replica will calculate digests again, which will take time)
repId=$(ssh root@$esx "vim-cmd vmsvc/getallvms | grep $rep" | awk -F ' ' '{print $1}');echo $repId;
ssh root@$esx "vim-cmd vmsvc/snapshot.get $repId;vim-cmd vmsvc/snapshot.removeall $repId";
#collect some info of the source vm
sourceRoot="$esxRoot/$netapp/$vm";echo "$sourceRoot";
cat    $sourceRoot/$vm*.vmx |grep 'vmdk"'       |sort
#scsi0:0.fileName = "hanab10sp4.vmdk"
#scsi0:1.fileName = "hanab10sp4_11.vmdk"
#scsi0:2.fileName = "hanab10sp4_2.vmdk"
#scsi0:3.fileName = "hanab10sp4_16.vmdk"
#scsi0:4.fileName = "hanab10sp4_4.vmdk"
#scsi0:5.fileName = "hanab10sp4_5.vmdk"
#scsi0:6.fileName = "hanab10sp4_6.vmdk"
ls -lh $sourceRoot/$vm*.vmdk                     
cat    $sourceRoot/$vm*.vmx |grep '.address = ' |sort
#collect some info of the clone
repRoot="$esxRoot/$dsm/$rep";
cat    $repRoot/$vm*.vmx |grep 'vmdk"'          |sort
#scsi0:0.fileName = "hanab10sp4.vmdk"
#scsi0:1.fileName = "hanab10sp4_11.vmdk"
#scsi0:2.fileName = "hanab10sp4_2.vmdk"
#scsi0:3.fileName = "hanab10sp4_16.vmdk"
#scsi0:4.fileName = "hanab10sp4_4.vmdk"
#scsi0:5.fileName = "hanab10sp4_5.vmdk"
#scsi0:6.fileName = "hanab10sp4_6.vmdk"
ls -lh $repRoot/$vm*.vmdk
cat    $repRoot/$vm*.vmx |grep '.address = '    |sort
#set replica parameters
vmDisk1=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4.vmdk"'    | cut -d \" -f2`;echo $vmDisk1;vmDisk1="/mnt/pve/dsm2/vcenter/$rep/$vmDisk1";ls -lah $vmDisk1;echo "[vmDisk1=$vmDisk1]";
vmDisk2=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4_11.vmdk"' | cut -d \" -f2`;echo $vmDisk1;vmDisk2="/mnt/pve/dsm2/vcenter/$rep/$vmDisk2";ls -lah $vmDisk2;echo "[vmDisk1=$vmDisk2]";
vmDisk3=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4_2.vmdk"'  | cut -d \" -f2`;echo $vmDisk1;vmDisk3="/mnt/pve/dsm2/vcenter/$rep/$vmDisk3";ls -lah $vmDisk3;echo "[vmDisk1=$vmDisk3]";
vmDisk4=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4_16.vmdk"' | cut -d \" -f2`;echo $vmDisk1;vmDisk4="/mnt/pve/dsm2/vcenter/$rep/$vmDisk4";ls -lah $vmDisk4;echo "[vmDisk1=$vmDisk4]";
vmDisk5=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4_4.vmdk"'  | cut -d \" -f2`;echo $vmDisk1;vmDisk5="/mnt/pve/dsm2/vcenter/$rep/$vmDisk5";ls -lah $vmDisk5;echo "[vmDisk1=$vmDisk5]";
vmDisk6=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4_5.vmdk"'  | cut -d \" -f2`;echo $vmDisk1;vmDisk6="/mnt/pve/dsm2/vcenter/$rep/$vmDisk6";ls -lah $vmDisk6;echo "[vmDisk1=$vmDisk6]";
vmDisk7=`cat $repRoot/$vm*.vmx |grep 'hanab10sp4_6.vmdk"'  | cut -d \" -f2`;echo $vmDisk1;vmDisk7="/mnt/pve/dsm2/vcenter/$rep/$vmDisk7";ls -lah $vmDisk7;echo "[vmDisk1=$vmDisk7]";
 vmMac1=`cat $repRoot/$vm*.vmx |grep ".ddress" | grep ':'  | cut -d \" -f2`;echo $vmMac1;echo "[vmMac1=$vmMac1]";
 vmconf="/etc/pve/nodes/$pve/qemu-server/$id.conf";
#clone template, update mac & bridge, import disk, update disk, add fake virtio, update boot order, then start the vm
 qm guest cmd    $id ping || {
 pvesh create /nodes/$pve/qemu/$clone/clone --newid $id --name $vm --full true
 qm set          $id --net0 virtio="$vmMac1",bridge=vmbr99;
 date >/tmp/date.txt;qm importdisk $id $vmDisk1 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk $id $vmDisk2 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk $id $vmDisk3 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk $id $vmDisk4 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk $id $vmDisk5 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk $id $vmDisk6 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk $id $vmDisk7 zfs --format raw;date >>/tmp/date.txt && cat /tmp/date.txt
 pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'first(to_entries[]|select(.key|startswith("unused"))).value'
 pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'last(to_entries[]|select(.key|startswith("unused"))).value'
 qm set          $id --sata0 zfs:vm-$id-disk-0
 qm set          $id --scsi0 zfs:vm-$id-disk-1
 qm set          $id --scsi1 zfs:vm-$id-disk-2
 qm set          $id --scsi2 zfs:vm-$id-disk-3
 qm set          $id --scsi3 zfs:vm-$id-disk-4
 qm set          $id --scsi4 zfs:vm-$id-disk-5
 qm set          $id --scsi5 zfs:vm-$id-disk-6
#qm importdisk   $id /mnt/pve/dsm1/images/disk.raw zfs --format raw
#qm set          $id --virtio0  zfs:vm-$id-disk-1
 pvesm alloc zfs $id "vm-$id-disk-15" 1M
 qm set          $id --virtio15 zfs:vm-$id-disk-15
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=sata0'>>"$vmconf"
 qm rescan --vm  $id
}   && qm start  $id
#login to vm and update settings
#review config and update settings
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\EnableSnmp.sh
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\HanaOnKvm.sh
#delete fake virtio, attach disk as virtio, enable network, update boot order
qm guest cmd $id ping || { 
 qm set $id -agent 1,fstrim_cloned_disks=1
 qm set $id -balloon 2048
 qm set $id -memory 40960
 qm set $id -sockets 2
 qm set $id -cores 2
 qm set $id -cpu host
 qm set $id -numa 1
 qm set $id -vga std
 qm set $id -delete virtio15
 qm set $id -delete unused0
 qm set $id -scsihw virtio-scsi-single
 qm set $id -delete sata0;qm set $id -virtio0 zfs:vm-$id-disk-0,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -delete scsi0;qm set $id -virtio1 zfs:vm-$id-disk-1,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -delete scsi1;qm set $id -virtio2 zfs:vm-$id-disk-2,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -delete scsi2;qm set $id -virtio3 zfs:vm-$id-disk-3,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -delete scsi3;qm set $id -virtio4 zfs:vm-$id-disk-4,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -delete scsi4;qm set $id -virtio5 zfs:vm-$id-disk-5,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -delete scsi5;qm set $id -virtio6 zfs:vm-$id-disk-6,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id -net0 virtio="$vmMac1",bridge=vmbr0
#qm set $id -delete shares,onboot,spice_enhancements
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=ide0;virtio0'>>"$vmconf"
 qm rescan --vm $id 
 cat "$vmconf"
}   && qm start $id
#do some cleanup if needed and shutdown pc
qm guest cmd  $id ping && {
 qm guest cmd  $id network-get-interfaces
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
 qm guest exec $id powershell -- "Stop-Computer -Force;"
}
#unregister vm from esxi
#remove vm replica from esxi
#remove vm from replica job
#disable backup/replica jobs

