#shutdown vm and make sure there is no snapshots
#run veeam backup task
#run veeam replica task when backup task finished
#set parameters for migration to proxmox
esx="pve3k";pve="pve6k";esxRoot="/mnt/sshfs/$esx";clone="100000001";netapp="SAN02DS02";vm="TS-DUS-Test";dsm="DSM2RW";rep=$vm"_v2p";id="17001099";
#mount sshfs to retrieve vm info
mkdir -p $esxRoot
sshfs -o allow_other,default_permissions root@$esx:/vmfs/volumes/ $esxRoot
#remove snapshots on the replica (when you do it, veeam replica will calculate digests again, which will take time)
repId=$(ssh root@$esx "vim-cmd vmsvc/getallvms | grep $rep" | awk -F ' ' '{print $1}');echo $repId;
ssh root@$esx "vim-cmd vmsvc/snapshot.get $repId;vim-cmd vmsvc/snapshot.removeall $repId";
#collect some info of the source vm
sourceRoot="$esxRoot/$netapp/$vm";echo "$sourceRoot";
cat    $sourceRoot/$vm*.vmx |grep 'vmdk"'       |sort
ls -lh $sourceRoot/$vm*.vmdk                     
cat    $sourceRoot/$vm*.vmx |grep '.address = ' |sort
#collect some info of the clone
repRoot="$esxRoot/$dsm/$rep";
cat    $repRoot/$vm*.vmx |grep 'vmdk"'          |sort
ls -lh $repRoot/$vm*.vmdk
cat    $repRoot/$vm*.vmx |grep '.address = '    |sort
#set replica parameters
vmDisk1=`cat $repRoot/$vm*.vmx |grep 'vmdk"' | cut -d \" -f2`;            echo $vmDisk1;vmDisk1="/mnt/pve/dsm2/vcenter/$rep/$vmDisk1";ls -lah $vmDisk1;echo "[vmDisk1=$vmDisk1]";
 vmMac1=`cat $repRoot/$vm*.vmx |grep ".ddress" | grep ':' |cut -d \" -f2`;echo $vmMac1;echo "[vmMac1=$vmMac1]";
#clone template, update mac & bridge, import disk, update disk, add fake virtio, update boot order, then start the vm
 qm guest cmd   $id ping || {
 pvesh create /nodes/$pve/qemu/$clone/clone --newid $id --name $vm --full true
 qm set         $id --net0 virtio="$vmMac1",bridge=vmbr99;date >/tmp/date.txt;
 date >/tmp/date.txt;
 qm importdisk  $id $vmDisk1 zfs --format raw
 date >>/tmp/date.txt && cat /tmp/date.txt
 qm set         $id --sata0 zfs:vm-$id-disk-0,discard=on,mbps_rd=128,mbps_wr=128
 qm importdisk  $id /mnt/pve/dsm1/images/disk.raw zfs --format raw
 qm set         $id --virtio0 zfs:vm-$id-disk-1
 sed -i '/boot:/d' /etc/pve/nodes/$pve/qemu-server/$id.conf
 echo 'boot: order=sata0'>>/etc/pve/nodes/$pve/qemu-server/$id.conf
 qm rescan --vm $id
}   && qm start $id
#review config and update settings
qm set $id \ 
 -delete shares,onboot,spice_enhancements \
 -agent 1,fstrim_cloned_disks=1 \
 -balloon 2048 \
 -memory 8192 \
 -sockets 2 \
 -cores 2 \
 -cpu kvm64 \
 -numa 1 \
 -vga std \
 -scsihw virtio-scsi-single \
 -virtio0 zfs:vm-$id-disk-0,aio=native,discard=on,iothread=1,mbps_rd=128,mbps_wr=128 
#login to vm and update settings
 qm guest cmd  $id ping && {
 qm guest cmd  $id network-get-interfaces
 qm guest exec $id cmd -- "/c ipconfig /all"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\setNetworkConfig.ps1;"
 qm guest exec $id powershell -- "Stop-Computer;"
}
#delete fake virtio, attach disk as virtio, enable network, update boot order
qm guest cmd $id ping || { 
 qm set $id --delete virtio0
 qm set $id --delete unused0
 qm set $id --delete sata0
 qm set $id --virtio0 zfs:vm-$id-disk-0,discard=on,aio=native,iothread=1,mbps_rd=128,mbps_wr=128
 qm set $id --net0 virtio="$vmMac1",bridge=vmbr0
 sed -i '/boot:/d' /etc/pve/nodes/$pve/qemu-server/$id.conf
 echo 'boot: order=ide0;virtio0'>>/etc/pve/nodes/$pve/qemu-server/$id.conf
 qm rescan --vm $id 
}   && qm start $id
#unregister vm from esxi
#remove vm replica from esxi
#remove vm from replica job
#disable backup/replica jobs

#set parameters for migration to proxmox
esx="pve3k";pve="pve6k";esxRoot="/mnt/sshfs/$esx";clone="100000001";netapp="SAN01DS02";vm="klutheha102";dsm="DSM2RW";rep=$vm"_v2p";id="17001082";
vmDisk1="/mnt/pve/dsm2/vcenter/klutheha102_v2p/klutheha102.vmdk"
vmDisk2="/mnt/pve/dsm2/vcenter/klutheha102_v2p/klutheha102_1.vmdk"
vmDisk3="/mnt/pve/dsm2/vcenter/klutheha102_v2p/klutheha102_2.vmdk"
vmDisk4="/mnt/pve/dsm2/vcenter/klutheha102_v2p/klutheha102_3.vmdk"
vmDisk5="/mnt/pve/dsm2/vcenter/klutheha102_v2p/klutheha102_4.vmdk"
 vmMac1="00:50:56:93:7e:bc"
#update vm, update mac & bridge, import disk, update disk, add fake virtio, update boot order, then start the vm
 qm guest cmd   $id ping || {
 qm set         $id --net0 virtio="$vmMac1",bridge=vmbr99
 date >/tmp/date.txt;qm importdisk  $id $vmDisk1 zfs --format raw;qm set $id --virtio0 zfs:vm-$id-disk-0,discard=on,mbps_rd=128,mbps_wr=128;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk  $id $vmDisk2 zfs --format raw;qm set $id --virtio1 zfs:vm-$id-disk-1,discard=on,mbps_rd=256,mbps_wr=256;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk  $id $vmDisk3 zfs --format raw;qm set $id --virtio2 zfs:vm-$id-disk-2,discard=on,mbps_rd=256,mbps_wr=256;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk  $id $vmDisk4 zfs --format raw;qm set $id --virtio3 zfs:vm-$id-disk-3,discard=on,mbps_rd=256,mbps_wr=256;date >>/tmp/date.txt && cat /tmp/date.txt
 date >/tmp/date.txt;qm importdisk  $id $vmDisk5 zfs --format raw;qm set $id --virtio4 zfs:vm-$id-disk-4,discard=on,mbps_rd=256,mbps_wr=256;date >>/tmp/date.txt && cat /tmp/date.txt
 sed -i '/boot:/d' /etc/pve/nodes/$pve/qemu-server/$id.conf
 echo 'boot: order=virtio0'>>/etc/pve/nodes/$pve/qemu-server/$id.conf
 qm rescan --vm $id
}

#links
https://docs.broadcom.com/docs-and-downloads/raid-controllers/raid-controllers-common-files/007.2007.0000.0000_Unified_StorCLI.zip
https://forum.proxmox.com/threads/start-vm-iothread-is-only-valid-with-virtio-disk-or-virtio-scsi-single-controller-ignoring.92463/#post-402775
https://forum.proxmox.com/threads/zfs-zvol-on-hdd-locks-up-vm.81831/
https://openzfs.github.io/openzfs-docs/Project%20and%20Community/FAQ.html
https://serverok.in/qm
https://gist.github.com/mrl22/df6cfcaab00d61b2e09943241ef8590c
#hooks
vmid="17001099";
qm guest exec $vmid "C:\WINDOWS\system32\cmd.exe" -- "/c ipconfig /all";
qm guest exec $vmid "C:\WINDOWS\system32\cmd.exe" -- "/c c:\tools\pve\post.cmd";
qm guest exec $vmid "C:\WINDOWS\system32\cmd.exe" -- "/c shutdown -s -t 3";
#ovftool for reference
ovftool --noSSLVerify 'vi://root:lala@172.17.10.14/TS-DUS-TEST-2' '/mnt/pve/dsm2/ova/TS-DUS-TEST-2.ova'
#prepare the machine
$pveDownload="https://files.esser.space/iso/etc/pve.zip"
$pvePath="c:\tools"
$pveZip="pve.zip"
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]'Tls11,Tls12'
#if (Test-Path $pvePath) {} else {New-Item -ItemType Directory -Path "$pvePath\pve"}
New-Item -ItemType Directory -Path "$pvePath\pve"
Invoke-WebRequest "$pveDownload" -OutFile "$pvePath\$pveZip"
Expand-Archive "$pvePath\$pveZip" -DestinationPath "$pvePath\pve"
Remove-Item "$pvePath\$pveZip"
Invoke-Item "$pvePath\pve"
#assume below happened in the vm before migration, maybe also: choco uninstall -y vmware-tools;choco upgrade all -y
c:\tools\pve\preChoco.cmd
c:\tools\pve\preOther.cmd
#https://ovirt.org/documentation/virtual_machine_management_guide/#:~:text=Server%20and%20Desktop.-,3.3.2.%20Installing%20the%20guest%20agents%2C%20tools%2C%20and%20drivers%20on%20Windows,-Procedure

#https://forums.servethehome.com/index.php?threads/wd-red-ssd.26284/
pveperf /zfs
hdparm -I /dev/sdb | grep "Model"
hdparm -I /dev/sdb | grep "Sector" #logical, 128:ashift=12, 4096 byte sector
cat /sys/class/block/sdb/queue/logical_block_size
cat /sys/class/block/sdb/queue/physical_block_size
lshw -class disk -class storage
lshw -short -C disk
fdisk -l | grep '^Disk /dev/' | egrep -v '/dev/(loop|mapper|md)'
smartctl -d ata -a -i /dev/sdb
#https://lars.timmann.de/wiki/index.php/ZFS_on_Linux#:~:text=choose%20%22try%20out%22.-,Get%20the%20right%20ashift%20value,-For%20example%20to
lsblk -o NAME,PHY-SeC,LOG-SEC /dev/sd{a,b} | awk 'function exponent (value) {for(i=0;value>1;i++){value/=2;}; return i;}{if($2 ~ /[0-9]+/){print $0,exponent($2)}else{print$0,"ashift"}}'
arc_summary
ls -lah /sys/module/zfs/parameters
zpool get ashift zfs
zfs get volsize,ashift,used zfs
zpool list -v -o ashift 
zpool get all zfs
#https://wiki.lustre.org/Optimizing_Performance_of_SSDs_and_Advanced_Format_Drives
# there are reports that SSDs can benefit from setting the ashift property explicitly to match the 4096 byte sector size.
# The value of ashift is actually a bit shift value, so the ashift value for 128 bytes is 9 (29 = 128) while the ashift value for 4,096 bytes is 12 (212 = 4,096). 
# To force the pool to use 4,096 byte sectors at pool creation time:
zpool create -o ashift=12 tank mirror sda sdb
#To force the pool to use 4,096 byte sectors when adding a vdev to a pool:
zpool add -o ashift=12 tank mirror sdc sdd


#https://forums.servethehome.com/index.php?threads/very-slow-zfs-raidz2-performance-on-truenas-12.33094/post-305544
zfs set xattr=sa zfs #set the Linux extended attributes as so, this will stop the file system from writing tiny files and write directly to the inodes
zfs set sync=disabled zfs #disable sync, this may seem dangerous, but do it anyway! You will get a huge performance gain.
zfs set compression=lz4 zfs #set the compression level default here, this is currently the best compression algorithm.
zfs set atime=off zfs #this disables the Accessed attribute on every file that is accessed, this can double IOPS
zfs set relatime=on zfs #https://forum.proxmox.com/threads/zfs-hdd-mirror-of-2-wd-red-pro-8tb-slow-even-with-slog-60gb-and-cache-400gb-on-ssd.105932/post-455953
zfs set recordsize=128K #The recordsize value will be determined by the type of data on the file system, 16K for VM images and databases or an exact match, or 1M for collections 5-9MB JPG files and GB+ movies ETC. If you are unsure, the default of 128K is good enough for all around mixes of file sizes.
disable caching for the VM # (cachemode "none" instead of "write back" or "write through") as ZFS is already caching in ARC so you don't cache the same data twice in RAM
#use "virtio SCSI single" for your VMs and enable "SSD emulation" and "IO thread"
#don't mount a ext4 with "discard" option. Setup a daily fstrim -a in your guests crontab instead
#https://schroederdennis.de/tipps-tricks/zfs-recordsize-beste-recordsize-finden-tuning-ashift/
#https://blog.bm-server.de/tag/volblocksize/
#https://openzfs.github.io/openzfs-docs/Performance%20and%20Tuning/Workload%20Tuning.html
#https://github.com/openzfs/zfs/issues/11407
#https://github.com/openzfs/zfs/issues/11407#issuecomment-756749555

SSD_A="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800315"
SSD_B="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800448"
SSD_C="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800696"
SSD_D="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800727"
SSD_E="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800774"
SSD_F="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800890"
SSD_G="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800007"
SSD_H="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800555"
SSD_I="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800643"
SSD_J="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800698"
SSD_K="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800722"
SSD_L="/dev/disk/by-id/ata-WDC_WDS200T1R0A-68A4W0_22160Y800863"

cat << EOF > /etc/zfs/vdev_id.conf
alias SSD_A_WD_315 ata-WDC_WDS200T1R0A-68A4W0_22160Y800315-part1
alias SSD_B_WD_448 ata-WDC_WDS200T1R0A-68A4W0_22160Y800448-part1
alias SSD_C_WD_696 ata-WDC_WDS200T1R0A-68A4W0_22160Y800696-part1
alias SSD_D_WD_727 ata-WDC_WDS200T1R0A-68A4W0_22160Y800727-part1
alias SSD_E_WD_774 ata-WDC_WDS200T1R0A-68A4W0_22160Y800774-part1
alias SSD_F_WD_890 ata-WDC_WDS200T1R0A-68A4W0_22160Y800890-part1
alias SSD_G_WD_007 ata-WDC_WDS200T1R0A-68A4W0_22160Y800007-part1
alias SSD_H_WD_555 ata-WDC_WDS200T1R0A-68A4W0_22160Y800555-part1
alias SSD_I_WD_643 ata-WDC_WDS200T1R0A-68A4W0_22160Y800643-part1
alias SSD_J_WD_698 ata-WDC_WDS200T1R0A-68A4W0_22160Y800698-part1
alias SSD_K_WD_722 ata-WDC_WDS200T1R0A-68A4W0_22160Y800722-part1
alias SSD_L_WD_863 ata-WDC_WDS200T1R0A-68A4W0_22160Y800863-part1
EOF

udevadm trigger

parted $SSD_A --script -- mklabel gpt
parted $SSD_B --script -- mklabel gpt
parted $SSD_C --script -- mklabel gpt
parted $SSD_D --script -- mklabel gpt
parted $SSD_E --script -- mklabel gpt
parted $SSD_F --script -- mklabel gpt
parted $SSD_G --script -- mklabel gpt
parted $SSD_H --script -- mklabel gpt
parted $SSD_I --script -- mklabel gpt
parted $SSD_J --script -- mklabel gpt
parted $SSD_K --script -- mklabel gpt
parted $SSD_L --script -- mklabel gpt

zpool create zfs mirror $SSD_A $SSD_B mirror $SSD_C $SSD_D mirror $SSD_E $SSD_F mirror $SSD_G $SSD_H mirror $SSD_I $SSD_J mirror $SSD_K $SSD_L
zpool export zfs
zpool import -d /dev/disk/by-vdev zfs

ThinkSystem SR650		esxi1k.dcdus1.local		172.17.10.2	172.17.10.11	S4AFB542		768GB
ThinkSystem SR650		esxi2k.dcdus1.local		172.17.10.3	172.17.10.12	S4AFB535		384GB
ThinkSystem SR650		esxi3k.dcdus1.local		172.17.10.4	172.17.10.13	S4AFB536		384‬GB
ThinkSystem SR650		esxi4k.dcdus1.local		172.17.10.5	172.17.10.14	S4AFB544		768‬GB
ThinkSystem SR650		esxi5k.dcdus1.local		172.17.10.6	172.17.10.15	S4AFB545		384GB
ThinkSystem SR650 V2	pve001k.dcdus1.local	172.17.10.7	172.17.10.17	J304D1Z7		416GB
ThinkSystem SR650 V2	pve002k.dcdus1.local	172.17.10.8	172.17.10.18	J304D1YZ		416GB

f$0wB2qCXuOR

VM Network (vSwitch0)
MTU 1500
DHCP	Disabled
IPv4 address	-
Subnet mask	-
Default gateway	-
DNS server addresses	-

Management Network (vSwitch0)
MTU 1500
DHCP	Disabled
IPv4 address	172.17.10.14 (static)
Subnet mask	255.255.255.0
Default gateway	172.17.10.1
DNS server addresses	172.17.10.19.9.9.9

iscsi1 (iscsi)
MTU 9000
DHCP	Disabled
IPv4 address	10.59.0.14 (static)
Subnet mask	255.255.255.0
Default gateway	172.17.10.1
DNS server addresses	172.17.10.19.9.9.9

iscsi2 (iscsi)
MTU 9000
DHCP	Disabled
IPv4 address	10.60.0.14 (static)
Subnet mask	255.255.255.0
Default gateway	172.17.10.1
DNS server addresses	172.17.10.19.9.9.9

127.0.0.1     localhost.localdomain localhost
#MGMT
172.17.10.2   xcc1k
172.17.10.3   xcc2k
172.17.10.4   xcc3k
172.17.10.5   xcc4k
172.17.10.6   xcc5k
172.17.10.7   xcc6k
172.17.10.8   xcc7k
172.17.10.11  pve1k pbs1k
172.17.10.12  pve2k pbs2k
172.17.10.13  pve3k pbs3k
172.17.10.14  pve4k pbs4k
172.17.10.15  pve5k pbs5k
172.17.10.16  pve6k pbs6k
172.17.10.17  pve7k pbs7k
172.17.10.43  dsm1
172.17.10.44  dsm2
#172.17.10.51  pbs1k
#172.17.10.52  pbs2k
#172.17.10.53  pbs3k
#172.17.10.54  pbs4k
#172.17.10.55  pbs5k
#172.17.10.56  pbs6k
#172.17.10.57  pbs7k
172.17.10.30  kluthesan01
172.17.10.20  kluthesan02
172.17.10.100 kluthesan03
172.17.10.73  aruba292021
172.17.10.74  aruba292022
172.17.10.93  aruba381021
172.17.10.94  aruba381022
172.17.10.96  aruba292031
172.17.10.97  aruba292032
172.17.10.98  aruba381031
172.17.10.99  aruba381032
#VM
172.17.1.33   dsm110g
172.17.1.34   dsm210g
#BAK_ISYSTEMS
10.191.1.6    dsm1bak
#ISCSI
10.59.0.11    iscsi1k1
10.59.0.12    iscsi2k1
10.59.0.13    iscsi3k1
10.59.0.14    iscsi4k1
10.59.0.15    iscsi5k1
10.59.0.16    iscsi6k1
10.59.0.17    iscsi7k1
10.60.0.11    iscsi1k2
10.60.0.12    iscsi2k2
10.60.0.13    iscsi3k2
10.60.0.14    iscsi4k2
10.60.0.15    iscsi5k2
10.60.0.16    iscsi6k2
10.60.0.17    iscsi7k2
10.59.0.30    kluthesan011a
10.60.0.30    kluthesan011b
10.59.0.31    kluthesan012a
10.60.0.31    kluthesan012b
10.59.0.20    kluthesan021a
10.60.0.20    kluthesan021b
10.59.0.22    kluthesan022a
10.60.0.21    kluthesan022b
10.59.0.100   kluthesan031a
10.60.0.100   kluthesan031b
10.59.0.101   kluthesan032a
10.60.0.101   kluthesan032b

