#!/bin/bash
ids="$1" 
node_name=$(hostname)
timestamp=$(date +"%Y%m%d_%H%M")
backup_folder=vmsettings-$node_name-$timestamp
if [ ! -d "$backup_folder" ]; then
    mkdir $backup_folder
fi
for id in $ids ; do
	echo "working@$id"
	qm config  $id           > $backup_folder/$id.conf
	qm config  $id --current > $backup_folder/$id.confcurrent
	qm status  $id --verbose > $backup_folder/$id.status
	qm showcmd $id --pretty  > $backup_folder/$id.showcmd
done
#vms='22019 17222343 17222344 17222345 172221211 172221221 172221222 172222410 172222411 172222412 172222413 172222420 172222421 172222422 172222423 172222424 172222510 172222520 172222552 172222553'
#vms='172222559 17222302 172221711 172222610 172222710 172222810 172222910 172223110 172223210 1722213 1722214 1722215 1722216 17222263 17222264 17222265 17222273 17222274 17222275 17222276 17222277 17222278 17222279 17222283 17222284 17222285 17222293 17222294 17222295 17222303 17222304 17222305 17222306 17222307 17222308 17222309 17222301 17222310 172223012 17222313 17222314 17222315 17222323 17222324 17222325 17222333 17222334 17222335 17222336'
#bash prox_vmsettings_backup.sh "$vms"
