# ABOUT

collection of scripts for ESX to PVE migration tasks to do before (pre) and after (post) migration of a windows server

# GOAL

is to quickly download this collection and execute the scripts when connected to the windows host itself, through guest agent, or winrm

# SETUP

1. run 'scripts\getUpdates.ps1' to download (or update) this package
2. review scripts in scripts folder
3. copy one of the example pre files starting with `pre*`, adjust as necessary, and run it

# PRE

prepare yourself to run the pre scripts well in advance to the date of the migration

especially the preChoco.cmd needs a reboot, and so do windows updates

you may create several pre- batch files because

some tasks you HAVE to perform only once:
- setChoco.ps1
- setChocoApps.ps1
- setChocoPins.ps1

and:
- enableAnsible.ps1
- enablePing.ps1
- enableRemoting.ps1
- getWindowsUpdateModule.ps1

plus:
- do not forget to run windows updates and reboots well before

some tasks you MAY perform once:
- preferIpv4.ps1
- setWindowsDefender.ps1

and:
- add your own scripts
- do not forget to run windows updates and reboots well before
- do not forget to setup auto shutdown

and some tasks you WANT to perform several times:
- getUpdates.ps1
- getNetworkConfig.ps1
- getNetworkConfigPrint.ps1

# POST

you should look at these before you migrate:
- removeGhosts.ps1
- removeVmwareTools.ps1
- fixVmwareTools.cmd

as we are calling scripts through guest agent after the vm has been migrated

# OTHER

you can ignore these for the moment:
- taskSchedule.ps1
- taskScheduleAgain.ps1
- taskScript.ps1
- taskScriptAgain.ps1

BUT you might want to schedule windows updates and reboots to happen well before the date of the migration

# LINKS

- Powershell Remote & Task List: EMEA\Customers\Part\Kluthe\20220629
- GhettoVCB Notes and Tests:     EMEA\Customers\Part\Kluthe\20220831
- OVFTool Example:               EMEA\Customers\Part\Kluthe\20220907

# TODO

Define the migration process and make a detailed checklist for every task you have to perform before, during and after the migration

# EXAMPLES

## WINDOWS

from 'dcdussql.sh'

```shell
#shutdown vm and make sure there is no snapshots
#run veeam backup task
#run veeam replica task when backup task finished
#set parameters for migration to proxmox
esx="pve1k";esxRep="pve3k";pve="pve6k";esxRoot="/mnt/sshfs/$esx";clone="100000002";netapp="SAN01DS02";vm="dcdussql";dsm="DSM2RW";rep=$vm"_v2p";id="17001035";
#mount sshfs to retrieve vm info
mkdir -p $esxRoot;mkdir -p /mnt/sshfs/$esxRep;
sshfs -o allow_other,default_permissions root@$esx:/vmfs/volumes/ $esxRoot;sshfs -o allow_other,default_permissions root@$esxRep:/vmfs/volumes/ /mnt/sshfs/$esxRep;
#remove snapshots on the replica (when you do it, veeam replica will calculate digests again, which will take time)
repId=$(ssh root@$esxRep "vim-cmd vmsvc/getallvms | grep $rep" | awk -F ' ' '{print $1}');echo $repId;
ssh root@$esxRep "vim-cmd vmsvc/snapshot.get $repId;vim-cmd vmsvc/snapshot.removeall $repId";
#collect some info of the source vm
sourceRoot="$esxRoot/$netapp/$vm";echo "$sourceRoot";
cat    $sourceRoot/$vm*.vmx |grep 'vmdk"'       |sort
#scsi0:0.fileName = "dcdussql.vmdk"
#scsi0:1.fileName = "dcdussql_1.vmdk"
ls -lh $sourceRoot/$vm*.vmdk                     
cat    $sourceRoot/$vm*.vmx |grep '.ddress = ' |sort
#collect some info of the clone
repRoot="/mnt/sshfs/$esxRep/$dsm/$rep";
cat    $repRoot/$vm*.vmx |grep 'vmdk"'          |sort
#scsi0:0.fileName = "dcdussql.vmdk"
#scsi0:1.fileName = "dcdussql_1.vmdk"
ls -lh $repRoot/$vm*.vmdk
cat    $repRoot/$vm*.vmx |grep '.ddress = '    |sort
#set replica parameters
vmDisk1=`cat $repRoot/$vm*.vmx    |grep 'dcdussql.vmdk"'    | cut -d \" -f2`;echo $vmDisk1;vmDisk1="/mnt/pve/dsm2/vcenter/$rep/$vmDisk1";ls -lah $vmDisk1;echo "[vmDisk1=$vmDisk1]";
vmDisk2=`cat $repRoot/$vm*.vmx    |grep 'dcdussql_1.vmdk"'  | cut -d \" -f2`;echo $vmDisk2;vmDisk2="/mnt/pve/dsm2/vcenter/$rep/$vmDisk2";ls -lah $vmDisk2;echo "[vmDisk2=$vmDisk2]";
 vmMac1=`cat $sourceRoot/$vm*.vmx |grep ".ddress" | grep ':' | cut -d \" -f2`;echo $vmMac1;echo "[vmMac1=$vmMac1]";
 vmconf="/etc/pve/nodes/$pve/qemu-server/$id.conf";
#clone template, update mac & bridge, import disk, update disk, add fake virtio, update boot order, then start the vm
qm guest cmd    $id ping || {
 pvesh create /nodes/$pve/qemu/$clone/clone --newid $id --name $vm --full true
 qm set          $id --net0 virtio="$vmMac1",bridge=vmbr99;
}
qm guest cmd     $id ping || {
 sleep 60m
 date >>/tmp/$id.log;qm importdisk $id $vmDisk1 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
 date >>/tmp/$id.log;qm importdisk $id $vmDisk2 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
}
qm guest cmd     $id ping || {
#pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'first(to_entries[]|select(.key|startswith("unused"))).value'
#pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'last(to_entries[]|select(.key|startswith("unused"))).value'
 qm set          $id --sata0 zfs:vm-$id-disk-0
 qm set          $id --sata1 zfs:vm-$id-disk-1
#qm importdisk   $id /mnt/pve/dsm1/images/disk.raw zfs --format raw
#qm set          $id --virtio0  zfs:vm-$id-disk-1
 pvesm alloc zfs $id "vm-$id-disk-15" 1M
 qm set          $id --virtio15 zfs:vm-$id-disk-15
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=sata0'>>"$vmconf"
 qm rescan --vm  $id
}   && qm start  $id
#login to vm and update settings
 qm guest cmd  $id ping && {
 qm guest cmd  $id network-get-interfaces
 qm guest exec $id cmd -- "/c ipconfig /all"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\setNetworkConfig.ps1;"
 qm guest exec $id powershell -- "Stop-Computer;"
}
#review config and update settings
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\EnableSnmp.sh
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\HanaOnKvm.sh
#delete fake virtio, attach disk as virtio, enable network, update boot order
qm guest cmd $id ping || { 
 qm set $id -agent 1,fstrim_cloned_disks=1
 qm set $id -balloon 2048
 qm set $id -memory 16384
 qm set $id -sockets 2
 qm set $id -cores 2
 qm set $id -cpu kvm64
 qm set $id -numa 1
 qm set $id -vga std
 qm set $id -delete virtio15
 qm set $id -delete unused0
 qm set $id -scsihw virtio-scsi-single
 qm set $id -delete sata0;qm set $id -virtio0 zfs:vm-$id-disk-0,discard=on,aio=native,iothread=1,mbps_rd=256,mbps_wr=256
 qm set $id -delete sata1;qm set $id -virtio1 zfs:vm-$id-disk-1,discard=on,aio=native,iothread=1,mbps_rd=256,mbps_wr=256
 qm set $id -net0 virtio="$vmMac1",bridge=vmbr0
#qm set $id -delete shares,onboot,spice_enhancements
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=ide0;virtio0'>>"$vmconf"
 qm rescan --vm $id 
 cat "$vmconf"
}   && qm start $id
#do some cleanup if needed and shutdown pc
qm guest cmd  $id ping && {
 qm guest cmd  $id network-get-interfaces
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
 qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
 qm guest exec $id powershell -- "Stop-Computer;"
}
#unregister vm from esxi
#remove vm replica from esxi
#remove vm from replica job
#disable backup/replica jobs

```

## LINUX

from 'kluthesld10.sh'

```shell
#shutdown vm and make sure there is no snapshots
#run veeam backup task
#run veeam replica task when backup task finished
#set parameters for migration to proxmox
esx="pve1k";esxRep="pve3k";pve="pve6k";esxRoot="/mnt/sshfs/$esx";clone="100000011";netapp="SAN01DS02";vm="kluthesld10";dsm="DSM2RW";rep=$vm"_v2p";id="17001079";
#mount sshfs to retrieve vm info
mkdir -p $esxRoot;mkdir -p /mnt/sshfs/$esxRep;
sshfs -o allow_other,default_permissions root@$esx:/vmfs/volumes/ $esxRoot;sshfs -o allow_other,default_permissions root@$esxRep:/vmfs/volumes/ /mnt/sshfs/$esxRep;
#remove snapshots on the replica (when you do it, veeam replica will calculate digests again, which will take time)
repId=$(ssh root@$esxRep "vim-cmd vmsvc/getallvms | grep $rep" | awk -F ' ' '{print $1}');echo $repId;
ssh root@$esxRep "vim-cmd vmsvc/snapshot.get $repId;vim-cmd vmsvc/snapshot.removeall $repId";
#collect some info of the source vm
sourceRoot="$esxRoot/$netapp/$vm";echo "$sourceRoot";
cat    $sourceRoot/$vm*.vmx |grep 'vmdk"'       |sort
#scsi0:0.fileName = "kluthesld10.vmdk"
#scsi0:1.fileName = "kluthesld10_1.vmdk"
#scsi0:2.fileName = "kluthesld10_2.vmdk"
ls -lh $sourceRoot/$vm*.vmdk                     
cat    $sourceRoot/$vm*.vmx |grep '.ddress = ' |sort
#ethernet0.address = "44:44:44:00:02:92"
#collect some info of the clone
repRoot="/mnt/sshfs/$esxRep/$dsm/$rep";
cat    $repRoot/$vm*.vmx |grep 'vmdk"'          |sort
#scsi0:0.fileName = "kluthesld10.vmdk  "
#scsi0:1.fileName = "kluthesld10_1.vmdk"
#scsi0:2.fileName = "kluthesld10_2.vmdk"
ls -lh $repRoot/$vm*.vmdk
cat    $repRoot/$vm*.vmx |grep '.ddress = '    |sort
#set replica parameters
vmDisk1=`cat $repRoot/$vm*.vmx |grep 'kluthesld10.vmdk"'    | cut -d \" -f2`;echo $vmDisk1;vmDisk1="/mnt/pve/dsm2/vcenter/$rep/$vmDisk1";ls -lah $vmDisk1;echo "[vmDisk1=$vmDisk1]";
vmDisk2=`cat $repRoot/$vm*.vmx |grep 'kluthesld10_1.vmdk"'  | cut -d \" -f2`;echo $vmDisk2;vmDisk2="/mnt/pve/dsm2/vcenter/$rep/$vmDisk2";ls -lah $vmDisk2;echo "[vmDisk2=$vmDisk2]";
vmDisk3=`cat $repRoot/$vm*.vmx |grep 'kluthesld10_2.vmdk"'  | cut -d \" -f2`;echo $vmDisk3;vmDisk3="/mnt/pve/dsm2/vcenter/$rep/$vmDisk3";ls -lah $vmDisk3;echo "[vmDisk3=$vmDisk3]";
 vmMac1=`cat $sourceRoot/$vm*.vmx |grep ".ddress" | grep ':' | cut -d \" -f2`;echo $vmMac1;echo "[vmMac1=$vmMac1]";
 vmconf="/etc/pve/nodes/$pve/qemu-server/$id.conf";
#clone template, update mac & bridge, import disk, update disk, add fake virtio, update boot order, then start the vm
qm guest cmd    $id ping || {
 pvesh create /nodes/$pve/qemu/$clone/clone --newid $id --name $vm --full true
 qm set          $id --net0 virtio="$vmMac1",bridge=vmbr99;
}
qm guest cmd     $id ping || {
 sleep 210m
 date >>/tmp/$id.log;qm importdisk $id $vmDisk1 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
 date >>/tmp/$id.log;qm importdisk $id $vmDisk2 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
 date >>/tmp/$id.log;qm importdisk $id $vmDisk3 zfs --format raw;date >>/tmp/$id.log && cat /tmp/$id.log
}
qm guest cmd     $id ping || {
#pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'first(to_entries[]|select(.key|startswith("unused"))).value'
#pvesh get    /nodes/$pve/qemu/$id/config  --output-format json | jq -r 'last(to_entries[]|select(.key|startswith("unused"))).value'
 qm set          $id --sata0 zfs:vm-$id-disk-0
 qm set          $id --scsi0 zfs:vm-$id-disk-1
 qm set          $id --scsi1 zfs:vm-$id-disk-2
#qm importdisk   $id /mnt/pve/dsm1/images/disk.raw zfs --format raw
#qm set          $id --virtio0  zfs:vm-$id-disk-1
 pvesm alloc zfs $id "vm-$id-disk-15" 1M
 qm set          $id --virtio15 zfs:vm-$id-disk-15
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=sata0'>>"$vmconf"
 qm rescan --vm  $id
}
#qm start  $id
#login to vm and update settings
#review config and update settings
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\EnableSnmp.sh
#X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Part\Kluthe\20220705\HanaOnKvm.sh
#delete fake virtio, attach disk as virtio, enable network, update boot order
qm guest cmd $id ping || { 
 qm set $id -agent 1,fstrim_cloned_disks=1
#qm set $id -balloon 2048
 qm set $id -memory 32768
 qm set $id -sockets 2
 qm set $id -cores 4
 qm set $id -cpu host
 qm set $id -numa 1
 qm set $id -vga std
 qm set $id -delete virtio15
 qm set $id -delete unused0
 qm set $id -scsihw virtio-scsi-single
 qm set $id -delete sata0;qm set $id -virtio0 zfs:vm-$id-disk-0,discard=on,aio=native,iothread=1,mbps_rd=512,mbps_wr=512
 qm set $id -delete scsi0;qm set $id -virtio1 zfs:vm-$id-disk-1,discard=on,aio=native,iothread=1,mbps_rd=512,mbps_wr=512
 qm set $id -delete scsi1;qm set $id -virtio2 zfs:vm-$id-disk-2,discard=on,aio=native,iothread=1,mbps_rd=512,mbps_wr=512
 qm set $id -net0 virtio="$vmMac1",bridge=vmbr0
#qm set $id -delete shares,onboot,spice_enhancements
 sed -i '/boot:/d' "$vmconf"
 echo 'boot: order=ide0;virtio0'>>"$vmconf"
 qm rescan --vm $id 
 cat "$vmconf"
}
#qm start $id
#do some cleanup if needed and shutdown pc
#qm guest cmd  $id ping && {
# qm guest cmd  $id network-get-interfaces
# qm guest exec $id powershell -- "c:\tools\pve\scripts\removeGhosts.ps1;"
# qm guest exec $id powershell -- "c:\tools\pve\scripts\removeVmwareTools.ps1;"
# qm guest exec $id powershell -- "Stop-Computer -Force;"
#}
#HanaOnKvm.sh
#Check kernel boot options used:
cat /proc/cmdline #BOOT_IMAGE=/boot/vmlinuz-5.3.18-150300.59.49-default root=/dev/mapper/system-root splash=silent resume=/dev/system/swap quiet splash=silent resume=/dev/system/swap quiet crashkernel=182M,high crashkernel=72M,low mitigations=auto
cp /etc/default/grub /etc/default/grub.20220818
vi /etc/default/grub #GRUB_CMDLINE_LINUX_DEFAULT="splash=silent quiet crashkernel=207M,high crashkernel=72M,low transparent_hugepage=never mitigations=auto kvm.nx_huge_pages=off intremap=no_x2apic_optout"
grub2-mkconfig -o /boot/grub2/grub.cfg
#zypper in -y vm-dump-metrics sapconf
zypper in -y qemu-guest-agent
#vm-dump-metrics
systemctl status  irqbalance
systemctl disable irqbalance
systemctl stop    irqbalance
#cp /etc/sysconfig/sapconf /etc/sysconfig/sapconf.bak
#vi /etc/sysconfig/sapconf #When using sapconf version 5, stop and disable the tuned service and instead enable and start the sapconf service.
#cat << EOF > /etc/sysconfig/sapconf
#VSZ_TMPFS_PERCENT=75
#SHMALL=1152921504606846720
#SHMMAX=18446744073709551615
#LIMIT_1="@sapsys soft nofile 1048576"
#LIMIT_2="@sapsys hard nofile 1048576"
#LIMIT_3="@sdba soft nofile 1048576"
#LIMIT_4="@sdba hard nofile 1048576"
#LIMIT_5="@dba soft nofile 1048576"
#LIMIT_6="@dba hard nofile 1048576"
#MAX_MAP_COUNT=2147483647
#SHMMNI=32768
#DIRTY_BYTES=629145600
#DIRTY_BG_BYTES=314572800
#TCP_SLOW_START=0
#KSM=0
#NUMA_BALANCING=0
#THP=never
#PERF_BIAS=performance
#GOVERNOR=performance
#FORCE_LATENCY=5
#MIN_PERF_PCT=100
#IO_SCHEDULER="noop none"
#EOF
mkinitrd
#unregister vm from esxi
#remove vm replica from esxi
#remove vm from replica job
#disable backup/replica jobs

```