#!/bin/bash
echo fMiscDownloadCaddy     && fMiscDownloadCaddy(){
 local SSH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )";
 local DIR="/tmp";
 local ZIP="$1";ZIP="/tmp/caddy.zip";
 local DDL="$2";DDL="https://files.esser.space/iso/etc/caddy/";
 cd "$DIR"
 WORK_DIR=`mktemp -d -p "$DIR"`
 if [[ ! "$WORK_DIR" || ! -d "$WORK_DIR" ]]; then
   echo "Could not create temp dir"
   exit 1
 else 
  cd "$WORK_DIR"
  wget -nc -c -nd -nH -r -l1 -e robots=off --reject="index.html*" $DDL
  zip -r "$ZIP" .
  cd "$DIR"
  rm -rf "$WORK_DIR"
 fi
}
echo fMiscPveInstallUpdates && fMiscPveInstallUpdates(){
 apt update;apt upgrade -y;apt auto-clean -y;apt autoremove -y;
}
echo fMiscPveBackup         && fMiscPveBackup(){
 set -e
 _bdir=${BACK_DIR:-/root/prox_config_backup}
 MAX_BACKUPS=5
 _tdir=${TMP_DIR:-/var/tmp}
 _tdir=$(mktemp -d $_tdir/proxmox-XXXXXXXX)
 function clean_up {
     echo "Cleaning up"
     rm -rf $_tdir
 }
 trap clean_up EXIT
 _now=$(date +%Y-%m-%d.%H.%M.%S)
 _HOSTNAME=$(hostname -f)
 _filename1="$_tdir/proxmoxetc.$_now.tar"
 _filename2="$_tdir/proxmoxpve.$_now.tar"
 _filename3="$_tdir/proxmoxroot.$_now.tar"
 _filename4="$_tdir/proxmoxcron.$_now.tar"
 _filename5="$_tdir/proxmoxvbios.$_now.tar"
 _filename6="$_tdir/proxmoxpackages.$_now.list"
 _filename7="$_tdir/proxmoxreport.$_now.txt"
 _filename8="$_tdir/proxmoxlocalbin.$_now.tar"
 _filename_final="$_tdir/proxmox_backup_"$_HOSTNAME"_"$_now".tar.gz"
 function check-num-backups {
     if [[ $(ls ${_bdir}/*${_HOSTNAME}*.tar.gz -l | grep ^- | wc -l) -ge $MAX_BACKUPS ]]; then
       local oldbackup="$(basename $(ls ${_bdir}/*${_HOSTNAME}*.tar.gz -t | tail -1))"
       echo "${_bdir}/${oldbackup}"
       rm "${_bdir}/${oldbackup}"
     fi
 }
 function copyfilesystem {
     echo "Tar files"
     # copy key system files
     tar --warning='no-file-ignored' -cvPf "$_filename1" /etc/.
     tar --warning='no-file-ignored' -cvPf "$_filename2" /var/lib/pve-cluster/.
     tar --warning='no-file-ignored' -cvPf "$_filename3" /root/.
     tar --warning='no-file-ignored' -cvPf "$_filename4" /var/spool/cron/.
     
     if [ "$(ls -A /usr/local/bin 2>/dev/null)" ]; then tar --warning='no-file-ignored' -cvPf "$_filename8" /usr/local/bin/.; fi
         
     if [ "$(ls /usr/share/kvm/*.vbios 2>/dev/null)" != "" ] ; then
 	echo backing up custom video bios...
 	tar --warning='no-file-ignored' -cvPf "$_filename5" /usr/share/kvm/*.vbios
     fi
     # copy installed packages list
     echo "Copying installed packages list from APT"
     apt-mark showmanual | tee "$_filename6"
     # copy pvereport output
     echo "Copying pvereport output"
     pvereport | tee "$_filename7"
 }
 function compressandarchive {
     echo "Compressing files"
     # archive the copied system files
     tar -cvzPf "$_filename_final" $_tdir/*.{tar,list,txt}
 
     # copy config archive to backup folder
     # this may be replaced by scp command to place in remote location
     cp $_filename_final $_bdir/
 }
 check-num-backups
 copyfilesystem
 compressandarchive
}
#$@
