#https://4sysops.com/archives/adding-and-removing-keyboard-languages-with-powershell/
$KeyboardToAdd = "de-DE";
$KeyboardList  = Get-WinUserLanguageList;$KeyboardList;
$KeyboardList.Add($KeyboardToAdd);
Set-WinUserLanguageList $KeyboardList -Force;


$languages = Get-WinUserLanguageList 
$languages.Clear()
$languages.add("de-DE")
Set-WinUserLanguageList $languages -Force

$KeyboardToAdd = "de-DE";
$GeoidToAdd    = "94";
$PackagePath   = "C:\Users\Administrator\Downloads";
$PackageToAdd  = Get-ChildItem -Path $PackagePath -Filter *$KeyboardToAdd*.cab | %{$_.FullName};
Add-WindowsPackage -Online -PackagePath $PackageToAdd;
Set-Culture $KeyboardToAdd;
Set-WinSystemLocale -SystemLocale $KeyboardToAdd;
Set-WinUILanguageOverride -Language $KeyboardToAdd;
Set-WinUserLanguageList $KeyboardToAdd -Force;
Set-WinHomeLocation -GeoId $GeoidToAdd;
Copy-UserInternationalSettingsToSystem -WelcomeScreen $True -NewUser $True;


# setup log4jscanner
$x64="C:\Program Files\SAP"
$x86="C:\Program Files (x86)\SAP"
$log4jscannerDownload="https://github.com/google/log4jscanner/releases/download/v0.2.0/log4jscanner-v0.2.0-windows-amd64.zip"
$log4jscannerDownload="https://github.com/google/log4jscanner/releases/download/v0.3.0/log4jscanner-v0.3.0-windows-amd64.zip"
$log4jscannerPath="c:\temp"
$log4jscannerZip="log4jscanner.zip"
$log4jscanner="$log4jscannerPath\log4jscanner\log4jscanner.exe"
$log4jscannerFound="$log4jscannerPath\log4jscanner\log4jscanner_found.txt"
$log4jscannerLeft="$log4jscannerPath\log4jscanner\log4jscanner_left.txt"
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]'Tls11,Tls12'
if (Test-Path $log4jscannerPath) {} else {New-Item -ItemType Directory -Path "$log4jscannerPath"}
Invoke-WebRequest "$log4jscannerDownload" -OutFile "$log4jscannerPath\$log4jscannerZip"
Expand-Archive "$log4jscannerPath\$log4jscannerZip" -DestinationPath "$log4jscannerPath"
Remove-Item "$log4jscannerPath\$log4jscannerZip"


# Language codes
$PrimaryLanguage = "de-DE"
$PrimaryInputCode = "0407:00000407"
$SecondaryLanguage = "en-US"
$SecondaryInputCode = "0809:00000809"
#$PrimaryGeoID = "94" #DE
#$PrimaryGeoID = "242" #UK

# Enable side-loading
# Required for appx/msix prior to build 18956 (1909 insider)
New-ItemProperty –Path HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\AppModelUnlock –Name AllowAllTrustedApps –Value 1 –PropertyType DWORD –Force

# Provision Local Experience Pack
$BlobURL = "https://mystorageaccount.blob.core.windows.net/mycontainer/en-gb.zip?sp=r&st=2020-03-26T18:02:28Z&se=2050-03-27T00:02:28Z&spr=https&sv=2019-02-02&sr=b&sig=91234567890OYr%2BI0RcryhGFy1DNMlzhfIWbQ%3D"

$DownloadedFile = "$env:LOCALAPPDATA\en-GB.zip"
Try
{
    $WebClient = New-Object System.Net.WebClient
    $WebClient.DownloadFile($BlobURL, $DownloadedFile)
    Unblock-File –Path $DownloadedFile –ErrorAction SilentlyContinue
    Expand-Archive –Path $DownloadedFile –DestinationPath $env:LOCALAPPDATA –Force –ErrorAction Stop
    Add-AppxProvisionedPackage –Online –PackagePath "$env:LOCALAPPDATA\en-gb\LanguageExperiencePack.en-gb.Neutral.appx" –LicensePath "$env:LOCALAPPDATA\en-gb\License.xml" –ErrorAction Stop
    Remove-Item –Path $DownloadedFile –Force –ErrorAction SilentlyContinue
}
Catch
{
    Write-Host "Failed to install Local Experience Pack: $_"
}

# Install optional features for primary language
$UKCapabilities = Get-WindowsCapability –Online | Where {$_.Name -match "$PrimaryLanguage" -and $_.State -ne "Installed"}
$UKCapabilities | foreach {
    Add-WindowsCapability –Online –Name $_.Name
}

# Apply custom XML to set administrative language defaults
$XML = @"
<gs:GlobalizationServices xmlns:gs="urn:longhornGlobalizationUnattend">
 
<!– user list –> 
    <gs:UserList>
        <gs:User UserID="Current" CopySettingsToDefaultUserAcct="true" CopySettingsToSystemAcct="true"/> 
    </gs:UserList>
 
    <!– GeoID –>
    <gs:LocationPreferences> 
        <gs:GeoID Value="$PrimaryGeoID"/>
    </gs:LocationPreferences>
 
    <gs:MUILanguagePreferences>
        <gs:MUILanguage Value="$PrimaryLanguage"/>
        <gs:MUIFallback Value="$SecondaryLanguage"/>
    </gs:MUILanguagePreferences>
 
    <!– system locale –>
    <gs:SystemLocale Name="$PrimaryLanguage"/>
 
    <!– input preferences –>
    <gs:InputPreferences>
        <gs:InputLanguageID Action="add" ID="$PrimaryInputCode" Default="true"/>
        <gs:InputLanguageID Action="add" ID="$SecondaryInputCode"/>
      </gs:InputPreferences>
 
    <!– user locale –>
    <gs:UserLocale>
        <gs:Locale Name="$PrimaryLanguage" SetAsCurrent="true" ResetAllSettings="false"/>
    </gs:UserLocale>
 </gs:GlobalizationServices>
"@

New-Item –Path $env:TEMP –Name "en-GB.xml" –ItemType File –Value $XML –Force

$Process = Start-Process –FilePath Control.exe –ArgumentList "intl.cpl,,/f:""$env:Temp\en-GB.xml""" –NoNewWindow –PassThru –Wait
$Process.ExitCode