﻿$URL = "http://EDUDEPLOY09:9801/MDTMonitorData/Computers"

function GetMDTData { 
  $Data = Invoke-RestMethod $URL

  foreach($property in ($Data.content.properties) ) { 
    New-Object PSObject -Property @{ 
      Name = $($property.Name); 
      PercentComplete = $($property.PercentComplete.’#text’); 
      Warnings = $($property.Warnings.’#text’); 
      Errors = $($property.Errors.’#text’); 
      DeploymentStatus = $( 
        Switch ($property.DeploymentStatus.’#text’) { 
        1 { "Active/Running" } 
        2 { "Failed" } 
        3 { "Successfully completed" } 
        Default { "Unknown" } 
        } 
      ); 
      StartTime = $($property.StartTime.’#text’) -replace "T"," "; 
      EndTime = $($property.EndTime.’#text’) -replace "T"," "; 
    } 
  } 
} 

$Head = "<style>"
$Head = $Head + "BODY{background-color:peachpuff;}"
$Head = $Head + "TABLE{border-width: 2px;border-style: solid;border-color: black;border-collapse: collapse;}"
$Head = $Head + "TH{border-width: 1px;padding: 0px;border-style: solid;border-color: black;background-color:thistle}"
$Head = $Head + "TD{border-width: 1px;padding: 0px;border-style: solid;border-color: black}"
$Head = $Head + "</style>"

$Title = "LabCenter Deployment Status"

GetMDTData | Select Name, DeploymentStatus, PercentComplete, Warnings, Errors, StartTime, EndTime | Sort -Property Name |
ConvertTo-Html  `
-Title $Title  `
-Head $Head  `
-Body (Get-Date -UFormat "%Y-%m-%d - %T ")  `
-PreContent "<H2>LabCenter Deployment Status for: $ENV:COMPUTERNAME </H2><P>Generated by Power of the Force</P>"  `
-PostContent "<P>For details, contact support@truesec.se.</P>"  `
-Property Name,DeploymentStatus,PercentComplete,Warnings,Errors,StartTime |
ForEach {
if($_ -like "*<td>Successfully completed</td>*"){$_ -replace "<tr>", "<tr bgcolor=green>"}
elseif($_ -like "*<td>Failed</td>*"){$_ -replace "<tr>", "<tr bgcolor=red>"}
else{$_}
} > C:\inetpub\wwwroot\default.htm 
#Invoke-Item $ENV:TEMP\Default.htm
