$SourceFile   ="X:\dev\autounattend\etc\googledrive\source\File.txt"
$RefreshToken ="1//09E_GQO1hsH7uCgYIARAAGAkSNwF-L9IrWc3W6mswnp1rS4ssC6ocaWLgf4P7zXkwwrUm8DMbQALDPmPRXu53ATggeLniDoLOH9M"
$ClientID     ="66050935983-bm6iaj0pbsstnc6dcv1ehrjq97dvt1jr.apps.googleusercontent.com"
$ClientSecret ="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"
$ParentId     ="11IKaf8aKOK4-zYs5hm5oqo7Mhj0KIZ_d"

$ScriptPath = $MyInvocation.MyCommand.Path
$SettingsPath = $ScriptPath -replace '\.ps1$', '.ini'
$ScriptLog = $ScriptPath -replace '\.ps1$', '.log'

if (-not (Test-Path $SettingsPath)) {
    $settingsMessage = @"
RefreshToken=
ClientID=
ClientSecret=
SourceFile=
ParentId=
"@
    $settingsMessage | Out-File -FilePath $SettingsPath -Encoding UTF8
    Write-Host "The settings file '$SettingsPath' was created."
    Write-Host "Please update all the variables in the settings file before running the script."
}

if (-not (Test-Path $ScriptLog)) {
    $logHeader = 'Date,Time,Type,Message'
    $logHeader | Out-File -FilePath $ScriptLog -Encoding UTF8
    Write-Host "The log file '$ScriptLog' was created."
}

function Write-Log {
    param([string]$Type, [string]$Message)
    $logEntry = "$(Get-Date -Format 'yyyy-MM-dd'),$(Get-Date -Format 'HH:mm:ss'),$Type,$Message"
    $logEntry | Out-File -FilePath $ScriptLog -Encoding UTF8 -Append
    Write-Host $logEntry
	$MaxLogFileLines = "1000"
    $logLines = Get-Content -Path $ScriptLog
    if ($logLines.Count -gt $MaxLogFileLines) {
        $logLines | Select-Object -Last $MaxLogFileLines | Set-Content -Path $ScriptLog
    }
}

Write-Log -Type 'START' -Message 'Script started.'

$SourceFileHash = "$SourceFile.hash"
$previousHash = ''
if (Test-Path $SourceFileHash) {
    $previousHash = Get-Content $SourceFileHash
}

$currentHash = Get-FileHash -Path $SourceFile | Select-Object -ExpandProperty Hash

if ($currentHash -eq $previousHash) {
    Write-Log -Type 'INFO' -Message "File hash for '$SourceFile' is the same. No need to upload."
    continue
} else {
    Write-Log -Type 'INFO' -Message "File hash for '$SourceFile' is different. Proceeding with the upload."
    Set-Content -Path $SourceFileHash -Value $currentHash
}

$accessToken = (Invoke-RestMethod @{
 Uri = 'https://accounts.google.com/o/oauth2/token'
 Body = "refresh_token=$RefreshToken&client_id=$ClientID&client_secret=$ClientSecret&grant_type=refresh_token"
 Method = 'Post'
 ContentType = 'application/x-www-form-urlencoded'
}).access_token

$sourceBase64 = [Convert]::ToBase64String([IO.File]::ReadAllBytes((Get-Item $SourceFile).FullName))
$sourceMime = [System.Web.MimeMapping]::GetMimeMapping((Get-Item $SourceFile).FullName)
$supportsTeamDrives = 'false'

$uploadMetadata = @{
 originalFilename = (Get-Item $SourceFile).Name
 name = (Get-Item $SourceFile).Name
 parents = @($ParentId)
}

$uploadBody = @"
--boundary
Content-Type: application/json; charset=UTF-8

$($uploadMetadata | ConvertTo-Json)

--boundary
Content-Transfer-Encoding: base64
Content-Type: $sourceMime

$sourceBase64
--boundary--
"@

$uploadHeaders = @{
    "Authorization" = "Bearer $accessToken"
    "Content-Type" = 'multipart/related; boundary=boundary'
    "Content-Length" = $uploadBody.Length
}

$response = Invoke-RestMethod -Uri "https://www.googleapis.com/upload/drive/v3/files?uploadType=multipart&supportsTeamDrives=$supportsTeamDrives" -Method Post -Headers $uploadHeaders -Body $uploadBody

Write-Log -Type 'INFO' -Message "File '$SourceFile' uploaded."

Write-Log -Type 'STOP' -Message 'Script stopped.'

