$ScriptPath = $PSScriptRoot
$PackagesPath = Join-Path $ScriptPath "packages"
$PackageId = "Google.Apis.Drive"
$PackageVersion = "1.60.0"

# Add the NuGet package source
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
Register-PackageSource -Name "NuGet" -Location "https://api.nuget.org/v3/index.json" -ProviderName "NuGet"

# Install the Google.Apis.Drive NuGet package
Install-Package -Name $PackageId -Version $PackageVersion -Destination $PackagesPath -ProviderName "NuGet" -Force

# Load the required assembly
$DriveAssemblyPath = Join-Path $PackagesPath "$PackageId.$PackageVersion\lib\net45\Google.Apis.Drive.dll"
Add-Type -Path $DriveAssemblyPath

# Import the module functions
$FunctionsPath = Join-Path $PackagesPath "$PackageId.$PackageVersion\build\Google.Apis.Drive.psm1"
Import-Module $FunctionsPath -DisableNameChecking
