#!/bin/bash
DefaultHostname="caddy"
read -e -p "Enter Your New Hostname:" -i "$DefaultHostname" Hostname
sed -i "s/bullseye/$Hostname/g" /etc/hosts
sed -i "s/bullseye/$Hostname/g" /etc/hostname
sed -i "s/bullseye/$Hostname/g" /etc/mailname
CONT=""
read -p "Install Caddy? (y/n) " CONT
if [ "$CONT" = "y" ]; then
  echo "Installing Caddy"
  apt install -y debian-keyring debian-archive-keyring apt-transport-https
  curl -1sLf 'https://dl.cloudsmith.io/public/caddy/stable/gpg.key' | gpg --dearmor -o /usr/share/keyrings/caddy-stable-archive-keyring.gpg
  curl -1sLf 'https://dl.cloudsmith.io/public/caddy/stable/debian.deb.txt' | tee /etc/apt/sources.list.d/caddy-stable.list
  apt update
  apt install caddy -y
  systemctl stop caddy
  mv /usr/bin/caddy /usr/bin/caddy.orig
  caddypackage='https://caddyserver.com/api/download?os=linux&arch=amd64&p=github.com%2Fcaddy-dns%2Fcloudflare&p=github.com%2Fmholt%2Fcaddy-webdav&p=github.com%2Fabiosoft%2Fcaddy-exec&p=github.com%2Fabiosoft%2Fcaddy-json-parse&p=github.com%2Fmastercactapus%2Fcaddy2-proxyprotocol&p=github.com%2Fkirsch33%2Frealip&p=github.com%2Fporech%2Fcaddy-maxmind-geolocation&p=github.com%2Fcaddyserver%2Fntlm-transport&p=github.com%2Fabiosoft%2Fcaddy-yaml&p=github.com%2Fmholt%2Fcaddy-l4&p=github.com%2Fabiosoft%2Fcaddy-json-schema&p=github.com%2Fmholt%2Fcaddy-dynamicdns&p=github.com%2Fgreenpau%2Fcaddy-git&p=github.com%2Fmuety%2Fcaddy-remote-host&p=github.com%2Fshift72%2Fcaddy-geo-ip&p=github.com%2Fcirca10a%2Fcaddy-geofence&p=github.com%2Fgit001%2Fcaddyv2-upload'
  wget $caddypackage -O /usr/bin/caddy
  chmod --reference=/usr/bin/caddy.orig /usr/bin/caddy
  chown --reference=/usr/bin/caddy.orig /usr/bin/caddy
  systemctl enable caddy
else
  echo "Skipping Caddy"
fi
CONT=""
read -p "Change Password? (y/n) " CONT
if [ "$CONT" = "y" ]; then
  echo "Changing Password"
  passwd
else
  echo "Keeping Password"
fi
CONT=""
read -p "Regenerate SSH Keys? [Note: when asked, keep the current ssh config] (y/n) " CONT
if [ "$CONT" = "y" ]; then
  echo "Regenerating SSH Keys"
  rm -v /etc/ssh/ssh_host_*
  dpkg-reconfigure openssh-server
else
  echo "Keeping SSH Keys"
fi
echo >/root/.bash_history
history -c
systemctl poweroff
#https://github.com/boxcutter/debian/blob/master/script/cleanup.sh
