function New-ZipFile( $sourcedir, $zipfilename )
{
   Add-Type -Assembly System.IO.Compression.FileSystem
   $compressionLevel = [System.IO.Compression.CompressionLevel]::Optimal
   [System.IO.Compression.ZipFile]::CreateFromDirectory($sourcedir,
        $zipfilename, $compressionLevel, $false)
}
$name     = "autounattend"
$dateTime = (Get-Date).ToString("yyyyMMddTHHmmss")
$source   = $PSScriptRoot
$parent   = Split-Path -Path $PSScriptRoot -Parent
$destin   = $parent + "\" + $name + "_" + $dateTime + ".zip"
#dir $source | New-Isofile -path "$destin" -Title "$name"
#Get-ChildItem -Path "$source" -Name -Exclude "backup",".gitignore","autoiso.ps1","autozip.ps1","README.md" | New-Isofile -path "$destin" -Title "$name"
#Get-ChildItem -Path "$source" -Name -Exclude "backup",".gitignore","autoiso.ps1","autozip.ps1","README.md" | New-ZipFile $destin
New-ZipFile $source $destin
sleep 5
