function GetScriptInfo {
    $currentPath                       = $PSScriptRoot
	$parentFolderName                  = (Split-Path $currentPath -Leaf)
    $currentScriptName                 = $PSCommandPath | Split-Path -Leaf
    $currentScriptNameWithoutExtension = [System.IO.Path]::GetFileNameWithoutExtension($currentScriptName)
    $currentScriptExtension            = [System.IO.Path]::GetExtension($currentScriptName)
    return @{
        Path      = $currentPath
		Folder    = $parentFolderName
        Name      = $currentScriptNameWithoutExtension
        Extension = $currentScriptExtension
        FileName  = $currentScriptName
		FilePath  = $currentPath + '\' + $currentScriptName
		LogName   = $currentScriptNameWithoutExtension + '.log'
		LogPath   = $currentPath + '\' + $currentScriptNameWithoutExtension + '.log'
    }
}
$script = GetScriptInfo
Write-Host @"
scriptPath      :$($script.Path)
scriptFolder    :$($script.Folder)
scriptName      :$($script.Name)
scriptExtension :$($script.Extension)
scriptFileName  :$($script.FileName)
scriptFilePath  :$($script.FilePath)
scriptLogName   :$($script.LogName)
scriptLogPath   :$($script.LogPath)
"@
#$script
#PS C:\WINDOWS\system32> X:\dev\autounattend\etc\pve\v2p\currentFolder.ps1
#scriptPath      :X:\dev\autounattend\etc\pve\v2p
#scriptFolder    :v2p
#scriptName      :currentFolder
#scriptExtension :.ps1
#scriptFileName  :currentFolder.ps1
#scriptFilePath  :X:\dev\autounattend\etc\pve\v2p\currentFolder.ps1
#scriptLogName   :currentFolder.log
#scriptLogPath   :X:\dev\autounattend\etc\pve\v2p\currentFolder.log

