# PLEASE MODIFY BELOW
function setVars {
$rnb    = 'demo'
$dom    = 'isystems.lab'
$usr    = 'administrator'
$pwd    = 'Test1234'
$pwdAD  = $pwd
$netw   = '192.168.10.1/24'
$dcip   = '192.168.10.171';$dc  = 'dc' ;$dcipTmp  = '192.168.10.133';
$admip  = '192.168.10.172';$adm = 'sql';$admipTmp = '192.168.10.190';
$rdsip  = '192.168.10.173';$rds = 'rds';$rdsipTmp = '192.168.10.191';
$ts1ip  = '192.168.10.174';$ts1 = 'ts1';$ts1ipTmp = '192.168.10.192';
$dnsip1 = '127.0.0.1'
$dnsip2 = $dcip
$fwip1 = '9.9.9.9'
$fwip2 = '8.8.8.8'
$crtPwd = 'sapB1iP'
$crtDns = 'localhost', 'sql', 'sld', 'dc', 'adm', 'rds', 'ts1'
$crtIps = '127.0.0.1', '192.168.10.171', '192.168.10.172', '192.168.10.173', '192.168.10.174', '192.168.10.175', '212.162.6.43'
# PLEASE KEEP & SEE COMMENTS BELOW
$scripts= $PSScriptRoot
$gwip   = $netw.Split('/')[0]
$prefix = $netw.Split('/')[1]
$netwid = $netw.Split('.')[0] + '.' + $netw.Split('.')[1] + '.' + $netw.Split('.')[2] + '.' + '0' + '/' + $prefix
$preint = [int]$prefix
$rdd    = $rnb.ToLower() + '.' + $dom
$nbios  = $rnb.ToUpper()
$dcusr  = $nbios         + '\' + $usr
$dcufqd = $usr + '@' + $rdd
$pwd    = ConvertTo-SecureString -AsPlainText $pwd   -Force
$pwdAD  = ConvertTo-SecureString -AsPlainText $pwdAD -Force
$cred   = New-Object System.Management.Automation.PSCredential -ArgumentList    $usr,$pwd
$credAD = New-Object System.Management.Automation.PSCredential -ArgumentList $dcufqd,$pwdAd
} ; . setVars
function PKIServ {
param([string]$out)
$certificatePath                   = $out
$newCertificateName                = $rdd
$newCertificatePassword            = $crtPwd
$dnsNames                          = $crtDns
$ipAddresses                       = $crtIps
$certificateYears                  = '2'
$rootCertificateName               = 'iSystems[CA]'
$rootCertificateThumbprint         = '189CDA9829C536A51B67F3687A98B4064B310EBE'
$intermediateCertificateName       = 'iSystems[IN]'
$intermediateCertificateThumbprint = 'E7A486F3A0CE1B04369A6E6CCD079E0BE019F2BE'
$newCertificateWildcard            = '*.' + $newCertificateName
$textExtension                     = "2.5.29.17={text}DNS=$($newCertificateWildcard -join '&DNS=')&DNS=$($newCertificateName -join '&DNS=')&$($dnsNames -join '&DNS=')&IPAddress=$($ipAddresses -join '&IPAddress=')"
$rootCertificate                   = Get-ChildItem -Path cert:\LocalMachine\My | where {$_.Thumbprint -eq $rootCertificateThumbprint}
$intermediateCertificate           = Get-ChildItem -Path cert:\LocalMachine\My | where {$_.Thumbprint -eq $intermediateCertificateThumbprint}
$params = @{
Signer            = $intermediateCertificate
KeyLength         = 2048
KeyAlgorithm      = 'RSA'
HashAlgorithm     = 'SHA256'
KeyExportPolicy   = 'Exportable'
NotAfter          = (Get-Date).AddYears($certificateYears)
Subject           = '*.' + $newCertificateName
TextExtension     = $textExtension
CertStoreLocation = 'Cert:\LocalMachine\My'
}
$newCertificate = New-SelfSignedCertificate @params
$certificateName = "iSystems[$newCertificateName]"
Export-PfxCertificate -Cert $newCertificate -FilePath "$certificatePath\$certificateName.pfx" -Password (ConvertTo-SecureString -AsPlainText $newCertificatePassword -Force)
Export-Certificate -Cert $newCertificate -FilePath "$certificatePath\$certificateName.cer"
}
#PKIServ -out "C:\Users\stuecking\iSystems GmbH\iSystems Support - SAP\EMEA\Customers\Support\Microsoft\Pki"
#PKIServ -out "X:\sync\onedrive\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Support\Microsoft\Pki"
#PKIServ -out "X:\iSystems Consulting e.K\iSystems Support - SAP\EMEA\Customers\Support\Microsoft\Pki"
function TestComputer { 
param(
 [string]$ip
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
 Enable-PSRemoting
 winrm quickconfig
 Set-Item wsman:\localhost\client\TrustedHosts -Value * -Force
 [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12;Install-PackageProvider Nuget -Force
 Install-Module -Name PowerShellGet -Force -SkipPublisherCheck -allowclobber
 $psgver = (get-installedmodule -name powershellget).version
 import-packageprovider -name PowerShellGet -force -requiredversion $psgver
 set-psrepository -name PSGallery -installationpolicy Trusted
 import-module -name PowerShellGet -requiredversion $psgver
}
}
#TestComputer            -ip  "$dcipTmp"
#TestComputer            -ip "$admipTmp"
#TestComputer            -ip "$rdsipTmp"
#TestComputer            -ip "$ts1ipTmp"
function ConfigureComputerStatic { 
param(
 [string]$ip,
 [string]$ipNew
)
#-InDisconnectedSession
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
# Get-Content -Raw -Path $SettingsBefore
 $Ethernet0            = "Ethernet0"
 $adapters             = Get-NetAdapter ; $i = 0 ; foreach ($adapter in $adapters) { Rename-NetAdapter -Name $adapter.Name -NewName "Ethernet$i" ; $i++ ; }
 $Settings             = "c:\ipconfigBefore.txt"
 $SettingsApply        = "c:\ipconfigBefore.ps1"
 $NetProfile           = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).NetProfile.Name                                                                                         ; echo "NetProfile           = $NetProfile          " >  $Settings
 $InterfaceAlias       = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).InterfaceAlias                                                                                          ; echo "InterfaceAlias       = $InterfaceAlias      " >> $Settings
 $InterfaceDescription = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).InterfaceDescription                                                                                    ; echo "InterfaceDescription = $InterfaceDescription" >> $Settings
 $InterfaceStatus      = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.Status                                                                              ; echo "InterfaceStatus      = $InterfaceStatus     " >> $Settings
 $InterfaceDhcpEnabled = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetIPv4Interface.DHCP                                                                          ; echo "InterfaceDhcpEnabled = $InterfaceDhcpEnabled" >> $Settings
 $InterfaceCategory    = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetProfile.NetworkCategory                                                                     ; echo "InterfaceCategory    = $InterfaceCategory   " >> $Settings
 $InterfaceMacDash     = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress                                                                    ; echo "InterfaceMacDash     = $InterfaceMacDash    " >> $Settings
 $InterfaceMacColon    = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress | % {$_.replace("-",":")}                                          ; echo "InterfaceMacColon    = $InterfaceMacColon   " >> $Settings
 $InterfaceMacString   = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress | % {$_.replace("-","")}                                           ; echo "InterfaceMacString   = $InterfaceMacString  " >> $Settings
 $ComputerName         = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0).ComputerName                                                                                             ; echo "ComputerName         = $ComputerName        " >> $Settings
 $IPAddress            = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).IPV4Address                                                                           ; echo "IPAddress            = $IPAddress           " >> $Settings
 $IPAddressFamily      = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).AddressFamily                                                                         ; echo "IPAddressFamily      = $IPAddressFamily     " >> $Settings
 $IPPrefixLength       = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).PrefixLength                                                                          ; echo "IPPrefixLength       = $IPPrefixLength      " >> $Settings
 $IPDefaultGateway     = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).IPv4DefaultGateway | select -ExpandProperty NextHop                                            ; echo "IPDefaultGateway     = $IPDefaultGateway    " >> $Settings
 $IPDNSServer          = (Get-DnsClientServerAddress                  -InterfaceAlias     $Ethernet0 | Select-Object -ExpandProperty ServerAddresses) -join "','";$IPDNSServer = -join("'", $IPDNSServer, "'") ; echo "IPDNSServer          = $IPDNSServer         " >> $Settings
 echo "#netsh interface ip reset                                                                                                                                                                  " >  "$SettingsApply"
 echo '$ethernet = Get-NetAdapter -name Ethernet0                                                                                                                                                 ' >> "$SettingsApply"
 echo '$ethernet | Set-NetIPInterface         -Dhcp:0                                                                                                                                             ' >> "$SettingsApply"
 echo '$ethernet | Set-NetAdapterBinding      -Enabled:0 -ComponentID ms_tcpip6                                                                                                                   ' >> "$SettingsApply"
 echo '$ethernet | Remove-NetIPAddress        -Confirm:0                                                                                                                                          ' >> "$SettingsApply"
 echo '$ethernet | Remove-NetRoute            -Confirm:0                                                                                                                                          ' >> "$SettingsApply"
 echo "sleep 3                                                                                                                                                                                    " >> "$SettingsApply"
 echo "New-NetIPAddress           -InterfaceAlias $InterfaceAlias -Confirm:0 -AddressFamily $IPAddressFamily -IPAddress $IPAddress -PrefixLength $IPPrefixLength -DefaultGateway $IPDefaultGateway" >> "$SettingsApply"
 echo "Set-DnsClientServerAddress -InterfaceAlias $InterfaceAlias -Confirm:0 -ServerAddresses $IPDNSServer                                                                                        " >> "$SettingsApply"
 echo "Clear-DnsClientCache                                                                                                                                                                       " >> "$SettingsApply"
 echo "Set-Itemproperty -Path HKLM:\SYSTEM\CurrentControlSet\Services\tcpip6\Parameters -Name DisabledComponents -value 32                                                                        " >> "$SettingsApply"
 echo "netsh interface teredo set state disabled                                                                                                                                                  " >> "$SettingsApply"
 echo "netsh interface ipv6 6to4 set state state=disabled undoonstop=disabled                                                                                                                     " >> "$SettingsApply"
 echo "netsh interface ipv6 isatap set state state=disabled                                                                                                                                       " >> "$SettingsApply"
 echo 'if([environment]::OSVersion.version.Major -lt 6) { return }                      # not if os older than vista                                                                              ' >> "$SettingsApply"
 echo 'if(1,3,4,5 -contains (Get-WmiObject win32_computersystem).DomainRole) { return } # not if domain joined                                                                                    ' >> "$SettingsApply"
 echo '$networkListManager = [Activator]::CreateInstance([Type]::GetTypeFromCLSID([Guid]"{DCB00C01-570F-4A9B-8D69-199FDBA5723B}"))                                                                ' >> "$SettingsApply"
 echo '$connections = $networkListManager.GetNetworkConnections()                                                                                                                                 ' >> "$SettingsApply"
 echo '$connections | % {$_.GetNetwork().SetCategory(1)}                                                                                                                                          ' >> "$SettingsApply"
 echo 'Get-NetConnectionProfile | Set-NetConnectionProfile -NetworkCategory Private                                                                                                               ' >> "$SettingsApply"
 echo '#done                                                                                                                                                                                      ' >> "$SettingsApply"
                  . "$SettingsApply"
 Remove-Item -Force "$SettingsApply"
 Remove-Item -Force "$Settings"
}
}
#ConfigureComputerStatic -ip  "$dcipTmp"
#ConfigureComputerStatic -ip "$admipTmp"
#ConfigureComputerStatic -ip "$rdsipTmp"
#ConfigureComputerStatic -ip "$ts1ipTmp"
function ConfigureComputerIpNew { 
param(
 [string]$ip,
 [string]$ipNew,
 [string]$name
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
 $Ethernet0            = "Ethernet0"
 $adapters             = Get-NetAdapter ; $i = 0 ; foreach ($adapter in $adapters) { Rename-NetAdapter -Name $adapter.Name -NewName "Ethernet$i" ; $i++ ; }
 $Settings             = "c:\ipconfigBefore.txt"
 $SettingsApply        = "c:\ipconfigBefore.ps1"
 $Settings             = "c:\ipconfigAfter.txt"
 $SettingsApply        = "c:\ipconfigAfter.ps1"
 $getDnsServers        = "$using:dnsip1 $using:dnsip2" ; $getDnsServers = $getDnsServers -replace '\s+', "','" ; $DnsServers = "'$getDnsServers'" ; $DnsServer  = "'$using:dcip'" ;
 $NetProfile           = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).NetProfile.Name                                                                                         ; echo "NetProfile           = $NetProfile          " >  $Settings
 $InterfaceAlias       = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).InterfaceAlias                                                                                          ; echo "InterfaceAlias       = $InterfaceAlias      " >> $Settings
 $InterfaceDescription = (Get-NetIPConfiguration    | Where-Object {$_.InterfaceAlias -eq $Ethernet0}).InterfaceDescription                                                                                    ; echo "InterfaceDescription = $InterfaceDescription" >> $Settings
 $InterfaceStatus      = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.Status                                                                              ; echo "InterfaceStatus      = $InterfaceStatus     " >> $Settings
 $InterfaceDhcpEnabled = "Disabled"                                                                                                                                                                            ; echo "InterfaceDhcpEnabled = $InterfaceDhcpEnabled" >> $Settings
 $InterfaceCategory    = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetProfile.NetworkCategory                                                                     ; echo "InterfaceCategory    = $InterfaceCategory   " >> $Settings
 $InterfaceMacDash     = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress                                                                    ; echo "InterfaceMacDash     = $InterfaceMacDash    " >> $Settings
 $InterfaceMacColon    = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress | % {$_.replace("-",":")}                                          ; echo "InterfaceMacColon    = $InterfaceMacColon   " >> $Settings
 $InterfaceMacString   = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 -Detailed).NetAdapter.LinkLayerAddress | % {$_.replace("-","")}                                           ; echo "InterfaceMacString   = $InterfaceMacString  " >> $Settings
 $ComputerName         = $using:name                                                                                                                                                                           ; echo "ComputerName         = $ComputerName        " >> $Settings
 $IPAddress            = $using:ipNew                                                                                                                                                                             ; echo "IPAddress            = $IPAddress           " >> $Settings
 $IPAddressFamily      = (Get-NetIPConfiguration                      -InterfaceAlias     $Ethernet0 | Get-NetIPAddress).AddressFamily                                                                         ; echo "IPAddressFamily      = $IPAddressFamily     " >> $Settings
 $IPPrefixLength       = $using:prefix                                                                                                                                                                         ; echo "IPPrefixLength       = $IPPrefixLength      " >> $Settings
 $IPDefaultGateway     = $using:gwip                                                                                                                                                                           ; echo "IPDefaultGateway     = $IPDefaultGateway    " >> $Settings
 $IPDNSServer          = if ($DnsServers -like "*$using:ipNew*") { $DnsServers } else { $DnsServer }                                                                                                           ; echo "IPDNSServer          = $IPDNSServer         " >> $Settings
 echo "#netsh interface ip reset                                                                                                                                                                  " >  "$SettingsApply"
 echo '$ethernet = Get-NetAdapter -name Ethernet0                                                                                                                                                 ' >> "$SettingsApply"
 echo '$ethernet | Set-NetIPInterface         -Dhcp:0                                                                                                                                             ' >> "$SettingsApply"
 echo '$ethernet | Set-NetAdapterBinding      -Enabled:0 -ComponentID ms_tcpip6                                                                                                                   ' >> "$SettingsApply"
 echo '$ethernet | Remove-NetIPAddress        -Confirm:0                                                                                                                                          ' >> "$SettingsApply"
 echo '$ethernet | Remove-NetRoute            -Confirm:0                                                                                                                                          ' >> "$SettingsApply"
 echo "sleep 3                                                                                                                                                                                    " >> "$SettingsApply"
 echo "New-NetIPAddress           -InterfaceAlias $InterfaceAlias -Confirm:0 -AddressFamily $IPAddressFamily -IPAddress $IPAddress -PrefixLength $IPPrefixLength -DefaultGateway $IPDefaultGateway" >> "$SettingsApply"
 echo "Set-DnsClientServerAddress -InterfaceAlias $InterfaceAlias -Confirm:0 -ServerAddresses $IPDNSServer                                                                                        " >> "$SettingsApply"
 echo "Clear-DnsClientCache                                                                                                                                                                       " >> "$SettingsApply"
 echo "Set-Itemproperty -Path HKLM:\SYSTEM\CurrentControlSet\Services\tcpip6\Parameters -Name DisabledComponents -value 32                                                                        " >> "$SettingsApply"
 echo "netsh interface teredo set state disabled                                                                                                                                                  " >> "$SettingsApply"
 echo "netsh interface ipv6 6to4 set state state=disabled undoonstop=disabled                                                                                                                     " >> "$SettingsApply"
 echo "netsh interface ipv6 isatap set state state=disabled                                                                                                                                       " >> "$SettingsApply"
 echo 'if([environment]::OSVersion.version.Major -lt 6) { return }                      # not if os older than vista                                                                              ' >> "$SettingsApply"
 echo 'if(1,3,4,5 -contains (Get-WmiObject win32_computersystem).DomainRole) { return } # not if domain joined                                                                                    ' >> "$SettingsApply"
 echo '$networkListManager = [Activator]::CreateInstance([Type]::GetTypeFromCLSID([Guid]"{DCB00C01-570F-4A9B-8D69-199FDBA5723B}"))                                                                ' >> "$SettingsApply"
 echo '$connections = $networkListManager.GetNetworkConnections()                                                                                                                                 ' >> "$SettingsApply"
 echo '$connections | % {$_.GetNetwork().SetCategory(1)}                                                                                                                                          ' >> "$SettingsApply"
 echo 'Get-NetConnectionProfile | Set-NetConnectionProfile -NetworkCategory Private                                                                                                               ' >> "$SettingsApply"
 echo '#done                                                                                                                                                                                      ' >> "$SettingsApply"
                  . "$SettingsApply"
 Remove-Item -Force "$SettingsApply"
 Remove-Item -Force "$Settings"
} -AsJob
}
#ConfigureComputerIpNew  -ip  "$dcipTmp" -ipNew  "$dcip" -name  "$dc"
#ConfigureComputerIpNew  -ip "$admipTmp" -ipNew "$admip" -name "$adm"
#ConfigureComputerIpNew  -ip "$rdsipTmp" -ipNew "$rdsip" -name "$rds"
#ConfigureComputerIpNew  -ip "$ts1ipTmp" -ipNew "$ts1ip" -name "$ts1"
function ScriptBlockTest {param([string]$ip,[string]$name);$scriptBlock = [Scriptblock]::Create(@"
 echo "without:$env:computername"
 echo "   with:`$env:computername"
"@) ; Invoke-Command -ComputerName $ip -Credential $credAD -ScriptBlock $scriptBlock ;
}
#ScriptBlockTest -ip  "$admip"
function RenameComputer { 
param(
 [string]$ip,
 [string]$name
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
 Rename-Computer -NewName $Using:name -Restart -Force;
}
}
#RenameComputer          -ip  "$dcip" -name "$dc"
#RenameComputer          -ip "$admip" -name "$adm"
#RenameComputer          -ip "$rdsip" -name "$rds"
#RenameComputer          -ip "$ts1ip" -name "$ts1"
function InstallDc {
param(
 [string]$ip,
 [string]$rdd,
 [string]$rds,
 [string]$rdsip,
 [string]$nbios,
 [string]$netwid,
 [string]$dnsip1,
 [string]$dnsip2,
 [string]$fwip1,
 [string]$fwip2,
 [Security.SecureString]$pwdAD
)
Write-Host "DC is installing.";
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
Set-DnsClientServerAddress -InterfaceAlias "Ethernet0" -ServerAddresses "$Using:dnsip1","$Using:dnsip2"
Set-ItemProperty -Path 'HKLM:\SYSTEM\CurrentControlSet\Services\LanmanWorkstation' -Name DependOnService -Value @('Bowser','MRxSmb20','NSI','DNS')
"sc config NlaSvc start= delayed-auto & sc triggerinfo NlaSvc start/networkon stop/networkoff & sc qc NlaSvc & sc qtriggerinfo NlaSvc" | cmd
Install-WindowsFeature -Name AD-Domain-Services -IncludeManagementTools -IncludeAllSubFeature
Import-Module ADDSDeployment
Install-ADDSForest -DomainName $Using:rdd -DomainNetBiosName $Using:nbios -DomainMode WinThreshold -ForestMode WinThreshold -SkipPreChecks -InstallDns:$true -SafeModeAdministratorPassword $Using:pwdAD -Force
}
Write-Host "DC is rebooting."
Start-Sleep -s 420
Write-Host "DC is installing.";
Invoke-Command -ComputerName $ip -Credential $credAD -ScriptBlock {
$rddfqdn = $using:rds + '.' + $using:rdd
(Get-ADDomain | Format-List Name, DomainMode) + (Get-ADForest | Format-List Name, ForestMode)
Add-DnsServerPrimaryZone     -NetworkID $Using:netwid -ReplicationScope Domain -DynamicUpdate Secure -PassThru
ADD-ADGroupMember -Identity "Terminal Server License Servers" -members "$using:rds$"
Add-DnsServerResourceRecordA -Name $using:rds -ZoneName $using:rdd -AllowUpdateAny -IPv4Address $using:rdsip -createPTR
Set-DnsServerForwarder       -IPAddress "$Using:fwip1","$Using:fwip2"
ipconfig /registerdns
Restart-Computer
}
Write-Host "DC is rebooting."
Start-Sleep -s 90
Write-Host "DC is done.";
Write-Host "----------------------------------------------------------";
Write-Host "Please proceed with the below before joining new machines.";
Write-Host "1) Import/Link/Edit GPOs and WMIFilters";
Write-Host "2) ...";
Write-Host "3) ...";
Write-Host "----------------------------------------------------------";
}
#InstallDC               -ip "$dcip" -rdd "$rdd" -rds "$rds" -rdsip "$rdsip" -rnb "$nbios" -netwid "$netwid" -dnsip1 "$dnsip1" -dnsip2 "$dnsip2" -fwip1 "$fwip1" -fwip2 "$fwip2" -pwdAD $pwdAD
function JoinDomain {
param(
 [string]$ip,
 [string]$rdd,
 [string]$dcufqd,
 [Security.SecureString]$pwdAD
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
 $credADJoin = New-Object System.Management.Automation.PSCredential -ArgumentList $using:dcufqd,$using:pwdAD
 Add-Computer -domainname $using:rdd -Credential $credADJoin
 Enable-PSRemoting
 winrm quickconfig
 Set-Item wsman:\localhost\client\TrustedHosts -Value * -Force
 Restart-Computer -Force
}
Write-Host "Joined & Restarting $ip."
}
#JoinDomain              -ip "$admip" -rdd "$rdd" -dcufqd "$dcufqd" -pwdAD $pwdAD
#JoinDomain              -ip "$rdsip" -rdd "$rdd" -dcufqd "$dcufqd" -pwdAD $pwdAD
#JoinDomain              -ip "$ts1ip" -rdd "$rdd" -dcufqd "$dcufqd" -pwdAD $pwdAD
function LicenseSessionHost {
param(
 [string]$ip,
 [string]$rds
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
 ADD-ADGroupMember -Identity "Terminal Server License Servers" -members "$using:rds$"
}
}
#LicenseSessionHost      -ip "$dcip" -rds "$rds"
function InstallSessionHost {
param(
 [string]$ip
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
 Add-WindowsFeature -Name RDS-RD-Server -IncludeAllSubFeature -Restart
}
}
#InstallSessionHost      -ip "$rdsip"
#InstallSessionHost      -ip "$ts1ip"
function InstallRdsCollection {
#REG ADD HKLM\Software\Microsoft\Windows\CurrentVersion\Policies\System\CredSSP\Parameters\ /v AllowEncryptionOracle /t REG_DWORD /d 2
#Set-item wsman:\localhost\Client\TrustedHosts -value $ip -Force
#Enable-WSManCredSSP –Role Client –DelegateComputer $ip -Force
#Enable-WSManCredSSP –Role Server -Force
param(
 [string]$ip,
 [string]$name,
 [string]$rdd
)
Invoke-Command -ComputerName $ip -Credential $cred -ScriptBlock {
#https://woshub.com/convert-sid-to-username-and-vice-versa/
#[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12;Install-PackageProvider Nuget –Force
#Install-Module -Name PowerShellGet -Force -SkipPublisherCheck
 $Settings = "c:\InstallRdsCollection.ps1"
 $rddfqdn = $using:name + '.' + $using:rdd
 $UserGroups = '"' + 'Domain Users' + '@' + $using:rdd + '"'
 echo "Import-Module RemoteDesktop                                                                                                                    " >$settings
 echo "New-RDSessionDeployment -ConnectionBroker $rddfqdn -WebAccessServer $rddfqdn -SessionHost $rddfqdn                                             ">>$settings
 echo "Add-WindowsFeature     -ComputerName $rddfqdn -Name RDS-Gateway -IncludeManagementTools                                                        ">>$settings
 echo "Add-RDServer           -Server       $rddfqdn -Role RDS-Gateway -ConnectionBroker $rddfqdn -GatewayExternalFqdn $rddfqdn                       ">>$settings
 echo "Add-RDServer -Server $rddfqdn -Role RDS-LICENSING -ConnectionBroker $rddfqdn                                                                   ">>$settings
 echo 'Set-RDLicenseConfiguration -LicenseServer $rddfqdn -Mode PerUser -ConnectionBroker $rddfqdn -Force                                             '>>$settings
 echo 'Set-Item    -Path RDS:\LicenseServer\Configuration\FirstName     -Value "Support"                                                              '>>$settings
 echo 'Set-Item    -Path RDS:\LicenseServer\Configuration\LastName      -Value "EU"                                                                   '>>$settings
 echo 'Set-Item    -Path RDS:\LicenseServer\Configuration\Company       -Value "iSystems"                                                             '>>$settings
 echo 'Set-Item    -Path RDS:\LicenseServer\Configuration\CountryRegion -Value "Germany"                                                              '>>$settings
 echo 'Set-Item    -Path RDS:\LicenseServer\ActivationStatus            -Value 1 -ConnectionMethod AUTO -Reason 5                                     '>>$settings 
 echo 'Import-Module RemoteDesktopServices                                                                                                            '>>$settings
 echo "Set-RDDeploymentGatewayConfiguration -GatewayMode Custom -GatewayExternalFQDN $rddfqdn -LogonMethod AllowUserToSelectDuringConnection -UseCachedCredentials:1 -BypassLocal:0 -ConnectionBroker $rddfqdn -force">>$settings
 echo "Remove-Item -Path RDS:\GatewayServer\CAP\RDS                                        -Force -recurse                                            ">>$settings
 echo "Remove-Item -Path RDS:\GatewayServer\RAP\RDS                                        -Force -recurse                                            ">>$settings
 echo "Remove-Item -Path RDS:\GatewayServer\CAP\RDG_CAP_AllUsers                           -Force -recurse                                            ">>$settings
 echo "Remove-Item -Path RDS:\GatewayServer\RAP\RDG_RDConnectionBrokers                    -Force -recurse                                            ">>$settings
 echo "Remove-Item -Path RDS:\GatewayServer\RAP\RDG_AllDomainComputers                     -Force -recurse                                            ">>$settings
 echo "Remove-Item -Path RDS:\GatewayServer\GatewayManagedComputerGroups\RDG_RDCBComputers -Force -recurse                                            ">>$settings
 echo "New-Item    -Path RDS:\GatewayServer\CAP\                                           -Name RDS -UserGroups $UserGroups -AuthMethod '1' -Force   ">>$settings
 echo "Set-Item    -Path RDS:\GatewayServer\CAP\RDS\DeviceRedirection\Printers             -Value '1'                                                 ">>$settings
 echo "Set-Item    -Path RDS:\GatewayServer\CAP\RDS\DeviceRedirection\SerialPorts          -Value '0'                                                 ">>$settings
 echo "Set-Item    -Path RDS:\GatewayServer\CAP\RDS\DeviceRedirection\PlugAndPlayDevices   -Value '0'                                                 ">>$settings
 echo "New-Item    -Path RDS:\GatewayServer\RAP\ -Name RDS -UserGroups $UserGroups -ComputerGroupType '2' -Force                                      ">>$settings
 echo "New-Item    -Path RDS:\GatewayServer\GatewayFarm\Servers -Name $rddfqdn -Force                                                                 ">>$settings
 echo 'Set-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\TerminalServerGateway\Config\Core" -Name "IsUdpEnabled" -Value "0"  '>>$settings
 echo 'install-module -name RDWebClientManagement -acceptlicense -force                                                                               '>>$settings
 echo 'install-rdwebclientpackage                                                                                                                     '>>$settings
 #G:430
 #<tr><td align="right"> <a href="password.aspx" title="Reset Password">Click Here</a> to change your password. </td></tr>
 #https://aventistech.com/2018/09/07/deploy-windows-2016-rds-with-powershell/
 #. "$Settings"
 #Remove-Item -Force "$Settings"
}
#Enter-PSSession "192.168.10.173" -Credential $cred
Write-Host "Please RDP to the RDS server and run the following as domain administrator:"
Write-Host ". c:\InstallRdsCollection.ps1"
#Invoke-Command -ScriptBlock { & 'c:\automatedtests\test.ps1'} -ComputerName RemoteComputer
}
#InstallRdsCollection     -ip "$rdsip" -name "$rds" -rdd "$rdd"
Get-Variable | Where {$_.Name -like "*ip*"} | Where {$_.Name -ne "PSScriptRoot"}
