# Define the registry path for pagefile settings
$RegPath = "HKLM:\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management"

# Set PagingFiles to "Automatic Managed"
Set-ItemProperty -Path $RegPath -Name "PagingFiles" -Value ""

# Configure the system to let Windows manage the pagefile
Set-ItemProperty -Path $RegPath -Name "ExistingPageFiles" -Value ""

# Notify user about the changes
Write-Host "Windows is now configured to automatically manage the pagefile size. A restart is required for the changes to take effect." -ForegroundColor Green
