if ($PsVersionTable.PSVersion.Major -lt 5) {
    "Current powershell version is: " + $PsVersionTable.PSVersion.Major.ToString() | Write-Output
    Write-Output "The onecli_completion script need powershell to be 5.0 or higher"
}
else {
    $comp_file = Join-Path "$PSScriptRoot" "help/onecli_completion.ps1"
    $prodir = Split-Path "$profile"
    if ( -not (Test-Path $prodir)) {
        Split-Path "$profile" | New-Item -Path $prodir -ItemType Directory
    } 
    $install_file = Join-Path "$prodir" "onecli_completion.ps1"
    Copy-Item -Path "$comp_file" -Destination "$install_file" -Force
    $import_cmd = "Import-Module `$PSScriptRoot/onecli_completion.ps1"
    $installed = $false
    if (Test-Path $profile) {
        $profile_content = Get-Content $profile
        foreach ($line in $profile_content) {
            if ($line.ToString() -eq $import_cmd) {
                $installed = $true
                break
            }
        }
    }
    if ($installed -eq $false) {
        "`n" + $import_cmd | Out-File -Append -FilePath $profile -Encoding utf8
    }
    Write-Output "Please restart your powershell to enable the completion function"
}