#!/usr/bin/env sh
# Copyright © 2019-present Lenovo. All rights reserved.
# License: Subject to terms of Lenovo License Agreement
# 
# This program is protected under relevant copyright laws. The information contained 
# herein is a sole property of Lenovo and must be kept in strict confidence by the recipient. 
# 
# Reproduction or disclosure, in whole or in part, or the 
# production of derivative works therefrom without the express permission of 
# Lenovo's Legal Team is strickly prohibited.
#Author:gujuan   Mail:gujuan2@lenovo.com  
#Reviewer:Emma  Mail:zhangjh11@lenovo.com 
#Tester:Tiger  Mail:keyue1@lenovo.com
EXE_DIR=`pwd`

MT_Tag="<MT>"
OS_Tag="<OS>"
ARCH_Tag="<ARCH>"
ID_Tag="<UPDATEID>"
SELECT_Tag="<SELECTED>"

ONECLI_BIN="/home/gujuan/bins/01p/OneCli"
OUT="$EXE_DIR/out"
PKG_DIR=$OUT/"pkg"
SCAN_xml="" #"$EXE_DIR/Onecli-update-scan.xml"

MT_val=""
OS_val=""
ARCH_val=""

BMC_val=""
SFTP_val=""

declare -A OS_dic
OS_dic=(["VMware"]="vmware" \
["AIX"]="aix" \
["Windows NT"]="winnt" \
["Windows 2000"]="win2000" \
["Windows 2003"]="win2003" \
["Windows PE"]="winpe" \
["Windows XP"]="winxp" \
["Win DC 2000"]="wincenter2000" \
["Win DC 2003"]="wincenter2003" \
["Win Vista"]="winvista" \
["Win Server 2008"]="win2008" \
["Windows 2012"]="win2012" \
["Windows 2012 R2"]="win2012r2" \
["Windows 7"]="win7" \
["Windows 8"]="win8" \
["Windows 2016"]="win2016" \
["RHEL 3"]="rhel3" \
["RHEL 4"]="rhel4" \
["RHEL 5"]="rhel5" \
["RHEL 6"]="rhel6" \
["RHEL 7"]="rhel7" \
["SLES 8"]="sles8" \
["SLES 9"]="sles9" \
["SLES 10"]="sles10" \
["SLES 11"]="sles11" \
["SLES 12"]="sles12" \
["VMware ESX 2"]="esx2" \
["VMware ESX 3_4"]="esx3_4" \
["VMware ESXi 4"]="esxi4" \
["VMware ESXi 6.5"]="esxi6.5" \
["VMware ESXi 5.0"]="esxi5.0" \
["VMware ESXi 5.1"]="esxi5.1" \
["VMware ESXi 5.5"]="esxi5.5" \
["VMware ESXi 6.0"]="esxi6.0" \
["RHEV-H 1"]="rhevh1" \
["PLATFORM"]="platform" \
["None"]="none")



function GetInfoFromScanXml()
{
	if [ -n "$SCAN_xml" ]&&[ -f "$SCAN_xml" ]; then 
		echo "$SCAN_xml has exist,we will get information refer this."
	else
		echo "scan xml is not exist, we will do onecli to inventory."
		param="--log 5 --output $OUT "
		[ -n "$BMC_val" ]&& param=$param"--bmc $BMC_val "
		echo $ONECLI_BIN update scan $param
		$ONECLI_BIN update scan $param
		[ $? != 0 ]&& echo "Do scan failed,exit." && return 1
		SCAN_xml=$OUT/"Onecli-update-scan.xml" 	
	fi
	MT_val=`cat $SCAN_xml|grep $MT_Tag|sed -e 's/.*>\(.*\)<.*/\1/'|tr -d " "`
	OS_val=`cat $SCAN_xml|grep $OS_Tag|sed -e 's/.*>\(.*\)<.*/\1/'`
	ARCH_val=`cat $SCAN_xml|grep $ARCH_Tag|sed -e 's/.*>\(.*\)<.*/\1/'|tr -d " "` 
	return 0
}


function DoDownloadXml()
{
	echo "Downloading xml..."
	param=""
	[ -n "$MT_val" ] && param="--mt $MT_val "
	os_val1=${OS_dic[$OS_val]}
	[ -n "$os_val1" ]&& param=$param"--ostype $os_val1 "
	mkdir -p $PKG_DIR
	echo "$ONECLI_BIN update acquire $param --scope latest --dir $PKG_DIR --metaonly --log 5 --output $OUT"
	$ONECLI_BIN update acquire $param --scope latest --dir $PKG_DIR --metaonly --log 5 --output $OUT
}

NeedUpdatePackages=()

function DoCompare()
{
	echo "Do compare..."
	param="--scanxml $SCAN_xml --dir $PKG_DIR --scope latest "
	echo $ONECLI_BIN update compare $param --log 5 --output $OUT
	$ONECLI_BIN update compare $param --log 5 --output $OUT
	compare_result="$OUT/Onecli-update-compare.xml"
	echo $compare_result
	count=0
	tmp=""
	while read data
	do
		echo $data|grep $ID_Tag 1>/dev/null 2>/dev/null
		if [ $? == 0 ];then
			tmp=`echo $data|sed -e 's/.*>\(.*\)<.*/\1/'|tr -d " "`
		fi

		echo $data|grep $SELECT_Tag 1>/dev/null 2>/dev/null
		if [ $? == 0 ];then
			select_value=`echo $data|sed -e 's/.*>\(.*\)<.*/\1/'|tr -d " "`
			#echo "$select_value"
			[ $select_value != 0 ] && NeedUpdatePackages[count]=$tmp && let count=count+1
		fi
				
	done < $compare_result

	#for id in ${NeedUpdatePackages[*]}
	#do
	#	echo ----$id
	#done
}

function DoAcquireAndFlash()
{
	ids=""
        for id in ${NeedUpdatePackages[*]}
        do
		ids=$ids","$id
        done
        ids=`echo ${ids:1}`
        param="--scope individual --includeid $ids --dir $PKG_DIR "
        param=$param"--log 5 --output $OUT "
	

	if [ -n $BMC_val ] && [ -n "$SFTP_val" ];then
		ConfirmPayloadInSftp
	else
	
		echo $ONECLI_BIN update acquire $param  
		$ONECLI_BIN update acquire $param 
		[ $? != 0 ]&& echo "Download payload failed,exit."&& return 1
	fi

	[ -n "$BMC_val" ]&& param=$param" --bmc $BMC_val "
	[ -n "$SFTP_val" ]&&param=$param" --sftp $SFTP_val "

	param=$param"--nocompare "
	echo $ONECLI_BIN update flash $param 
	$ONECLI_BIN update flash $param 
	return 0
}

Payload=""
function GetPayload()
{
	info=`grep -A 2 -E ".*PROPERTY.*NAME.*\"payload\".*" $PKG_DIR/$1.xml`
	Payload=`echo $info|sed -e 's/.*VALUE>\(.*\)<\/VALUE.*/\1/'`
	
}
	
function ConfirmPayloadInSftp()
{
	SFTP_auth=`echo $SFTP_val|cut -d @ -f 1`
	SFTP_path=`echo $SFTP_val|cut -d @ -f 2`
	#echo "curl -u $SFTP_auth sftp://$SFTP_path/ -k -l"
	remote_files=`curl -u $SFTP_auth sftp://$SFTP_path/ -k -l 2>/dev/null`

	for id in ${NeedUpdatePackages[*]}
	do
		GetPayload $id
		[ -z $Payload ] && echo "Could not find $id payload." && continue
		has_payload=0
		for file in $remote_files
		do
		#	echo "$file==$Payload"
			if [ "x$file" = "x$Payload" ] ;then
				has_payload=1
				break
			fi
		done
		if [ $has_payload -eq 0 ];then
			echo "$Payload not found in sftp server, will download from lenovo server and upload to sftp server... "
			param="--scope individual --includeid $id --dir $PKG_DIR "
			param=$param"--log 5 --output $OUT "
		        $ONECLI_BIN update acquire $param
			
			[ $? != 0 ] && echo "downlaod $Payload failed,exit progress." && exit 1
			curl -u $SFTP_auth -T $PKG_DIR/$Payload sftp://$SFTP_path/$Payload -k 1>/dev/null 2>/dev/null
			[ $? != 0 ] && echo "upload $Payload failed,exit progress." && exit 1
		fi
	done
}

function clean()
{
	rm -fr $OUT
}

function usage()
{
	echo -e "#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::#
    # Make sure to go through below 
    # - The script is put under <root>/xxx.sh
    # - <root> is where OneCLI zip package is extracted to
    	#This script can be used to flash the packages on demand for both IB and OOB
    	#The script will download the needed packages for user's senario
    # Note:
    # Pleae make sure the os can access to ethernet
    # See in user's guide for more details of command line options and adavanced 
    # features Product home page: https://support.lenovo.com/us/en/documents/lnvo-tcli
    #::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::#
    "
	echo "[usage]"
	echo -e "-b \tspecial bmc's information.Same as Onecli's \"--bmc\""
	echo -e "-s \tspecial scanxml"
	echo -e "-f \tspecial sftp's informaton.Same as Onecli's \"--sftp\""
	echo -e "-c \tclean all logs and packages"
	echo -e "-h \thelp"
}

##-----------------------main()-----------------------------------------##
while getopts "b:s:f:hc" arg
do 
	case $arg in
	b)
		BMC_val=$OPTARG
	;;
	s)
		SCAN_xml=$OPTARG
	;;
	f)
		SFTP_val=$OPTARG
	;;
	c)
		clean
		exit 0
	;;
	h)
		usage
		exit 0
	;;
	?)
	;;
	esac
done


GetInfoFromScanXml
[ $? != 0 ]&& exit 1

DoDownloadXml
[ $? != 0 ] && echo "download xml file failed, so exit"&& exit 1

DoCompare
#check packages size
count=${#NeedUpdatePackages[@]}
[ $count == 0 ]&& echo "No device needs to update." && exit 0

DoAcquireAndFlash
[ $? == 0 ]&& echo "Update success.Enjoy it."





