#!/usr/bin/env sh
# Copyright © 2019-present Lenovo. All rights reserved.
# License: Subject to terms of Lenovo License Agreement
# 
# This program is protected under relevant copyright laws. The information contained 
# herein is a sole property of Lenovo and must be kept in strict confidence by the recipient. 
# 
# Reproduction or disclosure, in whole or in part, or the 
# production of derivative works therefrom without the express permission of 
# Lenovo's Legal Team is strickly prohibited.
#Author:Emma   Mail:zhangjh11@lenovo.com  
#Reviewer:Ken  Mail:zhoukai2@lenovo.com 
#Tester:Tiger  Mail:keyue1@lenovo.com
ONECLI_EXE_DIR=`pwd`/.

print_usage_msg() { 
echo -e "#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::#
# Make sure to go through below 
# - The script is put under <root>/inband_firmware_update_for_prerequisite.sh
# - <root> is where OneCLI zip package is extracted to
# Note: 
# 1. Suppose the packages are put under local folder /var/tmp/download/repo/5465.
# 2. You might need to run this script twice to apply the latest updates package.
#    The script will help you to update the prerequiste uefi 108r 
#    and reboot the os to make it take effect if needed;
#    The script will help you to update all the needed packages for the second 
#    time or if the the installed uefi is already newer than 108r;
# 3. The script might reboot your os to make the prerequiste uefi 108r 
#    to take effect.
# 4. This is just a sample with 108r as the prerequiste, you can change 
#    'lnvgy_fw_uefi_the108r-1.31_anyos_32-64' with another uefi prerequiste,
#    It is better for you to replace '108r' with another uefi version too.
# See in user's guide for more details of command line options and adavanced 
# features Product home page: https://support.lenovo.com/us/en/documents/lnvo-tcli
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::#
"
}
# XXX  print the message, if parameter '-h/--help' is set
if [[ "$1" == "-h" || "$1" == "--help" ]];then 
    print_usage_msg 
    exit 0
fi

# XXX check if onecli is under $ONECLI_EXE_DIR.
if [[ ! -x $ONECLI_EXE_DIR/OneCli ]];then 
    echo "-- Error.  Not found $ONECLI_EXE_DIR/OneCLi execuatable file" 2>&1
    print_usage_msg
    exit 1
fi

# XXX check the packages.
pkgnum=`ls /var/tmp/download/repo/5465/lnvgy_fw_uefi_the108r-1.31_anyos_32-64.* | wc -l`
if [[ $pkgnum -eq 0 ]];then
    echo "-- Error.  Not found package in /var/tmp/download/repo/5465/" 2>&1
    print_usage_msg
    exit 2
fi

cd $ONECLI_EXE_DIR

echo -e "Copy the pre requesite to a seperate package"
mkdir -p /var/tmp/download/repo/5465/prerequiste
cp /var/tmp/download/repo/5465/lnvgy_fw_uefi_the108r-1.31_anyos_32-64.* /var/tmp/download/repo/5465/prerequiste
rm -fr ./requiste-output

echo -e "./OneCli update flash --scope latest --dir /var/tmp/download/repo/5465/prerequiste --output ./requiste-output"
./OneCli update flash --scope latest --dir /var/tmp/download/repo/5465/prerequiste --output ./requiste-output
echo -e "Check if the prerequiste package 108r has been flashed"
grep -q "lnvgy_fw_uefi_the108r-1.31_anyos_32-64" ./requiste-output/Onecli-update-flash.xml
if [ $? == 0 ];then
	echo -e "Prerequsite package 108r has been installed in the last cmd"
grep -q "Success" ./requiste-output/Onecli-update-flash.xml
if [ $? == 0 ]; then 
	echo -e "prerequiste uefi 108r has been isntalled successully, need to reboot the os to make it take effect"
		echo -e "You might need to run this script again to flash all the package after system reboot..."
    echo -e "Reboot OS Needed to make 108r take effect!!! Press 'Ctrl-C' to Exit" ;  sleep 2
    echo -e "Reboot OS Needed to make 108r take effect!!! Press 'Ctrl-C' to Exit" ;  sleep 2
    echo -e "Reboot OS Needed to make 108r take effect!!! Press 'Ctrl-C' to Exit" ;  sleep 2
		init 6
       else
        echo -e "prerequiste uefi 108r has not been installed correctly, need manually check!! "
       fi
else
   echo -e "No need to install the prerequiste 108r package..."
   echo -e "Flash all the packages need to be update on the OS"
   echo -e "./Onecli update flash --scope latest --dir /var/tmp/download/repo/5465"
  ./OneCli update flash --scope latest --dir /var/tmp/download/repo/5465

  [ $? -eq 0 ] || echo "-- Error. Run OneCli failed"
fi
