#!/bin/sh
# Copyright © 2018 - present Lenovo.  All rights reserved.
# Confidential and Proprietary.
export DATA_DIR_NAME="FOD"
FOD_KEY_DIR="${LOCAL_STORAGE_DIR}/$DATA_DIR_NAME"
#FOD_SAVED_KEYFILE_INFO="$FOD_KEY_DIR/info"
FOD_LOG_DIR="$BOMC_LOG_DIR/$DATA_DIR_NAME"

export MD_LOG_DIR=$FOD_LOG_DIR

FOD_KEY_BUF=()
FOD_DISP_BUF=()
FOD_INSTALLFILE_BUF=()
FOD_RESULT_BUF=()
#-----------------------
FOD_KEY_FILE="/tmp/fod_key_tmp"
CUR_FOD_INFO_FILE="$FOD_LOG_DIR/fod_report_result.xml"

declare -A Fod_dict

function loadKeys()
{
	mline=""
	key=""
	disp=""
	FOD_KEY_BUF=()
	while read mline
	do
#		echo "LINE:"$mline
		key="${key}"`echo ${mline%:*}`":"
		disp="${disp}"`echo ${mline#*:}`":"
#		Fod_dict[$key]="$value"
	done < $FOD_KEY_FILE
	store_ifs=$IFS
	IFS=":"
	FOD_KEY_BUF=(${key})
	FOD_DISP_BUF=(${disp})
	FOD_RESULT_BUF=(${key})
	FOD_INSTALLFILE_BUF=(${key})#fake
	IFS=$store_ifs
}

function DisplayActiveFoDkeys()
{
	read -p "Enter the REST port (empty for no change): " rest_port
	read -p "Enter the CIM port (empty for no change): " cim_port
	if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ];then
		${Run} "$GET_CMD" "blank" "$cim_port" "$rest_port"
		#${Run} "$ONECLI_BIN fod report $ONECLI_ADD_OPTION --output $FOD_LOG_DIR" "cat $ONECLI_CONSOLE_FILE | grep -A 10 'Key ID'"
		[ $? != 0 ] && return
		cat $ONECLI_CONSOLE_FILE|grep -A 10 "Key ID" 1>/dev/null 2>&1		
		
		if [[ $? != 0 ]] || [[ ! $(cat $ONECLI_CONSOLE_FILE|grep -v "Log("|grep -A 10 "Key ID"|grep -v "Key ID") ]] >/dev/null 2>/dev/null ; then
			echo "Not found any FoD key."
			return 
		fi
		
		echo -e "No.\tKey ID\t\t\tStatus\t\tDescription\t\t\t\t\t\t\tExpired Date"
		cat $ONECLI_CONSOLE_FILE|grep -v "Log("|grep -A 10 "Key ID"|grep -v "Key ID"|awk '{n=NF;if($n == "N/A")print $1"\t"$2"\t"substr($0,23,15)"\t"substr($0,45,60)"\t"$n;else print $1"\t"$2"\t"substr($0,23,15)"\t"substr($0,45,60)"\t"$(n-1)" "$n}'
		cat $ONECLI_CONSOLE_FILE|grep -v "Log("|grep -A 10 "Key ID"|grep -v "Key ID"|awk  '{print $2":"substr($0,40,60)}'>$FOD_KEY_FILE
	else
		${Run} "$GET_CMD" "blank" "$cim_port" "$rest_port"
		[ $? != 0 ] && return 0
		[ ! -e "$CUR_FOD_INFO_FILE" ]&& echo "[Warning]: Not found any FoD key." && return 0
		
		# count=`$XML_TOOL --xpath "count(FODS/*)" $CUR_FOD_INFO_FILE`
		# [ $count == 0 ] && echo "Not found any FoD key." && return 0
		# for i in $(seq 1 $count)
		# do
		# 	printf "%-5s%-15s%-19s%-15s%-60s%-15s\n" "No." "Feature Type" "Key ID" "Status" "Description" "Expired Date"
		# 	point="FODS/FOD[$i]"
		# 	type=`$XML_TOOL --xpath "$point/FeatureType/text()" $CUR_FOD_INFO_FILE`
		# 	id=`$XML_TOOL --xpath "$point/KeyID/text()" $CUR_FOD_INFO_FILE`
		# 	status=`$XML_TOOL --xpath "$point/Status/text()" $CUR_FOD_INFO_FILE`
		# 	desp=`$XML_TOOL --xpath "$point/Description/text()" $CUR_FOD_INFO_FILE`
		# 	expireddate=`$XML_TOOL --xpath "$point/ExpiredDate/text()" $CUR_FOD_INFO_FILE`
		# 	printf  "%-5s%-15s%-19s%-15s%-60s%-15s\n" "$i" "$type" "$id" "$status" "$desp" "$expireddate"
			
		# 	featureListCount=`$XML_TOOL --xpath "count($point/FeatureList/*)" $CUR_FOD_INFO_FILE`
		# 	[ $featureListCount == 0 ] && continue
		# 	printf "%-10s\n\n" "Feature List"
		# 	for j in $(seq 1 $featureListCount)
		# 	do
		# 		feature=`$XML_TOOL --xpath "$point/FeatureList/Feature[$j]/text()" $CUR_FOD_INFO_FILE`
		# 		printf "%-10s\n" "$feature"
		# 	done
		# 	printf "\n"
		# done
	fi
	
}


# function isInKeys()
# {
# 	found=0
# 	val=`echo $1|sed s/' '//g`

# 	for key in ${FOD_KEY_BUF[*]}
# 	do
# 		[ "x$key" == "x$val" ] && found=1
# 	done
# 	return $found
# }
Fod_key_num=""
Fod_key_choose=""

function showFodKey()
{
	[ ${#FOD_KEY_BUF[*]} != 0 ]  && [ -n "${FOD_KEY_BUF[0]}" ] && echo -e "\rNo.\tKey ID\t\t\tDescription"
	count=0
	for ((i=0; i<${#FOD_KEY_BUF[*]}; ++i ))
	do
		[ -z "${FOD_KEY_BUF[$i]}" ] && continue
		[ -z "${FOD_DISP_BUF[$i]}" ] && continue
		let count=count+1
		echo -e "$count\t${FOD_KEY_BUF[$i]}\t${FOD_DISP_BUF[$i]}"
		
		#initial key choose 
		Fod_key_num=$i
		Fod_key_choose=${FOD_KEY_BUF[$i]}
	done
	return $count
}

function getFodKey()
{
	echo "Keys detected."
	read -p "Enter the REST port (empty for no change): " rest_port
	read -p "Enter the CIM port (empty for no change): " cim_port
	${Run} "$GET_CMD" "blank" "$cim_port" "$rest_port"
	[ $? != 0 ] && return 1
	[ ! -e "$CUR_FOD_INFO_FILE" ]&& echo "[Warning]: Please use newest UpdateXpress." && return 1

	if [ "x$BOOT_OS_ENV_TYPE" == x"MCP" ];then
		cat $ONECLI_CONSOLE_FILE|grep -v "Log("|grep -A 10 "Key ID"|grep -v "key ID"|grep -v "Description"|awk  '{print $2":"substr($0,40,60)}'>$FOD_KEY_FILE
	else
		# cat $ONECLI_CONSOLE_FILE|grep -A 10 "Feature Type"|grep -v "Feature Type"|awk  '{print $2":"substr($0,49,50)}'>$FOD_KEY_FILE
		
		count=`$XML_TOOL --xpath "count(FODS/*)" $CUR_FOD_INFO_FILE`
		rm -f $FOD_KEY_FILE 1>/dev/null 2>&1
		[ $count == 0 ] && return 1

		for i in $(seq 1 $count)
		do
			point="FODS/FOD[$i]"
			
			id=`$XML_TOOL --xpath "$point/KeyID/text()" $CUR_FOD_INFO_FILE`
			
			desp=`$XML_TOOL --xpath "$point/Description/text()" $CUR_FOD_INFO_FILE`
			echo "${id}:${desp}" >> $FOD_KEY_FILE
			# printf  "%-5s%-15s%-19s%-15s%-60s%-15s\n" "$i" "$type" "$id" "$status" "$desp" "$expireddate"
		done
	fi
	
	loadKeys
	
	return 0
}

function askCoutinue()
{
	msg=$1
	while [ true ]
	do
		read -p "$msg" ans  
		if [ "x$ans" == "xy" ] || [ "x$ans" == "xY" ];then	
			return 0
		elif [ "x$ans" == "xn" ] || [ "x$ans" == "xN" ];then
			return 1
		fi #while
	done
}

FodKeyFiles=""

function chooseAndrunFodFunc()
{
	Fod_key_choose=""
	
	runfun=$1
	showFodKey	
	count=$?
	if [ ${count} -gt 1 ];then
		echo ""
		while [ true ]
		do
			#read -p "* More than one FoD key be found,Enter your option ('a' to all | 'q' to quit):" option
			read -p "* Enter the number of the FoD key('a' to all,'q' to quit):" option
			if [ -z "$option" ];then
				continue
			elif [ "x$option" == "xq" ]||[ "x$option" == "xQ" ]; then
				return 1
			elif [ "x$option" == "xa" ]||[ "x$option" == "xA" ]; then
				canrun="y"
				if [ "$runfun" == "doUninstallFod" ];then
					askCoutinue "* Are you sure you want to delete all key? [Y/N]:"
					[ $? != 0 ]&& canrun="n"
				fi

				if [ "$canrun" == "y" ];then
					hasSuccess="n"
					allSuccess="y"
					for ((i=0; i<${#FOD_KEY_BUF[*]}; ++i ))
					do
						[ -z "${FOD_KEY_BUF[$i]}" ] && continue
						# [ -z "${FOD_DISP_BUF[$i]}" ] && continue
						Fod_key_num=$i
						Fod_key_choose=${FOD_KEY_BUF[$i]}
						#echo -e "$((i+1))\t${FOD_KEY_BUF[$i]}\t${FOD_DISP_BUF[$i]}"

						$runfun "all_blank"
						if [ $? == 0 ];then
							hasSuccess="y"
							FOD_RESULT_BUF[$i]="[Success]"
						else
							FOD_RESULT_BUF[$i]="[Failure]"
							allSuccess="n"
						fi
					done

					
					if [ "x$hasSuccess" == "xy" ] && [ "$runfun" == "doExport" ];then
						saveExportFile 
						
						[ $? != 0 ]&& FodKeyFiles=""&&continue
						FodKeyFiles=""
						
						echo -e "\rNo.\tKey ID\t\t\tFilename\t\t\t\tResult"
						count1=0
						for ((i=0; i<${#FOD_KEY_BUF[*]}; ++i ))
						do
							[ -z "${FOD_KEY_BUF[$i]}" ] && continue
							# [ -z "${FOD_DISP_BUF[$i]}" ] && continue
							
							let count1=count1+1
							if [ "${FOD_RESULT_BUF[$i]}"  == "[Success]" ];then
								echo -e "$count1\t${FOD_KEY_BUF[$i]}\t${FOD_INSTALLFILE_BUF[$i]}\t\t${FOD_RESULT_BUF[$i]}"
							else
								echo -e "$count1\t${FOD_KEY_BUF[$i]}\tN/A\t\t\t\t\t${FOD_RESULT_BUF[$i]}"
							fi
						done
						
					else

						echo -e "\rNo.\tKey ID\t\t\tResult"
						count1=0
						for ((i=0; i<${#FOD_KEY_BUF[*]}; ++i ))
						do
							[ -z "${FOD_KEY_BUF[$i]}" ] && continue
							# [ -z "${FOD_DISP_BUF[$i]}" ] && continue
							
							let count1=count1+1
							echo -e "$count1\t${FOD_KEY_BUF[$i]}\t${FOD_RESULT_BUF[$i]}"
						done
					fi	
					[ "x$allSuccess" == "xy" ] && echo "" && break
					

					
				fi
			elif [ $option -gt 0 ] 2>/dev/null && [ $option -le ${count} ]; then
			
				Fod_key_num=$(($option-1))
				Fod_key_choose=${FOD_KEY_BUF[$(($option-1))]}

				if [ "$runfun" == "doUninstallFod" ];then
					askCoutinue "* Are you sure you want to delete the key? [Y/N]:"
					if [ $? == 0 ];then
						$runfun "-"
					fi
				elif [ "$runfun" == "doExport" ];then 
					$runfun "blank"
					[ $? == 0 ]&& saveExportFile 
					FodKeyFiles=""
					#[ $? == 0 ] &&  echo "Fod key file has been saved in `echo "$FOD_KEY_DIR"|sed 's/\/toolscenter/<USB>/'`/." 
				else
					$runfun "-"
				fi

			else
				echo "Invalid option."	
			fi
		done
	elif [ $count == 0 ];then
		echo -e "\rNot found any FoD key."
		return 1
	else
		echo ""
		canrun="y"
		
		if [ "$runfun" == "doUninstallFod" ];then
			askCoutinue "* Are you sure you want to delete the key? [Y/N]:"
			if [ $? == 0 ];then
				$runfun "-"
			fi
		elif [ "$runfun" == "doExport" ];then 
			$runfun "blank"
			[ $? == 0 ]&& saveExportFile 
			FodKeyFiles=""
		else
			$runfun "-"
		fi
		
	fi
	
		
	
	return 0
}
# export FOD_KEY_DETAIL_INFO=""

function doExport()
{
	$Run "$SET_CMD" "$1" "$Fod_key_choose" "$FOD_KEY_DIR" "$cim_port" "$rest_port"
	ret=$?
	#$ONECLI_BIN fod export --keyid $Fod_key_choose --dir $FOD_KEY_DIR $ONECLI_ADD_OPTION --output $FOD_LOG_DIR" 
	if [ $ret == 0 ];then
		filename=`ls -t ${FOD_KEY_DIR}/ | head -n 1`
		newname="${CUR_MACHINE_TYPE}_${CUR_SN}_`date +%Y%m%d%H%M%S`.key"
		mv $FOD_KEY_DIR/$filename $FOD_KEY_DIR/$newname 
		FOD_INSTALLFILE_BUF[$Fod_key_num]=$newname
		#these for local
		#sed -i  "/^$Fod_key_choose.*/d" $FOD_SAVED_KEYFILE_INFO 1>/dev/null 2>&1
		#echo -e "$Fod_key_choose:${FOD_DISP_BUF[$Fod_key_num]}:$newname">>$FOD_SAVED_KEYFILE_INFO
		#this for remote
		FodKeyFiles=$FodKeyFiles","$newname
		# FOD_KEY_DETAIL_INFO=$FOD_KEY_DETAIL_INFO";"$Fod_key_choose:${FOD_DISP_BUF[$Fod_key_num]}:$filename
		#echo -e "The fod key has been saved in $FOD_KEY_DIR/$filename."
	fi
	return $ret
}

function saveExportFile()
{
	FodKeyFiles=`echo ${FodKeyFiles:1}`
	FOD_KEY_DETAIL_INFO=`echo ${FOD_KEY_DETAIL_INFO:1}`
	if echo $FodKeyFiles |grep "," 1>/dev/null 2>&1; then
		filespath="${FOD_KEY_DIR}/{$FodKeyFiles}"
	else
		filespath="${FOD_KEY_DIR}/$FodKeyFiles"
	fi
	# export FOD_KEY_DETAIL_INFO
	$EXSTORAGE save "$filespath"

}

function ExportFoDkeys()
{
	getFodKey
	[ $? != 0 ] && return 
	chooseAndrunFodFunc "doExport"
}

function doUninstallFod()
{
	$Run "$SET_CMD" "$1" "$Fod_key_choose" "$cim_port" "$rest_port"
	return $?
	#1 "$ONECLI_BIN fod uninstall --keyid $Fod_key_choose $ONECLI_ADD_OPTION --output $FOD_LOG_DIR"
}

function UninstallActiveFoDkeys()
{
	getFodKey
	[ $? != 0 ] && return 
	chooseAndrunFodFunc "doUninstallFod"
}


function InstallFoDkeys()
{
	#keyfiles=($(ls $FOD_KEY_DIR))
	#keyfiles=($(ls .))
	$EXSTORAGE "install" 
	[ $? != 0 ]&& return
	file=`cat $CHOOSE_FILE`
	read -p "Enter the REST port (empty for no change): " rest_port
	read -p "Enter the CIM port (empty for no change): " cim_port
	$Run "$SET_CMD" "-" "$file" "$cim_port" "$rest_port"
}



mkdir -p $FOD_KEY_DIR 1>/dev/null 2>/dev/null
mkdir -p ${FOD_LOG_DIR} 1>/dev/null 2>/dev/null
#echo "calling $1"
$1
