// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
var HttpProxy=function(){
	var proxyStatus = 0;
	var result_file = "";

	function initPageDescription() {
        $("#testStatus").html("");
    	$("#testStatus").val("");
        $("#testMsg").html("");
        $("#testMsg").val("");
	}
	
	function initURLCustom() {
		if (top.selectedOSMachineType.indexOf("ibm") != -1) {
            $("#URLCustomDiv").hide();
            document.getElementById("checkURLCustom").checked = false;
            showURLCustom();
		} else {
            $("#URLCustomDiv").show();
		}
	}
    
    function initResetUrlButton() {
        if (top.bCheckForLatest) {
            $("#resetLenovoUrlBtn").show();
            $("#resetIbmUrlBtn").hide();
            document.getElementById("testUrl").placeholder = "https://support.lenovo.com";
        } else {
            if (top.selectedOSMachineType.indexOf("ibm") != -1 &&
                (top.selectedOSMachineType.indexOf("x") != -1 ||
                top.selectedOSMachineType.indexOf("purley") != -1)) {
                    $("#resetLenovoUrlBtn").show();
                    $("#resetIbmUrlBtn").show();
                    document.getElementById("testUrl").placeholder = "https://support.lenovo.com";
            } else {
                if (top.selectedOSMachineType.indexOf("ibm") != -1) {
                    $("#resetLenovoUrlBtn").hide();
                    $("#resetIbmUrlBtn").show();
                    document.getElementById("testUrl").placeholder = "https://www-03.ibm.com";
                } else if (top.selectedOSMachineType.indexOf("x") != -1 ||
                    top.selectedOSMachineType.indexOf("purley") != -1) {
                        $("#resetLenovoUrlBtn").show();
                        $("#resetIbmUrlBtn").hide();
                        document.getElementById("testUrl").placeholder = "https://support.lenovo.com";
                }
            }
        }
    }

	function initProxy() {
        // document.getElementById("proxy").checked = false;
        // enableProxy();
        // document.getElementById("checkAccount").checked = false;
        // showAccount();
        // document.getElementById("checkProxyCustom").checked = false;
        // showProxyCustom();
		// $("#proxyTable").hide();
		top.proxyType = "http";
		
		document.getElementById("ProxyType").options.length=0;
		document.getElementById("ProxyType").options.add(new Option("HTTP", "HTTP"));
		if (top.selectedOSMachineType.indexOf("ibm") == -1) {
			document.getElementById("ProxyType").options.add(new Option("HTTPS", "HTTPS"));
		}
        document.getElementById("ProxyType").options.add(new Option("SOCKS4", "SOCKS4"));
        document.getElementById("ProxyType").options.add(new Option("SOCKS4a", "SOCKS4a"));
        document.getElementById("ProxyType").options.add(new Option("SOCKS5", "SOCKS5"));
        document.getElementById("ProxyType").options.add(new Option("SOCKS5h", "SOCKS5h"));
        
        if(document.getElementById("checkProxySkipCertificate").checked) showProxySpecifyCertificate(0);
        else if(document.getElementById("checkProxySkipCertificate").checked) showProxySpecifyCertificate(1);

        if(document.getElementById("checkURLSkipCertificate").checked) showURLSpecifyCertificate(0);
        else if(document.getElementById("checkURLSpecifyCertificate").checked) showURLSpecifyCertificate(1);
	}
	
    function checkNetworkInfo() {
        if (!checkURLCustomCaCertFile()) {
            return false;
        }
        if (!checkProxy()) {
            return false;
        }

        return true;
    }

    function checkURLCustomCaCertFile() {
        if ($("#checkURLCustom").prop("checked") && $("#checkURLSpecifyCertificate").prop("checked")) {
            top.urlCustomCaCertFile = $('#URLCertFile').val();
            if (top.urlCustomCaCertFile == "" || top.urlCustomCaCertFile == null || top.urlCustomCaCertFile == undefined) {
                alert("Please input the CA certificate file for proxy. ");
                setTimeout(function(){$('#URLCertFile').focus()}, 1);
                return false;
            } else {
                if (!checkCaCertPemFileExist(top.urlCustomCaCertFile)) {
                    alert("The CA certificate file for proxy is invalid. ");
                    setTimeout(function(){$('#URLCertFile').focus()}, 1);
                    return false;
                }
            }
        } else {
            top.urlCustomCaCertFile = "";
        }

        if ($("#URLCustomDiv").is(':visible') == false) {
            top.url_custom = false;
        }

        return true;
    }

    function checkCaCertPemFileExist(file) {
        if (top.fileExists(file) && file.lastIndexOf(".pem") == file.length-4) {
            return true;
        } else {
            return false;
        }
    }

	function checkProxy() {
		if ($("#proxy").prop("checked")) {
			var ret = checkProxyInput();
			if (ret == 'add_empty') {
                alert("Please input host name. ");
                $('#pAdd').focus();
                setTimeout(function(){$('#pAdd').focus()}, 1);
                return false;
            }
            if (ret == 'invalid_add') {
                alert("The host name is invalid. ");
                $('#pAdd').focus();
                setTimeout(function(){$('#pAdd').focus()}, 1);
                return false;
            }
            if (ret == 'port_empty') {
                alert("Please input port. ");
                $('#pPort').focus();
                setTimeout(function(){$('#pPort').focus()}, 1);
                return false;
            }
            if (ret == 'invalid_port') {
                alert("The port is invalid. ");
                $('#pPort').focus();
                setTimeout(function(){$('#pPort').focus()}, 1);
                return false;
            }
            if (ret == 'user_empty') {
                alert("Please input user name. ");
                $('#pUid').focus();
                setTimeout(function(){$('#pUid').focus()}, 1);
                return false;
			}
            if (ret == 'pwd_empty') {
                alert("Please input password. ");
                $('#pPwd').focus();
                setTimeout(function(){$('#pPwd').focus()}, 1);
                return false;
            }
            if (ret == 'proxy_ca_cert_file_empty') {
                alert("Please input the CA certificate file for proxy. ");
                $('#proxyCaCertFile').focus();
                setTimeout(function(){$('#proxyCaCertFile').focus()}, 1);
                return false;
            }
            if (ret == 'invalid_proxy_ca_cert_file') {
                alert("The CA certificate file for proxy is invalid. ");
                $('#proxyCaCertFile').focus();
                setTimeout(function(){$('#proxyCaCertFile').focus()}, 1);
                return false;
            }
            if (ret == 'url_ca_cert_file_empty') {
                alert("Please input the CA certificate file for URL. ");
                $('#URLCertFile').focus();
                setTimeout(function(){$('#URLCertFile').focus()}, 1);
                return false;
            }
            if (ret == 'invalid_url_ca_cert_file') {
                alert("The CA certificate file for URL is invalid. ");
                $('#URLCertFile').focus();
                setTimeout(function(){$('#URLCertFile').focus()}, 1);
                return false;
            }
            // fix defect 198284 - [2020/3/18 brondan]
            top.proxyAdd = $('#pAdd').val();
            top.proxyPort = $('#pPort').val();
            if ($("#checkAccount").prop("checked")) {
                top.proxyUid = $('#pUid').val();
                top.proxyPwd = $('#pPwd').val();
            } else {
                top.proxyUid = "";
                top.proxyPwd = "";
            }
            if ($("#checkProxyCustom").prop("checked")) {
                top.proxyCaCertFile = $('#proxyCaCertFile').val();
            } else {
                top.proxyCaCertFile = "";
            }
            if ($("#proxyCustomDiv").is(':visible') == false) {
                top.proxy_custom = false;
            }
        } else {
            // fix defect 198287 - [2020/3/18 brondan]
            top.proxyAdd = "";
            top.proxyPort = "";
            top.proxyUid = "";
            top.proxyPwd = "";
            top.proxyCaCertFile = "";
        }
		return true;
	}

	function disAllInput() {
		disTestBtn();
		$("#testUrl").attr("disabled", true);
        $("#proxy").attr("disabled", true);
        $("#ProxyType").attr("disabled", true);
		$("#pAdd").attr("disabled", true);
        $("#pPort").attr("disabled", true);
        
		$("#checkAccount").attr("disabled", true);
		$("#pUid").attr("disabled", true);
        $("#pPwd").attr("disabled", true);

        $("#checkProxyCustom").attr("disabled", true);
        $("#checkProxySkipCertificate").attr("disabled", true);
        $("#checkProxySpecifyCertificate").attr("disabled", true);
        $("#proxyCaCertFile").attr("disabled", true);
        $("#proxyCaCertFileBtn").attr("disabled", true);

        $("#checkURLCustom").attr("disabled", true);
        $("#checkURLSkipCertificate").attr("disabled", true);
        $("#checkURLSpecifyCertificate").attr("disabled", true);

        $("#URLCertFile").attr("disabled", true);
        $("#URLCertFileBtn").attr("disabled", true);
	}

	function enableAllInput() {
		enableTestBtn();
		$("#testUrl").attr("disabled", false);
        $("#proxy").attr("disabled", false);
        $("#ProxyType").attr("disabled", false);
		$("#pAdd").attr("disabled", false);
        $("#pPort").attr("disabled", false);

		$("#checkAccount").attr("disabled", false);
		$("#pUid").attr("disabled", false);
        $("#pPwd").attr("disabled", false);

        $("#checkProxyCustom").attr("disabled", false);
        $("#checkProxySkipCertificate").attr("disabled", false);
        $("#checkProxySpecifyCertificate").attr("disabled", false);
        $("#proxyCaCertFile").attr("disabled", false);
        $("#proxyCaCertFileBtn").attr("disabled", false);

        $("#checkURLCustom").attr("disabled", false);
        $("#checkURLSkipCertificate").attr("disabled", false);
        $("#checkURLSpecifyCertificate").attr("disabled", false);
        $("#URLCertFile").attr("disabled", false);

        $("#URLCertFile").attr("disabled", false);
        $("#URLCertFileBtn").attr("disabled", false);
	}

	function SelectProxyType(proxy_type)
	{
        $("#proxyCustomDiv").hide();
        $("#URLCustomDiv").hide();

        if (top.selectedOSMachineType.indexOf("ibm") == -1) {
            switch (proxy_type)
            {
                case "HTTP":
                    top.proxyType = "http";
                    $("#URLCustomDiv").show();
                    showURLCustom();
                    break;
                case "HTTPS":
                    top.proxyType = "https";
                    $("#proxyCustomDiv").show();
                    showProxyCustom();
                    $("#URLCustomDiv").show();
                    showURLCustom();
                    break;
                case "SOCKS4":
                    top.proxyType = "socks4";
                    $("#URLCustomDiv").show();
                    showURLCustom();
                    break;
                case "SOCKS4a":
                    top.proxyType = "socks4a";
                    break;
                case "SOCKS5":
                    top.proxyType = "socks5";
                    $("#URLCustomDiv").show();
                    showURLCustom();
                    break;
                case "SOCKS5h":
                    top.proxyType = "socks5h";
                    break;
                default:
                    top.proxyType = "http";
                    break;
            }
        } else {
            switch (proxy_type)
            {
                case "HTTP":
                    top.proxyType = "http";
                    break;
                case "HTTPS":
                    top.proxyType = "https";
                    $("#proxyCustomDiv").show();
                    showProxyCustom();
                    break;
                case "SOCKS4":
                    top.proxyType = "socks4";
                    break;
                case "SOCKS4a":
                    top.proxyType = "socks4a";
                    break;
                case "SOCKS5":
                    top.proxyType = "socks5";
                    break;
                case "SOCKS5h":
                    top.proxyType = "socks5h";
                    break;
                default:
                    top.proxyType = "http";
                    break;
            }
        }
	}

	function enableProxy() {
		if ($("#proxy").prop("checked")) {
            top.useProxy = true;
			$("#proxyTable").show();
		} else {
            top.useProxy = false;
            $("#proxyTable").hide();
		}
	}

	function setProxy(obj) {
        if (obj.id == "pAdd") {
            obj.value = $.trim(obj.value);
            top.proxyAdd = obj.value;
        } else if (obj.id == "pPort") {
            obj.value = $.trim(obj.value);
            top.proxyPort = obj.value;
        } else if (obj.id == "pUid") {
            obj.value = $.trim(obj.value);
            top.proxyUid = obj.value;
        } else if (obj.id == "pPwd") {
            obj.value = $.trim(obj.value);
            top.proxyPwd = obj.value; 
        } else if (obj.id == "proxyCaCertFile") {
            obj.value = $.trim(obj.value);
            top.proxyCaCertFile = obj.value; 
        } else if (obj.id == "URLCertFile") {
            obj.value = $.trim(obj.value);
            top.urlCustomCaCertFile = obj.value; 
        }
    }

    function showAccount() {
    	if ($("#checkAccount").prop("checked")) {
    		top.useProxyAuth = true;
    		$("#ProxyAcountTable").show();
    	} else {
    		top.useProxyAuth = false;
    		$("#ProxyAcountTable").hide();
    	}
    }

	function updateProxyConfig() {
		if(top.configTag["IBM_SYSTEM_PROXY_ADDRESS"] == "1" && top.configTag["IBM_SYSTEM_PROXY_PORT"] == "1") {
			if (top.useProxy) {
	        	$("#proxy").attr("checked", true);
	        	$("#proxyTable").show();
	        	if (top.proxyAdd != null && top.proxyAdd != "" && top.proxyAdd != undefined) {
	        		$("#pAdd").html(top.proxyAdd);
	        		$("#pAdd").val(top.proxyAdd);
	        		top.configTag["IBM_SYSTEM_PROXY_ADDRESS"] = "";
	        	}
	        	if (top.proxyPort != "" && top.proxyPort != null && top.proxyPort != undefined) {
	        		$("#pPort").html(top.proxyPort);
	        		$("#pPort").val(top.proxyPort);
	        		top.configTag["IBM_SYSTEM_PROXY_PORT"] = "";
	        	}
	        	if (top.useProxyAuth) {
	        		$("#checkAccount").attr("checked", true);
	        		$("#ProxyAcountTable").show();
	        		if (top.proxyUid != "" && top.proxyUid != null && top.proxyUid != undefined) {
	        			$("#pUid").html(top.proxyUid);
	        			$("#pUid").val(top.proxyUid);
	        			top.configTag["IBM_SYSTEM_PROXY_USER"] = "";
	        		}
	        		$("#pPwd").html("");
	        		$("#pPwd").val("");
                }
                if (top.proxy_specify_cert) {
	        		$("#checkProxySpecifyCertificate").attr("checked", true);
	        		$("#ProxySpecifyCertificateTable").show();
	        		if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null && top.proxyCaCertFile != undefined) {
	        			$("#proxyCaCproxyCaCertFileertFile").html(top.proxyCaCertFile);
	        			$("#proxyCaCproxyCaCertFileertFile").val(top.proxyCaCertFile);
	        			top.configTag["IBM_SYSTEM_PROXY_CA_CERT_FILE"] = "";
	        		}
	        		$("#proxyCaCproxyCaCertFileertFile").html("");
	        		$("#proxyCaCproxyCaCertFileertFile").val("");
	        	}
	        }
		} else {
			setDefault();
		}
	}

	function setDefault() {
		$("#testUrl").html("");
        $("#testUrl").val("");
        $("#proxy").attr("checked", false);
		$("#proxyTable").hide();

		top.useProxy = false;
        top.useProxyAuth = false;
        top.useURLCustomCaCertFile = false;
        top.proxy_specify_cert = false;
		top.proxyAdd = "";
		top.proxyPort = "";
		top.proxyUid = "";
        top.proxyPwd = "";
        top.urlCustomCaCertFile = "";
        top.proxyCaCertFile = "";
	}

	function checkHostName(hostName) {
        var expHostName = /((^\s*((([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))\s*$)|(^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$))|(^\s*((?=.{1,255}$)(?=.*[A-Za-z].*)[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|\b-){0,61}[0-9A-Za-z])?)*)\s*$)/;
        var flag = expHostName.test(hostName);
        if (flag) return true;
        else return false;
    }

    function TestConnection() {
    	$("#testStatus").html("");
    	$("#testStatus").val("");
    	$("#testMsg").html("");
    	$("#testMsg").val("");
    	DisplayInnerText("InfoText", "");
    	$("#statusImg").empty();
    	disAllInput();
    	top.togglePrevious(false);
    	top.toggleNext(false);

        var retCode = "";
        if (top.url_custom && top.url_specify_cert) {
            top.urlCustomCaCertFile = $('#URLCertFile').val();
            if (top.urlCustomCaCertFile == "" || top.urlCustomCaCertFile == null || top.urlCustomCaCertFile == undefined) {
                $('#URLCertFile').focus();
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('InfoText', "Please input the additional CA certificate file. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#URLCertFile').focus();
                return;  
            } else {
                if (!checkCaCertPemFileExist(top.urlCustomCaCertFile)) {
                    $('#URLCertFile').focus();
                    $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                    DisplayInnerText('InfoText', "The additional CA certificate file is invalid. ");
                    togglePrevious(true);
                    toggleNext(true);
                    enableAllInput();
                    $('#URLCertFile').focus();
                    return;
                }                
            }

        } else {
            top.urlCustomCaCertFile = "";
        }
    
        if (top.useProxy) {
            retCode = checkProxyInput();
            if (retCode == 'add_empty') {
                // missing hostname
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('InfoText', "Please input host name. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#pAdd').focus();
                return;
            }
            if (retCode == 'invalid_add') {
                // proxy addr has wrong format
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "The host name is invalid. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#pAdd').focus();
                return;
            }
            if (retCode == 'port_empty') {
                //  missing proxy port
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "Please input port. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#pPort').focus();
                return;
            }
            if (retCode == 'invalid_port') {
                // proxy port is invalid
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "The port is invalid. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#pPort').focus();
                return;
            }
            if (retCode == 'user_empty') {
                // username is empty
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "Please input user name. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#pUid').focus();
                return;
			}
            if (retCode == 'pwd_empty') {
                // password is empty
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "Please input password. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#pPwd').focus();
                return;
            }
            if (retCode == 'proxy_ca_cert_file_empty') {
                // CA certificate file for proxy is incorrect
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "Please input the CA certificate file for proxy. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#proxyCaCertFile').focus();
                return;
            }
            if (retCode == 'invalid_proxy_ca_cert_file') {
                // CA certificate file for proxy is incorrect
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "The CA certificate file for proxy is invalid. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                $('#proxyCaCertFile').focus();
                return;
            }
            // fix defect 198284 - [2020/3/18 brondan]
            top.proxyAdd = $('#pAdd').val();
            top.proxyPort = $('#pPort').val();
            if ($("#checkAccount").prop("checked")) {
                top.proxyUid = $('#pUid').val();
                top.proxyPwd = $('#pPwd').val();
            } else {
                top.proxyUid = "";
                top.proxyPwd = "";
            }
            if ($("#checkAccount").prop("checked")) {
                top.proxyUid = $('#pUid').val();
                top.proxyPwd = $('#pPwd').val();
            } else {
                top.proxyUid = "";
                top.proxyPwd = "";
            }

            if ($("#proxyCustomDiv").is(':visible') && top.proxy_custom && top.proxy_specify_cert) {
                top.proxyCaCertFile = $('#proxyCaCertFile').val();
            } else {
                top.proxyCaCertFile = "";
            }
        } else {
            // fix defect 198287 - [2020/3/18 brondan]
            top.proxyAdd = "";
            top.proxyPort = "";
            top.proxyUid = "";
            top.proxyPwd = "";
            top.proxyCaCertFile = "";
        }

        if (!top.defaultUrl) {
            retCode = checkUrlInput();
            if (retCode == "url_empty") {
                // url is empty
                $("#statusImg").html("<img src=\"images/statusCritical.gif\" alt=\"Critical Error\">");
                DisplayInnerText('Proxy_InfoText', "Please input URL for testing. ");
                togglePrevious(true);
                toggleNext(true);
                enableAllInput();
                return;
            }
        }

        result_file = top.gl_ibm_support + top.getOSCommand("connResultFile");
        if (top.fileExists(result_file)) {
        	top.deleteFile(result_file);
        }
        var args = new Array();
        if (top.OSTYPE == "windows") {
        	args.push(top.workingdir + "\\" + getOSCommand("testConn"));
        } else {
        	args.push(top.workingdir + "/" + getOSCommand("testConn"));
        }

        if ($("#URLCustomDiv").is(':visible') && top.url_custom) {
            if (top.url_insecure) {
                args.push("--insecure");
            } else if (top.url_specify_cert) {
                if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
                    args.push("--cacert");
                    args.push(top.urlCustomCaCertFile); 
                }
            }
        }

        if (top.useProxy) {
            if ($("#proxyCustomDiv").is(':visible') && top.proxy_custom) {
                if (top.proxy_insecure) {
                    args.push("--proxy-insecure");
                } else if (top.proxy_specify_cert) {
                    if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
                        args.push("--proxy-cacert");
                        args.push(top.proxyCaCertFile); 
                    }
                }
            }

            args.push("--proxy");
            var is_ipv6 = top.proxyAdd.match(ipv6_pattern);
            if (is_ipv6 != null) {
                proxy_uri = "[" + top.proxyAdd + "]" + ":" + top.proxyPort;
            } else {
                proxy_uri = top.proxyAdd + ":" + top.proxyPort;
            }
            if (top.useProxyAuth) {
                proxy_auth = top.proxyUid
                if (top.proxyPwd != "" && top.proxyPwd != null && top.proxyPwd != undefined) {
                    proxy_auth = proxy_auth + ":" + top.proxyPwd;
                }
                proxy_uri = proxy_auth + "@" + proxy_uri;
            }
            if (top.proxyType == "https" ||
                top.proxyType == "socks4" ||
                top.proxyType == "socks4a" ||
                top.proxyType == "socks5" ||
                top.proxyType == "socks5h") {
                proxy_uri = top.proxyType + "://" + proxy_uri;
            }
            args.push(proxy_uri); 
        }
        
        setUrl();
        if (top.userInputUrl != "") {
            if (top.userInputUrl == top.default_lenovo_url) {
                args.push("--testlenovo");
            } else if (top.userInputUrl == top.default_ibm_url) {
                args.push("--testibm");
            } else {
                if (top.userInputUrl.toLowerCase().indexOf("http://") != 0 &&
                    top.userInputUrl.toLowerCase().indexOf("https://") != 0 &&
                    top.userInputUrl.toLowerCase().indexOf("socks4://") != 0 &&
                    top.userInputUrl.toLowerCase().indexOf("socks4a://") != 0 &&
                    top.userInputUrl.toLowerCase().indexOf("socks5://") != 0 &&
                    top.userInputUrl.toLowerCase().indexOf("socks5h://") != 0) {
                    top.userInputUrl = "http://" + top.userInputUrl;
                }
                args.push("--url");
                args.push(top.userInputUrl);
            }
        } else {
            if (top.bCheckForLatest) {
                args.push("--testlenovo");
            } else {
                if (top.selectedOSMachineType.indexOf("ibm") != -1 &&
                    (top.selectedOSMachineType.indexOf("x") != -1 ||
                    top.selectedOSMachineType.indexOf("purley") != -1)) {
                    args.push("--testboth");
                } else {
                    if (top.selectedOSMachineType.indexOf("ibm") != -1) {
                        args.push("--testibm");
                    } else if (top.selectedOSMachineType.indexOf("x") != -1 ||
                        top.selectedOSMachineType.indexOf("purley") != -1) {
                        args.push("--testlenovo");
                    }
                }
            }
        }

        args.push("--file");
        args.push(result_file);

        updateStatusImg("<img src=\"images/progressing.gif\" alt=\"Progressing\">");
	    DisplayInnerText("InfoText", "Testing the connection to the fix service provider...");

        secureRunProgram(null, args, BACKGROUND, HIDDEN, null, testConnCb);
    }

    function testConnCb() {
       	var retMsg = parseTestResult();
       	retMsg = retMsg.trim();
       	if (retMsg == "" || retMsg == null || retMsg == undefined) {
            retMsg = "Unknown error";
        }
        if (retMsg.toLowerCase() == "success." || retMsg.toLowerCase() == "succeed.") {
        	if (defaultUrl) {
        		$("#testStatus").html("<img src=\"images/statusSuccess.gif\" alt=\"Success\">");
                $("#testMsg").html(retMsg);
        	} else {
        		$("#testStatus").html("<img src=\"images/statusSuccess.gif\" alt=\"Success\">");
                $("#testMsg").html(retMsg);
        	} 
        } else {
        	if (defaultUrl) {
        		$("#testStatus").html("<img src=\"images/statusCritical.gif\" alt=\"Success\">");
                $("#testMsg").html(retMsg);
        	} else {
        		$("#testStatus").html("<img src=\"images/statusCritical.gif\" alt=\"Success\">");
                $("#testMsg").html(retMsg);
        	}
        }
        top.togglePrevious(true);
       	top.toggleNext(true);
       	DisplayInnerText("InfoText", "");
       	$("#statusImg").empty();
       	enableAllInput();
    }

    function disTestBtn() {
    	$("#buttonTest").attr("disabled", true);
    	$("#buttonTest").css("color", "grey");
    }

    function enableTestBtn() {
    	$("#buttonTest").attr("disabled", false);
    	$("#buttonTest").css("color", "black");
    }

	function updateStatusImg(imgSrc) {
	    top.proxyStatusImg = imgSrc;
	    // document.all("statusImg").innerHTML = imgSrc;
	    $("#statusImg").html(imgSrc);
	}

	function checkProxyInput() {
        // return
        // add_empty
        // invalid_add
        // port_empty
        // invalid_port
        // user_empty
        // success
        var proxy_add = $('#pAdd').val();
        if (proxy_add == '' || proxy_add == null || proxy_add == undefined) {
            $('#pAdd').focus();
            return 'add_empty';
        }
        if (!checkHostName(proxy_add)) {
            $('#pAdd').focus();
            return 'invalid_add';
        }
        var proxy_port = $('#pPort').val();
        if (proxy_port == '' || proxy_port == null || proxy_port == undefined) {
            $('#pPort').focus();
            return 'port_empty';
        }
        if (isNaN(proxy_port) || proxy_port < 1 || proxy_port > 65535) {
            $('#pPort').focus();
            return 'invalid_port';
        }
        if ($('#checkAccount').prop('checked')) {
            var proxy_user = $('#pUid').val();
            if (proxy_user == '' || proxy_user == null || proxy_user == undefined) {
                $('#pUid').focus();
                return 'user_empty';
            }

            var proxy_pwd = $('#pPwd').val();
            if (proxy_pwd == '' || proxy_pwd == null || proxy_pwd == undefined) {
                $('#pPwd').focus();
                return 'pwd_empty';
            }
        }
        if ($("#proxyCustomDiv").is(':visible') && top.proxy_custom && proxy_specify_cert) {
            top.proxyCaCertFile = $('#proxyCaCertFile').val();
            if (top.proxyCaCertFile == '' || top.proxyCaCertFile == null || top.proxyCaCertFile == undefined) {
                $('#proxyCaCertFile').focus();
                return 'proxy_ca_cert_file_empty';
            } else {
                if (!checkCaCertPemFileExist(top.proxyCaCertFile)) {
                    $('#proxyCaCertFile').focus();
                    return 'invalid_proxy_ca_cert_file';
                }
            }
        }
        if (top.url_custom && url_specify_cert) {
            top.urlCustomCaCertFile = $('#URLCertFile').val();
            if (top.urlCustomCaCertFile == '' || top.urlCustomCaCertFile == null || top.urlCustomCaCertFile == undefined) {
                $('#URLCertFile').focus();
                return 'url_ca_cert_file_empty';
            } else {
                if (!checkCaCertPemFileExist(top.urlCustomCaCertFile)) {
                    $('#URLCertFile').focus();
                    return 'invalid_url_ca_cert_file';
                }
            }
        }

        return 'success';
    }

    function checkUrlInput() {
        // return
        // url_empty
        // success
        var test_url = $("#testUrl").val();
        if (test_url == "" || test_url == null || test_url == undefined) {
            $("#testUrl").focus();
            return "url_empty";
        }
        return "success";
    }

	function parseTestResult() {
		var fileLines;
        try {
            fileLines = top.readTextFile(result_file);
        } catch(e) {
            return "Unknown error";
        }
        if (fileLines == "" || fileLines == null || fileLines == undefined) {
            return "Unknown error";
        } 
        return fileLines;
	}

	function DisplayInnerText(pTagName, textVal) {
	    if (pTagName = "InfoText") {
			top.proxyCheckResult = textVal;
		}
		if (top.OSTYPE == "windows") {
			//document.all(pTagName).innerText = textVal;
			// $("#"+pTagName).innerText = textVal;
		} else {
			//document.all(pTagName).innerHTML = textVal;
			// $("#"+pTagName).innerHTML = textVal;
		}
		$("#"+pTagName).html(textVal);
	}

	function setTestUrl(val) {
		if (val == 0) {
			top.defaultUrl = true;
			$("#testUrl").attr("disabled", true);
		} else if (val == 1) {
			top.defaultUrl = false;
			$("#testUrl").attr("disabled", false);
		}
	}

	function setUrl() {
        if ($("#testUrl").val() == "") {
            top.userInputUrl = document.getElementById("testUrl").placeholder;
        } else {
            top.userInputUrl = $("#testUrl").val();
        }
	}

    function showProxyCustom() {
        var check = document.getElementById("checkProxyCustom").checked;
        check?$("#checkProxyCustomDiv").show():$("#checkProxyCustomDiv").hide();
        top.proxy_custom = check;
    }

    function showProxySpecifyCertificate(val) {
        if (val == 0) {
            $("#ProxySpecifyCertificateTable").hide();
            top.proxy_specify_cert = false;
            top.proxy_insecure = true;
        } else if (val == 1) {
            $("#ProxySpecifyCertificateTable").show()
            top.proxy_specify_cert = true;
            top.proxy_insecure = false;
        }
    }

    function openProxyCertDir() {
        openFileDirectory("proxyCaCertFile", getProxyCertDir, 
		[{ name: 'File Type', extensions: ['pem'] }]);
    }

    function getProxyCertDir(path){
        var cert=path;
        if(cert!=null && cert!=""){
            $("#proxyCaCertFile").val(cert);
            top.proxyCaCertFile = cert;
        }
    }

    function openURLCertDir() {
        openFileDirectory("URLCertFile", getURLCertDir, 
		[{ name: 'File Type', extensions: ['pem'] }]);
    }

    function getURLCertDir(path){
        var cert=path;
        if(cert!=null && cert!=""){
            $("#URLCertFile").val(cert);
            top.gl_url_cert = cert;
        }
    }

    function showURLCustom() {
        var check = document.getElementById("checkURLCustom").checked;
        check?$("#checkURLCustomDiv").show():$("#checkURLCustomDiv").hide();
        top.url_custom = check;
    }

    function showURLSpecifyCertificate(val) {
        if (val == 0) {

            $("#URLSpecifyCertificateTable").hide();
            top.url_specify_cert = false;
            top.url_insecure = true;
        } else if (val == 1) {

            $("#URLSpecifyCertificateTable").show()
            top.url_specify_cert = true;
            top.url_insecure = false;
        }
    }

    function resetUrl(value) {
        if (value == 0) {
            document.getElementById("testUrl").value = top.default_lenovo_url;
        } else if (value == 1) {
            document.getElementById("testUrl").value = top.default_ibm_url;
        }
    }

	return{
		name: "Proxy",
        // init: updateProxyConfig, 
        init: function () {
            initPageDescription();
            initResetUrlButton();
			initURLCustom();
            initProxy();
            SelectProxyType("HTTP");
            showProxyCustom();
            showURLCustom();
            showURLSpecifyCertificate();

        	if (!top.proxyInit) {
        		updateProxyConfig();
        		top.proxyInit = true;
        	}
        },
        nextAction: checkNetworkInfo,
        setTestUrl: setTestUrl,
        setUrl: setUrl,
        SelectProxyType: SelectProxyType,
        enableProxy: enableProxy,
        setProxy: setProxy,
        showProxyCustom: showProxyCustom,
        showProxySpecifyCertificate: showProxySpecifyCertificate,
        showURLSpecifyCertificate: showURLSpecifyCertificate,
        showAccount: showAccount,
        showURLCustom: showURLCustom,
        openProxyCertDir: openProxyCertDir,
        openURLCertDir: openURLCertDir,
        resetUrl: resetUrl,
        getURLCertDir: getURLCertDir,
        getProxyCertDir: getProxyCertDir,
        TestConnection: TestConnection,
        title: "Network Access",
        content: loadContent("menu_Proxy.html"),
	}
}();
