// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

var gl_wizard = null;
var gl_wizard_steps = null;
var Welcome = null;
var Acquire_Location = null;
var HttpProxy = null;
var MediaPurpose = null;
var Load_Configuration = null;
var SupportedSystems = null;
var SaveConfiguration = null;
var ObtainLatestVersion = null;
var TargetDirectory = null;
var CreateMedia = null;
var UnattendedConfiguration = null;
var UpdateSelection = null;
var Progress = null;
var Finish = null;
var gl_steps_current = [];

function enableButton(button_id, enable) {
    //top.logEnter("enableButton", arguments);
    enable = isStringTrue(enable);
    var button = top.root.footer.document.getElementById(button_id);
    button.disabled = !enable;
}

function isStringTrue(string) {
    if (string == true) return true;
    if (string == false) return false;
    if (typeof string == "string" && string.toUpperCase() == "TRUE") return true;
    return false;
}

function configSteps(newSteps) {
    console.log("configSteps");
    for (var i = 0; i < newSteps.length; i++) {
        if (!newSteps[i]) {
            alert("Some steps are null: " + i);
            return;
        }
        var stepFound = false;
        for (var j = i; j < gl_wizard_steps.length; j++) {
            if (gl_wizard_steps[j].name == newSteps[i].name) {
                stepFound = true;
                if (j > i) {
                    for (var x = i; x < j; x++) {
                        if (gl_wizard_steps[i].onRemove) {
                            gl_wizard_steps[i].onRemove();
                        }
                        gl_wizard.steps('remove', i);
                    }
                    gl_wizard_steps.splice(i, (j - i));
                } //else j==i
                break;
            }
        }
        if (!stepFound) {
            gl_wizard.steps("insert", i, {
                title: newSteps[i].title,
                content: newSteps[i].content
            });
            gl_wizard_steps.splice(i, 0, newSteps[i]);
            $("[role='tab']").children("a").attr("tabindex","-1");
            $("[role='tab']").children("a").attr("style","pointer-events:none;");
        }
    }
    if (gl_wizard_steps.length > newSteps.length) {
        for (var i = newSteps.length; i < gl_wizard_steps.length; i++) {
            if (gl_wizard_steps[i].onRemove) {
                gl_wizard_steps[i].onRemove();
            }
            gl_wizard.steps('remove', newSteps.length);
        }
    }
    gl_wizard_steps = newSteps.concat();
    gl_steps_current = gl_wizard_steps.concat();
    removeDoneStepClass();
}

function removeDoneStepClass(cIndex) {
    if (!cIndex) {
        var cIndex = -1;
        $("#navigationbar-vertical").find("li").each(function (i, n) {
            var $this = $(this);
            if ($this.hasClass("current")) {
                cIndex = i;
                return true;
            }
            if (cIndex > -1 && i > cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    } else {
        $("#navigationbar-vertical").find("li").each(function (i, n) {
            var $this = $(this);
            if (i > cIndex && $this.hasClass("done"))
                $this.removeClass("done").addClass("disabled");
        });
    }

}

function goNextStep() {
    $("#navigationbar-vertical").steps("next");
}

function InitWizard() {
    // only default steps need add to this list.
    gl_wizard_steps = [Welcome, SupportedSystems, MediaPurpose, Acquire_Location, HttpProxy, TargetDirectory, CreateMedia, UnattendedConfiguration, SaveConfiguration, UpdateSelection, Progress, Finish];

    console.log("Start to init wizard...");
    for (let i = 0; i < gl_wizard_steps.length; i++) {
        try {
            console.log("Start to add step: " + gl_wizard_steps[i].title);

            let elTitle = document.createElement('h3');
            elTitle.innerHTML = gl_wizard_steps[i].title
            document.querySelector('#navigationbar-vertical').appendChild(elTitle);

            let elSelection = document.createElement('section');
            elSelection.innerHTML = gl_wizard_steps[i].content
            document.querySelector('#navigationbar-vertical').appendChild(elSelection);
        } catch (error) {
            console.log(error)
        }
    }

    gl_steps_current = gl_wizard_steps.concat();

    gl_wizard = $("#navigationbar-vertical").steps({
        headerTag: "h3",
        bodyTag: "section",
        transitionEffect: "slideLeft",
        stepsOrientation: "vertical",
        onInit: function (event, currentIndex) {
            console.log("common_init.");
            common_init();
            $("[role='tab']").children("a").attr("tabindex", "-1");
            $("[role='tab']").children("a").attr("style", "pointer-events:none;");
            console.log("success on init.");
        },
        onStepChanging: function (event, currentIndex, newIndex) {
            // Always allow going backward even if the current step contains invalid fields!
            if (currentIndex > newIndex) {
                if (gl_wizard_steps[currentIndex].previousAction) {
                    gl_wizard_steps[currentIndex].previousAction();
                }
                return true;
            }

            if (currentIndex < newIndex) {
                var act_next = gl_wizard_steps[currentIndex].nextAction();
                if (act_next == true
                    && gl_wizard_steps[newIndex] != Finish) {
                    togglePrevious(false);
                    toggleNext(false);
                }
                return act_next;
            }
        },
        onContentLoaded: function (event, currentIndex) {
            console.log("step " + currentIndex + " loaded" + event);
        },
        onStepChanged: function (event, currentIndex, priorIndex) {
            console.log("step changed");
            removeDoneStepClass(currentIndex);
            if (gl_wizard_steps[currentIndex] != UpdateSelection
                && gl_wizard_steps[currentIndex] != Progress
                && gl_wizard_steps[currentIndex] != Finish) {
                togglePrevious(true);
                toggleNext(true);
            }
            if (currentIndex > priorIndex) {
                gl_wizard_steps[currentIndex].init();
            } else if (gl_wizard_steps[currentIndex].needReInit) {
                gl_wizard_steps[currentIndex].init();
            } else if (gl_wizard_steps[currentIndex].backEntry) {
                gl_wizard_steps[currentIndex].backEntry();
            }
            disableAllTab();
        },
        onFinishing: function (event, currentIndex) {
            var form = $(this);

            // Disable validation on fields that are disabled.
            // At this point it's recommended to do an overall check (mean ignoring only disabled fields)
            form.validate().settings.ignore = ":disabled";

            // Start validation; Prevent form submission if false
            // return form.valid();
            return true;
        },
        onFinished: function (event, currentIndex) {
            Exit();
        }
    });
}

$(window).on('load', function () {
    // kill bomc.exe when exit the application in electron
    // 20170208 by yqw
    window.onbeforeunload = function (e) {
        killApp_bomc(top.mainAppName);
    };
    InitWizard();
});