// Copyright © 2016 - present Lenovo.    All rights reserved.
// Confidential and Proprietary.
var UpdateSelection = function () {
  let { createApp, computed, reactive, ref, watch, nextTick } = Vue;

  function genUpdateSelectionFilename() {
    return top.pathJoin(gl_support_dir, "update_selection_" + Date.now().toString() + "_" + Math.floor(Math.random() * 10) + ".json");
  }

  // Updates selection selectionData and functions
  const BY_NONE = 'by_none'; // do not group updates
  const BY_MT = 'by_mt'; // group updates by mt
  const BY_CATEGORY = 'by_category'; // group updates by category
  const group_check_box_all = ref(null)
  const updates_check_box_all = ref(null)
  let selectionData = reactive({
    group_by: BY_MT,
    acquireMode: top.acquireMode,
    updates: [],
    searchedUpdates: [],
    updatesGroupByMT: {},
    updatesGroupByCategory: {},
    queryCompleted: false,
    searchText: "",
    updatesAcCategory: new Map(),
    updatesLoadingMessage: "Loading Updates...",
  })

  function startQueryPackages() {
    selectionData.queryCompleted = false;
    try {
      let genQueryCmd = () => {
        let args = new Array();
        if (top.OSTYPE == "windows") {
          args.push(top.pathJoin(top.workingdir, "proxy.bat"));
        } else {
          args.push(top.pathJoin(top.workingdir, "proxy.sh"));
        }
        args.push(top.pathJoin(top.workingdir, top.mainAppName));
        args.push('guihelper');
        args.push('query');
        args.push('--dir')
        args.push(top.workingdirProgram);
        args.push('--output');
        args.push(top.gl_query_selection_result);
        args.push('--mt');
        args.push(top.mtArray.join(","));
        if (selectionData.acquireMode) {
          args.push('--acquire-result');
          args.push(top.gl_ac_result);
        }
        if (top.latest) {
          args.push("--latest");
        }
        return args;
      }
      runProgram(genQueryCmd(), () => {
        //load query results
        const initialGroupData = () => {
          return {
            "PACKAGES": [],
            "originalPackages": [],
            "expend": false,
            "SELECTED": true,
            "unselectedCount": 0,
          }
        }
        queryResults = JSON.parse(top.readTextFile(top.gl_query_selection_result))
        selectionData.queryCompleted = true;
        selectionData.updatesGroupByMT = {}
        selectionData.updatesGroupByCategory = {}
        selectionData.updates = []
        for (let i = 0; i < queryResults.length; ++i) {
          let mt = queryResults[i].MT;
          if (!(mt in selectionData.updatesGroupByMT)) {
            selectionData.updatesGroupByMT[mt] = initialGroupData()
          }
          for (let j = 0; j < queryResults[i].PACKAGES.length; ++j) {
            let qPkg = queryResults[i].PACKAGES[j];
            if (selectionData.updatesAcCategory.has(qPkg.UPDATEID)) {
              qPkg.COMPONENT = selectionData.updatesAcCategory.get(qPkg.UPDATEID);
            }
            let pkgIndex = selectionData.updates.findIndex((pkg) => pkg.UPDATEID === qPkg.UPDATEID)
            if (pkgIndex === -1) {
              pkgIndex = selectionData.updates.push(qPkg) - 1;
              //group by category
              let category = selectionData.updates[pkgIndex].COMPONENT;
              if (!(category in selectionData.updatesGroupByCategory)) {
                selectionData.updatesGroupByCategory[category] = initialGroupData()
              }
              selectionData.updatesGroupByCategory[category]["PACKAGES"].push(selectionData.updates[pkgIndex])
              selectionData.updatesGroupByCategory[category]["originalPackages"].push(selectionData.updates[pkgIndex])
              selectionData.updatesGroupByCategory[category]['SELECTED'] = selectionData.updatesGroupByCategory[category]['SELECTED'] && selectionData.updates[pkgIndex].SELECTED;
            }
            //group by mt
            selectionData.updatesGroupByMT[mt]["PACKAGES"].push(selectionData.updates[pkgIndex]);
            selectionData.updatesGroupByMT[mt]["originalPackages"].push(selectionData.updates[pkgIndex]);
            selectionData.updatesGroupByMT[mt]['SELECTED'] = selectionData.updatesGroupByMT[mt]['SELECTED'] && selectionData.updates[pkgIndex].SELECTED;
          }
        }
        selectionData.searchUpdates = selectionData.updates;
        togglePrevious(true);
        toggleNext(true);
      });
    } catch (error) {
      printInfoLog(error);
    }
  }

  // save selection to file
  function saveSelection() {
    let updateSelection = []
    top.gl_selected_list = new Map();
    for (let mt in selectionData.updatesGroupByMT) {
      let ug = selectionData.updatesGroupByMT[mt];
      if (!ug.SELECTED) {
        continue;
      }
      let selection = {
        targetSystems: [mt],
        rules: {
          includeIDs: []
        }
      }
      for (let i = 0; i < ug.PACKAGES.length; ++i) {
        if (!ug.PACKAGES[i].SELECTED) {
          continue;
        }
        selection.rules.includeIDs.push(ug.PACKAGES[i].UPDATEID);
      }
      if (selection.rules.includeIDs.length > 0) {
        top.gl_selected_list.set(mt.toLowerCase(), selection.rules.includeIDs);
      }
      updateSelection.push(selection);
    }
    let strUs = JSON.stringify(updateSelection);
    let updateSelectionFile = genUpdateSelectionFilename();
    top.writeTextFile(updateSelectionFile, strUs);
    return updateSelectionFile;
  }

    // save selection to file
    function saveSelectionToAcquireFile() {
      let acSelections = [];
      for (let mt in selectionData.updatesGroupByMT) {
        let ug = selectionData.updatesGroupByMT[mt];
        if (!ug.SELECTED) {
          continue;
        }
        let acResultItem = {
          MT:mt,
          PACKAGES:[]
        }

        for(let i = 0; i < ug.PACKAGES.length; ++i)
        {          
          acResultItem.PACKAGES.push(ug.PACKAGES[i]);
        }
        acSelections.push(acResultItem);
      }

      let itemSelected = JSON.stringify(acSelections);
      top.writeTextFile(top.gl_query_selection_result, itemSelected);
      return top.gl_query_selection_result;
    }

  async function updateSelection() {
    let __updateGroups = (groups) => {
      for (gName in groups) {
        let gp = groups[gName];
        gp.unselectedCount = 0;
        for (let i = 0; i < gp.PACKAGES.length; ++i) {
          if (!gp.PACKAGES[i].SELECTED) {
            gp.unselectedCount += 1;
          }
        }
        group_check_box_all.value.forEach((elInput) => {
          if (elInput.id == gName) {
            elInput.indeterminate = gp.unselectedCount > 0 && gp.unselectedCount < gp.PACKAGES.length;
          }
        })
      }
    }
    selectionData.unselectedCount = 0;
    selectionData.searchUpdates.forEach((pkg) => {
      if (!pkg.SELECTED) {
        selectionData.unselectedCount++;
      }
    })
    if (selectionData.group_by === BY_MT) {
      __updateGroups(selectionData.updatesGroupByMT);
    }
    else if (selectionData.group_by === BY_CATEGORY) {
      __updateGroups(selectionData.updatesGroupByCategory);
    }

    await nextTick();
    let __updateSelectAllCheckbox = (groups) => {
      for (gName in groups) {
        let gp = groups[gName];
        group_check_box_all.value.forEach((elInput) => {
          if (elInput.id == gName) {
            elInput.indeterminate = gp.unselectedCount > 0 && gp.unselectedCount < gp.PACKAGES.length;
          }
        })
      }
    }
    if (selectionData.group_by === BY_MT) {
      __updateSelectAllCheckbox(selectionData.updatesGroupByMT);
    }
    else if (selectionData.group_by === BY_CATEGORY) {
      __updateSelectAllCheckbox(selectionData.updatesGroupByCategory);
    }
    else {
      if (updates_check_box_all.value !== null) {
        updates_check_box_all.value.indeterminate = selectionData.unselectedCount > 0 && selectionData.unselectedCount < selectionData.searchUpdates.length;
      }
    }
  }

  function getGroupsContainsThisUpdate(pkg) {
    let relatedGroups = []
    if (selectionData.group_by == BY_MT) {
      for (gn in selectionData.updatesGroupByMT) {
        if (selectionData.updatesGroupByMT[gn].PACKAGES.indexOf(pkg) != -1) {
          relatedGroups.push(gn);
        }
      }
    }
    return relatedGroups;
  }

  watch(
    () => selectionData.group_by,
    () => {
      updateSelection();
      selectionExports.searchUpdates();
    })

  let selectionExports = {
    onGroupSelectionChange: (event, gName, group) => {
      data2 = gName;
      if (selectionData.group_by !== BY_NONE) {
        let needConfirmPkgs = []
        group.PACKAGES.forEach((pkg) => {
          if (event.target.checked === pkg.SELECTED) {
            return;
          }
          pkg.SELECTED = event.target.checked;
          if (!event.target.checked) {
            let relatedGroups = getGroupsContainsThisUpdate(pkg).filter((value) => value !== gName);
            if (relatedGroups.length > 0) {
              needConfirmPkgs.push({
                pkg: pkg,
                relatedGroups: relatedGroups
              })
            }
          }
        })
        if (needConfirmPkgs.length > 0) {
          let confirmMsg = "";
          needConfirmPkgs.forEach(({ pkg, relatedGroups }) => {
            confirmMsg += "The update " + pkg.UPDATEID + " also applicable for following system(s) " + relatedGroups.join(",") + ".\n";
          })
          confirmMsg += "Are you sure you want to unselected it for all?"
          if (!confirm(confirmMsg)) {
            needConfirmPkgs.forEach(({ pkg }) => {
              pkg.SELECTED = true;
            })
          }
        }
        group.unselectedCount = event.target.checked ? 0 : group.PACKAGES.length - needConfirmPkgs.length;
        updateSelection();
      }
      else {
        selectionData.searchUpdates.forEach((pkg) => {
          if (event.target.checked === pkg.SELECTED) {
            return;
          }
          pkg.SELECTED = event.target.checked;
        })
      }
    },
    onUpdateSelectionChange: (_, gName, pkg) => {
      if (!pkg.SELECTED) {
        let relatedGroups = getGroupsContainsThisUpdate(pkg).filter((value) => value !== gName);
        if (relatedGroups.length > 0) {
          if (confirm("This update " + pkg.UPDATEID + " also applicable for following system(s) " + relatedGroups.join(",") + ".  Are you sure you want to unselected it for all?")) {
            updateSelection();
          }
          else {
            pkg.SELECTED = true;
          }
        }
        else {
          updateSelection();
        }
      }
      else {
        updateSelection();
      }
    },
    onExpendChange: async (group) => {
      group.expend = !group.expend;
      if (group.expend) {
        await nextTick();
        updateSelection();
      }
    },
    searchUpdates: () => {
      const isPkgMatch = (pkg) => {
        const isiCaseMatch = (srcStr) => {
          return srcStr.toLowerCase().includes(selectionData.searchText.toLowerCase());
        }
        return isiCaseMatch(pkg.UPDATEID) || isiCaseMatch(pkg.DESCRIPTION) || isiCaseMatch(pkg.COMPONENT);
      }
      if (selectionData.group_by !== BY_NONE) {
        let groups = selectionData.group_by === BY_MT ? selectionData.updatesGroupByMT : selectionData.updatesGroupByCategory;
        if (selectionData.searchText !== "") {
          for (gn in groups) {
            let np = groups[gn].originalPackages.filter((pkg) => {
              return isPkgMatch(pkg);
            })
            groups[gn].PACKAGES = np;
          }
        }
        else {
          for (gn in groups) {
            groups[gn].PACKAGES = [];
            groups[gn].originalPackages.forEach((value) => { groups[gn].PACKAGES.push(value); });
          }
        }
      }
      else {
        if (selectionData.searchText !== "") {
          selectionData.searchUpdates = selectionData.updates.filter((pkg) => {
            return isPkgMatch(pkg);
          })
        }
        else {
          selectionData.searchUpdates = selectionData.updates;
        }
      }
      updateSelection();
    },
    activeGroups: computed({
      get() {
        if (selectionData.group_by === BY_MT) {
          return selectionData.updatesGroupByMT;
        } else if (selectionData.group_by === BY_CATEGORY) {
          return selectionData.updatesGroupByCategory;
        }
        else {
          return {}
        }
      }
    })
  }

  function checkSelectionSupersedeAndPrerequisites() {
    if(!top.latest)
    {
      return true;
    }
    let appendedPrerequisites = [];
    let filteredSupersedes = [];
    let supersedesMap = new Map()
    let prerequisitesMap = new Map()
    selectionData.updates.forEach((pkg) => {
      if (pkg.SELECTED) {
        if (pkg.PRE_SUPERSEDE !== "") {
          filteredSupersedes = filteredSupersedes.concat(pkg.SUPERSEDES);
          pkg.SUPERSEDES.forEach((sup) => {
            supersedesMap.set(sup, pkg.UPDATEID);
          })
        }
        if (pkg.PREREQUISITES.length > 0) {
          appendedPrerequisites = appendedPrerequisites.concat(pkg.PREREQUISITES);
          pkg.PREREQUISITES.forEach((sup) => {
            prerequisitesMap.set(sup, pkg.UPDATEID);
          })
        }
      }
    })
    appendedPrerequisites = [...new Set(appendedPrerequisites)];
    filteredSupersedes = [...new Set(filteredSupersedes)];
    filteredSupersedes = filteredSupersedes.filter((value) => {
      return appendedPrerequisites.indexOf(value) === -1;
    })
    let prompts = [];
    let shouldUnselectedPkgs = [];
    let shouldSelectedPkgs = [];
    selectionData.updates.forEach((pkg) => {
      if (pkg.SELECTED && filteredSupersedes.indexOf(pkg.UPDATEID) != -1) {
        shouldUnselectedPkgs.push(pkg);
        prompts.push(pkg.UPDATEID + " is superseded by " + supersedesMap.get(pkg.UPDATEID) + " will be removed");
      }
      if (!top.noPrereq) {
        if (!pkg.SELECTED && appendedPrerequisites.indexOf(pkg.UPDATEID) != -1) {
          shouldSelectedPkgs.push(pkg);
          prompts.push(pkg.UPDATEID + " is a prerequisite of " + prerequisitesMap.get(pkg.UPDATEID) + " will be selected")
        }
      }
    })
    if (prompts.length > 0) {
      alert(prompts.join("\n"))
      shouldUnselectedPkgs.forEach((pkg) => { pkg.SELECTED = false })
      shouldSelectedPkgs.forEach((pkg) => { pkg.SELECTED = true })
    }
    return true;
  }

  //Acquire mode selectionData and functions
  let acquireData = reactive({
    total: 0,
    curIndex: 0,
    curDownloading: "",
    isAcquiring: false,
    canceled: false,
    ignoreAcErrors: false,
    errors: []
  });

  function genAcquireCmd() {
    let args = new Array();
    if (top.OSTYPE == "windows") {
      args.push(top.pathJoin(top.workingdir, "proxy.bat"));
    } else {
      args.push(top.pathJoin(top.workingdir, "proxy.sh"));
    }
    args.push(top.pathJoin(top.workingdir, top.mainAppName));

    top.program = top.program.replace("uxspi", "UPDATE");

    args.push('--function=' + top.program.toLowerCase());

    args.push("--machine-type=" + top.mtArray.join(","));

    if (top.url_custom) {
      if (top.url_insecure) {
        args.push("--insecure");
      } else if (top.url_specify_cert) {
        if (top.urlCustomCaCertFile != "" && top.urlCustomCaCertFile != null) {
          args.push("--cacert");
          args.push(top.urlCustomCaCertFile);
        }
      }
    }

    if (top.useProxy) {
      if (top.proxyAdd != "" && top.proxyAdd != null && top.proxyAdd != undefined && top.proxyPort != "" && top.proxyPort != null && top.proxyPort != undefined) {
        if (top.proxyType == "https" ||
          top.proxyType == "socks4" ||
          top.proxyType == "socks4a" ||
          top.proxyType == "socks5" ||
          top.proxyType == "socks5h") {
          args.push("--proxy-address=" + top.proxyType + "://" + top.proxyAdd);
        } else {
          args.push("--proxy-address=" + top.proxyAdd);
        }
        args.push("--proxy-port=" + top.proxyPort);
      }
      if (top.useProxyAuth) {
        if (top.proxyUid != "" && top.proxyUid != null && top.proxyUid != undefined) {
          args.push("--proxy-user=" + top.proxyUid);
        }
        if (top.proxyPwd != "" && top.proxyPwd != null && top.proxyPwd != undefined) {
          args.push("--proxy-password=" + top.proxyPwd);
        }
      }

      if (top.proxy_insecure) {
        args.push("--proxy-insecure");
      } else {
        if (top.proxy_specify_cert) {
          if (top.proxyCaCertFile != "" && top.proxyCaCertFile != null) {
            args.push("--proxy-cacert");
            args.push(top.proxyCaCertFile);
          }
        }
      }
    }

    if (top.OSTYPE == "windows") {
      var lastChar = top.workingdirProgram.charAt(top.workingdirProgram.length - 1);
      if (lastChar == "\\") {
        top.workingdirProgram = top.workingdirProgram.substring(0, top.workingdirProgram.length - 1);
      }
    }
    args.push("-l");
    args.push(top.workingdirProgram);
    args.push("--xml");
    args.push("--acquire-type=package");
    args.push("--metaonly");
    if (top.latest) {
      args.push("--latest");
    }
    return args;
  }

  function onAcquireFinished() {
    for (let i = 0; i < acquireData.total; ++i) {
      let acRet = loadAcResult(top.gl_ac_result, i);
      if (acRet != null && acRet.FINISHED && acRet.PACKAGES.length > 0) {
        continue;
      }
      else if (acRet != null && acRet.PACKAGES.length == 0) {
        acquireData.errors.push("Not found updates for " + acRet.MT);
      }
      else {
        acquireData.errors.push("Failed to download updates metadata for " + top.mtArray[i]);
      }
    }
    if (acquireData.errors.length > 0) {
      if (!confirm("There is some errors when downloading updates metadata, continue load updates?")) {
        return;
      }
      acquireData.ignoreAcErrors = true;
    }
    selectionData.updates = [];
    selectionData.updatesGroupByMT = {};
    selectionData.updatesGroupByCategory = {};
    selectionData.updatesAcCategory = new Map();
    let acResults = loadAcResults(top.gl_ac_result);
    for (let i = 0; i < acResults.length; ++i) {
      let selection = {
        targetSystems: [acResults[i].MT],
        rules: {
          includeIDs: []
        }
      }
      for (let j = 0; j < acResults[i].PACKAGES.length; ++j) {
        const pkg = acResults[i].PACKAGES[j]
        selection.rules.includeIDs.push(pkg.UPDATEID);
        if (top.latest) {
          if (!selectionData.updatesAcCategory.has(pkg.UPDATEID)) {
            selectionData.updatesAcCategory.set(pkg.UPDATEID, pkg.COMPONENT);
          }
        }
      }
    }
    startQueryPackages()
  }

  let acquireExports = {
    startAcquire: () => {
      top.mtArray = top.mtArray.sort()
      deleteFile(top.gl_ac_result);
      deleteFile(top.gl_query_selection_result);
      deleteFile(top.guilogInfo);
      deleteFile(top.cliErrorMsg);

      acquireData.total = top.mtArray.length;
      acquireData.curIndex = 0;
      acquireData.curDownloading = "";
      acquireData.isAcquiring = true;
      acquireData.canceled = false;
      acquireData.errors = [];
      acquireData.ignoreAcErrors = false;

      top.runProgram(genAcquireCmd(), () => {
         acquireData.isAcquiring = false;
         if(!acquireData.canceled) {
          onAcquireFinished();
         }
      });

      let checkAcquireStatus = () => {
        let acRet = loadAcResult(top.gl_ac_result, acquireData.curIndex);
        if (acRet != null) {
          acquireData.curDownloading = acRet.MT;
          if (acRet.CURRENTUPDATEID) {
            acquireData.curDownloading += "->" + acRet.CURRENTUPDATEID;
          }
          if (acRet.FINISHED) {
            if (acRet.ERROR.length > 0) {
              top.writeTextFile(top.CONFIRM_CONTINUE_FILE, "CONTINUE", false);
              acquireData.errors.push(acRet.ERROR.length.toString() + " update(s) metadata download failed for " + acRet.MT);
            }
            acquireData.curIndex++;
            if (acquireData.curIndex == acquireData.total) {
              return;
            }
          }
        }
        if (acquireData.isAcquiring && !acquireData.canceled) {
          setTimeout(checkAcquireStatus, 500);
        }
      }
      checkAcquireStatus();
    },
    cancelAcquire: () => {
      killApp_bomc(top.mainAppName);
      acquireData.isAcquiring = false;
      acquireData.canceled = true;
      top.togglePrevious(true);
    },
    acquireStatus: computed({
      get() {
        if (acquireData.canceled) {
          return "Canceled to download updates metadata."
        } else if (!acquireData.isAcquiring) {
          if (acquireData.errors.length == 0) {
            return "Succeed to download updates metadata."
          }
          else {
            return "Failed to download updates metadata.";
          }
        }
      }
    }),
    acquireProgress: computed({
      get() {
        if (acquireData.curDownloading.length > 0) {
          return "Acquiring for " + acquireData.total + " systems in total, current downloading for " +
            (acquireData.curIndex < acquireData.total ? 1 + acquireData.curIndex : acquireData.total) + "th system, " + acquireData.curDownloading
        }
        else {
          return "Connecting...";
        }
      }
    }),
    showUpdateSelection: computed(
      {
        get() {
          return !acquireData.isAcquiring && (acquireData.errors.length == 0 || acquireData.ignoreAcErrors) && !acquireData.canceled
        }
      }
    )
  }

  let vueApp = undefined;
  function initVueApp() {
    if (vueApp) {
      return
    }
    vueApp = createApp({
      setup() {
        return {
          group_check_box_all,
          updates_check_box_all,
          selectionData,
          ...selectionExports,
          acquireData,
          ...acquireExports,
        }
      }
    });
    vueApp.mount("#new_update_selection")
  }

  return {
    name: "UpdateSelection",
    onRemove: () => {
      this.vueApp = undefined;
    },
    init: () => {
      initVueApp();
      selectionData.acquireMode = top.acquireMode;
      if (selectionData.acquireMode) {
        acquireExports.startAcquire();
      }
      else {
        startQueryPackages();
      }
    },
    nextAction: function () {
      if (!checkSelectionSupersedeAndPrerequisites()) {
        return false;
      }

      UpdateSelection.selectionFile = saveSelection();
      if (selectionData.acquireMode) {
        saveSelectionToAcquireFile();
      }
      return true;
    },
    backEntry: function () {
      togglePrevious(true);
      toggleNext(true);
    },
    title: "Update Selection",
    content: loadContent("UpdateSelection/UpdateSelection.html"),
  };
}();