// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Welcome = function() {

    function wl_init() {
        $("#versionInfo").html("Version "+top.PACKAGE_VERSION);
        initLanguageOption();
        Banner.set_active_status("", "");
    }

    function doCheckForLatest(ref) {
        printLog("INFO","check box 'Check for the latest version of this installer'  "+($(ref).prop("checked")?"checked.":"unchecked."));
        if ($(ref).prop("checked")) {
            if(gl_steps_current.indexOf(Proxy_Setting)>0){
                gl_steps_current.splice(gl_steps_current.indexOf(Proxy_Setting),1);
            }
            if(gl_steps_current.indexOf(Obtain_Latest_Version)>0){
                gl_steps_current.splice(gl_steps_current.indexOf(Obtain_Latest_Version),1);
            }
            gl_steps_current.splice(1, 0, Proxy_Setting, Obtain_Latest_Version);
            configSteps(gl_steps_current);
            top.bProxyShow = false;
            top.bCheckForLatest = true;
        } else {
            gl_steps_current.splice(1,2);
            configSteps(gl_steps_current);
            top.bProxyShow = true;
            top.bCheckForLatest = false;
        }
        printLog("DEBUG","function doCheckForLatest end.");
    }

    function initLanguageOption(){
        printLog("DEBUG","function initLanguageOption start.");
        let languageOpt = top.languagesCfg().languageOpt;
        console.log("initLanguageOption");
        console.log(JSON.stringify(languageOpt));
        if(languageOpt){
            let str = "";
            languageOpt.forEach(function(opt){
                str += "<option value='"+opt.value+"'>"+opt.name+"</option>";
            });
            $("#languageSelect").html(str);
            $("#languageSelect").val(top.BUILD_LANGUAGE);
        }
        printLog("DEBUG","function initLanguageOption end.");
    }

    function languageChanged(ele){
        printLog("INFO","Language option changed.");
        let lan = top.languagesCfg();
        lan.language = $(ele).val();
        top.updateLanguagesCfg(lan);
        window.xpress.reload();
    }

    return {
        name: "Welcome",
        index: 0,
        init: wl_init, 
        doCheckForLatest: doCheckForLatest,
        languageChanged: languageChanged,
        nextAction: function() { printLog("INFO","Next was clicked."); return true;},
        importId: '#import_welcome',
        selectorId: '.welcome',
        title: "Navi.Welcome",
        localizedTitle: tr("Navi.Welcome")
    };
}();
