// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Task = function () {
	// Register all needed tasks there
	const taskID = {
		updating: top.gl_isUpdate,
		manageStagedUpdate: top.gl_stagedTask,
		raidConfigure: top.gl_configRaid,
		biosConfig: top.gl_biosConfigure,
		collectLog: top.gl_collectLog,
		configureSecurity: top.gl_configSecurity
	}
	const selectInfo = {};
	for (let task of Object.values(taskID)) {
		selectInfo[task] = Vue.reactive({
			show: false,
			selected: false
		});
	}

	let vue_class = {
		data() {
			return {
				taskID,
				selectInfo,
				currentPage,
				edgeInfo,
				dialog
			};
		},
		methods: {
			tr: top.tr
		},
		watch: {
			selectInfo: {
				deep: true,
				handler: selectedChanged
			}
		},
		computed: {
			isUpdatingEnabled: isUpdatingEnabled,
			isManageStagedUpdateEnabled() {
				return !(selectInfo[taskID.updating].selected || selectInfo[taskID.configureSecurity].selected);
			},
			isRaidConfigureEnabled() {
				return !selectInfo[taskID.configureSecurity].selected;
			},
			isBIOSConfigEnabled() { return true; },
			isCollectLogEnabled() { return true; },
			isConfigureSecurityEnabled: isConfigureSecurityEnabled
		},
		directives: {
			focus: {
				mounted(el) {
					el.focus();
				}
			}
		}
	};

	let log = console.log;

	let edgeInfo = Vue.reactive({
		wave: "",
		mode: ""
	});

    function isUpdatingEnabled(){
        return !(selectInfo[taskID.manageStagedUpdate].selected || selectInfo[taskID.configureSecurity].selected);
    }

    function isConfigureSecurityEnabled() {
        return !(selectInfo[taskID.updating].selected
            || selectInfo[taskID.manageStagedUpdate].selected
            || selectInfo[taskID.biosConfig].selected
            || selectInfo[taskID.collectLog].selected
            || selectInfo[taskID.raidConfigure].selected);
    }

	function updateSteps() {
		top.gl_steps_current.splice(top.gl_steps_current.indexOf(Update_Task) + 1);
		top.gl_task = [];
		if (currentPage.tasks) {
			for (let task of Object.values(currentPage.tasks)) {
				if (selectInfo[task].selected) {
					top.gl_steps_current.push(...gl_taskLists[task]);
					top.gl_task.push(task);
				}
			}
		}
		top.gl_steps_current.push(Finish);
		configSteps(top.gl_steps_current);
	}

	function selectedChanged() {
		let val = selectInfo[taskID.updating].selected
			|| selectInfo[taskID.manageStagedUpdate].selected
			|| selectInfo[taskID.raidConfigure].selected
			|| selectInfo[taskID.biosConfig].selected
			|| selectInfo[taskID.collectLog].selected
			|| selectInfo[taskID.configureSecurity].selected;
		toggleNext(val);
		updateSteps();
	}

	function initOptions(availableTasks) {
		for (let id of Object.values(taskID)) {
			selectInfo[id].show = false;
			selectInfo[id].selected = false;
		}
		for (let id of availableTasks) {
			selectInfo[id].show = true;
		}
	}

	let currentPage = Vue.reactive({
		isAllReady: false,
		vue_app: undefined,
		opsList: {},
		init: async function () {
			this.opsList = top.loadSetting("operation_defines.json");
			this.tasks = await this.reloadTasks();
			initOptions(this.tasks);
			this.initFinished = true;
		},
		next: async function () {
			this.isAllReady = true;
			gl_wizard.steps("next");
		},
		reloadTasks: async function () {
			log("Begin to obtain available operations.");
			let connectMode = (top.gl_OOB_Params.Enabled ? "OOB" : "Inband");
			let mtype = "";
			selectInfo[taskID.configureSecurity].show = false;
			if ("OOB" == connectMode) {
				if (top.gl_multi_server_management) {
					// Multi only support some special tasks now
					mtype = "MultiServers";
				} else {
					// All tasks about thinkshield only could work in OOB mode
					// mtype = edgeGetInfo() == gl_MachineMode[7] ? gl_MachineMode[7] : "IsThinkEdge";
					let mode = await edgeGetInfo();
					if (mode != gl_MachineMode[7]) {
						mtype = "IsThinkEdge";
						selectInfo[taskID.configureSecurity].show = true;
					} else {
						mtype = gl_MachineMode[7];
					}
					// mtype = (mode == gl_MachineMode[1] || mode == gl_MachineMode[2]) ? "IsThinkEdge" : gl_MachineMode[7];
				}
			} else {
				mtype = gl_MachineMode[7]; // Default
			}
			let isTargetCFC = () => {
				if (top.isCFC() || Banner.get_current_mt() == "Multi") {
					return true;
				}
				return false;
			}
			if (Banner.get_current_mt() == "Multi" || !isTargetCFC()) {
				for (let key in this.opsList[connectMode]) {
					let pos = this.opsList[connectMode][key].indexOf(gl_biosConfigure);
					if (pos != -1){
						this.opsList[connectMode][key].splice(pos, 1);
					}
				}
			}
			if (!isTargetCFC()) {
				for (let key in this.opsList[connectMode]) {
					let pos = this.opsList[connectMode][key].indexOf(gl_collectLog);
					if (pos != -1){
						this.opsList[connectMode][key].splice(pos, 1);
					}
				}
			}
			return this.opsList[connectMode][mtype].concat();
		}
	});

	let dialog = Vue.reactive({
		Message: {
			show: false,
			showDialog: async function () {
				this.show = true;
			},
			onOk: function () {
				this.show = false;
			}
		}
	})

	async function edgeGetInfo() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		top.showUnstoppableWaitMsg();
		if (top.fileExists(edgeserverStatusPath)) {
			top.deleteFile(edgeserverStatusPath);
		}
		let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("getsecurityinfo");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push(...add_output_log5());
		printLog("INFO", "run commend:" + getRunProgramCommend(args));
		let result = await runProgram(args);
		top.hideUnstoppableWaitMsg();
		let ret = gl_MachineMode[7]; // Default
		if (!result.success) {
			selectInfo[taskID.configureSecurity].show = false;
			return ret;
		}
		selectInfo[taskID.configureSecurity].show = true;
		try {
			let xccInfo = JSON.parse(top.readTextFile(edgeserverStatusPath));
			let xccWave = xccInfo["Wave"];
			edgeInfo.wave = xccWave;
			let xccStatus;
			if (xccWave.toLowerCase() == "wave1") {
				let xccMode = xccInfo["Mode"]; // enabled/disabled/unsupported
				xccStatus = xccInfo["Status"]; // inactive/active (only presented when mode = enabled)
				if (xccMode.toLowerCase() == "enabled") {
					if (xccStatus.toLowerCase() != "active") {
						ret = gl_MachineMode[1]; // ThinkEdge_Enabled_Inactive
					} else {
						ret = gl_MachineMode[2]; // ThinkEdge_Enabled_Active
					}
				} else if (xccMode.toLowerCase() == "disabled") {
					ret = gl_MachineMode[0] // ThinkEdge_Disabled
				}
			} else {
				let xccActivationMethod = xccInfo["Activation Method"];
				xccStatus = xccInfo["Status"];
				if (xccActivationMethod.toLowerCase() == "local") {
					ret = xccStatus.toLowerCase() != "active" ? gl_MachineMode[3] : gl_MachineMode[4];
				} else if (xccActivationMethod.toLowerCase() == "portal") {
					ret = xccStatus.toLowerCase() != "active" ? gl_MachineMode[5] : gl_MachineMode[6];
				}
			}
			top.gl_Edge_Machine_Params.ActivationCode = xccInfo["Active Code"];
			top.gl_Edge_Machine_Params.ChallengeText = xccInfo["Challenge Text"];
			top.gl_Edge_Machine_Params.SN = xccInfo["Serial Number"];
			top.gl_Edge_Machine_Params.roleID = xccInfo["User Role ID"];
			top.gl_Edge_Machine_Params.SEDEnabled = xccInfo["SED Encryption"];
			top.gl_Edge_Machine_Params.SEDEncryptionMethod = xccInfo["SED Generate method"];
			top.gl_Edge_Machine_Params.Wave = xccWave;
			top.gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable = xccInfo["Chassis Intrusion Detection Enable"];
			top.gl_Edge_Machine_Params.GSensor.MotionDetectionMode = xccInfo["MotionDetection"]["Motion Detection Mode"];
			top.gl_Edge_Machine_Params.GSensor.StepCounter = xccInfo["MotionDetection"]["StepCounter"];
			top.gl_Edge_Machine_Params.GSensor.ThresholdLevel = xccInfo["MotionDetection"]["ThresholdLevel"];
		} catch (e) {
			printLog("ERROR", "Failed to read edgeserverStatus json.");
			ret = gl_MachineMode[7]; // Default
			printLog("DEBUG", "Current machine mode is ", ret);
			console.log("Current machine mode is", ret);
			return ret;
		}
		printLog("DEBUG", "Current machine mode is ", ret);
		console.log("Current machine mode is", ret);
		top.gl_Edge_Machine_Params.MachineMode = ret;
		edgeInfo.mode = gl_MachineMode.indexOf(ret);
		return ret;
	}

	function init() {
		printLog("INFO", "TargetServer page init.");

		// Store mt & os info as all of them being ready
		// On OOB multiserver case, gl_mt_list and gl_os_list contains all combanitions of mt and os. (Create repo case is same with it)
		// On OOB non-multiserver case, gl_mt_list[0] == gl_OOB_Params.mt, gl_os_list[0] == "platform"
		// On Inband case, gl_mt_list[0] == gl_current_mt, gl_os_list[0] == gl_current_os
		if (top.gl_OOB_Params.Enabled){
			top.gl_mt_list = new Array();
			top.gl_os_list = new Array();
			for (let server of Server_Pool.selectedServerList) {
				top.gl_mt_list.push(server.mt);
			}
			top.gl_mt_list = Array.from(new Set(top.gl_mt_list));
			top.gl_os_list = ["platform"];
		} else {
			top.gl_mt_list = new Array();
			top.gl_os_list = new Array();
			top.gl_mt_list.push(top.gl_current_mt);
			top.gl_os_list.push(top.gl_current_os);
		}
        edgeInfo.wave = "";
        edgeInfo.mode = "";
		selectedChanged();

		init_vue();
	};

	async function init_vue() {
		if (currentPage.vue_app) {
			await currentPage.init();
			return;
		}
		currentPage.vue_app = Vue.createApp(vue_class);
		currentPage.vue_app.mount('#update_task_vue');
		await currentPage.init();
	}

	function uninit() {
		if (!currentPage.vue_app) {
			return;
		}
		currentPage.vue_app.unmount();
		currentPage.vue_app = undefined;
	}

	function next() {
		log("next click in update task page.")
		if (currentPage.isAllReady) {
			return true;
		}
		currentPage.next();
		return false;
	}

	function previous() {
		currentPage.initFinished = false;
		top.toggleNext(true);
		return true;
	}

	return {
		index: 0,
		name: "Update_Task",
		init: init,
		nextAction: next,
        selUpdateTask: function() { if(isUpdatingEnabled()) {selectInfo[taskID.updating].selected = true;}},
        selConfigSecurityTask: function() { if(isConfigureSecurityEnabled()) {selectInfo[taskID.configureSecurity].selected = true;}},
        needReInit: true,
		previousAction: previous,
		importId: '#import_update_task',
        selectorId: '.update_task',
        title: "Navi.UpdateTask",
		localizedTitle: tr("Navi.UpdateTask"),
		uninit: uninit
	}
}();