// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Execution = function() {
    var up_progress_timer;
    var up_table_visibility;
    var up_total;
    var up_package_index;
    var up_running;
    var up_isGrantly;
    var up_isELIE;
    var up_args;
    var up_isbundle;
    
    var up_flashResult; // up_flashResult & 1: error, up_flashResult & 2: warning

    const ONECLIRESULT_TASK_STAGED = 86; // Regard as Success
    const ONECLIRESULT_NO_UPDATE = 110;  // Regard as Warning

    // current index of payload that is copying
    var copyIndex = 0;
    // total number of payloads that need copy
    var copyTotal = 0;
    // if a payload is failed to copy, will push into this array
    // if copyError.length > 0, will warn user
    // if copyError.length = copyTotal, will let user retry
    var copyError = new Array();

    var waitForComplete = 0;

    // let serversResult = [{
    //     ip:"192.168.1.1",
    //     errorCode:"",
    //     errorMsg:"",
    //     isHasParent:true,
    //     packages:[{
    //         id:"lnvgy_fw_uefi_tee174f-3.10_anyos_32-64",
    //         parentID:"",
    //         reboot:"No reboot required",
    //         devices:[{
    //             unit:"UEFI",
    //             slot:"N/A",
    //             resCode:1543,
    //             resMessage:"The prerequisites of this package flash failed, so skip updating this package."
    //         }]
    //     }]
    // }];
    let serversResult = new Array();

    // for salie, after comparing updates and user select packages to update, will copy payloads from /run/initramfs/live to /toolscenter
    // after copying, start normal process
    function up_init() {
        printLog("INFO","Update Execution page init.");
        if (top.gl_OOB_Params.Enabled) {
            document.getElementById("updateBeginLabel").innerText = $.i18n.prop("UpdateExec.RebootConfirm");
        } else {
            document.getElementById("updateBeginLabel").innerText = $.i18n.prop("UpdateExec.UpdateConfirm");
        }
        $("#ue-taskid").parent().hide();
        // init page
        // transfer to appropriate value
        if (top.gl_uxlite_bootable || top.gl_multi_server_management) {
            $('#BundleDiv').hide();
            up_isbundle = false;
        } else {
            $('#BundleDiv').show();
            up_isbundle = $("#EnableBundleCheckbox").prop("checked");
        }
        if (up_isbundle) {
            $('#ApplyTimeDiv').show();
        } else {
            $('#ApplyTimeDiv').hide();
        }
        if (top.gl_OOB_Params.Enabled) {
            $('#ApplyTimeOption option[value="OnReset"]').show();
            $('#ApplyTimeOption option[value="Immediate"]').show();
            $('#ApplyTimeOption option[value="Immediate"]').prop("selected", true);
            $('#InstructionalForOnReset').hide();
            $('#InstructionalForImmediate').show();
            $('#InstructionalForOnStartUpdateRequest').hide();
        } else {
            $('#ApplyTimeOption option[value="OnReset"]').show();
            $('#ApplyTimeOption option[value="Immediate"]').hide();
            $('#ApplyTimeOption option[value="OnReset"]').prop("selected", true);
            $('#InstructionalForOnReset').show();
            $('#InstructionalForImmediate').hide();
            $('#InstructionalForOnStartUpdateRequest').hide();
        }

        if (top.gl_uxlite_bootable && top.fileExists('/etc/elie_version')) {
            up_isELIE = true;
        } else {
            up_isELIE = false;
        }

        // only need copy payloads when it is bootable case and it is not boot by usb key or pxe
        if (top.gl_uxlite_bootable && top.need_copy() && !in_ramdisk()) {
            startCopy();
        }
        else {
            up_init_normal();
        }
        up_flashResult = 0;
    }

    function startCopy() {
        top.togglePrevious(false);
        top.toggleNext(false);
        copyTotal = top.gl_co_list.length;
        copyIndex = 0;
        copyError = new Array();
        $('#copyMsg').html('');
        $('#errMsgExec2').html('');
        $('#errMsgExec').hide();
        $('#warnMsgExec').hide();
        $('#warnMsgExec2').html('');
        $('#copy_success').hide();
        $('#copyBeginSection').hide();
        $('#EnableBundleDiv').hide();
        $('#ApplyTimeDiv').hide();
        $('#updateBeginSection').hide();
        document.getElementById('copyProgress').style.marginRight = '100%';
        $('#copy_status').show();
        if (up_isELIE) {
            top.createDirectory("/run/initramfs/live");
            var mountArgs = new Array();
            mountArgs.push("mount");
            if(top.gl_ISO_path != "")
                mountArgs.push(top.gl_ISO_path);
            else
                mountArgs.push("/dev/sr0");
            mountArgs.push("/run/initramfs/live");
            printLog("INFO","run command:" + getRunProgramCommend(mountArgs));
            runProgram(mountArgs, null, copyPayload);
        }
        else {
            copyPayload(true);
        }
    }

    function copyPayload(success) {
        if (!success) {
            copyError.push(top.gl_co_list[copyIndex - 1]);
        }
        if (copyIndex > copyTotal - 1) {
            if (up_isELIE) {
                var umountArgs = new Array();
                umountArgs.push("umount");
                umountArgs.push("/run/initramfs/live");
                printLog("INFO","run command:" + getRunProgramCommend(umountArgs));
                runProgram(umountArgs, null, completeCopy);
            }
            else {
                completeCopy();
            }
        } else {
            var payloadFile = top.gl_payload_list[copyIndex];
            if (payloadFile.substring(0, "/toolscenter/".length) != "/toolscenter/") {
                payloadFile = "/toolscenter/" + payloadFile;
            }
            var parentDir = top.dirname(payloadFile);
            payloadFile = payloadFile.substring("/toolscenter".length);
            top.createDirectory(parentDir);
            var copyArgs = new Array();
            copyArgs.push("cp");
            copyArgs.push("-rnf"); // add -n, do not copy same item.
            copyArgs.push("/run/initramfs/live" + payloadFile);
            copyArgs.push("/toolscenter" + payloadFile)
            copyIndex++;
            // show progress
            document.getElementById("copyMsg").innerHTML = $.i18n.prop("UpdateExec.Copying") + " " + copyIndex + " of " + copyTotal;
            var percentage = formatData((1 - copyIndex / copyTotal) * 100) + "%";
            document.getElementById("copyProgress").style.marginRight = percentage;
            printLog("INFO","run command:" + getRunProgramCommend(copyArgs));
            runProgram(copyArgs, null, copyPayload);
        }
    }

    function completeCopy() {
        $('#copy_status').hide();
        top.togglePrevious(true);
        if (copyError.length == copyTotal) {
            $('#errMsgExec').show();
            $('#errMsgExec2').html($.i18n.prop('UpdateExec.FailCopyAll'));
            $('#copyBeginSection').show();
            top.toggleNext(false);
        } else if (copyError.length > 0) {
            $('#warnMsgExec').show();
            var warnMsg = $.i18n.prop('UpdateExec.FailCopySome');
            for (var i = 0; i < copyError.length; i++) {
                warnMsg += '<br>' + copyError[i];
            }
            $('#warnMsgExec2').html(warnMsg);
            $('#copyBeginSection').show();
            $('#EnableBundleDiv').show();
            if (up_isbundle) $('#ApplyTimeDiv').show();
            $('#updateBeginSection').show();
            top.toggleNext(true);
        } else {
            $('#copy_success').show();
            $('#copyBeginSection').hide();
            up_init_normal();
        }
    }

    function up_init_normal() {
        // init
        // if execution page is inited, View Log at Finish page should show flash log instead of acquiring log.
        // clean the previous value of logfile
        // if flash is success, it will assign a new value to this variable, else, it will remain an empty string.
        setLogFile("");
        up_table_visibility = false;
        up_total = -1;
        up_package_index = 0;
        up_running = false;
        up_args = new Array();
        top.togglePrevious(true);

        $("#up_status").hide();
        $('#EnableBundleDiv').show();
        if (up_isbundle) $('#ApplyTimeDiv').show();
        $("#updateBeginSection").show();
        toggleNext(false);
        // fix problem that flash is not started automatically when autorun is enabled
        if (top.gl_uxlite_bootable == '1') {
            if (top.is_unattend() || top.is_autorun()) {
                $("#updateBeginBtn").click();
            }
        }
        up_isGrantly = top.isGrantly();
    }

    function confirmUpdate() { 
        printLog("INFO","button 'Begin Update' was clicked.");
        $('#copy_status').hide();
        $('#errMsgExec').hide();
        $('#warnMsgExec').hide();
        $('#copy_success').hide(); 
        $('#copyBeginSection').hide();
        beginExecute();
    }

    /** MULTI FLASH FUNCTIONS */
    function beginUpdate_multi() {
        togglePrevious(false);
        toggleNext(false);
        document.getElementById("flashMsg").style.display = "block";

        let flash_progress = new Array(Server_Pool.selectedServerList.length).fill(0);
        up_args = new Array();
        up_args.push(top.getSystemFile("oneCli"));
        up_args.push("update");
        up_args.push("flash");
        up_args.push("--uselocalimg");
        if (top.gl_Remote_Params.Use_Sep_Remote) {
            if (top.gl_Remote_Params.Use_Sep_SFTP) {
                up_args.push("--sftp");
            } else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
                up_args.push("--https");
            } else if (top.gl_Remote_Params.Use_Sep_FTP) {
                up_args.push("--ftp");
            } else if (top.gl_Remote_Params.Use_Sep_HTTP) {
                up_args.push("--http");
            }
            up_args.push(RemoteServerConnInfo());
        }
        up_args.push("--dir");
        up_args.push(top.gl_workingDir);

        // TODO
        // if (!up_isbundle && top.gl_OOB_Params.Enabled && !top.isAmd()) {
        up_args.push('--platform');
        // }

        for (let i = 0; i < Server_Pool.selectedServerList.length; ++i) {
            let cmpXmlFile = top.getSupportFile("compareResult", "oneCli", Server_Pool.selectedServerList[i].ip);
            if (!top.fileExists(cmpXmlFile)) {
                // Skip flash because it must fail without comparexml
                deleteFile(top.getSupportFile("updateResult", "oneCli", Server_Pool.selectedServerList[i].ip));
                flash_progress[i] = 1;
                printLog("INFO", "Skip " + Server_Pool.selectedServerList[i].ip + " beceuse of no comparexml.");
                continue;
            }
            deleteFile(top.getSupportFile("updateResult", "oneCli", Server_Pool.selectedServerList[i].ip));
            deleteFile(top.getSupportFile("commonResult", null, Server_Pool.selectedServerList[i].ip));
            let real_args = up_args.concat();
            real_args.push("--imm");
            real_args.push(SplitFullConnInfo(Server_Pool.selectedServerList[i]));
            real_args.push("--never-check-trust");
            real_args.push(...add_output_log5(Server_Pool.selectedServerList[i].ip));
            real_args.push("--comparexml");
            real_args.push(cmpXmlFile);
            printLog("INFO","run command:" + getRunProgramCommend(real_args));
            runProgram(real_args, null, () => {
                flash_progress[i] = 1;
            });
        }

        up_progress_timer = setInterval(() => {
            let countTotal = flash_progress.length;
            let countRunning = flash_progress.filter(n => n == 0).length;
            let countDone = flash_progress.filter(n => n == 1).length;
            document.getElementById("flashMsgTotal").innerText   = $.i18n.prop("Total")   + ": " + countTotal;
            document.getElementById("flashMsgRunning").innerText = $.i18n.prop("Common.Running") + ": " + countRunning;
            document.getElementById("flashMsgDone").innerText    = $.i18n.prop("Common.Done")    + ": " + countDone;

            if (countDone == countTotal) {
                clearInterval(up_progress_timer);
                showFlashResult_multi();
            }
        }, 1000);
    }

    function readFlashResult() {
        serversResult = new Array();
        for (let _selectedServer of Server_Pool.selectedServerList) {
            let _errorCode = null;
            let _resultMsg = null;
            let _isHasParent = false;
            let _packages = new Array();
            // Read flash result
            let _flashResult = top.readTextFile(top.getSupportFile("updateResult", "oneCli", _selectedServer.ip));
            if (_flashResult != null) {
                let Slot_Type_String = new Array();
                let _flashDom = ezJsLib.XmlDom.parse(_flashResult);
                let _pkgCollection = _flashDom.getElementsByTagName("PACKAGE");
                for (let i = 0; i < _pkgCollection.length; ++i) {
                    let _devices = new Array();
                    let _childUpdateCollection = _pkgCollection[i].getElementsByTagName("CHILDUPDATE");
                    for (let j = 0; j < _childUpdateCollection.length; ++j) {
                        // Deal with slot, change slotType from number to a readable text
                        let slot;
                        let slotNum = ezJsLib.XmlDom.getValueByTagFromNode("SLOTNUM", _childUpdateCollection[j], "N/A");
                        let slotType = ezJsLib.XmlDom.getValueByTagFromNode("SLOTTYPE", _childUpdateCollection[j], "N/A");
                        if (slotNum != "N/A" && !isNaN(slotNum)) {
                            if (slotType == "N/A" || isNaN(slotType)) {
                                slot = slotNum;
                            } else if (slotType === 0 || slotType === "0") {
                                slot = "Onboard";
                            } else {
                                if (Slot_Type_String.length == 0) {
                                    for (let slotName of _flashDom.getElementsByTagName("SLOTNAME")) {
                                        Slot_Type_String.push(slotName.textContent);
                                    }
                                }
                                slot = Slot_Type_String[slotType] + " " + slotNum;
                            }
                        } else {
                            slot = "N/A";
                        }
                        _devices.push({
                            unit:       ezJsLib.XmlDom.getValueByTagFromNode("ADAPTERNAME", _childUpdateCollection[j], "N/A"),
                            slot:       slot,
                            resCode:    ezJsLib.XmlDom.getValueByTagFromNode("RESCODE", _childUpdateCollection[j], "0"),
                            resMessage: ezJsLib.XmlDom.getValueByTagFromNode("RESMESSAGE", _childUpdateCollection[j], "N/A")
                        });
                    }
                    let _parentID = ezJsLib.XmlDom.getValueByTagFromNode("MACROPACKAGEID", _pkgCollection[i], "");
                    if (_parentID != "") {
                        _isHasParent = true;
                    }
                    _packages.push({
                        id:       ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", _pkgCollection[i], "N/A"),
                        parentID: _parentID,
                        reboot:   ezJsLib.XmlDom.getValueByTagFromNode("REBOOT", _pkgCollection[i], "Unknown"),
                        devices:  _devices
                    });
                }
            }
            // Read common result
            let _commonResult = top.readTextFile(top.getSupportFile("commonResult", null, _selectedServer.ip));
            if (_commonResult != null) {
                let commonResultDom = ezJsLib.XmlDom.parse(_commonResult);
                _errorCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", commonResultDom.documentElement, null);
                _resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", commonResultDom.documentElement, null);
            }
            if (_errorCode === null || _errorCode === undefined) {
                _errorCode = "N/A";
            }
            if (_resultMsg === "" || _resultMsg === null || _resultMsg === undefined) {
                _resultMsg = $.i18n.prop("UpdateExec.UnknownError");
            }
            serversResult.push({
                ip:          _selectedServer.ip,
                errorCode:   _errorCode,
                errorMsg:    _resultMsg,
                isHasParent: _isHasParent,
                packages:    _packages
            });
        }
    }
    function sortFlashResult() {
        function judgeStatus(server) {
            // level
            //   0    Has result table, Success
            //   1    Has result table, Warning
            //   2    Has result table, Error
            //   3    No result table,  Success(failed to read result?)
            //   4    No result table,  Warning(such as no need to update)
            //   5    No result table,  Error
            if (server.packages.length < 1) {
                if (server.errorCode === 0 || server.errorCode === "0" || Number(server.errorCode) === ONECLIRESULT_TASK_STAGED) {
                    return 3;
                }
                if (Number(server.errorCode) === ONECLIRESULT_NO_UPDATE) {
                    return 4;
                }
                return 5;
            } else {
                if (server.errorCode === 0 || server.errorCode === "0" || Number(server.errorCode) === ONECLIRESULT_TASK_STAGED) {
                    return 0;
                }
                return 2;
            }
        }
        serversResult.sort((serverA, serverB) => {
            return judgeStatus(serverA) - judgeStatus(serverB);
        });
        function judgeChildStatus(package) {
            // Success -> Error
            if (package.resCode === 0 || package.resCode === "0") {
                return 0;
            } else if (Number(package.resCode) === ONECLIRESULT_TASK_STAGED) {
                return 1;
            } else {
                return 2;
            }
        }
        for (let server of serversResult) {
            server.packages.sort((pA, pB) => {
                return judgeChildStatus(pA) - judgeChildStatus(pB);
            })
        }
    }
    function updateCount(index, content) {
        let spans = _doc.getElementById(TITLE_PRE + index).getElementsByTagName("span");
        spans[0].innerHTML = content;
    }
    function ExpandMultiResult() {
        for (let i = 0; i < serversResult.length; ++i) {
            let index = "flash_" + serversResult[i].ip;
            let tableContentDiv = document.getElementById(TABLE_DIV_PRE + index);
            if (tableContentDiv && tableContentDiv.style.display == "none") {
                displayContent(index);
            }
        }
    }
    function CollapseMultiResult() {
        for (let i = 0; i < serversResult.length; ++i) {
            let index = "flash_" + serversResult[i].ip;
            let tableContentDiv = document.getElementById(TABLE_DIV_PRE + index);
            if (tableContentDiv && tableContentDiv.style.display != "none") {
                hideContent(index);
            }
        }
    }

    function showFlashResult_multi() {
        document.getElementById("multiflash_tip").style.display = "block";
        document.getElementById("multiflash_tip").innerHTML = $.i18n.prop("UpdateExec.MultiFlashTip");
        document.getElementById("multiflash_expandbutton").style.display = "block";

        readFlashResult();
        sortFlashResult();

        _doc = document;
        _details = _doc.getElementById("details_multiflash");
        _details.innerHTML = "";
        _details.style.display = "block";
        if (serversResult.filter(s => s.isHasParent == true).length > 0) {
            header = ["", tr("Updatable Unit"), tr("Slot"), tr("Need Reboot"), tr("Result"), tr("Update ID"), tr("Parent ID")];
        } else {
            header = ["", tr("Updatable Unit"), tr("Slot"), tr("Need Reboot"), tr("Result"), tr("Update ID")];
        }
        for (let server of serversResult)
        {
            let index = "flash_" + server.ip;
            createContent(server.ip, null, null, index, function createTitle (ip, mt, os, index, contentDiv) {
                let titleInnerHTML = new Array();
                titleInnerHTML.push("<div class='ContentTitleDiv' id='" + TITLE_PRE + index + "' onclick='toggleContent(this)'>");
                titleInnerHTML.push("<img>&nbsp;");
                titleInnerHTML.push(ip + " - <span></span>");
                titleInnerHTML.push("</div>");
                contentDiv.innerHTML = titleInnerHTML.join("");
            });
            if (server.packages.length < 1) {
                //content empty, unnecessary to create a table
                if (server.errorCode === 0 || server.errorCode === "0" || Number(server.errorCode) === ONECLIRESULT_TASK_STAGED) {
                    updateTitle(index, "Done");
                    updateCount(index, $.i18n.prop("UpdateExec.NoFlashResult"));
                } else if (Number(server.errorCode) === ONECLIRESULT_NO_UPDATE) {
                    updateTitle(index, "Warning");
                    if(server.errorMsg === "No package needs update."){
                        updateCount(index, tr("UpdateComparison.NoUpdates"));
                    } else {
                        updateCount(index, "(" + server.errorMsg + ")");
                    }
                } else {
                    updateTitle(index, "Error");
                    updateCount(index, "(" + server.errorMsg + ")");
                }
                continue;
            } else {
                showPlusIcon(index);
                if (server.errorCode === 0 || server.errorCode === "0" || Number(server.errorCode) === ONECLIRESULT_TASK_STAGED) {
                    updateTitle(index, "Done");
                } else {
                    updateTitle(index, "Error");
                }
            }
            let countSuccessItems = 0;
            let countStagedItems = 0;
            let countTableItems = server.packages.length;
            let table = createTable(index, "multiflash");
            for (let pkg of server.packages) {
                let id       = pkg.id;
                let parentID = pkg.parentID;
                let reboot   = pkg.reboot;
                for (let childUpdate of pkg.devices) {
                    let unit       = childUpdate.unit;
                    let slot       = childUpdate.slot;
                    let resCode    = childUpdate.resCode;
                    let resMessage = childUpdate.resMessage;
                    let status     = "";
                    let imgHTML    = "";
                    if (resCode === "0" || resCode === 0) {
                        status = "Success";
                        ++countSuccessItems;
                        imgHTML = `<img src="images/statusSuccess_obj16.gif">`;
                    } else if (Number(resCode) === ONECLIRESULT_TASK_STAGED) {
                        status = "Staged";
                        ++countStagedItems;
                        imgHTML = `<img src="images/statusSuccess_obj16.gif">`;
                    } else {
                        status = "Error";
                        imgHTML = `<img src="images/statusCritical_obj16.gif">`;
                    }

                    //add a new row
                    let newRow = table.insertRow(-1);
                    let newCell0 = newRow.insertCell(-1);
                    newCell0.innerHTML = imgHTML;
                    newCell0.className = "EntityTableCell";
    
                    let newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = unit;
                    newCell1.title = unit;
                    newCell1.className = "EntityTableCell";
    
                    let newCell2 = newRow.insertCell(-1);
                    newCell2.innerHTML = slot;
                    newCell2.title = slot;
                    newCell2.className = "EntityTableCell";
    
                    let newCell3 = newRow.insertCell(-1);
                    newCell3.innerHTML = reboot;
                    newCell3.title = reboot;
                    newCell3.className = "EntityTableCell";

                    let newCell4 = newRow.insertCell(-1);
                    newCell4.innerHTML = status;
                    newCell4.title = resMessage;
                    newCell4.className = "EntityTableCell Hoverable";
                    newCell4.style.textDecoration = "underline";
                    newCell4.style.color = "#2d6cbf";
                    // newCell4.style.cursor = "pointer";
    
                    let newCell5 = newRow.insertCell(-1);
                    newCell5.innerHTML = id;
                    newCell5.title = id;
                    newCell5.className = "EntityTableCell";

                    if (header.length == 7) {
                        let newCell6 = newRow.insertCell(-1);
                        newCell6.innerHTML = parentID;
                        newCell6.title = parentID;
                        newCell6.className = "EntityTableCell";
                    }
                }
            }
            printLog("INFO",server.ip + ": " + (countSuccessItems + countStagedItems) + " success in " + countTableItems + " case(s).");
            let textDesc = tr("{0} updates succeed out of {1}", countSuccessItems + countStagedItems, countTableItems);
            if (countStagedItems > 0) {
                textDesc += tr(", include {0} staged cases.", countStagedItems);
            }
            updateCount(index, textDesc);
        }
        togglePrevious(true);
        toggleNext(true);
        document.getElementById("flashMsg").style.display = "none";
        setLogFile(top.getTempPath4ThisTask());
        return;
    }
    /** END MULTI FLASH FUNCTIONS */

    function beginExecute() {
        // show status bar and hide begin button
        $('#EnableBundleDiv').hide();
        $('#ApplyTimeDiv').hide();
        $("#updateBeginSection").hide();
        if (top.gl_multi_server_management) {
            beginUpdate_multi();
        } else {
            $("#up_status").show();
            beginUpdate();
        }
    }

    function updateCB() {
        up_args.push("--comparexml");
        up_args.push(top.getSupportFile('compareResult', 'rewrite'));
        togglePrevious(false);
        toggleNext(false);
        up_running = true;
        top.store_onecli_command(up_args);
        printLog("INFO","run command:" + getRunProgramCommend(up_args));
        runProgram(up_args, null, markComplete);
        up_progress_timer = setInterval(showStatus_up, 1000);
    }

    function RemoteServerConnInfo() {
        if (top.gl_Remote_Params.Remote_UserName != "" || top.gl_Remote_Params.Remote_Password != "") {
            if (top.gl_Remote_Params.Remote_Port == "") {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@[" + top.gl_Remote_Params.Remote_Address + "]" + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@" + top.gl_Remote_Params.Remote_Address + top.gl_Remote_Params.Remote_Location);
                }
            } else {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@[" + top.gl_Remote_Params.Remote_Address + "]:" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_UserName + ":" + top.gl_Remote_Params.Remote_Password + "@" + top.gl_Remote_Params.Remote_Address + ":" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                }
            }
        } else {
            if (top.gl_Remote_Params.Remote_Port == "") {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return ("[" + top.gl_Remote_Params.Remote_Address + "]" + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_Address + top.gl_Remote_Params.Remote_Location);
                }
            } else {
                if (top.gl_Remote_Params.Remote_Address.indexOf(":") != -1) {
                    return ("[" + top.gl_Remote_Params.Remote_Address + "]:" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                } else {
                    return (top.gl_Remote_Params.Remote_Address + ":" + top.gl_Remote_Params.Remote_Port + top.gl_Remote_Params.Remote_Location);
                }
            }
        }
    }

    function beginUpdate() {
        //Preparation
        waitForComplete = 0;
        deleteFile(top.getSupportFile("updateResult", "oneCli"));
        deleteFile(top.getSupportFile("commonResult"));
        up_args = new Array();
        up_args.push(top.getSystemFile("oneCli"));
        up_args.push("update");
        up_args.push("flash");
        if (top.gl_OOB_Params.Enabled) {
            up_args.push("--uselocalimg");
            up_args.push("--imm");
            up_args.push(SplitFullConnInfo());
            
            if (top.gl_Remote_Params.Use_Sep_Remote) {
                // One and only one protocol has been selected in OOBSetting
                if (top.gl_Remote_Params.Use_Sep_SFTP) {
                    up_args.push("--sftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
                    up_args.push("--https");
                } else if (top.gl_Remote_Params.Use_Sep_FTP) {
                    up_args.push("--ftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTP) {
                    up_args.push("--http");
                }
                up_args.push(RemoteServerConnInfo());
            }
            up_args.push("--never-check-trust");
        } else {
            // inband CFC also use external server
            if (top.gl_Remote_Params.Use_Sep_Remote) {
                if (top.gl_Remote_Params.Use_Sep_SFTP) {
                    up_args.push("--sftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTPS) {
                    up_args.push("--https");
                } else if (top.gl_Remote_Params.Use_Sep_FTP) {
                    up_args.push("--ftp");
                } else if (top.gl_Remote_Params.Use_Sep_HTTP) {
                    up_args.push("--http");
                }
                up_args.push(RemoteServerConnInfo());
                up_args.push("--never-check-trust");
            }
        }

        // inband parameters
        // add by chenhao at 20170606
        if (top.gl_Inband_Params.Enabled && top.gl_Inband_Params.UserInput) {
            if (top.gl_Inband_Params.IMM_UserName != "" && top.gl_Inband_Params.IMM_UserName != null && top.gl_Inband_Params.IMM_UserName != undefined
             && top.gl_Inband_Params.IMM_Password != "" && top.gl_Inband_Params.IMM_Password != null && top.gl_Inband_Params.IMM_Password != undefined) {
                up_args.push("--bmc-username");
                up_args.push(top.gl_Inband_Params.IMM_UserName);
                up_args.push("--bmc-password");
                up_args.push(top.gl_Inband_Params.IMM_Password);
            }

            if (top.gl_Inband_Params.IMM_Port != "" && top.gl_Inband_Params.IMM_Port != null && top.gl_Inband_Params.IMM_Port != undefined) {
                up_args.push("--bmc-cim-port");
                up_args.push(top.gl_Inband_Params.IMM_Port);
            }

            if (top.gl_Inband_Params.REST_Port != "" && top.gl_Inband_Params.REST_Port != null && top.gl_Inband_Params.REST_Port != undefined) {
                up_args.push("--bmc-rest-port");
                up_args.push(top.gl_Inband_Params.REST_Port);
            }
        }

        // bundle parameters
        if (up_isbundle) {
            up_args.push("--bundle");
            up_args.push("--applytime");
            var applyTimeArg = $('#ApplyTimeOption').prop("value");
            up_args.push(applyTimeArg);
        }

        up_args.push("--dir");
        up_args.push(top.gl_workingDir);
        up_args.push(...add_output_log5());

        if (top.gl_optionBackup == true) {
            up_args.push("--backup");
        }

        // inband case and oob case
        if (!up_isbundle && top.gl_OOB_Params.Enabled && !top.isAmd()) {
            up_args.push('--platform');
        }
        if (top.is_reboot_bmc() == false) {
            up_args.push('--noreboot');
        }
        rewrite_compare_result(top.gl_selected_list, top.gl_forceid_list, updateCB);
    }

    function markComplete(rc, error) {
        up_running = false;
    }

    function up_backEntry() {
        // do nothing when back from the next page
    }

    function showStatus_up() {
        var up_running_cache = up_running;
        var content;        
        if(top.fileExists(top.getSupportFile("updateResult", "oneCli"))) {
            content = top.readTextFile(top.getSupportFile("updateResult", "oneCli"));    
        }
        if (content != null) {
            var dom = ezJsLib.XmlDom.parse(content);
            if (!up_table_visibility)  {
                createDetailTable(dom);
                up_table_visibility = true;
            }
            updateDetailTable(dom, up_running_cache);
            updateProgressBar(up_running_cache);
        }
        //if (!up_running_cache && (up_total == up_package_index)) 
        // Bug 117321 - xClarity Essential tool BoMC v11.0 window hung and fail to exit after system update completed.
        // for bootable mode, will detect whether common_result.xml is completed writing
        // if it is completed writing, will set up_running_cache to false
        // added by chenhao: 2017.11.1
        if (top.gl_uxlite_bootable) {
            if (top.fileExists(top.getSupportFile('commonResult'))) {
                var resultFile = top.readTextFile(top.getSupportFile('commonResult'));
                var resultDom;
                var resultRC;
                if (resultFile != null) {
                    try {
                        resultDom = ezJsLib.XmlDom.parse(resultFile);
                        resultRC = ezJsLib.XmlDom.getValueByTagFromNode("RETURNCODE", resultDom.documentElement);
                    } catch(e) {
                        // do nothing
                    }
                    console.log('resultRC is: ' + resultRC);
                    if (resultRC != null || resultRC != undefined) {
                        up_running_cache = false;
                    }
                }
            }
        }
        if (!up_running_cache) {
            clearInterval(up_progress_timer);
            getCommonResult();
            if (needPrereqWarn()) {
                top.gl_needPrereqWarn = true;
            }
            togglePrevious(true);
            toggleNext(true);
            showTaskId();
        }
    }

    function reConfigSteps(hasTaskId) {
        if(hasTaskId){
            let currentIndex = top.gl_wizard.data("state").currentIndex;
            if (top.gl_steps_current[currentIndex + 1] == Task_Complete) {
                top.gl_steps_current.splice(currentIndex + 1, 0, Staged_Task);
            }
            configSteps(top.gl_steps_current);
            Staged_Task.setSkipRepoter(true);
        } else {
            let currentIndex = top.gl_wizard.data("state").currentIndex;
            if (top.gl_steps_current[currentIndex + 1] == Staged_Task) {
                top.gl_steps_current.splice(currentIndex + 1, 1);
            }
            configSteps(top.gl_steps_current);
        }
    }

    function showTaskId(){
        var applyTimeArg = $('#ApplyTimeOption').prop("value");
        if(!up_isbundle){
            return;
        }
        var content = null;

        if(top.fileExists(top.getSupportFile("flashResult"))) {
            content = top.readTextFile(top.getSupportFile("flashResult"));
            if (content != null) {
                var dom = ezJsLib.XmlDom.parse(content);
                let taskId = ezJsLib.XmlDom.getValueByTag("TASKID", dom);
                let applytime = ezJsLib.XmlDom.getValueByTag("APPLYTIME", dom);
                document.getElementById("ue-taskid").innerText = taskId;
                if(taskId != null && taskId.length > 0){
                    $("#ue-taskid").parent().show();
                    Staged_Task.setTaskId(taskId);
                    reConfigSteps(true);
                } else {
                    Staged_Task.setTaskId("");
                    reConfigSteps(false);
                }
            }
        }
    }

    function needPrereqWarn() {
        var content = null;
        var res = false;

        if(top.fileExists(top.getSupportFile("updateResult", "oneCli"))) {
            content = top.readTextFile(top.getSupportFile("updateResult", "oneCli"));
            if (content != null) {
                var dom = ezJsLib.XmlDom.parse(content);
                var total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);
                var res_code;
                var prereq_code = "1703";
                for (var i = 0; i < total; i++) {
                    res_code = ezJsLib.XmlDom.getValueByTagAndIndex("RESCODE", dom, i);
                    if (res_code === prereq_code) {
                        res = true;
                        break;
                    } else {
                        res = false;
                    }
                }
            }
        }

        return res;
    }

    function createDetailTable(dom) {
        var table = document.getElementById('up_progress_table');
        var mt, os, total;  
        mt = top.gl_current_mt;
        os = top.gl_current_os_d;
        // arch = top.gl_current_arch_d;
        // for non-multiserver case, the first element is target mt
        if (top.gl_OOB_Params.Enabled) mt = top.gl_mt_list[0];

        total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);

        document.getElementById("up_progress").style.display = "";
        table.style.visibility = "visible";
        /************ Why the following method does not work on IE? Include <td> in the <tr>?*************/
        /*var con = "<td colspan=\"2\" class='EntityTableCell2'>Machine-Type=\""
                    + mt + "\", OS="
                    + os + "</td>";
        alert(con);
        table.insertRow(-1).innerHTML = con;*/

        var newCell = table.insertRow(-1).insertCell(-1);
        newCell.colSpan = 4;
        newCell.className = "EntityTableCell2";
        if (top.gl_uxlite_bootable == "1") {
            newCell.innerHTML = "Machine-Type=\"" + mt + "\"";
        } else if (top.gl_OOB_Params.Enabled) {
            newCell.innerHTML = "Remote Machine-Type=\"" + mt + "\"";
        } else {
            // newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os + " (" + arch + ")";
            newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os;
        }
        up_total = parseInt(total);
        for (var i = 0; i < total; i++) {
            //default consider that its a full xml file, including all nodes
            var nameValue, reboot, statusValue, errorMsg, updateId, CompValue, resultValue, rclevel;
            nameValue = ezJsLib.XmlDom.getValueByTagAndIndex("NAME", dom, i);
            reboot = ezJsLib.XmlDom.getValueByTagAndIndex("REBOOT", dom, i);
            errorMsg = ezJsLib.XmlDom.getValueByTagAndIndex("ERRORMESSAGE", dom, i);
            updateId = ezJsLib.XmlDom.getValueByTagAndIndex("UPDATEID", dom, i);
            CompValue = ezJsLib.XmlDom.getValueByTagAndIndex("COMPONENT", dom, i);
            resultValue = ezJsLib.XmlDom.getValueByTagAndIndex("RESULT", dom, i);
            statusValue = ezJsLib.XmlDom.getValueByTagAndIndex("STATUS", dom, i);
            statusValue = ezJsLib.XmlDom.getStatus(statusValue);
            rclevel = ezJsLib.XmlDom.getValueByTagAndIndex("RCLEVEL", dom, i);
            // Check whether uEFI update succeed.
            var pos = CompValue.indexOf("UEFI")
            if (pos != -1) {
                top.gl_isValidUefiUpdate = true;//fix coverity issue 46956
            }

            //add a new row
            var newRow = table.insertRow(-1);

            var newCell1 = newRow.insertCell(-1);
            newCell1.innerHTML = nameValue;
            newCell1.title = nameValue;
            newCell1.className = "EntityTableCell";

            /*
            var newCell4 = newRow.insertCell(-1);
            newCell4.innerHTML = newVersion;
            newCell4.title = newVersion;
            newCell4.className = "EntityTableCell";
            */

            var newCell6 = newRow.insertCell(-1);
            if (reboot.indexOf("No") != -1) {
                newCell6.innerHTML = reboot;
            } else {
                newCell6.innerHTML = "Required";
            }
            newCell6.title = reboot;
            newCell6.className = "EntityTableCell";

            var newCell7 = newRow.insertCell(-1);
            newCell7.title = statusValue;
            newCell7.className = "EntityTableCell";
            if (statusValue == "Successfully Installed") {
                newCell7.innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
            } else if (statusValue == "Running") {
                newCell7.innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
            } else if (statusValue == "Not Started") {
                newCell7.innerHTML = "<img src='images/statusStopped_obj16.gif'>" + statusValue;
            } else {
                var values = new Array();
                filterStatusValue(values, statusValue);
                if (values.length == 3) {
                    newCell7.title = values[2];
                    if (values[0] == "Not Applicable") {
                        newCell7.innerHTML = "<img src='images/statusInformation_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.HardwareNotPresent") + "</a>";
                        up_flashResult |= 0x2;
                    } else {
                        newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.More") + "</a>";
                        up_flashResult |= 0x1;
                    }
                } else if (values.length == 1) {
                    if (errorMsg == "") {
                        table.rows[up_package_index + 2].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0];
                        up_flashResult |= 0x1;
                    } else {
                        newCell7.title = errorMsg;
                        newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + errorMsg + "');\">" + $.i18n.prop("UpdateExec.FailMsg") + "</a>";
                        up_flashResult |= 0x1;
                    }
                } else {
                    switch (rclevel) {
                        case '0': // info should not be here, display critical icon
                            newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x1;
                            break;
                        case '1': // error
                            newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x1;
                            break;
                        case '2': // warning
                            newCell7.innerHTML = "<img src='images/statusWarning_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x2;
                            break;
                        default:
                            newCell7.innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            up_flashResult |= 0x1;
                            break;
                    }
                }
            }
            // add new column "Result"
            // 20161115 by chenhao
            var newCell8 = newRow.insertCell(-1);
            if (!resultValue || resultValue == "") {
                // do nothing
            } else {
                newCell8.innerHTML = resultValue;
                newCell8.title = resultValue;
            }
            newCell8.className = "EntityTableCell";
        }
    }

    function updateStatusAndRebootCell(row, iconPath, statusValue, rebootValue) {
        row.cells[2].innerHTML = iconPath + statusValue;
        row.cells[2].title = statusValue;
        row.cells[1].title = rebootValue;
        row.cells[1].innerHTML = rebootValue;
    }

    function updateDetailTable(dom, up_running_cache) {
        var table = document.getElementById('up_progress_table');
        var root = dom.documentElement;
        var nodes = root.getElementsByTagName("PACKAGE");
        var finishCount = 0;
        for(var nodeIndex = 0; nodeIndex < nodes.length; nodeIndex++) {
            if(!top.gl_OOB_Params.Enabled && up_isGrantly) {
                var statusNodes = nodes[nodeIndex].getElementsByTagName("STATUS");
                var msgNodes = nodes[nodeIndex].getElementsByTagName("ERRORMESSAGE");
                var errorMsg = "";
                var resultNodes = nodes[nodeIndex].getElementsByTagName("RESULT");
                var resultMsg = "";
                var rclevelNodes = nodes[nodeIndex].getElementsByTagName("RCLEVEL");
                var rclevel = null;
                if (msgNodes[0]) {
                    if (msgNodes[0].childNodes[0]) {
                        errorMsg = msgNodes[0].childNodes[0].nodeValue;
                    }
                }
                if (resultNodes[0]) {
                    if (resultNodes[0].childNodes[0]) {
                        resultMsg = resultNodes[0].childNodes[0].nodeValue;
                    }
                    if (!resultMsg || resultMsg == "") {
                        // do nothing
                    } else {
                        table.rows[nodeIndex + 2].cells[3].title = resultMsg;
                        table.rows[nodeIndex + 2].cells[3].innerHTML = resultMsg;
                    }
                }
                if (rclevelNodes[0]) {
                    if (rclevelNodes[0].childNodes[0]) {
                        rclevel = resultNodes[0].childNodes[0].nodeValue;
                    }
                }
                if (statusNodes[0]) {
                    if (statusNodes[0].childNodes[0]) {
                        var statusValue = ezJsLib.XmlDom.getStatus(statusNodes[0].childNodes[0].nodeValue);
                        table.rows[nodeIndex + 2].cells[2].title = statusValue;
                        if (statusValue == "Not Started") {
                            //do nothing, keep original table
                            if (!up_running_cache) 
                                finishCount++;
                        } else if (statusValue == "Running") {
                            if (!up_running_cache) {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + $.i18n.prop("UpdateExec.NotFinish");
                                up_flashResult |= 0x1;
                                finishCount++;
                            } else {
                                table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/progress_anim2_small.gif'>" + statusValue;
                            }
                        } else if (statusValue == "Successfully Installed") {
                            table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusSuccess_obj16.gif'>" + statusValue;
                            finishCount++;
                        } else {
                            //table.rows[nodeIndex + 2].cells[3].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                            var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", nodes[nodeIndex]);
                            var values = new Array();
                            filterStatusValue(values, statusValue);
                            if (values.length == 3) {
                                table.rows[nodeIndex + 2].cells[2].title = values[2];
                                if (values[0] == "Not Applicable") {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusInformation_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.HardwareNotPresent") + "</a>";
                                    up_flashResult |= 0x2;
                                } else {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + values[2] + "');\">" + $.i18n.prop("UpdateExec.More") + "</a>";
                                    up_flashResult |= 0x1;
                                }
                            } else if (values.length == 1) {
                                if (errorMsg == "") {
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0];
                                    up_flashResult |= 0x1;
                                } else {
                                    table.rows[nodeIndex + 2].cells[2].title = errorMsg;
                                    table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + values[0] + " <a href=\"javascript:void 0\" onclick=\"alert('" + errorMsg + "');\">" + $.i18n.prop("UpdateExec.FailMsg") + "</a>";
                                    up_flashResult |= 0x1;
                                }
                            } else {
                                switch (rclevel) {
                                    case '0': // info should not be here, display critical icon
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x1;
                                        break;
                                    case '1': // error
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x1;
                                        break;
                                    case '2': // warning
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusWarning_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x2;
                                        break;
                                    default:
                                        table.rows[nodeIndex + 2].cells[2].innerHTML = "<img src='images/statusCritical_obj16.gif'>" + statusValue;
                                        up_flashResult |= 0x1;
                                        break;
                                }
                            }
                            finishCount++;
                        }
                    }
                }
            } else {    // for OOB and Purley case: add by chenhao: 20161101
                var statusNodes = nodes[nodeIndex].getElementsByTagName("STATUS");
                var resultNodes = nodes[nodeIndex].getElementsByTagName("RESULT");
                var rcNodes = nodes[nodeIndex].getElementsByTagName("RCODE");
                var rebootNodes = nodes[nodeIndex].getElementsByTagName("REBOOT");
                var rclevelNodes = nodes[nodeIndex].getElementsByTagName("RCLEVEL"); // 0: info 1: error 2: warning
                var statusValue, resultValue, rcValue, rebootValue, rclevel;
                try {
                    statusValue = statusNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    statusValue = "";
                }
                try {
                    resultValue = resultNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    resultValue = "";
                }
                try {
                    rebootValue = rebootNodes[0].childNodes[0].nodeValue;
                } catch (e) {
                    rebootValue = "";
                }
                rebootValue = top.reboot_decode(rebootValue.toString());
                try {
                    rcValue = rcNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    rcValue = 0;
                }
                try {
                    rclevel = rclevelNodes[0].childNodes[0].nodeValue;
                } catch(e) {
                    rclevel = "";
                }
                /*
                if (statusValue) {
                    table.rows[nodeIndex + 2].cells[2].title = statusValue;
                    table.rows[nodeIndex + 2].cells[2].innerHTML = statusValue;
                }
                if (rebootValue) {
                    table.rows[nodeIndex + 2].cells[1].title = rebootValue;
                    table.rows[nodeIndex + 2].cells[1].innerHTML = rebootValue;
                }
                */
                    if (!resultValue || resultValue == "") {         // no result value ==> the update of the package is not finished
                    if (rcValue == 0 || rcValue == ONECLIRESULT_TASK_STAGED) {
                        if (!up_running_cache) {
                            updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                            up_flashResult |= 0x1;
                            finishCount++;
                        } else {
                            // For those packages that are not the one being installed, if its status is "Ready", change it to "Not Started"
                            // show stopped icon
                            if (statusValue == "Ready" && nodeIndex != finishCount) {
                                statusValue = "Not Started";
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusStopped_obj16.gif'>", statusValue, rebootValue);
                            } else {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/progress_anim2_small.gif'>", statusValue, rebootValue);
                            }
                        }
                    } else {
                        updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                        up_flashResult |= 0x1;
                    } 
                } else {
                    table.rows[nodeIndex + 2].cells[3].innerHTML = resultValue;
                    table.rows[nodeIndex + 2].cells[3].title = resultValue;
                    switch (rclevel) {
                        case '0': // info
                            if (rcValue == 0 || rcValue == ONECLIRESULT_TASK_STAGED) { // regard ONECLIRESULT_TASK_STAGED as success result
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusSuccess_obj16.gif'>", statusValue, rebootValue);
                            } else {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                                up_flashResult |= 0x1;
                            }
                            break;
                        case '1': // error
                            updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                            up_flashResult |= 0x1;
                            break;
                        case '2': // warning
                            updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusWarning_obj16.gif'>", statusValue, rebootValue);
                            up_flashResult |= 0x2;
                            break;
                        default: // if RCLEVEL is not defined or RCLEVEL is empty
                            if (rcValue == 0 || rcValue == ONECLIRESULT_TASK_STAGED) {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusSuccess_obj16.gif'>", statusValue, rebootValue);
                            } else {
                                updateStatusAndRebootCell(table.rows[nodeIndex + 2], "<img src='images/statusCritical_obj16.gif'>", statusValue, rebootValue);
                                up_flashResult |= 0x1;
                            }
                            break;
                    }
                    finishCount++;
                }
            }
        }
        up_package_index = finishCount;
    }

    /*
     * Filter status value and sort "Install did not succeed" and other detail message.
     */
    function filterStatusValue(values, statusValue) {
        var criterion = "Install did not succeed";
        var pos = statusValue.indexOf(criterion);
        if (pos != -1) {
            values.push(criterion);
            if (statusValue.length > criterion.length) {
                values.push("Error Message");
                values.push(statusValue.substring(pos + criterion.length + 1, statusValue.length + 1));
            }
        } else {
            var criterion2 = "Not Applicable";
            var pos2 = statusValue.indexOf(criterion2);
            if (pos2 != -1) {
                values.push(criterion2);
                if (statusValue.length > criterion2.length) {
                    values.push("Update Message");
                    values.push(statusValue.substring(pos2 + criterion2.length + 1, statusValue.length + 1));
                }
            }
        }
    }

    function updateProgressBar(running) {
        if ((up_package_index + 1) > up_total) {
            if (!running) {
                return;
            } else {
                if (waitForComplete < 6) {
                    waitForComplete++;
                    return;
                } else {
                    document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.CollectData");
                    document.getElementById("progressSectionExec").style.display = "none";
                    document.getElementById("progressImageExec").style.marginTop = "-10px";
                }
            }
        } else {
            document.getElementById("upMsg").innerHTML = $.i18n.prop("UpdateExec.Updating") + " " + (up_package_index + 1) + " of " + up_total;
            var percentage = formatData((1 - (up_package_index + 1) / up_total) * 100) + "%";
            document.getElementById("installProgress").style.marginRight = percentage;
        }
    }

    //display messages from common_result.xml
    function getCommonResult() {
        var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, resultError;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            resultError = false;
            if (resultDom.documentElement.getElementsByTagName("ERRORCODE").length > 0) {
                resultError = true;
                var errorCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", resultDom.documentElement);
                if (errorCode == 0 || errorCode == ONECLIRESULT_TASK_STAGED) {
                    resultError = false;
                }
            }
            /* if (resultError) {
                complete(0, resultMsg);
            } else if (resultMsg.indexOf("failed") != -1) {
                complete(2, resultMsg);
            } else {
                complete(1, resultMsg);
            } */
            if (resultError) {
                if (up_flashResult & 0x1) { // error
                    complete(1, resultMsg);
                } else if (up_flashResult & 0x2) { // warning
                    complete(2, resultMsg);
                }
            } else {
                complete(0, resultMsg);
            }
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
        } else {
            complete(1, top.getComErrMsg());
        }
    }

    function complete(c, msg) {
        switch (c) {
            case 0: // info
                document.getElementById("up_status").innerHTML = "<img src=\"images/statusSuccess.gif\"> <span style=\"margin-left:36px;\" id=\"upMsg\">";
                var pos = msg.indexOf("\n");
                if (pos != -1) {
                    document.getElementById("upMsg").innerHTML = "<h3 id=\"upMsgContent1\"></h3>";
                    if (pos != msg.length - 1) {
                        document.getElementById("upMsg").innerHTML = "<h3 id=\"upMsgContent1\"></h3><br><p id=\"upMsgContent2\"></p>";
                        document.getElementById("upMsgContent2").innerText = msg.substring(pos + 1);
                    }
                    document.getElementById("upMsgContent1").innerText = msg.substring(0, pos);
                } else {
                    document.getElementById("up_status").innerHTML = "<img src=\"images/statusSuccess.gif\"> <span style=\"margin-left:36px;\" id=\"upMsg\">";
                    // Don't use innerHTML = msg, because there are illegal characters in msg such as < >
                    document.getElementById("upMsg").innerText = msg;
                }
                break;
            case 1: // error
                $("#up_status").hide();
                $("#errMsgExec").show();
                $("#errMsgExec2").html($.i18n.prop("UpdateExec.ErrorInstall") + "<br>" + $.i18n.prop("UpdateExec.ErrorMsg", msg) + "<br>" + $.i18n.prop("UpdateExec.MoreInfo", top.getSupportDir()));
                // document.getElementById("up_status").style.display = "none";
                // document.getElementById("errMsgExec").style.display = "block";
                // document.getElementById("errMsgExec2").innerHTML = "Error(s) occured while installing! <br>Error message: " + msg;
                break;
            case 2: // warning
                $("#up_status").hide();
                $("#warnMsgExec").show();
                $("#warnMsgExec2").html(msg);
                // document.getElementById("up_status").style.display = "none";
                // document.getElementById("warnMsgExec").style.display = "block";
                // document.getElementById("warnMsgExec").childNodes[0].src = "images/statusWarning.png";
                // document.getElementById("warnMsgExec2").innerHTML = msg;
                break;
            default:
                break;
        }
        clearInterval(up_progress_timer);
        waitForComplete = 0;
        //We consider the user has completed his behavior, so they can't go previous page.
        //top.enableButton("nextButton", true);
        //top.enableButton("previousButton", true);
        if (top.getEnv("BOMC_UNATTENDED_MODE")) {
            top.Exit(false);
            return;
        }
    }

    function toggleEnableBundle() {
        if ($("#EnableBundleCheckbox").prop("checked")) {
			printLog("INFO","check box 'Bundle' checked.");
			$("#ApplyTimeDiv").show();
			up_isbundle = true;
		} else {
			printLog("INFO","check box 'Bundle' unchecked.");
			$("#ApplyTimeDiv").hide();
			up_isbundle = false;
		}
    }

    function changeApplyTimeOpt() {
        var applytime = $('#ApplyTimeOption').prop("value");
        printLog('INFO','[Update_Execution.html:ApplyTimeOption] Apply Time: ' + applytime);
        if (applytime == "OnReset") {
            $('#InstructionalForOnReset').show();
            $('#InstructionalForImmediate').hide();
            $('#InstructionalForOnStartUpdateRequest').hide();
        } else if (applytime == "Immediate") {
            $('#InstructionalForOnReset').hide();
            $('#InstructionalForImmediate').show();
            $('#InstructionalForOnStartUpdateRequest').hide();
        } else if (applytime == "OnStartUpdateRequest") {
            $('#InstructionalForOnReset').hide();
            $('#InstructionalForImmediate').hide();
            $('#InstructionalForOnStartUpdateRequest').show();
        }
    }

    function onCopyTaskID(){
        let taskid = document.getElementById("ue-taskid").innerText;
        window.copyToClipBoard(taskid);
    }

    return {
        init: up_init,
        backEntry: up_backEntry,
        index: 0,
        name: "Update_Execution",
        nextAction: function() { 
            printLog("INFO","Next was clicked.");
            clearInterval(up_progress_timer);
            return true;
        },
        previousAction: function() {
            printLog("INFO","Previous was clicked.");
            clearInterval(up_progress_timer);
            toggleNext(true);
            return true;
        },     
        confirmUpdate: confirmUpdate, 
        toggleEnableBundle: toggleEnableBundle,
        changeApplyTimeOpt: changeApplyTimeOpt,
        startCopy: startCopy,
        onCopyTaskID: onCopyTaskID,
        importId: '#import_update_execution',
        selectorId: '.update_execution',
        title: "Navi.UpdateExecution",
        localizedTitle: tr("Navi.UpdateExecution"),
        needRefresh: true,
        ExpandMultiResult: ExpandMultiResult,
        CollapseMultiResult: CollapseMultiResult
    }

}();
