// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Update_Comparison = function() {

    var co_navigation_timer;
    var co_navigation_timer_sec;

    var co_total;
    var CONST_TIME;
    var is_in_comparison;

    var headerTable;

    var ONECLI_ACQUIRE_PARTPACKAGES_FAILURE = 101;

    // if user clicks the cancel button, the value will be true
    var userCancel = false;

    // missing packages while downloading meta data
    var missingPacks;
    var missingPacksArray;

    // var addPrereqCount;
    var addPrereqArray;
    // prereq not shown in the list, but maybe exists in the xml, such as UTIL
    var addPrereqArrayNotFound;

    var selArray = new Array();
    var last_selArray = new Array();

    var prereq_arr = new Array();

    // the current macro package
    var curMacroPkg = "";
    var curMacroPkgIndex = -1;
    // is current updateid belongs to any macro package
    var isMacroTypePkg = false;
    // [index of macro, sum of micro]
    var macroMap = new Map();
    // [index of micro, sum of child]
    var childMap = new Map();

    // set of packages get from compare xml except UTIL
    var xmlPkgs = new Array();
    var xmlPkgsUTIL = new Array();

    // [{
    //     ip:"x.x.x.x", errorCode:"", errorMsg:"", isHasParent:true,
    //     packages:[{
    //         id:"lnvgy_fw_uefi_xxx_anyos_32-64",
    //         parentID:"", pkgXML:"", inventoryJSON:"", signatureJSON:"", payload:"",
    //         devices:[{
    //             unit:"", slot:"", latest:"", current:""
    //         }]
    //     }]
    // }]
    let serversResult = new Array();

    function co_backEntry() {
        document.getElementById("cmpMsg").style.display = "none"; // hide the init message
        document.getElementById("acqMsgInCmp").style.display = "none";
        document.getElementById("errMsg").style.display = "none";
        top.toggleNext(true);
        top.togglePrevious(true);
    }

    function parsePkgVersion(newVersion) {
        var firstSpaceIndex, lastSpaceIndex;
        firstSpaceIndex = newVersion.indexOf(" ");
        newVersion = newVersion.slice(firstSpaceIndex + 1);
        lastSpaceIndex = newVersion.indexOf(" ");
        newVersion = newVersion.slice(0, lastSpaceIndex);
        return newVersion;
    }

    function cancelCompare() {
        printLog("INFO","button 'Cancel' was clicked.");
        top.togglePrevious(true);
        top.toggleNext(false);
        $("#cmpMsg").css("display", "none");
        $("#acqMsgInCmp").css("display", "none");
        $("#beginBtn_compare").css("display", "block");
        $("#cancelBtn_compare").css("display", "none");

        if (getTaskName() == top.gl_isUpdate && !top.gl_OOB_Params.Enabled && !top.gl_uxlite_bootable) {
            if(osIsLinux()) {
                $("#showNoAdapterSection").hide();
            }
        }
        top.killOneCli();
        userCancel = true;
    }

    function continueCompare() {
        printLog("INFO","button 'Continue' was clicked.");
        $('#cancelBtn_compare').show();
        $('#retryBtn_compare').hide();
        $('#continueBtn_compare').hide();
        $('#showDetail').hide();
        $('#hideDetail').hide();
        $('#errMsg').hide();
        $('#acqMsgInCmp').hide();
        $('#cmpMsg').css("display", "block");
        $('#missDetailSection').empty();
        $('#missDetailSection').hide();
        startCompare(true);
    }

    function startCompare(success, error) {
        if (userCancel == true) return;
        acquire_running = false;    // acquire meta data finished
        top.saveMetaToLocal();
        if (!success) {
            $("#showNoAdapterSection").hide();
            // clean
            missingPacksArray = new Array();
            var resultMsg = " Failed to get package list. ";
            var commonContent;
            if (!top.fileExists(top.getSupportFile('commonResult'))) {
                complete(0, resultMsg);
                $("#cancelBtn_compare").hide();
                $("#beginBtn_compare").hide();
                $('#retryBtn_compare').show();
                top.togglePrevious(true);
            } else {
                commonContent = top.readTextFile(top.getSupportFile('commonResult'));
            }
            if (commonContent == null || commonContent == undefined || commonContent == '') {
                complete(0, resultMsg);
                $("#cancelBtn_compare").hide();
                $("#beginBtn_compare").hide();
                $('#retryBtn_compare').show();
                top.togglePrevious(true);
            } else {
                var commonDom = ezJsLib.XmlDom.parse(commonContent);
                resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", commonDom.documentElement);
                var errorCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", commonDom.documentElement);
                if (errorCode == ONECLI_ACQUIRE_PARTPACKAGES_FAILURE) {
                    missingPacks = true;
                    if (top.fileExists(top.getSupportFile('acquireResult'))) {
                        var acquireContent = top.readTextFile(top.getSupportFile('acquireResult'));
                        if (acquireContent != null && acquireContent != undefined && acquireContent != '') {
                            var acquireDom = ezJsLib.XmlDom.parse(acquireContent);
                            var total = ezJsLib.XmlDom.getValueByTag("TOTAL", acquireDom);
                            for (var i = 0; i < total; i++) {
                                try {
                                    var pack = ezJsLib.XmlDom.getNodeByTagAndIndex("PACKAGE", acquireDom, i);
                                    var nameValue = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                                    var statusValue = ezJsLib.XmlDom.getValueByTagFromNode("STATUS", pack);
                                    if (statusValue == 'Error') {
                                        missingPacksArray.push(nameValue);
                                    }
                                } catch (e) {
                                    continue;
                                }
                            }
                        }
                    }
                    if (top.gl_OOB_Params.Enabled) {
                        if (top.fileExists(top.getSupportFile('acquireResult2'))) {
                            var acquireContent = top.readTextFile(top.getSupportFile('acquireResult2'));
                            if (acquireContent != null && acquireContent != undefined && acquireContent != '') {
                                var acquireDom = ezJsLib.XmlDom.parse(acquireContent);
                                var total = ezJsLib.XmlDom.getValueByTag("TOTAL", acquireDom);
                                for (var i = 0; i < total; i++) {
                                    try {
                                        var pack = ezJsLib.XmlDom.getNodeByTagAndIndex("PACKAGE", acquireDom, i);
                                        var nameValue = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                                        var statusValue = ezJsLib.XmlDom.getValueByTagFromNode("STATUS", pack);
                                        if (statusValue == 'Error') {
                                            missingPacksArray.push(nameValue);
                                        }
                                    } catch (e) {
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                    if (missingPacksArray.length == 0) {
                        missingPacks = false;
                    }
                    // startCompare(true);
                    complete(0, resultMsg);
                    $("#cancelBtn_compare").hide();
                    $("#retryBtn_compare").show();
                    $('#beginBtn_compare').hide();
                    $('#continueBtn_compare').show();
                    $('#missDetailSection').empty();
                    if (missingPacks) {
                        var missingDetail = '';
                        for (var i = 0; i < missingPacksArray.length; i++) {
                            // missingDetail += missingPacksArray[i] + '\n';
                            missingDetail += missingPacksArray[i] + '<br>';
                        }
                        $('#missDetailSection').html(missingDetail);
                        // $('#missDetailSection').show();
                        $('#showDetail').show();
                    }
                    top.togglePrevious(true);
                } else {
                    complete(0, resultMsg);
                    $("#cancelBtn_compare").hide();
                    $("#beginBtn_compare").hide();
                    $('#retryBtn_compare').show();
                    top.togglePrevious(true);
                }
            }
        } else {
            if (!top.gl_multi_server_management) {
                $('#acqMsgInCmp').hide();
                $('#cmpMsg').css("display", "block");
                is_in_comparison = true;    //start to compare

                // Preparation
                deleteFile(top.getSupportFile("compareResult", "oneCli"));
                deleteFile(top.getSupportFile("commonResult"));

                // new implementation

                var args = new Array();
                args.push(top.getSystemFile("oneCli"));
                args.push("update");
                args.push("compare");

                // Bug 91184 - [BoMC10.4.3] Need add "--type fw" in compare and flash command in updategui when run in MCP and SaLIE
                if (top.gl_uxlite_bootable) {
                    args.push("--type");
                    args.push("fw");
                    args.push("--scope");
                    args.push("latest");
                } else {
                    if (!top.gl_isUXSP) {
                        args.push('--scope');
                        args.push('latest');
                    } else {
                        args.push('--scope');
                        args.push('uxsp');
                    }
                }
                if (top.gl_OOB_Params.Enabled) {
                    args.push("--imm");
                    args.push(SplitFullConnInfo());
                    args.push("--never-check-trust");
                }

                // inband parameters
                // add by chenhao at 20170606
                if (top.gl_Inband_Params.Enabled && top.gl_Inband_Params.UserInput) {
                    if (top.gl_Inband_Params.IMM_UserName != "" && top.gl_Inband_Params.IMM_UserName != null && top.gl_Inband_Params.IMM_UserName != undefined
                    && top.gl_Inband_Params.IMM_Password != "" && top.gl_Inband_Params.IMM_Password != null && top.gl_Inband_Params.IMM_Password != undefined) {
                        args.push("--bmc-username");
                        args.push(top.gl_Inband_Params.IMM_UserName);
                        args.push("--bmc-password");
                        args.push(top.gl_Inband_Params.IMM_Password);
                    }
                    if (top.gl_Inband_Params.IMM_Port != "" && top.gl_Inband_Params.IMM_Port != null && top.gl_Inband_Params.IMM_Port != undefined) {
                        args.push("--bmc-cim-port");
                        args.push(top.gl_Inband_Params.IMM_Port);
                    }
                    if (top.gl_Inband_Params.REST_Port != "" && top.gl_Inband_Params.REST_Port != null && top.gl_Inband_Params.REST_Port != undefined) {
                        args.push("--bmc-rest-port");
                        args.push(top.gl_Inband_Params.REST_Port);
                    }
                }
                
                if (!top.gl_showNoAdapters) {
                    args.push("--checkdevice");
                }
                
                args.push("--dir");
                args.push(top.gl_workingDir);
                args.push(...add_output_log5());
                if (top.gl_optionBackup == true) {
                    args.push("--backup");
                }
                
                togglePrevious(false);
                toggleNext(false);

                printLog("INFO","run command:" + getRunProgramCommend(args));
                runProgram(args, null, showStatus_co);
            } else {
                // Multiupdate case
                $('#acqMsgInCmp').hide();
                $('#cmpMsg').css("display", "block");
                is_in_comparison = true;    //start to compare
                togglePrevious(false);
                toggleNext(false);
                let progress = new Array(Server_Pool.selectedServerList.length).fill(0);

                // new implementation
                let args = new Array();
                args.push(top.getSystemFile("oneCli"));
                args.push("update");
                args.push("compare");
                args.push('--scope');
                if (!top.gl_isUXSP) {
                    args.push('latest');
                } else {
                    args.push('uxsp');
                }
                args.push("--dir");
                args.push(top.gl_workingDir);

                for (let i = 0; i < Server_Pool.selectedServerList.length; ++i) {
                    deleteFile(top.getSupportFile("compareResult", "oneCli", Server_Pool.selectedServerList[i].ip));
                    deleteFile(top.getSupportFile("commonResult", null, Server_Pool.selectedServerList[i].ip));
                    let realArg = args.concat();
                    realArg.push("--imm");
                    realArg.push(SplitFullConnInfo(Server_Pool.selectedServerList[i]));
                    realArg.push("--never-check-trust");
                    realArg.push(...add_output_log5(Server_Pool.selectedServerList[i].ip));
                    printLog("INFO","run command:" + getRunProgramCommend(realArg));
                    runProgram(realArg, null, () => {
                        progress[i] = 1;
                    });
                }

                let timer = setInterval(() => {
                    if (userCancel == true) {
                        clearInterval(timer);
                    } else if (progress.filter(n => n == 1).length == progress.length) {
                        clearInterval(timer);
                        showStatus_multi();
                    }
                }, 1000);
            }
        }
        
    }

    // #region MULTI COMPARE FUNCTIONS
    function readCompareResult() {
        serversResult = new Array();
        for (let _selectedServer of Server_Pool.selectedServerList) {
            let _errorCode = null;
            let _resultMsg = null;
            let _isHasParent = false;
            let _packages = new Array();
            // Read compare result
            let _cmpResult = top.readTextFile(top.getSupportFile("compareResult", "oneCli", _selectedServer.ip));
            if (_cmpResult != null) {
                let Slot_Type_String = new Array();
                let _cmpDom = ezJsLib.XmlDom.parse(_cmpResult);
                let _pkgCollection = _cmpDom.getElementsByTagName("PACKAGE");
                for (let i = 0; i < _pkgCollection.length; ++i) {
                    if (_pkgCollection[i].getElementsByTagName("SELECTED")[0].textContent == "1") {
                        let _devices = new Array();
                        let _childUpdateCollection = _pkgCollection[i].getElementsByTagName("CHILDUPDATE");
                        for (let j = 0; j < _childUpdateCollection.length; ++j) {
                            if (ezJsLib.XmlDom.getValueByTagFromNode("CSELECTED", _childUpdateCollection[j]) == "1") {
                                // Deal with slot, change slotType from number to a readable text
                                let slot;
                                let slotNum = ezJsLib.XmlDom.getValueByTagFromNode("CSLOTNUM", _childUpdateCollection[j], "N/A");
                                let slotType = ezJsLib.XmlDom.getValueByTagFromNode("CSLOTTYPE", _childUpdateCollection[j], "N/A");
                                if (slotNum != "N/A" && !isNaN(slotNum)) {
                                    if (slotType == "N/A" || isNaN(slotType)) {
                                        slot = slotNum;
                                    } else if (slotType === 0 || slotType === "0") {
                                        slot = "Onboard";
                                    } else {
                                        if (Slot_Type_String.length == 0) {
                                            for (let slotName of _cmpDom.getElementsByTagName("SLOTNAME")) {
                                                Slot_Type_String.push(slotName.textContent);
                                            }
                                        }
                                        slot = Slot_Type_String[slotType] + " " + slotNum;
                                    }
                                } else {
                                    slot = "N/A";
                                }
                                _devices.push({
                                    unit:    ezJsLib.XmlDom.getValueByTagFromNode("CADAPTERNAME", _childUpdateCollection[j], "N/A"),
                                    slot:    slot,
                                    latest:  ezJsLib.XmlDom.getValueByTagFromNode("CNEWVERSION", _childUpdateCollection[j], "N/A"),
                                    current: ezJsLib.XmlDom.getValueByTagFromNode("CINSTALLED", _childUpdateCollection[j], "N/A")
                                });
                            }
                        }
                        let _parentID = ezJsLib.XmlDom.getValueByTagFromNode("MACROPACKAGEID", _pkgCollection[i], "");
                        if (_parentID != "") {
                            _isHasParent = true;
                        }
                        _packages.push({
                            id:            ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", _pkgCollection[i], "N/A"),
                            parentID:      _parentID,
                            pkgXML:        ezJsLib.XmlDom.getValueByTagFromNode("PACKAGEXML", _pkgCollection[i], ""),
                            inventoryJSON: ezJsLib.XmlDom.getValueByTagFromNode("INVENTORYJSON", _pkgCollection[i], ""),
                            signatureJSON: ezJsLib.XmlDom.getValueByTagFromNode("SIGNATUREJSON", _pkgCollection[i], ""),
                            payload:       ezJsLib.XmlDom.getValueByTagFromNode("PAYLOADFILE", _pkgCollection[i], ""),
                            devices:       _devices
                        });
                    }
                }
            }
            // Read common result
            let _commonResult = top.readTextFile(top.getSupportFile("commonResult", null, _selectedServer.ip));
            if (_commonResult != null) {
                let commonResultDom = ezJsLib.XmlDom.parse(_commonResult);
                _errorCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", commonResultDom.documentElement, null);
                _resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", commonResultDom.documentElement, null);
            }
            if (_errorCode === null || _errorCode === undefined) {
                _errorCode = "N/A";
            }
            if (_resultMsg === "" || _resultMsg === null || _resultMsg === undefined) {
                _resultMsg = $.i18n.prop("UpdateComparison.UnknownError");
            }
            serversResult.push({
                ip:          _selectedServer.ip,
                errorCode:   _errorCode,
                errorMsg:    _resultMsg,
                isHasParent: _isHasParent,
                packages:    _packages
            });
        }
    }
    function sortCompareResult() {
        function judgeStatus(server) {
            if (server.packages.length < 1) {
                if (server.errorCode === 0 || server.errorCode === "0") {
                    return 2;
                }
                return 3;
            } else {
                if (server.errorCode === 0 || server.errorCode === "0") {
                    return 0;
                }
                return 1;
            }
        }
        serversResult.sort((serverA, serverB) => {
            return judgeStatus(serverA) - judgeStatus(serverB);
        });
    }

    function updateCount(index, content) {
        let spans = _doc.getElementById(TITLE_PRE + index).getElementsByTagName("span");
        spans[0].innerHTML = content;
    }
    function ExpandMultiResult() {
        for (let i = 0; i < serversResult.length; ++i) {
            let index = "compare_" + serversResult[i].ip;
            let tableContentDiv = document.getElementById(TABLE_DIV_PRE + index);
            if (tableContentDiv && tableContentDiv.style.display == "none") {
                displayContent(index);
            }
        }
    }
    function CollapseMultiResult() {
        for (let i = 0; i < serversResult.length; ++i) {
            let index = "compare_" + serversResult[i].ip;
            let tableContentDiv = document.getElementById(TABLE_DIV_PRE + index);
            if (tableContentDiv && tableContentDiv.style.display != "none") {
                hideContent(index);
            }
        }
    }

    function showStatus_multi() {
        document.getElementById("cmpMsg").style.display = "none";
        document.getElementById("acqMsgInCmp").style.display = "none";
        document.getElementById("errMsg").style.display = "none";
        document.getElementById("buttonSection").style.display = "none";
        document.getElementById("missDetailSection").style.display = "none";
        document.getElementById("multicompare_tip").style.display = "block";
        document.getElementById("multicompare_expandbutton").style.display = "block";
        top.toggleNext(true);
        top.togglePrevious(true);

        readCompareResult();
        sortCompareResult();

        _doc = document;
        _details = _doc.getElementById("details_multicompare");
        _details.innerHTML = "";
        _details.style.display = "block";
        if (serversResult.filter(s => s.isHasParent == true).length > 0) {
            header = ["", tr("Updatable Unit"), tr("Slot"), tr("New Version"), tr("Installed Version"), tr("Update ID"), tr("Parent ID")];
        } else {
            header = ["", tr("Updatable Unit"), tr("Slot"), tr("New Version"), tr("Installed Version"), tr("Update ID")];
        }
        for (let server of serversResult)
        {
            let index = "compare_" + server.ip;
            createContent(server.ip, null, null, index, function createTitle (ip, mt, os, index, contentDiv) {
                let titleInnerHTML = new Array();
                titleInnerHTML.push("<div class='ContentTitleDiv' id='" + TITLE_PRE + index + "' onclick='toggleContent(this)'>");
                // The img is nonsense, just for compatiable with old code
                titleInnerHTML.push("<img>&nbsp;");
                titleInnerHTML.push(ip + " - <span></span>");
                titleInnerHTML.push("</div>");
                contentDiv.innerHTML = titleInnerHTML.join("");
            });
            if (server.packages.length < 1) {
                //content empty, unnecessary to create a table
                if (server.errorCode === 0 || server.errorCode === "0") {
                    updateTitle(index, "None");
                    updateCount(index, $.i18n.prop("UpdateComparison.NoUpdates"));
                } else {
                    updateTitle(index, "Error");
                    updateCount(index, "(" + server.errorMsg + ")");
                }
                continue;
            } else {
                showPlusIcon(index);
                if (server.errorCode === 0 || server.errorCode === "0") {
                    updateTitle(index, "Nopic");
                } else {
                    updateTitle(index, "Error");
                }
            }
            let countTableItems = 0;
            let table = createTable(index, "comparison");
            for (let pkg of server.packages) {
                let id = pkg.id;
                let parentID = pkg.parentID;
                for (let childUpdate of pkg.devices) {
                    let unit    = childUpdate.unit;
                    let slot    = childUpdate.slot;
                    let latest  = childUpdate.latest;
                    let current = childUpdate.current;
                    //add a new row
                    let newRow = table.insertRow(-1);
                    let newCell0 = newRow.insertCell(-1);
    
                    let newCell1 = newRow.insertCell(-1);
                    newCell1.innerHTML = unit;
                    newCell1.title = unit;
                    newCell1.className = "EntityTableCell";
    
                    let newCell2 = newRow.insertCell(-1);
                    newCell2.innerHTML = slot;
                    newCell2.title = slot;
                    newCell2.className = "EntityTableCell";
    
                    let newCell3 = newRow.insertCell(-1);
                    newCell3.innerHTML = latest;
                    newCell3.title = latest;
                    newCell3.className = "EntityTableCell";
                    
                    let newCell4 = newRow.insertCell(-1);
                    newCell4.innerHTML = current;
                    newCell4.title = current;
                    newCell4.className = "EntityTableCell";
    
                    let newCell5 = newRow.insertCell(-1);
                    newCell5.innerHTML = id;
                    newCell5.title = id;
                    newCell5.className = "EntityTableCell";

                    if (header.length == 7) {
                        let newCell6 = newRow.insertCell(-1);
                        newCell6.innerHTML = parentID;
                        newCell6.title = parentID;
                        newCell6.className = "EntityTableCell";
                    }

                    ++countTableItems;
                }
            }
            updateCount(index, countTableItems + " " + $.i18n.prop("Common.Updates"));
        }
        complete(1);
    }
    
    function co_collect_multi() {
        printLog("INFO","Next was clicked.");
        if (top.gl_isViaWeb) {
            // The difference between acquire list and compare result is package such as bmu
            // now deal with bmu in onecli, so acquire list is same with compare result
            Update_Comparison.acquireList = serversResult.concat();
            let updateIdSet = new Set();
            for (let server of serversResult) {
                for (let pkg of server.packages) {
                    updateIdSet.add(pkg.id);
                }
            }

            if (updateIdSet.size < 1) {
                uxlite_alert("No firmware needs to update on any server. You can close updateXpress directly.");
                return false;
            }
        }
        return true;
    }
    // #endregion MULTI COMPARE FUNCTIONS

    function clearAcqResultFiles() {
        deleteFile(top.getSupportFile("acquireResult"));
        var series = 2;
        // To avoid dead loop
        while(series<=100) {
            var tempFilename = top.getSupportFileBySeries("acquireResult", series)
            if(fileExists(tempFilename)) {
                deleteFile(tempFilename);
                series++;
            } else {
                break;
            }
        }
        deleteFile(top.getSupportFile("commonResult"));
    }

    function clearAcMeta() {
        if (top.fileExists(top.getSupportFile('acResultMeta'))) {
            top.deleteFile(top.getSupportFile('acResultMeta'));
        }
        if (top.fileExists(top.getSupportFile('acResult2Meta'))) {
            top.deleteFile(top.getSupportFile('acResult2Meta'));
        }
    }

    function startAcquireXML() {
        clearAcqResultFiles();
        clearAcMeta();
        var args = new Array();
        args.push(top.getSystemFile("oneCli"));
        args.push("update");
        args.push("acquire");
        args.push("--xml");
        args.push("--metaonly");

        if (!top.gl_isUXSP) {
            args.push('--scope');
            args.push('latest');
        } else {
            args.push('--scope');
            args.push('uxsp');
        }

        // set mt
        args.push("--mt");
        let mts = "";
        for (let mtype of top.gl_mt_list) {
            mts += mtype + ",";
        }
        args.push(mts.substring(0, mts.length - 1));

        // set os
        args.push("--ostype");
        if (top.gl_OOB_Params.Enabled) {
            args.push("platform");
        } else {
            args.push(top.gl_current_os);
        }

        //set proxy if there is
        args.push(...add_proxy_para());

        args.push("--dir");
        args.push(top.gl_workingDir);
        args.push(...add_output_log5());

        acquire_running = true;

        printLog("INFO","run command:" + getRunProgramCommend(args));
        runProgram(args, null, startCompare);
    }

    function startCompareProcess() {
        printLog("INFO","button 'Begin' was clicked.");

        if("1" == top.gl_uxlite_bootable || top.gl_Inband_Params.Enabled){
            enableUsbLan();
        }
        // init
        co_total = 0;
        CONST_TIME = 60;
        is_in_comparison = false;
        headerTable = null;
        userCancel = false;
        missingPacks = false;
        missingPacksArray = new Array();
        curMacroPkg = "";
        curMacroPkgIndex = -1;
        isMacroTypePkg = false;
        macroMap.clear();
        childMap.clear();
        xmlPkgs = new Array();
        xmlPkgsUTIL = new Array();

        headerTable = document.getElementById("co_progress_table_force_header");
        $("#cancelBtn_compare").show();
        $('#errMsg').hide();
        $('#retryBtn_compare').hide();
        $("#beginBtn_compare").hide();
        $('#continueBtn_compare').hide();
        $("#immIsPrereqWarning").hide();
        // $('#detailSection').hide();
        $('#showDetail').hide();
        $('#hideDetail').hide();
        $('#missDetailSection').empty();
        $('#missDetailSection').hide();
        top.toggleNext(false);
        top.togglePrevious(false);
        // for inband and oob case (except create repository case):
        // always get meta data first no matter it is UXSP or latest
        if (getTaskName() == top.gl_isUpdate && top.gl_isViaWeb && !top.gl_uxlite_bootable) {
            $("#acqMsgInCmp").css("display", "block");
            startAcquireXML();
        } else {
            $("#cmpMsg").css("display", "block");
            startCompare(true);
        }
    }

    function co_init() {
        printLog("INFO","Update Comparison page init.");

        $("#beginBtn_compare").css("display", "block");
        $("#cancelBtn_compare").css("display", "none");
        $("#immIsPrereqWarning").css("display", "none");
        $("#cmpMsg").css("display", "none");
        $("#acqMsgInCmp").css("display", "none");
        top.toggleNext(false);
        missingPacks = false;
        missingPacksArray = new Array();
        $('#missPackWarning').hide();
        $("#showNoAdapterSection").hide();
        $('#missDetailSection').empty();

        if (top.is_unattend() || top.is_autorun()) {
            $("#beginBtn_compare").click();
        } else {
            $('#beginBtn_compare').show();
        }
        top.gl_force = document.getElementById('enableForceUpdate').checked;
        $("#comp_showNoAdapterCheckBox").attr("checked", top.gl_showNoAdapters);
        if (top.gl_multi_server_management) {
            $("#showNoAdapterSection").hide();
        }

    }

    function osIsLinux(){
        var agent = navigator.userAgent.toLowerCase();
        if (agent.indexOf("win32") >= 0 || agent.indexOf("wow32") >= 0) {
          return false;
          }
        if (agent.indexOf("win64") >= 0 || agent.indexOf("wow64") >= 0) {
            return false;
        }
        return true;
      }

    function getScanResult(resultDom) {
        var modulesNode = ezJsLib.XmlDom.getChildNodeByTagFromNode("MODULES", resultDom.documentElement);
        var result = 0;
        var msg = "Success";
        // coverity 166810
        if (modulesNode != null && modulesNode != undefined) {
            console.log("Parse scan result")
            var t_index = 0;
            while (true) {
                var moduleNode = ezJsLib.XmlDom.getChildNodeByTagAndIndexFromNode("MODULE", modulesNode, t_index)
                if (moduleNode != null) {
                    t_index++;
                }
                else {
                    break;
                }
                var moduleName = ezJsLib.XmlDom.getValueByTagFromNode("NAME", moduleNode)
                console.log(moduleName)
                console.log(result)
                console.log(msg)
                if (moduleName.toLowerCase() == "scan") {
                    result = ezJsLib.XmlDom.getValueByTagFromNode("RETURNCODE", moduleNode)
                    msg = ezJsLib.XmlDom.getValueByTagFromNode("ERRORMESSAGE", moduleNode)
                    break;
                }
            }
        }
        return { result: result, msg: msg };
    }

    function showStatus_co(success, error) {
        if (userCancel == true) return;
        else {
            xmlPkgs = new Array();
            xmlPkgsUTIL = new Array();
            co_total = 0;
            var resultFile = top.readTextFile(top.getSupportFile("commonResult"));
            var resultDom, resultMsg, resultError, scanResult;
            if (resultFile != null) {
                resultDom = ezJsLib.XmlDom.parse(resultFile);
                resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
                scanResult = getScanResult(resultDom);
                console.log(JSON.stringify(scanResult))
                if (resultDom.documentElement.getElementsByTagName("ERROR").length > 0) {
                    resultError = true;
                    var errorContent = ezJsLib.XmlDom.getValueByTagFromNode("ERROR", resultDom.documentElement);
                    if (errorContent == "No") {
                        resultError = false;
                    }
                }
            } else {
                resultDom = '';
                resultMsg = '';
                resultError = true;
            }
            if (success == true) {
                if(resultError) {
                    complete(0, resultMsg);
                    top.toggleNext(false);
                    top.togglePrevious(true);
                    $('#retryBtn_compare').show();
                } else {
                    var table = document.getElementById('co_progress_table');
                    $("#co_progress_table_force_header").show();
                    var content;
                    if(top.fileExists(top.getSupportFile("compareResult", "oneCli"))) {
                        content = top.readTextFile(top.getSupportFile("compareResult", "oneCli"));    
                    } 
                    if (content == null) {
                        complete(0, $.i18n.prop("UpdateComparison.NoXMLFile"));
                        top.toggleNext(false);
                        top.togglePrevious(true);
                        $('#retryBtn_compare').show();
                        return;
                    }
                    var dom = ezJsLib.XmlDom.parse(content);

                    document.getElementById("cmpMsg").style.display = "none"; //hide the init message
                    document.getElementById("acqMsgInCmp").style.display = "none";
                    document.getElementById("errMsg").style.display = "none";
                    console.log("scanResult=" + scanResult.result);
                    if (parseInt(scanResult.result) === 0)
                    {
                        document.getElementById("compareWarning").style.display = "none";
                    }
                    else
                    {
                        document.getElementById("compareWarning").style.display = "block";
                        document.getElementById("compareWarningMsg").innerHTML = $.i18n.prop("UpdateComparison.CompareWarning") + scanResult.msg;
                    }

                    var mt, os, total, IsPartition;
                    mt = top.gl_current_mt;
                    os = top.gl_current_os_d;
                    // arch = top.gl_current_arch_d;
                    // for OOB case, need to get MT from remote machine
                    if (top.gl_OOB_Params.Enabled) mt = top.gl_mt_list[0];
                    total = ezJsLib.XmlDom.getValueByTag("TOTAL", dom);
                    IsPartition = ezJsLib.XmlDom.getValueByTagFromNode("ISPARTITION", dom);

                    headerTable.style.visibility = "visible";
                    table.style.display = "";
                    document.getElementById("tableDiv").style.display = "";

                    var newContentRow = headerTable.insertRow(-1);
                    var contentCheckBoxCell = newContentRow.insertCell(-1);
                    contentCheckBoxCell.colSpan = 1;
                    contentCheckBoxCell.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" id=\"all_checkbox\" onclick=\"Update_Comparison.selectContent(this);\" title='select/deselect all packages'>";
                    contentCheckBoxCell.className = "EntityTableCell3";
                    contentCheckBoxCell.style.width = 23 + "px";

                    var contentCheckBoxCel0 = newContentRow.insertCell(-1);
                    contentCheckBoxCel0.colSpan = 1;
                    // contentCheckBoxCel0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" onclick=\"Update_Comparison.forceidContent(this);\">";
                    contentCheckBoxCel0.innerHTML = "";
                    contentCheckBoxCel0.className = "EntityTableCell3";
                    contentCheckBoxCel0.style.width = 40 + "px";
                    
                    var newCell = newContentRow.insertCell(-1);
                    newCell.colSpan = 8;
                    newCell.className = "EntityTableCell2";
                    if (top.gl_uxlite_bootable == "1") {
                        newCell.innerHTML = "Machine-Type=\"" + mt + "\"";
                    } else if (top.gl_OOB_Params.Enabled) {
                        newCell.innerHTML = "Remote Machine-Type=\"" + mt + "\"";
                    } else {
                        // newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os + " (" + arch + ")";
                        newCell.innerHTML = "Machine-Type=\"" + mt + "\", OS=" + os;
                    }
                    
                    // co_total = total;
                    // get packages from xml, then we could sort them ourselves
                    for (var i = 0; i < total; i++) {
                        var pack = ezJsLib.XmlDom.getNodeByTagAndIndex('PACKAGE', dom, i);
                        var component = ezJsLib.XmlDom.getValueByTagFromNode("COMPONENT", pack);
                        if (component == "UTIL") {
                            xmlPkgsUTIL.push(pack);
                        } else {
                            xmlPkgs.push(pack);
                        }
                    }
                    xmlPkgs.sort(function (a, b) {
                        var aid = ezJsLib.XmlDom.getValueByTagFromNode("MACROPACKAGEID", a);
                        var bid = ezJsLib.XmlDom.getValueByTagFromNode("MACROPACKAGEID", b);
                        // 1. let macro packages ahead of table rows
                        var amicro = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", a);
                        var bmicro = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", b);
                        if (aid != amicro && bid == bmicro) return -1;
                        if (aid == amicro && bid != bmicro) return 1;
                        // 2. let packages with the same macropackageid in together
                        if (aid < bid) return -1;
                        if (aid > bid) return 1;
                        // 3. aid == bid, belong to the same macro package, put undetected packages in low priority
                        var aver = ezJsLib.XmlDom.getValueByTagFromNode("CINSTALLED", a);
                        var bver = ezJsLib.XmlDom.getValueByTagFromNode("CINSTALLED", b);
                        if (aver == bver) return 0;
                        if (aver == "Undetected") return 1;
                        if (bver == "Undetected") return -1;
                        return 0;
                    });
                    // Bug 128459 - BOMC 11.1.0 uEFI Flash w/USB Key Causes Prerequisite Message for Old Code When Newer Code is On The System
                    // store all prereq in this array
                    prereq_arr = new Array();

                    for (var i = 0; i < total; i++) {
                        try {
                            var pack_prereq = xmlPkgs[i];
                            var prereq = ezJsLib.XmlDom.getValueByTagFromNode('REQUISITE', pack_prereq);
                            var tmp_prereq_arr = prereq.split(',');
                            for (var j = 0; j < tmp_prereq_arr.length; j++) {
                                if (prereq_arr.indexOf(tmp_prereq_arr[j]) == -1) {
                                    prereq_arr.push(tmp_prereq_arr[j]);
                                }
                            }
                        } catch (e) {
                            continue;
                        }
                    }

                    let macroPackageIsHasAnyDevice = new Map();
                    for (var i = 0, j = 0; i < total; i++) { 
                        //alert("i = " + i + "total=" + total);
                        //default consider that its a full xml file, including all nodes
                        var pack, nameValue, updateId, severity, reboot, newVersion, installed, selected, forceid, requisite, children, chindNodeNumber, releaseDate, macroId, hasdevice;
                        pack = xmlPkgs[i];
                        if (!pack) {
                            continue;
                        }
                        nameValue = ezJsLib.XmlDom.getValueByTagFromNode("NAME", pack);
                        updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                        selected = ezJsLib.XmlDom.getValueByTagFromNode("SELECTED", pack);
                        forceid = ezJsLib.XmlDom.getValueByTagFromNode("FORCEID", pack);
                        requisite = ezJsLib.XmlDom.getValueByTagFromNode("REQUISITE", pack);
                        releaseDate = ezJsLib.XmlDom.getValueByTagFromNode("RELEASEDATE", pack);
                        
                        children = pack.getElementsByTagName("CHILDUPDATE");
                        chindNodeNumber = (children && children.length > 0) ? children.length : 0;
                        macroId = ezJsLib.XmlDom.getValueByTagFromNode("MACROPACKAGEID", pack);
                        try {
                            hasdevice = ezJsLib.XmlDom.getValueByTagFromNode("HASDEVICE", pack);
                        } catch(e) {
                            hasdevice = "";
                        }

                        // if this package is a prereq and it is not selected by default, it will not be displayed
                        if (prereq_arr.indexOf(updateId) != -1) {
                            if (selected.toString() == '0') {
                                continue;
                            }
                        }

                        
                        if (macroId && macroId != updateId){
                            if (macroId != curMacroPkg) {
                                macroUpdateRows(macroId, table, j);
                                curMacroPkg = macroId;
                                curMacroPkgIndex = j;
                                isMacroTypePkg = true;
                                macroMap.set(curMacroPkgIndex, 0); // count the number of micro under curMacroPkg
                                macroPackageIsHasAnyDevice.set(curMacroPkgIndex, 0);
                            }
                        } else {
                            curMacroPkg = "";
                            curMacroPkgIndex = -1;
                            isMacroTypePkg = false;
                        }

                        if (isMacroTypePkg) {
                            macroMap.set(curMacroPkgIndex, macroMap.get(curMacroPkgIndex) + 1);
                        }
                        
                        // only under bootable mode will display this warning
                        // add by chenhao: 20170822
                        if (top.gl_uxlite_bootable) {
                            if (updateId.indexOf("ibm_fw_imm") != -1 || updateId.indexOf("lnvgy_fw_imm") != -1 || updateId.indexOf('lnvgy_fw_xcc') != -1) {
                                if (i < (total - 1)) {
                                    $("#immIsPrereqWarning").css("display", "block");
                                }
                            }
                        }
                        
                        severity = ezJsLib.XmlDom.getValueByTagFromNode("SEVERITYDES", pack);
                        reboot = ezJsLib.XmlDom.getValueByTagFromNode("REBOOTDES", pack);
                        newVersion = ezJsLib.XmlDom.getValueByTagFromNode("PKGVERSION", pack);
                        newVersion = parsePkgVersion(newVersion);
                        installed = ezJsLib.XmlDom.getValueByTagFromNode("CINSTALLED", pack);
                        //add a new row
                        var newRow = table.insertRow(-1);
                        newRow.id = "packageindex" + j;
                        var newCell1 = newRow.insertCell(-1);
                        newCell1.setAttribute("role", "presentation");
                        if (selected == 1 && hasdevice == "1") {
                            //be selected
                            newCell1.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='" + updateId + "' id=\"co_checkbox" + j +
                                "\" onclick=\"Update_Comparison.selectUp(" + j + ", this, " + curMacroPkgIndex + ")\" checked " +
                                "aria-label='update id: " + nameValue + "'>";
                            newRow.className = "RowSelected";
                        } else {
                            newCell1.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='" + updateId + "' id=\"co_checkbox" + j +
                                "\" onclick=\"Update_Comparison.selectUp(" + j + ", this, " + curMacroPkgIndex + ")\" " +
                                "aria-label='update id: " + nameValue + "'>";
                        }
                        newCell1.className = "EntityTableCellCompareSe";
                        newCell1.style.width = "23px";

                        // Display force column as default
                        // if (top.gl_force) {
                        var newCell0 = newRow.insertCell(-1);
                        newCell0.setAttribute("role", "presentation");
                        if (selected == 1 && hasdevice == "1") {
                            if (forceid == 1) {
                                newCell0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='" + updateId + "' id=\"co_checkbox_f" + j +
                                "\" onclick=\"printLog('INFO','[Update_Comparison.js:co_checkbox_f" + j + "] (forceid)line " + j + " '+ (this.checked?'checked.':'unchecked.'))\" checked " +
                                "aria-label='force id: " + nameValue + "'>";
                            } else {
                                newCell0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='" + updateId + "' id=\"co_checkbox_f" + j +
                                "\" onclick=\"printLog('INFO','[Update_Comparison.js:co_checkbox_f" + j + "] (forceid)line " + j + " '+ (this.checked?'checked.':'unchecked.'))\" " +
                                "aria-label='force id: " + nameValue + "'>";
                            }
                        } else {
                            newCell0.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" value='" + updateId + "' id=\"co_checkbox_f" + j +
                                "\" disabled=\"disabled\" onclick=\"printLog('INFO','[Update_Comparison.js:co_checkbox_f" + j + "] (forceid)line " + j + " '+ (this.checked?'checked.':'unchecked.'))\" " +
                                "aria-label='force id: " + nameValue + "'>";
                        }
                        newCell0.className = "EntityTableCellCompareSe";
                        newCell0.style.width = "40px";
                        // }

                        var newCell2 = newRow.insertCell(-1);
                        newCell2.innerHTML = formatStrNowrap(nameValue);
                        newCell2.className = "EntityTableCell";
                        // add bmu support
                        if (top.gl_OOB_Params.Enabled) {
                            packageType = top.getPackageType(updateId);
                            if (packageType == "bmu") {
                                newCell2.style.color = "blue";
                                document.getElementById("bmuWarning").style.display = "block";
                            }
                        }

                        var treeImg = "";
                        if (isMacroTypePkg) {
                            treeImg = "<img src='./images/joinblank.png' border=0>";
                        }
                        if (chindNodeNumber > 0) {
                            newCell2.setAttribute("role", "presentation");
                            newCell2.id = "name" + j;
                            newCell2.innerHTML = "<div onclick='Update_Comparison.toggleChildrenNode(" + j + "," + chindNodeNumber + ")'>" +
                                                 treeImg + "<button class='Contracter' aria-label='toggle node'></button>" + newCell2.innerHTML + "</div>";
                            newCell2.style.cursor = "pointer";
                            childMap.set(j, chindNodeNumber);
                        } else {
                            newCell2.innerHTML = "<div><img src='./images/joinblank.png' border=0>"+ treeImg + newCell2.innerHTML + "</div>";
                        }
                        newCell2.title = nameValue;
                        newCell2.style.width = "178px";

                        var newCell3 = newRow.insertCell(-1);
                        newCell3.innerHTML = formatStrNowrap(severity);
                        newCell3.title = severity;
                        newCell3.className = "EntityTableCell";
                        newCell3.style.width = "80px"

                        var newCell4 = newRow.insertCell(-1);
                        if (children && children.length > 0)
                            newCell4.innerHTML = "";
                        else {
                            newCell4.innerHTML = formatStrNowrap(newVersion);
                            newCell4.title = newVersion;
                        }
                        newCell4.className = "EntityTableCell";
                        newCell4.style.width = "85px";

                        var newCell5 = newRow.insertCell(-1);
                        if (children && children.length > 0 && hasdevice == "1")
                            newCell5.innerHTML = "";
                        else {
                            newCell5.innerHTML = formatStrNowrap(installed);
                            newCell5.title = installed;
                        }
                        newCell5.className = "EntityTableCell";
                        newCell5.style.width = "105px";

                        var newCell6 = newRow.insertCell(-1);
                        newCell6.innerHTML = formatStrNowrap(reboot);
                        newCell6.title = reboot;
                        newCell6.className = "EntityTableCell";
                        newCell6.style.width = "80px";

                        var newCell7 = newRow.insertCell(-1);
                        newCell7.innerHTML = formatStrNowrap(updateId);
                        newCell7.title = updateId;
                        newCell7.className = "EntityTableCell";
                        newCell7.style.width = "120px";

                        var newCell8 = newRow.insertCell(-1);
                        newCell8.innerHTML = formatStrNowrap(requisite);
                        newCell8.title = requisite;
                        newCell8.className = "EntityTableCell";
                        newCell8.style.width = "120px";

                        var newCell9 = newRow.insertCell(-1);
                        newCell9.innerHTML = formatStrNowrap(releaseDate);
                        newCell9.title = releaseDate;
                        newCell9.className = "EntityTableCell";
                        newCell9.style.width = "80px";

                        let isHasAnyDevice = { val: 0 };
                        childUpdateRows(children, table, selected, j, isHasAnyDevice);

                        // Set isHasAnyDevice for normal packages and macro packages
                        newRow.setAttribute("isHasAnyDevice", isHasAnyDevice.val);
                        if (isMacroTypePkg && isHasAnyDevice.val === 1) {
                            macroPackageIsHasAnyDevice.set(curMacroPkgIndex, 1);
                        }

                        j++;
                        co_total++;
                    }

                    macroPackageIsHasAnyDevice.forEach(function (val, key) {
                        document.getElementById("macroindex" + key).setAttribute("isHasAnyDevice", val);
                    });

                    // init table style
                    setTableStatus();
                    setTreeImg();
                    // Expand macro packages by default
                    macroMap.forEach(function (val, key) {
                        toggleMacroNode(key);
                    });
                    if(!top.gl_showNoAdapters){
                        $('#co_progress_table tr[isHasAnyDevice="0"]').hide();
                    }

                    if (IsPartition == 1) {
                        uxlite_alert($.i18n.prop("UpdateComparison.ScalableWarn"));
                        // uxlite_alert("Warning! You are attempting to update firmware on a system that is part of a scalable complex with multiple partitions. ALL NODES IN A COMPLEX MUST be updated to the same firmware levels before resetting any system in the scalable complex. \nWhen updating the Integrated Management Module firmware, complete the update on all nodes in the complex, then manually restart the BMCs in order for the new firmware to take effect.\nYou can use online UXSPI with '--reboot-imm' option to specify BMC to be restarted after updated.\n");
                    }
                    complete(1, resultMsg);
                    top.toggleNext(true);
                }
            } else {
                if (resultMsg == '' || resultMsg == null || resultMsg == undefined) {
                    resultMsg = top.getComErrMsg();
                }
                complete(0, resultMsg);
                top.toggleNext(false);
                top.togglePrevious(true);
                $('#retryBtn_compare').show();
            }
            // adjust the width to fit the window
            document.getElementById("co_progress_table").style.width="100%";
            togglePrevious(true);
            // toggleNext(true);
            $("#cancelBtn_compare").css("display", "none");
            $('#missDetailSection').empty();
            if (missingPacks) {
                var missingDetail = '';
                for (var i = 0; i < missingPacksArray.length; i++) {
                    // missingDetail += missingPacksArray[i] + '\n';
                    missingDetail += missingPacksArray[i] + '<br>';
                }
                $('#missDetailSection').html(missingDetail);
                $('#missPackWarning').show();
            }
        }
        comp_ShowNoAdapters();

        //show checkbox after compare finished.        
        $("#showNoAdapterSection").show();

        toggleForceCheckbox();
    }

    function macroUpdateRows(macroId, table, i) {
        var newRow = table.insertRow(-1);
        newRow.id = "macroindex" + i;   // macro's index is same with the first micro's index
        newRow.classList += "macro";

        var newCell1 = newRow.insertCell(-1);
        newCell1.setAttribute("role", "presentation");
        newCell1.innerHTML = "<input type=\"checkbox\" name=\"checkbox\" id=\"macro_checkbox" + i +
                            "\" onclick=\"Update_Comparison.selectMacro(" + i + ", this)\" aria-label='select/deselect all child packages of " + macroId + "'>";
        newCell1.className = "EntityTableCellCompareSe";
        newCell1.style.width = "23px";

        // if (top.gl_force) {
        var newCell0 = newRow.insertCell(-1);
        newCell0.innerHTML = "";
        newCell0.className = "EntityTableCellCompareSe";
        newCell0.style.width = "40px";
        // }
        
        var newCell2 = newRow.insertCell(-1);
        newCell2.setAttribute("role", "presentation");
        newCell2.innerHTML = formatStrNowrap(macroId);
        newCell2.innerHTML = "<div onclick='Update_Comparison.toggleMacroNode(" + i + ")'>" +
                            "<button class='Contracter' aria-label='toggle node'></button>" + newCell2.innerHTML + "</div>";
        newCell2.title = macroId;
        newCell2.style.cursor = "pointer";
        newCell2.className = "EntityTableCell";
        newCell2.style.width = "178px";

        var newCell3 = newRow.insertCell(-1);
        newCell3.innerHTML = "";
        newCell3.className = "EntityTableCell";
        newCell3.style.width = "80px";

        var newCell4 = newRow.insertCell(-1);
        newCell4.innerHTML = "";
        newCell4.className = "EntityTableCell";
        newCell4.style.width = "85px";

        var newCell5 = newRow.insertCell(-1);
        newCell5.innerHTML = "";
        newCell5.className = "EntityTableCell";
        newCell5.style.width = "105px";

        var newCell6 = newRow.insertCell(-1);
        newCell6.innerHTML = "";
        newCell6.className = "EntityTableCell";
        newCell6.style.width = "80px";

        var newCell7 = newRow.insertCell(-1);
        newCell7.innerHTML = "";
        newCell7.className = "EntityTableCell";
        newCell7.style.width = "120px";

        var newCell8 = newRow.insertCell(-1);
        newCell8.innerHTML = "";
        newCell8.className = "EntityTableCell";
        newCell8.style.width = "120px";

        var newCell9 = newRow.insertCell(-1);
        newCell9.innerHTML = "";
        newCell9.className = "EntityTableCell";
        newCell9.style.width = "80px";
    }

    function childUpdateRows(children, table, selected, i, isPackageHasAnyDevice) {
        if (!children || children.length < 1)
            return;
        for (var index = 0; index < children.length; index++) {
            var CNAME = children[index].getElementsByTagName("CNAME")[0].childNodes[0].nodeValue;
            var CNEWVERSION = children[index].getElementsByTagName("CNEWVERSION")[0].childNodes[0].nodeValue;
            var CHASDEVICE;
            try {
                CHASDEVICE = children[index].getElementsByTagName("CHASDEVICE")[0].childNodes[0].nodeValue;
            } catch(e) {
                CHASDEVICE = "";
            }
            if (CHASDEVICE !== 1 && CHASDEVICE !== "1") {
                CHASDEVICE = 0;
            } else {
                CHASDEVICE = 1;
            }

            var CINSTALLED;            
            try {
                CINSTALLED = children[index].getElementsByTagName("CINSTALLED")[0].childNodes[0].nodeValue;
            } catch(e) {
                CINSTALLED = "UNKNOWN";
            }

            var newRow = table.insertRow(-1);
            if (selected == 1)
                newRow.className = "RowSelected";
            newRow.id = "child" + i + "_" + index;

            var newCell0 = newRow.insertCell(-1);
            newCell0.innerHTML = "";
            newCell0.className = "EntityTableCellCompareSe";

            // if (top.gl_force) {
            var newCell1 = newRow.insertCell(-1);
            newCell1.innerHTML = "";
            newCell1.className = "EntityTableCellCompareSe";
            // }
            
            var newCell2 = newRow.insertCell(-1);
            var treeimg = "";
            if (isMacroTypePkg) {
                treeimg = "<img src='./images/joinblank.png' border=0>"
            }
            // CID 190223
            newCell2.innerHTML = "<div><img src='./images/joinblank.png' border=0>" + treeimg + "<img src='./images/joinblank.png' border=0>" + CNAME + "</div>";
            newCell2.className = "EntityTableCell";

            var newCell3 = newRow.insertCell(-1);
            newCell3.innerHTML = "";
            newCell3.className = "EntityTableCell";

            var newCell4 = newRow.insertCell(-1);
            newCell4.innerHTML = CNEWVERSION;
            newCell4.className = "EntityTableCell";

            var newCell5 = newRow.insertCell(-1);
            newCell5.innerHTML = CINSTALLED;
            newCell5.className = "EntityTableCell";
            newRow.setAttribute("isHasAnyDevice", CHASDEVICE);
            if (CHASDEVICE === 1) {
                isPackageHasAnyDevice.val = 1;
            }

            var newCell6 = newRow.insertCell(-1);
            newCell6.innerHTML = "";
            newCell6.className = "EntityTableCell";

            var newCell7 = newRow.insertCell(-1);
            newCell7.innerHTML = "";
            newCell7.className = "EntityTableCell";

            var newCell8 = newRow.insertCell(-1);
            newCell8.innerHTML = "";
            newCell8.className = "EntityTableCell";

            var newCell9 = newRow.insertCell(-1);
            newCell9.innerHTML = "";
            newCell9.className = "EntityTableCell";
        }
    }

    function stopCalculagraph() {
        if (co_navigation_timer){
            clearInterval(co_navigation_timer);
            co_navigation_timer=undefined;
        }
        document.getElementById("timerMsg").style.display = "none";
    }

    function runCalculagraph() {
        co_navigation_timer_sec -= 1;
        document.getElementById("calculagraphMsg").innerHTML = $.i18n.prop("UpdateComparison.SecondRemain",co_navigation_timer_sec);
        // document.getElementById("calculagraphMsg").innerHTML = co_navigation_timer_sec + " seconds remaining to navigate to execution page...";
        if (co_navigation_timer_sec == 0) //stop the timer and navigate to the next page...
        {
            stopCalculagraph();
            gl_wizard.steps("next");
        }
    }

    function startCalculagraph(time) {
        co_navigation_timer_sec = time;
        document.getElementById("calculagraphMsg").innerHTML = $.i18n.prop("UpdateComparison.SecondRemain",co_navigation_timer_sec);
        // document.getElementById("calculagraphMsg").innerHTML = co_navigation_timer_sec + " seconds remaining to navigate to execution page...";
        if(co_navigation_timer == undefined){
            co_navigation_timer = setInterval(runCalculagraph, 1000);
        }
    }

    function toggleMacroNode(i) {
        if (document.getElementById("macroindex" + i).getElementsByTagName("button")[0].className == "Expander") {
            document.getElementById("macroindex" + i).getElementsByTagName("button")[0].className = "Contracter";
        } else {
            document.getElementById("macroindex" + i).getElementsByTagName("button")[0].className = "Expander";
        }
        return checkNodesUnderMacro(i);
    }
    function checkNodesUnderMacro(i) {
        var trDisplay = "table-row";
        var size = macroMap.get(i);
        if (document.getElementById("macroindex" + i).getElementsByTagName("button")[0].className == "Expander")
        {
            printLog("INFO","macro pakage " + i + " was show only a row.");
            for (var index = i; index < i + size; index++) {
                document.getElementById("packageindex" + index).style.display = "none";
                if (childMap.has(index)) {
                    var childNodeNumber = childMap.get(index);
                    for (var childindex = 0; childindex < childNodeNumber; childindex++) {
                        document.getElementById("child" + index + "_" + childindex).style.display = "none";
                    }
                }
            }
        }
        else
        {
            printLog("INFO","macro package " + i + " was show full content.");
            for (var index = i; index < i + size; index++) {
                document.getElementById("packageindex" + index).style.display = trDisplay;
                if (childMap.has(index) && document.getElementById("name" + index).getElementsByTagName("button")[0].className == "Contracter") {
                    var childNodeNumber = childMap.get(index);
                    for (var childindex = 0; childindex < childNodeNumber; childindex++) {
                        document.getElementById("child" + index + "_" + childindex).style.display = trDisplay;
                    }
                }
            }
        }
        if(!top.gl_showNoAdapters){
            $('#co_progress_table tr[isHasAnyDevice="0"]').hide();
        }
    }

    function toggleChildrenNode(updateId, childId) {
        if (document.getElementById("name" + updateId).getElementsByTagName("button")[0].className == "Expander") {
            document.getElementById("name" + updateId).getElementsByTagName("button")[0].className = "Contracter";
        } else {
            document.getElementById("name" + updateId).getElementsByTagName("button")[0].className = "Expander";
        }
        checkChildrenNodes(updateId, childId);
    }
    function checkChildrenNodes(updateId, childId) {
        var trDisplay = "table-row";
        if (document.getElementById("name" + updateId).getElementsByTagName("button")[0].className == "Expander")
        {
            printLog("INFO","update " + updateId + ", child " + childId + " was show only a row.");
            for (var i = 0; i < childId; i++) {
                document.getElementById("child" + updateId + "_" + i).style.display = "none";
            }
        }
        else
        {
            printLog("INFO","update " + updateId + ", child " + childId + " was show full content.");
            for (var i = 0; i < childId; i++) {
                document.getElementById("child" + updateId + "_" + i).style.display = trDisplay;
            }
        }
        if(!top.gl_showNoAdapters){
            $('#co_progress_table tr[isHasAnyDevice="0"]').hide();
        }
    }

    function checkBacklevel() {
        var hasBacklevel = 0;

        var total = xmlPkgs.length;
        var backUpdateIds = new Array();

        for (var i = 0; i < co_total; i++) {
            if (document.getElementById("co_checkbox" + i).checked == true) {
                var updateId_GUI = document.getElementById("co_checkbox" + i).value;
                for (var j = 0; j < total; j++) {
                    var pack = xmlPkgs[j];
                    if (!pack) {
                        continue;
                    }
                    var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                    var compResult = ezJsLib.XmlDom.getValueByTagFromNode("COMPRESULT", pack);
                    if (updateId_GUI == updateId && compResult < 0) {
                        backUpdateIds.push(updateId);
                        hasBacklevel++;
                    } else {
                        //dummy
                    }
                }
            }
        }

        if (hasBacklevel > 0) {
            if (confirm($.i18n.prop("UpdateComparison.BackLevelWarn"))) {
            // if (confirm("Warning: You've selected some updates which are backlevel. It may fail to backlevel or not work.  Are you sure you want to continue to update? ")) {
                return true;
            } else {
                return false;
            }
        }

        return true;
    }

    function co_collect() {
        printLog("INFO","Next was clicked.");
        // addPrereqCount = 0;
        addPrereqArray = new Array();
        addPrereqArrayNotFound = new Array();
        selArray = new Array();

        if (document.getElementById('prereq_accept').checked) {
            top.gl_prereq_user_confirm = true;
        } else {
            top.gl_prereq_user_confirm = false;
        }

        if (!is_in_comparison) {
            // if user selects a package that has pre-reqs
            // will automatically select the pre-reqs for user
            // will check in the following function after onecli confirm the tag name of pre-req
            
            for (var i = 0; i < co_total; i++) {
                if (document.getElementById("co_checkbox" + i).checked == true) {
                    var updateId = document.getElementById("co_checkbox" + i).value;
                    selectPreReq(updateId);
                }
            }

            if (addPrereqArray.length > 0) {
                var addPrereqString = '';
                for (var i = 0; i < addPrereqArray.length; i++) {
                    if (i == addPrereqArray.length -1) {
                        addPrereqString += addPrereqArray[i];
                    } else {
                        addPrereqString += addPrereqArray[i] + ', ';
                    }
                }
                if (addPrereqArray.length == 1) {
                    alert($.i18n.prop('UpdateComparison.addPackSelected', addPrereqString));
                } else {
                    alert($.i18n.prop('UpdateComparison.addPacksSelected', addPrereqString));
                }
            }

            top.gl_co_list = new Array();
            top.gl_payload_list = new Array();
            top.gl_selected_list = new Array();
            top.gl_forceid_list = new Array();
            var offset = 0;
            for (var i = 0; i < co_total; i++) {
                if (xmlPkgs.length) {
                    var pack = xmlPkgs[i + offset];
                    var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                    var selected = ezJsLib.XmlDom.getValueByTagFromNode("SELECTED", pack);
                    while (prereq_arr.indexOf(updateId) != -1 && selected.toString() == '0') {
                        ++offset;
                        pack = xmlPkgs[i + offset];
                        updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                        selected = ezJsLib.XmlDom.getValueByTagFromNode("SELECTED", pack);
                    }
                }
                if (document.getElementById("co_checkbox" + i).checked == true) {
                    var updateId = document.getElementById("co_checkbox" + i).value;

                    top.gl_co_list.push(updateId);
                    top.gl_selected_list.push(updateId);
                    var pack = xmlPkgs[i + offset];
                    var bundleZipFile  = ezJsLib.XmlDom.getValueByTagFromNode("BUNDLEZIP", pack);
                    if(bundleZipFile.length != 0)
                    {
                        top.gl_payload_list.push(bundleZipFile);
                    }
                    else
                    {
                        var payload  = ezJsLib.XmlDom.getValueByTagFromNode("PAYLOADFILE", pack);
                        top.gl_payload_list.push(payload);    
                    }

                    if (document.getElementById("co_checkbox_f" + i)) {
                        if (document.getElementById("co_checkbox_f" + i).checked == true) {
                            top.gl_forceid_list.push(updateId);
                        }
                    }

                    if (xmlPkgs.length) {
                        var pack = xmlPkgs[i + offset];
                        var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", pack);
                        var selected = ezJsLib.XmlDom.getValueByTagFromNode("SELECTED", pack);
                        var unselectedReason = "";
                        try {
                            unselectedReason = ezJsLib.XmlDom.getValueByTagFromNode("UNSELECTEDREASON", pack);
                        } catch(e) {
                            unselectedReason = "It is not recommended to install or upgrade this package. ";
                        }
                        if (unselectedReason == "" || unselectedReason == null || unselectedReason == undefined) {
                            unselectedReason = "It is not recommended to install or upgrade this package. ";
                        }
                        // if (unselectedReason.indexOf("0-Selected") < 0) {
                        if (selected == "0") {
                            var selRsn = new Object();
                            selRsn.update_id = updateId;
                            selRsn.unSelRsn = unselectedReason;
                            selArray.push(selRsn);
                        }

                    }
                }
            }

            for (var i = 0; i < xmlPkgsUTIL.length; i++) {
                var updateId = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", xmlPkgsUTIL[i]);
                for (var j = 0; j < addPrereqArrayNotFound.length; j++) {
                    if (addPrereqArrayNotFound[j] == updateId) {
                        top.gl_co_list.push(updateId);
                        top.gl_selected_list.push(updateId);
                        
                        var bundleZipFile  = ezJsLib.XmlDom.getValueByTagFromNode("BUNDLEZIP", xmlPkgsUTIL[i]);
                        if(bundleZipFile.length != 0)
                        {
                            top.gl_payload_list.push(bundleZipFile);
                        }
                        else
                        {
                            var payload = ezJsLib.XmlDom.getValueByTagFromNode("PAYLOADFILE", xmlPkgsUTIL[i]);
                            top.gl_payload_list.push(payload);    
                        }
    
                        break;
                    }
                }
            }

            if(top.gl_uxlite_bootable == "1" &&(top.is_unattend() || top.is_autorun()))
            {
                var bomc_force_list = top.getBomcForceList();
                for (var i = 0; i < bomc_force_list.length; i++) {
                    var updateId = bomc_force_list[i];
                    if (top.gl_co_list.indexOf(updateId) == -1) {
                        top.gl_co_list.push(updateId);
                    }
                    if (top.gl_selected_list.indexOf(updateId) == -1) {
                        top.gl_selected_list.push(updateId);
                    }
                    if (top.gl_forceid_list.indexOf(updateId) == -1) {
                        top.gl_forceid_list.push(updateId);
                    }

                    for (var j = 0; j < xmlPkgs.length; j++) {
                        var updateIdxml = ezJsLib.XmlDom.getValueByTagFromNode("UPDATEID", xmlPkgs[j]);
                        if (updateIdxml == updateId) {
                            var bundleZipFile  = ezJsLib.XmlDom.getValueByTagFromNode("BUNDLEZIP", xmlPkgs[j]);
                            if(bundleZipFile.length != 0)
                            {
                                top.gl_payload_list.push(bundleZipFile);
                            }
                            else
                            {
                                var payload = ezJsLib.XmlDom.getValueByTagFromNode("PAYLOADFILE", xmlPkgs[j]);
                                if (top.gl_payload_list.indexOf(payload) == -1) {
                                    top.gl_payload_list.push(payload);
                                }
                            }
                            break;
                        }
                    }
                }
            }

            if (top.gl_co_list.length < 1) {
                uxlite_alert($.i18n.prop("UpdateComparison.selectMore"));
                // uxlite_alert("Please select one or more update(s)!");
                return false;
            } else {
                
                stopCalculagraph();

                // for unattended mode and autorun mode, will not display this popup dialog
                var table = document.getElementById("sel_rsn_table");
                $("#sel_rsn_table").empty();
                if (!top.is_unattend() && !top.is_autorun()) {
                    var selArrayFlg = false;
                    var last_selArray_id = new Array();
                    for (var i = 0; i < last_selArray.length; i++) {
                        last_selArray_id.push(last_selArray[i].update_id);
                    }
                    for (var i = 0; i < selArray.length; i++) {
                        if(last_selArray_id.indexOf(selArray[i].update_id) < 0) {
                            selArrayFlg = true;
                            break;
                        }
                    }
                    if (selArrayFlg && !top.gl_prereq_user_confirm) {
                        for (var i = 0; i < selArray.length; i++) {
                            var updateTarget =  selArray[i].update_id;
                            var unselectedReason = selArray[i].unSelRsn;
                            var selrsn_tb_row = table.insertRow(-1);
                            var selrsn_tb_id_cell = selrsn_tb_row.insertCell(-1);
                            selrsn_tb_id_cell.style.width = "50%";
                            selrsn_tb_id_cell.style = "border: 1px solid black";
                            selrsn_tb_id_cell.innerHTML = updateTarget;
                            var selrsn_tb_rsn_cell = selrsn_tb_row.insertCell(-1);
                            selrsn_tb_rsn_cell.style.width = "50%";
                            selrsn_tb_rsn_cell.style = "border: 1px solid black";
                            selrsn_tb_rsn_cell.innerHTML = unselectedReason;    
                        }
                        top.show_prereq_mis_dialog();
                        return 'waiting';

                    } 
                }

                if (top.gl_uxlite_bootable == "1" && !top.getEnv("BOMC_UNATTENDED_MODE")) {
                    if (checkBacklevel()) {
                        //continue
                    } else {
                        return;
                    }
                }
            }

            // if there is bmu package, will append the packages in ac_result2.xml to top.gl_co_list
            // now deal with bmu in onecli

            // update the local machine and update a remote machine
            // if it is individual package
            // need remove Update_Selection, move Update_Comparison above of Acquire_Updates
            // add by chenhao 20170620
            // if (getTaskName() == top.gl_isUpdate && !top.gl_isUXSP && top.gl_isViaWeb) {
            if (getTaskName() == top.gl_isUpdate && top.gl_isViaWeb) {
                top.gl_su_list = top.gl_co_list;
            }

        }
        document.getElementById('prereq_accept').checked = false;
        last_selArray = selArray;
        return true;
    }

    function complete(c, msg) {
        is_in_comparison = false;
        if (top.getEnv("BOMC_UNATTENDED_MODE") && c == 0) {
            top.Exit(false);
            return;
        }

        document.getElementById("cmpMsg").style.display = "none";
        document.getElementById("acqMsgInCmp").style.display = "none";
        switch (c) {
            case 0: //error
                document.getElementById("errMsg").style.display = "block";
                document.getElementById("errMsg2").innerHTML = $.i18n.prop("UpdateComparison.CompareError") + msg;
                // document.getElementById("errMsg2").innerHTML = "Error(s) occur while comparing! <br>Error message: " + msg;
                top.toggleNext(false);
                break;
            case 1:
                if (top.gl_uxlite_bootable == "1") {
                    document.getElementById("timerMsg").style.display = "block";
                    if (top.getEnv("UXSPI_TIMEOUT")) {
                        startCalculagraph(top.getEnv("UXSPI_TIMEOUT"));
                    } else {
                        startCalculagraph(CONST_TIME);
                    }
                }
                break;
            default:
                break;
        }
    }

    // Table will refresh once any checkbox changing its status. Disable it before selecting a batch of checkboxes to reduce unnecessary refresh
    var preventSetTableStatus = false;
    function setTableStatusAfter(batchSelect) {
        preventSetTableStatus = true;
        if (batchSelect) {
            batchSelect();
        }
        preventSetTableStatus = false;
        setTableStatus();
    }

    function selectContent(ref) {
        let isChecked = ref.checked;
        printLog("INFO","check box 'includeid all' "+(isChecked?"checked.":"unchecked."));
        setTableStatusAfter(() => {
            for (var i = 0; i < co_total; i++) {
                let packageindex = "packageindex" + i;
                if(!top.gl_showNoAdapters && document.getElementById(packageindex).getAttribute("isHasAnyDevice") == "0"){
                    continue;
                }
                if (document.getElementById("co_checkbox" + i).checked != isChecked) {
                    document.getElementById("co_checkbox" + i).click();
                }
            }
        });
    }

    function selectMacro(macroId, ref) {
        var end = macroMap.get(macroId) + macroId;
        let isChecked = ref.checked;
        printLog("INFO","check box 'includeid macro' "+macroId+ (isChecked?" checked.":" unchecked."));
        setTableStatusAfter(() => {
            for (var i = macroId; i < end; ++i) {
                let packageindex = "packageindex" + i;
                if(!top.gl_showNoAdapters && document.getElementById(packageindex).getAttribute("isHasAnyDevice") == "0"){
                    continue;
                }
                if (document.getElementById("co_checkbox" + i).checked != isChecked) {
                    document.getElementById("co_checkbox" + i).click();
                }
            }
        });
    }

    // function forceidContent(ref) {
    //     printLog("INFO","check box 'forceid all' "+(ref.checked?"checked.":"unchecked."));
    //     for (var i = 0; i < co_total; i++) {
    //         if (!document.getElementById("co_checkbox_f" + i).disabled) {
    //             document.getElementById("co_checkbox_f" + i).checked = !ref.checked;
    //             document.getElementById("co_checkbox_f" + i).click();
    //         }
    //     }
    // }

    function selectPreReq(updateId) {
        for (var i = 0; i < xmlPkgs.length; i++) {
            // get UPDATEID of the package to find it
            var findUpdateId = xmlPkgs[i].getElementsByTagName("UPDATEID")[0].innerHTML;
            if (findUpdateId == updateId) {
                var requisite;
                var reqSelected;
                try {
                    requisite = xmlPkgs[i].getElementsByTagName("REQUISITE")[0].innerHTML;
                } catch(e) {
                    requisite = null;
                }
                if (requisite && requisite != "") {
                    var reqs = requisite.split(",");
                    for (var j = 0; j < reqs.length; j++) {
                        for (var l = 0; l < xmlPkgs.length; l++) {
                            if (reqs[j] == xmlPkgs[l].getElementsByTagName('UPDATEID')[0].innerHTML) {
                                reqSelected = xmlPkgs[l].getElementsByTagName('SELECTED')[0].innerHTML;
                                if (reqSelected == '1') {
                                    for (var k = 0; k < co_total; k++) {
                                        if (document.getElementById("co_checkbox" + k).value == reqs[j]) {
                                            if (!document.getElementById("co_checkbox" + k).checked) {
                                                document.getElementById("co_checkbox" + k).click();
                                                document.getElementById("co_checkbox" + k).checked = true;
                                                // addPrereqCount++;
                                                addPrereqArray.push(reqs[j]);
                                                selectPreReq(reqs[j]);
                                            }
                                        }
                                    }
                                }
                                break;
                            }
                            // if never find in xmlPkgs
                            if (l == xmlPkgs.length - 1) {
                                addPrereqArrayNotFound.push(reqs[j]);
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    // Mainly set image tree of table
    /**
     * macro
     * |-micro
     * | |-child
     * | |_child
     * |_micro
     *   |-child
     *   |_child
     * micro
     * |-child
     * |_child
     */
    function setTreeImg() {
        for (let [key, value] of childMap) {
            let isLastItem = true;
            for (let i = value - 1; i >= 0; --i) {
                let childindex = "child" + key + "_" + i;
                if (!top.gl_showNoAdapters && document.getElementById(childindex).getAttribute("isHasAnyDevice") == "0") {
                    continue;
                }
                if (isLastItem) {
                    document.getElementById(childindex).getElementsByTagName("img")[1].src = "./images/joinbottom.png";
                } else {
                    document.getElementById(childindex).getElementsByTagName("img")[1].src = "./images/join.png";
                }
                isLastItem = false;
            }
        }
        for (let [key, value] of macroMap) {
            let isLastItem = true;
            for (let i = value - 1; i >= 0; --i) {
                let packageindex = "packageindex" + (i + key);
                if (!top.gl_showNoAdapters && document.getElementById(packageindex).getAttribute("isHasAnyDevice") == "0") {
                    continue;
                }
                if (!childMap.has(i + key)) {
                    if (isLastItem) {
                        document.getElementById(packageindex).getElementsByTagName("img")[1].src = "./images/joinbottom.png";
                    } else {
                        document.getElementById(packageindex).getElementsByTagName("img")[1].src = "./images/join.png";
                    }
                } else {
                    let isLastChild = true;
                    for (let j = childMap.get(i + key) - 1; j >= 0; --j) {
                        let childindex = "child" + (i + key) +"_" +j;
                        if (!top.gl_showNoAdapters && document.getElementById(childindex).getAttribute("isHasAnyDevice") == "0") {
                            continue;
                        }
                        if (isLastItem) {
                            document.getElementById(childindex).getElementsByTagName("img")[1].src = "./images/joinblank.png";
                        } else {
                            document.getElementById(childindex).getElementsByTagName("img")[1].src = "./images/joinmid.png";
                        }
                        if (isLastChild) {
                            document.getElementById(childindex).getElementsByTagName("img")[2].src = "./images/joinbottom.png";
                        } else {
                            document.getElementById(childindex).getElementsByTagName("img")[2].src = "./images/join.png";
                        }
                        isLastChild = false;
                    }
                }
                isLastItem = false;
            }
        }
    }

    // Mainly set status or style of macro_checkbox and all_checkbox, such as checked and class
    function setTableStatus() {
        if (preventSetTableStatus) return;
        // for micro class and child class
        for (let key = 0; key < co_total; ++key) {
            let isChecked = document.getElementById("co_checkbox" + key).checked;
            document.getElementById("packageindex" + key).className = isChecked ? "RowSelected" : "RowUnselected";
        }
        for (let [key, value] of childMap) {
            let isChecked = document.getElementById("co_checkbox" + key).checked;
            for (let i = 0; i < value; ++i) {
                document.getElementById("child" + key + "_" + i).className = isChecked ? "RowSelected" : "RowUnselected";
            }
        }
        // for macro checkbox and macro class
        for (let [key, value] of macroMap) {
            let end = value + key;
            let countSelected = 0, countUnselected = 0;
            for (let i = key; i < end; ++i) {
                let packageindex = "packageindex" + i;
                if(!top.gl_showNoAdapters && document.getElementById(packageindex).getAttribute("isHasAnyDevice") == "0"){
                    // They will be hidden
                    continue;
                }
                if (document.getElementById("co_checkbox" + i).checked) {
                    ++countSelected;
                } else {
                    ++countUnselected;
                }
            }
            let macroCheckboxIndex = "macro_checkbox" + key;
            let macroindex = "macroindex" + key;
            if (countSelected == 0) {
                document.getElementById(macroCheckboxIndex).checked = false;
                document.getElementById(macroCheckboxIndex).indeterminate = false;
                document.getElementById(macroindex).className = "RowUnselected";
            } else if (countUnselected == 0) {
                document.getElementById(macroCheckboxIndex).checked = true;
                document.getElementById(macroCheckboxIndex).indeterminate = false;
                document.getElementById(macroindex).className = "RowSelected";
            } else {
                document.getElementById(macroCheckboxIndex).checked = true;
                document.getElementById(macroCheckboxIndex).indeterminate = true;
                document.getElementById(macroindex).className = "RowSelected";
            }
        }
        // for all_checkbox
        let checkedNumber;
        let unCheckedNumber;
        if (!top.gl_showNoAdapters) {
            checkedNumber = $('#co_progress_table tr[isHasAnyDevice="1"] input[type=checkbox]:not([id^="co_checkbox_f"]):checked:not(:indeterminate)').length;
            unCheckedNumber = $('#co_progress_table tr[isHasAnyDevice="1"] input[type=checkbox]:not([id^="co_checkbox_f"]):not(:checked):not(:indeterminate)').length;
        } else {
            checkedNumber = $('#co_progress_table tr input[type=checkbox]:not([id^="co_checkbox_f"]):checked:not(:indeterminate)').length;
            unCheckedNumber = $('#co_progress_table tr input[type=checkbox]:not([id^="co_checkbox_f"]):not(:checked):not(:indeterminate)').length;
        }
        if (checkedNumber == 0) {
            document.getElementById("all_checkbox").checked = false;
            document.getElementById("all_checkbox").indeterminate = false;
        } else if (unCheckedNumber == 0) {
            document.getElementById("all_checkbox").checked = true;
            document.getElementById("all_checkbox").indeterminate = false;
        } else {
            document.getElementById("all_checkbox").checked = true;
            document.getElementById("all_checkbox").indeterminate = true;
        }
    }

    function selectUp(update, ref, macroPkgIndex) {
        printLog("INFO","(includeid)line " + update + (ref.checked?" checked.":" unchecked."));

        if (document.getElementById("co_checkbox_f" + update) && top.gl_force) {
            if (ref.checked) {
                document.getElementById("co_checkbox_f" + update).disabled = false;
            } else {
                document.getElementById("co_checkbox_f" + update).checked = false;
                document.getElementById("co_checkbox_f" + update).disabled = "disabled";
            }
        }
        
        setTableStatus();
    }

    function toggleForceCheckbox() {
        top.gl_force = document.getElementById('enableForceUpdate').checked;
        if (top.gl_force) {
            $('#co_progress_table .RowSelected [id^="co_checkbox_f"]').prop("disabled",false)
        } else {
            $('#co_progress_table [id^="co_checkbox_f"]').prop("disabled", true);
            $('#co_progress_table [id^="co_checkbox_f"]').prop("checked", false);
        }
    }

    /**
     * deal with multi-line tablecell trouble in IE('nowrap', 'overflow: hidden' in css file won't work)
     */
    function formatStrNowrap(str) {
        return "<span style='white-space:nowrap;'>" + str + "</span>";
    }

    function tableScroll() {
        $("#headerOutDiv").scrollLeft($("#co_progress").scrollLeft());
    }

    function enNextBtn() {
        printLog("INFO","Previous was clicked.");
        stopCalculagraph();
        top.toggleNext(true);
        top.togglePrevious(true);
    }

    function showMissingDetail() {
        printLog("INFO","button 'Show Details' was clicked.");
        $('#missDetailSection').show();
        $('#showDetail').hide();
        $('#hideDetail').show();
    }

    function hideMissingDetail() {
        printLog("INFO","button 'Hide Details' was clicked.");
        $('#missDetailSection').hide();
        $('#showDetail').show();
        $('#hideDetail').hide();
    }

    function comp_ShowNoAdapters(){
        top.gl_showNoAdapters = $("#comp_showNoAdapterCheckBox").prop("checked");
        if(top.gl_showNoAdapters){
            for(let [key, value] of macroMap){
                let macroIndex = "macroindex" + key;
                document.getElementById(macroIndex).style.display = "";
                if(document.getElementById(macroIndex).getElementsByTagName("button")[0].className == "Expander"){
                    continue;
                }           
                for(var i=0;i<value;i++){
                    let packageindex = "packageindex" + (i + key);
                    document.getElementById(packageindex).style.display = "table-row";
                    if(!childMap.has(i+key)){
                        continue;
                    }
                    if(document.getElementById(packageindex).getElementsByTagName("button")[0].className == "Expander"){
                        continue;
                    }
                    for(var j=0;j<childMap.get(i+key);j++){
                        let childindex = "child" + (i + key) +"_" +j;
                        document.getElementById(childindex).style.display = "table-row";
                    }
                }
            }
            for(var i=0;i<co_total;i++){
                if(macroMap.has(i)){
                    i += macroMap.get(i) - 1;
                    continue;
                }
                let packageindex = "packageindex" + i;
                document.getElementById(packageindex).style.display = "table-row";
                if(!childMap.has(i)){
                    continue;
                }
                if(document.getElementById(packageindex).getElementsByTagName("button")[0].className == "Expander"){
                    continue;
                }
                for(var j=0;j<childMap.get(i);j++){
                    let childindex = "child" + (i) +"_" +j;
                    document.getElementById(childindex).style.display = "table-row";
                }
            }
        } else {
            var numberOfSelected = $('#co_progress_table').find('tr[isHasAnyDevice="0"]').find('input:checkbox:checked').length;
            if(numberOfSelected > 0){
                var result = confirm($.i18n.prop("UpdateComparison.UnselectedNoAdapter"));
                if(result==false){
                    $("#comp_showNoAdapterCheckBox").prop("checked",true);
                    top.gl_showNoAdapters = true;
                    return;
                }
            }
            $('#co_progress_table tr[isHasAnyDevice="0"]').hide();
            for (var i = 0; i < co_total; i++) { 
                let packageindex = "packageindex" + i;
                let isAllNoDevice = true;
                let cbindex = "co_checkbox" + i;
                if(!childMap.has(i)){
                    if(document.getElementById(cbindex).checked){
                        document.getElementById(cbindex).click();
                    }
                    continue;
                }

                for(var j=0;j<childMap.get(i);j++){
                    let childindex = "child" + i + "_" + j;
                    if(document.getElementById(childindex).getAttribute("isHasAnyDevice") == "0")  //hide no device item. 
                    {
                        document.getElementById(childindex).style.display = "none";
                    }
                }

                for(var j=0;j<childMap.get(i);j++){
                    let childindex = "child" + i + "_" + j;
                    if(document.getElementById(childindex).getAttribute("isHasAnyDevice") && document.getElementById(childindex).getAttribute("isHasAnyDevice") == "1"){
                        isAllNoDevice = false;
                        break;
                    }
                }
                if (isAllNoDevice) {
                    document.getElementById(packageindex).style.display = "none";
                    if(document.getElementById(cbindex).checked){
                        document.getElementById(cbindex).click();
                    }
                }
            }
            for(let [key, value] of macroMap){
                let isAllNoDevice = true;
                let isAllHide = true;
                for(var i=0;i<value;i++){
                    let childKey = i + key;
                    let id = "packageindex" + (childKey);
                    if(document.getElementById(id).getAttribute("isHasAnyDevice") == "1"){
                        isAllNoDevice = false;
                        break;
                    }
                    if(document.getElementById(id).style.display != "none"){
                        isAllHide = false;
                        break;
                    }
                    if(childMap.has(childKey)){
                        for (var j = 0; j < childMap.get(childKey); j++) {
                            let childindex = "child" + childKey + "_" + j;
                            if (document.getElementById(childindex).getAttribute("isHasAnyDevice") == "0") {
                                document.getElementById(childindex).style.display = "none";
                            }
                        }

                        for(var j=0;j<childMap.get(childKey);j++){
                            let childindex = "child" + childKey + "_" + j;
                            if(document.getElementById(childindex).getAttribute("isHasAnyDevice") && document.getElementById(childindex).getAttribute("isHasAnyDevice") == "1"){
                                isAllNoDevice = false;
                                break;
                            }
                        }
                    }
                }
                if(isAllNoDevice && isAllHide){
                    let id  = "macroindex" + key;
                    document.getElementById(id).style.display = "none";
                }
            }
        }
        setTableStatus();
        setTreeImg();
    }

    return {
        init: co_init,
        backEntry: co_backEntry,
        index: 0,
        name: "Update_Comparison",
        selectUp: selectUp,
        nextAction: ()=>{
            return top.gl_multi_server_management? co_collect_multi(): co_collect();
        },
        previousAction: enNextBtn,
        selectContent: selectContent,
        selectMacro: selectMacro,
        // forceidContent: forceidContent,
        toggleChildrenNode: toggleChildrenNode,
        toggleMacroNode: toggleMacroNode,
        importId: '#import_update_comparison',
        selectorId: '.update_comparison',
        title: "Navi.UpdateComparison",
        localizedTitle: tr("Navi.UpdateComparison"),
        stopCalculagraph: stopCalculagraph,
        tableScroll: tableScroll,
        needRefresh: true,
        beginCompare: startCompareProcess,
        cancelCompare: cancelCompare,
        showMissingDetail: showMissingDetail,
        hideMissingDetail: hideMissingDetail,
        continueCompare: continueCompare,
        showNoAdapters:comp_ShowNoAdapters,
        ExpandMultiResult: ExpandMultiResult,
        CollapseMultiResult: CollapseMultiResult,
        toggleForceCheckbox: toggleForceCheckbox,
        acquireList: new Array()
    }

}();
