// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Target_Server = function () {
	let vue_app = undefined;

	let log = console.log;

	let PASSWORD_NEED_RESET = "54";

	var crypt_temp_file = top.pathJoin(top.basePath(), "multi_server.json");

	let certIMMTempFile = top.pathJoin(top.getSupportDir(), "IMM_Cert.txt");

	let local_network_file = top.pathJoin(top.getEnv("TMP"), "onecli_discover_network_info.json");
	let check_result_file = top.pathJoin(top.getSupportDir(), "check_result_file.json");
	let selectInfo = Vue.reactive({
		Type: ""
	});

	let supportList = Vue.reactive({
		show: false,
		data: []
	});

	let selectInfoTypeWatch = function (newVal) {
		let newShowStep = [];
		resetAllErrorInfo();
		supportList.show = false;
		if (top.bCheckForLatest) {
			newShowStep = [Welcome, Proxy_Setting, Obtain_Latest_Version, Target_Server, Update_Task, Finish];
		} else {
			newShowStep = [Welcome, Target_Server, Update_Task, Finish];
		}
		checkNext = function () {
			return true;
		}
		top.gl_direct_connect = false;
		switch (newVal) {
			case "ManageRemoteServer":
				top.gl_task = [];
				configSteps(newShowStep);
				top.gl_OOB_Params.Enabled = true;
				top.gl_Inband_Params.Enabled = false;
				checkNext = checkNextForRemoteServerManage;
				break;
			case "ManageLocalServer":
				top.gl_task = [];
				configSteps(newShowStep);
				top.gl_OOB_Params.Enabled = false;
				top.gl_Inband_Params.Enabled = true;
				checkNext = checkInbandInput;
				break;
			case "CreateRepository":
				top.gl_task = [top.gl_createRepo];
				newShowStep.splice(newShowStep.indexOf(Update_Task), 1, Update_Type, Machine_Types, Target_Operating_Systems, Target_Directory, Update_Selection, Acquire_Updates, Task_Complete);
				if (!top.bCheckForLatest) {
					newShowStep.splice(newShowStep.indexOf(Machine_Types), 0, Proxy_Setting);
				}
				configSteps(newShowStep);
				top.gl_OOB_Params.Enabled = false;
				top.gl_Inband_Params.Enabled = false;
				break;
			case "BatchManageServers":
				top.gl_task = [];
				newShowStep.splice(newShowStep.indexOf(Update_Task), 0, Server_Pool);
				configSteps(newShowStep);
				top.gl_OOB_Params.Enabled = true;
				top.gl_Inband_Params.Enabled = false;
				break;
			case "DirectConnect":
				top.gl_task = [];
				newShowStep.splice(newShowStep.indexOf(Update_Task), 0, Direct_Connection_Setting);
				configSteps(newShowStep);
				top.gl_OOB_Params.Enabled = true;
				top.gl_Inband_Params.Enabled = false;
				top.gl_direct_connect = true;
				checkNext = checkNextForDirectConnect;
				break;
		}
	}

	let localBmcInfo = Vue.reactive({
		userName: "",
		password: "",
		cimPort: "",
		restPort: "",
		customInput: false
	});

	let directConnectBmcInfo = Vue.reactive({
		defaultIP: "192.168.70.125",
		userName: "USERID",
		password: "PASSW0RD",
		mustChangePassword: false,
		newPassword1: "",
		newPassword2: "",
		verifyOk: false
	});

	let oobBmcInfo = Vue.reactive({
		userName: "",
		password: "",
		ip: "",
		port: "",
		ipList: {},
		value: "",
		mustChangePassword: false,
		newPassword1: "",
		newPassword2: "",
		verifyOk: false,
		onecliIsRunning: false,
		skipCertCheck: false,
		verifyIp: function () {
			return top.checkHostName(this.ip);
		}
	});

	let chooseNetworkId = Vue.reactive({
		show: false,
		info: [
			{
				id: 1,
				name: "network 1"
			},
			{
				id: 4,
				name: "network 2"
			},
			{
				id: 6,
				name: "network 3"
			}
		],
		currentId: null,
		cancel: function () {
			this.show = false;
		},
		ok: function () {
			currentId = null;
			this.show = false;
		}
	});

	let dialog = Vue.reactive({
		bmcCertificate: {
			show: false,
			text: "",
			certCheckOk: false,
			ok: function () {
				this.show = false;
				let certIMMSaveFile = "IMM_" + this.ip + ".txt";
				top.writeTextFile(certIMMSaveFile, this.certText);
				gl_wizard.steps("next");
			},
			cancel: function () {
				this.show = false;
			}
		},
	});

	let errorInfo = Vue.reactive({
		code: "",
		info: "",
		detail: "",
		showErrorInfoDetail: false,
		reset: function () {
			this.code = "";
			this.info = "";
			this.detail = "";
			this.showOnecliFailInfo = false;
		}
	})

	let resetAllErrorInfo = function () {
		errorInfo.error = "";
		errorInfo.info = "";
		errorInfo.detail = "";
	}
	function GetCert(ip, port, callback) {
		deleteFile(top.getSupportFile("commonResult"));
		let certIMMSaveFile = "IMM_" + ip + ".txt";
		certIMMSaveFile = top.pathJoin(top.getSupportDir(), certIMMSaveFile);
		let onecliExited = function (success, error, stdout, stderr, errorCode) {
			if (!success) {
				errorInfo.info = $.i18n.prop("TargetServer.GetTrustFailed");
				errorInfo.detail = stderr;
			}
			if (!top.fileExists(certIMMTempFile)) {
				errorInfo.info = $.i18n.prop("TargetServer.GetTrustFailed");
				success = false;
			}
			let savedCert = top.readTextFile(certIMMSaveFile);
			let currentCert = top.readTextFile(certIMMTempFile);
			if (savedCert == null) {
				top.writeTextFile(certIMMSaveFile, currentCert);
				savedCert = currentCert;
			}
			if (currentCert != null) {
				success = currentCert == savedCert;
			}
			try {
				if (callback) {
					callback({
						ok: success,
						pem: currentCert
					});
				}
			} catch (exp) {
				printLog(Error, exp);
			}
		}
		top.deleteFile(certIMMTempFile);
		let args = [
			top.getSystemFile("oneCli"),
			"misc",
			"gettrust",
			"--host",
			ip,
			"--type",
			"https",
			"--result",
			certIMMTempFile,
			...add_output_log5()
		];
		if (port) {
			args.push("--port");
			args.push(port);
		}
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onecliExited);
	}

	let getConnectionInfo = function (ip, port, userName) {
		if (ip.includes(":")) {
			if (port && port != "") {
				return (userName + "@[" + ip + "]:" + port);
			} else {
				return (userName + "@[" + ip + "]");
			}
		} else {
			if (port && port != "") {
				return (userName + "@" + ip + ":" + port);
			} else {
				return (userName + "@" + ip);
			}
		}
	}

	async function encrypt(ip, port, userName, password) {
		let ipText = ip;
		if (top.isIPV6(ip)) {
			ipText = "[" + ip + "]";
		}
		let multiData = {
			connection_credentials: {
				"default_alias": userName + ":" + password
			},
			target_systems: [
				ipText + (port ? ":" + port : "")
			]
		}
		try {
			top.writeTextFile(crypt_temp_file, JSON.stringify(multiData, null, 2));
		} catch (e) {
			log(e);
			errorInfo.info = "Write encrypt file error";
			errorInfo.detail = e;
			return false;
		}

		let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("encrypt");
		args.push("--configfile");
		args.push(crypt_temp_file);
		args.push("--unattended");
		args.push("-q");
		args.push(...add_output_log5());
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		top.deleteFile(top.getSupportFile("commonResult"));
		let result = await runProgram(args);
		top.deleteFile(crypt_temp_file);
		if (!result.success) {
			showOnecliFailInfo(tr("OneCli execute encrypt fail."), result.stderr);
			return false;
		}
		let cryptObj = JSON.parse(top.readTextFile(top.getSystemFile("crypt")));
		oobBmcInfo.key = multi_config.GetKey({ userName: userName, port: port, ip: ip });
		let item = function () {
			for (let iter of cryptObj.ENCRYPTED_INFO) {
				if (iter.key == oobBmcInfo.key) {
					return iter;
				}
			}
			return null;
		}();
		if (item) {
			oobBmcInfo.value = item.value;
			multi_config.UpdateAttend(cryptObj.MODE, cryptObj.RAND_NUM);
			return true;
		}
		return false;
	}

	let appendConnection = function (ip, port, userName, password, mt, sn, key, value) {
		multi_config.AppendOrUpdate(ip, ip, port, userName, value, mt, sn);
		if (ip in oobBmcInfo.ipList) {
			let item = oobBmcInfo.ipList[ip];
			item.port = port;
			item.mt = mt;
			item.sn = sn;
			item.userName = userName;
			item.key = multi_config.GetKey(item);
			item.value = value;
		}
	}

	let storeTargetServerInfo = function (ip, port, userName, mt, sn) {
		// Store server info to following tasks
		Server_Pool.selectedServerList = [{
			ip: ip,
			port: port,
			userName: userName,
			mt: mt,
			sn: sn
		}];
		Banner.set_active_status(mt, "");
		// Initiate recommendation related to target serve here
		function aTAG(content, url) {
			let aTag = document.createElement("a");
			aTag.href = url;
			aTag.target = "_blank";
			aTag.innerText = content;
			aTag.setAttribute("onclick", 'event.preventDefault();top.openExternal(this.href);');
			return aTag.outerHTML;
		}
		let httpsAddr = "https://" + ip;
		if (port != undefined && port != null && port != "") {
			httpsAddr += ":" + port;
		}
		top.gl_errorcodeToRecommendedAction[0x5a] = tr("Recommendation.Firmware.GsensorConfigError", aTAG(httpsAddr, httpsAddr));
		top.gl_errorcodeToRecommendedAction[0x59] = tr("Recommendation.Firmware.ChassisIntrusionConfigError", aTAG(httpsAddr, httpsAddr));
		top.gl_errorcodeToRecommendedAction[0x57] = tr("Recommendation.Firmware.GsensorConfigError", aTAG(httpsAddr, httpsAddr));
		top.gl_errorcodeToRecommendedAction[0x56] = tr("Recommendation.Firmware.ChassisIntrusionConfigError", aTAG(httpsAddr, httpsAddr));
        top.gl_errorcodeToRecommendedAction[0x52] = tr("Recommendation.ThinkShield.LocalActivate", aTAG(httpsAddr, httpsAddr));
	};
	async function discoverMachine(ip) {
		let args = [
			top.getSystemFile("oneCli"),
			"discover",
			"--ip",
			ip,
			"--noslp",
			"--noslpdiscover",
			"--nossdp",
			...add_output_log5()
		];
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		let discoverFileName = top.getSupportFile("discoverResult");
		top.deleteFile(discoverFileName);
		let result = await top.runProgram(args);
		if (!result.success) {
			showOnecliFailInfo("discover machine fail", result.stderr);
			return false;
		}
		let rootObj = JSON.parse(top.readTextFile(discoverFileName));
		top.deleteFile(discoverFileName);
		return rootObj.Find == 1;
	}

	async function addIPToNetwork(ip, network_id) {
		errorInfo.reset();
		let args = [
			top.getSystemFile("oneCli"),
			"ux",
			"addip",
			"--network-id",
			network_id,
			...add_output_log5()
		]
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		let result = await top.runProgram(args);
		if(!result.success){
			showOnecliFailInfo("Add IP to network fail", result.stderr);
		}
		args = [
			top.getSystemFile("oneCli"),
			"ux",
			"restore",
			...add_output_log5()
		];
		top.setCleanCommand(args);
		return result.success;
	}

	async function discoverLocalNetwork() {
		let args = [
			top.getSystemFile("oneCli"),
			"ux",
			"network",
			...add_output_log5()
		]
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		result = await runProgram(args);
		if (!result.success) {
			printLog("ERROR", result);
			showOnecliFailInfo(tr("Fetch network information error"), result.stderr);
			return false;
		}
		try {
			let data = top.readTextFile(local_network_file);
			let rootObj = JSON.parse(data);
			chooseNetworkId.info = [];
			for (let item of rootObj) {
				chooseNetworkId.info.push({
					id: item.ID,
					name: item.Name,
					description: item.Description
				});
			}
			if (rootObj.length == 0) {
				return false;
			} else if (rootObj.length == 1) {
				chooseNetworkId.currentId = chooseNetworkId.info[0].id;
				return true;
			} else {
				chooseNetworkId.show = true;
				return new Promise(function (resolve) {
					chooseNetworkId.ok = function () {
						chooseNetworkId.show = false;
						resolve(true);
					}
					chooseNetworkId.cancel = function () {
						chooseNetworkId.show = false;
						resolve(false);
					}
				});
			}
		} catch (exp) {
			printLog("ERROR", exp);
			return false;
		}
	}
	async function checkBmcAccount(ip, port, userName) {
		let args = [
			top.getSystemFile("oneCli"),
			"ux",
			"check-bmc-account",
			"--bmc",
			getConnectionInfo(ip, port, userName),
			"--never-check-trust",
			"--noping",
			...add_output_log5()
		]
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		let result = await runProgram(args);
		if (result.success) {
			return true;
		}
		if (result.errorCode == PASSWORD_NEED_RESET) {
			directConnectBmcInfo.mustChangePassword = true;
		} else {
			showOnecliFailInfo(tr("Connect to BMC fail."), result.stderr);
		}
		return false;
	}
	let doScan = function (userName, password, ip, port, callback) {
		let _doScan = function (cert) {
			deleteFile(top.getSupportFile("commonResult"));
			let args = [];
			args.push(top.getSystemFile("oneCli"));
			args.push("update");
			args.push("scan");
			args.push("--bmc");
			args.push(getConnectionInfo(ip, port, userName));
			args.push("--never-check-trust");
			args.push(...add_output_log5());
			args.push("--skipfw");
			top.store_onecli_command(args);
			printLog("INFO", "run command:" + getRunProgramCommend(args));

			let onScanFinished = function (success, errorCode, stderr) {
				console.log(success);
				try {
					errorInfo.code = errorCode;
					let commonResult = top.getSupportFile("commonResult");
					let xmlContent = top.readTextFile(commonResult);
					if (!xmlContent) {
						errorInfo.info = $.i18n.prop("TargetServer.TipsInfo8");
						errorInfo.detail = stderr;
						if (errorInfo.code == PASSWORD_NEED_RESET) {
							callback(true, "", "", cert, true)
							return;
						}
						callback(false);
						return;
					}
					let comm_dom = ezJsLib.XmlDom.parse(xmlContent);
					if ("Yes" == ezJsLib.XmlDom.getValueByTagFromNode("ERROR", comm_dom.documentElement)) {
						errorInfo.detail = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
						errorInfo.code = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", comm_dom.documentElement);
					}
					if (!success) {
						errorInfo.info = $.i18n.prop("TargetServer.TipsInfo8");
						if (errorInfo.code == PASSWORD_NEED_RESET) {
							callback(true, "", "", cert, true)
							return;
						}
						callback(false);
						return;
					}
					let doc = top.readTextFile(top.getSupportFile("scanResult"));
					let dom = ezJsLib.XmlDom.parse(doc);
					let mt = ezJsLib.XmlDom.getValueByTagFromNode("MT", dom.documentElement);
					let sn = ezJsLib.XmlDom.getValueByTagFromNode("SN", dom.documentElement);
					oobBmcInfo.mt = mt;
					oobBmcInfo.sn = sn;
					callback(true, mt, sn, cert, false);
					return;
				} catch (e) {
					errorInfo.info = $.i18n.prop("TargetServer.TipsInfo8");
					errorInfo.detail = e;
				}
				callback(false);
			}
			runProgram(args, null, function (success, error, stdout, stderr, errorCode) {
				onScanFinished(success, errorCode, stderr);
			});
		}
		if (dialog.certCheckOk) {
			_doScan({ ok: true, pem: "" });
			return;
		}
		GetCert(ip, port, function (cert) {
			if (!cert.pem) {
				errorInfo.info = tr("Get cert failed");
				if (callback) {
					callback(false);
				}
				return;
			}
			_doScan(cert);
		});
	};

	let checkInbandInput = function () {
		if (!localBmcInfo.customInput) {
			return true;
		}
		if (!localBmcInfo.userName && localBmcInfo.password) {
			$("#target-server-username").focus();
			errorInfo.info = $.i18n.prop("TargetServer.TipsInfo1");
			return false;
		}
		if (!localBmcInfo.password && localBmcInfo.userName) {
			$("#target-server-password").focus();
			errorInfo.info = $.i18n.prop("TargetServer.TipsInfo1");
			return false;
		}
		if (localBmcInfo.cimPort
			&& (isNaN(localBmcInfo.cimPort)
				|| localBmcInfo.cimPort < 1
				|| localBmcInfo.cimPort > 65535)) {
			$("#target-server-cimPort").focus();
			errorInfo.info = $.i18n.prop("Common.Port.Warning");
			return false;
		}
		if (localBmcInfo.restPort
			&& (isNaN(localBmcInfo.restPort)
				|| localBmcInfo.restPort < 1
				|| localBmcInfo.restPort > 65535)) {
			$("#target-server-restPort").focus();
			errorInfo.info = $.i18n.prop("Common.Port.Warning");
			return false;
		}
		return true;
	};

	let showOnecliFailInfo = function (msg = tr('Execute onecli command fail.'), stderr = "") {
		let commonResult = top.getSupportFile("commonResult");
		let xmlContent = top.readTextFile(commonResult);
		errorInfo.info = msg;
		if (!xmlContent) {
			errorInfo.info = msg;
			errorInfo.detail = stderr;
			return;
		}
		let comm_dom = ezJsLib.XmlDom.parse(xmlContent);
		if ("Yes" == ezJsLib.XmlDom.getValueByTagFromNode("ERROR", comm_dom.documentElement)) {
			errorInfo.detail = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
			errorInfo.code = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", comm_dom.documentElement);
		}
	};

	let vue_class = {
		data() {
			return {
				selectInfo: selectInfo,
				localBmcInfo: localBmcInfo,
				dialog: dialog,
				errorInfo: errorInfo,
				oobBmcInfo: oobBmcInfo,
				supportList: supportList,
				chooseNetworkId: chooseNetworkId,
				directConnectBmcInfo: directConnectBmcInfo
			}
		},
		methods: {
			checkIsAmd: function () {
				return top.isAmd(top.gl_current_mt);
			},
			checkIsCFC: function () {
				return top.isCFC(top.gl_current_mt);
			},
			checkIsBootable: function () {
				return top.gl_uxlite_bootable;
			},
			cancelOnecli: function () {
				top.killOneCli();
			},
			onChangePassword: function (ip, port, userName, newPassword) {
				oobBmcInfo.onecliIsRunning = true;
				errorInfo.reset();
				ChangePassword(ip, port, userName, newPassword, function (success, stderr) {
					if (success) {
						return;
					}
					oobBmcInfo.onecliIsRunning = false;
					showOnecliFailInfo(tr("Change password failed."), stderr);
				});
			},
			osType: function(){
				return top.OSTYPE;
			},
			nextAction: () => top.gl_wizard.steps("next"),
			tr: top.tr
		},
		watch: {
			"selectInfo.Type": selectInfoTypeWatch,
			"localBmcInfo.customInput": function (val) {
				errorInfo.info = "";
				top.gl_Inband_Params.UserInput = val;
			},
			"localBmcInfo.userName": function (val) {
				top.gl_Inband_Params.IMM_UserName = val;
			},
			"localBmcInfo.password": function (val) {
				top.gl_Inband_Params.IMM_Password = val;
			},
			"localBmcInfo.cimPort": function (val) {
				top.gl_Inband_Params.IMM_Port = val;
			},
			"localBmcInfo.restPort": function (val) {
				top.gl_Inband_Params.REST_Port = val;
			},
			"oobBmcInfo.ip": function (val) {
				dialog.bmcCertificate.certCheckOk = false;
				oobBmcInfo.verifyOk = false;
				if (val in oobBmcInfo.ipList) {
					let item = oobBmcInfo.ipList[val];
					oobBmcInfo.userName = item.userName;
					oobBmcInfo.userNameBk = oobBmcInfo.userName;
					oobBmcInfo.value = item.value;
					oobBmcInfo.port = item.port;
					oobBmcInfo.password = item.password;
				} else {
					oobBmcInfo.value = "";
					// console.log(oobBmcInfo.password);
				}
			},
			"oobBmcInfo.userName": function (val) {
				dialog.bmcCertificate.certCheckOk = false;
				if (val != oobBmcInfo.userNameBk) {
					oobBmcInfo.value = "";
					oobBmcInfo.userNameBk = val;
				}
				oobBmcInfo.verifyOk = false;
			},
			"oobBmcInfo.password": function (val) {
				dialog.bmcCertificate.certCheckOk = false;
				oobBmcInfo.verifyOk = false;
			},
			"oobBmcInfo.port": function (val) {
				dialog.bmcCertificate.certCheckOk = false;
				oobBmcInfo.verifyOk = false;
			},
			"oobBmcInfo.skipCertCheck": function (val) {
				dialog.bmcCertificate.certCheckOk = false;
				oobBmcInfo.verifyOk = false;
			},
			"directConnectBmcInfo.mustChangePassword": function (val) {
				top.toggleNext(!val);
			}
		},

		directives: {
			focus: {
				mounted(el) {
					el.focus();
				}
			}
		},

		computed: {
			passwordValid() {
				if (oobBmcInfo.value === "") {
					if (oobBmcInfo.password) {
						return true;
					} else {
						return false;
					}
				}
				return true;
			}
		}
	}

	function init() {
		printLog("INFO", "TargetServer page init.");

		Banner.set_active_status("", "");
		supportList.data = top.loadSetting("multi_server_management_support_list.json");

		init_vue();
	};

	function needForceCompare() {
		top.initForceCompare();
		if (top.is_autorun() || top.is_unattend() || top.isAmd(top.gl_current_mt)) {
			// AMD servers do not need offer bmc information, skip this page like autorun mode
			top.gl_Inband_Params.UserInput = false;
			gl_wizard.steps("next");
		}
	};

	async function ChangePassword(ip, port, userName, newPassword, callback) {
		deleteFile(top.getSupportFile("commonResult"));
		let onecliExited = async function (success, error, stdout, stderr, errorCode) {
			if(success){
				directConnectBmcInfo.mustChangePassword = false;
				oobBmcInfo.mustChangePassword = false;
				oobBmcInfo.password = newPassword;
				directConnectBmcInfo.password = newPassword;
				gl_wizard.steps("next");
			}
			if (callback) {
				callback(success, stderr);
			}
		}
		let args = [
			top.getSystemFile("oneCli"),
			"misc",
			"bmcpassword",
			"--bmc",
			getConnectionInfo(ip, port, userName),
			"--never-check-trust",
			"--newpwd",
			newPassword,
			"--quiet",
			...add_output_log5()
		];
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onecliExited);
	};


	let checkNextForDirectConnect = function () {
		directConnectBmcInfo.verifyOk = true;
		return true;
	}
	let checkNextForRemoteServerManage = function () {
		if (oobBmcInfo.ip === "") {
			$("#oobinfo-ipaddr").focus();
			errorInfo.info = $.i18n.prop("Common.RquiredField");
			return false;
		}
		if (!top.checkHostName(oobBmcInfo.ip)) {
			$("#oobinfo-ipaddr").focus();
			errorInfo.info = $.i18n.prop("Common.IllegalServerAddress");
			return false;
		}
		if (oobBmcInfo.userName === "") {
			$("#oobinfo-username").focus();
			errorInfo.info = $.i18n.prop("Common.RquiredField");
			return false;
		}

		if (!oobBmcInfo.password && !oobBmcInfo.value) {
			$("#oobinfo-password").focus();
			errorInfo.info = $.i18n.prop("Common.RquiredField");
			return false;
		}
		if (oobBmcInfo.port != "") {
			let port = parseInt(oobBmcInfo.port);
			if (port < 1 || port > 65535) {
				errorInfo.info = $.i18n.prop("Common.Port.Warning");
				return false;
			}
		}
		return true;
	};


	let checkNext = checkNextForRemoteServerManage;

	async function remoteManagementNext() {
		if (oobBmcInfo.password) {
			await encrypt(oobBmcInfo.ip, oobBmcInfo.port, oobBmcInfo.userName, oobBmcInfo.password);
		}
		doScan(oobBmcInfo.userName, oobBmcInfo.password, oobBmcInfo.ip, oobBmcInfo.port, function (success, mt, sn, cert, mustChangePassword) {
			oobBmcInfo.onecliIsRunning = false;
			if (mustChangePassword) {
				oobBmcInfo.mustChangePassword = true;
			}
			else if (success) {
				if (!top.checkSupportMachineType(mt)) {
					alert($.i18n.prop("Common.SystemNotSupport"));
					return;
				}
				Banner.set_active_status(mt, "");
				if (!cert.ok) {
					if (oobBmcInfo.skipCertCheck) {
						let certIMMSaveFile = "IMM_" + oobBmcInfo.ip + ".txt";
						certIMMSaveFile = top.pathJoin(top.getSupportDir(), certIMMSaveFile);
						top.writeTextFile(certIMMSaveFile, cert.pem);
						gl_wizard.steps("next");
						return;
					}
					dialog.bmcCertificate.text = cert.pem;
					dialog.bmcCertificate.show = true;
					dialog.bmcCertificate.ok = function () {
						let certIMMSaveFile = "IMM_" + oobBmcInfo.ip + ".txt";
						certIMMSaveFile = top.pathJoin(top.getSupportDir(), certIMMSaveFile);
						top.writeTextFile(certIMMSaveFile, cert.pem);
						dialog.bmcCertificate.certCheckOk = true;
						oobBmcInfo.verifyOk = true;
						dialog.bmcCertificate.show = false;
						gl_wizard.steps("next");
					};
					return;
				}
				oobBmcInfo.verifyOk = true;
				gl_wizard.steps("next");
			}
		})
	}

	function next() {
		resetAllErrorInfo();
		if (!checkNext()) {
			return false;
		}
		top.gl_multi_server_management = selectInfo.Type === "BatchManageServers";
		if (selectInfo.Type === "ManageRemoteServer") {
			oobBmcInfo.mustChangePassword = false;
			if (oobBmcInfo.verifyOk) {
				if (!top.checkSupportMachineType(oobBmcInfo.mt)) {
					alert($.i18n.prop("Common.SystemNotSupport"));
					return false;
				}
				appendConnection(oobBmcInfo.ip, oobBmcInfo.port, oobBmcInfo.userName, oobBmcInfo.password, oobBmcInfo.mt,
					oobBmcInfo.sn, oobBmcInfo.key, oobBmcInfo.value);
				storeTargetServerInfo(oobBmcInfo.ip, oobBmcInfo.port, oobBmcInfo.userName, oobBmcInfo.mt, oobBmcInfo.sn);
				return true;
			}
			oobBmcInfo.onecliIsRunning = true;
			remoteManagementNext();
			return false;
		}
		else if (["BatchManageServers", "CreateRepository"].includes(selectInfo.Type)) {
			top.onecliCommandStrings = [""];
			top.logFiles = [""];
			top.gl_mt_list = new Array();
			top.gl_os_list = new Array();
			return true;
		}
		else if (selectInfo.Type === "ManageLocalServer" || top.gl_uxlite_bootable) {
			if (!top.checkSupportMachineType(top.gl_current_mt)) {
				if (top.gl_current_admin_account == "YES") {
					alert($.i18n.prop("Common.SystemNotSupport"));
					return false;
				} else {
					alert($.i18n.prop("Common.AdminAcquired"));
					return false;
				}
			}
			if (top.gl_uxlite_bootable != "1") {
				// Bootable will be set with BootableMedia_xxx
				Banner.set_active_status(top.gl_current_mt, top.gl_current_os_d);
			}
			return true;
		}
		else if (selectInfo.Type === "DirectConnect") {
			return true;
		}
		return true;
	}

	async function init_vue() {
		multi_config.Load();
		oobBmcInfo.ipList = {};
		for (let item of multi_config.Data().ENCRYPTED_INFO) {
			oobBmcInfo.ipList[item.ip] = {
				ip: item.ip,
				port: item.port,
				mt: item.mt,
				sn: item.sn,
				userName: item.userName,
				key: item.key,
				value: item.value
			}
		}
		directConnectBmcInfo.verifyOk = false;
		if (vue_app != undefined) {
			return;
		}
		vue_app = Vue.createApp(vue_class);
		vue_app.mount('#vue-target-server');
		top.gl_curTaskIndex = 0;
		errorInfo.info = "";
		if (top.gl_uxlite_bootable) {
			top.gl_OOB_Params.Enabled = false;
			top.gl_Inband_Params.Enabled = true;
			top.gl_task = [top.gl_isUpdate];
			top.onecliCommandStrings = [""];
			top.logFiles = [""];
			// Collect mt information for ELIE mode as it will skip Update_Task step
			top.gl_mt_list = new Array();
			top.gl_os_list = new Array();
			top.gl_mt_list.push(top.gl_current_mt);
			top.gl_os_list.push(top.gl_current_os);
			checkNext = checkInbandInput;
			setTimeout(needForceCompare, 1000);
		} else {
			if (selectInfo.Type === "") {
				selectInfo.Type = "ManageRemoteServer";
			}
		}
	}

	function uninit() {
		if (vue_app != undefined) {
			vue_app.unmount();
			vue_app = undefined;
		}
	}

	return {
		index: 0,
		name: "Target_Server",
		init: init,
		nextAction: next,
		previousAction: function () {
			printLog("INFO", "Previous was clicked.");
			return true;
		},
		importId: '#import_target_server',
		selectorId: '.target_server',
		title: "Navi.TargetServer",
		localizedTitle: tr("Navi.TargetServer"),
		needReInit: true,
		uninit: uninit
	}
}();