// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
TShield_Setting = function () {

    let tsInfo = {
        UserName: "", 
        Password: "", 
        Group: "",
        OTP: ""
    };

    let taskDone = false;

    let isCouldSkipDefault;

    // let commandStage = "init";
    let commandStage = new Map();
    commandStage.set(gl_syncEdgeStatus, "init");
    commandStage.set(gl_portal_activate, "init");
    commandStage.set(gl_portalActivation, "init");

    let tokenFile;
    let challengeResponse;

    // Total retry times if failed
    let DEFAULT_RETRY_TIMES = 2;
    let maxRetryTimes = 0;
    let currentRetriedTimes = 0;
    // Current command's info
    let currentFunc;
    let currentDivId;

    function setTaskUnDone(){
        taskDone = false;
    }

    function createATag(content, url) {
        let aTag = document.createElement("a");
        aTag.href = url;
        aTag.target = "_blank";
        aTag.innerText = content;
        return aTag.outerHTML;
    }
    function setUrlContainer(id, content) {
        document.getElementById(id).innerHTML = content;
        setExternalExplorer(document.getElementById(id).getElementsByTagName("a")[0]);
    }

    function resetExternalUrl() {
        let link1 = createATag($.i18n.prop("TShieldSetting.Pattern3"), "https://lenovopress.lenovo.com/lp1725-thinkedge-security");
        setUrlContainer("activate_ts_help", $.i18n.prop("TShieldSetting.ActivateHelp", link1));

        let link2 = createATag($.i18n.prop("TShieldSetting.Pattern2"), "https://support.lenovo.com/us/en/solutions/ht509195");
        setUrlContainer("create_ts_userid_activate", $.i18n.prop("TShieldSetting.CreateUserIntroForActivate", link2));

        let link3 = createATag($.i18n.prop("TShieldSetting.Pattern1"), "https://lenovopress.lenovo.com/lp1725-thinkedge-security");
        setUrlContainer("create_ts_userid_claim2", $.i18n.prop("TShieldSetting.CreateUserIntroForClaim2", link3));

        let link4 = createATag($.i18n.prop("TShieldSetting.Pattern1"), "https://lenovopress.lenovo.com/lp1725-thinkedge-security");
        setUrlContainer("create_ts_orgid", $.i18n.prop("TShieldSetting.CreateOrgIntro", link4));

        let link5 = createATag($.i18n.prop("TShieldSetting.Pattern1"), "https://portal.thinkshield.lenovo.com/remindDomain");
        setUrlContainer("find_ts_orgid", $.i18n.prop("TShieldSetting.FindOrgIntro", link5));
    }

    function TS_init() {
        printLog("INFO","TShield Setting page init.");
        // top.gl_isAccountValidated = false;
        if (commandStage.get(getTaskName()) == "done") {
            top.togglePrevious(true);
            top.toggleNext(false);
        } else {
            top.togglePrevious(true);
            top.toggleNext(false);
            // If we disable input, the elements with same ID in subPageContainer are also disabled.
            // Next time this page loaded the elements are still disabled.
            /* $("#TSUserName,#TSPassword,#TSGroup").prop("disabled", false);
            $("#TSbutton").prop("disabled", false);
            $("#TSbutton").css("background", "#0e72ac");
            $("#TSbutton").css("color", "#fff");
            top.toggleNext(taskDone); */
        }
        // Enable external url
        resetExternalUrl();

        $('#TSStartButtonDiv > div')[0].style = "margin-left:33.33333333%";
        $('#tshield_setting_subtitle').show();

        if (gl_syncEdgeStatus == getTaskName()) {
            document.getElementById("TSMainHeader").innerText = $.i18n.prop("Navi.SyncEdgeStatus");
            document.getElementById("create_ts_userid_claim1").style.display = "block";
            document.getElementById("create_ts_userid_claim2").style.display = "block";
            document.getElementById("TS_inputbox").style.display = "block";
            document.getElementById("TSbutton").innerText = $.i18n.prop("TShieldSetting.SyncBtn");
        } else if (gl_portal_activate == getTaskName()) {
            if (top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[3]) { // ThinkEdge_Local_Inactive
                document.getElementById("TSMainHeader").innerText = $.i18n.prop("Navi.TShieldSetting"); 
                document.getElementById("TSbutton").innerText = tr("Activate");
                $('#TSStartButtonDiv > div')[0].style = "margin-left:15px";
                $('#tshield_setting_subtitle').hide();
            } else {
                document.getElementById("TSMainHeader").innerText = $.i18n.prop("Navi.TShieldSetting");
                document.getElementById("create_ts_userid_activate").style.display = "block";
                document.getElementById("create_ts_orgid").style.display = "block";
                document.getElementById("find_ts_orgid").style.display = "block";
                document.getElementById("activate_msg").style.display = "block";
                document.getElementById("TS_inputbox").style.display = "block";
                document.getElementById("TSbutton").innerText = $.i18n.prop("TShieldSetting.ActivateBtn");
            }
        } else if (gl_portalActivation == getTaskName()) {
            document.getElementById("TSMainHeader").innerText = $.i18n.prop("TShieldSetting.ValidateTile");
            document.getElementById("create_ts_userid_activate").style.display = "block";
            document.getElementById("create_ts_orgid").style.display = "block";
            document.getElementById("find_ts_orgid").style.display = "block";

            document.getElementById("TS_inputbox").style.display = "block";
            document.getElementById("TSbutton").innerText = $.i18n.prop("TShieldSetting.ValidateBtn");
        }
        tokenFile = top.getSupportFile("tokenFile");
    }

    function writeTSParams(){
        tsInfo.UserName = $("#TSUserName").val();
		tsInfo.Password = $("#TSPassword").val();
		tsInfo.Group    = $("#TSGroup").val();
        // tsInfo.OTP      = $("#TSOTP").val();
	}

    function showTipsInfo(str, id){
		if (str == ""){
			$("#TSTips").hide();
			return;
		}
		$("#"+id).show();
		$("#"+id+"Info").html(str);
	}

    function checkParamIsNull(){
		var ret = "";
		$(["TSGroup", "TSUserName", "TSPassword"]).each(function(i, n){
			let value=$("#" + n).val();
			if(!value || value == ""){
				ret = "TSTips";
				$("#"+n).focus();
				return false;
			}
		});
		return ret;
	}

    function progressSetSuccess(progressId) {
        document.getElementById(progressId).src = "images/statusSuccess_obj16.gif";
    }
    function progressSetRunning(progressId) {
        document.getElementById(progressId).src = "images/progress_anim2_small.gif";
    }
    function progressSetFailed(progressId) {
        document.getElementById(progressId).src = "images/statusCritical_obj16.gif";
    }

    function getCommonResult() {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, errCode;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            errCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return { msg : resultMsg, code : errCode };
        } else {
            return { msg : top.getComErrMsg(), code : null };
        }
    }

    function taskFailed() {
        progressSetFailed(currentDivId);
        let currentMessageDiv = document.getElementById(currentDivId).parentNode.getElementsByClassName("ErrorMessage")[0];
        let currentRecommendationDiv = document.getElementById(currentDivId).parentNode.getElementsByClassName("Recommendation")[0];
        currentMessageDiv.style.display="block";
        currentRecommendationDiv.style.display="block";
        let res = getCommonResult();
        currentMessageDiv.innerHTML = $.i18n.prop("UpdateExec.ErrorMsg", res.msg);
        if(res.code != null && res.code != undefined && top.gl_errorcodeToRecommendedAction[Number(res.code)] != undefined){
            currentRecommendationDiv.innerHTML = top.gl_errorcodeToRecommendedAction[Number(res.code)];
        }
        taskAllComplete(false);
    }
    function taskRetry() {
        if (currentRetriedTimes < maxRetryTimes) {
            currentFunc();
        } else {
            taskFailed();
        }
    }
    function taskRun(cmdDivId, cmdFunc, retryTimes) {
        currentDivId = cmdDivId;
        currentFunc = cmdFunc;
        $("#"+currentDivId).parent().show();
        progressSetRunning(currentDivId);
        currentRetriedTimes = 0;
        if (retryTimes != undefined) {
            maxRetryTimes = retryTimes;
        } else {
            maxRetryTimes = DEFAULT_RETRY_TIMES;
        }
        currentFunc();
    }

    function taskAllComplete(success) {
        if (success == true) {
            commandStage.set(getTaskName(), "done");
            // commandStage = "init";
            taskDone = true;
            // top.togglePrevious(getTaskName() == top.gl_portalActivation);
            top.togglePrevious(true);
            top.toggleNext(true);
            if (getTaskName() == top.gl_portalActivation) {
                top.gl_isAccountValidated = true;
            }
            $("#TSUserName,#TSPassword,#TSGroup").prop("disabled", false);
            $("#TSbutton").prop("disabled", false);
            $("#TSbutton").css("background", "#0e72ac");
            $("#TSbutton").css("color", "#fff");
            getCommonResult(); // only for set log file in the end
        } else {
            // $("#TSUserName,#TSPassword,#TSGroup,#TSOTP").prop("disabled", false);
            $("#TSUserName,#TSPassword,#TSGroup").prop("disabled", false);
            commandStage.set(getTaskName(), "init");
            top.togglePrevious(true);
            $("#TSbutton").prop("disabled", false);
            $("#TSbutton").css("background", "#0e72ac");
            $("#TSbutton").css("color", "#fff");
            top.toggleNext(isCouldSkipDefault);
        }
    }

    function syncEdgeStatusActive(isPreviousSuccess) {
        if (isPreviousSuccess == false) {
            return taskRetry();
        }
        switch (commandStage.get(getTaskName())) {
            case "init":
                Array.from(document.getElementById("TS_processLogs").getElementsByTagName("div")).forEach(div => {
                    div.style.display="none";
                });
                Array.from(document.getElementsByClassName("ErrorMessage")).forEach(errorMsg => {
                    errorMsg.style.display="none";
                });
                taskRun("TS_Gettoken", cmdGettoken);
                break;

            case "gettokenDone":
                progressSetSuccess("TS_Gettoken");
                taskRun("TS_Claim", cmdClaim);
                break;

            case "claimDone":
                progressSetSuccess("TS_Claim");
                if (top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[2] || // ThinkEdge_Enabled_Active
                    top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[6] || // ThinkEdge_Portal_Active
                    top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[4]) { // ThinkEdge_Local_Active
                    taskRun("TS_SetActive", cmdSetActive);
                } else if (top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[1] || // ThinkEdge_Enabled_Inactive
                           top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[5] || // ThinkEdge_Portal_Inactive
                           top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[3]) { // ThinkEdge_Local_Inactive
                    taskRun("TS_SetDeactivated", cmdSetDeactivated);
                }

                break;

            case "setActiveDone":
                progressSetSuccess("TS_SetActive");
                taskAllComplete(true);
                break;
            
            case "setDeactivatedDone":
                progressSetSuccess("TS_SetDeactivated");
                taskAllComplete(true);
                break;
        
            default:
                break;
        }
    }

    function loaclActivate(isPreviousSuccess) {
        if (isPreviousSuccess == false) {
            return taskRetry();
        }
        switch (commandStage.get(getTaskName())) {
            case "init":
                Array.from(document.getElementById("TS_processLogs").getElementsByTagName("div")).forEach(div => {
                    div.style.display="none";
                })
                Array.from(document.getElementsByClassName("ErrorMessage")).forEach(errorMsg => {
                    errorMsg.style.display="none";
                });
                taskRun("TS_Unlock", cmdUnlock);
                break;

            case "unlockDone":
                progressSetSuccess("TS_Unlock");
                taskAllComplete(true);
                break;
        
            default:
                break;
        }
    }

    function activateLocked(isPreviousSuccess) {
        if (isPreviousSuccess == false) {
            return taskRetry();
        }
        switch (commandStage.get(getTaskName())) {
            case "init":
                Array.from(document.getElementById("TS_processLogs").getElementsByTagName("div")).forEach(div => {
                    div.style.display="none";
                })
                Array.from(document.getElementsByClassName("ErrorMessage")).forEach(errorMsg => {
                    errorMsg.style.display="none";
                });
                taskRun("TS_Gettoken", cmdGettoken);
                break;

            case "gettokenDone":
                progressSetSuccess("TS_Gettoken");
                taskRun("TS_Claim", cmdClaim);
                break;

            case "claimDone":
                progressSetSuccess("TS_Claim");
                taskRun("TS_Unlock", cmdActivate);
                break;

            case "activateDone":
                // progressSetSuccess("TS_Activate");
                taskRun("TS_Unlock", cmdCallHome);
                break;

            case "callhomeDone":
                // progressSetSuccess("TS_Activate");
                taskRun("TS_Unlock", cmdUnlock);
                break;

            case "unlockDone":
                progressSetSuccess("TS_Unlock");
                taskRun("TS_SetActive", cmdSetActive);
                break;

            case "setActiveDone":
                progressSetSuccess("TS_SetActive");
                taskAllComplete(true);
                // Disable button after portal activation
                $("#TSbutton").prop("disabled", true);
                $("#TSbutton").css("background", "#eee");
                $("#TSbutton").css("color", "#aaa");
                break;
        
            default:
                break;
        }
    }

    function validateTSaccount(isPreviousSuccess) {
        printLog("INFO", "Start validate TS account")
        if (isPreviousSuccess == false) {
            return taskRetry();
        }
        switch (commandStage.get(getTaskName())) {
            case "init":
                Array.from(document.getElementById("TS_processLogs").getElementsByTagName("div")).forEach(div => {
                    div.style.display="none";
                })
                Array.from(document.getElementsByClassName("ErrorMessage")).forEach(errorMsg => {
                    errorMsg.style.display="none";
                });
                taskRun("TS_Gettoken", cmdGettoken);
                break;

            case "gettokenDone":
                progressSetSuccess("TS_Gettoken");
                taskAllComplete(true);
                break;
        
            default:
                break;
        }
    }

    function cmdGettoken() {
        ++currentRetriedTimes;
        if (top.fileExists(tokenFile)) {
            top.deleteFile(tokenFile);
        }
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
        args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("gettoken");
        args.push("--ts-username");
        args.push(tsInfo.UserName);
        args.push("--ts-password");
        args.push(tsInfo.Password);
		args.push("--ts-organization-id");
        args.push(tsInfo.Group);
        // if (tsInfo.OTP != "") {
        //     args.push("--ts-otp");
        //     args.push(tsInfo.OTP);
        // }
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push(...add_proxy_para());
        args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "gettokenDone");
		runProgram(args, null, cmdNextStep);
    }

    function cmdClaim() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("claim");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push("--active-code");
        args.push(top.gl_Edge_Machine_Params.ActivationCode);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "claimDone");
	    runProgram(args, null, cmdNextStep);
    }

    function cmdCallHome() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        challengeResponse = "";
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("callhome");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push("--challenge-otp");
        args.push(top.gl_Edge_Machine_Params.ChallengeText);
        args.push("--ts-organization-id");
        args.push(tsInfo.Group);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "callhomeDone");
		runProgram(args, null, (success) => {
            let tsStatusPath = top.getSupportFile("thinkShieldStatus");
            if (success && top.fileExists(tsStatusPath)) {
                printLog("INFO","ThinkShield status file exists, try to parse it.");
                try {
                    let tsStatus = JSON.parse(top.readTextFile(tsStatusPath));
                    challengeResponse = tsStatus["ChallengeResponseText"];
                    if (challengeResponse == undefined || challengeResponse == "") {
                        success = false;
                    }
                } catch (e) {
                    success = false;
                }
            } else {
                success = false;
            }
            cmdNextStep(success);
        });
    }

    function cmdUnlock() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("unlock");
        if (top.gl_Edge_Machine_Params.MachineMode != top.gl_MachineMode[3]) { // not ThinkEdge_Local_Inactive
            args.push("--response-otp");
            args.push(challengeResponse);
        }
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "unlockDone");
		runProgram(args, null, cmdNextStep);
    }

    function cmdActivate() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("activate");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "activateDone");
		runProgram(args, null, cmdNextStep);
    }

    function cmdSetActive() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("setstatustoactive");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(tokenFile);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "setActiveDone");
		runProgram(args, null, cmdNextStep);
    }

    function cmdSetDeactivated() {
        ++currentRetriedTimes;
        deleteFile(top.getSupportFile("commonResult"));
        let args = [];
		args.push(top.getSystemFile("oneCli"));
        args.push("edgeserver");
        args.push("setstatustoinactive");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(top.getSupportFile("tokenFile"));
        args.push(...add_proxy_para());
        args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
        commandStage.set(getTaskName(), "setDeactivatedDone");
		runProgram(args, null, cmdNextStep);
    }

    function cmdNextStep(isPreviousSuccess) {
        if(gl_syncEdgeStatus == getTaskName()) {
            // We can get here only if the Security Pack is enabled or the server is in Portal Activation mode
            syncEdgeStatusActive(isPreviousSuccess);
        } else if (gl_portal_activate == getTaskName()) {
            if (top.gl_Edge_Machine_Params.MachineMode == top.gl_MachineMode[3]) { // ThinkEdge_Local_Inactive
                loaclActivate(isPreviousSuccess);
            } else {
                activateLocked(isPreviousSuccess);
            }
        } else if (gl_portalActivation == getTaskName()) {
            // validate Think Shield portal account
            validateTSaccount(isPreviousSuccess);
        }
    }

    function edgeGetInfoCmd() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		if (top.fileExists(edgeserverStatusPath)) {
			top.deleteFile(edgeserverStatusPath);
		}
		let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("getsecurityinfo");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push(...add_output_log5());
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, edgeGetInfo);
	}

	function edgeGetInfo() {
		let edgeserverStatusPath = top.getSupportFile("edgeserverStatus");
		if (top.fileExists(edgeserverStatusPath)) {
			try {
				let xccInfo = JSON.parse(top.readTextFile(edgeserverStatusPath));
				top.gl_Edge_Machine_Params.ActivationCode = xccInfo["Active Code"];
				top.gl_Edge_Machine_Params.ChallengeText = xccInfo["Challenge Text"];
			} catch (e) {
				printLog("ERROR","Failed to read edgeserverStatus json.");
			}
		}
        cmdNextStep();
        /**
         * Main process
         * cmdNextStep
         *   - syncEdgeStatusActive
         *     - Gettoken  - Claim  - SetActive
         *   - activateLocked
         *     - Gettoken  - Claim  - Activate  - CallHome  - Unlock  - SetActive
         */
	}

    function startSecurityOperation() {
        printLog("INFO","Start was clicked.");
        top.toggleNext(false);
        top.togglePrevious(false);
        $("#TSbutton").prop("disabled", true);
        $("#TSbutton").css("background", "#eee");
            $("#TSbutton").css("color", "#aaa");
        showTipsInfo("");
        let retid = checkParamIsNull();
        if (retid != "") {
            showTipsInfo($.i18n.prop("Common.RquiredField"), retid);
            top.togglePrevious(true);
            $("#TSbutton").prop("disabled", false);
            $("#TSbutton").css("background", "#0e72ac");
            $("#TSbutton").css("color", "#fff");
            top.toggleNext(isCouldSkipDefault);
            return false;
        }
        // $("#TSUserName,#TSPassword,#TSGroup,#TSOTP").prop("disabled", true);
        $("#TSUserName,#TSPassword,#TSGroup").prop("disabled", true);
        writeTSParams();
        cmdNextStep();
    }

    return {
        index: 0,
        name: "TShield_Setting",
        init: TS_init,
        nextAction: function() {
            top.togglePrevious(true);
            return true;
        },
        previousAction: function() {
            top.toggleNext(true);
            return true;
        },
        startSecurityOperation: startSecurityOperation,
        setTaskUnDone: setTaskUnDone,
        importId: '#import_tshield_setting',
        selectorId: '.tshield_setting',
        title: "Navi.TShieldSetting",
        localizedTitle: tr("Navi.TShieldSetting"),
    }
}();