// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Sed_Management = function () {

    let global_point = null;

    // styles
    let floatingStyle = {
        position: 'fixed',
        top: 'auto',
    };
    let iconFalseImg = {
        'background-image': 'url(images/verified=false.png)'
    };
    let iconTrueImg = {
        'background-image': 'url(images/verified=true.png)'
    }
    let iconStyle = {
        width: '16px',
        height: '16px',
        'background-repeat': 'no-repeat',
        'background-size': 'cover',
        display: 'inline-block'
    };
    let tipsStyle = {
        'position': 'fixed'
    };
    let passwdInputStyle = {
        width: '160px',
        'padding-left': '15px',
        color: 'rgb(96, 98, 102)',
        'font-size': 'small',
        border: 'none'
    }

    let stage = "init";

    function startProcess (obj) {
        global_point.clickable = 'notclick';
        top.togglePrevious(false);
        top.toggleNext(false);
        obj.isRunning = true;
        obj.isFailed = false;
        obj.isFinished = false;
        obj.imgPath = "images/progress_anim2_small.gif";
    }
    function processSucceed (obj) {
        global_point.clickable = '';
        top.togglePrevious(true);
        top.toggleNext(true);
        obj.isFailed = false;
        obj.isFinished = true;
        obj.imgPath = "images/statusSuccess_obj16.gif";
        getCommonResult();
        stage = "done";
    }
    function processFail (obj) {
        global_point.clickable = '';
        top.togglePrevious(true);
        top.toggleNext(false);
        obj.isFailed = true;
        obj.isFinished = true;
        obj.imgPath = "images/statusCritical_obj16.gif";
        obj.errmsg = getCommonResult().msg;
    }
    function onProcessFinished (success) {
        if (success) {
            processSucceed(this);
        } else {
            processFail(this);
        }
    }

    function getCommonResult () {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, errCode;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            errCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return { msg: resultMsg, code: errCode };
        } else {
            return { msg: top.getComErrMsg(), code: null };
        }
    }

    let vue_component = {
        mounted() {
            initLocale();
        },
        created () {
            printLog("INFO", "SED Management app created.");
            // assign [this] to an object so that we can use data outside
            global_point = this;
            top.toggleNext(false);
        },
        data () {
            return {
                settingsForWarning: {
                    show: true,
                    warningContent: tr("SEDManagement.Change.UsingRandomWarning"),
                    yesContent: '',
                    noContent: '',
                    hasYes: false,
                    hasNo: false,
                    level: 'waring'
                },
                generateMethod: '',
                afterRandomKeyGeneration: false,
                afterKeyBackup: false,
                picked: 'Generate',
                clickable: '',
                motionTips: '',
                motionTipsShow: false,
                unfold: false,
                tipsStyle: clone(tipsStyle),
                sedEnabled: top.gl_Edge_Machine_Params.SEDEnabled,
                sedEncryptionMethod: top.gl_Edge_Machine_Params.SEDEncryptionMethod
            }
        },
        methods: {
            afterGenerate (israndom) {
                // only after successfully generating sed key
                if (israndom) {
                    this.afterRandomKeyGeneration = true;
                    this.afterKeyBackup = false;
                    this.picked = "Backup";
                    this.warningContent = $.i18n.prop('SEDManagement.Change.AfterRandomGenerationWarning');
                    top.toggleNext(false);
                    top.togglePrevious(false);
                }
                this.sedEncryptionMethod = israndom ? "Random" : "Passphrase";
                this.sedEnabled = true;
                top.gl_Edge_Machine_Params.SEDEncryptionMethod = this.sedEncryptionMethod;
                top.gl_Edge_Machine_Params.SEDEnabled = true;
            },
            afterBackup () {
                this.afterKeyBackup = true;
                this.warningContent = $.i18n.prop('SEDManagement.Change.UsingRandomWarning');
                top.toggleNext(true);
                top.togglePrevious(true);
            },
            showFloatingIntro (e, text) {
                let elemRect = e.currentTarget.getBoundingClientRect();
                this.tipsStyle.top = (elemRect.top + 20) + "px";
                this.tipsStyle.left = (elemRect.left + 20) + "px";
                this.tipsStyle.width = (document.body.clientWidth - elemRect.left - 40) + "px";
                this.motionTips = text;
                this.motionTipsShow = true;
            },
            hideFloatingIntro () {
                this.motionTipsShow = false;
            },
            tr: top.tr
        },
        computed: {
            afterRDGenAndBeforeBackup () {
                return this.afterRandomKeyGeneration && !this.afterKeyBackup;
            }
        }
    }

    function sed_init () {
        if (stage == "done") {
            top.toggleNext(true);
            top.togglePrevious(true);
        } else {
            top.toggleNext(false);
            top.togglePrevious(true);
        }
        init_vue();
        if (global_point){
            global_point.sedEncryptionMethod = top.gl_Edge_Machine_Params.SEDEncryptionMethod;
            global_point.sedEnabled = top.gl_Edge_Machine_Params.SEDEnabled;
        }
    }

    function sed_uninit () {
        if (top.sed_management_app != null || top.sed_management_app != undefined) {
            top.sed_management_app.unmount();
            top.sed_management_app = undefined;
        }
    }

    async function init_vue () {
        if (top.sed_management_app == undefined) {
            top.sed_management_app = Vue.createApp(vue_component);
            // Register each component into app
            const { sedGenerate } = await import('./components/Sed_Generate.js');
            const { sedBackup } = await import('./components/Sed_Backup.js');
            const { sedRecover } = await import('./components/Sed_Recover.js');
            const { alert } = await import('../Common_Components/Alert/Alert.js');
            top.sed_management_app.component("sedgenerate", sedGenerate).component("sedbackup", sedBackup).component("sedrecover", sedRecover).component("alert", alert);
            top.sed_management_app.mount('#sed_management_vue');
        }
    }

    // export functions and objects so that we can re-use them in each [component]
    return {
        index: 0,
        name: "Sed_Management",
        init: sed_init,
        uninit: sed_uninit,
        floatingStyle: floatingStyle,
        iconFalseImg: iconFalseImg,
        iconTrueImg: iconTrueImg,
        iconStyle: iconStyle,
        tipsStyle: tipsStyle,
        passwdInputStyle: passwdInputStyle,
        startProcess: startProcess,
        onProcessFinished: onProcessFinished,
        nextAction: function () {
            return true;
        },
        previousAction: function () {
            return true;
        },
        importId: '#import_sed_management',
        selectorId: '.sed_management',
        title: "Navi.SedManagement",
        localizedTitle: tr("Navi.SedManagement"),
        needReInit: true
    }
}();