// Copyright © 2022 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Security_Pack = function () {

    let isMotionDetection;
    let isTrusionDetection;

    let commandStage = "init";
    let allCommandSuccess = true;

    let rebootTimerHandle = undefined;

    let toLock = false;

    function SP_init() {
        printLog("INFO","Security Pack page init.");
        if (true == top.gl_isAccountValidated) {
            $('#WithClaimWarning').show();
            $('#WithoutClaimWarning').hide();
        } else {
            $('#WithoutClaimWarning').show();
            $('#WithClaimWarning').hide();
        }
        $('#SP_SetServerActiveInTS').parent().find('span').eq(0).html($.i18n.prop("SecurityPack.Status.SetServerActive"));
        $('#SP_SetServerInactiveInTS').parent().find('span').eq(0).html($.i18n.prop("SecurityPack.Status.SetServerInactive"));
        $('#WithClaimWarning').find('p').eq(0).html($.i18n.prop("SecurityTask.WithClaimWarning"));
        // $('#WithClaimWarning').find('p').eq(0).html($.i18n.prop("SecurityTask.ClaimWarning"))；
        if (commandStage == "done") {
            // top.togglePrevious(false);
            top.togglePrevious(false);
            top.toggleNext(true);
        } else {
            top.toggleNext(false);
            if(top.gl_Edge_Machine_Params.GSensor.MotionDetectionMode){
                document.getElementById("SPMontionDetection").setAttribute("checked", top.gl_Edge_Machine_Params.GSensor.MotionDetectionMode);
            }
            if(top.gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable){
                document.getElementById("SPChassisIntrusionDetection").setAttribute("checked", top.gl_Edge_Machine_Params.ChassisIntrusionDetectionEnable);
            }
            toggleDetectionButton(document.getElementById("SPMontionDetection"));
            toggleDetectionButton(document.getElementById("SPChassisIntrusionDetection"));

            $("#EnableSecurityConfirmDiv").show();
            $("#SP_Pack_button").show();
            // $("#EnableSecurityConfirmInput").focus();
            checkUserDecision();
            // $("#SPMontionDetection").parent().parent().parent().removeClass("notclick");
            // $("#SPMontionDetection").parent().parent().parent().addClass("notclick");
            $('#WithoutClaimWarning').parent().children().addClass("notclick");
            $('#WithoutClaimWarning').removeClass("notclick");
            $('#WithClaimWarning').removeClass("notclick");
        }
    }

    function toggleDetectionButton(buttonObj) {
        printLog("INFO","The option "+buttonObj.id+" is "+(buttonObj.checked?"checked.":"unchecked."));
        if (buttonObj.checked) {
            document.getElementById(buttonObj.id+"Status").innerText = $.i18n.prop("SecurityPack.Enabled");
        } else {
            document.getElementById(buttonObj.id+"Status").innerText = $.i18n.prop("SecurityPack.Disabled");
        }
    }

    function showTipsInfo(str, errcode, id){
		if (str == ""){
            $("#SP_ClaimServerInTS").parent().hide();
            $("#SP_ClaimServerInTS").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_ClaimServerInTS").parent().children(".Recommendation")[0].innerHTML = "";
			$("#SP_EnableSecurityPack").parent().hide();
            $("#SP_EnableSecurityPack").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_EnableSecurityPack").parent().children(".Recommendation")[0].innerHTML = "";
            $("#SP_SetMotionDetection").parent().hide();
            $("#SP_SetMotionDetection").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_SetMotionDetection").parent().children(".Recommendation")[0].innerHTML = "";
            $("#SP_SetChassisIntrutionDetection").parent().hide();
            $("#SP_SetChassisIntrutionDetection").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_SetChassisIntrutionDetection").parent().children(".Recommendation")[0].innerHTML = "";
            $("#SP_LockServer").parent().hide();
            $("#SP_LockServer").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_LockServer").parent().children(".Recommendation")[0].innerHTML = "";
            $("#SP_SetServerActiveInTS").parent().hide();
            $("#SP_SetServerActiveInTS").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_SetServerActiveInTS").parent().children(".Recommendation")[0].innerHTML = "";
            $("#SP_SetServerInactiveInTS").parent().hide();
            $("#SP_SetServerInactiveInTS").parent().children(".ErrorMessage")[0].innerHTML = "";
            $("#SP_SetServerInactiveInTS").parent().children(".Recommendation")[0].innerHTML = "";
			return;
		}
		$("#"+id).parent().show();
        $("#"+id).parent().children(".ErrorMessage")[0].innerHTML = str;
        if(errcode != null && errcode != undefined && top.gl_errorcodeToRecommendedAction[Number(errcode)] != undefined){
            $("#"+id).parent().children(".Recommendation")[0].innerHTML = top.gl_errorcodeToRecommendedAction[Number(errcode)];
        }
	}

    function collectUserOptions() {
        isMotionDetection = document.getElementById("SPMontionDetection").checked;
        isTrusionDetection = document.getElementById("SPChassisIntrusionDetection").checked;
    }

    function showRebootTips(){
        $("#SP_status").parent().show();
        document.getElementById("SP_status").value = 0;
        rebootTimerHandle = setInterval(function(){
            document.getElementById("SP_status").value++;
        }, 1000);
    }

    function hideRebootTips(){
        $("#SP_status").parent().hide();
        clearInterval(rebootTimerHandle);
    }

    function HandleWarningOption(obj) {
        $("#EnableSecurityConfirmInput").focus();
        $('#WithoutClaimWarning').parent().children().removeClass("notclick");
        if ($('#WithoutClaimWarning').css('display') == 'block') {
            // do nothing
        } else {
            if($('#WithClaimWarningYes').prop('checked') == true) {
                toLock = true;
            } else {
                toLock = false;
            }
        }
    }

    function SP_ClaimServerInTSPortal() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_ClaimServerInTS").parent().show();
        progressSetRunning("SP_ClaimServerInTS");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("claim");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(top.getSupportFile("tokenFile"));
        args.push("--active-code");
        args.push(top.gl_Edge_Machine_Params.ActivationCode);
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onClaimed);
    }

    function onClaimed(success) {
        hideRebootTips();
        if (!success) {
            commandStage = "claim_failed";
            allCommandSuccess = false;
            progressSetFailed("SP_ClaimServerInTS");
            return SP_MainProcess();
        } else {
            commandStage = "claimed";
            progressSetSuccess("SP_ClaimServerInTS");
            return SP_MainProcess();
        }
    }

    function SP_SetServerActiveInTSPortal() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_SetServerActiveInTS").parent().show();
        progressSetRunning("SP_SetServerActiveInTS");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("setstatustoactive");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(top.getSupportFile("tokenFile"));
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onSetActive);
    }

    function onSetActive(success) {
        hideRebootTips();
        if (!success) {
            commandStage = "set_failed";
            allCommandSuccess = false;
            progressSetFailed("SP_SetServerActiveInTS");
            return SP_MainProcess();
        } else {
            commandStage = "set";
            progressSetSuccess("SP_SetServerActiveInTS");
            return SP_MainProcess();
        }
    }

    function SP_SetServerInactiveInTSPortal() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_SetServerInactiveInTS").parent().show();
        progressSetRunning("SP_SetServerInactiveInTS");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("setstatustoinactive");
        args = args.concat(SplitXCCInfo());
        args.push("--ts-token-file");
        args.push(top.getSupportFile("tokenFile"));
        args.push(...add_proxy_para());
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onSetInactive);
    }

    function onSetInactive(success) {
        hideRebootTips();
        if (!success) {
            commandStage = "set_failed";
            allCommandSuccess = false;
            progressSetFailed("SP_SetServerInactiveInTS");
            return SP_MainProcess();
        } else {
            commandStage = "set";
            progressSetSuccess("SP_SetServerInactiveInTS");
            return SP_MainProcess();
        }
    }

    function SP_EnableSecurityPack() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_EnableSecurityPack").parent().show();
        progressSetRunning("SP_EnableSecurityPack");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("enablesecuritypack");
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onEnabled);
        showRebootTips();
    }

    function onEnabled(success) {
        hideRebootTips();
        if (!success) {
            commandStage = "enable_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_EnableSecurityPack");
            return SP_MainProcess();
        } else {
            commandStage = "enabled";
            progressSetSuccess("SP_EnableSecurityPack");
            return SP_MainProcess();
        }
    }

    function SP_Lock() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_LockServer").parent().show();
        progressSetRunning("SP_LockServer");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
		args.push("lock");
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onLocked);
    }

    function onSetMotionDetectionFinished(success){
        if (!success) {
            commandStage = "set_motion_detection_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_SetMotionDetection");
            return SP_MainProcess();
        } else {
            commandStage = "set_motion_detection_success";
            progressSetSuccess("SP_SetMotionDetection");
            return SP_MainProcess();
        }
    }

    function SP_SetMotionDetection(){
        deleteFile(top.getSupportFile("commonResult"));
        document.getElementById("SP_SetMotionDetectionDesc").innerText = isMotionDetection? $.i18n.prop("SecurityPack.Status.EnableMotionDetection"): $.i18n.prop("SecurityPack.Status.DisableMotionDetection");
        $("#SP_SetMotionDetection").parent().show();
        progressSetRunning("SP_SetMotionDetection");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
        if(isMotionDetection){
            args.push("enablemotiondetection");
        }else{
            args.push("disablemotiondetection");
        }
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onSetMotionDetectionFinished);
    }

    function onSetIntrusionDetectionFinished(success){
        if (!success) {
            commandStage = "set_intrusion_detection_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_SetChassisIntrutionDetection");
            return SP_MainProcess();
        } else {
            commandStage = "set_intrusion_detection_success";
            progressSetSuccess("SP_SetChassisIntrutionDetection");
            return SP_MainProcess();
        }
    }

    function SP_SetChassisInstrusionDetection(){
        deleteFile(top.getSupportFile("commonResult"));
        document.getElementById("SP_SetChassisIntrutionDetectionDesc").innerText = isTrusionDetection? $.i18n.prop("SecurityPack.Status.EnableChassisIntrusionDetection"): $.i18n.prop("SecurityPack.Status.DisableChassisIntrusionDetection");
        $("#SP_SetChassisIntrutionDetection").parent().show();
        progressSetRunning("SP_SetChassisIntrutionDetection");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
		args.push("edgeserver");
        if(isTrusionDetection){
            args.push("enableintrusiondetection");
        }else{
            args.push("disableintrusiondetection");
        }
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onSetIntrusionDetectionFinished);
    }

    function onLocked(success) {
        if (!success) {
            commandStage = "lock_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_LockServer");
            return SP_MainProcess();
        } else {
            commandStage = "locked";
            progressSetSuccess("SP_LockServer");
            return SP_MainProcess();
        }
    }

    function SP_OSPoweroff() {
        deleteFile(top.getSupportFile("commonResult"));
        $("#SP_OSPoweroff").parent().show();
        progressSetRunning("SP_OSPoweroff");
        let args = [];
		args.push(top.getSystemFile("oneCli"));
        args.push("misc");
		args.push("ospower");
		args.push("turnoff");
        args.push("--bmc");
		args.push(SplitFullConnInfo());
        args.push("--never-check-trust");
		args.push(...add_output_log5());
        top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, onOSPoweroff);
    }

    function onOSPoweroff(success) {
        if (!success) {
            commandStage = "power_fail";
            allCommandSuccess = false;
            progressSetFailed("SP_OSPoweroff");
            return SP_MainProcess();
        } else {
            commandStage = "poweroff";
            progressSetSuccess("SP_OSPoweroff");
            return SP_MainProcess();
        }
    }

    function SP_MainProcess() {
        printLog("INFO","Enable was clicked.");
        // if claim in task, we do claim first
        if (commandStage == "init") {
            showTipsInfo("");
            collectUserOptions();
            if (true == top.gl_isAccountValidated) {
                return SP_ClaimServerInTSPortal();
            }
            return SP_EnableSecurityPack();
        } else if (commandStage == "claimed") {
            return SP_EnableSecurityPack();
        } else if (commandStage == "enabled") {
            return SP_SetMotionDetection();
        } else if (commandStage == "set_motion_detection_success") {
            return SP_SetChassisInstrusionDetection();
        } else if (commandStage == "set_intrusion_detection_success") {
            if (false == top.gl_isAccountValidated || true == toLock) {
                return SP_Lock();
            }
            commandStage = "poweroff";
            return SP_MainProcess();
        } else if (commandStage == "locked") {
            return SP_OSPoweroff();
        } else if (commandStage == "poweroff") {
            if (true == top.gl_isAccountValidated && false == toLock) {
                return SP_SetServerActiveInTSPortal();
            } else if (true == top.gl_isAccountValidated && true == toLock) {
                return SP_SetServerInactiveInTSPortal();
            }
            commandStage = "set";
            return SP_MainProcess();
        } else if (commandStage == "set") {
            getCommonResult(); // Set log
            commandStage = "done";
            top.toggleNext(true);
        } else {
            // Error case
            showErrorMessage();
            top.togglePrevious(true);
            $("#EnableSecurityConfirmDiv").show();
            $("#SP_Pack_button").show();
            $("#SPMontionDetection").parent().parent().parent().removeClass("notclick");
        }
    }

    function getCommonResult() {
        let resultFile = top.readTextFile(top.getSupportFile("commonResult"));
        var resultDom, resultMsg, errCode;
        if (resultFile != null) {
            resultDom = ezJsLib.XmlDom.parse(resultFile);
            resultMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", resultDom.documentElement);
            errCode = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", resultDom.documentElement);
            setLogFile(ezJsLib.XmlDom.getValueByTag("LOGFILE", resultDom));
            return { msg : resultMsg, code : errCode };
        } else {
            return { msg : top.getComErrMsg(), code : null };
        }
    }
    function showErrorMessage() {
        let errorMsg = $.i18n.prop("SecurityPack.EnableError") + "<br>"
        let id = "SP_EnableSecurityPack";
        if(commandStage == "set_motion_detection_fail"){
            errorMsg = $.i18n.prop("SecurityPack.SetMotionError") + "<br>";
            id = "SP_SetMotionDetection";
        } else if(commandStage == "set_intrusion_detection_fail"){
            errorMsg = $.i18n.prop("SecurityPack.SetChassisIntrutionError") + "<br>";
            id = "SP_SetChassisIntrutionDetection";
        } else if (commandStage == "lock_fail") {
            errorMsg = $.i18n.prop("SecurityPack.LockError") + "<br>";
            id = "SP_LockServer";
        } else if (commandStage == "power_fail") {
            errorMsg = $.i18n.prop("SecurityPack.OSPoweroffError") + "<br>";
            id = "SP_OSPoweroff";
        }

        let res = getCommonResult();
        errorMsg += res.msg;
        showTipsInfo(errorMsg, res.code, id);
        commandStage = "init";
    }

    function showFloatingTips(obj, divID) {
        let elemRect = obj.getBoundingClientRect();
        document.getElementById(divID).style.position = "fixed";
        document.getElementById(divID).style.top = (elemRect.top + 20) + "px";
        document.getElementById(divID).style.left = (elemRect.left + 20) + "px";
        document.getElementById(divID).style.width = (document.body.clientWidth - elemRect.left - 40) + "px";
        $("#"+divID).show();
    }
    function hideFloatingTips(divID) {
        $("#"+divID).hide();
    }

    function progressSetSuccess(progressId) {
        document.getElementById(progressId).src = "images/statusSuccess_obj16.gif";
    }
    function progressSetRunning(progressId) {
        document.getElementById(progressId).src = "images/progress_anim2_small.gif";
    }
    function progressSetFailed(progressId) {
        document.getElementById(progressId).src = "images/statusCritical_obj16.gif";
    }

    function startEnableOperation(){
        commandStage = "init";
        $("#EnableSecurityConfirmDiv").hide();
        $("#SP_Pack_button").hide();
        $("#SP_EnableSecurityPack").parent().hide();
        $("#SP_SetMotionDetection").parent().hide();
        $("#SP_SetChassisIntrutionDetection").parent().hide();
        $("#SP_LockServer").parent().hide();
        $("#SP_OSPoweroff").parent().hide();
        $("#SPMontionDetection").parent().parent().parent().addClass("notclick");
        top.toggleNext(false);
        top.togglePrevious(false);
        allCommandSuccess = true;
        SP_MainProcess();
    }

    function checkUserDecision() {
        let val = $("#EnableSecurityConfirmInput").val();
        if (val == "YES") {
            document.getElementById("SP_Pack_button").style.backgroundColor = "#0e72ac";
            document.getElementById("SP_Pack_button").style.color = "#fff";
            $("#SP_Pack_button").prop("disabled", false);
        } else {
            document.getElementById("SP_Pack_button").style.backgroundColor = "#eee";
            document.getElementById("SP_Pack_button").style.color = "#aaa";
            $("#SP_Pack_button").prop("disabled", true);
        }
    }

    return {
        index: 0,
        name: "Security_Pack",
        init: SP_init,
        nextAction: function() {
            top.togglePrevious(true);
            return true;
        },
        previousAction: function() {
            top.toggleNext(true);
            return true;
        },
        showFloatingTips: showFloatingTips,
        hideFloatingTips: hideFloatingTips,
        toggleDetectionButton: toggleDetectionButton,
        startEnableOperation: startEnableOperation,
        checkUserDecision: checkUserDecision,
        HandleWarningOption: HandleWarningOption,
        importId: '#import_security_pack',
        selectorId: '.security_pack',
        title: "Navi.SecurityPack",
        localizedTitle: tr("Navi.SecurityPack"),
        needReInit: true
    }
}();