// Copyright © 2018 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

Raid_Config = function () {

	var user_cancel = false;
	var raidShowPath = "";
	var raidResultPath = "";
	var vol_action_type = {};

	var create_vol_static_index = 0;

	// why overwrite it... maybe need to remove.
	Array.prototype.originIndexOf = Array.prototype.indexOf;
	Array.prototype.indexOf = function (e, f) {
		if (f) return this.originIndexOf(e, f);
		for (var i = 0; i < this.length; i++) {
			if (this[i] == e)
				return i;
		}
		return -1;
	};

	Array.prototype.add = function (val) {
		var index = this.indexOf(val);
		if (index == -1) {
			this.push(val);
		}
	};

	Array.prototype.remove = function (val) {
		var index = this.indexOf(val);
		if (index > -1) {
			this.splice(index, 1);
		}
	};

	function raid_init() {
		printLog("INFO", "RAID Configuration page init.");
		// clear and reset the page
		top.gl_leftAvaDiskCap = 0;
		top.gl_totalAvaDiskCap = 0;
		create_vol_static_index = 0;
		var msg = $.i18n.prop("RaidConfig.GetRaidShow");
		refreshTable(msg);
	}

	function validateInput() {
		$("#errorMsgExecText").html();
		$("#vol_check_msg").hide();
		var vol_name = $("#create_vol_name").val().trim();
		if (vol_name == "" || vol_name == null || vol_name == undefined) {
			return "vol_name_empty";
		}
		// check whether there is already volumes with the same name in this pool
		var vol_name_exist = false;
		for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
			if (vol_name == top.gl_raid_user_create_vol[i].name) {
				if (vol_action_type.type == "create") {
					vol_name_exist = true;
					break;
				} else if (vol_action_type.type == "edit") {
					if (vol_name == vol_action_type.name) {
						continue;
					} else {
						vol_name_exist = true;
						break;
					}
				}
			}
		}
		if (vol_name_exist) {
			return "vol_name_dup";
		}
		var vol_cap = $("#create_vol_cap").val();
		if (vol_cap == "" || vol_cap == null || vol_cap == undefined) {
			return "vol_cap_empty";
		}
		if (vol_cap.indexOf("GB") != -1) {
			vol_cap.replace("GB", "");
		}
		if (vol_cap.indexOf("MB") != -1) {
			vol_cap.replace("MB", "");
		}
		if (isNaN(vol_cap)) {
			return "vol_cap_invalid";
		}
		vol_cap = parseFloat(vol_cap).toFixed(3);
		if (vol_cap == "0" || vol_cap == 0) {
			return "vol_cap_zero";
		}
		vol_cap = formatCapToGb(vol_cap);
		if (parseFloat(vol_cap) > parseFloat(top.gl_leftAvaDiskCap)) {
			return "cap_exceed";
		}
		return "success";
	}

	function refreshVolCreateTab() {
		$("#vol_info_table").empty();
		var table = document.getElementById("vol_info_table");
		for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
			var vol_index = top.gl_raid_user_create_vol[i].index;
			var vol_name = top.gl_raid_user_create_vol[i].name;
			var vol_cap = top.gl_raid_user_create_vol[i].capacity;

			var vol_raid_level = $("#raidlvl").val();
			var new_vol_row = table.insertRow(-1);
			var new_vol_row_id = "vol-" + vol_index;
			var vol_checkbox_id = "checkbox-" + new_vol_row_id;
			new_vol_row.id = new_vol_row_id;
			var vol_checkbox_cell = new_vol_row.insertCell(-1);
			vol_checkbox_cell.className = "RaidTableCellRadio";
			vol_checkbox_cell.style.width = "3%";
			vol_checkbox_cell.style.textAlign = "center";
			vol_checkbox_cell.setAttribute("role", "presentation");
			vol_checkbox_cell.innerHTML = "<input id='" + vol_checkbox_id + "' type='radio' name='vol_radio' onclick='Raid_Config.selectVolRow(this.id)' aria-label='" + vol_name + "'>";

			var vol_name_cell = new_vol_row.insertCell(-1);
			vol_name_cell.className = "RaidTableCell";
			vol_name_cell.style.width = "37%";
			vol_name_cell.style.textAlign = "center";
			vol_name_cell.innerText = vol_name;
			vol_name_cell.title = vol_name;

			var vol_cap_cell = new_vol_row.insertCell(-1);
			vol_cap_cell.className = "RaidTableCell";
			vol_cap_cell.style.width = "30%";
			vol_cap_cell.style.textAlign = "center";
			vol_cap_cell.innerText = vol_cap;
			vol_cap_cell.title = vol_cap;

			var vol_raid_level_cell = new_vol_row.insertCell(-1);
			vol_raid_level_cell.className = "RaidTableCell";
			vol_raid_level_cell.style.width = "30%";
			vol_raid_level_cell.style.textAlign = "center";
			vol_raid_level_cell.innerText = vol_raid_level;
			vol_raid_level_cell.title = vol_raid_level;
		}

		if(top.gl_raid_user_create_vol.length == 0){
			$("#createVol").attr("disabled", false);
			$("#createVol").removeClass("DisabledText");
		}
	}

	function applyVol() {
		warnMessageShow(false);
		printLog("INFO", "button 'Apply' was clicked.");
		var ret = validateInput();
		var err_msg = "";
		if (ret == "vol_name_empty") {
			err_msg = $.i18n.prop("RaidConfig.InputVolName");
		} else if (ret == "vol_name_dup") {
			err_msg = $.i18n.prop("RaidConfig.VolNameExist");
		} else if (ret == "vol_cap_empty") {
			err_msg = $.i18n.prop("RaidConfig.InputVolCap");
		} else if (ret == "vol_cap_invalid" || ret == "vol_cap_zero") {
			err_msg = $.i18n.prop("RaidConfig.CapValueInvalid");
		} else if (ret == "cap_exceed") {
			err_msg = $.i18n.prop("RaidConfig.NoEnoughSpace");
		}
		if (err_msg != "" && err_msg != null && err_msg != undefined) {
			$("#errorMsgExecText").html(err_msg);
			$("#vol_check_msg").show();
			return;
		}
		var form_index = 0;
		var form_name = $("#create_vol_name").val().trim();
		var form_cap = $("#create_vol_cap").val();
		form_cap = formatCapToGb(form_cap);

		var form_io_policy = $("#create_vol_io_policy").val();
		var form_strip_size = $("#create_vol_strip_size").val();
		var form_acc_policy = $("#create_vol_acc_policy").val();
		var form_read_policy = $("#create_vol_read_policy").val();
		var form_drive_cache = $("#create_vol_drive_cache").val();
		var form_write_policy = $("#create_vol_write_policy").val();
		var form_init = $("#create_vol_init").val();

		if (vol_action_type.type == "create") {
			form_index = create_vol_static_index;
			var volume_obj = {};
			volume_obj.index = form_index;
			volume_obj.name = form_name;
			volume_obj.capacity = form_cap;
			volume_obj.io_policy = form_io_policy;
			volume_obj.strip_size = form_strip_size;
			volume_obj.acc_policy = form_acc_policy;
			volume_obj.read_policy = form_read_policy;
			volume_obj.drive_cache = form_drive_cache;
			volume_obj.write_policy = form_write_policy;
			volume_obj.init = form_init;
			top.gl_raid_user_create_vol.push(volume_obj);
			create_vol_static_index++;
		} else if (vol_action_type.type == "edit") {
			form_index = top.gl_vol_select.replace("vol-", "");
			for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
				if (form_index == top.gl_raid_user_create_vol[i].index) {
					top.gl_raid_user_create_vol[i].name = form_name;
					top.gl_raid_user_create_vol[i].capacity = form_cap;
					top.gl_raid_user_create_vol[i].io_policy = form_io_policy;
					top.gl_raid_user_create_vol[i].strip_size = form_strip_size;
					top.gl_raid_user_create_vol[i].acc_policy = form_acc_policy;
					top.gl_raid_user_create_vol[i].read_policy = form_read_policy;
					top.gl_raid_user_create_vol[i].drive_cache = form_drive_cache;
					top.gl_raid_user_create_vol[i].write_policy = form_write_policy;
					top.gl_raid_user_create_vol[i].init = form_init;
					vol_updated = true;
					break;
				}
			}
		}
		$("#form_step2_prev").attr("disabled", false);
		$("#form_step2_next").attr("disabled", false);
		$("#form_step2_prev").addClass("btn-primary");
		$("#form_step2_prev").removeClass("btn-default");
		$("#form_step2_next").addClass("btn-primary");
		$("#form_step2_next").removeClass("btn-default");

		if (top.gl_raid_select_type.toLowerCase() == "oobmicrochip"
			|| top.gl_raid_select_type.toLowerCase() == "oobvroc" 
			|| top.isCFC(top.gl_mt_list[0])) {
			if (top.gl_raid_user_create_vol.length > 0) {
				$("#createVol").attr("disabled", true);
				$("#createVol").addClass("DisabledText");
			}
		}

		$("#editVol").attr("disabled", true);
		$("#editVol").addClass("DisabledText");
		$("#removeVol").attr("disabled", true);;
		$("#removeVol").addClass("DisabledText");
		refreshVolCreateTab();
		$("#errorMsgExecText").html();
		$("#vol_check_msg").hide();
		$("#createVolForm").hide();
		setLeftAvaDiskCap();
	}

	function cancelEditVolume() {
		printLog("INFO", "button 'Cancel' was clicked, Volume page was hidden.");
		$("#errorMsgExecText").html();
		$("#vol_check_msg").hide();
		$("#createVolForm").hide();
		$("#form_step2_prev").attr("disabled", false);
		$("#form_step2_next").attr("disabled", false);
		$("#form_step2_prev").addClass("btn-primary");
		$("#form_step2_prev").removeClass("btn-default");
		$("#form_step2_next").addClass("btn-primary");
		$("#form_step2_next").removeClass("btn-default");
	}

	function checkRaid0() {
		var total_disk_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				total_disk_count++;
			}
		}
		if (total_disk_count < 1) {
			return $.i18n.prop("RaidConfig.AddLeastOneDisk");
		} else {
			return "disk_check_pass";
		}
	}

	function checkRaid1() {
		var total_disk_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				total_disk_count++;
			}
		}
		if (total_disk_count < 2) {
			return $.i18n.prop("RaidConfig.AddLeastTwoDisks");
		} else if (total_disk_count % 2 != 0) {
			return $.i18n.prop("RaidConfig.NoOddDiskNum");
		} else {
			return "disk_check_pass";
		}
	}

	function checkRaid5() {
		var total_disk_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				total_disk_count++;
			}
		}
		if (total_disk_count < 3) {
			return $.i18n.prop("RaidConfig.AddLeastThreeDisks");
		} else {
			return "disk_check_pass";
		}
	}

	function checkRaid6() {
		var total_disk_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				total_disk_count++;
			}
		}
		if (total_disk_count < 3) {
			return $.i18n.prop("RaidConfig.AddLeastThreeDisks");
		} else {
			return "disk_check_pass";
		}
	}

	function checkRaid10() {
		var total_span_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				total_span_count++;
			}
		}
		if (total_span_count < 2) {
			return $.i18n.prop("RaidConfig.AddLeastTwoSpans");
		}
		var disk_num_wrong = false;
		var equal_disk_wrong = false;
		var disk_num_arr = new Array();
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				var disk_num = 0;
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (top.gl_raid_select_disk.spans[i].disks[j]) {
						disk_num++;
					}
				}
				disk_num_arr.push(disk_num);
				if (disk_num < 2) {
					disk_num_wrong = true;
				}
			}
		}
		if (disk_num_arr.length > 0) {
			for (var i = 0; i < disk_num_arr.length; i++) {
				if (disk_num_arr.indexOf(disk_num_arr[i]) != 0) {
					equal_disk_wrong = true;
					break;
				}
			}
		}

		if (disk_num_wrong) {
			return $.i18n.prop("RaidConfig.EachSpanTwoDisks");
		}
		if (equal_disk_wrong) {
			return $.i18n.prop("RaidConfig.EqualDiskNumEachSpan");
		}
		return "disk_check_pass";
	}

	function checkRaid50() {
		var total_span_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				total_span_count++;
			}
		}
		if (total_span_count < 2) {
			return $.i18n.prop("RaidConfig.AddLeastTwoSpans");
		}
		var disk_num_wrong = false;
		var equal_disk_wrong = false;
		var disk_num_arr = new Array();
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				var disk_num = 0;
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (top.gl_raid_select_disk.spans[i].disks[j]) {
						disk_num++;
					}
				}
				disk_num_arr.push(disk_num);
				if (disk_num < 3) {
					disk_num_wrong = true;
				}
			}
		}
		if (disk_num_arr.length > 0) {
			for (var i = 0; i < disk_num_arr.length; i++) {
				if (disk_num_arr.indexOf(disk_num_arr[i]) != 0) {
					equal_disk_wrong = true;
					break;
				}
			}
		}

		if (disk_num_wrong) {
			return $.i18n.prop("RaidConfig.EachSpanThreeDisks");
		}
		if (equal_disk_wrong) {
			return $.i18n.prop("RaidConfig.EqualDiskNumEachSpan");
		}
		return "disk_check_pass";
	}

	function checkRaid60() {
		return checkRaid50();
	}

	function checkRaid00() {
		var total_span_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				total_span_count++;
			}
		}
		if (total_span_count < 2) {
			return $.i18n.prop("RaidConfig.AddLeastTwoSpans");
		}
		var disk_num_wrong = false;
		var equal_disk_wrong = false;
		var disk_num_arr = new Array();
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				var disk_num = 0;
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (top.gl_raid_select_disk.spans[i].disks[j]) {
						disk_num++;
					}
				}
				disk_num_arr.push(disk_num);
				if (disk_num < 1) {
					disk_num_wrong = true;
				}
			}
		}
		if (disk_num_arr.length > 0) {
			for (var i = 0; i < disk_num_arr.length; i++) {
				if (disk_num_arr.indexOf(disk_num_arr[i]) != 0) {
					equal_disk_wrong = true;
					break;
				}
			}
		}

		if (disk_num_wrong) {
			return $.i18n.prop("RaidConfig.EachSpanOneDisk");
		}
		if (equal_disk_wrong) {
			return $.i18n.prop("RaidConfig.EqualDiskNumEachSpan");
		}
		return "disk_check_pass";
	}

	function checkRaid1T() {
		var total_disk_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				total_disk_count++;
			}
		}
		if (total_disk_count < 3) {
			return $.i18n.prop("RaidConfig.AddLeastThreeDisks");
		} else {
			return "disk_check_pass";
		}
	}

	function checkRaid10T() {
		var total_span_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				total_span_count++;
			}
		}
		if (total_span_count < 2) {
			return $.i18n.prop("RaidConfig.AddLeastTwoSpans");
		}

		var disk_num_wrong = false;
		var equal_disk_wrong = false;
		var disk_num_arr = new Array();
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				var disk_num = 0;
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (top.gl_raid_select_disk.spans[i].disks[j]) {
						disk_num++;
					}
				}
				disk_num_arr.push(disk_num);
				if (disk_num < 6) {
					disk_num_wrong = true;
				}
			}
		}
		if (disk_num_arr.length > 0) {
			for (var i = 0; i < disk_num_arr.length; i++) {
				if (disk_num_arr.indexOf(disk_num_arr[i]) != 0) {
					equal_disk_wrong = true;
					break;
				}
			}
		}

		if (disk_num_wrong) {
			return $.i18n.prop("RaidConfig.EachSpanSixDisk");
		}
		if (equal_disk_wrong) {
			return $.i18n.prop("RaidConfig.EqualDiskNumEachSpan");
		}
		return "disk_check_pass";
	}

	function checkSelDisk() {
		var total_disk_count = 0;
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (top.gl_raid_select_disk.spans[i].disks[j]) {
						total_disk_count++;
					}
				}
			}
		}
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				total_disk_count++;
			}
		}
		// hot spares do not count
		/*for (var i = 0; i < top.gl_raid_select_disk.hot_spares.length; i++) {
			if (top.gl_raid_select_disk.hot_spares[i]) {
				total_disk_count++;
			}
		}*/
		if (total_disk_count < 1) {
			return $.i18n.prop("RaidConfig.AddLeastOneDisk");
		}


		var ret = "";
		if ($("#raidlvl").val() == "0") {
			ret = checkRaid0();
		} else if ($("#raidlvl").val() == "1") {
			ret = checkRaid1();
		} else if ($("#raidlvl").val() == "5") {
			ret = checkRaid5();
		} else if ($("#raidlvl").val() == "6") {
			ret = checkRaid6();
		} else if ($("#raidlvl").val() == "10") {
			ret = checkRaid10();
		} else if ($("#raidlvl").val() == "50") {
			ret = checkRaid50();
		} else if ($("#raidlvl").val() == "60") {
			ret = checkRaid60();
		} else if ($("#raidlvl").val() == "00") {
			ret = checkRaid00();
		} else if ($("#raidlvl").val() == "1T") {
			ret = checkRaid1T();
		} else if ($("#raidlvl").val() == "10T") {
			ret = checkRaid10T();
		}
		return ret;
	}

	function formStep1Next() {
		printLog("INFO", "button 'Next' was clicked, want goto Step2: Create Volume.");
		var ret = checkSelDisk();
		if (ret != "disk_check_pass") {
			alert(ret);
			return;
		}
		top.gl_raid_user_create_vol = new Array();
		$("#vol_info_table").empty();
		create_vol_static_index = 0;
		vol_action_type = {};
		var raidlvl = top.gl_raid_lvl;
		if (top.gl_raid_select_type.toLowerCase() == "oobmicrochip" 
			|| top.gl_raid_select_type.toLowerCase() == "oobvroc"
			|| top.gl_raid_select_type.toLowerCase() == "oobcfcmicrochip") {
			setAvaDiskCap();
			setAvaDiskCapExt(raidlvl);
		} else {
			setAvaDiskCap();
		}

		setLeftAvaDiskCap();
		$("#step-1").hide();
		$("#step-2").show();

		$("#createVol").attr("disabled", false);
		$("#createVol").removeClass("DisabledText");
		$("#editVol").attr("disabled", true);
		$("#editVol").addClass("DisabledText");
		$("#removeVol").attr("disabled", true);;
		$("#removeVol").addClass("DisabledText");
		refreshVolCreateTab();

		$("#step-3").hide();
		$("#formStep1Title").removeClass("btn-primary");
		$("#formStep1Title").addClass("btn-default");
		$("#formStep2Title").removeClass("btn-default");
		$("#formStep2Title").addClass("btn-primary");
	}

	function formStep2Next() {
		printLog("INFO", "button 'Next' was clicked, want goto Step3: Summary.");
		if (top.gl_raid_user_create_vol.length < 1) {
			alert($.i18n.prop("RaidConfig.AddLeastOneVol"));
			return;
		}
		$("#step-1").hide();
		$("#step-2").hide();
		$("#step-3").show();
		$("#formStep2Title").removeClass("btn-primary");
		$("#formStep2Title").addClass("btn-default");
		$("#formStep3Title").removeClass("btn-default");
		$("#formStep3Title").addClass("btn-primary");
		var raid_lvl = top.gl_raid_lvl;//fix coverity issue 110763
		$("#sum_raid_lvl").html(raid_lvl);
		$("#sum_raid_lvl").val(raid_lvl);
		var drive_num = 0;
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i]) {
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (top.gl_raid_select_disk.spans[i].disks[j]) {
						drive_num++;
					}
				}
			}
		}
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i]) {
				drive_num++;
			}
		}
		$("#sum_drive_num").html(drive_num);
		$("#sum_drive_num").val(drive_num);
		var hotspares_num = 0;
		for (var i = 0; i < top.gl_raid_select_disk.hot_spares.length; i++) {
			if (top.gl_raid_select_disk.hot_spares[i]) {
				hotspares_num++;
			}
		}
		$("#sum_hot_spare").html(hotspares_num);
		$("#sum_hot_spare").val(hotspares_num);
		$("#sum_total_cap").html(top.gl_totalAvaDiskCap + " GB");
		$("#sum_total_cap").val(top.gl_totalAvaDiskCap + " GB");
		$("#sum_left_cap").html(top.gl_leftAvaDiskCap + " GB");
		$("#sum_left_cap").val(top.gl_leftAvaDiskCap + " GB");
		renderSumVolTable();
	}

	function renderSumVolTable() {
		$("#sum_vol_tbody").empty();
		var tbody = document.getElementById("sum_vol_tbody");
		for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
			if (top.gl_raid_user_create_vol[i]) {
				var vol_name = top.gl_raid_user_create_vol[i].name;
				var vol_cap = top.gl_raid_user_create_vol[i].capacity;
				var vol_row = tbody.insertRow(-1);
				var vol_name_cell = vol_row.insertCell(-1);
				vol_name_cell.innerText = vol_name;
				vol_name_cell.title = vol_name;
				var vol_cap_cell = vol_row.insertCell(-1);
				vol_cap_cell.innerText = vol_cap;
				vol_cap_cell.title = vol_cap;
				var vol_raid_lvl_cell = vol_row.insertCell(-1);
				vol_raid_lvl_cell.innerText = "RAID " + $("#raidlvl").val();
				vol_raid_lvl_cell.title = "RAID " + $("#raidlvl").val();
			}
		}
	}

	function formStep2Prev() {
		printLog("INFO", "button 'Previous' was clicked, want goto Step1: Select Drivers.");
		if (confirm($.i18n.prop("RaidConfig.BackToDiskSel"))) {
			printLog("INFO", "button 'Ok' was clicked, goto Step1: Select Drivers.");
			$("#step-1").show();
			$("#step-2").hide();
			$("#step-3").hide();
			$("#formStep1Title").removeClass("btn-default");
			$("#formStep1Title").addClass("btn-primary");
			$("#formStep2Title").removeClass("btn-primary");
			$("#formStep2Title").addClass("btn-default");
		} else {
			return;
		}
	}

	function formStep3Prev() {
		printLog("INFO", "button 'Previous' was clicked, want goto Step2: Create Volume.");
		$("#step-1").hide();
		$("#step-2").show();
		$("#step-3").hide();
		$("#formStep2Title").addClass("btn-primary");
		$("#formStep2Title").removeClass("btn-default");
		$("#formStep3Title").addClass("btn-default");
		$("#formStep3Title").removeClass("btn-primary");
	}

	function selectVolRow(id) {
		printLog("INFO", "radio '" + id + "' was clicked.");
		$("#vol_info_table tr").each(function () {
			$(this).removeClass();
		});
		if (id.indexOf("checkbox-") != -1) {
			id = id.replace("checkbox-", "");
		}
		document.getElementById(id).className = "RowSelected";
		top.gl_vol_select = id;
		$("#editVol").attr("disabled", false);
		$("#editVol").removeClass("DisabledText");
		$("#removeVol").attr("disabled", false);
		$("#removeVol").removeClass("DisabledText");
	}

	function getAppropriateStripeSize(ctrl_id, defaultValue) {
		let minValue = top.gl_minStripeSize[ctrl_id];
		let maxValue = top.gl_maxStripeSize[ctrl_id];
		let retValue = [];
		if (isNaN(minValue) || isNaN(maxValue) || minValue <= 0 || maxValue <= 0) {
			// Invalid value, use default
			retValue = defaultValue.concat();
		} else {
			for (let beg = Number(minValue); beg <= Number(maxValue); beg *= 2) {
				let curVal = beg / 1024;
				if (curVal >= 1024) {
					curVal /= 1024;
					retValue.push(curVal + "MB");
				} else {
					retValue.push(curVal + "KB");
				}
			}
			if (top.gl_raid_select_type.toLowerCase() == "oobvroc") {
				if (document.getElementById("raidlvl").value == "1") {
					retValue.remove("128KB");      //OOBVROC RAID1 not support 128KB
				}
			}
			if (retValue.length == 0) {
				retValue = defaultValue.concat();
			}
		}
		return retValue.concat();
	}

	function showCreateVol() {
		warnMessageShow(false);
		printLog("INFO", "button 'Create Volume' was clicked.");
		if(top.gl_raid_select_type.toLowerCase() == "oobmicrochip"
			||top.gl_raid_select_type.toLowerCase() == "oobcfcmicrochip"
			||top.gl_raid_select_type.toLowerCase() == "oobvroc"){
			$("#create_vol_cap").val(top.gl_defaultDiskCap);
		}else{
			$("#create_vol_cap").val(top.gl_leftAvaDiskCap);
		}
		$("#create_vol_name").val("");

		printLog("INFO", "button 'Create Volume' was clicked. type :" + top.gl_raid_select_type);

		var ctrl_selected_raid_lvl = document.getElementById("raidlvl");

		var raid_write_policy = {};
		var raid_strip_size_option = {};
		var raid_read_policy = {};
		var raid_init_policy = {};

		if (top.gl_raid_select_type.toLowerCase() == "oobvroc") {
			raid_strip_size_option[top.gl_raid_select_type] = ["4KB", "8KB", "16KB", "32KB", "64KB", "128KB"];
			if (ctrl_selected_raid_lvl.value == "1") {
				raid_strip_size_option[top.gl_raid_select_type].remove("128KB");      //RAID1 not support 128KB
			}
		} else if (top.gl_raid_select_type.toLowerCase() == "oobmicrochip") {
			raid_read_policy[top.gl_raid_select_type] = ["No Read Ahead", "Read Ahead"];
			raid_write_policy[top.gl_raid_select_type] = ["Write Back","Always Write Back","Off"];
			raid_strip_size_option[top.gl_raid_select_type] = ["64KB", "128KB", "256KB", "512KB", "1MB"];

		} else if (top.gl_raid_select_type.toLowerCase() == "oobcfcmicrochip") {
			raid_strip_size_option[top.gl_raid_select_type] = ["64KB", "128KB", "256KB", "512KB", "1MB"];

		} else if (top.gl_raid_select_type.toLowerCase() == "oobcfclsi") {
			raid_write_policy[top.gl_raid_select_type] = ["Write Through", "Unprotected Write Back"];
			raid_strip_size_option[top.gl_raid_select_type] = ["64KB", "128KB", "256KB", "512KB", "1MB"];
			raid_read_policy[top.gl_raid_select_type] = ["Off", "Read Ahead"];
			raid_init_policy[top.gl_raid_select_type] = ["No", "Fast", "Full"];

		} else {
			raid_write_policy[top.gl_raid_select_type] = ["Write Through"];
			raid_strip_size_option[top.gl_raid_select_type] = ["32KB", "64KB", "128KB", "256KB", "512KB", "1MB"];
		}

		if(top.gl_raid_select_type.toLowerCase() != "oobcfcmicrochip" && top.gl_raid_select_type.toLowerCase() != "oobvroc"){
			//ctrl RAID write policy option
			var tmp_raid_write_policy = document.getElementById("create_vol_write_policy");
			var support_raid_write_policy = raid_write_policy[top.gl_raid_select_type];
			tmp_raid_write_policy.options.length = 0;
			for (var i = 0; i < support_raid_write_policy.length; ++i) {
				tmp_raid_write_policy.options[i] = new Option(support_raid_write_policy[i]);
			}
		}

		//ctrl RAID strip size option
		var ctrl_id = top.gl_raid_select.replace("ctrl-", "");
		var tmp_raid_strip_size_option = document.getElementById("create_vol_strip_size");
		var support_raid_strip_size_option = getAppropriateStripeSize(ctrl_id, raid_strip_size_option[top.gl_raid_select_type].concat());
		tmp_raid_strip_size_option.length = 0;
		for (var i = 0; i < support_raid_strip_size_option.length; ++i) {
			tmp_raid_strip_size_option.options[i] = new Option(support_raid_strip_size_option[i]);
		}

		var defaultStripeValue = "32KB";

		if (top.gl_raid_select_type.toLowerCase() == "oobvroc") {

			if (ctrl_selected_raid_lvl.value == "1") {
				defaultStripeValue = "64KB";          //RAID1 default 64KB
			} else {
				defaultStripeValue = "128KB";         //RAID0 default 128KB
			}
			/*
			$("#create_vol_io_policy").val("Direct");             //need disable edit
			$("#create_vol_acc_policy").val("Read Write");        //need disable edit
			$("#create_vol_read_policy").val("No Read Ahead");    //need disable edit
			$("#create_vol_drive_cache").val("Unchanged");        //need disable edit
			$("#create_vol_write_policy").val("Off");             //need disable edit
			$("#create_vol_init").val("No");                      //need disable edit
			*/

			$("#create_vol_io_policy").hide();
			$("#create_vol_acc_policy").hide();
			$("#create_vol_read_policy").hide();
			$("#create_vol_drive_cache").hide();
			$("#create_vol_write_policy").hide();
			$("#create_vol_init").hide();

			$("#RaidConfig_IoPolicy").hide();
			$("#RaidConfig_AccPolicy").hide();
			$("#RaidConfig_ReadPolicy").hide();
			$("#RaidConfig_DriveCache").hide();
			$("#RaidConfig_WritePolicy").hide();
			$("#RaidConfig_Initialization").hide();

		} else if (top.gl_raid_select_type.toLowerCase() == "oobmicrochip") {
			var tmp_raid_read_policy = document.getElementById("create_vol_read_policy");
			var support_raid_read_policy = raid_read_policy[top.gl_raid_select_type];
			tmp_raid_read_policy.length = 0;
			for (var i = 0; i < support_raid_read_policy.length; ++i) {
				tmp_raid_read_policy.options[i] = new Option(support_raid_read_policy[i]);
			}

			defaultStripeValue = "256KB";
			$("#create_vol_read_policy").val("No Read Ahead");
			$("#create_vol_write_policy").val("Off");

			$("#create_vol_read_policy").show();
			$("#create_vol_write_policy").show();

			$("#RaidConfig_ReadPolicy").show();
			$("#RaidConfig_WritePolicy").show();

			/*
			$("#create_vol_io_policy").val("Cached");	          //need disable edit
			$("#create_vol_acc_policy").val("Read Write");        //need disable edit
			$("#create_vol_drive_cache").val("Disabled");         //need disable edit    
			$("#create_vol_init").val("No");                      //need disable edit
			*/

			$("#create_vol_io_policy").hide();
			$("#create_vol_acc_policy").hide();
			$("#create_vol_drive_cache").hide();
			$("#create_vol_init").hide();

			$("#RaidConfig_IoPolicy").hide();
			$("#RaidConfig_AccPolicy").hide();
			$("#RaidConfig_DriveCache").hide();
			$("#RaidConfig_Initialization").hide();
		} else if (top.gl_raid_select_type.toLowerCase() == "oobcfcmicrochip") {
			defaultStripeValue = "64KB";
			$("#create_vol_io_policy").hide();
			$("#create_vol_acc_policy").hide();
			$("#create_vol_read_policy").hide();
			$("#create_vol_drive_cache").hide();
			$("#create_vol_write_policy").hide();
			$("#create_vol_init").hide();

			$("#RaidConfig_IoPolicy").hide();
			$("#RaidConfig_AccPolicy").hide();
			$("#RaidConfig_ReadPolicy").hide();
			$("#RaidConfig_DriveCache").hide();
			$("#RaidConfig_WritePolicy").hide();
			$("#RaidConfig_Initialization").hide();
		} else if (top.gl_raid_select_type.toLowerCase() == "oobcfclsi") {

			var tmp_raid_read_policy = document.getElementById("create_vol_read_policy");
			var support_raid_read_policy = raid_read_policy[top.gl_raid_select_type];
			tmp_raid_read_policy.length = 0;
			for (var i = 0; i < support_raid_read_policy.length; ++i) {
				tmp_raid_read_policy.options[i] = new Option(support_raid_read_policy[i]);
			}

			var tmp_raid_init_policy = document.getElementById("create_vol_init");
			var support_raid_init_policy = raid_init_policy[top.gl_raid_select_type];
			tmp_raid_init_policy.length = 0;
			for (var i = 0; i < support_raid_init_policy.length; ++i) {
				tmp_raid_init_policy.options[i] = new Option(support_raid_init_policy[i]);
			}

			defaultStripeValue = "64KB";
			$("#create_vol_acc_policy").val("Read Write");
			$("#create_vol_read_policy").val("Off");
			$("#create_vol_drive_cache").val("Unchanged");
			$("#create_vol_write_policy").val("Write Through");
			$("#create_vol_init").val("No");

			$("#create_vol_io_policy").hide();
			$("#RaidConfig_IoPolicy").hide();

			$("#create_vol_acc_policy").show();
			$("#create_vol_read_policy").show();
			$("#create_vol_drive_cache").show();
			$("#create_vol_write_policy").show();
			$("#create_vol_init").show();

			$("#RaidConfig_AccPolicy").show();
			$("#RaidConfig_ReadPolicy").show();
			$("#RaidConfig_DriveCache").show();
			$("#RaidConfig_WritePolicy").show();
			$("#RaidConfig_Initialization").show();
		} else {
			$("#create_vol_io_policy").val("Direct");
			defaultStripeValue = "32KB";
			$("#create_vol_acc_policy").val("Read Write");
			$("#create_vol_read_policy").val("Read Ahead");
			$("#create_vol_drive_cache").val("Unchanged");
			$("#create_vol_write_policy").val("Write Through");
			$("#create_vol_init").val("No");

			$("#create_vol_io_policy").show();
			$("#create_vol_acc_policy").show();
			$("#create_vol_read_policy").show();
			$("#create_vol_drive_cache").show();
			$("#create_vol_write_policy").show();
			$("#create_vol_init").show();

			$("#RaidConfig_IoPolicy").show();
			$("#RaidConfig_AccPolicy").show();
			$("#RaidConfig_ReadPolicy").show();
			$("#RaidConfig_DriveCache").show();
			$("#RaidConfig_WritePolicy").show();
			$("#RaidConfig_Initialization").show();
		}
		if (support_raid_strip_size_option.indexOf(defaultStripeValue) != -1) {
			$("#create_vol_strip_size").val(defaultStripeValue);
		} else {
			$("#create_vol_strip_size").prop("selectedIndex", 0);
		}
		$("#createVolForm").show();
		vol_action_type = {
			type: "",
			name: ""
		};
		vol_action_type.type = "create";
		stripeSizeChangeSet(vol_action_type.type);
		$("#form_step2_prev").attr("disabled", true);
		$("#form_step2_prev").removeClass("btn-primary");
		$("#form_step2_prev").addClass("btn-default");
		$("#form_step2_next").attr("disabled", true);
		$("#form_step2_next").removeClass("btn-primary");
		$("#form_step2_next").addClass("btn-default");
	}

	function removeVolume() {
		warnMessageShow(false);
		printLog("INFO", "button 'Remove Volume' was clicked.");
		vol_action_type = {};
		vol_action_type.type = "remove";
		var temp_arr = [];
		for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
			if (top.gl_vol_select.replace("vol-", "") == top.gl_raid_user_create_vol[i].index) {
				continue;
			} else {
				temp_arr.push(top.gl_raid_user_create_vol[i]);
			}
		}
		top.gl_raid_user_create_vol = temp_arr;
		stripeSizeChangeSet(vol_action_type.type);
		
		$("#editVol").attr("disabled", true);
		$("#editVol").addClass("DisabledText");
		$("#removeVol").attr("disabled", true);
		$("#removeVol").addClass("DisabledText");
		refreshVolCreateTab();
		setLeftAvaDiskCap();
		$("#createVolForm").hide();
		$("#form_step2_prev").attr("disabled", false);
		$("#form_step2_next").attr("disabled", false);
		$("#form_step2_prev").addClass("btn-primary");
		$("#form_step2_prev").removeClass("btn-default");
		$("#form_step2_next").addClass("btn-primary");
		$("#form_step2_next").removeClass("btn-default");
	}

	function showEditVol() {
		warnMessageShow(false);
		printLog("INFO", "button 'Edit Volume' was clicked.");
		vol_action_type = {
			type: "",
			name: ""
		}
		vol_action_type.type = "edit";
		var vol_name = "";
		var vol_cap = 0;
		for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
			if (top.gl_raid_user_create_vol[i].index == top.gl_vol_select.replace("vol-", "")) {
				vol_name = top.gl_raid_user_create_vol[i].name;
				$("#create_vol_name").val(vol_name);
				vol_cap = top.gl_raid_user_create_vol[i].capacity;
				vol_cap = formatCapToGb(vol_cap);
				$("#create_vol_cap").val(vol_cap);
				$("#create_vol_index").val(top.gl_raid_user_create_vol[i].index);
				$("#create_vol_io_policy").val(top.gl_raid_user_create_vol[i].io_policy);
				$("#create_vol_strip_size").val(top.gl_raid_user_create_vol[i].strip_size);
				$("#create_vol_acc_policy").val(top.gl_raid_user_create_vol[i].acc_policy);
				$("#create_vol_read_policy").val(top.gl_raid_user_create_vol[i].read_policy);
				$("#create_vol_drive_cache").val(top.gl_raid_user_create_vol[i].drive_cache);
				$("#create_vol_write_policy").val(top.gl_raid_user_create_vol[i].write_policy);
				$("#create_vol_init").val(top.gl_raid_user_create_vol[i].init);
				break;
			}
		}

		stripeSizeChangeSet(vol_action_type.type);

		vol_action_type.name = vol_name;
		setLeftAvaDiskCap(vol_cap);
		$("#avaDiskCap").val(top.gl_leftAvaDiskCap);
		$("#avaDiskCap").html(top.gl_leftAvaDiskCap);
		$("#createVolForm").show();

		$("#form_step2_prev").attr("disabled", true);
		$("#form_step2_prev").removeClass("btn-primary");
		$("#form_step2_prev").addClass("btn-default");
		$("#form_step2_next").attr("disabled", true);
		$("#form_step2_next").removeClass("btn-primary");
		$("#form_step2_next").addClass("btn-default");
	}

	function formatCapToGb(cap) {
		var ret_cap = 0;
		if (cap.indexOf("GB") != -1) {
			ret_cap = cap.replace("GB", "").trim();
			ret_cap = parseFloat(ret_cap);
			ret_cap = ret_cap.toFixed(3);
		} else if (cap.indexOf("MB") != -1) {
			ret_cap = cap.replace("MB", "").trim();
			ret_cap = parseFloat(ret_cap);
			ret_cap = ret_cap.toFixed(3);
		} else {
			ret_cap = cap.trim();
			ret_cap = parseFloat(ret_cap);
			ret_cap = ret_cap.toFixed(3);
		}
		return ret_cap;
	}

	function setAvaDiskCap() {
		top.gl_totalAvaDiskCap = 0;
		if (top.gl_raid_select_disk.spans) {
			if (top.gl_raid_select_disk.spans.length > 0) {
				for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
					for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
						var cap = top.gl_raid_select_disk.spans[i].disks[j].capacity;
						cap = formatCapToGb(cap);
						top.gl_totalAvaDiskCap = parseFloat(top.gl_totalAvaDiskCap) + parseFloat(cap);
					}
				}
			}
		}
		if (top.gl_raid_select_disk.disks) {
			if (top.gl_raid_select_disk.disks.length > 0) {
				for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
					var cap = top.gl_raid_select_disk.disks[i].capacity;
					cap = formatCapToGb(cap);
					top.gl_totalAvaDiskCap = parseFloat(top.gl_totalAvaDiskCap) + parseFloat(cap);
				}
			}
		}
	}

	function setAvaDiskCapExt(radilvl) {

		arraycap = new Array();
		var diskcount = 0;
		top.gl_defaultDiskCap = 0;
		if (top.gl_raid_select_disk.spans) {
			if (top.gl_raid_select_disk.spans.length > 0) {
				for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
					for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
						var cap = top.gl_raid_select_disk.spans[i].disks[j].capacity;
						cap = formatCapToGb(cap);
						arraycap[i] = parseFloat(cap);
					}
				}
			}
		}
		if (top.gl_raid_select_disk.disks) {
			if (top.gl_raid_select_disk.disks.length > 0) {
				for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
					var cap = top.gl_raid_select_disk.disks[i].capacity;
					cap = formatCapToGb(cap);
					arraycap.push(parseFloat(cap));
				}
			}
		}

		diskcount = arraycap.length;
		Array.from(new Set(arraycap)).sort();

		if (radilvl == "0" || radilvl == "00") {
			top.gl_defaultDiskCap = arraycap[0] * diskcount;
		} else if (radilvl == "1" || radilvl == "10" || radilvl == "1E") {
			top.gl_defaultDiskCap = (arraycap[0] * diskcount) * 0.5;
		} else if (radilvl == "5") {
			top.gl_defaultDiskCap = (arraycap[0] * diskcount) * ((diskcount - 1) / diskcount);
		} else if (radilvl == "6" || radilvl == "50" || radilvl == "5E" || radilvl == "5EE") {
			top.gl_defaultDiskCap = (arraycap[0] * diskcount) * ((diskcount - 2) / diskcount);
		} else if (radilvl == "60") {
			top.gl_defaultDiskCap = (arraycap[0] * diskcount) * ((diskcount - 4) / diskcount);
		} else if(radilvl == "1T" || radilvl == "10T"){
			top.gl_defaultDiskCap = arraycap[0] * (diskcount / 3)
		} else {
			printLog("INFO","unsupport Raid type:" + raidlvl);
		}
		top.gl_defaultDiskCap = parseFloat(top.gl_defaultDiskCap).toFixed(3);
	}

	function setLeftAvaDiskCap(vol_cap) {
		var total_used_cap = 0;
		if (top.gl_raid_user_create_vol.length > 0) {
			for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
				var cap = top.gl_raid_user_create_vol[i].capacity;
				if (cap.indexOf("GB") != -1) {
					cap = cap.replace("GB", "").trim();
					cap = parseFloat(cap);
					cap = cap.toFixed(3);
				}
				if (cap.indexOf("MB") != -1) {
					cap = cap.replace("MB", "").trim();
					cap = parseFloat(cap);
					cap = cap / 1024;
					cap = cap.toFixed(3);
				}
				total_used_cap = parseFloat(total_used_cap) + parseFloat(cap);
			}
		}
		top.gl_leftAvaDiskCap = top.gl_totalAvaDiskCap - total_used_cap;
		top.gl_leftAvaDiskCap = parseFloat(top.gl_leftAvaDiskCap).toFixed(3);
		if (vol_cap) {
			if (vol_action_type.type == "edit") {
				top.gl_leftAvaDiskCap = parseFloat(top.gl_leftAvaDiskCap) + parseFloat(vol_cap);
				top.gl_leftAvaDiskCap = top.gl_leftAvaDiskCap.toFixed(3);
			}
		}
		$("#avaDiskCap").html(top.gl_leftAvaDiskCap);
		$("#avaDiskCap").val(top.gl_leftAvaDiskCap);
	}

	function retrInfo() {
		user_cancel = false;
		top.gl_raid_info_array = new Array();
		top.gl_raid_info_array.ctrls = new Array();

		raidShowPath = top.getSupportFile("raidShowResult");
		raidResultPath = top.getSupportFile("raidResult");
		if (top.fileExists(raidShowPath)) {
			top.deleteFile(raidShowPath);
		}
		if (top.fileExists(raidResultPath)) {
			top.deleteFile(raidResultPath);
		}

		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("misc");
		args.push("raid");
		args.push("show");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push(...add_output_log5());
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, retrInfoCb);

		// retrInfoCb(true);
	}

	function getRcMsg() {
		var ret = new Object();
		if (!top.fileExists(top.getSupportFile("raidResult"))) {
			ret = rc404();
		} else {
			var raidResultContent = "";
			try {
				raidResultContent = top.readTextFile(top.getSupportFile("raidResult"));
			} catch (e) {
				ret = rc404();
				return ret;
			}
			var raidResultDom = "";
			try {
				raidResultDom = ezJsLib.XmlDom.parse(raidResultContent);
				var raidRc = ezJsLib.XmlDom.getValueByTagFromNode("RETURNCODE", raidResultDom.documentElement);
				var raidMsg = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", raidResultDom.documentElement);
				setLogFile(ezJsLib.XmlDom.getValueByTagFromNode("LOGFILE", raidResultDom.documentElement));
				var raidItems = ezJsLib.XmlDom.getChildNodeByTagFromNode("ITEMS", raidResultDom.documentElement);
				if (raidRc != "0" && raidItems != null && raidItems != undefined) {
					var items = raidItems.getElementsByTagName("ITEM");
					for (var i = 0; i < items.length; ++i) {
						var deviceName = ezJsLib.XmlDom.getValueByTagFromNode("DEVICE", items[i]);
						var deviceResult = ezJsLib.XmlDom.getValueByTagFromNode("RESULT", items[i]);
						raidMsg += "<br/>DEVICE " + deviceName + ": " + deviceResult;
					}
				}

			} catch (e) {
				ret = rc404();
				return ret;
			}
			ret.rc = raidRc;
			ret.msg = raidMsg;
		}
		return ret;
	}

	function rc404() {
		var ret = {};
		ret.rc = "404";
		ret.msg = $.i18n.prop("RaidConfig.CannotGetOnecliStatus");
		return ret;
	}

	function getSupportInfo(id, controller) {

		top.gl_raid_select_supportlevel[id] = null;
		top.gl_minStripeSize[id] = 0;
		top.gl_maxStripeSize[id] = 0;

		try {
			top.gl_minStripeSize[id] = ezJsLib.XmlDom.getValueByTagFromNode("MinStripeSize", controller);
		} catch (e) {
		}

		try {
			top.gl_maxStripeSize[id] = ezJsLib.XmlDom.getValueByTagFromNode("MaxStripeSize", controller);
		} catch (e) {
		}

		try {
			var support_levels = ezJsLib.XmlDom.getValueByTagFromNode("SupportRaidLevels", controller);
			top.gl_raid_select_supportlevel[id] = support_levels.split(',');
		} catch (e) {
		}

		printLog("INFO", "Controller:" + id + " support raidlvl:" + top.gl_raid_select_supportlevel[id]);
		printLog("INFO", "Controller:" + id + " support stripe size range:" + top.gl_minStripeSize[id] + " - " + top.gl_maxStripeSize[id]);

	}

	function retrInfoCb() {
		if (user_cancel) {
			cancelRetr();
			return;
		}
		var ret = getRcMsg();
		if (ret.rc != "0") {
			retrFail(ret);
			return;
		}
		if (!top.fileExists(raidShowPath)) {
			ret = rc404();
			retrFail(ret);
			return;
		}
		$("#raidStatusDiv").hide();
		$("#startRetrBtn").hide();
		$("#cancelRetrBtn").hide();
		var table = document.getElementById("raid_info_table");
		try {
			var raidShowContent = top.readTextFile(raidShowPath);
		} catch (e) {
			ret = rc404();
			retrFail(ret);
			return;
		}
		if (raidShowContent == null || raidShowContent == undefined) {
			ret = rc404();
			retrFail(ret);
			return;
		}

		var controllerIdTag                   = "ControllerID";
		var rootTag                           = "CONTROLLER";
		var controllerTypeTag                 = "Type";
		var controllerNameTag                 = "ProductName";

		var raidRootTag                       = "POOLS";
		var raidPoolTag                       = "POOL";
		var raidIdTag                         = "PoolID";
		var raidStateTag                      = "RAIDState";
		var raidCapacityTag                   = "RAIDCapacity";

		var raidVolumeRootTag                 = "VOLUMES";
		var raidVolumeTag                     = "VOLUME";
		var raidVolumeIdTag                   = "VolumeID";
		var raidVolumeNameTag                 = "Name";
		var raidVolumeStateTag                = "Status";
		var raidVolumeCapacity                = "Capacity";

		var diskRootTag                       = "DISKS";
		var diskTag                           = "DISK";
		var diskIdTag                         = "DiskID";
		var diskNameTag                       = "ProductName";
		var diskStateTag                      = "State";
		var diskSlotNoTag                     = "SlotNo";
		var diskCapacityTag                   = "Capacity";
		var diskMediaTypeTag                  = "MediaType";
		var diskTypeTag                       = "DiskType";
		// var diskManufacturerTag               = "Manufacturer";
		var diskSerialNoTag                   = "SerialNo";
		var diskPartNoTag                     = "PartNo";
		var diskFRUNoTag                      = "FRUNo";

		var raidShowDom = ezJsLib.XmlDom.parse(raidShowContent);
		var controllers = new Array();
		try {
			controllers = raidShowDom.documentElement.getElementsByTagName(rootTag);
		} catch (e) {
			controllers = new Array();
		}
		if (controllers.length == 0) {
			return;
		}

		top.gl_raid_select_supportlevel = {};
		top.gl_minStripeSize = {};
		top.gl_maxStripeSize = {};
		for (var ctrl_index = 0; ctrl_index < controllers.length; ctrl_index++) {
			var active_disk_array = new Array();
			var id = "";
			try {
				id = ezJsLib.XmlDom.getValueByTagFromNode(controllerIdTag, controllers[ctrl_index]);
			} catch (e) {
				id = "";
			}
			if (id == null || id == undefined) {
				id = "";
			}
			var type = "";
			try {
				type = ezJsLib.XmlDom.getValueByTagFromNode(controllerTypeTag, controllers[ctrl_index]);
			} catch (e) {
				type = "";
			}
			if (type == "OOBM2") {
				id = "m.2-" + id; // to be compatible with old code, will remove this tag before command running
			}

			printLog("INFO", "current select raid type: " + type + ".");

			var ctrl_name = "";
			try {
				ctrl_name = ezJsLib.XmlDom.getValueByTagFromNode(controllerNameTag, controllers[ctrl_index]);
			} catch (e) {
				ctrl_name = "";
			}
			if (ctrl_name == null || ctrl_name == undefined) {
				ctrl_name = "";
			}

			getSupportInfo(id, controllers[ctrl_index]);

			if (id.toLowerCase().indexOf("m.2") != -1) {
				id = id.toLowerCase();
				ctrl_name = id;
			}
			else {
				if (null == top.gl_raid_select_supportlevel[id]) {
					if(type.toLowerCase() == "oobvroc") {
						top.gl_raid_select_supportlevel[id] = ["RAID0", "RAID1", "RAID5", "RAID10"];
					} else if(type.toLowerCase() == "oobmicrochip"){
						top.gl_raid_select_supportlevel[id] = ["RAID0", "RAID1", "RAID5", "RAID6", "RAID10", "RAID50", "RAID60", "RAID00", "RAID1T", "RAID10T"];
					} else{
						top.gl_raid_select_supportlevel[id] = ["RAID0", "RAID1", "RAID5", "RAID6", "RAID10", "RAID50", "RAID60", "RAID00"];  //GP brcm/CFC brcm/CFC microchip
					}
				}
				else if (-1 != top.gl_raid_select_supportlevel[id].indexOf("RAID0")) {
					if(type.toLowerCase() == "ooblsi"){
						top.gl_raid_select_supportlevel[id].add("RAID00");
					}
				}
			}

			ctrl_name = "Controller " + ctrl_name;
			// new ctrl row
			var new_ctrl_row = table.insertRow(-1);
			var ctrl_id = "ctrl-" + id;
			new_ctrl_row.id = ctrl_id;
			// first cell, for radio
			var ctrl_radio_id = "radio_" + ctrl_id;
			var ctrl_radio_cell = new_ctrl_row.insertCell(-1);
			var ctrl_type = "ctrl-" + type;
			ctrl_radio_cell.className = "RaidTableCellRadio";
			ctrl_radio_cell.style.width = "3%";
			ctrl_radio_cell.setAttribute("role", "presentation");
			ctrl_radio_cell.innerHTML = "<input id='" + ctrl_radio_id + "' type='radio' name='test' value='" + ctrl_type + "' onclick='Raid_Config.selectRaidRow(this.id,this.value)' aria-label='" + ctrl_name + "'>";
			// ctrl name
			var ctrl_name_cell = new_ctrl_row.insertCell(-1);
			ctrl_name_cell.className = "RaidTableCell";
			ctrl_name_cell.style.width = "30%";
			// ctrl_name_cell.innerHTML = "<img src='./images/treeExpand_mius.gif' style='margin-left:10px' border='0'>" + ctrl_name;
			ctrl_name_cell.innerHTML = "<div style='margin-left:5px'><img class='styleShow' id='toggle_" + ctrl_id + "' onclick='Raid_Config.toggleRow(this.id)' src='./images/treeExpand_mius.gif' style='cursor:pointer' border='0'>" + ctrl_name + "</div>";
			ctrl_name_cell.title = ctrl_name;
			// empty cell

			var ctrl_empty_cell1 = new_ctrl_row.insertCell(-1);
			ctrl_empty_cell1.className = "RaidTableCell";
			ctrl_empty_cell1.style.width = "20%";
			ctrl_empty_cell1.innerHTML = " ";
			// empty cell
			var ctrl_empty_cell2 = new_ctrl_row.insertCell(-1);
			ctrl_empty_cell2.className = "RaidTableCell";
			ctrl_empty_cell2.style.width = "15%";
			ctrl_empty_cell2.innerHTML = " ";
			// empty cell
			var ctrl_empty_cell3 = new_ctrl_row.insertCell(-1);
			ctrl_empty_cell3.className = "RaidTableCell";
			ctrl_empty_cell3.style.width = "15%";
			ctrl_empty_cell3.innerHTML = " ";

			// empty cell
			var ctrl_empty_cell4 = new_ctrl_row.insertCell(-1);
			ctrl_empty_cell4.className = "RaidTableCell";
			ctrl_empty_cell4.style.width = "20%";
			ctrl_empty_cell4.innerHTML = " ";

			var curr_ctrl = {};
			curr_ctrl.id = id;
			curr_ctrl.name = ctrl_name.replace("Controller ", "");
			curr_ctrl.pools = new Array();
			curr_ctrl.non_raid_disks = new Array();

			var pools = new Array();
			try {
				pools = controllers[ctrl_index].getElementsByTagName(raidRootTag)[0];
				pools = pools.getElementsByTagName(raidPoolTag);
			} catch (e) {
				pools = new Array();
			}

			for (var pool_index = 0; pool_index < pools.length; pool_index++) {
				// pool and row id
				var pool_id = "";
				try {
					if(top.isCFC(top.gl_mt_list[0])){
						pool_id = ezJsLib.XmlDom.getValueByTagFromNode(raidVolumeIdTag, pools[pool_index]);
					}else{
						pool_id = ezJsLib.XmlDom.getValueByTagFromNode(raidIdTag, pools[pool_index]);
					}
					
				} catch (e) {
					pool_id = "";
				}
				if (pool_id == null || pool_id == undefined) {
					pool_id = "";
				}
				if (pool_id == "") {
					pool_id = "m.2";
				}
				pool_id = "pool-" + pool_id;
				var new_pool_row = table.insertRow(-1);
				var row_id = ctrl_id + "_" + pool_id + "_pooltitle";
				new_pool_row.id = row_id;
				// empty cell1
				var pool_empty_cell1 = new_pool_row.insertCell(-1);
				pool_empty_cell1.className = "RaidTableCellRadio";
				pool_empty_cell1.style.width = "3%";
				pool_empty_cell1.innerHTML = " ";
				// pool name
				var pool_name = "Storage Array " + pool_id;
				var pool_name_cell = new_pool_row.insertCell(-1);
				pool_name_cell.className = "RaidTableCell";
				pool_name_cell.style.width = "30%";
				// pool_name_cell.innerHTML = "<img src='./images/treeExpand_mius.gif' style='margin-left:20px' border='0'>" + " " + pool_name;
				pool_name_cell.innerHTML = "<div style='margin-left:20px'><img class='styleShow' id='toggle_" + row_id + "' onclick='Raid_Config.toggleRow(this.id)' src='./images/treeExpand_mius.gif' style='cursor:pointer' border='0'>" + pool_name + "</div>";
				pool_name_cell.title = pool_name;
				// pool state
				var pool_state = "";
				try {
					pool_state = ezJsLib.XmlDom.getValueByTagFromNode(raidStateTag, pools[pool_index]);
				} catch (e) {
					pool_state = "";
				}
				if (pool_state == null || pool_state == undefined) {
					pool_state = "";
				}
				var pool_state_cell = new_pool_row.insertCell(-1);
				pool_state_cell.className = "RaidTableCell";
				pool_state_cell.style.width = "20%";
				pool_state_cell.innerHTML = " " + pool_state;
				pool_state_cell.title = pool_state;
				// pool capacity
				var pool_cap = "";
				try {
					pool_cap = ezJsLib.XmlDom.getValueByTagFromNode(raidCapacityTag, pools[pool_index]);
				} catch (e) {
					pool_cap = "";
				}
				if (pool_cap == null || pool_cap == undefined) {
					if (top.isCFC(top.gl_mt_list[0])) {
						pool_cap = ezJsLib.XmlDom.getValueByTagFromNode(raidVolumeCapacity, pools[pool_index]);
					} else {
						pool_cap = "";
					}
				}
				var pool_cap_cell = new_pool_row.insertCell(-1);
				pool_cap_cell.className = "RaidTableCell";
				pool_cap_cell.style.width = "15%";
				pool_cap_cell.innerHTML = " " + pool_cap;
				pool_cap_cell.title = pool_cap;

				// empty cell2
				var pool_empty_cell2 = new_pool_row.insertCell(-1);
				pool_empty_cell2.className = "RaidTableCell";
				pool_empty_cell2.style.width = "15%";
				pool_empty_cell2.innerHTML = " ";

				// empty cell2

				var pool_empty_cell3 = new_pool_row.insertCell(-1);
				pool_empty_cell3.className = "RaidTableCell";
				pool_empty_cell3.style.width = "20%";
				pool_empty_cell3.innerHTML = " ";

				var curr_pool = {};
				curr_pool.id = pool_id.replace("pool-", "");
				curr_pool.name = pool_name.replace("Storage Array ", "").replace("pool-", "");
				curr_pool.state = pool_state;
				curr_pool.capacity = pool_cap;
				curr_pool.active_disks = new Array();
				curr_pool.volumes = new Array();

				var volumes = new Array();
				try {
					volumes = pools[pool_index].getElementsByTagName(raidVolumeRootTag)[0];
					volumes = volumes.getElementsByTagName(raidVolumeTag);
				} catch (e) {
					volumes = new Array();
				}
				for (var volume_index = 0; volume_index < volumes.length; volume_index++) {
					// new row
					var vol_id = "";
					try {
						vol_id = ezJsLib.XmlDom.getValueByTagFromNode(raidVolumeIdTag, volumes[volume_index]);
					} catch (e) {
						vol_id = "";
					}
					if (vol_id == null || vol_id == undefined) {
						vol_id = "";//fix coverity issue 110760
					}
					vol_id = "volume-" + vol_id;
					var new_vol_row_id = ctrl_id + "_" + pool_id + "_" + vol_id;
					var new_vol_row = table.insertRow(-1);
					new_vol_row.id = new_vol_row_id;
					// empty cell1
					var vol_empty_cell1 = new_vol_row.insertCell(-1);
					vol_empty_cell1.className = "RaidTableCellRadio";
					vol_empty_cell1.style.width = "3%";
					vol_empty_cell1.innerHTML = " ";
					// vol name
					var vol_name = "";
					try {
						vol_name = ezJsLib.XmlDom.getValueByTagFromNode(raidVolumeNameTag, volumes[volume_index]);
					} catch (e) {
						vol_name = "";
					}
					if (vol_name == null || vol_name == undefined) {
						vol_name = "";
					}
					vol_name = "Volume " + vol_name;
					var vol_name_cell = new_vol_row.insertCell(-1);
					vol_name_cell.className = "RaidTableCell";
					vol_name_cell.style.width = "30%";
					vol_name_cell.innerHTML = "<div style='margin-left:30px'>" + vol_name + "</div>";
					vol_name_cell.title = vol_name;
					// vol state
					var vol_state = "";
					try {
						vol_state = ezJsLib.XmlDom.getValueByTagFromNode(raidVolumeStateTag, volumes[volume_index]);
					} catch (e) {
						vol_state = "";
					}
					if (vol_state == null || vol_name == undefined) {
						vol_state = "";
					}
					var vol_state_cell = new_vol_row.insertCell(-1);
					vol_state_cell.className = "RaidTableCell";
					vol_state_cell.style.width = "20%";
					vol_state_cell.innerHTML = vol_state;
					vol_state_cell.title = vol_state;
					// vol cap
					var vol_cap = "";
					try {
						vol_cap = ezJsLib.XmlDom.getValueByTagFromNode(raidVolumeCapacity, volumes[volume_index]);
					} catch (e) {
						vol_cap = "";
					}
					if (vol_cap == null || vol_cap == undefined) {
						vol_cap = "";
					}
					var vol_cap_cell = new_vol_row.insertCell(-1);
					vol_cap_cell.className = "RaidTableCell";
					vol_cap_cell.style.width = "15%";
					vol_cap_cell.innerHTML = vol_cap;
					vol_cap_cell.title = vol_cap;
					// empty cell2
					var vol_empty_cell2 = new_vol_row.insertCell(-1);
					vol_empty_cell2.className = "RaidTableCell";
					vol_empty_cell2.style.width = "15%";
					vol_empty_cell2.innerHTML = " ";

					// empty cell3
					var vol_empty_cell3 = new_vol_row.insertCell(-1);
					vol_empty_cell3.className = "RaidTableCell";
					vol_empty_cell3.style.width = "20%";
					vol_empty_cell3.innerHTML = " ";

					var curr_vol = {};
					curr_vol.id = vol_id.replace("volume-", "");
					curr_vol.name = vol_name.replace("Volume ", "");
					curr_vol.state = vol_state;
					curr_vol.capacity = vol_cap;
					curr_pool.volumes.push(curr_vol);
				}
				var active_disks = new Array();
				try {
					active_disks = pools[pool_index].getElementsByTagName(diskRootTag)[0];
					active_disks = active_disks.getElementsByTagName(diskTag);
				} catch (e) {
					active_disks = new Array();
				}
				for (var active_disks_index = 0; active_disks_index < active_disks.length; active_disks_index++) {
					// new row
					var active_disk_id = "";
					try {
						active_disk_id = ezJsLib.XmlDom.getValueByTagFromNode(diskIdTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_id = "";
					}
					var active_disk_slotno = "";
					try {
						active_disk_slotno = ezJsLib.XmlDom.getValueByTagFromNode(diskSlotNoTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_slotno = "";
					}
					if (active_disk_slotno == null || active_disk_slotno == undefined) {
						active_disk_slotno = "";
					}
					if (active_disk_id == "" || active_disk_id == null || active_disk_id == undefined) {
						active_disk_id = active_disk_slotno;
					}
					active_disk_array.push(active_disk_id);
					active_disk_id = "activedisk-" + active_disk_id;
					active_disk_row_id = ctrl_id + "_" + pool_id + "_" + active_disk_id;
					var new_active_disk_row = table.insertRow(-1);
					new_active_disk_row.id = active_disk_row_id;
					// empty cell1
					var active_disk_empty_cell1 = new_active_disk_row.insertCell(-1);
					active_disk_empty_cell1.className = "RaidTableCellRadio";
					active_disk_empty_cell1.style.width = "3%";
					active_disk_empty_cell1.innerHTML = " ";
					// active disk name
					var active_disk_name = "";
					try {
						active_disk_name = ezJsLib.XmlDom.getValueByTagFromNode(diskNameTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_name = "";
					}
					if (active_disk_name == null || active_disk_name == undefined) {
						active_disk_name = "";
					}
					active_disk_name = "Drive " + active_disk_id.replace("activedisk-", "");
					var active_disk_name_cell = new_active_disk_row.insertCell(-1);
					active_disk_name_cell.className = "RaidTableCell";
					active_disk_name_cell.style.width = "30%";
					active_disk_name_cell.innerHTML = "<div style='margin-left:30px'>" + active_disk_name + "</div>";
					active_disk_name_cell.title = active_disk_name;
					// active disk state
					var active_disk_state = "";
					try {
						active_disk_state = ezJsLib.XmlDom.getValueByTagFromNode(diskStateTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_state = "";
					}
					if (active_disk_state == null || active_disk_state == undefined) {
						active_disk_state = "";
					}
					var active_disk_state_cell = new_active_disk_row.insertCell(-1);
					active_disk_state_cell.className = "RaidTableCell";
					active_disk_state_cell.style.width = "20%";
					active_disk_state_cell.innerHTML = active_disk_state;
					active_disk_state_cell.title = active_disk_state;
					// active disk cap
					var active_disk_cap = "";
					try {
						active_disk_cap = ezJsLib.XmlDom.getValueByTagFromNode(diskCapacityTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_cap = "";
					}
					if (active_disk_cap == null || active_disk_cap == undefined) {
						active_disk_cap = "";
					}
					var active_disk_cap_cell = new_active_disk_row.insertCell(-1);
					active_disk_cap_cell.className = "RaidTableCell";
					active_disk_cap_cell.style.width = "15%";
					active_disk_cap_cell.innerHTML = active_disk_cap;
					active_disk_cap_cell.title = active_disk_cap;
					// active disk type
					var active_disk_details = "";
					try {
						active_disk_details = ezJsLib.XmlDom.getValueByTagFromNode(diskMediaTypeTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_details = "";
					}
					if (active_disk_details == null || active_disk_details == undefined) {
						active_disk_details = "";
					}

					var active_disk_type = "";
					try {
						active_disk_type = ezJsLib.XmlDom.getValueByTagFromNode(diskTypeTag, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_type = "";
					}
					if (active_disk_type == null || active_disk_type == undefined) {
						active_disk_type = "";
					}

					var active_disk_details_cell = new_active_disk_row.insertCell(-1);
					active_disk_details_cell.className = "RaidTableCell";
					active_disk_details_cell.style.width = "15%";
					active_disk_details_cell.innerHTML = (active_disk_type + " " + active_disk_details).trim();
					active_disk_details_cell.title = active_disk_details;

					// active disk serialno
					var active_disk_serialno = "";
					try {
						active_disk_serialno = ezJsLib.XmlDom.getValueByTagFromNode(diskSerialNo, active_disks[active_disks_index]);
					} catch (e) {
						active_disk_serialno = "";
					}
					if (active_disk_serialno == null || active_disk_serialno == undefined) {
						active_disk_serialno = "";
					}
					var active_disk_serialno_cell = new_active_disk_row.insertCell(-1);
					active_disk_serialno_cell.className = "RaidTableCell";
					active_disk_serialno_cell.style.width = "20%";
					active_disk_serialno_cell.innerHTML = active_disk_serialno;
					active_disk_serialno_cell.title = active_disk_serialno;

					var curr_active_disk = {};
					curr_active_disk.id = active_disk_id.replace("activedisk-", "");
					curr_active_disk.slotno = active_disk_slotno;
					curr_active_disk.name = active_disk_name.replace("Drive ", "");
					curr_active_disk.state = active_disk_state;
					curr_active_disk.capacity = active_disk_cap;
					curr_active_disk.details = active_disk_details;
					curr_active_disk.serialno = active_disk_serialno;
					curr_pool.active_disks.push(curr_active_disk);
				}
				curr_ctrl.pools.push(curr_pool);
			}

			// parse idle disks
			var all_disks = new Array();
			try {
				all_disks = controllers[ctrl_index].getElementsByTagName(diskRootTag);
			} catch (e) {
				all_disks = new Array();
			}

			var idle_disk_count = 0;
			for (var disks_index = 0; disks_index < all_disks.length; disks_index++) {
				var disk_set = all_disks[disks_index].getElementsByTagName(diskTag);
				for (var disk_set_index = 0; disk_set_index < disk_set.length; disk_set_index++) {
					var disk_set_id = "";
					try {
						disk_set_id = ezJsLib.XmlDom.getValueByTagFromNode(diskIdTag, disk_set[disk_set_index]);
					} catch (e) {
						disk_set_id = "";
					}
					var disk_set_slotno = "";
					try {
						disk_set_slotno = ezJsLib.XmlDom.getValueByTagFromNode(diskSlotNoTag, disk_set[disk_set_index]);
					} catch (e) {
						disk_set_slotno = "";
					}
					if (disk_set_slotno == null || disk_set_slotno == undefined) {
						disk_set_slotno = "";
					}
					if (disk_set_id == "" || disk_set_id == null || disk_set_id == undefined) {
						disk_set_id = disk_set_slotno;
					}

					var disk_set_state = "";
					try{
						disk_set_state = ezJsLib.XmlDom.getValueByTagFromNode(diskStateTag, disk_set[disk_set_index]);
					} catch (e) {
						disk_set_state = "";
					}
					if (disk_set_state == null || disk_set_state == undefined) {
						disk_set_state = "";
					}
					if (active_disk_array.indexOf(disk_set_id) == -1) {
						if(disk_set_state.toLowerCase() != "online" && disk_set_state.toLowerCase() != "dedicated hot spare"){
							idle_disk_count++;
						}
					}
				}
			}

			// insert row for non-raid disk title
			if (idle_disk_count > 0) {
				var non_raid_disk_title_row = table.insertRow(-1);
				var non_raid_disk_title_row_id = ctrl_id + "_" + "nonraiddisk";
				non_raid_disk_title_row.id = non_raid_disk_title_row_id;
				// empty cell1
				var non_raid_disk_title_empty_cell1 = non_raid_disk_title_row.insertCell(-1);
				non_raid_disk_title_empty_cell1.className = "RaidTableCellRadio";
				non_raid_disk_title_empty_cell1.style.width = "3%";
				non_raid_disk_title_empty_cell1.innerHTML = " ";
				// non raid disk title
				non_raid_disk_title = "Non-RAID Drives";
				var non_raid_disk_title_cell = non_raid_disk_title_row.insertCell(-1);
				non_raid_disk_title_cell.className = "RaidTableCell";
				non_raid_disk_title_cell.style.width = "30%";
				non_raid_disk_title_cell.innerHTML = "<div style='margin-left:20px'><img class='styleShow' id='toggle_" + non_raid_disk_title_row_id + "' onclick='Raid_Config.toggleRow(this.id)' src='./images/treeExpand_mius.gif' style='cursor:pointer' border='0'>" + non_raid_disk_title + "</div>";
				non_raid_disk_title_cell.title = non_raid_disk_title;
				// empty cell2
				var non_raid_disk_title_empty_cell2 = non_raid_disk_title_row.insertCell(-1);
				non_raid_disk_title_empty_cell2.className = "RaidTableCell";
				non_raid_disk_title_empty_cell2.style.width = "20%";
				non_raid_disk_title_empty_cell2.innerHTML = " ";
				// empty cell3
				var non_raid_disk_title_empty_cell3 = non_raid_disk_title_row.insertCell(-1);
				non_raid_disk_title_empty_cell3.className = "RaidTableCell";
				non_raid_disk_title_empty_cell3.style.width = "15%";
				non_raid_disk_title_empty_cell3.innerHTML = " ";
				// empty cell4
				var non_raid_disk_title_empty_cell4 = non_raid_disk_title_row.insertCell(-1);
				non_raid_disk_title_empty_cell4.className = "RaidTableCell";
				non_raid_disk_title_empty_cell4.style.width = "15%";
				non_raid_disk_title_empty_cell4.innerHTML = " ";

				// empty cell5
				var non_raid_disk_title_empty_cell5 = non_raid_disk_title_row.insertCell(-1);
				non_raid_disk_title_empty_cell5.className = "RaidTableCell";
				non_raid_disk_title_empty_cell5.style.width = "20%";
				non_raid_disk_title_empty_cell5.innerHTML = " ";
			}

			if (id.toLowerCase().indexOf("m.2") == -1) {
				if (idle_disk_count < 12){
					top.gl_raid_select_supportlevel[id].remove("RAID10T");
				}
				if (idle_disk_count < 6) {
					top.gl_raid_select_supportlevel[id].remove("RAID50");
					top.gl_raid_select_supportlevel[id].remove("RAID60");
				}
				if (idle_disk_count < 4) {
					top.gl_raid_select_supportlevel[id].remove("RAID10");
				}
				if (idle_disk_count < 3) {
					top.gl_raid_select_supportlevel[id].remove("RAID5");
					top.gl_raid_select_supportlevel[id].remove("RAID6");
					top.gl_raid_select_supportlevel[id].remove("RAID1T");
				}
				if (idle_disk_count < 2) {
					top.gl_raid_select_supportlevel[id].remove("RAID1");
					top.gl_raid_select_supportlevel[id].remove("RAID00");
				}
				if (idle_disk_count < 1) {
					top.gl_raid_select_supportlevel[id].remove("RAID0");
				}
			}

			for (var disks_index = 0; disks_index < all_disks.length; disks_index++) {
				var disk_set = all_disks[disks_index].getElementsByTagName(diskTag);
				for (var disk_set_index = 0; disk_set_index < disk_set.length; disk_set_index++) {
					var disk_set_id = "";
					try {
						disk_set_id = ezJsLib.XmlDom.getValueByTagFromNode(diskIdTag, disk_set[disk_set_index]);
					} catch (e) {
						disk_set_id = "";
					}
					var disk_set_slotno = "";
					try {
						disk_set_slotno = ezJsLib.XmlDom.getValueByTagFromNode(diskSlotNoTag, disk_set[disk_set_index]);
					} catch (e) {
						disk_set_slotno = "";
					}
					if (disk_set_slotno == null || disk_set_slotno == undefined) {
						disk_set_slotno = "";
					}
					if (disk_set_id == "" || disk_set_id == null || disk_set_id == undefined) {
						disk_set_id = disk_set_slotno;
					}
					if (active_disk_array.indexOf(disk_set_id) == -1) {
						// this is idle disk in all disks set
						var idle_disk_id = disk_set_id;
						idle_disk_id = "idledisk-" + idle_disk_id;
						var idle_disk_name = "";
						try {
							idle_disk_name = ezJsLib.XmlDom.getValueByTagFromNode(diskNameTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_name = "";
						}
						if (idle_disk_name == null || idle_disk_name == undefined) {
							idle_disk_name = "";
						}
						var idle_disk_display_name = "";
						idle_disk_display_name = "Drive " + idle_disk_id.replace("idledisk-", "");
						var idle_disk_state = "";
						try {
							idle_disk_state = ezJsLib.XmlDom.getValueByTagFromNode(diskStateTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_state = "";
						}
						if (idle_disk_state == null || idle_disk_state == undefined) {
							idle_disk_state = "";
						}
						// this is no state for m.2 disk, always set it to "good"
						if (idle_disk_state == "") {
							idle_disk_state = "good";
						}
						var idle_disk_state_display = "";
						if (idle_disk_state.toLowerCase().indexOf("good") != -1) {
							idle_disk_state = "good";
							idle_disk_state_display = "Unconfigured GOOD";
						} else if (idle_disk_state.toLowerCase().indexOf("bad") != -1) {
							idle_disk_state = "bad";
							idle_disk_state_display = "Unconfigured BAD";
						} else if (idle_disk_state.toLowerCase().indexOf("jbod") != -1) {
							idle_disk_state = "jbod";
							idle_disk_state_display = "JBOD";
						} else if (idle_disk_state.toLowerCase().indexOf("enable") != -1) {      //CFC add
							idle_disk_state = "enable";
							idle_disk_state_display = "Enable";
						} else if (idle_disk_state.toLowerCase().indexOf("online") != -1 || disk_set_state.toLowerCase() != "dedicated hot spare") {      //GP microchip use
							printLog("INFO","Drive " + idle_disk_display_name + " is in use.so not display.");
							continue;
						} else {
							idle_disk_state = idle_disk_state.toLowerCase();
							idle_disk_state_display = idle_disk_state.toUpperCase();
						}
						var idle_disk_cap = "";
						try {
							idle_disk_cap = ezJsLib.XmlDom.getValueByTagFromNode(diskCapacityTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_cap = "";
						}
						if (idle_disk_cap == null || idle_disk_cap == undefined) {
							idle_disk_cap = "";
						}
						var idle_disk_detail = "";
						try {
							idle_disk_detail = ezJsLib.XmlDom.getValueByTagFromNode(diskMediaTypeTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_detail = "";
						}
						if (idle_disk_detail == null || idle_disk_detail == undefined) {
							idle_disk_detail = "";
						}

						//show more disk information
						var idle_disk_type = "";
						try {
							idle_disk_type = ezJsLib.XmlDom.getValueByTagFromNode(diskTypeTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_type = "";
						}
						if (idle_disk_type == null || idle_disk_type == undefined) {
							idle_disk_type = "";
						}

						//show serialno
						var idle_disk_serialno = "";
						try {
							idle_disk_serialno = ezJsLib.XmlDom.getValueByTagFromNode(diskSerialNoTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_serialno = "";
						}
						if (idle_disk_serialno == null || idle_disk_serialno == undefined) {
							idle_disk_serialno = "";
						}

						//show partno
						var idle_disk_partno = "";
						try {
							idle_disk_partno = ezJsLib.XmlDom.getValueByTagFromNode(diskPartNoTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_partno = "";
						}
						if (idle_disk_partno == null || idle_disk_partno == undefined) {
							idle_disk_partno = "";
						}

						//show fruno
						var idle_disk_fruno = "";
						try {
							idle_disk_fruno = ezJsLib.XmlDom.getValueByTagFromNode(diskFRUNoTag, disk_set[disk_set_index]);
						} catch (e) {
							idle_disk_fruno = "";
						}
						if (idle_disk_fruno == null || idle_disk_fruno == undefined) {
							idle_disk_fruno = "";
						}

						var new_idle_disk_row = table.insertRow(-1);
						var new_idle_disk_row_id = ctrl_id + "_" + idle_disk_id + "_" + idle_disk_state;
						new_idle_disk_row.id = new_idle_disk_row_id;
						// first cell, for radio
						var idle_disk_radio_id = "radio_" + ctrl_id + "_" + idle_disk_id + "_" + idle_disk_state;
						var idle_disk_ctrl_type = "ctrl-" + type;
						var idle_disk_radio_cell = new_idle_disk_row.insertCell(-1);
						idle_disk_radio_cell.className = "RaidTableCellRadio";
						idle_disk_radio_cell.style.width = "3%";
						if (ctrl_id.replace("ctrl-", "").indexOf("m.2") != -1) {
							idle_disk_radio_cell.innerHTML = "";
						} else {
							idle_disk_radio_cell.setAttribute("role", "presentation");
							idle_disk_radio_cell.innerHTML = "<input id='" + idle_disk_radio_id + "' type='radio' value='" + idle_disk_ctrl_type + "' name='test' onclick='Raid_Config.selectRaidRow(this.id,this.value)' aria-label='" + idle_disk_display_name + "'>";
						}
						// non raid disk name
						var idle_disk_name_cell = new_idle_disk_row.insertCell(-1);
						idle_disk_name_cell.className = "RaidTableCell";
						idle_disk_name_cell.style.width = "30%";
						idle_disk_name_cell.innerHTML = "<div style='margin-left:30px'>" + idle_disk_display_name + "</div>";
						idle_disk_name_cell.title = idle_disk_display_name;
						// non raid disk state
						var idle_disk_state_cell = new_idle_disk_row.insertCell(-1);
						idle_disk_state_cell.className = "RaidTableCell";
						idle_disk_state_cell.style.width = "20%";
						idle_disk_state_cell.innerHTML = idle_disk_state_display;
						idle_disk_state_cell.title = idle_disk_state_display;
						// non raid disk capacity
						var idle_disk_cap_cell = new_idle_disk_row.insertCell(-1);
						idle_disk_cap_cell.className = "RaidTableCell";
						idle_disk_cap_cell.style.width = "15%";
						idle_disk_cap_cell.innerHTML = idle_disk_cap;
						idle_disk_cap_cell.title = idle_disk_cap;
						// non raid disk detail
						var idle_disk_detail_cell = new_idle_disk_row.insertCell(-1);
						idle_disk_detail_cell.className = "RaidTableCell";
						idle_disk_detail_cell.style.width = "15%";
						idle_disk_detail_cell.innerHTML = (idle_disk_type + " " + idle_disk_detail).trim();
						idle_disk_detail_cell.title = idle_disk_detail;

						// non raid disk serialno
						var idle_disk_serialno_cell = new_idle_disk_row.insertCell(-1);
						idle_disk_serialno_cell.className = "RaidTableCell";
						idle_disk_serialno_cell.style.width = "20%";
						idle_disk_serialno_cell.innerHTML = idle_disk_serialno;
						idle_disk_serialno_cell.title = idle_disk_serialno;

						var curr_idle_disk = {};
						curr_idle_disk.id = idle_disk_id.replace("idledisk-", "");
						curr_idle_disk.name = idle_disk_name;
						curr_idle_disk.state = idle_disk_state;
						curr_idle_disk.capacity = idle_disk_cap;
						curr_idle_disk.detail = idle_disk_detail;
						curr_idle_disk.serialno = idle_disk_serialno;

						curr_ctrl.non_raid_disks.push(curr_idle_disk);
					}
				}
			}
			top.gl_raid_info_array.ctrls.push(curr_ctrl);
		}
		top.togglePrevious(true);
		top.toggleNext(true);
		$("#tableRaidDiv").show();
		$("#buttonRaidDiv").show();
	}

	function disableDriveMake() {
			disableMakeGood();
			disableMakeJbod();
	}

	function selectRaidRow(id, value) {
		printLog("INFO", "radio " + id + " was checked.");
		$("#raid_info_table tr").each(function () {
			$(this).removeClass();
		});
		if (id.indexOf("radio_") != -1) {
			id = id.replace("radio_", "");
		}
		document.getElementById(id).className = "RowSelected";

		var ctrl_type = value;
		if (ctrl_type.indexOf("ctrl-") != -1) {
			ctrl_type = ctrl_type.replace("ctrl-", "");
		}
		printLog("INFO", "radio " + id + " was checked. type:" + ctrl_type);
		top.gl_raid_select_type = ctrl_type;
		top.gl_raid_select = id;
		if (top.gl_raid_select.indexOf("idledisk") != -1) {
			disableCreateVol();
			disableClearVol();
			
			if (top.isCFC(top.gl_mt_list[0]) || top.gl_raid_select_type.toLowerCase() == "oobvroc" || top.gl_raid_select_type.toLowerCase() == "oobmicrochip") {
				disableDriveMake();
			}else if(top.gl_raid_select.indexOf("good") == -1){
				enableMakeGood();
				disableMakeJbod();
			}else if(top.gl_raid_select.indexOf("jbod") == -1){
				disableMakeGood();
				enableMakeJbod();
			}
		} else {
			enableCreateVol();
			enableClearVol();
			disableMakeGood();
			disableMakeJbod();

			var gl_raid_ava_disk_check = new Array();
			var ctrl_id = id.replace("ctrl-", "");
			for (var i = 0; i < top.gl_raid_info_array.ctrls.length; i++) {
				if (top.gl_raid_info_array.ctrls[i].id == ctrl_id) {
					gl_raid_ava_disk_check = top.gl_raid_info_array.ctrls[i].non_raid_disks;
				}
			}
			// there is no available disk in this controller
			if (gl_raid_ava_disk_check.length < 1) {
				disableCreateVol();
			}
		}
	}

	function disableCreateVol() {
		$("#createVolume").attr("disabled", true);
		$("#createVolume").addClass("DisabledText");
	}

	function enableCreateVol() {
		$("#createVolume").attr("disabled", false);
		$("#createVolume").removeClass("DisabledText");
	}

	function disableClearVol() {
		$("#clearController").attr("disabled", true);
		$("#clearController").addClass("DisabledText");
	}

	function enableClearVol() {
		$("#clearController").attr("disabled", false);
		$("#clearController").removeClass("DisabledText");
	}

	function disableMakeGood() {
		$("#makeGoodBtn").attr("disabled", true);
		$("#makeGoodBtn").addClass("DisabledText");
	}

	function enableMakeGood() {
		$("#makeGoodBtn").attr("disabled", false);
		$("#makeGoodBtn").removeClass("DisabledText");
	}

	function disableMakeJbod() {
		$("#makeJbodBtn").attr("disabled", true);
		$("#makeJbodBtn").addClass("DisabledText");
	}

	function enableMakeJbod() {
		$("#makeJbodBtn").attr("disabled", false);
		$("#makeJbodBtn").removeClass("DisabledText");
	}

	function retrFail(ret) {
		if (!user_cancel) {
			$("#raid_info_table").empty();
			$("#buttonRaidDiv").hide();
			$("#tableRaidDiv").hide();
			$("#raidStatusDiv").show();
			if (ret.rc == "118") {
				$("#raidStatusDiv img")[0].src = "images/statusWarning.png";
				$("#raidMsgDiv").html($.i18n.prop("RaidConfig.NoController"));
			} else {
				$("#raidStatusDiv img")[0].src = "images/StatusCritical.png";
				$("#raidMsgDiv").html($.i18n.prop("RaidConfig.RetrFail", ret.msg));
			}
			$("#cancelRetrBtn").hide();
			$("#startRetrBtn").show();
		}
		top.togglePrevious(true);
		top.toggleNext(true);
	}

	function clearCtrl() {
		printLog("INFO", "button 'Clear Controller' was clicked.");
		if (!confirm($.i18n.prop("RaidConfig.ClearConfig"))) {
			return false;
		}
		top.togglePrevious(false);
		top.toggleNext(false);
		var ctrl_display = top.gl_raid_select.replace("ctrl-", "");
		var msg = $.i18n.prop("RaidConfig.ClearCtrl", ctrl_display);
		// $("#progressMsg").html(msg);
		// $("#progressRaidDiv").show();
		$("#raidStatusDiv img")[0].src = "images/progress_anim2.gif";
		$("#raidMsgDiv").html(msg);
		$("#raidStatusDiv").show();
		$("#tableRaidDiv").hide();
		$("#buttonRaidDiv").hide();
		$("#startRetrBtn").hide();
		$("#cancelRetrBtn").hide();
		raidShowPath = top.getSupportFile("raidShowResult");
		raidResultPath = top.getSupportFile("raidResult");
		if (top.fileExists(raidShowPath)) {
			top.deleteFile(raidShowPath);
		}
		if (top.fileExists(raidResultPath)) {
			top.deleteFile(raidResultPath);
		}
		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("misc");
		args.push("raid");
		args.push("clear");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push(...add_output_log5());
		// args.push("--target");
		// args.push(ctrl_display);
		args.push("--ctrl");
		args.push(ctrl_display.replace("m.2-", ""));
		args.push("--force");
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, clearCtrlCb);
	}

	function clearCtrlCb() {
		top.togglePrevious(true);
		top.toggleNext(true);
		var ret = getRcMsg();
		if (ret.rc != "0") {
			$("#raidMsgDiv").html($.i18n.prop("RaidConfig.ClearCtrlFail", ret.msg));
			$("#raidStatusDiv img")[0].src = "images/StatusCritical.png";
			$("#tableRaidDiv").show();
			$("#buttonRaidDiv").show();
		} else {
			var msg = $.i18n.prop("RaidConfig.ClearCtrlSuccess") + " " + $.i18n.prop("RaidConfig.CancelMsg");
			$("#startRetrBtn").show();
			$("#cancelRetrBtn").hide();
			$("#raidStatusDiv img")[0].src = "images/statusSuccess.gif";
			$("#raidMsgDiv").html(msg);
			$("#raidStatusDiv").show();
		}
	}

	function makeDiskGood() {
		printLog("INFO", "button 'Make Good' was clicked.");
		if (!confirm($.i18n.prop("RaidConfig.DoMakeGood"))) {
			return false;
		}
		top.toggleNext(false);
		top.togglePrevious(false);
		var _index = top.gl_raid_select.indexOf("_");
		var ctrl_select = top.gl_raid_select.substr(0, _index);
		var ctrl_display = ctrl_select.replace("ctrl-", "");
		var idledisk_index = top.gl_raid_select.indexOf("idledisk");
		var disk_display = top.gl_raid_select.substr(idledisk_index);
		var _index = disk_display.indexOf("_");
		disk_display = disk_display.substr(0, _index);
		disk_display = disk_display.replace("idledisk-", "");
		var msg = $.i18n.prop("RaidConfig.MakeDiskGood", disk_display, ctrl_display);
		$("#raidStatusDiv img")[0].src = "images/progress_anim2.gif";
		$("#raidMsgDiv").html(msg);
		$("#raidStatusDiv").show();
		$("#tableRaidDiv").hide();
		$("#buttonRaidDiv").hide();
		$("#startRetrBtn").hide();
		$("#cancelRetrBtn").hide();
		raidShowPath = top.getSupportFile("raidShowResult");
		raidResultPath = top.getSupportFile("raidResult");
		if (top.fileExists(raidShowPath)) {
			top.deleteFile(raidShowPath);
		}
		if (top.fileExists(raidResultPath)) {
			top.deleteFile(raidResultPath);
		}
		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("misc");
		args.push("raid");
		args.push("makegood");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push("--force");
		args.push(...add_output_log5());
		// args.push("--target");
		// args.push(ctrl_display);
		args.push("--ctrl");
		args.push(ctrl_display.replace("m.2-", ""));
		args.push("--drive");
		args.push(disk_display);
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, makeGoodCb);
	}

	function makeGoodCb() {
		top.toggleNext(true);
		top.togglePrevious(true);
		var ret = getRcMsg();
		if (ret.rc != "0") {
			$("#raidMsgDiv").html($.i18n.prop("RaidConfig.MakeGoodFail", ret.msg));
			$("#raidStatusDiv img")[0].src = "images/StatusCritical.png";
			$("#progressRaidDiv").hide();
			$("#tableRaidDiv").show();
			$("#buttonRaidDiv").show();
		} else {
			var msg = $.i18n.prop("RaidConfig.MakeGoodSuccess") + " " + $.i18n.prop("RaidConfig.CancelMsg");
			$("#startRetrBtn").show();
			$("#cancelRetrBtn").hide();
			$("#raidStatusDiv img")[0].src = "images/statusSuccess.gif";
			$("#raidMsgDiv").html(msg);
			$("#raidStatusDiv").show();
		}
	}

	function makeDiskJbod() {
		printLog("INFO", "button 'Make JBOD' was clicked.");
		if (!confirm($.i18n.prop("RaidConfig.DoMakeJbod"))) {
			return false;
		}
		top.toggleNext(false);
		top.togglePrevious(false);
		var _index = top.gl_raid_select.indexOf("_");
		var ctrl_select = top.gl_raid_select.substr(0, _index);
		var ctrl_display = ctrl_select.replace("ctrl-", "");
		var idledisk_index = top.gl_raid_select.indexOf("idledisk");
		var disk_display = top.gl_raid_select.substr(idledisk_index);
		var _index = disk_display.indexOf("_");
		disk_display = disk_display.substr(0, _index);
		disk_display = disk_display.replace("idledisk-", "");
		var msg = $.i18n.prop("RaidConfig.MakeDiskJbod", disk_display, ctrl_display);
		// $("#progressMsg").html(msg);
		// $("#progressRaidDiv").show();
		$("#raidStatusDiv img")[0].src = "images/progress_anim2.gif";
		$("#raidMsgDiv").html(msg);
		$("#raidStatusDiv").show();
		$("#tableRaidDiv").hide();
		$("#buttonRaidDiv").hide();
		$("#startRetrBtn").hide();
		$("#cancelRetrBtn").hide();
		raidShowPath = top.getSupportFile("raidShowResult");
		raidResultPath = top.getSupportFile("raidResult");
		if (top.fileExists(raidShowPath)) {
			top.deleteFile(raidShowPath);
		}
		if (top.fileExists(raidResultPath)) {
			top.deleteFile(raidResultPath);
		}
		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("misc");
		args.push("raid");
		args.push("makejbod");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		args.push("--force");
		args.push(...add_output_log5());
		// args.push("--target");
		// args.push(ctrl_display);
		args.push("--ctrl");
		args.push(ctrl_display.replace("m.2-", ""));
		args.push("--drive");
		args.push(disk_display);
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, makeJbodCb);
	}

	function makeJbodCb() {
		top.toggleNext(true);
		top.togglePrevious(true);
		var ret = getRcMsg();
		if (ret.rc != "0") {
			$("#raidMsgDiv").html($.i18n.prop("RaidConfig.MakeJbodFail", ret.msg));
			$("#raidStatusDiv img")[0].src = "images/StatusCritical.png";
			$("#progressRaidDiv").hide();
			$("#tableRaidDiv").show();
			$("#buttonRaidDiv").show();
		} else {
			var msg = $.i18n.prop("RaidConfig.MakeJbodSuccess") + " " + $.i18n.prop("RaidConfig.CancelMsg");
			$("#startRetrBtn").show();
			$("#cancelRetrBtn").hide();
			$("#raidStatusDiv img")[0].src = "images/statusSuccess.gif";
			$("#raidMsgDiv").html(msg);
			$("#raidStatusDiv").show();
		}
	}

	function refreshTable(msg) {
		printLog("INFO", "function refreshTable begin.");
		if (msg == "" || msg == null || msg == undefined) {
			msg = $.i18n.prop("RaidConfig.GetRaidShow");
		}
		$("#raidStatusDiv img")[0].src = "images/progress_anim2.gif";
		$("#raidMsgDiv").html(msg);
		$("#raidStatusDiv").show();
		$("#raid_info_table").empty();
		$("#buttonRaidDiv").hide();
		$("#tableRaidDiv").hide();
		$("#cancelRetrBtn").show();
		$("#startRetrBtn").hide();
		disableMakeJbod();
		disableMakeGood();
		disableClearVol();
		disableCreateVol();
		top.togglePrevious(false);
		top.toggleNext(false);
		retrInfo();
		printLog("INFO", "function refreshTable end.");
	}

	function userCancel() {
		printLog("INFO", "button 'Cancel' was clicked.");
		user_cancel = true;
		top.killOneCli();
		// cancelRetr();
	}

	function cancelRetr() {
		$("#raid_info_table").empty();
		$("#buttonRaidDiv").hide();
		$("#tableRaidDiv").hide();
		$("#progressRaidDiv").hide();
		$("#cancelRetrBtn").hide();
		$("#startRetrBtn").show();
		$("#raidMsgDiv").html($.i18n.prop("RaidConfig.CancelMsg"));
		$("#raidStatusDiv img")[0].src = "images/statusInformation.gif";
		$("#raidStatusDiv").show();
		top.togglePrevious(true);
		top.toggleNext(true);
	}

	function toggleRow(id) {
		var toggle_id = id;
		var toggle = document.getElementById(toggle_id);
		var select_id = toggle_id.replace("toggle_", "");
		var table = document.getElementById("raid_info_table");
		var rows = table.rows;
		if (toggle.src.indexOf("mius") != -1) {
			printLog("INFO", "control " + toggle_id + " hidden");
			toggle.src = "./images/treeExpand_plus.gif";
			for (var row_index = 0; row_index < rows.length; row_index++) {
				if (rows[row_index].id == select_id) {
					continue;
				}
				var check_id = select_id.replace("_pooltitle", "").replace("_nonraiddisk", "_idledisk");
				if (rows[row_index].id != select_id && rows[row_index].id.indexOf(check_id) == 0) {
					if (rows[row_index].id.indexOf("pooltitle") != -1) {
						var select_toggle_id = "toggle_" + rows[row_index].id;
						document.getElementById(select_toggle_id).src = "./images/treeExpand_plus.gif";
					}
					if (rows[row_index].id.indexOf("nonraiddisk") != -1) {
						var select_toggle_id = "toggle_" + rows[row_index].id;
						document.getElementById(select_toggle_id).src = "./images/treeExpand_plus.gif";
					}
					rows[row_index].style.display = "none";
					// $("#" + rows[row_index].id).hide();
				}
			}
		} else if (toggle.src.indexOf("plus") != -1) {
			printLog("INFO", "control " + toggle_id + " shown");
			toggle.src = "./images/treeExpand_mius.gif";
			for (var row_index = 0; row_index < rows.length; row_index++) {
				if (rows[row_index].id == select_id) {
					continue;
				}
				var check_id = select_id.replace("_pooltitle", "").replace("_nonraiddisk", "_idledisk");
				if (rows[row_index].id != select_id && rows[row_index].id.indexOf(check_id) == 0) {
					if (rows[row_index].id.indexOf("pooltitle") != -1) {
						var select_toggle_id = "toggle_" + rows[row_index].id;
						document.getElementById(select_toggle_id).src = "./images/treeExpand_mius.gif";
					}
					if (rows[row_index].id.indexOf("nonraiddisk") != -1) {
						var select_toggle_id = "toggle_" + rows[row_index].id;
						document.getElementById(select_toggle_id).src = "./images/treeExpand_mius.gif";
					}
					rows[row_index].style.display = "";
					// $("#" + rows[row_index].id).show();
				}
			}
		}
	}

	function initSelDiskTable() {
		$("#raid_sel_disk_table").empty();
		top.gl_raid_select_disk = {
			spans: [],
			disks: [],
			hot_spares: []
		};
		var temp_span = {};
		temp_span.id = 1;
		temp_span.name = "Span 1";
		temp_span.disks = new Array();

		if ($("#raidlvl	").val() == "10" || $("#raidlvl	").val() == "50" || $("#raidlvl	").val() == "60" || $("#raidlvl	").val() == "00" || $("#raidlvl	").val() == "10T") {
			top.gl_raid_select_disk.spans.push(temp_span);
			refreshSelDiskTable();
		}
	}

	function refreshSelDiskTable() {
		var table = document.getElementById("raid_sel_disk_table");
		$("#raid_sel_disk_table").empty();
		$("#addSpanDiv").hide();
		if (top.gl_raid_select_disk.spans.length > 0) {			
			for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
				if (top.gl_raid_select_disk.spans[i]) {
					var span_id = top.gl_raid_select_disk.spans[i].id;
					var span_name = top.gl_raid_select_disk.spans[i].name;

					var span_row = table.insertRow(-1);
					var span_row_id = "span_" + span_id;
					span_row.id = span_row_id;

					var span_checkbox_cell = span_row.insertCell(-1);
					span_checkbox_cell.style.width = "20px";
					span_checkbox_cell.style.textAlign = "center";

					var lastSpanTag = false;
					if (i + 1 == top.gl_raid_select_disk.spans.length) {
						lastSpanTag = true;
					}
					if (lastSpanTag && span_id != 1) {
						var span_checkbox_id = "checkbox-span_" + span_id;
						span_checkbox_cell.innerHTML = "<input id='" + span_checkbox_id + "' aria-label='true' type='checkbox' name='checkbox_span' onclick='Raid_Config.selectDiskRow(this)'>";
					}

					var span_name_cell = span_row.insertCell(-1);
					span_name_cell.style.width = "20%";
					span_name_cell.style.textAlign = "center";
					span_name_cell.innerText = span_name;
					span_name_cell.title = span_name;
					var span_empty_cell1 = span_row.insertCell(-1);
					span_empty_cell1.style.width = "40%";
					span_empty_cell1.style.textAlign = "center";

					var span_empty_cell2 = span_row.insertCell(-1);
					span_empty_cell2.style.width = "30%";
					span_empty_cell2.style.textAlign = "center";

					for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
						if (top.gl_raid_select_disk.spans[i].disks[j]) {
							var disk_id = top.gl_raid_select_disk.spans[i].disks[j].id;
							var disk_role = top.gl_raid_select_disk.spans[i].disks[j].role;
							var disk_name = top.gl_raid_select_disk.spans[i].disks[j].display_name;
							var disk_cap = top.gl_raid_select_disk.spans[i].disks[j].capacity;

							var sel_disk_row = table.insertRow(-1);
							var sel_disk_row_id = "selDisk_" + disk_id;
							sel_disk_row.id = sel_disk_row_id;

							var sel_checkbox_cell = sel_disk_row.insertCell(-1);
							sel_checkbox_cell.style.width = "20px";
							sel_checkbox_cell.style.textAlign = "center";
							if (lastSpanTag) {
								var sel_checkbox_id = "checkbox-" + sel_disk_row_id;
								sel_checkbox_cell.innerHTML = "<input id='" + sel_checkbox_id + "' aria-label='true' type='checkbox' name='check_sel_disk' onclick='Raid_Config.selectDiskRow(this)'/>";
							}

							var sel_disk_role_cell = sel_disk_row.insertCell(-1);
							sel_disk_role_cell.style.textAlign = "center";
							sel_disk_role_cell.innerText = disk_role;
							sel_disk_role_cell.title = disk_role;

							var sel_disk_name_cell = sel_disk_row.insertCell(-1);
							sel_disk_name_cell.style.width = "40%";
							sel_disk_name_cell.style.textAlign = "center";
							sel_disk_name_cell.innerText = disk_name;
							sel_disk_name_cell.title = disk_name;

							var sel_disk_cap_cell = sel_disk_row.insertCell(-1);
							sel_disk_cap_cell.style.width = "30%";
							sel_disk_cap_cell.style.textAlign = "center";
							sel_disk_cap_cell.innerText = disk_cap;
							sel_disk_cap_cell.title = disk_cap;
						}
					}
				}
			}
		}
		if (top.gl_raid_select_disk.disks.length > 0) {
			for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
				var disk_id = top.gl_raid_select_disk.disks[i].id;
				var disk_role = top.gl_raid_select_disk.disks[i].role;
				var disk_name = top.gl_raid_select_disk.disks[i].display_name;
				var disk_cap = top.gl_raid_select_disk.disks[i].capacity;
				var sel_disk_row = table.insertRow();
				var sel_disk_row_id = "selDisk_" + disk_id;
				sel_disk_row.id = sel_disk_row_id;
				var sel_checkbox_cell = sel_disk_row.insertCell();
				sel_checkbox_cell.style.width = "20px";
				sel_checkbox_cell.style.textAlign = "center";
				sel_checkbox_cell.innerHTML = "<input id='checkbox-selDisk_" + disk_id + "' aria-label='true' type='checkbox' name='check_sel_disk' onclick='Raid_Config.selectDiskRow(this)'/>";
				var sel_disk_role_cell = sel_disk_row.insertCell(-1);
				sel_disk_role_cell.style.width = "20%";
				sel_disk_role_cell.style.textAlign = "center";
				sel_disk_role_cell.innerText = disk_role;
				sel_disk_role_cell.title = disk_role;

				var sel_disk_name_cell = sel_disk_row.insertCell(-1);
				sel_disk_name_cell.style.width = "40%";
				sel_disk_name_cell.style.textAlign = "center";
				sel_disk_name_cell.innerText = disk_name;
				sel_disk_name_cell.title = disk_name;
				var sel_disk_cap_cell = sel_disk_row.insertCell(-1);
				sel_disk_cap_cell.style.width = "30%";
				sel_disk_cap_cell.style.textAlign = "center";
				sel_disk_cap_cell.innerText = disk_cap;
				sel_disk_cap_cell.title = disk_cap;
			}
		}
		if (top.gl_raid_select_disk.hot_spares.length > 0) {
			for (var i = 0; i < top.gl_raid_select_disk.hot_spares.length; i++) {
				if (!top.gl_raid_select_disk.hot_spares[i]) {
					continue;
				}
				var disk_id = top.gl_raid_select_disk.hot_spares[i].id;
				var disk_role = top.gl_raid_select_disk.hot_spares[i].role;
				var disk_name = top.gl_raid_select_disk.hot_spares[i].display_name;
				var disk_cap = top.gl_raid_select_disk.hot_spares[i].capacity;
				var sel_disk_row = table.insertRow();
				var sel_disk_row_id = "selDisk_" + disk_id;
				sel_disk_row.id = sel_disk_row_id;
				var sel_checkbox_cell = sel_disk_row.insertCell();
				sel_checkbox_cell.style.width = "20px";
				sel_checkbox_cell.style.textAlign = "center";
				sel_checkbox_cell.innerHTML = "<input id='checkbox-selDisk_" + disk_id + "' aria-label='true' type='checkbox' name='check_sel_disk' onclick='Raid_Config.selectDiskRow(this)'/>";
				var sel_disk_role_cell = sel_disk_row.insertCell(-1);
				sel_disk_role_cell.style.width = "20%";
				sel_disk_role_cell.style.textAlign = "center";
				sel_disk_role_cell.innerText = disk_role;
				sel_disk_role_cell.title = disk_role;

				var sel_disk_name_cell = sel_disk_row.insertCell(-1);
				sel_disk_name_cell.style.width = "40%";
				sel_disk_name_cell.style.textAlign = "center";
				sel_disk_name_cell.innerText = disk_name;
				sel_disk_name_cell.title = disk_name;
				var sel_disk_cap_cell = sel_disk_row.insertCell(-1);
				sel_disk_cap_cell.style.width = "30%";
				sel_disk_cap_cell.style.textAlign = "center";
				sel_disk_cap_cell.innerText = disk_cap;
				sel_disk_cap_cell.title = disk_cap;
			}
		}
	}

	function startCreateVol() {
		printLog("INFO", "button 'Create Array' was clicked.");
		top.gl_raid_user_create_vol = new Array();
		top.gl_raid_ava_disk = new Array();
		top.gl_raid_select_disk = {
			spans: [],
			disks: [],
			hot_spares: []
		};
		var ctrl_id = top.gl_raid_select.replace("ctrl-", "");

		for (var i = 0; i < top.gl_raid_info_array.ctrls.length; i++) {
			if (top.gl_raid_info_array.ctrls[i].id == ctrl_id) {
				top.gl_raid_ava_disk = top.gl_raid_info_array.ctrls[i].non_raid_disks;
			}
		}

		// there is no available disk in this controller
		if (top.gl_raid_ava_disk.length < 1) {
			alert($.i18n.prop("RaidConfig.NoAvailableDisk"));
			return;
		}

		if (ctrl_id.indexOf("m.2") != -1) {
			$("#CreateM2Modal").modal("show");
			//ctrl RAID strip size option
			var tmp_raid_strip_size_option_m2 = document.getElementById("create_vol_strip_size_m2");
			var support_raid_strip_size_option_m2 = getAppropriateStripeSize(ctrl_id, ["32KB", "64KB", "128KB", "256KB", "512KB", "1MB"].concat());
			tmp_raid_strip_size_option_m2.length = 0;
			for (var i = 0; i < support_raid_strip_size_option_m2.length; ++i) {
				tmp_raid_strip_size_option_m2.options[i] = new Option(support_raid_strip_size_option_m2[i]);
			}
			stripeSizeChangeSetForM2(true);
			return;
		} else {
			var raid_lvl = document.getElementById("raidlvl");
			raid_lvl.options.length = 0;
			var support_level = top.gl_raid_select_supportlevel[ctrl_id];
			for (var i = 0; i < support_level.length; ++i) {
				//printLog("INFO", "---- "+support_level[i]+":"+support_level[i].substring(4));
				raid_lvl.options[i] = new Option(support_level[i], support_level[i].substring(4));
			}

			switch(raid_lvl.options[0].text)
			{
				case "RAID0":
					$("#raidlvl").val("0");
					break;
				case "RAID1":
					$("#raidlvl").val("1");
					break;
				case "RAID5":
					$("#raidlvl").val("5");
					break;
				case "RAID6":
					$("#raidlvl").val("6");
					break;
				case "RAID10":
					$("#raidlvl").val("10");
					break;
				case "RAID50":
					$("#raidlvl").val("50");
					break;
				case "RAID60":
					$("#raidlvl").val("60");
					break;
				case "RAID00":
					$("#raidlvl").val("00");
					break;
				case "RAID1T":
					$("#raidlvl").val("1T");
					break;
				case "RAID10T":
					$("#raidlvl").val("10T");
					break;
				default:
					$("#raidlvl").val("0");
					break;
			}
			$("#addSpanDiv").hide();
			changeSelect(document.getElementById("raidlvl"));


			$("#CreateVolumeModal").modal("show");
			$("#step-1").show();
			$("#step-2").hide();
			$("#step-3").hide();
			$("#formStep1Title").addClass("btn-primary");
			$("#formStep1Title").removeClass("btn-default");
			$("#formStep2Title").addClass("btn-default");
			$("#formStep2Title").removeClass("btn-primary");
			$("#formStep3Title").addClass("btn-default");
			$("#formStep3Title").removeClass("btn-primary");
			initAvaDiskTable();
			initSelDiskTable();
		}
	}

	/*********Johnny20181031*********/
	function initAvaDiskTable() {
		// top.gl_raid_ava_dyn_disk = top.gl_raid_ava_disk;
		top.gl_raid_ava_dyn_disk = new Array();
		for (var i = 0; i < top.gl_raid_ava_disk.length; i++) {
			if (!top.gl_raid_ava_disk[i]) {
				continue;
			}
			top.gl_raid_ava_dyn_disk.push(top.gl_raid_ava_disk[i]);
		}
		var table = document.getElementById("raid_ava_disk_table");
		$("#raid_ava_disk_table").empty();
		for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
			if (!top.gl_raid_ava_dyn_disk[i]) {
				continue;
			}
			var disk_id = top.gl_raid_ava_dyn_disk[i].id;
			var disk_name = "Drive " + disk_id;
			var disk_cap = top.gl_raid_ava_dyn_disk[i].capacity;
			var disk_detail = top.gl_raid_ava_dyn_disk[i].detail;
			var ava_disk_row = table.insertRow(-1);
			var ava_disk_row_id = "avaDisk_" + disk_id;
			ava_disk_row.id = ava_disk_row_id;
			var ava_disk_check_cell = ava_disk_row.insertCell(-1);
			ava_disk_check_cell.style.width = "20px";
			ava_disk_check_cell.style.textAlign = "center";
			ava_disk_check_cell.innerHTML = "<input id='checkbox-avaDisk_" + disk_id + "' aria-label='true' type='checkbox' name='check_ava_disk' onclick='Raid_Config.selectDiskRow(this)'/>";
			var ava_disk_name_cell = ava_disk_row.insertCell(-1);
			ava_disk_name_cell.style.width = "40%";
			ava_disk_name_cell.style.textAlign = "center";
			ava_disk_name_cell.innerText = disk_name;
			ava_disk_name_cell.title = disk_name;
			var ava_disk_type_cell = ava_disk_row.insertCell(-1);
			ava_disk_type_cell.style.width = "20%";
			ava_disk_type_cell.style.textAlign = "center";
			ava_disk_type_cell.innerText = disk_detail;
			ava_disk_type_cell.title = disk_detail;
			var ava_disk_cap_cell = ava_disk_row.insertCell(-1);
			ava_disk_cap_cell.style.width = "30%";
			ava_disk_cap_cell.style.textAlign = "center";
			ava_disk_cap_cell.innerText = disk_cap;
			ava_disk_cap_cell.title = disk_cap;
		}
	}

	function refreshAvaDiskTable() {
		var table = document.getElementById("raid_ava_disk_table");
		$("#raid_ava_disk_table").empty();
		for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
			var disk_id = top.gl_raid_ava_dyn_disk[i].id;
			var disk_name = "Drive " + disk_id;
			var disk_cap = top.gl_raid_ava_dyn_disk[i].capacity;
			var disk_detail = top.gl_raid_ava_dyn_disk[i].detail;
			var ava_disk_row = table.insertRow(-1);
			var ava_disk_row_id = "avaDisk_" + disk_id;
			ava_disk_row.id = ava_disk_row_id;
			var ava_disk_check_cell = ava_disk_row.insertCell(-1);
			ava_disk_check_cell.style.width = "20px";
			ava_disk_check_cell.style.textAlign = "center";
			ava_disk_check_cell.innerHTML = "<input id='checkbox-avaDisk_" + disk_id + "' aria-label='true' type='checkbox' name='check_sel_disk' onclick='Raid_Config.selectDiskRow(this)'/>";
			var ava_disk_name_cell = ava_disk_row.insertCell(-1);
			ava_disk_name_cell.style.width = "40%";
			ava_disk_name_cell.style.textAlign = "center";
			ava_disk_name_cell.innerText = disk_name;
			ava_disk_name_cell.title = disk_name;
			var ava_disk_type_cell = ava_disk_row.insertCell(-1);
			ava_disk_type_cell.style.width = "20%";
			ava_disk_type_cell.style.textAlign = "center";
			ava_disk_type_cell.innerText = disk_detail;
			ava_disk_type_cell.title = disk_detail;
			var ava_disk_cap_cell = ava_disk_row.insertCell(-1);
			ava_disk_cap_cell.style.width = "30%";
			ava_disk_cap_cell.style.textAlign = "center";
			ava_disk_cap_cell.innerText = disk_cap;
			ava_disk_cap_cell.title = disk_cap;

		}
	}

	function addMember() {
		printLog("INFO", "button 'Add member ->' was clicked.");
		var temp_disk_arr = new Array();
		var select_count = 0;
		$("#raid_ava_disk_table input").each(function () {
			if (this.checked) {
				select_count++;
			}
		});
		if (select_count < 1) {
			alert($.i18n.prop("RaidConfig.SelLeastOneDiskFromLeft"));
			return;
		}
		$("#raid_ava_disk_table input").each(function () {
			if (this.checked) {
				var disk_id = this.id.replace("checkbox-avaDisk_", "");
				for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
					if (!top.gl_raid_ava_dyn_disk[i]) {
						continue;
					}
					if (disk_id == top.gl_raid_ava_dyn_disk[i].id) {
						var temp_disk = {};
						temp_disk.id = top.gl_raid_ava_dyn_disk[i].id;
						temp_disk.role = "Member";
						temp_disk.display_name = "Drive " + temp_disk.id;
						temp_disk.name = top.gl_raid_ava_dyn_disk[i].name;
						temp_disk.capacity = top.gl_raid_ava_dyn_disk[i].capacity;
						temp_disk.state = top.gl_raid_ava_dyn_disk[i].state;
						temp_disk.detail = top.gl_raid_ava_dyn_disk[i].detail;
						top.gl_raid_select_disk.disks.push(temp_disk);

						delete top.gl_raid_ava_dyn_disk[i];
					}
				}

			}
		});
		for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
			if (top.gl_raid_ava_dyn_disk[i] != undefined && top.gl_raid_ava_dyn_disk[i] != null) {
				temp_disk_arr.push(top.gl_raid_ava_dyn_disk[i]);
			}
		}
		top.gl_raid_ava_dyn_disk = temp_disk_arr;
		refreshAvaDiskTable();
		refreshSelDiskTable();
		toggleAddSpanDivShow();
	}

	function changeSelect(_select) {
		top.gl_raid_lvl = _select.value;
		printLog('INFO', 'Select RAID Level: RAID ' + _select.value);
		// _select.value = [0, 1, 5, 6, 10, 50, 60, 00];

		var raidlvlTips = {
			"0"		:$.i18n.prop("RaidConfig.Raid0Tip"),
			"1"		:$.i18n.prop("RaidConfig.Raid1Tip"),
			"5"		:$.i18n.prop("RaidConfig.Raid5Tip"),
			"6"		:$.i18n.prop("RaidConfig.Raid6Tip"),
			"10"	:$.i18n.prop("RaidConfig.Raid10Tip"),
			"50"	:$.i18n.prop("RaidConfig.Raid5060Tip"),
			"60"	:$.i18n.prop("RaidConfig.Raid5060Tip"),
			"00"	:$.i18n.prop("RaidConfig.Raid00Tip"),
			"1T"	:$.i18n.prop("RaidConfig.Raid1TTip"),
			"10T"	:$.i18n.prop("RaidConfig.Raid10TTip")
		}
		var _changeText = document.getElementById("changeText");
		_changeText.removeChild(_changeText.childNodes[0]);
		_changeText.appendChild(document.createTextNode(raidlvlTips[_select.value]));

		if (_select.value == "0") {
			$("#add_mem_btn").show();
			$("#add_span_btn").hide();
			$("#add_hotspare_btn").hide();
			$("#remove_disk_btn").show();
		} else if (_select.value == "00") {
			$("#add_span_btn").show();
			$("#add_mem_btn").hide();
			$("#add_hotspare_btn").hide();
			$("#remove_disk_btn").show();
		} else if (_select.value == "1" || _select.value == "5" || _select.value == "6" || _select.value == "1T" || _select.value == "10T") {
			$("#add_mem_btn").show();
			$("#add_span_btn").hide();
			showGPHotSpareBtn();
			$("#remove_disk_btn").show();
		} else if (_select.value == "10" || _select.value == "50" || _select.value == "60") {
			$("#add_span_btn").show();
			$("#add_mem_btn").hide();
			showGPHotSpareBtn();
			$("#remove_disk_btn").show();
		} 
		setAddToSpanText(1);
		initAvaDiskTable();
		initSelDiskTable();
	}

	function showGPHotSpareBtn(){
		if (!top.isCFC(top.gl_mt_list[0])) {
			$("#add_hotspare_btn").show();
		}
	}

	function setAddToSpanText(span_num) {
		// $("#add_span_btn").html("Add to Span " + span_num + " ->");
		$("#span_num").html(span_num);
	}

	//insert a span row to selected disk drives
	function addToSpan(_btn) {
		printLog("INFO", "button 'Add to Span1 ->' was clicked.");
		/*var span_id = $("#add_span_btn").html();
		span_id = span_id.replace("Add to Span ", "");
		span_id = span_id.replace(" ->", "");
		span_id = span_id.replace(" -&gt;", "");*/
		var span_id = $("#span_num").html();
		var temp_disk_arr = new Array();
		var select_count = 0;
		$("#raid_ava_disk_table input").each(function () {
			if (this.checked) {
				select_count++;
			}
		});
		if (select_count < 1) {
			alert($.i18n.prop("RaidConfig.SelLeastOneDiskFromLeft"));
			return;
		}
		$("#raid_ava_disk_table input").each(function () {
			if (this.checked) {
				var disk_id = this.id.replace("checkbox-avaDisk_", "");
				for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
					if (!top.gl_raid_ava_dyn_disk[i]) {
						continue;
					}
					if (disk_id == top.gl_raid_ava_dyn_disk[i].id) {
						var temp_disk = {};
						temp_disk.id = top.gl_raid_ava_dyn_disk[i].id;
						temp_disk.role = "Member";
						temp_disk.display_name = "Drive " + temp_disk.id;
						temp_disk.name = top.gl_raid_ava_dyn_disk[i].name;
						temp_disk.capacity = top.gl_raid_ava_dyn_disk[i].capacity;
						temp_disk.state = top.gl_raid_ava_dyn_disk[i].state;
						temp_disk.detail = top.gl_raid_ava_dyn_disk[i].detail;

						for (var j = 0; j < top.gl_raid_select_disk.spans.length; j++) {
							if (top.gl_raid_select_disk.spans[j]) {
								if (top.gl_raid_select_disk.spans[j].id == span_id) {
									if (top.gl_raid_select_disk.spans[j].disks) {
										top.gl_raid_select_disk.spans[j].disks.push(temp_disk);
									}
								}
							}
						}
						delete top.gl_raid_ava_dyn_disk[i];
					}
				}

			}
		});
		for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
			if (top.gl_raid_ava_dyn_disk[i] != undefined && top.gl_raid_ava_dyn_disk[i] != null) {
				temp_disk_arr.push(top.gl_raid_ava_dyn_disk[i]);
			}
		}
		top.gl_raid_ava_dyn_disk = temp_disk_arr;
		refreshAvaDiskTable();
		refreshSelDiskTable();
		toggleAddSpanDivShow();
	}

	//reset modal when close it
	function dismissModal() {

		$("#CreateVolumeModal").modal("hide");
		$("#createVolForm").hide();
		$("#CreateM2Modal").modal("hide");
		$("#m2ErrorMsgExecText").html();
		$("#vol_name_check_m2").hide();
		$("#create_vol_name_m2").val("");
		$("#raidlvl_m2").prop("selectedIndex", 0);
		$("#create_vol_strip_size_m2").prop("selectedIndex", 0);
		// top.gl_raid_user_create_vol = new Array();
		/*top.gl_raid_select_disk = {
			spans: [],
			disks: [],
			hot_spares: []
		};*/
	}

	function cancelModal() {
		stripeSizeChangeSetForM2(false)
		warnMessageShowForM2(false);
		printLog("INFO", "button 'Cancel' was clicked.");
		if (confirm($.i18n.prop("RaidConfig.CancelCreateConfirm"))) {
			printLog("INFO", "button 'Yes' was clicked.");
			dismissModal();
		} else {
			printLog("INFO", "button 'No' was clicked.");
			return;
		}
	}

	function addHotSpare() {
		printLog("INFO", "button 'Add hot spare ->' was clicked.");
		var temp_disk_arr = new Array();
		var select_count = 0;
		$("#raid_ava_disk_table input").each(function () {
			if (this.checked) {
				select_count++;
			}
		});
		if (select_count < 1) {
			alert($.i18n.prop("RaidConfig.SelLeastOneDiskFromLeft"));
			return;
		}
		$("#raid_ava_disk_table input").each(function () {
			if (this.checked) {
				var disk_id = this.id.replace("checkbox-avaDisk_", "");
				for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
					if (!top.gl_raid_ava_dyn_disk[i]) {
						continue;
					}
					if (disk_id == top.gl_raid_ava_dyn_disk[i].id) {
						var temp_disk = {};
						temp_disk.id = top.gl_raid_ava_dyn_disk[i].id;
						temp_disk.role = "Hotspare";
						temp_disk.name = top.gl_raid_ava_dyn_disk[i].name;
						temp_disk.display_name = "Drive " + temp_disk.id;
						temp_disk.capacity = top.gl_raid_ava_dyn_disk[i].capacity;
						temp_disk.state = top.gl_raid_ava_dyn_disk[i].state;
						temp_disk.detail = top.gl_raid_ava_dyn_disk[i].detail;
						top.gl_raid_select_disk.hot_spares.push(temp_disk);

						delete top.gl_raid_ava_dyn_disk[i];
					}
				}

			}
		});
		for (var i = 0; i < top.gl_raid_ava_dyn_disk.length; i++) {
			if (top.gl_raid_ava_dyn_disk[i] != undefined && top.gl_raid_ava_dyn_disk[i] != null) {
				temp_disk_arr.push(top.gl_raid_ava_dyn_disk[i]);
			}
		}
		top.gl_raid_ava_dyn_disk = temp_disk_arr;
		refreshAvaDiskTable();
		refreshSelDiskTable();
		toggleAddSpanDivShow();
	}

	function removeDisk() {
		printLog("INFO", "button '<- Remove' was clicked.");
		var temp_disk_obj = {
			spans: [],
			disks: [],
			hot_spares: []
		};
		// var temp_spans = new Array();
		var select_count = 0;
		$("#raid_sel_disk_table input").each(function () {
			if (this.checked) {
				select_count++;
			}
		});
		if (select_count < 1) {
			alert($.i18n.prop("RaidConfig.SelLeastOneDiskFromRight"));
			return;
		}
		$("#raid_sel_disk_table input").each(function () {
			if (this.checked) {
				var row_id = this.id.replace("checkbox-", "");
				var span_id = "";
				if (row_id.indexOf("span") != -1) {
					span_id = row_id.replace("span_", "");
					for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
						if (!top.gl_raid_select_disk.spans[i]) {
							continue;
						}
						if (top.gl_raid_select_disk.spans[i].id == span_id) {
							for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
								if (!top.gl_raid_select_disk.spans[i].disks[j]) {
									continue;
								}
								var temp_disk = {};
								temp_disk.id = top.gl_raid_select_disk.spans[i].disks[j].id;
								temp_disk.name = top.gl_raid_select_disk.spans[i].disks[j].name;
								temp_disk.capacity = top.gl_raid_select_disk.spans[i].disks[j].capacity;
								temp_disk.state = top.gl_raid_select_disk.spans[i].disks[j].state;
								temp_disk.detail = top.gl_raid_select_disk.spans[i].disks[j].detail;
								top.gl_raid_ava_dyn_disk.push(temp_disk);
							}
							delete top.gl_raid_select_disk.spans[i];
						}
					}
				}

				var disk_id = ""
				if (row_id.indexOf("selDisk") != -1) {
					disk_id = row_id.replace("selDisk_", "");
					for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
						if (!top.gl_raid_select_disk.spans[i]) {
							continue;
						}
						for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
							if (!top.gl_raid_select_disk.spans[i].disks[j]) {
								continue;
							}
							if (top.gl_raid_select_disk.spans[i].disks[j].id == disk_id) {
								var temp_disk = {};
								temp_disk.id = top.gl_raid_select_disk.spans[i].disks[j].id;
								temp_disk.name = top.gl_raid_select_disk.spans[i].disks[j].name;
								temp_disk.capacity = top.gl_raid_select_disk.spans[i].disks[j].capacity;
								temp_disk.state = top.gl_raid_select_disk.spans[i].disks[j].state;
								temp_disk.detail = top.gl_raid_select_disk.spans[i].disks[j].detail;
								top.gl_raid_ava_dyn_disk.push(temp_disk);

								delete top.gl_raid_select_disk.spans[i].disks[j];
							}
						}
					}

					for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
						if (!top.gl_raid_select_disk.disks[i]) {
							continue;
						}
						if (disk_id == top.gl_raid_select_disk.disks[i].id) {
							var temp_disk = {};
							temp_disk.id = top.gl_raid_select_disk.disks[i].id;
							temp_disk.name = top.gl_raid_select_disk.disks[i].name;
							temp_disk.capacity = top.gl_raid_select_disk.disks[i].capacity;
							temp_disk.state = top.gl_raid_select_disk.disks[i].state;
							temp_disk.detail = top.gl_raid_select_disk.disks[i].detail;
							top.gl_raid_ava_dyn_disk.push(temp_disk);

							delete top.gl_raid_select_disk.disks[i];
						}
					}
					for (var i = 0; i < top.gl_raid_select_disk.hot_spares.length; i++) {
						if (!top.gl_raid_select_disk.hot_spares[i]) {
							continue;
						}
						if (disk_id == top.gl_raid_select_disk.hot_spares[i].id) {
							var temp_disk = {};
							temp_disk.id = top.gl_raid_select_disk.hot_spares[i].id;
							temp_disk.name = top.gl_raid_select_disk.hot_spares[i].name;
							temp_disk.capacity = top.gl_raid_select_disk.hot_spares[i].capacity;
							temp_disk.state = top.gl_raid_select_disk.hot_spares[i].state;
							temp_disk.detail = top.gl_raid_select_disk.hot_spares[i].detail;
							top.gl_raid_ava_dyn_disk.push(temp_disk);

							delete top.gl_raid_select_disk.hot_spares[i];
						}
					}
				}

			}
		});
		for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
			if (top.gl_raid_select_disk.spans[i] != undefined && top.gl_raid_select_disk.spans[i] != null) {
				var temp_span = {};
				temp_span.id = top.gl_raid_select_disk.spans[i].id;
				temp_span.name = top.gl_raid_select_disk.spans[i].name;
				temp_span.disks = new Array();
				for (var j = 0; j < top.gl_raid_select_disk.spans[i].disks.length; j++) {
					if (!top.gl_raid_select_disk.spans[i].disks[j]) {
						continue;
					}
					temp_span.disks.push(top.gl_raid_select_disk.spans[i].disks[j]);
				}
				temp_disk_obj.spans.push(temp_span);
			}
		}
		for (var i = 0; i < top.gl_raid_select_disk.disks.length; i++) {
			if (top.gl_raid_select_disk.disks[i] != undefined && top.gl_raid_select_disk.disks[i] != null) {
				temp_disk_obj.disks.push(top.gl_raid_select_disk.disks[i]);
			}
		}
		for (var i = 0; i < top.gl_raid_select_disk.hot_spares.length; i++) {
			if (top.gl_raid_select_disk.hot_spares[i] != undefined && top.gl_raid_select_disk.hot_spares[i] != null) {
				temp_disk_obj.hot_spares.push(top.gl_raid_select_disk.hot_spares[i]);
			}
		}
		top.gl_raid_select_disk = temp_disk_obj;
		refreshAvaDiskTable();
		refreshSelDiskTable();
		toggleAddSpanDivShow();

		var span_count = top.gl_raid_select_disk.spans.length;
		setAddToSpanText(span_count);
	}

	function selectDiskRow(element) {
		var row_id = element.id.replace("checkbox-", "");
		if (element.checked) {
			printLog("INFO", "checkbox '" + element.id + "' checked.");
			$("#" + row_id).addClass("RowSelected");
		} else {
			printLog("INFO", "checkbox '" + element.id + "' unchecked.");
			$("#" + row_id).removeClass("RowSelected");
		}
	}

	function startCreateStorage() {
		printLog("INFO", "button 'Create' was clicked.");
		if (!confirm($.i18n.prop("RaidConfig.CreateConfig"))) {
			return false;
		}
		var msg = $.i18n.prop("RaidConfig.ApplyRaidConfig");
		$("#raidStatusDiv").show();
		$("#raidStatusDiv img")[0].src = "images/progress_anim2.gif";
		$("#raidMsgDiv").html(msg);
		top.toggleNext(false);
		top.togglePrevious(false);
		$("#buttonRaidDiv").hide();
		$("#tableRaidDiv").hide();

		writeIniFile();
		dismissModal();

		raidShowPath = top.getSupportFile("raidShowResult");
		raidResultPath = top.getSupportFile("raidResult");
		if (top.fileExists(raidShowPath)) {
			top.deleteFile(raidShowPath);
		}
		if (top.fileExists(raidResultPath)) {
			top.deleteFile(raidResultPath);
		}

		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("misc");
		args.push("raid");
		args.push("add");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		// args.push("--target");
		// args.push(top.gl_raid_select.replace("ctrl-", ""));
		args.push("--ctrl");
		args.push(top.gl_raid_select.replace("ctrl-", "").replace("m.2-", ""));
		args.push("--file");
		args.push(top.gl_raid_ini_path);
		args.push("--force");
		args.push(...add_output_log5());
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, createStorCb);
	}

	function createStorCb() {
		var ret = getRcMsg();
		if (ret.rc == "0") {
			var msg = $.i18n.prop("RaidConfig.CreateStorSucc");
			$("#raidStatusDiv img")[0].src = "images/statusSuccess.gif";
			$("#raidMsgDiv").html(msg);
			$("#raidStatusDiv").show();
			$("#startRetrBtn").show();
		} else {
			var msg = $.i18n.prop("RaidConfig.CreateStorFail", ret.msg);
			$("#raidStatusDiv img")[0].src = "images/StatusCritical.gif";
			$("#raidMsgDiv").html(msg);
			$("#raidStatusDiv").show();
			$("#tableRaidDiv").show();
			$("#buttonRaidDiv").show();
		}
		top.togglePrevious(true);
		top.toggleNext(true);
	}

	function addSpan() {
		var span_id = top.gl_raid_select_disk.spans.length + 1;
		// $("#add_span_btn").html("Add to Span " + span_id + " ->");
		$("#span_num").html(span_id);
		var temp_span = {};
		temp_span.id = span_id;
		temp_span.name = "Span " + span_id;
		temp_span.disks = new Array();
		top.gl_raid_select_disk.spans.push(temp_span);
		refreshSelDiskTable();
		toggleAddSpanDivShow();
	}

	function toggleAddSpanDivShow(){
		if ($("#raidlvl").val() == "10" || $("#raidlvl").val() == "50" || $("#raidlvl").val() == "60" || $("#raidlvl").val() == "00" || $("#raidlvl").val() == "10T") {
			toggleAddSpanDiv();
		}
	}

	function toggleAddSpanDiv() {
		if (showAddSpan()) {
			$("#addSpanDiv").show();
		} else {
			$("#addSpanDiv").hide();
		}
	}

	function showAddSpan() {
		if ($("#raidlvl").val() == "0" || $("#raidlvl").val() == "1" || $("#raidlvl").val() == "5" || $("#raidlvl").val() == "6") {
			return false;
		} else if ($("#raidlvl").val() == "10") {
			// for raid 10, 2 ~ 3 spans required, a minimum of 2 drive(s) for each span
			if (top.gl_raid_select_disk.spans.length > 3) {
				return false;
			}
			for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
				if (top.gl_raid_select_disk.spans[i].id == top.gl_raid_select_disk.spans.length) {
					if (top.gl_raid_select_disk.spans[i].disks.length < 2) {
						return false;
					}
				}
			}
		} else if ($("#raidlvl").val() == "50" || $("#raidlvl").val() == "60") {
			// for raid 50 and 60, 2 spans required, a minimum of 3 drive(s) for each span
			for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
				if (top.gl_raid_select_disk.spans[i].id == top.gl_raid_select_disk.spans.length) {
					if (top.gl_raid_select_disk.spans[i].disks.length < 3) {
						return false;
					}
				}
			}
		} else if ($("#raidlvl").val() == "00") {
			// for raid 00, 2 ~ 7 spans required, a minimum of 1 drive(s) for each span
			if (top.gl_raid_select_disk.spans.length > 7) {
				return false;
			}
			for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
				if (top.gl_raid_select_disk.spans[i].id == top.gl_raid_select_disk.spans.length) {
					if (top.gl_raid_select_disk.spans[i].disks.length < 1) {
						return false;
					}
				}
			}
		} else if ($("#raidlvl").val() == "10T") {
			// for raid 10T, 2 spans required, a minimum of 6 drive(s) for each span
			for (var i = 0; i < top.gl_raid_select_disk.spans.length; i++) {
				if (top.gl_raid_select_disk.spans[i].id == top.gl_raid_select_disk.spans.length) {
					if (top.gl_raid_select_disk.spans[i].disks.length < 6) {
						return false;
					}
				}
			}
		} 

		return true;
	}

	function writeIniFile() {
		top.gl_raid_ini_path = top.getSupportFile("raidConfig");
		if (top.fileExists(top.gl_raid_ini_path)) {
			top.deleteFile(top.gl_raid_ini_path);
		}
		var fileContent = "";
		var ctrl_id = top.gl_raid_select.replace("ctrl-", "");

		var raid_lvl = $("#raidlvl").val();
		for (var i = 0; i < top.gl_raid_user_create_vol.length; i++) {
			if (top.gl_raid_user_create_vol[i]) {
				var ctrl_line = "[ctrl" + ctrl_id + "-vol" + i + "]" + "\n";

				var disk_line = "disks=";
				for (var j = 0; j < top.gl_raid_select_disk.spans.length; j++) {
					if (top.gl_raid_select_disk.spans[j]) {
						if (j != 0) {
							disk_line += ":";
						}
						for (var k = 0; k < top.gl_raid_select_disk.spans[j].disks.length; k++) {
							if (top.gl_raid_select_disk.spans[j].disks[k]) {
								if (k != 0) {
									disk_line += ",";
								}
								var disk_id = top.gl_raid_select_disk.spans[j].disks[k].id;
								disk_line += disk_id;
							}
						}
					}
				}
				for (var j = 0; j < top.gl_raid_select_disk.disks.length; j++) {
					if (top.gl_raid_select_disk.disks[j]) {
						if (j != 0) {
							disk_line += ",";
						}
						disk_line += top.gl_raid_select_disk.disks[j].id;
					}
				}
				disk_line += "\n";

				var raidlvl_line = "raid_level=";
				raidlvl_line += codeRaidLvl(raid_lvl) + "\n";

				var name_line = "vol_name=";
				name_line += top.gl_raid_user_create_vol[i].name + "\n";

				var strip_size_line = "strip_size=";
				var strip_size = top.gl_raid_user_create_vol[i].strip_size;
				strip_size = codeStripSize(strip_size);
				strip_size_line += strip_size + "\n";

				if (top.isCFC(top.gl_mt_list[0])) {

					var size_line = "volume_size=";
					var volume_size = top.gl_raid_user_create_vol[i].capacity;
					volume_size += "GB";
					size_line += volume_size + "\n";

					if (top.gl_raid_select_type.toLowerCase() == "oobcfclsi") {
						var write_policy_line = "write_policy=";
						var write_policy = top.gl_raid_user_create_vol[i].write_policy;
						write_policy = codeWritePolicy(write_policy);
						write_policy_line += write_policy + "\n";

						var read_policy_line = "read_policy=";
						var read_policy = top.gl_raid_user_create_vol[i].read_policy;
						read_policy = codeReadPolicyCFC(read_policy);
						read_policy_line += read_policy + "\n";

						var access_policy_line = "access_policy=";
						var access_policy = top.gl_raid_user_create_vol[i].acc_policy;
						access_policy = codeAccPolicy(access_policy);
						access_policy_line += access_policy + "\n";

						var cache_policy_line = "cache_policy=";
						var cache_policy = top.gl_raid_user_create_vol[i].drive_cache;
						cache_policy = codeCachePolicy(cache_policy);
						cache_policy_line += cache_policy + "\n";

						var init_line = "initialization=";
						var init_val = top.gl_raid_user_create_vol[i].init;
						init_val = codeInit(init_val);
						init_line += init_val + "\n";

						fileContent = fileContent + ctrl_line + disk_line + raidlvl_line + name_line + write_policy_line + read_policy_line + access_policy_line + cache_policy_line + size_line + strip_size_line + init_line + "\n";
					} else {
						fileContent = fileContent + ctrl_line + disk_line + raidlvl_line + name_line + size_line + strip_size_line + "\n";
					}
				} else {

					var hot_spare_line = "hot_spares=";
					for (var j = 0; j < top.gl_raid_select_disk.hot_spares.length; j++) {
						if (top.gl_raid_select_disk.hot_spares[j]) {
							if (j != 0) {
								hot_spare_line += ",";
							}
							hot_spare_line += top.gl_raid_select_disk.hot_spares[j].id;
						}
					}
					hot_spare_line += "\n";

					if (top.gl_raid_select_type.toLowerCase() == "oobvroc") {
						var volume_size_str = "volume_size=" + parseFloat(top.gl_raid_user_create_vol[i].capacity) + "GB" + "\n";
						fileContent = fileContent + ctrl_line + disk_line + hot_spare_line + raidlvl_line + name_line + volume_size_str + strip_size_line + "\n";

					} else if (top.gl_raid_select_type.toLowerCase() == "oobmicrochip") {

						var write_policy_line = "write_policy=";
						var write_policy = top.gl_raid_user_create_vol[i].write_policy;
						write_policy = codeWritePolicy(write_policy);
						write_policy_line += write_policy + "\n";

						var read_policy_line = "read_policy=";
						var read_policy = top.gl_raid_user_create_vol[i].read_policy;
						read_policy = codeReadPolicy(read_policy);
						read_policy_line += read_policy + "\n";

						var volume_size_str = "volume_size=" + parseFloat(top.gl_raid_user_create_vol[i].capacity) + "GB" + "\n";

						fileContent = fileContent + ctrl_line + disk_line + hot_spare_line + raidlvl_line + name_line + volume_size_str + strip_size_line + write_policy_line + read_policy_line + "\n";

					} else {

						var write_policy_line = "write_policy=";
						var write_policy = top.gl_raid_user_create_vol[i].write_policy;
						write_policy = codeWritePolicy(write_policy);
						write_policy_line += write_policy + "\n";

						var read_policy_line = "read_policy=";
						var read_policy = top.gl_raid_user_create_vol[i].read_policy;
						read_policy = codeReadPolicy(read_policy);
						read_policy_line += read_policy + "\n";

						var io_policy_line = "io_policy=";
						var io_policy = top.gl_raid_user_create_vol[i].io_policy;
						io_policy = codeIoPolicy(io_policy);
						io_policy_line += io_policy + "\n";

						var access_policy_line = "access_policy=";
						var access_policy = top.gl_raid_user_create_vol[i].acc_policy;
						access_policy = codeAccPolicy(access_policy);
						access_policy_line += access_policy + "\n";

						var cache_policy_line = "cache_policy=";
						var cache_policy = top.gl_raid_user_create_vol[i].drive_cache;
						cache_policy = codeCachePolicy(cache_policy);
						cache_policy_line += cache_policy + "\n";

						var size_line = "volume_size=";
						var volume_size = top.gl_raid_user_create_vol[i].capacity;
						if (volume_size == top.gl_totalAvaDiskCap) {
							volume_size = "100%";
						} else {
							volume_size = volume_size / top.gl_totalAvaDiskCap;
							volume_size = parseFloat(volume_size) * 100;
							volume_size = parseFloat(volume_size).toFixed(2);
							volume_size = volume_size + "%";
						}
						size_line += volume_size + "\n";

						var init_line = "initialization=";
						var init_val = top.gl_raid_user_create_vol[i].init;
						init_val = codeInit(init_val);
						init_line += init_val + "\n";

						fileContent = fileContent + ctrl_line + disk_line + hot_spare_line + raidlvl_line + name_line + write_policy_line + read_policy_line + io_policy_line + access_policy_line + cache_policy_line + size_line + strip_size_line + init_line + "\n";
					}
				}
			}
		}
		top.writeTextFile(top.gl_raid_ini_path, fileContent);
	}

	function codeRaidLvl(raidlvl){
		if(raidlvl.toUpperCase() == "1T"){
			return "1triple";
		} else if(raidlvl.toUpperCase() == "10T"){
			return "10triple";
		} else if(raidlvl.toUpperCase() == "1E"){
			return "1E";
		} else{
			return raidlvl;
		}
	}

	function codeCachePolicy(value) {
		if (value.toLowerCase().indexOf("unchanged") != -1) {
			return "0";
		} else if (value.toLowerCase().indexOf("enable") != -1) {
			return "1";
		} else if (value.toLowerCase().indexOf("disable") != -1) {
			return "2";
		}
	}

	function codeInit(value) {
		if (value.toLowerCase().indexOf("no") != -1) {                //gp & cfc use
			return "0";
		} else if (value.toLowerCase().indexOf("fast") != -1) {       //gp & cfc use
			return "1";
		} else if (value.toLowerCase().indexOf("full") != -1) {       //only cfc use
			return "2";
		}
	}

	function codeStripSize(value) {
		if (value.toLowerCase() == "4kb") {
			return "4K";
		} else if (value.toLowerCase() == "8kb") {
			return "8K";
		} else if (value.toLowerCase() == "16kb") {
			return "16K";
		} else if (value.toLowerCase() == "32kb") {
			return "32K";
		} else if (value.toLowerCase() == "64kb") {
			return "64K";
		} else if (value.toLowerCase() == "128kb") {
			return "128K";
		} else if (value.toLowerCase() == "256kb") {
			return "256K";
		} else if (value.toLowerCase() == "512kb") {
			return "512K";
		} else if (value.toLowerCase() == "1mb") {
			return "1024K";
		}
	}

	function codeAccPolicy(value) {
		if (value.toLowerCase().indexOf("read write") != -1) {
			return "0";
		} else if (value.toLowerCase().indexOf("read only") != -1) {
			return "2";
		} else if (value.toLowerCase().indexOf("blocked") != -1) {
			return "3";
		}
	}

	function codeIoPolicy(value) {
		if (value.toLowerCase().indexOf("direct") != -1) {
			return "0";
		} else if (value.toLowerCase().indexOf("cached") != -1) {
			return "1";
		}
	}

	function codeWritePolicy(value) {
		if (value.toLowerCase() == "write through") { 
			return "0";
		} else if (value.toLowerCase() == "always write back") {                 //gp&cfc use
			return "1";
		} else if (value.toLowerCase() == "unprotected write back") {            //only cfc use
			return "1";
		} else if (value.toLowerCase() == "write back with bbu") {
			return "2";
		} else if (value.toLowerCase() == "write back") {
			return "2";          
		} else if (value.toLowerCase() == "off") {
			return "3";                 
		}

		/*20220809:GP microChip use write back/always write back/off */
	}

	function codeReadPolicy(value) {
		if (value.toLowerCase() == "no read ahead") {
			return "0";
		} else if (value.toLowerCase() == "adaptive read ahead") {
			return "2";
		} else if (value.toLowerCase() == "read ahead") {
			return "1";
		}
	}

	function codeReadPolicyCFC(value) {
		if (value.toLowerCase().indexOf("off") != -1) {
			return "0";
		} else if (value.toLowerCase().indexOf("read ahead") != -1) {
			return "1";
		}
	}

	/*******Johnny20181120*******/
	function volInputM2() {
		$("#m2ErrorMsgExecText").html();
		$("#vol_name_check_m2").hide();
		var vol_name = $("#create_vol_name_m2").val().trim();
		if (vol_name == "" || vol_name == null || vol_name == undefined) {
			return "vol_name_m2_empty";
		}
	}

	function startCreateStorageM2() {
		warnMessageShowForM2(false);
		printLog("INFO", "button 'Create' was clicked.");
		var ret = volInputM2();
		var err_msg = "";
		if (ret == "vol_name_m2_empty") {
			err_msg = $.i18n.prop("RaidConfig.InputVolName");
		}
		if (err_msg != "" && err_msg != null && err_msg != undefined) {
			$("#m2ErrorMsgExecText").html(err_msg);
			$("#vol_name_check_m2").show();
			return;
		}

		if (!confirm($.i18n.prop("RaidConfig.CreateConfig"))) {
			return false;
		}

		var msg = $.i18n.prop("RaidConfig.ApplyRaidConfig");
		$("#raidStatusDiv").show();
		$("#raidStatusDiv img")[0].src = "images/progress_anim2.gif";
		$("#raidMsgDiv").html(msg);
		top.toggleNext(false);
		top.togglePrevious(false);
		$("#buttonRaidDiv").hide();
		$("#tableRaidDiv").hide();

		writeIniFileM2();
		dismissModal();

		raidShowPath = top.getSupportFile("raidShowResult");
		raidResultPath = top.getSupportFile("raidResult");
		if (top.fileExists(raidShowPath)) {
			top.deleteFile(raidShowPath);
		}
		if (top.fileExists(raidResultPath)) {
			top.deleteFile(raidResultPath);
		}

		var args = new Array();
		args.push(top.getSystemFile("oneCli"));
		args.push("misc");
		args.push("raid");
		args.push("add");
		args.push("--bmc");
		args.push(SplitFullConnInfo());
		args.push("--never-check-trust");
		// args.push("--target");
		// args.push(top.gl_raid_select.replace("ctrl-", ""));
		args.push("--ctrl");
		args.push(top.gl_raid_select.replace("ctrl-", "").replace("m.2-", ""));
		args.push("--file");
		args.push(top.gl_raid_ini_path);
		args.push("--force");
		args.push(...add_output_log5());
		top.store_onecli_command(args);
		printLog("INFO", "run command:" + getRunProgramCommend(args));
		runProgram(args, null, createStorCb);
	}

	function writeIniFileM2() {
		top.gl_raid_ini_path = top.getSupportFile("raidConfig");
		if (top.fileExists(top.gl_raid_ini_path)) {
			top.deleteFile(top.gl_raid_ini_path);
		}
		var fileContent = "";
		var ctrl_id = top.gl_raid_select.replace("ctrl-", "").replace("m.2-", "");
		var raidlvl_m2 = $("#raidlvl_m2").val();
		var vol_name_m2 = $("#create_vol_name_m2").val().trim();
		var strip_size_m2 = $("#create_vol_strip_size_m2").val();

		var vol_obj_m2 = {};
		vol_obj_m2.raid_level = raidlvl_m2;
		vol_obj_m2.vol_name = vol_name_m2;
		vol_obj_m2.strip_size = strip_size_m2;

		var ctrl_line = "[ctrl" + ctrl_id + "-vol0]" + "\n";

		var raidlvl_line = "raid_level=";
		raidlvl_line += vol_obj_m2.raid_level + "\n";

		var name_line = "vol_name=";
		name_line += vol_obj_m2.vol_name + "\n";

		var strip_size_line = "strip_size=";
		var strip_size = vol_obj_m2.strip_size;
		// strip_size = codeStripSizeM2(strip_size);
		strip_size = codeStripSize(strip_size);
		strip_size_line += strip_size + "\n";

		fileContent = fileContent + ctrl_line + raidlvl_line + name_line + strip_size_line + "\n";

		top.writeTextFile(top.gl_raid_ini_path, fileContent);
	}

	// function codeStripSizeM2(value) {
	// 	if (value.toLowerCase().indexOf("32kb") != -1) {
	// 		return "32K";
	// 	} else if (value.toLowerCase().indexOf("64kb") != -1) {
	// 		return "64K";
	// 	}
	// }
	function warnMessageShowForM2(needShow,message="")
	{
		$("#m2ErrorMsgExecText").html();
		$("#vol_name_check_m2").hide();
		if(needShow)
		{
			$("#m2WarnMsgExecText").html(message);
			$("#m2WarnMsgExecControl").show();
		}
		else
		{
			$("#m2WarnMsgExecText").html();
			$("#m2WarnMsgExecControl").hide()
		}
	}


	function stripeSizeChangeSetForM2(needEvent){
		var sel = document.getElementById("create_vol_strip_size_m2");
		if(needEvent)
		{
			sel.onchange = function(){
				warnMessageShowForM2(true, $.i18n.prop("RaidConfig.WarnChangeStripeSize"));
			};
		}
		else
		{
			sel.onchange = function(){};
		}
	}
	
	function warnMessageShow(needShow,message="")
	{
		$("#errorMsgExecText").html();
		$("#vol_check_msg").hide();
		if(needShow)
		{
			$("#warnMsgExecText").html(message);
			$("#warnMsgExecControl").show();
		}
		else
		{
			$("#warnMsgExecText").html();
			$("#warnMsgExecControl").hide()
		}
	}


	function stripeSizeChangeSet(type){
		var sel = document.getElementById("create_vol_strip_size");
		if(type == "create" || type == "edit")
		{
			sel.onchange = function(){
				warnMessageShow(true, $.i18n.prop("RaidConfig.WarnChangeStripeSize"));
			};
		}
		else
		{
			sel.onchange = function(){};
		}
	}


	return {
		index: 0,
		name: "Raid_Config",
		nextAction: function () {
			printLog("INFO", "Next was clicked.");
			return true;
		},
		init: raid_init,
		importId: '#import_raid_config',
		selectorId: '.raid_config',
		title: "Navi.RaidConfig",
		localizedTitle: tr("Navi.RaidConfig"),
		refreshTable: refreshTable,
		userCancel: userCancel,
		// cancelRetr: cancelRetr,
		changeSelect: changeSelect,
		selectRaidRow: selectRaidRow,
		clearCtrl: clearCtrl,
		makeDiskGood: makeDiskGood,
		makeDiskJbod: makeDiskJbod,
		toggleRow: toggleRow,
		startCreateVol: startCreateVol,
		formStep1Next: formStep1Next,
		formStep3Prev: formStep3Prev,
		formStep2Prev: formStep2Prev,
		formStep2Next: formStep2Next,
		showEditVol: showEditVol,
		cancelEditVolume: cancelEditVolume,
		initAvaDiskTable: initAvaDiskTable,
		refreshAvaDiskTable: refreshAvaDiskTable,
		initSelDiskTable: initSelDiskTable,
		refreshSelDiskTable: refreshSelDiskTable,
		applyVol: applyVol,
		showCreateVol: showCreateVol,
		selectVolRow: selectVolRow,
		removeVolume: removeVolume,
		addMember: addMember,
		addToSpan: addToSpan,
		addHotSpare: addHotSpare,
		removeDisk: removeDisk,
		selectDiskRow: selectDiskRow,
		startCreateStorage: startCreateStorage,
		cancelModal: cancelModal,
		addSpan: addSpan,
		volInputM2: volInputM2,
		startCreateStorageM2: startCreateStorageM2,
		writeIniFileM2: writeIniFileM2
	}
}();
