// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Portal_Activation = function () {

    const { reactive, ref, watch, computed, onMounted } = Vue

    let portalActivationApp = undefined;

    const taskTool = TaskTool(false);

    const vue_obj = {
        setup (props) {

            const settingsForWithClaim = reactive({
                show: top.gl_isAccountValidated,
                warningContent: tr("Enable portal activation warning with claim"),
                yesContent: tr("Yes, I want to lock down server"),
                noContent: tr("No, I want to keep the server unlocked"),
                hasYes: true,
                hasNo: true,
                level: 'waring',
                res: ''
            });

            const settingsForWithoutClaim = reactive({
                show: !top.gl_isAccountValidated,
                warningContent: tr("Enable portal activation warning without claim"),
                yesContent: tr("Yes, I understand and would like to proceed"),
                noContent: '',
                hasYes: true,
                hasNo: false,
                level: 'waring',
                res: ''
            });

            const clickable_b = ref('notclick');
            const lockDown = ref(false);
            const confirmText = ref('');
            const enable = ref(true);
            const confirmBox = ref(null);

            watch(confirmText, (newValue) => {
                enable.value = !(newValue == "YES");
            });
            const taskInfos = reactive([]);

            /* 
            Claim*->Enable -->[LockDown->Shutdown->Set Deactive]*
                            \-->Set Active*
            */
            let enablePortalActivation = function () {
                // taskTool.clickable.value = 'notclick';
                taskInfos.length = 0;
                const allTasks = {};
                // ======= Claim =======
                let args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("claim");
                args = args.concat(SplitXCCInfo());
                args.push("--ts-token-file");
                args.push(top.getSupportFile("tokenFile"));
                args.push("--active-code");
                args.push(top.gl_Edge_Machine_Params.ActivationCode);
                args.push(...add_proxy_para());
                args.push(...add_output_log5());
                allTasks["Claim"] = new taskTool.TaskInfo("Claim", args, null, new taskTool.TaskStatus(tr("SecurityPack.Status.ClaimServer"), tr("SecurityPack.Status.ClaimServer")));

                // ======= Enable =======
                args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("enableportalactivation");
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push(...add_output_log5());
                allTasks["Enable"] = new taskTool.TaskInfo("Enable", args, null, new taskTool.TaskStatus(tr("Promote system lockdown control to ThinkShield portal managed."), tr("Promote system lockdown control to ThinkShield portal managed.")));

                // ======= LockDown =======
                args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("lock");
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push(...add_output_log5());
                allTasks["LockDown"] = new taskTool.TaskInfo("LockDown", args, null, new taskTool.TaskStatus(tr("SecurityPack.Status.LockServer"), tr("SecurityPack.Status.LockServer")));

                // ======= Shutdown =======
                args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("misc");
                args.push("ospower");
                args.push("turnoff");
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push(...add_output_log5());
                allTasks["Shutdown"] = new taskTool.TaskInfo("Shutdown", args, null, new taskTool.TaskStatus(tr("SecurityPack.Status.OSPoweroff"), tr("SecurityPack.Status.OSPoweroff")));

                // ======= Set Deactivated =======
                args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("setstatustoinactive");
                args = args.concat(SplitXCCInfo());
                args.push("--ts-token-file");
                args.push(top.getSupportFile("tokenFile"));
                args.push(...add_proxy_para());
                args.push(...add_output_log5());
                allTasks["SetDeactivated"] = new taskTool.TaskInfo("SetDeactivated", args, null, new taskTool.TaskStatus(tr("SecurityPack.Status.SetServerInactive"), tr("SecurityPack.Status.SetServerInactive")));

                // ======= Set Active =======
                args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("setstatustoactive");
                args = args.concat(SplitXCCInfo());
                args.push("--ts-token-file");
                args.push(top.getSupportFile("tokenFile"));
                args.push(...add_proxy_para());
                args.push(...add_output_log5());
                allTasks["SetActive"] = new taskTool.TaskInfo("SetActive", args, null, new taskTool.TaskStatus(tr("SecurityPack.Status.SetServerActive"), tr("SecurityPack.Status.SetServerActive")));


                let tasksToBeDone;
                if (!top.gl_isAccountValidated) {
                    tasksToBeDone = ["Enable", "LockDown", "Shutdown"];
                } else {
                    if (lockDown.value) {
                        tasksToBeDone = ["Claim", "Enable", "LockDown", "Shutdown", "SetDeactivated"];
                    } else {
                        tasksToBeDone = ["Claim", "Enable", "SetActive"];
                    }
                }

                tasksToBeDone.forEach(e => {
                    taskInfos.push(allTasks[e]);
                })

                taskTool.runOrderedTasksSync(taskInfos);
            }
            return {
                enablePortalActivation,
                settingsForWithClaim,
                settingsForWithoutClaim,
                confirmText,
                confirmBox,
                enable,
                lockDown,
                clickable_b,
                clickable_a: taskTool.clickable,
                taskInfos
            }
        }
    }

    const init_vue = async function () {
        if (portalActivationApp == undefined) {
            portalActivationApp = Vue.createApp(vue_obj);
            const { taskStatus } = await import('../Common_Components/Task_Status/Task_Status.js');
            const { alert } = await import('../Common_Components/Alert/Alert.js');
            portalActivationApp.component("taskstatus", taskStatus).component("alert", alert);
            portalActivationApp.mount('#portal_activation_vue'); 
        }
    }

    const init = function () {
        printLog("DEBUG", "Init portal activation.");
        if (taskTool.stage.value == "done") {
            top.toggleNext(true);
            top.togglePrevious(true);
        } else {
            top.toggleNext(false);
            top.togglePrevious(true);
        } 
        init_vue();
    }

    const uninit = function () {
        if (portalActivationApp != null || portalActivationApp != undefined) {
            portalActivationApp.unmount();
            portalActivationApp = undefined;
        }
    }

    return {
        index: 0,
        name: "Portal_Activation",
        init: init,
        uninit: uninit,
        nextAction: function () {
            return true;
        },
        previousAction: function () {
            return true;
        },
        needReInit: true,
        importId: '#import_portal_activation',
        selectorId: '.portal_activation',
        title: "Navi.PortalActivation",
        localizedTitle: tr("Navi.PortalActivation")
    }
}();