multi_config = function () {
    let multi_server_config_file = top.pathJoin(top.basePath(), "multi_server_config_file.json");
    let crypt_file = top.getSystemFile("crypt");
    let config_temp_file = top.pathJoin(top.basePath(), "config_temp.json");
    let errorInfo = "";

    let log = function (msg) {
        printLog("INFO", msg)
    }

    let logErr = function (msg) {
        printLog("ERROR", msg);
    }

    let multi_config_obj = {
        MODE: "",
        RAND_NUM: "",
        ENCRYPTED_INFO: [],
    }

    function GetKey(item) {
        let ip = item.ip;
        if (top.isIPV6(item.ip)) {
            ip = "[" + item.ip + "]";
        }
        return [
            item.userName,
            "@",
            ip,
            ...[item.port ? `:${item.port}` : '']
        ].join("");
    }

    function Load() {
        try {
            let data = "";

            data = top.readTextFile(multi_server_config_file);
            let jsObj = JSON.parse(data);
            if (!jsObj) {
                log("Configure file parse is empty.");
                top.deleteFile(crypt_file);
                top.deleteFile(multi_server_config_file);
                return;
            }
            data = top.readTextFile(crypt_file);
            let crypt = JSON.parse(data);
            if (!crypt) {
                crypt = {
                    MODE: "",
                    RAND_NUM: "",
                    ENCRYPTED_INFO: []
                }
            };
            let isDifferent = false;
            let validSize = 0;
            for (let item of jsObj.ENCRYPTED_INFO) {
                if (item.value && item.value.length > 0) {
                    validSize++;
                }
            }
            if (crypt.MODE != jsObj.MODE
                || crypt.RAND_NUM != jsObj.RAND_NUM
                || crypt.ENCRYPTED_INFO.length != validSize) {
                isDifferent = true;
                crypt.MODE = jsObj.MODE;
                crypt.RAND_NUM = jsObj.RAND_NUM;
                crypt.ENCRYPTED_INFO = [];
            }
            let existInvalidItem = false;
            for (let i = 0; i < jsObj.ENCRYPTED_INFO.length; i++) {
                item = jsObj.ENCRYPTED_INFO[i];
                if (item.password) {
                    delete item.password;
                }
                if (!top.checkHostName(item.ip)) {
                    jsObj.ENCRYPTED_INFO.splice(i, 1);
                    i--;
                    existInvalidItem = true;
                    continue;
                }
                if (!item.value || item.value.length == 0) {
                    continue;
                }
                let findItem = false;
                for (let j = 0; j < crypt.ENCRYPTED_INFO.length; j++) {
                    let item2 = crypt.ENCRYPTED_INFO[j];
                    if (item2.key == GetKey(item)) {
                        findItem = true;
                        if (item2.value != item.value) {
                            item2.value = item.value;
                            isDifferent = true;
                        }
                    }
                }
                if (!findItem) {
                    isDifferent = true;
                    if (item.value) {
                        crypt.ENCRYPTED_INFO.push({
                            key: GetKey(item),
                            value: item.value
                        });
                    }
                }
            }
            if (existInvalidItem) {
                top.writeTextFile(multi_server_config_file, JSON.stringify(jsObj, null, 2));
            }
            if (isDifferent) {
                if (crypt.MODE && crypt.RAND_NUM) {
                    top.writeTextFile(crypt_file, JSON.stringify(crypt, null, 4));
                }
            }
            multi_config_obj.MODE = jsObj.MODE;
            multi_config_obj.RAND_NUM = jsObj.RAND_NUM;
            for (let item of jsObj.ENCRYPTED_INFO) {
                multi_config_obj.ENCRYPTED_INFO.push(item);
                multi_config_obj.key = GetKey(item);
            }
        } catch (e) {
            top.deleteFile(crypt_file);
            top.deleteFile(multi_server_config_file);
            logErr("Exception, " + e);
        }
    }

    async function Merge(fileName) {
        try {
            let data = top.readTextFile(fileName);
            let rootObj = JSON.parse(data);
            if (rootObj.MODE == multi_config_obj.MODE && rootObj.RAND_NUM == multi_config_obj.RAND_NUM) {
                for (let item of rootObj.ENCRYPTED_INFO) {
                    AppendOrUpdate(item.ip, item.internalIP, item.port, item.userName, item.value, item.mt, item.sn, item.needChangePassword);
                }
                return true;
            }
            for (let i = 0; i < rootObj.ENCRYPTED_INFO.length; i++) {
                let item = rootObj.ENCRYPTED_INFO[i];
                if (item.userName && item.userName.length > 0 && item.value && item.value.length > 0) {
                    continue;
                }
                AppendOrUpdate(item.ip, item.internalIP, item.port, item.userName, item.value, item.mt, item.sn, item.needChangePassword);
                rootObj.ENCRYPTED_INFO.splice(i, 1);
                i--;
            }
            top.writeTextFile(config_temp_file, JSON.stringify(rootObj));
            let onecliExec = [
                top.getSystemFile("oneCli"),
                "encrypt",
                "--importfile",
                config_temp_file,
                "--unattended",
                "-q",
                ...add_output_log5()
            ]
            if (top.fileExists(crypt_file)) {
                top.store_onecli_command(onecliExec);
                top.deleteFile(top.getSupportFile("commonResult", null));
                let result = await runProgram(onecliExec);
                top.deleteFile(config_temp_file);
                if (result.success) {
                    data = top.readTextFile(crypt_file);
                    let cryptObj = JSON.parse(data);
                    for (let item of cryptObj.ENCRYPTED_INFO) {
                        let pos = item.key.lastIndexOf("@");
                        ip = item.key.substring(pos + 1);
                        userName = item.key.substring(0, pos);
                        let fItem = function () {
                            for (let i of rootObj.ENCRYPTED_INFO) {
                                if (i.ip == ip) {
                                    return i;
                                }
                            }
                            return {
                                mt: "",
                                sn: "",
                            }
                        }();
                        AppendOrUpdate(ip, fItem.internalIP, fItem.port, userName, item.value, fItem.mt, fItem.sn);
                    }
                    return true;
                } else {
                    errorInfo = stderr;
                    return false;
                }
            } else {
                updateAttend(rootObj.MODE, rootObj.RAND_NUM);
                for (let item of rootObj.ENCRYPTED_INFO) {
                    AppendOrUpdate(item.ip, item.internalIP, item.port, item.userName, item.value, item.mt, item.sn);
                }
                Save();
            }
            return true;
        } catch (e) {
            logErr(e);
        }
        return false;
    }
    function Save() {
        let tempObj = {
            MODE: multi_config_obj.MODE,
            RAND_NUM: multi_config_obj.RAND_NUM,
            ENCRYPTED_INFO: []
        }
        let cryptObj = {
            MODE: multi_config_obj.MODE,
            RAND_NUM: multi_config_obj.RAND_NUM,
            ENCRYPTED_INFO: []
        }
        let findItem = function (dataArray, ip) {
            for (let i = 0; i < dataArray.length; i++) {
                let item = dataArray[i];
                if (item.ip === ip) {
                    return i;
                }
            }
            return -1;
        }
        for (let item of multi_config_obj.ENCRYPTED_INFO) {
            if (!item.ip) {
                continue;
            }
            let pos = findItem(tempObj.ENCRYPTED_INFO, item.ip);
            if (pos == -1) {
                tempObj.ENCRYPTED_INFO.push({
                    ip: item.ip,
                    internalIP: item.internalIP,
                    port: item.port,
                    userName: item.userName,
                    mt: item.mt,
                    sn: item.sn,
                    value: item.value,
                    needChangePassword: !!item.needChangePassword
                });
            }
            if (item.value) {
                cryptObj.ENCRYPTED_INFO.push({
                    key: GetKey(item),
                    value: item.value
                });
                if (pos != -1) {
                    tempObj.ENCRYPTED_INFO[pos].userName = item.userName;
                    tempObj.ENCRYPTED_INFO[pos].value = item.value;
                }
            }
        }
        top.writeTextFile(multi_server_config_file, JSON.stringify(tempObj, null, 2));
        if (cryptObj.MODE && cryptObj.RAND_NUM) {
            top.writeTextFile(crypt_file, JSON.stringify(cryptObj, null, 4));
        }
    }

    function Export(fileName) {
        let tempObj = {
            MODE: multi_config_obj.MODE,
            RAND_NUM: multi_config_obj.RAND_NUM,
            ENCRYPTED_INFO: []
        }
        for (let item of multi_config_obj.ENCRYPTED_INFO) {
            tempObj.ENCRYPTED_INFO.push({
                ip: item.ip,
                internalIP: item.internalIP,
                port: item.port,
                userName: item.userName,
                mt: item.mt,
                sn: item.sn,
                value: item.value,
                needChangePassword: !!item.needChangePassword
            });
        }
        return top.writeTextFile(fileName, JSON.stringify(tempObj, null, 2));
    }

    function ExportSelectedItem(fileName, data) {
        let tempObj = {
            MODE: multi_config_obj.MODE,
            RAND_NUM: multi_config_obj.RAND_NUM,
            ENCRYPTED_INFO: []
        }
        for (let item of data) {
            if (item.selected) {
                tempObj.ENCRYPTED_INFO.push({
                    ip: item.ip,
                    internalIP: item.internalIP,
                    port: item.port,
                    userName: item.userName,
                    mt: item.mt,
                    sn: item.sn,
                    value: item.value,
                    needChangePassword: !!item.needChangePassword
                });
            }
        }
        return top.writeTextFile(fileName, JSON.stringify(tempObj, null, 2));
    }

    function AppendOrUpdate(ip, internalIP, port, userName, value, mt, sn, needChangePassword) {
        if (!ip) {
            return;
        }
        for (let item of multi_config_obj.ENCRYPTED_INFO) {
            if (item.ip === ip) {
                let isChanged = false;
                if (internalIP && item.internalIP != internalIP) {
                    isChanged = true;
                }
                if (port && item.port != port) {
                    isChanged = true;
                }
                if (userName && item.userName != userName) {
                    isChanged = true;
                }
                if (value && item.value != value) {
                    isChanged = true;
                }
                if (mt && item.mt != mt) {
                    isChanged = true;
                }
                if (sn && item.sn != sn) {
                    isChanged = true;
                }
                if (needChangePassword != undefined && item.needChangePassword != needChangePassword) {
                    isChanged = true;
                }
                item.internalIP = internalIP ? internalIP : item.internalIP;
                item.port = port ? port : item.port;
                item.userName = userName ? userName : item.userName;
                item.value = value ? value : item.value;
                item.mt = mt ? mt : item.mt;
                item.sn = sn ? sn : item.sn;
                item.needChangePassword = needChangePassword != undefined ? !!needChangePassword : item.needChangePassword;
                if (isChanged) {
                    Save();
                }
                return;
            }
        }
        multi_config_obj.ENCRYPTED_INFO.push({
            ip: ip,
            internalIP: internalIP ? internalIP : ip,
            port: port ? port : "",
            userName: userName ? userName : "",
            value: value ? value : "",
            mt: mt ? mt : "",
            sn: sn ? sn : "",
            needChangePassword: needChangePassword ? needChangePassword : false
        });
        Save();
    }

    function removeItem(ip) {
        for (let i = 0; i < multi_config_obj.ENCRYPTED_INFO.length; i++) {
            let item = multi_config_obj.ENCRYPTED_INFO[i];
            if (item.ip === ip) {
                multi_config_obj.ENCRYPTED_INFO.splice(i, 1);
                i--;
            }
        }
        Save();
    }

    function updateAttend(MODE, RAND_NUM) {
        if (!multi_config_obj.MODE) {
            multi_config_obj.MODE = MODE;
        } else if (multi_config_obj.MODE != MODE) {
            log("MODE changed, so clear all data which is saved before.");
            multi_config_obj.MODE = MODE;
            multi_config_obj.ENCRYPTED_INFO = [];
        }
        if (!multi_config_obj.RAND_NUM) {
            multi_config_obj.RAND_NUM = RAND_NUM;
        } else if (multi_config_obj.RAND_NUM != RAND_NUM) {
            log("RAND_NUM changed, so clear all data which is saved before.");
            multi_config_obj.RAND_NUM = RAND_NUM;
            multi_config_obj.ENCRYPTED_INFO = [];
        }
    }

    return {
        errorInfo: errorInfo,
        Data: function () { return multi_config_obj; },
        Load: Load,
        Merge: Merge,
        Save: Save,
        Export: Export,
        ExportSelectedItem: ExportSelectedItem,
        AppendOrUpdate: AppendOrUpdate,
        RemoveItem: removeItem,
        GetKey: GetKey,
        UpdateAttend: updateAttend
    }
}();