// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Local_Activation = function () {

    const { reactive, ref, watch, computed } = Vue

    let loaclActivationApp = undefined;

    const taskTool = TaskTool();

    let vue_obj = {
        setup () {

            const taskInfos = reactive([]);
            const disabled = ref(false);
            const style = reactive({
                background: "#0e72ac",
                color: "#fff",
                padding:'0.5em 2em',
                'border-radius':'5px',
                border: 'none'
            });

            let localActivate = function () {

                taskInfos.length = 0;

                let args = [];
                args.push(top.getSystemFile("oneCli"));
                args.push("edgeserver");
                args.push("unlock");
                args.push("--bmc");
                args.push(SplitFullConnInfo());
                args.push("--never-check-trust");
                args.push(...add_output_log5());
                taskInfos.push(new taskTool.TaskInfo("LocalActivate", args, (res)=>{
                    if (true === res) {
                        disabled.value = "disabled";
                        style.background = "#eee";
                        style.color = "#aaa";
                    }
                }, new taskTool.TaskStatus(tr("Unlock target server."), tr("Unlock target server."))));

                taskTool.runOrderedTasksSync(taskInfos);
            }

            return {
                taskInfos,
                clickable: taskTool.clickable,
                localActivate,
                disabled,
                style,
                tr,
            }
        }
    }

    let init_vue = async function () {
        if (loaclActivationApp == undefined) {
            loaclActivationApp = Vue.createApp(vue_obj);
            const { taskStatus } = await import('../Common_Components/Task_Status/Task_Status.js');
            loaclActivationApp.component("taskstatus", taskStatus);
            loaclActivationApp.use(ElementPlus);
            loaclActivationApp.mount('#local_activation_vue');
        }
    }

    let uninit = function () {
        if (loaclActivationApp != null || loaclActivationApp != undefined) {
            loaclActivationApp.unmount();
            loaclActivationApp = undefined;
        }
    }

    let init = function () {
        printLog("DEBUG", "Init local activation app.");
        if (taskTool.stage == "done") {
            top.toggleNext(true);
            top.togglePrevious(true);
        } else {
            top.toggleNext(false);
            top.togglePrevious(true);
        } 
        init_vue();
    }

    return {
        index: 0,
        name: "Local_Activation",
        init: init,
        uninit: uninit,
        nextAction: function () {
            return true;
        },
        previousAction: function () {
            return true;
        },
        importId: '#import_local_activation',
        selectorId: '.local_activation',
        title: "Navi.LocalActivate",
        localizedTitle: tr("Navi.LocalActivate"),
        needReInit: true
    }
}();