// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Finish = function() {

	let selectedTaskId = 0;
	let selectedLogPath = "";

	// Common
	function fn_init() {
		printLog("INFO","Finish page init.");

		document.getElementById("completeMsg").innerHTML = "<img src='images/statusInformation_obj16.gif'> ";
		if (top.gl_task.indexOf(top.gl_isUpdate) != -1 && top.gl_needPrereqWarn) {
			document.getElementById("completeMsg").innerHTML += $.i18n.prop("Finish.PrereqWarn");
		} else {
			document.getElementById("completeMsg").innerHTML += $.i18n.prop("Finish.UpdateComplete");
		}
		if (top.gl_task.indexOf(top.gl_isUpdate) != -1 && true == top.gl_isValidUefiUpdate) {
			document.getElementById("completeMsg").innerHTML += "<BR><BR><img src='images/statusInformation_obj16.gif'> ";
			document.getElementById("completeMsg").innerHTML += $.i18n.prop("Finish.UEFIUpdate");
		}
		document.getElementById("multiCompleteLogDir").innerText = tr("All logs are located in {0}", top.getSupportDir());
		initTaskOptions();
	}

	function initTaskOptions() {
		document.getElementById("taskSelector").innerHTML = "";
        selectedTaskId = 0;

		var validTasks = new Array();
		printLog('INFO', 'origin task count:' + top.gl_task.length);
		var j = 0;
		for (let i = 0; i < top.gl_task.length; ++i) {
			if (top.gl_task[i] != top.gl_configSecurity)
				validTasks[j++] = i;
		}
		printLog('INFO', 'valid task count:' + validTasks.length);
		
		for (let i = 0; i < validTasks.length; ++i) {
			let opt = document.createElement("option");
			opt.value = validTasks[i];
			opt.innerText = top.gl_tasksName[top.gl_task[validTasks[i]]];
			document.getElementById("taskSelector").appendChild(opt);
		}
		$('#taskSelector option:first').prop("selected", true);
		if (validTasks.length < 2) {
			// Hide it because of too few option, but it still take effect in checkTaskOptions()
			$("#taskSelectorDiv").hide();
		} else {
			$("#taskSelectorDiv").show();
		}
		checkTaskOptions();
	}

	function checkTaskOptions() {
		let option = $('#taskSelector').prop("value");
        printLog('INFO','[Finish.html:checkTaskOptions] Task selected: ' + option);
        selectedTaskId = parseInt(option);
		selectedLogPath = getLogFile(selectedTaskId);
		if (selectedLogPath == null || selectedLogPath == undefined || selectedLogPath == "") {
			// Invalid case, set GUI same with single case
			// It will show "not found" if user click "View Log"
			$("#singleServerDiv").show();
			$("#multiServerDiv").hide();
			return;
		}

		if (!top.isAbsolutePath(selectedLogPath)) {
			selectedLogPath = top.pathJoin(top.getSupportDir(), selectedLogPath);
		}
		if (top.isDirectory(selectedLogPath)) {
			$("#singleServerDiv").hide();
			$("#multiServerDiv").show();
			parseLogDirectory();
			displaySortedResult();
		} else {
			$("#singleServerDiv").show();
			$("#multiServerDiv").hide();
		}
	}

	// MultiServer case
	const ONECLIRESULT_TASK_STAGED = 86; // Regard as Success
    const ONECLIRESULT_NO_UPDATE = 110;  // Regard as Warning
	let commonResults = new Array();
	let ip2LogLocate = {};

	function parseLogDirectory() {
		ip2LogLocate = {};
		/**
		 * selectedLogPath
		 *  |- 1.1.1.1
		 *  |- SUCCESS-2.2.2.2
		 *  |_ FAILURE-3.3.3.3
		 * TODO: IPv6
		 */
		let subfolders = top.readDirectorySync(selectedLogPath, 2);
		for (let _selectedServer of Server_Pool.selectedServerList) {
			for (let dir of subfolders) {
				if (top.basename(dir).indexOf(_selectedServer.ip) != -1) {
					ip2LogLocate[_selectedServer.ip] = dir;
					break;
				}
			}
		}
	}

	function displaySortedResult() {
		document.getElementById("multiCompleteLogsTable").innerHTML = "";
		readCommonResult();
		sortCommonResult();
		displayCommonResult();
	}
	function readCommonResult() {
		commonResults = new Array()
		for (let _selectedServer of Server_Pool.selectedServerList) {
			let _errorCode = "N/A";
			let _logfile = "";
			let _errorMsg = "";
			let _commonResult = null;
			if (ip2LogLocate[_selectedServer.ip]) {
				_commonResult = top.readTextFile(top.getSupportFile("commonResult", null, ip2LogLocate[_selectedServer.ip]));
			}
			if (_commonResult != null) {
				let _dom = ezJsLib.XmlDom.parse(_commonResult);
				_errorCode = _dom.getElementsByTagName("ERRORCODE")[0].innerHTML;
				_logfile = _dom.getElementsByTagName("LOGFILE")[0].innerHTML;
				_errorMsg = _dom.getElementsByTagName("MESSAGE")[0].innerHTML;
			}
			if (!_errorMsg) {
				_errorMsg = "Unknown result message";
			}
			commonResults.push({
				ip:         _selectedServer.ip,
				mt:         _selectedServer.mt,
				sn:         _selectedServer.sn,
 				returnCode: _errorCode,
				logfile:    _logfile,
				errorMsg:   _errorMsg
			});
		}
	}
	function sortCommonResult() {
		// default: sort by commonResult returnCode
		commonResults.sort((resultA, resultB) => {
			if (resultA.returnCode === resultB.returnCode) {
				return 0;
			}
			if (resultA.returnCode === "N/A") {
				return 1;
			}
			if (resultB.returnCode === "N/A") {
				return -1;
			}
			return resultA.returnCode - resultB.returnCode;
		});
	}
	function displayCommonResult() {
		for (let result of commonResults) {
			let className, title;
			if (result.returnCode === 0 || result.returnCode === "0" || Number(result.returnCode) === ONECLIRESULT_TASK_STAGED) {
				className = "glyphicon glyphicon-ok-circle span-ok";
				title = "Success";
			} else if (Number(result.returnCode) === ONECLIRESULT_NO_UPDATE) {
				className = "glyphicon glyphicon-warning-sign span-warning";
				title = "Warning";
			} else {
				className = "glyphicon glyphicon-remove-circle span-failed";
				title = "Failure";
			}
			let content = 
			`<tr>
				<td style="border: thin solid lightgray;">${result.ip}</td>
				<td style="border: thin solid lightgray;">${result.mt}</td>
				<td style="border: thin solid lightgray;">${result.sn}</td>
				<td style="border: thin solid lightgray;">
					<div style="margin-left:10px;">
						<span class="${className}" title="${title}" aria-hidden="true"></span>
					</div>
				</td>
				<td style="border: thin solid lightgray;">${result.errorMsg}</td>
				<td style="border: thin solid lightgray;">
					<button class="inTableButton" onClick="Finish.dumpLog_multi('${result.ip}','${result.logfile}');" title="Click to open log file">
						<span class="glyphicon glyphicon-file" style="color: skyblue;" aria-hidden="true"></span>
					</button>
				</td>
			</tr>`
			document.getElementById("multiCompleteLogsTable").innerHTML += content;
		}
	}
	function dumpLog_multi(ipAddr, logfile) {
		printLog("INFO","button 'View log multi' was clicked.");
		let mywidth = 600;
		let myheight = 400;
		let myleft = (screen.width - mywidth) / 2;
		let mytop = (screen.height - myheight) / 2;
		let logOpts = 'width=' + mywidth + ', height=' + myheight;
		logOpts += ', top=' + mytop + ', left=' + myleft;
		logOpts += ', directories=no';
		logOpts += ', location=no';
		logOpts += ', menubar=yes';
		logOpts += ', resizable=yes';
		logOpts += ', scrollbars=yes';
		logOpts += ', status=no';
		logOpts += ', toolbar=no';
		logOpts += ', close=yes';
		logOpts += ', show=true';
		logOpts += ', title=Lenovo XClarity Essentials UpdateXpress';
		let logContent = "";
		{
			if (ip2LogLocate[ipAddr] && logfile) {
				logContent = top.readTextFile(top.pathJoin(ip2LogLocate[ipAddr], logfile), "null");
			}
			if (!logContent) {
				logContent = $.i18n.prop("Finish.NoLogFound");
			}
			top.writeTextFile(top.getSupportFile("logHtml"), "<HTML><BODY><PRE>");
			top.writeTextFile(top.getSupportFile("logHtml"), logContent, 'a');
			top.writeTextFile(top.getSupportFile("logHtml"), "<\/PRE><\/BODY><\/HTML>", 'a');
		}
		let logWindow = window.open("file://" + top.getSupportFile("logHtml"), "", logOpts);
		if (window.focus) logWindow.focus();
	}

	// Single case
	function dumpLog() {
		printLog("INFO","button 'View Log' was clicked.");
		// remove the alert since nw.js does not support CTRL + W to close the window
		// 20160921 by chenhao9
		// alert("The log will be brought up in a separate browser window.\nPress \"Ctrl + w\" to return.");
		let mywidth = 600;
		let myheight = 400;
		let myleft = (screen.width - mywidth) / 2;
		let mytop = (screen.height - myheight) / 2;
		let logOpts = 'width=' + mywidth + ', height=' + myheight;
		logOpts += ', top=' + mytop + ', left=' + myleft;
		logOpts += ', directories=no';
		logOpts += ', location=no';
		logOpts += ', menubar=yes';
		logOpts += ', resizable=yes';
		logOpts += ', scrollbars=yes';
		logOpts += ', status=no';
		logOpts += ', toolbar=no';
		logOpts += ', close=yes';
		logOpts += ', show=true';
		logOpts += ', title=Lenovo XClarity Essentials UpdateXpress';
		let logContent = "";
		if (selectedLogPath == null || selectedLogPath == undefined || selectedLogPath == "") {
			logContent = "<HTML><BODY><PRE>" + $.i18n.prop("Finish.NoLogFound") + "<\/PRE><\/BODY><\/HTML>";
			top.writeTextFile(top.getSupportFile("logHtml"), logContent);
		} else {
			logContent = top.readTextFile(selectedLogPath, "null");
			// It may cause error-codes
			// logContent = "<HTML><BODY><PRE>" + logContent + "<\/PRE><\/BODY><\/HTML>";
			top.writeTextFile(top.getSupportFile("logHtml"), "<HTML><BODY><PRE>");
			top.writeTextFile(top.getSupportFile("logHtml"), logContent, 'a');
			top.writeTextFile(top.getSupportFile("logHtml"), "<\/PRE><\/BODY><\/HTML>", 'a');
		}
		let logWindow = window.open("file://" + top.getSupportFile("logHtml"), "", logOpts);
		if (window.focus) logWindow.focus();
	}

	return {
		name: "Finish",
		index: 0,
		init: fn_init,
		checkTaskOptions: checkTaskOptions,
		nextAction: function() { printLog("INFO","Next was clicked."); return true; },
		importId: '#import_finish',
		selectorId: '.finish',
		title: "Navi.Finish",
		localizedTitle: tr("Navi.Finish"),
		dumpLog: dumpLog,
		dumpLog_multi: dumpLog_multi,
		needRefresh: true
	}
}();
