// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

/* 
tables = [
    {
        headers: [
            {
                index: 1,
                title: "",
                width: 15,
            },
            {
                index: 2,
                title: "Setting name",
                width: 30,
            },
            {
                index: 3,
                title: "Set value",
                width: 30,
            },
            {
                index: 4,
                title: "Result",
                width: 25,
            },
            ...
        ],
        title: "xxxxxxxxxxxxxxx",
        desc: "xxxxxxxxxxxxxxxx",
        ts: new TaskInfo(...), // one task info per table
        data: [
            [
                {
                    index: 1,
                    status: status[3],
                    content: status[3],
                },
                {
                    index: 2,
                    title: item.DisplayName,
                    attributeName: item.AttributeName,
                    content: item.HelpText,
                },
                {
                    index: 3,
                    title: item.Value,
                    content: item.Value,
                },
                {
                    index: 4,
                    title: "Success",
                    content: "Success",
                    style: {
                        "text-decoration": "underline",
                        "color": "rgb(45, 108, 191)"
                    },
                    classes: "Hoverable"
                },
                ...
            ],
            ...
        ],
    },
    ...
]
*/

export let uxTable = function () {

    const { watch, ref, computed } = Vue;

    const INTERVAL_TIME = 10; 		//ms
    const SLIDE_TIME = 0.1 * 1000;	//ms

    const table_style = {
    }

    const content_style = {
        display: 'none'
    }

    let _move = null;

    return {

        props: ["tables", 'desc'],
        setup (props) {

            function ExpandMultiResult () {
                for (let e of document.getElementsByClassName("ContentTableContainer")) {
                    displayContent(e.childNodes[0]);
                }
            }

            function CollapseMultiResult () {
                for (let e of document.getElementsByClassName("ContentTableContainer")) {
                    hideContent(e.childNodes[0]);
                }
            }

            let isRunning = computed(()=>{
                for(let table of props.tables) {
                    if (table.ts.taskStatus.isRunning) {
                        return true;
                    }
                }
                return false;
            });
            
            let isFinished = computed(()=>{
                for(let table of props.tables) {
                    if (!table.ts.taskStatus.isFinished) {
                        return false;
                    }
                }
                return true;
            });

            let isCanceled = computed(()=>{
                for(let table of props.tables) {
                    if (table.ts.taskStatus.isCanceled) {
                        return true;
                    }
                }
                return false;
            });


            let watch_table = function (table) {

                let watch_every_item = function () {
                    watch(() => table.data, (value) => {
                        let flag = 0;
                        let table_icon = "images/statusSuccess_obj16.gif";
                        for (let e of value) {
                            e = e[0];
                            if (e.status != undefined || e.status != null) {
                                if (e.status == "progress") {
                                    e.icon = "images/progress_anim2_small.gif";
                                    flag |= 0x1;
                                } else if (e.status == "stopped") {
                                    e.icon = "images/statusStopped_obj16.gif";
                                    flag |= 0x8;
                                } else if (e.status == "info") {
                                    e.icon = "images/statusInformation_obj16.gif";
                                    flag |= 0x10;
                                } else if (e.status == "success") {
                                    e.icon = "images/statusSuccess_obj16.gif";
                                } else if (e.status == "critical") {
                                    e.icon = "images/statusCritical_obj16.gif";
                                    flag |= 0x2;
                                } else if (e.status == "warning") {
                                    e.icon = "images/statusWarning_obj16.gif";
                                    flag |= 0x4;
                                }
                            }
                        }
                        if (flag & 0x1) {
                            table_icon = "images/progress_anim2_small.gif";
                        } else if (flag & 0x2) {
                            table_icon = "images/statusCritical_obj16.gif";
                        } else if (flag & 0x4) {
                            table_icon = "images/statusWarning_obj16.gif";
                        } else if (flag & 0x8) {
                            table_icon = "images/statusInformation_obj16.gif";
                        } else if (flag & 0x10) {
                            table_icon = "images/statusInformation_obj16.gif";
                        }

                        table.icon = table_icon;

                    }, {
                        immediate: true,
                        deep: true
                    });
                }

                
                watch(() => table.ts.taskStatus, (val) => {
                    if (val.isRunning && !val.isFinished) {
                        table.icon = "images/progress_anim2_small.gif";
                        table.clickable = false;
                        CollapseMultiResult();
                    } else if (val.isFinished) {
                        table.clickable = true;
                        watch_every_item();
                    }
                }, {
                    immediate: true,
                    deep: true
                });
            }

            watch(() => props.tables, (tables) => {
                for (let table of tables) {
                    watch_table(table);
                }
            },
            { deep: true });


            function hideContent (e) {
                let content = e.parentNode.childNodes[1];
                if (content) {
                    content.style.display = "none";
                    let orginal_button = content.parentNode.childNodes[0].childNodes[0];
                    orginal_button.className = "Expander";
                    orginal_button.title = "display";
                }
            }

            function displayContent (e) {
                let content = e.parentNode.childNodes[1];
                if (content) {
                    content.style.height = "";
                    content.style.display = "";
                    let orginal_button = content.parentNode.childNodes[0].childNodes[0];
                    orginal_button.className = "Contracter";
                    orginal_button.title = "hide";
                }
            }

            function move () {
                let content = this.parentNode.childNodes[1];
                let table = content.childNodes[0];
                let speed = table.offsetHeight / SLIDE_TIME * INTERVAL_TIME;
                if (speed < 1) {
                    speed = 1;
                }
                if (this.ac_moving_hide) {
                    let tmp = parseFloat(content.style.height.replace("px", "")) - speed;
                    if (tmp > 1) {
                        content.style.height = tmp + "px";
                        this.timer = setTimeout(_move, INTERVAL_TIME);
                    }
                    else {
                        hideContent(this);
                        clearTimeout(this.timer);
                    }
                }
                else {
                    let tmp = parseFloat(content.style.height.replace("px", "")) + speed;
                    if (tmp < table.offsetHeight) {
                        content.style.height = tmp + "px";
                        this.timer = setTimeout(_move, INTERVAL_TIME);
                    }
                    else {
                        displayContent(this);
                        clearTimeout(this.timer);
                    }
                }
            }

            function slideContent (e) {
                // moving_contentIndex = contentIndex;
                let node = e.currentTarget;
                let content = node.parentNode.childNodes[1];
                if (content.style.display != "none") {		//to hide
                    // printLog("INFO","shown --> hidden");
                    clearTimeout(e.timer);
                    content.style.height = content.offsetHeight + "px";
                    node.ac_moving_hide = true;
                    // ac_moving_hide = true;
                    _move = move.bind(node);
                    _move();
                } else {									//hidden --> show
                    // printLog("INFO","hidden --> shown");
                    clearTimeout(e.timer);
                    content.style.display = "";
                    content.style.height = "1px";
                    node.ac_moving_hide = false;
                    // ac_moving_hide = false;
                    _move = move.bind(node);
                    _move();
                }
            }

            function toggleContent (e) {
                slideContent(e);
            }


            return {
                toggleContent,
                ExpandMultiResult,
                CollapseMultiResult,
                isRunning,
                isFinished,
                isCanceled,
                tables: props.tables,
                table_style,
                content_style
            }
        },
        template: readTextFile(appBasePath() + '/js/ext/Common_Components/UX_Table/UX_Table.html')
    }
}();