// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
export let alert = function () {
    const { ref } = Vue
    return {
        /* 
        settings: {
            show: false,
            warningContent: "xxx",
            yesContent: "xxx",
            noContent: "xxx",
            hasYes: true,
            hasNo: true,
            level: 'warning'
        }
         */
        props: ['settings'],
        emits: ['option'],
        setup (props) {
            const imgPath = ref('');
            switch (props.settings.level) {
                case 'info':
                    imgPath.value = 'images/statusInformation_obj16.gif';
                    break;
                case 'warning':
                    imgPath.value = 'images/statusWarning_obj16.gif';
                    break;
                case 'error':
                    imgPath.value = 'images/statusCritical_obj16.gif';
                    break;
                default:
                    imgPath.value = 'images/statusWarning_obj16.gif';
                    break;
            }
            return {
                settings: props.settings,
                imgPath,
                tr
            }
        },
        template: readTextFile(appBasePath() + '/js/ext/Common_Components/Alert/Alert.html')
    }
}();