// Copyright © 2016 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Collect_Log = function () {
//TODO kill onecli failed?
    let vue_app = undefined;
    let uiStyle = Vue.reactive({
        isBMCLogShow: false,
        isFFDCShow: false,
        logFile: "",
        ffdcPath: "",
        isError: false
    });

    let multiTaskCfgFile = top.pathJoin(top.basePath(), "multi_task_config.json");

    const tableTitle = Vue.reactive({
        flag: "",
        description: ""
    });
    const tableData = Vue.reactive([]);

    async function writeConfigFile() {
        let batchFileData = {
            parallel_number: 50,
            parallel_order: 1,
            password_decrypt_mode: 1,
            bmc_credential: {},
            target_bmc: []
        };
        let index = 0;
        for (let item of Server_Pool.selectedServerList) {
            batchFileData.bmc_credential[item.userName] = item.userName;
            batchFileData.target_bmc.push(item.userName + "@" + item.ip);
            ++index;
        }
        top.writeTextFile(multiTaskCfgFile, JSON.stringify(batchFileData, "", 2));
    }

    async function runMultiCMD() {
        deleteFile(top.getSupportFile('multi_command_history'));
        let args = [];
        if (Collect_Log_Setting.collectSetting.isCollectBMCLog) {
            args = [
                top.getSystemFile("oneCli"),
                "multiinventory",
                "getinfor",
                "--device",
                "bmc_event_logs",
                "--htmlreport",
                "--pretty"
            ];
            if (Collect_Log_Setting.collectSetting.isCollectFFDC) {
                args.push("--ffdc");
            }
        } else if (Collect_Log_Setting.collectSetting.isCollectFFDC) {
            args = [
                top.getSystemFile("oneCli"),
                "multiffdc"
            ];
        }
        args.push(...["--configfile", multiTaskCfgFile, "--never-check-trust"]);
        args.push(...add_output_log5());

        printLog("INFO", "run command:" + getRunProgramCommend(args));
        let progress_timer = setInterval(showResultTable, 1000);
        let subProcess = await runProgram(args);
        showResultTable();
        clearInterval(progress_timer);

        // Copy result to target path
        let logsDir = "";
        try {
            let data = top.readTextFile(top.getSupportFile('multi_command_history'));
            let content = JSON.parse(data);
            let cmdHistory = content["History"];
            for (let i = 0; i < cmdHistory.length; ++i) {
                if (cmdHistory[i]["Process ID"] == subProcess.processId) {
                    logsDir = cmdHistory[i]["Saved Folder"];
                }
            }   
        } catch (error) {
            logsDir = "";
        }
        if (logsDir === "") {
            uiStyle.isError = true;
            uiStyle.ffdcPath = "";
            uiStyle.logFile = "";
            tableTitle.flag = "images/statusCritical_obj16.gif";
            tableTitle.description = tr("Command failed with OneCLI returned: ") + subProcess.errorCode + " - " + subProcess.stdout;
        } else {
            copyPathSync(logsDir, Collect_Log_Setting.collectSetting.outputDir, true);
            uiStyle.ffdcPath = Collect_Log_Setting.collectSetting.outputDir;
            uiStyle.logFile = top.pathJoin(uiStyle.ffdcPath, "index.html");
            tableTitle.flag = "images/statusSuccess_obj16.gif";
            tableTitle.description = tr("Done");
        }
        setLogFile(logsDir);
    }

    function showResultTable() {
        let result = [];
        let path = top.getMultiCmdOutputDir();
        if (path) {
            let progress = top.readTextFile(top.pathJoin(path, "multi_task_status.json"));
            if (progress) {
                let taskStatus = JSON.parse(progress);
                let serverStatus = taskStatus["result"][0]["servers"];
                for (let i = 0; i < serverStatus.length; ++i) {
                    let icon = "";
                    switch (serverStatus[i]["status"]) {
                        case "waiting":
                            icon = "images/statusStopped_obj16.gif";
                            break;
                        case "running":
                            icon = "images/progress_anim2_small.gif";
                            break;
                        case "success":
                            icon = "images/statusSuccess_obj16.gif";
                            break;
                        case "failure":
                            icon = "images/statusCritical_obj16.gif";
                            break;
                        default:
                            icon = "images/statusWarning_obj16.gif";
                            break;
                    }
                    result.push({
                        ip: serverStatus[i]["host"],
                        status: serverStatus[i]["status"],
                        statusIcon: icon,
                        errorCode: serverStatus[i]["error code"]
                    });
                }
            }
        }
        tableData.splice(0, tableData.length, ...result);
    }

    async function collect() {
        uiStyle.isBMCLogShow = false;
        uiStyle.isFFDCShow = false;
        toggleNext(false);
        togglePrevious(false);
        setLogFile("");
        tableTitle.flag = "images/progress_anim2_small.gif";
        tableTitle.description = tr("Collecting log...");
        tableData.length = 0;
        await writeConfigFile();
        await runMultiCMD();
        toggleNext(true);
        togglePrevious(true);
        uiStyle.isBMCLogShow = Collect_Log_Setting.collectSetting.isCollectBMCLog;
        uiStyle.isFFDCShow = Collect_Log_Setting.collectSetting.isCollectFFDC;
    }

    let vue_class = {
        data() {
            return {
                uiStyle,
                tableTitle,
                tableData
            };
        },
        methods: {
            tr: top.tr,
            collect: collect,
            viewLog(path) {
                printLog("INFO", "Attempt to open log locate in: " + path);
                if (!top.fileExists(path)) {
                    alert(tr("Unable to open the file/folder because it is not exist. Probably an error occurred while collecting. Check logs for further details."))
                    return false;
                }
                top.openExternal(path);
            }
        },
        directives: {
            focus: {
                mounted(el) {
                    el.focus();
                }
            }
        }
    };

    function init() {
        printLog("INFO", "TargetServer page init.");
        init_vue();
        uiStyle.isError = false;
        collect();
    };

    async function init_vue() {
        if (vue_app) {
            return;
        }
        vue_app = Vue.createApp(vue_class);
        vue_app.use(ElementPlus);
        vue_app.mount('#collect_log_vue');
    }

    function uninit() {
        if (!vue_app) {
            return;
        }
        vue_app.unmount();
        vue_app = undefined;
    }

    return {
        index: 0,
        name: "Collect_Log",
        init: init,
        nextAction() {return true},
        previousAction() {return true},
        importId: '#import_collect_log',
        selectorId: '.collect_log',
        title: "Collect Log",
        localizedTitle: tr("Collect Log"),
        uninit: uninit
    }
}();