// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

Bios_Mode_Select = (function () {
    let log = console.log;

    let vue_app = undefined;

    function init() {
        log("init bios mode select");
        init_vue();
    }

    let thisPage = Vue.reactive({
        allReady: false,
    });



    async function verify() {
        if (selectInfo.Type == "CommonMode") {
            return true;
        }
        let data = read_config_batch_file_sync('set', 'BIOS', selectInfo.fileName);
        if(null == data) {
            // show pop over
            alert(tr('Failed to import configuration batch file.'));
            return false;
        }
        Bios_Configure.BiosChangeData.length = 0;
        for(let item of data) {
            Bios_Configure.BiosChangeData.push(item);
        }
        return true;
    }

    function next() {
        if (thisPage.allReady) {
            return true;
        }
        verify()
            .then((ok) => {
                if (ok) {
                    thisPage.allReady = true;
                    gl_wizard.steps("next");
                }
            })
            .catch((msg) => {
            });
        return false;
    }

    function previous() {
        top.toggleNext(true);
        return true;
    }

    function init_vue() {
        if (vue_app != undefined) {
            return;
        }
        vue_app = Vue.createApp(vue_class);
        vue_app.use(ElementPlus);
        vue_app.mount("#bios_mode_select_vue");
    }

    function uninit() {
        if (vue_app != undefined) {
            vue_app.unmount();
            vue_app = undefined;
        }
    }

    let selectInfo = Vue.reactive({
        Type: "CommonMode",
        fileName: top.getSupportDir() + "config_batch.txt",
        typeChanged: function (val) {
            log(val);
            thisPage.allReady = false;
            if (val === "CommonMode") {
                thisPage.allReady = true;
                let pos = top.gl_steps_current.indexOf(Bios_Configure);
                if (pos < 0) {
                    pos = top.gl_steps_current.indexOf(Bios_Mode_Select);
                    top.gl_steps_current.splice(pos + 1, 0, Bios_Configure);
                }
                pos = top.gl_steps_current.indexOf(Bios_Export);
                if (pos < 0) {
                    pos = top.gl_steps_current.indexOf(Bios_Change_View);
                    top.gl_steps_current.splice(pos + 1, 0, Bios_Export);
                }
                top.configSteps(top.gl_steps_current);
            } else {
                let pos = top.gl_steps_current.indexOf(Bios_Configure);
                if (pos >= 0) {
                    top.gl_steps_current.splice(pos, 1);
                }
                pos = top.gl_steps_current.indexOf(Bios_Export);
                if (pos >= 0) {
                    top.gl_steps_current.splice(pos, 1);
                }
                top.configSteps(top.gl_steps_current);
            }
        },
        onBrowseFile: function () {
            printLog("INFO", "button 'Browse...' was clicked.");
            let _filterType = [{ name: 'Config batch Files', extensions: ['*'] }];
            let path = window.xpress.showOpenDialogFile(this.fileName,  _filterType);
            if (path && path[0]) {
                this.fileName = path[0];
            }
        }
    })

    let vue_class = {
        data() {
            return {
                selectInfo: selectInfo
            };
        },
        methods: {
            tr: top.tr
        },
        mounted() { },
        watch: {
            "selectInfo.Type":  {
                handler: selectInfo.typeChanged,
                immediate: true
            },
            "selectInfo.fileName": function() {
                thisPage.allReady = false;
            }
        },
        computed: {
        },
        directives: {
            focus: {
                mounted(el) {
                    el.focus();
                },
            },
        },
    };

    return {
        index: 0,
        name: "Bios_Mode_Select",
        init: init,
        nextAction: next,
        previousAction: previous,
        importId: "#import_bios_mode_select",
        selectorId: ".bios_mode_select_class",
        title: "BIOS Mode Select",
        localizedTitle: tr("BIOS Mode Select"),
        uninit: uninit,
        selectInfo: selectInfo
    };
})();
