// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.

Bios_Configure = (function () {
    let log = console.log;

    let vue_app = undefined;

    function init() {
        log("init bios configure");
        init_vue();
    }

    let thisPage = Vue.reactive({
        allReady: false
    });

    function fetchData() {
        biosChangeData.splice(0, biosChangeData.length);
        for (let i = 0; i < biosInfoList.length; i++) {
            let item1 = biosInfoList[i];
            let item2 = biosInfoListBack[i];
            if (item1.Edit) {
                let changeItem = {
                    HelpText: item1.HelpText,
                    DisplayName: item1.DisplayName,
                    AttributeName: item1.AttributeName,
                    OldValue: item2.Value,
                    Value: item1.Value,
                    Type: item1.Type
                };
                biosChangeData.push(changeItem);
            }
        }
    }

    function next() {
        if (thisPage.allReady) {
            fetchData();
            return true;
        }
        verify()
            .then((ok) => {
                if (ok) {
                    thisPage.allReady = true;
                    gl_wizard.steps("next");
                }
            })
            .catch((msg) => {
            });
        return false;
    }

    function previous() {
        top.toggleNext(true);
        return true;
    }

    async function init_vue() {
        bmcInfo.init();
        biosInfoList.splice(0, biosInfoList.length);
        biosInfoListBack.splice(0, biosInfoListBack.length);
        biosChangeData.splice(0, biosChangeData.length);
        tab.init();
        errorInfo.reset();
        for (let key in biosInfo) {
            delete biosInfo[key];
        }
        checkNextButton();
        if (vue_app != undefined) {
            let result = await acquireDataByOnecli();
            if (!result) {
                return;
            }
            let fileName = top.getSupportFile("bios_show_view_result");
            loadBios(fileName);
            filterByBlackList();
            groupBios();
        // loadDependencies();
            return;
        }
        for (let key in biosInfo) {
            delete biosInfo[key];
        }

        
        vue_app = Vue.createApp(vue_class);
        vue_app.use(ElementPlus);
        vue_app.mount("#bios_configure_vue");

        let result = await acquireDataByOnecli();
        if (!result) {
            return;
        }
        let fileName = top.getSupportFile("bios_show_view_result");
        loadBios(fileName);
        filterByBlackList();
        groupBios();
        // loadDependencies();
    }

    function uninit() {
        if (vue_app != undefined) {
            vue_app.unmount();
            vue_app = undefined;
        }
    }

    function showOnecliFailInfo(msg = tr("Execute onecli command fail."), stderr = "") {
        let commonResult = top.getSupportFile("commonResult");
        let xmlContent = top.readTextFile(commonResult);
        errorInfo.info = msg;
        if (!xmlContent) {
            errorInfo.info = msg;
            errorInfo.detail = stderr;
            return;
        }
        let comm_dom = ezJsLib.XmlDom.parse(xmlContent);
        if ("Yes" == ezJsLib.XmlDom.getValueByTagFromNode("ERROR", comm_dom.documentElement)) {
            errorInfo.detail = ezJsLib.XmlDom.getValueByTagFromNode("MESSAGE", comm_dom.documentElement);
            errorInfo.code = ezJsLib.XmlDom.getValueByTagFromNode("ERRORCODE", comm_dom.documentElement);
        }
    }

    let getConnectionInfo = function (ip, port, userName) {
        if (ip.includes(":")) {
            if (port && port != "") {
                return (userName + "@[" + ip + "]:" + port);
            } else {
                return (userName + "@[" + ip + "]");
            }
        } else {
            if (port && port != "") {
                return (userName + "@" + ip + ":" + port);
            } else {
                return (userName + "@" + ip);
            }
        }
    }
    async function verify() {
        log("verify connect clicked");
        errorInfo.reset();
        for (let item of biosInfoList) {
            if (item.Edit && item.error) {
                if (item.Type === "Password") {
                    warning.Info = tr("The value of '{0}' is out of range, please check it.", item.DisplayName);
                } else {
                    warning.Info = tr("The value of '{0}' = {1} is out of range, please check it.", item.DisplayName, item.Value);
                }                
                warning.Show = true;
                return false;
            }
        }
        return true;
    }

    function onVerifyConnect() {
        oneCli.isRunning = true;
        verifyConnect()
            .then((ok) => {
                oneCli.isRunning = false; oneCli.verifyOk = ok;
                oneCli.runInfo = "";
            })
            .catch((msg) => {
                oneCli.isRunning = false;
                errorInfo.info = msg;
                oneCli.runInfo = "";
            })
    }

    function checkNextButton() {
        top.toggleNext(tab.selectedCount > 0);
        return true;
    }

    function findPos(biosData, name) {
        for (let i = 0; i < biosData.length; i++) {
            let item = biosData[i];
            if (item.AttributeName === name) {
                return i;
            }
        }
        return -1;
    }

    function groupBios(file = "Bios_Config_Classification.json") {
        let root = top.loadSetting(file);
        for (let key in root) {
            let value = root[key];
            for (let item of value) {
                let pos = findPos(biosInfoList, item);
                if (pos >= 0) {
                    if (key in biosInfo) {
                        biosInfo[key].push(biosInfoList[pos])
                    } else {
                        biosInfo[key] = [biosInfoList[pos]];
                    }
                    biosInfoList[pos].group = key;
                }
            }
        }
        biosInfo["Other"] = [];
        for (let item of biosInfoList) {
            if (!item.group) {
                biosInfo["Other"].push(item);
            }
        }
    }

    function filterByBlackList(schemeFile = "BIOS_Blacklist.json") {
        let root = top.loadSetting(schemeFile);
        for (let item of root.Blacklist) {
            let pos = findPos(biosInfoList, item);
            if (pos >= 0) {
                tab.total--;
                biosInfoList.splice(pos, 1);
                log("filter item: ", item);
            }
            pos = findPos(biosInfoListBack, item);
            if (pos >= 0) {
                biosInfoListBack.splice(pos, 1);
            }
        }
    }

    function loadDependencies(schemeFile = "d:/tmp/bios-configure.json") {
        let data = top.readTextFile(schemeFile);
        let root = JSON.parse(data);
        let dataList = root["RegistryEntries"]["Dependencies"];
        for (let depItem of dataList) {
            if (depItem.DependencyFor === "SYSACS") {
                //ignore SYSACS dependency
                continue;
            }
            let pos = findPos(depItem.DependencyFor);
            if (depItem.Type == "Map") {
                
            } else {
                log("Unknow Type dependency:", depItem.Type);
            }
        }
    }

    async function acquireDataByOnecli() {
        let args = [
            top.getSystemFile("oneCli"),
            "config",
            "showvalues",
            "BIOS",
            "--bmc",
            getConnectionInfo(bmcInfo.ip, bmcInfo.port, bmcInfo.userName),
            "--never-check-trust",
            "--all",
            "-J",
            "--quiet",
            "--redfish",
            ...add_output_log5(),
        ];
        oneCli.isRunning = true;
        oneCli.runInfo = "Acquire BIOS schema...";
        let result = await oneCli.start(args);
        oneCli.isRunning = false;
        oneCli.runInfo = "";
        if (!result.success) {
            showOnecliFailInfo("Acquire BIOS scheme fail.", result.stderr);
            return false;
        }
        return result.success;        
    }
    function loadBios(schemeFile = "d:/tmp/bios-configure.json") {
        let data = top.readTextFile(schemeFile);
        let root = JSON.parse(data);
        let attributes = root["BIOS"];
        for (let item of attributes) {
            tab.total++;
            let nItem = {
                DisplayName: item["Display Name"],
                AttributeName: item["Attribute Name"],
                Value: item["Current Value"],
                Type: item.Type,
                ReadOnly: eval(item["Read Only"]),
                WriteOnly: eval(item["Write Only"]),
                HelpText: item["Help Text"],
                Edit: false,
                Min: eval(item["Lower Bound"]),
                Max: eval(item["Upper Bound"]),
                Step: eval(item["Scalar Increment"]),
                DefaultValue: item["Default Value"],
                MaxLength: eval(item["Max Length"]),
                MinLength: eval(item["Min Length"]),
                ValueExpression: item.ValueExpression,
                error: false,
                valueHelpInfo:"",
                ValueList: [],
                ResetRequired: item.ResetRequired,
                GrayOut: eval(item.GrayOut)
            }            
            if (nItem.Type == "Integer") {
                nItem.valueHelpInfo = "The value must between in [{0} - {1}]".format(nItem.Min, nItem.Max);
                nItem.DefaultValue = eval(nItem.DefaultValue);
                nItem.Value = eval(nItem.Value);
            } else if (nItem.Type == "Boolean") {
                nItem.DefaultValue = eval(nItem.DefaultValue);
                nItem.Value = eval(nItem.Value);
            } else if (nItem.Type === "String" || nItem.Type === "Password") {
                nItem.valueHelpInfo = tr("The length must between {0} and {1}", nItem.MinLength, nItem.MaxLength);
            }
            if (item["Valid Value"] instanceof Array) {
                for (let v of item["Valid Value"]) {
                    if (typeof(v) === 'string') {
                        nItem.ValueList.push({
                            ValueDisplayName: v,
                            ValueName: v
                        });                      
                    } else {
                        nItem.ValueList.push(v);
                    }
                }
            }
            biosInfoList.push(nItem);

            nItem2 = {
                AttributeName: nItem.AttributeName,
                Value: nItem.Value
            }
            biosInfoListBack.push(nItem2);
        }
    }

    function onValueChanged(val, item) {
        if (item.Type != "Password") {
            log("new value: ", val);
        }
        if (item.Type == "Integer") {
            if (val < item.Min || val > item.Max) {
                item.error = true;
            } else {
                item.error = false;
            }
        }
        if (item.Type == "Password" || item.Type == "String") {
            if (item.ValueExpression) {
                let reg = RegExp(item.ValueExpression);
                item.error = !reg.test(val);
            }
            if (val.length > item.MaxLength || val.length < item.MinLength) {
                item.error = true;
            }
        }
    }

    function onItemChanged(val) {
        log(val);
        if (val) {
            tab.selectedCount++;
        } else {
            tab.selectedCount--;
        }
    }

    let oneCli = Vue.reactive({
        isRunning: false,
        args: [],
        runInfo: "",
        Kill: function () {
            top.killOneCli();
        },
        start: async function (args) {
            deleteFile(top.getSupportFile("commonResult"));
            this.args = args;
            printLog("INFO", "run commend:" + getRunProgramCommend(args));
            return top.runProgram(args);
        }
    });

    let tab = Vue.reactive({
        activeTab: "",
        total:0,
        selectedCount: 0,
        init: function () {
            this.total = 0;
            this.selectedCount = 0;
        },
        onClick: function (val) {
            console.log(tab.activeTab);
        },
        onReset: function () {
            for (let i = 0; i < biosInfoList.length; i++) {
                biosInfoList[i].Value = biosInfoListBack[i].Value;
                biosInfoList[i].Edit = false;
                this.selectedCount = 0;
            }
        },
        onSelectedCountChanged: function (val) {
            checkNextButton();
        }
    });

    let errorInfo = Vue.reactive({
        info: "",
        code: 0,
        detail: "",
        reset: function () {
            this.info = "";
            this.code = 0;
            this.detail = "";
        }
    });

    let biosInfo = Vue.reactive({});

    let biosInfoList = Vue.reactive([]);

    let biosInfoListBack = Vue.reactive([]);

    let biosChangeData = Vue.reactive([]);

    let warning = Vue.reactive({
        Show: false,
        Info: ""
    });

    let bmcInfo = Vue.reactive({
        ip: "",
        userName: "",
        port: "",
        init: function () {
            if (Server_Pool && Server_Pool.selectedServerList) {
                if (Server_Pool.selectedServerList.length > 0) {
                    let item = Server_Pool.selectedServerList[0];
                    this.ip = item.ip;
                    this.userName = item.userName;
                    this.port = this.port;
                }
            }
        }
    });

    let vue_class = {
        data() {
            return {
                errorInfo: errorInfo,
                oneCli: oneCli,
                biosInfo: biosInfo,
                tab: tab,
                thisPage: thisPage,
                warning: warning,
                bmcInfo: bmcInfo
            };
        },
        methods: {
            tr: top.tr,
            onValueChanged: onValueChanged,
            onItemChanged: onItemChanged
        },
        mounted() { },
        watch: {
            "tab.selectedCount":tab.onSelectedCountChanged
        },
        computed: {
        },
        directives: {
            focus: {
                mounted(el) {
                    el.focus();
                },
            },
        },
    };

    return {
        index: 0,
        name: "Bios_Configure",
        init: init,
        nextAction: next,
        previousAction: previous,
        importId: "#import_bios_configure",
        selectorId: ".bios_configure_class",
        title: "BIOS Configure",
        localizedTitle: tr("BIOS Configure"),
        uninit: uninit,
        BiosChangeData: biosChangeData
    };
})();
