// Copyright © 2023 - present Lenovo.  All rights reserved.
// Confidential and Proprietary.
Bios_Export = function () {

    const { reactive, ref } = Vue

    const taskTool = TaskTool(true, 1);

    let biosExportApp = undefined;

    let items_to_be_set = new Array();

    let vue_obj = {
        setup () {
            const need_export = ref(false);

            let path = ref(top.getSupportDir() + "config_batch.txt");

            const open_working_dir = function (filename) {
                printLog("INFO", "button 'Browse...' was clicked.");
                let tmp = getFileParentdir(filename);
                if (undefined !== tmp) {
                    path.value = tmp;
                }
            }

            let export_status = reactive(new taskTool.TaskStatus(tr('Exporting file...'), tr('Export file.')));

            const checkDirPath = (path_str) => {
                if (path_str.endsWith("\\") || path_str.endsWith("/")) {
                    alert(tr("SEDManagement.NotAFilePath"));
                    return false;
                }
                let dir = top.dirname(path_str);
                let ret = validatePath(dir);
                if (ret != "success") {
                    if (ret == tr("Common.UnavailablePath")) {
                        if (confirm(tr("SEDManagement.DirectoryNotExist"))) {
                            createDirectory(dir);
                            if (!directoryExists(dir)) {
                                alert(tr("Common.CreatePathFailure"));
                                return false;
                            }
                        } else {
                            return false;
                        }
                    } else {
                        alert(ret);
                        return false;
                    }
                }
                if (top.fileExists(path_str)) {
                    if (!confirm(tr("SEDManagement.OverwriteFile", top.basename(path_str)))) {
                        return false;
                    }
                }
                return true;
            }

            const export_config_batch_file = function () {
                if (!checkDirPath(path.value)) {
                    return;
                }
                export_status.isRunning = true;
                export_status.isFinished = false;
                export_status.img = "images/progress_anim2_small.gif";
                if (write_config_batch_file_sync(items_to_be_set, "set", "BIOS.", path.value)) {
                    export_status.isFinished = true;
                    export_status.isFailed = false;
                    export_status.img = "images/statusSuccess_obj16.gif";
                } else {
                    export_status.isFinished = true;
                    export_status.isFailed = true;
                    export_status.img = "images/statusCritical_obj16.gif";
                }
            }

            return {
                clickable: taskTool.clickable,
                need_export,
                open_working_dir,
                export_config_batch_file,
                export_status,
                path,
                tr,
            }
        }
    }

    let init_vue = async function () {
        if (biosExportApp == undefined) {
            biosExportApp = Vue.createApp(vue_obj);
            const { taskStatus } = await import('../Common_Components/Task_Status/Task_Status.js');
            biosExportApp.component("taskstatus", taskStatus);
            biosExportApp.use(ElementPlus);
            biosExportApp.mount('#bios_export_vue');
        }
    }

    let uninit = function () {
        if (biosExportApp != null || biosExportApp != undefined) {
            biosExportApp.unmount();
            biosExportApp = undefined;
        }
    }

    let init = function () {
        printLog("DEBUG", "Init bios export app.");
        init_vue();
        items_to_be_set.length = 0;
        let temp = { ...Bios_Configure.BiosChangeData };
        Object.values(temp).forEach(e => {
            items_to_be_set.push({ ...e });
        })
        toggleNext(true);
        togglePrevious(true);
    }

    return {
        index: 0,
        name: "Bios_Export",
        init: init,
        uninit: uninit,
        nextAction: function () {
            return true;
        },
        previousAction: function () {
            return true;
        },
        importId: '#import_bios_export',
        selectorId: '.bios_export',
        title: "Navi.BIOSExport",
        localizedTitle: tr("Navi.BIOSExport"),
        needReInit: true
    }
}();